const {fail, VIRTUAL_SYMBOL_PREFIX} = require('../../lib/setup');
const {getSignatureSteps} = require('./allocationSignature');

exports.args = 1;
exports.host = 'allocation';
exports.description = 'Get address of an allocation account [argument: symbol]';

const addressReal = (ops, symbol) => {
  return [{symbol}, 'getAddress'];
}

const addressVirtual = (ops, symbol) => {
  return [
    ...getSignatureSteps(ops, this, 'addressAccount', [symbol]),
    ({accountID, signature}) => ({query: `/e/swap/allocation/account/address/${accountID}/${symbol}/${signature}`}), 'rout',
    result => { return (result === 'UNSET')?'[!] Virtual target address is not set! Please use method setAddress to set it.':result; }
  ]
}

exports.address = (ops) => (symbol) => {
  if (symbol.charAt(0)===VIRTUAL_SYMBOL_PREFIX) {
    return addressVirtual(ops, symbol);
  } else {
    return addressReal(ops, symbol);
  }
}
