const {fail, VIRTUAL_SYMBOL_PREFIX} = require('../../lib/setup');
const {getSignatureSteps} = require('./allocationSignature');

exports.args = 2;
exports.host = 'allocation';
exports.description = 'Set the virtual target address of an allocation account [argument: symbol]';

const addressVirtual = (ops, symbol, target) => {
  return [
    ...getSignatureSteps(ops, this, 'setAddressAccount', [symbol, target]),
    ({accountID, signature}) => ({query: `/e/swap/allocation/account/setAddress/${accountID}/${symbol}/${target}/${signature}`}), 'rout'
  ]
}

exports.addressSet = (ops) => (symbol, target) => {
  if (symbol.charAt(0)===VIRTUAL_SYMBOL_PREFIX) {
    return addressVirtual(ops, symbol, target);
  } else {
    return fail(`Only virtual assets can set a custom target address. Real assets have a deterministic address that cannot be changed.`);
  }
}
