const {fail, done, getLogin, VIRTUAL_SYMBOL_PREFIX} = require('../../lib/setup');

exports.args = 1;
exports.host = 'allocation';
exports.description = 'Accept a deal and send funds [argument: dealID]';

exports.accept = (ops) => (dealID) => [
  getLogin(ops, {...this, host: ''}), 'session',
  keys => ({
    id: [{data: 'account ' + keys.secretKey}, 'hash', hash => ({data: hash, source: 'hex', target: 'base58'}), 'code'],
    deal: [{query: '/e/swap/deal/status/' + dealID}, 'rout']
  }), 'parallel',
  proposal => {
    if (typeof proposal !== 'object' || proposal === null) {
      return fail(`Failed to process request to accept deal ${dealID}.`);
    } else if (typeof proposal.deal !== 'object' || proposal.deal === null) {
      return fail(`Deal ${dealID} could not be found.`);
    } else if (proposal.deal.status === 'open' && Number(proposal.deal.progress) === 0) { // claim
      const amount = proposal.deal.ask.amount;
      const target = proposal.deal.ask.target;
      const symbol = proposal.deal.ask.symbol;
      if (symbol.charAt(0)===VIRTUAL_SYMBOL_PREFIX) {
        const method = symbol.split('.')[0].substr(1).toUpperCase();
        const virtualSymbol = symbol.split(/\.(.*)/s)[1].toUpperCase();
        return done(`To accept deal ${dealID} please remit ${amount} ${virtualSymbol} by ${method} to: ${target}`);
      } else {
        return [
          {symbol, amount, target}, 'rawTransaction',
          rawTx => { return {query: '/e/swap/deal/remit/' + dealID + '/' + rawTx}; }, 'rout'
        ];
      }
    } else {
      return fail(`Deal ${dealID} has ${proposal.deal.status} status. Acceptance request denied.`);
    }
  },
  'sequential'
];
