const {done, getLogin, VIRTUAL_SYMBOL_PREFIX} = require('../../lib/setup');

exports.args = 3;
exports.host = 'allocation';
exports.description = 'Request and accept a swap deal [argument: base] [argument: symbol] [argument: target_amount]';

exports.swap = ops => (base, symbol, targetAmount) => [
  getLogin(ops, {...this, host: ''}), 'session',
  {symbol}, 'getAddress', // get primary allocation address
  target => ({query: '/e/swap/deal/proposal/' + base + '/' + symbol + '/' + targetAmount + '/' + target}), 'rout',
  proposal => {
    const dealID = proposal.id;
    const amount = proposal.ask.amount;
    const target = proposal.ask.target;
    const symbol = proposal.ask.symbol;
    if (symbol.charAt(0)===VIRTUAL_SYMBOL_PREFIX) {
      const method = symbol.split('.')[0].substr(1).toUpperCase();
      const virtualSymbol = symbol.split(/\.(.*)/s)[1].toUpperCase();
      return done(dealID + ` > Please remit ${amount} ${virtualSymbol} by ${method} to: ${target}`);
    } else {
      return [
        {symbol, amount, target}, 'rawTransaction',
        rawTx => { return {query: '/e/swap/deal/remit/' + dealID + '/' + rawTx}; }, 'rout',
        txID => { return dealID; }
      ];
    }
  }, 'sequential'
];
