/**
 * @memberof module:compressed-json.converters
 * @namespace stringConverter
 */
'use strict';

import Prefixes from '../constants/Prefixes';

var PrefixValues = Object.values(Prefixes);
/** @lends module:compressed-json.converters.stringConverter */

var stringConverter = {
  toPointer: function toPointer(index) {
    return Prefixes.POINTER_PREFIX + index.toString(36);
  },
  toEscaped: function toEscaped(raw) {
    var needsEscape = PrefixValues.some(function (v) {
      return raw.startsWith(v);
    });
    return needsEscape ? Prefixes.ESCAPED_PREFIX + raw : raw;
  },
  fromEscaped: function fromEscaped(escaped) {
    var needsRestore = escaped.startsWith(Prefixes.ESCAPED_PREFIX);
    return needsRestore ? escaped.slice(Prefixes.ESCAPED_PREFIX.length) : escaped;
  },
  fromPointer: function fromPointer(pointer) {
    return pointer.slice(Prefixes.POINTER_PREFIX.length);
  },
  isPointer: function isPointer(value) {
    return value.startsWith(Prefixes.POINTER_PREFIX);
  }
};

export default stringConverter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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