'use strict';

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

import stringConverter from './converters/stringConverter';

var RADIX = 36;
/**
 * @memberof module:compressed-json
 * @function decompress
 * @param {Object} compressed
 * @param {Object} [options={}] - Optional settings
 */

function decompress(compressed) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$reservedKeys = options.reservedKeys,
      reservedKeys = _options$reservedKeys === void 0 ? [] : _options$reservedKeys,
      _options$reservedValu = options.reservedValues,
      reservedValues = _options$reservedValu === void 0 ? [] : _options$reservedValu;

  if (!compressed) {
    return null;
  }

  var _compressed$K = compressed.K,
      K = _compressed$K === void 0 ? [] : _compressed$K,
      _compressed$P = compressed.P,
      P = _compressed$P === void 0 ? [] : _compressed$P,
      values = compressed._;
  var keys = [].concat(_toConsumableArray(reservedKeys), _toConsumableArray(K));
  var pointers = [].concat(_toConsumableArray(reservedValues), _toConsumableArray(P));

  var stringValueFor = function stringValueFor(value) {
    if (stringConverter.isPointer(value)) {
      var index = parseInt(stringConverter.fromPointer(value), RADIX);
      return pointers[index];
    }

    return stringConverter.fromEscaped(value);
  };

  var convert = function convert(values) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$keyPath = _ref.keyPath,
        keyPath = _ref$keyPath === void 0 ? '' : _ref$keyPath;

    if (Array.isArray(values)) {
      return values.map(function (v, i) {
        return convert(v, {
          keyPath: [keyPath, i].join('/')
        });
      });
    }

    if (values === null) {
      return null;
    }

    switch (_typeof(values)) {
      case 'undefined':
        {
          return;
        }

      case 'function':
        return null;

      case 'object':
        {
          var decompressed = {};
          var shortKeys = Object.keys(values);

          for (var _i = 0, _shortKeys = shortKeys; _i < _shortKeys.length; _i++) {
            var shortKey = _shortKeys[_i];
            var value = values[shortKey];
            var key = keys[parseInt(shortKey, RADIX)];
            decompressed[key] = convert(value, {
              keyPath: [keyPath, shortKey].join('/')
            });
          }

          return decompressed;
        }

      case 'string':
        return stringValueFor(values, keyPath);

      default:
        return values;
    }
  };

  return convert(values);
}

decompress.fromString = function decompressFromString(compressedString) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return decompress(JSON.parse(compressedString), options);
};

export default decompress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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