/**
 * @license
 * https://github.com/ealmansi/cashaddrjs
 * Copyright (c) 2017-2020 Emilio Almansi
 * Distributed under the MIT software license, see the accompanying
 * file LICENSE or http://www.opensource.org/licenses/mit-license.php.
 */

'use strict';

/**
 * Validation utility.
 *
 * @module validation
 */

/**
 * Error thrown when encoding or decoding fail due to invalid input.
 *
 * @constructor ValidationError
 * @param {string} message Error description.
 */
function ValidationError(message) {
  var error = new Error();
  this.name = error.name = 'ValidationError';
  this.message = error.message = message;
  this.stack = error.stack;
}

ValidationError.prototype = Object.create(Error.prototype);

/**
 * Validates a given condition, throwing a {@link ValidationError} if
 * the given condition does not hold.
 *
 * @static
 * @param {boolean} condition Condition to validate.
 * @param {string} message Error message in case the condition does not hold.
 */
function validate(condition, message) {
  if (!condition) {
    throw new ValidationError(message);
  }
}

module.exports = {
  ValidationError: ValidationError,
  validate: validate,
};
