exports.createLink = createLink;
exports.call = call;

let protocols = {};
protocols.http = require('./http');
protocols.tcp = require('./tcp');
protocols.ws = require('./websocket');

const ports = {
  tor: 9050,
  i2p: 4444,
  socks: 1080
}

for (const entry in ports) {
  for (const protocol of ['http','https','ws','wss','tcp','tcps']) {
    ports[`${entry}+${protocol}`] = ports[entry];
  }
}

exports.ports = ports;

const conf = require('../../conf/conf');
const { Client } = require('../rest');
const { SocksProxyAgent } = require('socks-proxy-agent');

function getProtocol(prefix) {
  let protocol = 'http';
  const secondary = prefix.split('+')[1];
  if (typeof secondary !== 'undefined') {
    if (secondary.substr(0,2) === 'ws') protocol = 'ws';
    else if(secondary.substr(0,3) === 'tcp') protocol = 'tcp';
  }
  return protocol;
}

function call (link, host, qpath, args, method, dataCallback, errorCallback) {
  const [prefix, hostNameAndPort] = host.split('://');
  let targetPrefix;
  switch (prefix.split('+')[1]) {
    case 'https':
      targetPrefix = 'https';
      break;
    case 'ws':
      targetPrefix = 'ws';
      break;
    case 'wss':
      targetPrefix = 'wss';
      break;
    case 'tcp':
      targetPrefix = 'tcp';
      break;
    case 'tcps':
      targetPrefix = 'tcps';
      break;
    case 'http':
    default:
      targetPrefix = 'http';
  }
  const targetHost = `${targetPrefix}://${hostNameAndPort}`;
  const type = getProtocol(prefix);
  protocols[type].call(link, targetHost, qpath, args, method, dataCallback, errorCallback);
}

function createLink (APIrequest, host, APIhosts, dataCallback, errorCallback) {
  const options = {};
  const [prefix, hostNameAndPort] = host.split('://');
  const proxyHostName = conf.get('socks.proxyhost');
  const proxyPort = conf.get('socks.proxyport', true) || ports[prefix.split('+')[0]]; // use silent for fallback
  const proxyUser = conf.get('socks.proxyuser', true) || undefined; // silent ignore unset configuration
  const proxyPass = conf.get('socks.proxypass', true) || undefined; // silent ignore unset configuration
  const socksConfig = {
    hostname: proxyHostName,
    port: proxyPort,
    userId: proxyUser,
    password: proxyPass
  };
  options.agent = new SocksProxyAgent(socksConfig);
  const type = getProtocol(prefix);
  protocols[type].createLink(APIrequest, host, APIhosts, dataCallback, errorCallback, options);
}
