// engine.js -> handle engine calls
//
// (c) 2018 Internet of Coins project - Joachim de Koning
//

const {getFreshOrCachedData, getFreshDataWithoutCaching} = require('../cache');
const conf = require('../../conf/conf');

function engineList () {
  return {
    error: 0,
    data: Object.keys(global.hybrixd.engine).sort()
  };
}

function process (request, xpath) {
  const hasNoArguments = xpath.length === 1;
  return hasNoArguments
    ? engineList()
    : getEngineData(request, xpath);
}

function getEngineData (request, xpath) {
  const engine = xpath[1];
  const engineExists = global.hybrixd.engine.hasOwnProperty(engine);
  if (engineExists) {
    if (!conf.get(engine + '.enabled')) return { error: 400, data: 'Engine "' + engine + '" not enabled.' };
    const recipe = global.hybrixd.engine[engine];
    const getFreshDataWithOrWithoutCaching = request.data ? getFreshDataWithoutCaching : getFreshOrCachedData;
    return getFreshDataWithOrWithoutCaching(recipe, request, xpath);
  } else return {error: 404, data: 'Engine "' + engine + '" not found!'};
}

exports.process = process;
