/**
   * Set timeout of current process.
   * @category Process
   * @param {Number} [millisecs] - Amount of milliseconds to wait. If not specified the timeout is unlimited, and only limited by the scheduler engine.
   * @param {Object} [data=data] - Set data variable as soon as the process times out.
   * @param {Object} [err=1] - Value to set the error flag to as soon as the process times out.
   * @example
   * time                      // return the current process timeout value
   * time -1                   // set 'unlimited' timeout (process is killed after one hour)
   * time 0                    // immediately timeout the process
   * time 1000                 // set timeout to one second
   * time 1000 "Time's up!" 0  // set timeout to one second, if exceeded set data to "Time's up!" and give no error
   */
exports.time = data => async function (p, millisecs, hookData, hookErr) {
  if (typeof millisecs !== 'undefined' && isNaN(millisecs)) p.fail('time: value specified must be a number (milliseconds)');
  else if (typeof millisecs === 'undefined') {
    return p.next( p.getTimeOut() );
  }
  /* TODO fix this
  if (typeof hookData !== 'undefined' || typeof hookErr !== 'undefined') {
    process.timeHook = {data: typeof hookData === 'undefined' ? global.hybrixd.proc[p.getProcessID()].data : hookData, err: (typeof hookErr === 'undefined' ? 1 : hookErr)};
  }
  */
  p.setTimeOut(millisecs);
  return p.next(data);
};

exports.tests = {
  time: [
    'done $OK',
    'time 1000 "$OK" 0',
    'wait 2000'
  ]
}
