const process = require('process');
process.once('message', async (message) => {
  const task = message.args && message.args[1] ? message.args[1] : '';
  const data = message.data;
  const parse = require('./parse');
  var result = null;
  var err = 0;
  if (task === 'parseData') {
    const source = message.args && message.args[2] ? message.args[2] : null;
    result = await parse.parseData(data, source);
  } else if (task === 'makeSymbolList') result = await parse.makeSymbolList(data);
  else err = 'spawnParse expects task! Should contain one of: parseData, makeSymbolList';
  if (!result) err = 'spawnParse encountered an error!';
  process.send({err,result});
});
