/**
  * Execute a javascript module function and return its result directly (used for serving content without progress through API).
  * Only if the script is run from a recipe with a Javascript module defined.
  * Note: This can only be defined as the first command in a Qrtz method!
  * @category Process
  * @param {String} name - Name of the function. Getting arguments inside the function is possible.
  * @example
  * serv myFunction
  *
  * module.js:
  * function myFunction(proc,data){
  *   const args = JSON.stringify(proc.command);
  *   proc.done(`hello world, with arguments: ${args}`);
  * }
**/

exports.serv = data => async function (p, name) {
  if (p.getStep() > 0) p.fail('serv: must be run as first Qrtz command');
  return;
}

exports.tests = {
  serv: [
    'done $OK'
  ]
}
