
// determine the fixed fee
function estimatePair (proc,data) {
  const action = proc.command[1];
  const subType = proc.command[2].split(':').pop();
  const symbol = proc.command[3];
  let pair;
  switch (action) {
    case 'withdraw':
    case 'transfer':
      pair = `${symbol}/_${subType}.${symbol}`;
      break;
    case 'deposit':
      pair = `_${subType}.${symbol}/${symbol}`;
      break;
    default:
      return proc.fail('estimatePair expecting action one of: deposit, withdraw, transfer');
  }
  return proc.done(pair);
}

// determine the fixed fee
function estimateFixedFee (proc,data) {
  let result = 0;
  const action = proc.command[1];
  const subType = proc.command[2].split(':').pop();
  for (bankingMethod of data) {
    if (bankingMethod.type === `hybrix:${subType}` &&
        bankingMethod.hasOwnProperty('fees') &&
        bankingMethod.fees.hasOwnProperty(action) &&
        bankingMethod.fees[action].hasOwnProperty('fixed') &&
        !isNaN(bankingMethod.fees[action].fixed)) {
      result = bankingMethod.fees[action].fixed;
      break;
    }
  }
  return proc.done(result);
}

// exports
exports.estimateFixedFee = estimateFixedFee;
exports.estimatePair = estimatePair;
