/*!
This file contains compressed source code from the hybrix project.
 http://hybrix.io
 http://internetofcoins.org
Please see the files at above mentioned sites for copyright/license information.
In any case where license information cannot be found, please take into account
the GPLv3 for this source code.
*/
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "../common/base-x.js":
/*!***************************!*\
  !*** ../common/base-x.js ***!
  \***************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("{// base-x encoding / decoding\n// Copyright (c) 2018 base-x contributors\n// Copyright (c) 2014-2018 The Bitcoin Core developers (base58.cpp)\n// Customization 2019: BASE256 conversion bug fixed by Agent725\n// Distributed under the MIT software license, see the accompanying\n// file LICENSE or http://www.opensource.org/licenses/mit-license.php.\n\nconst Buffer = (__webpack_require__(/*! safe-buffer */ \"../common/node_modules/safe-buffer/index.js\").Buffer)\n\nmodule.exports = function base (ALPHABET) {\n  if (ALPHABET.length > 255) throw new TypeError('Alphabet too long')\n\n  const BASE_MAP = new Uint8Array(256)\n  BASE_MAP.fill(255)\n\n  for (let i = 0; i < ALPHABET.length; i++) {\n    const x = ALPHABET.charAt(i)\n    const xc = x.charCodeAt(0)\n\n    if (BASE_MAP[xc] !== 255) throw new TypeError(x + ' is ambiguous')\n    BASE_MAP[xc] = i\n  }\n\n  const BASE = ALPHABET.length\n  const LEADER = ALPHABET.charAt(0)\n  const FACTOR = Math.log(BASE) / Math.log(256) // log(BASE) / log(256), rounded up\n  const iFACTOR = Math.log(256) / Math.log(BASE) // log(256) / log(BASE), rounded up\n\n  function encode (source) {\n    if (!Buffer.isBuffer(source)) throw new TypeError('Expected Buffer')\n    if (source.length === 0) return ''\n\n    // Skip & count leading zeroes.\n    let zeroes = 0\n    let length = 0\n    let pbegin = 0\n    const pend = source.length\n\n    while (pbegin !== pend && source[pbegin] === 0) {\n      pbegin++\n      zeroes++\n    }\n\n    // Allocate enough space in big-endian base58 representation.\n    const size = ((pend - pbegin) * iFACTOR + 1) >>> 0\n    const b58 = new Uint8Array(size)\n\n    // Process the bytes.\n    while (pbegin !== pend) {\n      let carry = source[pbegin]\n\n      // Apply \"b58 = b58 * 256 + ch\".\n      let i = 0\n      for (let it = size - 1; (carry !== 0 || i < length) && (it !== -1); it--, i++) {\n        carry += (256 * b58[it]) >>> 0\n        b58[it] = (carry % BASE) >>> 0\n        carry = (carry / BASE) >>> 0\n      }\n\n      if (carry !== 0) throw new Error('Non-zero carry')\n      length = i\n      pbegin++\n    }\n\n    // Skip leading zeroes in base58 result.\n    let it = size - length\n    while (it !== size && b58[it] === 0) {\n      it++\n    }\n\n    // Translate the result into a string.\n    let str = LEADER.repeat(zeroes)\n    for (; it < size; ++it) str += ALPHABET.charAt(b58[it])\n\n    return str\n  }\n\n  function decodeUnsafe (source) {\n    if (typeof source !== 'string') throw new TypeError('Expected String')\n    if (source.length === 0) return Buffer.alloc(0)\n\n    let psz = 0\n\n    // Skip leading spaces.\n    if (source[psz] === ' ') return\n\n    // Skip and count leading '1's.\n    let zeroes = 0\n    let length = 0\n    while (source[psz] === LEADER) {\n      zeroes++\n      psz++\n    }\n\n    // Allocate enough space in big-endian base256 representation.\n    const size = (((source.length - psz) * FACTOR) + 1) >>> 0 // log(58) / log(256), rounded up.\n    const b256 = new Uint8Array(size)\n\n    // Process the characters.\n    while (source[psz]) {\n      // Decode character\n      let carry = BASE_MAP[source.charCodeAt(psz)]\n\n      // Invalid character\n      if (carry === 255) return\n\n      let i = 0\n      for (let it = size - 1; (carry !== 0 || i < length) && (it !== -1); it--, i++) {\n        carry += (BASE * b256[it]) >>> 0\n        b256[it] = (carry % 256) >>> 0\n        carry = (carry / 256) >>> 0\n      }\n\n      if (carry !== 0) throw new Error('Non-zero carry')\n      length = i\n      psz++\n    }\n\n    // Skip trailing spaces.\n    if (source[psz] === ' ') return\n\n    // Skip leading zeroes in b256.\n    let it = size - length\n    while (it !== size && b256[it] === 0) {\n      it++\n    }\n\n    const vch = Buffer.allocUnsafe(zeroes + (size - it))\n    vch.fill(0x00, 0, zeroes)\n\n    let j = zeroes\n    while (it !== size) {\n      vch[j++] = b256[it++]\n    }\n\n    return vch\n  }\n\n  function decode (string) {\n    const buffer = decodeUnsafe(string)\n    if (buffer) return buffer\n\n    throw new Error('Non-base' + BASE + ' character')\n  }\n\n  return {\n    encode: encode,\n    decodeUnsafe: decodeUnsafe,\n    decode: decode\n  }\n}\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/base-x.js?\n}");

/***/ }),

/***/ "../common/basecode.js":
/*!*****************************!*\
  !*** ../common/basecode.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("{const basex = __webpack_require__(/*! ./base-x.js */ \"../common/base-x.js\");\nconst {Buffer} = __webpack_require__(/*! buffer */ \"buffer\");\n\n// replace multiple strings\n// example: replacebulk(\"testme\",['es','me'],['1','2']); => \"t1t2\"\nfunction replaceBulk (str, findArray, replaceArray) {\n  let i; let regex = []; let map = {};\n  for (i = 0; i < findArray.length; i++) {\n    regex.push(findArray[i].replace(/([-[\\]{}()*+?.\\\\^$|#,])/g, '\\\\$1'));\n    map[findArray[i]] = replaceArray[i];\n  }\n  regex = regex.join('|');\n  str = str.replace(new RegExp(regex, 'g'), function (matched) {\n    return map[matched];\n  });\n  return str;\n}\n\nfunction generateAsciiTable () {\n  let x = '';\n  for (let i = 0; i < 256; i++) { x = x + String.fromCharCode(i); }\n  return x;\n}\n\nconst asciiTable = generateAsciiTable();\n\nfunction getEncoding (code) {\n  switch (code) {\n    case 'cashaddr':\n      return 'qpzry9x8gf2tvdw0s3jn54khce6mua7l';\n    case 'base64':\n      return 'base64';\n    case 'base58':\n      return '123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz';\n    case 'hex':\n      return '0123456789abcdef';\n    case 'number':\n    case 'dec':\n      return '0123456789';\n    case 'oct':\n      return '01234567';\n    case 'bool':\n    case 'bin':\n      return '01';\n    case 'bech32':\n      return 'ABCDEFGHIJKLMNOPQRSTUVWXYZ234567';\n    case 'ascii':\n    case 'base256':\n      // DEPRECATED: return asciiTable; -> base-x contains a bug which makes it unable to handle 256 character alphabet\n    case 'string':\n    case 'utf-8':\n    default:\n      return 'string';\n  }\n}\n\nfunction cleanInput (code, input) {\n  switch (code) {\n    case 'base58':\n      return input.replace(/[^1-9A-HJ-NP-Za-km-z]/g, '');\n    case 'hex':\n      if (input.substring(0, 2) === '0x') { input = input.substring(2); }\n      return input.toLowerCase().replace(/[^0-9a-f]/g, '');\n    case 'number':\n    case 'dec':\n      return (typeof input === 'number') ? String(input) : input.replace(/[^0-9]/g, '');\n    case 'oct':\n      return input.replace(/[^0-7]/g, '');\n    case 'bool':\n      return input ? '1' : '0';\n    case 'bin':\n      return input.replace(/[^0-1]/g, '');\n    case 'bech32':\n    case 'RFC4648':\n      return replaceBulk(input.toUpperCase(), ['0', '1', '8', '9'], ['O', 'I', 'B', 'G']).replace(/[^A-Z2-7]/g, '');\n    default:\n      return input;\n  }\n}\n\nfunction recode (source, target, input) {\n  if (typeof target === 'undefined') { target = source; source = getEncoding('ascii'); }\n\n  const sourceEncoding = getEncoding(source);\n\n  input = cleanInput(source, input);\n  if (source === 'hex' && target === 'dec') input = input.replace(/^0+(?=\\d)/, ''); // in case of hexadecimal to decimal, remove leading zeroes\n  const buffer = Buffer.from(sourceEncoding === 'string' ? input : basex(sourceEncoding).decode(input));\n\n  const targetEncoding = getEncoding(target);\n\n  if (targetEncoding === 'string') {\n    return buffer.toString();\n  } else if (target === 'bool') {\n    return buffer.toString() !== '0';\n  } else if (target === 'number') {\n    return Number(Buffer.from(basex(targetEncoding).encode(buffer)));\n  } else if (target === 'base64') {\n    return buffer.toString('base64');\n  } else {\n    return Buffer.from(basex(targetEncoding).encode(buffer)).toString();\n  }\n}\n\nexports.recode = recode;\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/basecode.js?\n}");

/***/ }),

/***/ "../common/compress-unified-address.js":
/*!*********************************************!*\
  !*** ../common/compress-unified-address.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("{const zlib = __webpack_require__(/*! zlib */ \"zlib\");\nconst baseCode = __webpack_require__(/*! ./basecode */ \"../common/basecode.js\");\nconst ZLIB_COMPRESSION_LEVEL = 8;\nconst Buffer = (__webpack_require__(/*! buffer */ \"buffer\").Buffer);\n\n// keep only uniques\nconst uniq = function (ydata) {\n  const amount = 1;\n  let str;\n  if (typeof ydata === 'string') {\n    str = true;\n    ydata = ydata.split('');\n  }\n  const sorted = ydata.sort();\n  for (let i = 0; i < ydata.length; i++) {\n    let entries = 0;\n    for (let j = 0; j < ydata.length; j++) {\n      if (ydata[i] === sorted[j]) {\n        if (entries >= amount) {\n          ydata.splice(i, 1);\n        }\n        entries++;\n      }\n    }\n  }\n  if (str) {\n    ydata = ydata.join('');\n  }\n  return ydata;\n};\n\n// replace multiple strings\n// example: replacebulk(\"testme\",['es','me'],['1','2']); => \"t1t2\"\nfunction replaceBulk (str, findArray, replaceArray) {\n  let i; let regex = []; const map = {};\n  for (i = 0; i < findArray.length; i++) {\n    regex.push(findArray[i].replace(/([-[\\]{}()*+?.\\\\^$|#,])/g, '\\\\$1'));\n    map[findArray[i]] = replaceArray[i];\n  }\n  regex = regex.join('|');\n  str = str.replace(new RegExp(regex, 'g'), function (matched) {\n    return map[matched];\n  });\n  return str;\n}\n\n// example encoding string\n// const datastring = 'eth.hy:0xfd9eb537df909144f14084d75fa88142bc80eb57,tomo.hy:0xfd9eb537df909144f14084d75fa88142bc80eb57,xyz.hy:0xfd9eb4892b1n3a83ns82bs7281b73142bc80eb57';\n\nfunction encode (datastring) {\n  try {\n    // first gather all unique addresses\n    const addresses = uniq(datastring.split(',').map(val => { return val.split(':')[1]; }));\n    let suffix;\n    // version 0: legacy extended compressed format\n    let version = 0;\n    // version 1: if all addresses are the same and of type EVM, and all assets have the same suffix \n    if (addresses.length === 1 && addresses[0].startsWith('0x')) {\n      const suffixes = uniq(datastring.split(',').map(val => { return val.split(':')[0].split('.')[1]; }));\n      if (suffixes.length === 1) version = 1;\n      suffix = suffixes[0];\n    }\n    // encoding\n    let result = null;\n    switch (version) {\n      case 0:\n        const reference = addresses.map((val, idx) => { return String(idx); });\n        // now replace all addresses in string by reference to addresses in array\n        const pruned = replaceBulk(datastring, addresses, reference);\n        const reformatted = addresses.join(',') + '|' + pruned;\n        // encode\n        result = baseCode.recode('hex', 'base58', zlib.deflateSync(reformatted, {level: ZLIB_COMPRESSION_LEVEL}).toString('hex'));\n        break;\n      case 1:\n        const assets = uniq(datastring.split(',').map(val => { return val.split(':')[0].split('.')[0].toLowerCase(); })).join(',');\n        const pureHexAddress = addresses[0].substr(2);\n        // DEBUG: result = `${assets}:${suffix}:${pureHexAddress}`;\n        result = baseCode.recode('hex', 'base58', pureHexAddress) + baseCode.recode('ascii', 'base58', `${assets}:${suffix}:` );\n        break;\n    }\n    return `${version}${result}`;\n  } catch (e) {\n    return null;\n  }\n}\n\nfunction decode (datastring) {\n  const version = Number(datastring.substr(0, 1));\n  let result = null;\n  try {\n    switch (version) {\n      case 0:\n        // decompress\n        const decompressed = zlib.inflateSync(Buffer.from(baseCode.recode('base58', 'hex', datastring.substr(1)), 'hex')).toString();\n        // now reverse the operation... (we prefix reference numbers and addresses with semicolon to avoid replacing numbers in token names)\n        if (typeof decompressed === 'string') {\n          const parts = decompressed.split('|');\n          const prefixedAddresses = parts[0].split(',').map((val) => { return String(':' + val); });\n          const reference = prefixedAddresses.map((val, idx) => { return String(':' + idx); });\n          const pruned = parts[1];\n          // restore all addresses in string by reference to addresses in array\n          result = replaceBulk(pruned, reference, prefixedAddresses);\n        }\n        break;\n      case 1:\n        const inputString = datastring.substr(1);\n        // find the necessary decoding index\n        let addressDecoded, idx;\n        for (idx = 24; idx < 42; idx++) {\n          addressDecoded = baseCode.recode('base58', 'hex', inputString.substr(0,idx));\n          if (addressDecoded.length === 40) break;\n        }\n        const decoded = baseCode.recode('base58', 'ascii', inputString.substr(idx)) + addressDecoded;\n        if (decoded.split(':').length === 3) result = decoded.split(':')[0].split(',').map(val => { return `${val}.${decoded.split(':')[1]}:0x${decoded.split(':')[2]}`; }).join(',');\n        break;\n    }\n  } catch (e) {\n    result = null;\n  }\n  return result;\n}\n\nexports.encode = encode;\nexports.decode = decode;\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/compress-unified-address.js?\n}");

/***/ }),

/***/ "../common/crypto/decimal-light.js":
/*!*****************************************!*\
  !*** ../common/crypto/decimal-light.js ***!
  \*****************************************/
/***/ (function(module, exports, __webpack_require__) {

eval("{var __WEBPACK_AMD_DEFINE_RESULT__;/* decimal.js-light v2.2.3 https://github.com/MikeMcl/decimal.js-light/LICENCE */\n!function(r){\"use strict\";function e(r,e){var t,n,i,o,s,u,f,c,l=r.constructor,d=l.precision;if(!r.s||!e.s)return e.s||(e=new l(r)),E?h(e,d):e;if(f=r.d,c=e.d,s=r.e,i=e.e,f=f.slice(),o=s-i){for(0>o?(n=f,o=-o,u=c.length):(n=c,i=s,u=f.length),s=Math.ceil(d/y),u=s>u?s+1:u+1,o>u&&(o=u,n.length=1),n.reverse();o--;)n.push(0);n.reverse()}for(u=f.length,o=c.length,0>u-o&&(o=u,n=c,c=f,f=n),t=0;o;)t=(f[--o]=f[o]+c[o]+t)/q|0,f[o]%=q;for(t&&(f.unshift(t),++i),u=f.length;0==f[--u];)f.pop();return e.d=f,e.e=i,E?h(e,d):e}function t(r,e,t){if(r!==~~r||e>r||r>t)throw Error(x+r)}function n(r){var e,t,n,i=r.length-1,o=\"\",s=r[0];if(i>0){for(o+=s,e=1;i>e;e++)n=r[e]+\"\",t=y-n.length,t&&(o+=u(t)),o+=n;s=r[e],n=s+\"\",t=y-n.length,t&&(o+=u(t))}else if(0===s)return\"0\";for(;s%10===0;)s/=10;return o+s}function i(r,e){var t,i,s,u,f,c,l=0,d=0,a=r.constructor,g=a.precision;if(o(r)>16)throw Error(O+o(r));if(!r.s)return new a(v);for(null==e?(E=!1,c=g):c=e,f=new a(.03125);r.abs().gte(.1);)r=r.times(f),d+=5;for(i=Math.log(L(2,d))/Math.LN10*2+5|0,c+=i,t=s=u=new a(v),a.precision=c;;){if(s=h(s.times(r),c),t=t.times(++l),f=u.plus(P(s,t,c)),n(f.d).slice(0,c)===n(u.d).slice(0,c)){for(;d--;)u=h(u.times(u),c);return a.precision=g,null==e?(E=!0,h(u,g)):u}u=f}}function o(r){for(var e=r.e*y,t=r.d[0];t>=10;t/=10)e++;return e}function s(r,e,t){if(e>r.LN10.sd())throw E=!0,t&&(r.precision=t),Error(N+\"LN10 precision limit exceeded\");return h(new r(r.LN10),e)}function u(r){for(var e=\"\";r--;)e+=\"0\";return e}function f(r,e){var t,i,u,c,l,d,a,g,p,w=1,m=10,x=r,O=x.d,b=x.constructor,L=b.precision;if(x.s<1)throw Error(N+(x.s?\"NaN\":\"-Infinity\"));if(x.eq(v))return new b(0);if(null==e?(E=!1,g=L):g=e,x.eq(10))return null==e&&(E=!0),s(b,g);if(g+=m,b.precision=g,t=n(O),i=t.charAt(0),c=o(x),!(Math.abs(c)<15e14))return a=s(b,g+2,L).times(c+\"\"),x=f(new b(i+\".\"+t.slice(1)),g-m).plus(a),b.precision=L,null==e?(E=!0,h(x,L)):x;for(;7>i&&1!=i||1==i&&t.charAt(1)>3;)x=x.times(r),t=n(x.d),i=t.charAt(0),w++;for(c=o(x),i>1?(x=new b(\"0.\"+t),c++):x=new b(i+\".\"+t.slice(1)),d=l=x=P(x.minus(v),x.plus(v),g),p=h(x.times(x),g),u=3;;){if(l=h(l.times(p),g),a=d.plus(P(l,new b(u),g)),n(a.d).slice(0,g)===n(d.d).slice(0,g))return d=d.times(2),0!==c&&(d=d.plus(s(b,g+2,L).times(c+\"\"))),d=P(d,new b(w),g),b.precision=L,null==e?(E=!0,h(d,L)):d;d=a,u+=2}}function c(r,e){var t,n,i;for((t=e.indexOf(\".\"))>-1&&(e=e.replace(\".\",\"\")),(n=e.search(/e/i))>0?(0>t&&(t=n),t+=+e.slice(n+1),e=e.substring(0,n)):0>t&&(t=e.length),n=0;48===e.charCodeAt(n);)++n;for(i=e.length;48===e.charCodeAt(i-1);)--i;if(e=e.slice(n,i)){if(i-=n,t=t-n-1,r.e=b(t/y),r.d=[],n=(t+1)%y,0>t&&(n+=y),i>n){for(n&&r.d.push(+e.slice(0,n)),i-=y;i>n;)r.d.push(+e.slice(n,n+=y));e=e.slice(n),n=y-e.length}else n-=i;for(;n--;)e+=\"0\";if(r.d.push(+e),E&&(r.e>_||r.e<-_))throw Error(O+t)}else r.s=0,r.e=0,r.d=[0];return r}function h(r,e,t){var n,i,s,u,f,c,h,l,d=r.d;for(u=1,s=d[0];s>=10;s/=10)u++;if(n=e-u,0>n)n+=y,i=e,h=d[l=0];else{if(l=Math.ceil((n+1)/y),s=d.length,l>=s)return r;for(h=s=d[l],u=1;s>=10;s/=10)u++;n%=y,i=n-y+u}if(void 0!==t&&(s=L(10,u-i-1),f=h/s%10|0,c=0>e||void 0!==d[l+1]||h%s,c=4>t?(f||c)&&(0==t||t==(r.s<0?3:2)):f>5||5==f&&(4==t||c||6==t&&(n>0?i>0?h/L(10,u-i):0:d[l-1])%10&1||t==(r.s<0?8:7))),1>e||!d[0])return c?(s=o(r),d.length=1,e=e-s-1,d[0]=L(10,(y-e%y)%y),r.e=b(-e/y)||0):(d.length=1,d[0]=r.e=r.s=0),r;if(0==n?(d.length=l,s=1,l--):(d.length=l+1,s=L(10,y-n),d[l]=i>0?(h/L(10,u-i)%L(10,i)|0)*s:0),c)for(;;){if(0==l){(d[0]+=s)==q&&(d[0]=1,++r.e);break}if(d[l]+=s,d[l]!=q)break;d[l--]=0,s=1}for(n=d.length;0===d[--n];)d.pop();if(E&&(r.e>_||r.e<-_))throw Error(O+o(r));return r}function l(r,e){var t,n,i,o,s,u,f,c,l,d,a=r.constructor,g=a.precision;if(!r.s||!e.s)return e.s?e.s=-e.s:e=new a(r),E?h(e,g):e;if(f=r.d,d=e.d,n=e.e,c=r.e,f=f.slice(),s=c-n){for(l=0>s,l?(t=f,s=-s,u=d.length):(t=d,n=c,u=f.length),i=Math.max(Math.ceil(g/y),u)+2,s>i&&(s=i,t.length=1),t.reverse(),i=s;i--;)t.push(0);t.reverse()}else{for(i=f.length,u=d.length,l=u>i,l&&(u=i),i=0;u>i;i++)if(f[i]!=d[i]){l=f[i]<d[i];break}s=0}for(l&&(t=f,f=d,d=t,e.s=-e.s),u=f.length,i=d.length-u;i>0;--i)f[u++]=0;for(i=d.length;i>s;){if(f[--i]<d[i]){for(o=i;o&&0===f[--o];)f[o]=q-1;--f[o],f[i]+=q}f[i]-=d[i]}for(;0===f[--u];)f.pop();for(;0===f[0];f.shift())--n;return f[0]?(e.d=f,e.e=n,E?h(e,g):e):new a(0)}function d(r,e,t){var i,s=o(r),f=n(r.d),c=f.length;return e?(t&&(i=t-c)>0?f=f.charAt(0)+\".\"+f.slice(1)+u(i):c>1&&(f=f.charAt(0)+\".\"+f.slice(1)),f=f+(0>s?\"e\":\"e+\")+s):0>s?(f=\"0.\"+u(-s-1)+f,t&&(i=t-c)>0&&(f+=u(i))):s>=c?(f+=u(s+1-c),t&&(i=t-s-1)>0&&(f=f+\".\"+u(i))):((i=s+1)<c&&(f=f.slice(0,i)+\".\"+f.slice(i)),t&&(i=t-c)>0&&(s+1===c&&(f+=\".\"),f+=u(i))),r.s<0?\"-\"+f:f}function a(r,e){return r.length>e?(r.length=e,!0):void 0}function g(r){function e(r){var t=this;if(!(t instanceof e))return new e(r);if(t.constructor=e,r instanceof e)return t.s=r.s,t.e=r.e,void(t.d=(r=r.d)?r.slice():r);if(\"number\"==typeof r){if(0*r!==0)throw Error(x+r);if(r>0)t.s=1;else{if(!(0>r))return t.s=0,t.e=0,void(t.d=[0]);r=-r,t.s=-1}return r===~~r&&1e7>r?(t.e=0,void(t.d=[r])):c(t,r.toString())}if(\"string\"!=typeof r)throw Error(x+r);if(45===r.charCodeAt(0)?(r=r.slice(1),t.s=-1):t.s=1,!D.test(r))throw Error(x+r);c(t,r)}var t,n,i;if(e.prototype=A,e.ROUND_UP=0,e.ROUND_DOWN=1,e.ROUND_CEIL=2,e.ROUND_FLOOR=3,e.ROUND_HALF_UP=4,e.ROUND_HALF_DOWN=5,e.ROUND_HALF_EVEN=6,e.ROUND_HALF_CEIL=7,e.ROUND_HALF_FLOOR=8,e.clone=g,e.config=e.set=p,void 0===r&&(r={}),r)for(i=[\"precision\",\"rounding\",\"toExpNeg\",\"toExpPos\",\"LN10\"],t=0;t<i.length;)r.hasOwnProperty(n=i[t++])||(r[n]=this[n]);return e.config(r),e}function p(r){if(!r||\"object\"!=typeof r)throw Error(N+\"Object expected\");var e,t,n,i=[\"precision\",1,w,\"rounding\",0,8,\"toExpNeg\",-1/0,0,\"toExpPos\",0,1/0];for(e=0;e<i.length;e+=3)if(void 0!==(n=r[t=i[e]])){if(!(b(n)===n&&n>=i[e+1]&&n<=i[e+2]))throw Error(x+t+\": \"+n);this[t]=n}if(void 0!==(n=r[t=\"LN10\"])){if(n!=Math.LN10)throw Error(x+t+\": \"+n);this[t]=new this(n)}return this}var v,w=1e9,m={precision:20,rounding:4,toExpNeg:-7,toExpPos:21,LN10:\"2.302585092994045684017991454684364207601101488628772976033327900967572609677352480235997205089598298341967784042286\"},E=!0,N=\"[DecimalError] \",x=N+\"Invalid argument: \",O=N+\"Exponent out of range: \",b=Math.floor,L=Math.pow,D=/^(\\d+(\\.\\d*)?|\\.\\d+)(e[+-]?\\d+)?$/i,q=1e7,y=7,M=9007199254740991,_=b(M/y),A={};A.absoluteValue=A.abs=function(){var r=new this.constructor(this);return r.s&&(r.s=1),r},A.comparedTo=A.cmp=function(r){var e,t,n,i,o=this;if(r=new o.constructor(r),o.s!==r.s)return o.s||-r.s;if(o.e!==r.e)return o.e>r.e^o.s<0?1:-1;for(n=o.d.length,i=r.d.length,e=0,t=i>n?n:i;t>e;++e)if(o.d[e]!==r.d[e])return o.d[e]>r.d[e]^o.s<0?1:-1;return n===i?0:n>i^o.s<0?1:-1},A.decimalPlaces=A.dp=function(){var r=this,e=r.d.length-1,t=(e-r.e)*y;if(e=r.d[e])for(;e%10==0;e/=10)t--;return 0>t?0:t},A.dividedBy=A.div=function(r){return P(this,new this.constructor(r))},A.dividedToIntegerBy=A.idiv=function(r){var e=this,t=e.constructor;return h(P(e,new t(r),0,1),t.precision)},A.equals=A.eq=function(r){return!this.cmp(r)},A.exponent=function(){return o(this)},A.greaterThan=A.gt=function(r){return this.cmp(r)>0},A.greaterThanOrEqualTo=A.gte=function(r){return this.cmp(r)>=0},A.isInteger=A.isint=function(){return this.e>this.d.length-2},A.isNegative=A.isneg=function(){return this.s<0},A.isPositive=A.ispos=function(){return this.s>0},A.isZero=function(){return 0===this.s},A.lessThan=A.lt=function(r){return this.cmp(r)<0},A.lessThanOrEqualTo=A.lte=function(r){return this.cmp(r)<1},A.logarithm=A.log=function(r){var e,t=this,n=t.constructor,i=n.precision,o=i+5;if(void 0===r)r=new n(10);else if(r=new n(r),r.s<1||r.eq(v))throw Error(N+\"NaN\");if(t.s<1)throw Error(N+(t.s?\"NaN\":\"-Infinity\"));return t.eq(v)?new n(0):(E=!1,e=P(f(t,o),f(r,o),o),E=!0,h(e,i))},A.minus=A.sub=function(r){var t=this;return r=new t.constructor(r),t.s==r.s?l(t,r):e(t,(r.s=-r.s,r))},A.modulo=A.mod=function(r){var e,t=this,n=t.constructor,i=n.precision;if(r=new n(r),!r.s)throw Error(N+\"NaN\");return t.s?(E=!1,e=P(t,r,0,1).times(r),E=!0,t.minus(e)):h(new n(t),i)},A.naturalExponential=A.exp=function(){return i(this)},A.naturalLogarithm=A.ln=function(){return f(this)},A.negated=A.neg=function(){var r=new this.constructor(this);return r.s=-r.s||0,r},A.plus=A.add=function(r){var t=this;return r=new t.constructor(r),t.s==r.s?e(t,r):l(t,(r.s=-r.s,r))},A.precision=A.sd=function(r){var e,t,n,i=this;if(void 0!==r&&r!==!!r&&1!==r&&0!==r)throw Error(x+r);if(e=o(i)+1,n=i.d.length-1,t=n*y+1,n=i.d[n]){for(;n%10==0;n/=10)t--;for(n=i.d[0];n>=10;n/=10)t++}return r&&e>t?e:t},A.squareRoot=A.sqrt=function(){var r,e,t,i,s,u,f,c=this,l=c.constructor;if(c.s<1){if(!c.s)return new l(0);throw Error(N+\"NaN\")}for(r=o(c),E=!1,s=Math.sqrt(+c),0==s||s==1/0?(e=n(c.d),(e.length+r)%2==0&&(e+=\"0\"),s=Math.sqrt(e),r=b((r+1)/2)-(0>r||r%2),s==1/0?e=\"1e\"+r:(e=s.toExponential(),e=e.slice(0,e.indexOf(\"e\")+1)+r),i=new l(e)):i=new l(s.toString()),t=l.precision,s=f=t+3;;)if(u=i,i=u.plus(P(c,u,f+2)).times(.5),n(u.d).slice(0,f)===(e=n(i.d)).slice(0,f)){if(e=e.slice(f-3,f+1),s==f&&\"4999\"==e){if(h(u,t+1,0),u.times(u).eq(c)){i=u;break}}else if(\"9999\"!=e)break;f+=4}return E=!0,h(i,t)},A.times=A.mul=function(r){var e,t,n,i,o,s,u,f,c,l=this,d=l.constructor,a=l.d,g=(r=new d(r)).d;if(!l.s||!r.s)return new d(0);for(r.s*=l.s,t=l.e+r.e,f=a.length,c=g.length,c>f&&(o=a,a=g,g=o,s=f,f=c,c=s),o=[],s=f+c,n=s;n--;)o.push(0);for(n=c;--n>=0;){for(e=0,i=f+n;i>n;)u=o[i]+g[n]*a[i-n-1]+e,o[i--]=u%q|0,e=u/q|0;o[i]=(o[i]+e)%q|0}for(;!o[--s];)o.pop();return e?++t:o.shift(),r.d=o,r.e=t,E?h(r,d.precision):r},A.toDecimalPlaces=A.todp=function(r,e){var n=this,i=n.constructor;return n=new i(n),void 0===r?n:(t(r,0,w),void 0===e?e=i.rounding:t(e,0,8),h(n,r+o(n)+1,e))},A.toExponential=function(r,e){var n,i=this,o=i.constructor;return void 0===r?n=d(i,!0):(t(r,0,w),void 0===e?e=o.rounding:t(e,0,8),i=h(new o(i),r+1,e),n=d(i,!0,r+1)),n},A.toFixed=function(r,e){var n,i,s=this,u=s.constructor;return void 0===r?d(s):(t(r,0,w),void 0===e?e=u.rounding:t(e,0,8),i=h(new u(s),r+o(s)+1,e),n=d(i.abs(),!1,r+o(i)+1),s.isneg()&&!s.isZero()?\"-\"+n:n)},A.toInteger=A.toint=function(){var r=this,e=r.constructor;return h(new e(r),o(r)+1,e.rounding)},A.toNumber=function(){return+this},A.toPower=A.pow=function(r){var e,t,n,o,s,u,c=this,l=c.constructor,d=12,g=+(r=new l(r));if(!r.s)return new l(v);if(c=new l(c),!c.s){if(r.s<1)throw Error(N+\"Infinity\");return c}if(c.eq(v))return c;if(n=l.precision,r.eq(v))return h(c,n);if(e=r.e,t=r.d.length-1,u=e>=t,s=c.s,u){if((t=0>g?-g:g)<=M){for(o=new l(v),e=Math.ceil(n/y+4),E=!1;t%2&&(o=o.times(c),a(o.d,e)),t=b(t/2),0!==t;)c=c.times(c),a(c.d,e);return E=!0,r.s<0?new l(v).div(o):h(o,n)}}else if(0>s)throw Error(N+\"NaN\");return s=0>s&&1&r.d[Math.max(e,t)]?-1:1,c.s=1,E=!1,o=r.times(f(c,n+d)),E=!0,o=i(o),o.s=s,o},A.toPrecision=function(r,e){var n,i,s=this,u=s.constructor;return void 0===r?(n=o(s),i=d(s,n<=u.toExpNeg||n>=u.toExpPos)):(t(r,1,w),void 0===e?e=u.rounding:t(e,0,8),s=h(new u(s),r,e),n=o(s),i=d(s,n>=r||n<=u.toExpNeg,r)),i},A.toSignificantDigits=A.tosd=function(r,e){var n=this,i=n.constructor;return void 0===r?(r=i.precision,e=i.rounding):(t(r,1,w),void 0===e?e=i.rounding:t(e,0,8)),h(new i(n),r,e)},A.toString=A.valueOf=A.val=A.toJSON=function(){var r=this,e=o(r),t=r.constructor;return d(r,e<=t.toExpNeg||e>=t.toExpPos)};var P=function(){function r(r,e){var t,n=0,i=r.length;for(r=r.slice();i--;)t=r[i]*e+n,r[i]=t%q|0,n=t/q|0;return n&&r.unshift(n),r}function e(r,e,t,n){var i,o;if(t!=n)o=t>n?1:-1;else for(i=o=0;t>i;i++)if(r[i]!=e[i]){o=r[i]>e[i]?1:-1;break}return o}function t(r,e,t){for(var n=0;t--;)r[t]-=n,n=r[t]<e[t]?1:0,r[t]=n*q+r[t]-e[t];for(;!r[0]&&r.length>1;)r.shift()}return function(n,i,s,u){var f,c,l,d,a,g,p,v,w,m,E,x,O,b,L,D,M,_,A=n.constructor,P=n.s==i.s?1:-1,R=n.d,U=i.d;if(!n.s)return new A(n);if(!i.s)throw Error(N+\"Division by zero\");for(c=n.e-i.e,M=U.length,L=R.length,p=new A(P),v=p.d=[],l=0;U[l]==(R[l]||0);)++l;if(U[l]>(R[l]||0)&&--c,x=null==s?s=A.precision:u?s+(o(n)-o(i))+1:s,0>x)return new A(0);if(x=x/y+2|0,l=0,1==M)for(d=0,U=U[0],x++;(L>l||d)&&x--;l++)O=d*q+(R[l]||0),v[l]=O/U|0,d=O%U|0;else{for(d=q/(U[0]+1)|0,d>1&&(U=r(U,d),R=r(R,d),M=U.length,L=R.length),b=M,w=R.slice(0,M),m=w.length;M>m;)w[m++]=0;_=U.slice(),_.unshift(0),D=U[0],U[1]>=q/2&&++D;do d=0,f=e(U,w,M,m),0>f?(E=w[0],M!=m&&(E=E*q+(w[1]||0)),d=E/D|0,d>1?(d>=q&&(d=q-1),a=r(U,d),g=a.length,m=w.length,f=e(a,w,g,m),1==f&&(d--,t(a,g>M?_:U,g))):(0==d&&(f=d=1),a=U.slice()),g=a.length,m>g&&a.unshift(0),t(w,a,m),-1==f&&(m=w.length,f=e(U,w,M,m),1>f&&(d++,t(w,m>M?_:U,m))),m=w.length):0===f&&(d++,w=[0]),v[l++]=d,f&&w[0]?w[m++]=R[b]||0:(w=[R[b]],m=1);while((b++<L||void 0!==w[0])&&x--)}return v[0]||v.shift(),p.e=c,h(p,u?s+o(p)+1:s)}}();m=g(m),v=new m(1), true?!(__WEBPACK_AMD_DEFINE_RESULT__ = (function(){return m}).call(exports, __webpack_require__, exports, module),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this);\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/decimal-light.js?\n}");

/***/ }),

/***/ "../common/crypto/hashDJB2.js":
/*!************************************!*\
  !*** ../common/crypto/hashDJB2.js ***!
  \************************************/
/***/ ((module) => {

eval("{var DJB2 = {\n  hash: function (str) {\n    var hash = 0, i, l, char;\n    if (str === 0) return hash;\n    for (i = 0, l = str.length; i < l; i++) {\n      char = str.charCodeAt(i);\n      hash = ((hash << 5) - hash) + char;\n      hash |= 0; // Convert to 32bit integer\n    }\n\n    hash &= 0xFFFFFFFF;\n    var hex = hash.toString(16).toUpperCase();\n    return ('00000000' + hex).slice(-8).replace('-', '0');\n  }\n};\n\nmodule.exports = DJB2;\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/hashDJB2.js?\n}");

/***/ }),

/***/ "../common/crypto/hex2base32.js":
/*!**************************************!*\
  !*** ../common/crypto/hex2base32.js ***!
  \**************************************/
/***/ ((module) => {

eval("{var bitprt;\n\nfunction hexToBase32 (inputval) {\n  // define rfc4648 alphabet array (32 bits)\n  var RFC4648 = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'];\n\n  // clean input value to accept only valid hex strings\n  var inputstr = inputval.toString();\n  inputstr = inputstr.toUpperCase();\n  inputstr = inputstr.replace(/[^A-F0-9]/g, '');\n\n  var bitstr = '';\n  // create string of bits out of hexstring\n  for (var cnt = 0; cnt < inputstr.length; cnt++) {\n    var bitint = parseInt(inputstr[cnt], 16);\n\n    // DEBUG console.log(bitint+'/'+bitint.toString(2));\n\n    // hex values must be zero padded to four bits each\n    bitprt = bitint.toString(2);\n\n    // first check whether bitstr length is 4 and prefix zero's if not\n    var addzeros = 4 - bitprt.length;\n\n    for (var dnt = 0; dnt < addzeros; dnt++) {\n      bitprt = '0' + bitprt;\n    }\n\n    bitstr = bitstr + bitprt;\n  }\n\n  // convert bitstr to rfc4648 per 5 bits\n\n  // first check whether bitstr length is multiple of 5 and prefix zero's if not\n  var remainder = bitstr.length % 5;\n  var addzeros = 5 - remainder;\n\n  // do not add five zero's padding\n  if (addzeros == 5) { addzeros = 0; }\n\n  for (var cnt = 0; cnt < addzeros; cnt++) {\n    bitstr = '0' + bitstr;\n  }\n\n  // DEBUG console.log( bitstr+'/'+bitstr.length+'/'+remainder );\n\n  // process bitstring per five bits\n  var startpos = 0;\n  var endpos = 5;\n  var base32str = '';\n\n  for (var cnt = 0; cnt < (bitstr.length / 5); cnt++) {\n    var bitpart = bitstr.substring(startpos + (cnt * 5), endpos + (cnt * 5));\n    base32str += RFC4648[parseInt(bitpart, 2)];\n    // DEBUG console.log( RFC4648[parseInt(bitpart,2)]+'/'+bitpart );\n  }\n\n  return base32str;\n}\n\nfunction base32ToHex (inputval) {\n  // define rfc4648 alphabet array (32 bits)\n  var RFC4648 = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7'];\n  var HEX = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' ];\n\n  // clean input value to accept only valid rfc4648\n  var inputstr = inputval.toString();\n  inputstr = inputstr.toUpperCase();\n  inputstr = inputstr.replace(/[^A-Z2-7]/g, '');\n\n  var bitstr = '';\n\n  // create string of bits out of rfc4648 string\n  for (var cnt = 0; cnt < inputstr.length; cnt++) {\n    var bitint = RFC4648.indexOf(inputstr[cnt]);\n    var bitbit = bitint.toString(2);\n\n    // add leading zeros to five bit length\n    var remainder = 5 - bitbit.length;\n\n    for (var dnt = 0; dnt < remainder; dnt++) {\n      bitbit = '0' + bitbit;\n    }\n\n    // DEBUG console.log(bitint+'/'+bitbit);\n\n    bitstr = bitstr + bitbit;\n  } // end of bitstring creation\n\n  // DEBUG console.log(\"before zero-remove:\"+bitstr);\n\n  // first check whether bitstr length is multiple of 4 and remove prefixed zero's if not\n  var remainder = bitstr.length % 4;\n  var remzeros = 4 - remainder;\n\n  // do not remove if remzeros is four\n  if (remzeros == 4) { remzeros = 0; }\n\n  // remove prefixed zeros\n  for (var cnt = 0; cnt < remzeros; cnt++) {\n    if (bitstr.startsWith('0')) {\n      bitstr = bitstr.substring(1);\n    }\n  }\n\n  // DEBUG console.log(\"after zero-remove:\"+bitstr);\n\n  // process bitstring per four bits\n  var startpos = 0;\n  var endpos = 4;\n  var hexstr = '';\n\n  for (var cnt = 0; cnt < (bitstr.length / 4); cnt++) {\n    var bitpart = bitstr.substring(startpos + (cnt * 4), endpos + (cnt * 4));\n    var hexint = parseInt(bitpart, 2);\n    // DEBUG console.log( hexint );\n\n    // convert to hex\n    hexstr = hexstr + HEX[hexint];\n\n    // DEBUG console.log( hexstr+'/'+bitpart );\n  }\n\n  return hexstr;\n}\n\nmodule.exports = {\n  hexToBase32,\n  base32ToHex\n};\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/hex2base32.js?\n}");

/***/ }),

/***/ "../common/crypto/hex2dec.js":
/*!***********************************!*\
  !*** ../common/crypto/hex2dec.js ***!
  \***********************************/
/***/ ((module, exports, __webpack_require__) => {

eval("{var __WEBPACK_AMD_DEFINE_RESULT__;// very large Hexadecimal to Decimal number converter\nvar Decimal = __webpack_require__(/*! ./decimal-light */ \"../common/crypto/decimal-light.js\");\nDecimal.set({precision: 64});\n\nvar hex2dec = (function () {\n  /**\n   * A function for converting hex <-> dec w/o loss of precision.\n   *\n   * The problem is that parseInt(\"0x12345...\") isn't precise enough to convert\n   * 64-bit integers correctly.\n   *\n   * Internally, this uses arrays to encode decimal digits starting with the least\n   * significant:\n   * 8 = [8]\n   * 16 = [6, 1]\n   * 1024 = [4, 2, 0, 1]\n   */\n\n  // Adds two arrays for the given base (10 or 16), returning the result.\n  // This turns out to be the only \"primitive\" operation we need.\n  function add (x, y, base) {\n    var z = [];\n    var n = Math.max(x.length, y.length);\n    var carry = 0;\n    var i = 0;\n    while (i < n || carry) {\n      var xi = i < x.length ? x[i] : 0;\n      var yi = i < y.length ? y[i] : 0;\n      var zi = carry + xi + yi;\n      z.push(zi % base);\n      carry = Math.floor(zi / base);\n      i++;\n    }\n    return z;\n  }\n\n  // Returns a*x, where x is an array of decimal digits and a is an ordinary\n  // JavaScript number. base is the number base of the array x.\n  function multiplyByNumber (num, x, base) {\n    if (num < 0) return null;\n    if (num == 0) return [];\n\n    var result = [];\n    var power = x;\n    while (true) {\n      if (num & 1) {\n        result = add(result, power, base);\n      }\n      num = num >> 1;\n      if (num === 0) break;\n      power = add(power, power, base);\n    }\n\n    return result;\n  }\n\n  function parseToDigitsArray (str, base) {\n    var digits = str.split('');\n    var ary = [];\n    for (var i = digits.length - 1; i >= 0; i--) {\n      var n = parseInt(digits[i], base);\n      if (isNaN(n)) return null;\n      ary.push(n);\n    }\n    return ary;\n  }\n\n  function convertBase (str, fromBase, toBase) {\n    var digits = parseToDigitsArray(str, fromBase);\n    if (digits === null) return null;\n\n    var outArray = [];\n    var power = [1];\n    for (var i = 0; i < digits.length; i++) {\n      // invariant: at this point, fromBase^i = power\n      if (digits[i]) {\n        outArray = add(outArray, multiplyByNumber(digits[i], power, toBase), toBase);\n      }\n      power = multiplyByNumber(fromBase, power, toBase);\n    }\n\n    var out = '';\n    for (var i = outArray.length - 1; i >= 0; i--) {\n      out += outArray[i].toString(toBase);\n    }\n    return out;\n  }\n\n  var hex2dec = {\n\n    /* lHexToDec : function (s) {   // DEPRECATED\n      dec = new Decimal(0);\n      s.split('').forEach(function(chr) {\n          var n = parseInt(chr, 16);\n          for(var t = 8; t; t >>= 1) {\n              dec = dec.plus(dec);\n              if(n & t) dec = dec.plus(1);\n          }\n      });\n      return dec;\n    }, */\n\n    toHex: function (decStr) {\n      var hex = convertBase(String(decStr), 10, 16);\n      return hex ? '0x' + hex : null;\n    },\n\n    toDec: function (hexStr) {\n      if (!hexStr) {\n        var result = 0;\n      } else {\n        if (hexStr.substring(0, 2) === '0x') hexStr = hexStr.substring(2);\n        hexStr = hexStr.toLowerCase();\n        var result = convertBase(hexStr, 16, 10);\n      }\n      return new Decimal((result || 0));\n    }\n\n  };\n\n  return hex2dec;\n})();\n\nif (true) {\n  !(__WEBPACK_AMD_DEFINE_RESULT__ = (function () { return hex2dec; }).call(exports, __webpack_require__, exports, module),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));\n} else // removed by dead control flow\n{}\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/hex2dec.js?\n}");

/***/ }),

/***/ "../common/crypto/lz-string.js":
/*!*************************************!*\
  !*** ../common/crypto/lz-string.js ***!
  \*************************************/
/***/ ((module) => {

eval("{// Copyright (c) 2013 Pieroxy <pieroxy@pieroxy.net>\n// This work is free. You can redistribute it and/or modify it\n// under the terms of the WTFPL, Version 2\n// For more information see LICENSE.txt or http://www.wtfpl.net/\n//\n// For more information, the home page:\n// http://pieroxy.net/blog/pages/lz-string/testing.html\n//\n// LZ-based compression algorithm, version 1.4.4\n//\n// Patched by Agent725 for the Internet of Coins project\n//\n// private property\nvar f = String.fromCharCode;\nvar keyStrBase64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_='; // patched (URL SAFE)\n// var keyStrBase64 = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\"; // NOT URL SAFE, SO DISABLED\nvar keyStrUriSafe = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$'; // NOT URL SAFE! DO NOT USE IN URL!\nvar baseReverseDic = {};\n\nfunction getBaseValue (alphabet, character) {\n  if (!baseReverseDic[alphabet]) {\n    baseReverseDic[alphabet] = {};\n    for (var i = 0; i < alphabet.length; i++) {\n      baseReverseDic[alphabet][alphabet.charAt(i)] = i;\n    }\n  }\n  return baseReverseDic[alphabet][character];\n}\n\nvar LZString = {\n  compressToBase64: function (input) {\n    if (input == null) return '';\n    var res = LZString._compress(input, 6, function (a) { return keyStrBase64.charAt(a); });\n    switch (res.length % 4) { // To produce valid Base64\n      default: // When could this happen ?\n      case 0 : return res;\n      case 1 : return res + '===';\n      case 2 : return res + '==';\n      case 3 : return res + '=';\n    }\n  },\n\n  decompressFromBase64: function (input) {\n    if (input == null) return '';\n    if (input == '') return null;\n    return LZString._decompress(input.length, 32, function (index) { return getBaseValue(keyStrBase64, input.charAt(index)); });\n  },\n\n  compressToUTF16: function (input) {\n    if (input == null) return '';\n    return LZString._compress(input, 15, function (a) { return f(a + 32); }) + ' ';\n  },\n\n  decompressFromUTF16: function (compressed) {\n    if (compressed == null) return '';\n    if (compressed == '') return null;\n    return LZString._decompress(compressed.length, 16384, function (index) { return compressed.charCodeAt(index) - 32; });\n  },\n\n  // compress into uint8array (UCS-2 big endian format)\n  compressToUint8Array: function (uncompressed) {\n    var compressed = LZString.compress(uncompressed);\n    var buf = new Uint8Array(compressed.length * 2); // 2 bytes per character\n\n    for (var i = 0, TotalLen = compressed.length; i < TotalLen; i++) {\n      var current_value = compressed.charCodeAt(i);\n      buf[i * 2] = current_value >>> 8;\n      buf[i * 2 + 1] = current_value % 256;\n    }\n    return buf;\n  },\n\n  // decompress from uint8array (UCS-2 big endian format)\n  decompressFromUint8Array: function (compressed) {\n    if (compressed === null || compressed === undefined) {\n      return LZString.decompress(compressed);\n    } else {\n      var buf = new Array(compressed.length / 2); // 2 bytes per character\n      for (var i = 0, TotalLen = buf.length; i < TotalLen; i++) {\n        buf[i] = compressed[i * 2] * 256 + compressed[i * 2 + 1];\n      }\n\n      var result = [];\n      buf.forEach(function (c) {\n        result.push(f(c));\n      });\n      return LZString.decompress(result.join(''));\n    }\n  },\n\n  // compress into a string that is already URI encoded\n  compressToEncodedURIComponent: function (input) {\n    if (input == null) return '';\n    return LZString._compress(input, 6, function (a) { return keyStrUriSafe.charAt(a); });\n  },\n\n  // decompress from an output of compressToEncodedURIComponent\n  decompressFromEncodedURIComponent: function (input) {\n    if (input == null) return '';\n    if (input == '') return null;\n    input = input.replace(/ /g, '+');\n    return LZString._decompress(input.length, 32, function (index) { return getBaseValue(keyStrUriSafe, input.charAt(index)); });\n  },\n\n  compress: function (uncompressed) {\n    return LZString._compress(uncompressed, 16, function (a) { return f(a); });\n  },\n  _compress: function (uncompressed, bitsPerChar, getCharFromInt) {\n    if (uncompressed == null) return '';\n    var i, value,\n      context_dictionary = {},\n      context_dictionaryToCreate = {},\n      context_c = '',\n      context_wc = '',\n      context_w = '',\n      context_enlargeIn = 2, // Compensate for the first entry which should not count\n      context_dictSize = 3,\n      context_numBits = 2,\n      context_data = [],\n      context_data_val = 0,\n      context_data_position = 0,\n      ii;\n\n    for (ii = 0; ii < uncompressed.length; ii += 1) {\n      context_c = uncompressed.charAt(ii);\n      if (!Object.prototype.hasOwnProperty.call(context_dictionary, context_c)) {\n        context_dictionary[context_c] = context_dictSize++;\n        context_dictionaryToCreate[context_c] = true;\n      }\n\n      context_wc = context_w + context_c;\n      if (Object.prototype.hasOwnProperty.call(context_dictionary, context_wc)) {\n        context_w = context_wc;\n      } else {\n        if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate, context_w)) {\n          if (context_w.charCodeAt(0) < 256) {\n            for (i = 0; i < context_numBits; i++) {\n              context_data_val = (context_data_val << 1);\n              if (context_data_position == bitsPerChar - 1) {\n                context_data_position = 0;\n                context_data.push(getCharFromInt(context_data_val));\n                context_data_val = 0;\n              } else {\n                context_data_position++;\n              }\n            }\n            value = context_w.charCodeAt(0);\n            for (i = 0; i < 8; i++) {\n              context_data_val = (context_data_val << 1) | (value & 1);\n              if (context_data_position == bitsPerChar - 1) {\n                context_data_position = 0;\n                context_data.push(getCharFromInt(context_data_val));\n                context_data_val = 0;\n              } else {\n                context_data_position++;\n              }\n              value = value >> 1;\n            }\n          } else {\n            value = 1;\n            for (i = 0; i < context_numBits; i++) {\n              context_data_val = (context_data_val << 1) | value;\n              if (context_data_position == bitsPerChar - 1) {\n                context_data_position = 0;\n                context_data.push(getCharFromInt(context_data_val));\n                context_data_val = 0;\n              } else {\n                context_data_position++;\n              }\n              value = 0;\n            }\n            value = context_w.charCodeAt(0);\n            for (i = 0; i < 16; i++) {\n              context_data_val = (context_data_val << 1) | (value & 1);\n              if (context_data_position == bitsPerChar - 1) {\n                context_data_position = 0;\n                context_data.push(getCharFromInt(context_data_val));\n                context_data_val = 0;\n              } else {\n                context_data_position++;\n              }\n              value = value >> 1;\n            }\n          }\n          context_enlargeIn--;\n          if (context_enlargeIn == 0) {\n            context_enlargeIn = Math.pow(2, context_numBits);\n            context_numBits++;\n          }\n          delete context_dictionaryToCreate[context_w];\n        } else {\n          value = context_dictionary[context_w];\n          for (i = 0; i < context_numBits; i++) {\n            context_data_val = (context_data_val << 1) | (value & 1);\n            if (context_data_position == bitsPerChar - 1) {\n              context_data_position = 0;\n              context_data.push(getCharFromInt(context_data_val));\n              context_data_val = 0;\n            } else {\n              context_data_position++;\n            }\n            value = value >> 1;\n          }\n        }\n        context_enlargeIn--;\n        if (context_enlargeIn == 0) {\n          context_enlargeIn = Math.pow(2, context_numBits);\n          context_numBits++;\n        }\n        // Add wc to the dictionary.\n        context_dictionary[context_wc] = context_dictSize++;\n        context_w = String(context_c);\n      }\n    }\n\n    // Output the code for w.\n    if (context_w !== '') {\n      if (Object.prototype.hasOwnProperty.call(context_dictionaryToCreate, context_w)) {\n        if (context_w.charCodeAt(0) < 256) {\n          for (i = 0; i < context_numBits; i++) {\n            context_data_val = (context_data_val << 1);\n            if (context_data_position == bitsPerChar - 1) {\n              context_data_position = 0;\n              context_data.push(getCharFromInt(context_data_val));\n              context_data_val = 0;\n            } else {\n              context_data_position++;\n            }\n          }\n          value = context_w.charCodeAt(0);\n          for (i = 0; i < 8; i++) {\n            context_data_val = (context_data_val << 1) | (value & 1);\n            if (context_data_position == bitsPerChar - 1) {\n              context_data_position = 0;\n              context_data.push(getCharFromInt(context_data_val));\n              context_data_val = 0;\n            } else {\n              context_data_position++;\n            }\n            value = value >> 1;\n          }\n        } else {\n          value = 1;\n          for (i = 0; i < context_numBits; i++) {\n            context_data_val = (context_data_val << 1) | value;\n            if (context_data_position == bitsPerChar - 1) {\n              context_data_position = 0;\n              context_data.push(getCharFromInt(context_data_val));\n              context_data_val = 0;\n            } else {\n              context_data_position++;\n            }\n            value = 0;\n          }\n          value = context_w.charCodeAt(0);\n          for (i = 0; i < 16; i++) {\n            context_data_val = (context_data_val << 1) | (value & 1);\n            if (context_data_position == bitsPerChar - 1) {\n              context_data_position = 0;\n              context_data.push(getCharFromInt(context_data_val));\n              context_data_val = 0;\n            } else {\n              context_data_position++;\n            }\n            value = value >> 1;\n          }\n        }\n        context_enlargeIn--;\n        if (context_enlargeIn == 0) {\n          context_enlargeIn = Math.pow(2, context_numBits);\n          context_numBits++;\n        }\n        delete context_dictionaryToCreate[context_w];\n      } else {\n        value = context_dictionary[context_w];\n        for (i = 0; i < context_numBits; i++) {\n          context_data_val = (context_data_val << 1) | (value & 1);\n          if (context_data_position == bitsPerChar - 1) {\n            context_data_position = 0;\n            context_data.push(getCharFromInt(context_data_val));\n            context_data_val = 0;\n          } else {\n            context_data_position++;\n          }\n          value = value >> 1;\n        }\n      }\n      context_enlargeIn--;\n      if (context_enlargeIn == 0) {\n        context_enlargeIn = Math.pow(2, context_numBits);\n        context_numBits++;\n      }\n    }\n\n    // Mark the end of the stream\n    value = 2;\n    for (i = 0; i < context_numBits; i++) {\n      context_data_val = (context_data_val << 1) | (value & 1);\n      if (context_data_position == bitsPerChar - 1) {\n        context_data_position = 0;\n        context_data.push(getCharFromInt(context_data_val));\n        context_data_val = 0;\n      } else {\n        context_data_position++;\n      }\n      value = value >> 1;\n    }\n\n    // Flush the last char\n    while (true) {\n      context_data_val = (context_data_val << 1);\n      if (context_data_position == bitsPerChar - 1) {\n        context_data.push(getCharFromInt(context_data_val));\n        break;\n      } else context_data_position++;\n    }\n    return context_data.join('');\n  },\n\n  decompress: function (compressed) {\n    if (compressed == null) return '';\n    if (compressed == '') return null;\n    return LZString._decompress(compressed.length, 32768, function (index) { return compressed.charCodeAt(index); });\n  },\n\n  _decompress: function (length, resetValue, getNextValue) {\n    var dictionary = [],\n      next,\n      enlargeIn = 4,\n      dictSize = 4,\n      numBits = 3,\n      entry = '',\n      result = [],\n      i,\n      w,\n      bits, resb, maxpower, power,\n      c,\n      data = {val: getNextValue(0), position: resetValue, index: 1};\n\n    for (i = 0; i < 3; i += 1) {\n      dictionary[i] = i;\n    }\n\n    bits = 0;\n    maxpower = Math.pow(2, 2);\n    power = 1;\n    while (power != maxpower) {\n      resb = data.val & data.position;\n      data.position >>= 1;\n      if (data.position == 0) {\n        data.position = resetValue;\n        data.val = getNextValue(data.index++);\n      }\n      bits |= (resb > 0 ? 1 : 0) * power;\n      power <<= 1;\n    }\n\n    switch (next = bits) {\n      case 0:\n        bits = 0;\n        maxpower = Math.pow(2, 8);\n        power = 1;\n        while (power != maxpower) {\n          resb = data.val & data.position;\n          data.position >>= 1;\n          if (data.position == 0) {\n            data.position = resetValue;\n            data.val = getNextValue(data.index++);\n          }\n          bits |= (resb > 0 ? 1 : 0) * power;\n          power <<= 1;\n        }\n        c = f(bits);\n        break;\n      case 1:\n        bits = 0;\n        maxpower = Math.pow(2, 16);\n        power = 1;\n        while (power != maxpower) {\n          resb = data.val & data.position;\n          data.position >>= 1;\n          if (data.position == 0) {\n            data.position = resetValue;\n            data.val = getNextValue(data.index++);\n          }\n          bits |= (resb > 0 ? 1 : 0) * power;\n          power <<= 1;\n        }\n        c = f(bits);\n        break;\n      case 2:\n        return '';\n    }\n    dictionary[3] = c;\n    w = c;\n    result.push(c);\n    while (true) {\n      if (data.index > length) {\n        return '';\n      }\n\n      bits = 0;\n      maxpower = Math.pow(2, numBits);\n      power = 1;\n      while (power != maxpower) {\n        resb = data.val & data.position;\n        data.position >>= 1;\n        if (data.position == 0) {\n          data.position = resetValue;\n          data.val = getNextValue(data.index++);\n        }\n        bits |= (resb > 0 ? 1 : 0) * power;\n        power <<= 1;\n      }\n\n      switch (c = bits) {\n        case 0:\n          bits = 0;\n          maxpower = Math.pow(2, 8);\n          power = 1;\n          while (power != maxpower) {\n            resb = data.val & data.position;\n            data.position >>= 1;\n            if (data.position == 0) {\n              data.position = resetValue;\n              data.val = getNextValue(data.index++);\n            }\n            bits |= (resb > 0 ? 1 : 0) * power;\n            power <<= 1;\n          }\n\n          dictionary[dictSize++] = f(bits);\n          c = dictSize - 1;\n          enlargeIn--;\n          break;\n        case 1:\n          bits = 0;\n          maxpower = Math.pow(2, 16);\n          power = 1;\n          while (power != maxpower) {\n            resb = data.val & data.position;\n            data.position >>= 1;\n            if (data.position == 0) {\n              data.position = resetValue;\n              data.val = getNextValue(data.index++);\n            }\n            bits |= (resb > 0 ? 1 : 0) * power;\n            power <<= 1;\n          }\n          dictionary[dictSize++] = f(bits);\n          c = dictSize - 1;\n          enlargeIn--;\n          break;\n        case 2:\n          return result.join('');\n      }\n\n      if (enlargeIn == 0) {\n        enlargeIn = Math.pow(2, numBits);\n        numBits++;\n      }\n\n      if (dictionary[c]) {\n        entry = dictionary[c];\n      } else {\n        if (c === dictSize) {\n          entry = w + w.charAt(0);\n        } else {\n          return null;\n        }\n      }\n      result.push(entry);\n\n      // Add w+entry[0] to the dictionary.\n      dictionary[dictSize++] = w + entry.charAt(0);\n      enlargeIn--;\n\n      w = entry;\n\n      if (enlargeIn == 0) {\n        enlargeIn = Math.pow(2, numBits);\n        numBits++;\n      }\n    }\n  }\n};\n\nmodule.exports = LZString;\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/lz-string.js?\n}");

/***/ }),

/***/ "../common/crypto/nacl.js":
/*!********************************!*\
  !*** ../common/crypto/nacl.js ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

eval("{var nacl_factory = {\n  instantiate: function (on_ready, optionsOpt) {\n    var options = optionsOpt || {};\n    var undefined_reference_value = (function (v) { return v; })();\n    var requested_total_memory = options.requested_total_memory || undefined_reference_value;\n\n    if (typeof on_ready !== 'function') {\n      throw new Error(\"nacl_factory: Expects on_ready callback as first argument. New in v1.1.0.\");\n    }\n\n    return (function (window, document) {\n      var Module = {\n        TOTAL_MEMORY: requested_total_memory\n      };\n      var nacl_raw = Module;\n    var Module;\n    if (typeof Module === 'undefined') {\n      Module = {};\n    }\n    var root = Module;\n    if (typeof root['sodium'] !== 'object') {\n      if (typeof global === 'object') {\n        root = global;\n      } else if (typeof window === 'object') {\n        root = window;\n      }\n    }\n    if (typeof root['sodium'] === 'object' && typeof root['sodium']['totalMemory'] === 'number') {\n      Module['TOTAL_MEMORY'] = root['sodium']['totalMemory'];\n    }\n    var _Module = Module;\n    Module.ready = new Promise(function(resolve, reject) {\n      var Module = _Module;\n      Module.onAbort = reject;\n      Module.print = function(what) {\n        typeof(console) !== 'undefined' && console.log(what);\n      }\n      Module.printErr = function(what) {\n        typeof(console) !== 'undefined' && console.warn(what);\n      }\n      Module.onRuntimeInitialized = function() {\n        try {\n          /* Test arbitrary wasm function */\n          Module._crypto_secretbox_keybytes();\n          resolve();\n        } catch (err) {\n          reject(err);\n        }\n      };\n      Module.useBackupModule = function() {\n        return new Promise(function(resolve, reject) {\n          var Module = {};\n          Module.onAbort = reject;\n\n          Module.onRuntimeInitialized = function() {\n            Object.keys(_Module).forEach(function(k) {\n              if (k !== 'getRandomValue') {\n                delete _Module[k];\n              }\n            });\n            Object.keys(Module).forEach(function(k) {\n              _Module[k] = Module[k];\n            });\n            resolve();\n          };\n\n          var Module=typeof Module!==\"undefined\"?Module:{};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var arguments_=[];var thisProgram=\"./this.program\";var quit_=function(status,toThrow){throw toThrow};var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;ENVIRONMENT_IS_WEB=typeof window===\"object\";ENVIRONMENT_IS_WORKER=typeof importScripts===\"function\";ENVIRONMENT_IS_NODE=typeof process===\"object\"&&typeof process.versions===\"object\"&&typeof process.versions.node===\"string\";ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;var scriptDirectory=\"\";function locateFile(path){if(Module[\"locateFile\"]){return Module[\"locateFile\"](path,scriptDirectory)}return scriptDirectory+path}var read_,readAsync,readBinary,setWindowTitle;var nodeFS;var nodePath;if(ENVIRONMENT_IS_NODE){if(ENVIRONMENT_IS_WORKER){scriptDirectory=(__webpack_require__(/*! path */ \"path\").dirname)(scriptDirectory)+\"/\"}else{scriptDirectory=__dirname+\"/\"}read_=function shell_read(filename,binary){var ret=tryParseAsDataURI(filename);if(ret){return binary?ret:ret.toString()}if(!nodeFS)nodeFS=__webpack_require__(/*! fs */ \"fs\");if(!nodePath)nodePath=__webpack_require__(/*! path */ \"path\");filename=nodePath[\"normalize\"](filename);return nodeFS[\"readFileSync\"](filename,binary?null:\"utf8\")};readBinary=function readBinary(filename){var ret=read_(filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(process[\"argv\"].length>1){thisProgram=process[\"argv\"][1].replace(/\\\\/g,\"/\")}arguments_=process[\"argv\"].slice(2);if(true){module[\"exports\"]=Module}quit_=function(status){process[\"exit\"](status)};Module[\"inspect\"]=function(){return\"[Emscripten Module object]\"}}else if(ENVIRONMENT_IS_SHELL){if(typeof read!=\"undefined\"){read_=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}readBinary=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer===\"function\"){return new Uint8Array(readbuffer(f))}data=read(f,\"binary\");assert(typeof data===\"object\");return data};if(typeof scriptArgs!=\"undefined\"){arguments_=scriptArgs}else if(typeof arguments!=\"undefined\"){arguments_=arguments}if(typeof quit===\"function\"){quit_=function(status){quit(status)}}if(typeof print!==\"undefined\"){if(typeof console===\"undefined\")console={};console.log=print;console.warn=console.error=typeof printErr!==\"undefined\"?printErr:print}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){scriptDirectory=self.location.href}else if(document.currentScript){scriptDirectory=document.currentScript.src}if(scriptDirectory.indexOf(\"blob:\")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf(\"/\")+1)}else{scriptDirectory=\"\"}{read_=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){readBinary=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,false);xhr.responseType=\"arraybuffer\";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}readAsync=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,true);xhr.responseType=\"arraybuffer\";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)}}setWindowTitle=function(title){document.title=title}}else{}var out=Module[\"print\"]||console.log.bind(console);var err=Module[\"printErr\"]||console.warn.bind(console);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=null;if(Module[\"arguments\"])arguments_=Module[\"arguments\"];if(Module[\"thisProgram\"])thisProgram=Module[\"thisProgram\"];if(Module[\"quit\"])quit_=Module[\"quit\"];var wasmBinary;if(Module[\"wasmBinary\"])wasmBinary=Module[\"wasmBinary\"];var noExitRuntime;if(Module[\"noExitRuntime\"])noExitRuntime=Module[\"noExitRuntime\"];var WebAssembly={Memory:function(opts){return{buffer:new ArrayBuffer(opts[\"initial\"]*65536),grow:function(amount){var ret=__growWasmMemory(amount);return ret}}},Table:function(opts){var ret=new Array(opts[\"initial\"]);ret.grow=function(by){if(ret.length>=14+8){abort(\"Unable to grow wasm table. Use a higher value for RESERVED_FUNCTION_POINTERS or set ALLOW_TABLE_GROWTH.\")}ret.push(null)};ret.set=function(i,func){ret[i]=func};ret.get=function(i){return ret[i]};return ret},Module:function(binary){return{}},Instance:function(module,info){var exports=(\n// EMSCRIPTEN_START_ASM\nfunction a(asmLibraryArg,wasmMemory,wasmTable){var scratchBuffer=new ArrayBuffer(8);var b=new Int32Array(scratchBuffer);var c=new Float32Array(scratchBuffer);var d=new Float64Array(scratchBuffer);function e(){if(typeof setTempRet0===\"function\")setTempRet0(b[1]);return b[0]}function f(low,high){b[0]=low;b[1]=high}function g(global,env,buffer){var h=env.memory;var i=wasmTable;var j=new global.Int8Array(buffer);var k=new global.Int16Array(buffer);var l=new global.Int32Array(buffer);var m=new global.Uint8Array(buffer);var n=new global.Uint16Array(buffer);var o=new global.Uint32Array(buffer);var p=new global.Float32Array(buffer);var q=new global.Float64Array(buffer);var r=global.Math.imul;var s=global.Math.fround;var t=global.Math.abs;var u=global.Math.clz32;var v=global.Math.min;var w=global.Math.max;var x=global.Math.floor;var y=global.Math.ceil;var z=global.Math.sqrt;var A=env.abort;var B=global.NaN;var C=global.Infinity;var D=env.__assert_fail;var E=env.emscripten_asm_const_iii;var F=env.abort;var G=env.emscripten_memcpy_big;var H=env.emscripten_resize_heap;var I=env.getTempRet0;var J=5280352;var K=0;\n// EMSCRIPTEN_START_FUNCS\nfunction Yc(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,k=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0;S=J-256|0;J=S;while(1){o=W<<3;ba=o+(S+128|0)|0;o=b+o|0;Q=m[o+4|0]|m[o+5|0]<<8|(m[o+6|0]<<16|m[o+7|0]<<24);l[ba>>2]=m[o|0]|m[o+1|0]<<8|(m[o+2|0]<<16|m[o+3|0]<<24);l[ba+4>>2]=Q;W=W+1|0;if((W|0)!=16){continue}break}o=pa(S,a,64);b=o;l[b+88>>2]=1595750129;l[b+92>>2]=-1521486534;b=a;p=m[b+88|0]|m[b+89|0]<<8|(m[b+90|0]<<16|m[b+91|0]<<24);ba=m[b+92|0]|m[b+93|0]<<8|(m[b+94|0]<<16|m[b+95|0]<<24);g=m[b+72|0]|m[b+73|0]<<8|(m[b+74|0]<<16|m[b+75|0]<<24);Q=m[b+76|0]|m[b+77|0]<<8|(m[b+78|0]<<16|m[b+79|0]<<24);ca=m[b+80|0]|m[b+81|0]<<8|(m[b+82|0]<<16|m[b+83|0]<<24);ea=m[b+84|0]|m[b+85|0]<<8|(m[b+86|0]<<16|m[b+87|0]<<24);X=l[o+4>>2];S=o;c=l[o+36>>2];b=c+l[o+132>>2]|0;e=l[o+32>>2];W=l[o+128>>2];aa=e+W|0;if(aa>>>0<W>>>0){b=b+1|0}W=aa+l[o>>2]|0;b=b+X|0;b=W>>>0<aa>>>0?b+1|0:b;X=W;W=a;aa=b;W=_(X^(m[W+64|0]|m[W+65|0]<<8|(m[W+66|0]<<16|m[W+67|0]<<24))^-1377402159,b^(m[W+68|0]|m[W+69|0]<<8|(m[W+70|0]<<16|m[W+71|0]<<24))^1359893119,32);f=W;b=K;k=b;b=b+1779033703|0;W=f+ -205731576|0;if(W>>>0<4089235720){b=b+1|0}A=W;d=e^A;e=b;d=_(d,c^b,24);c=o;W=l[c+136>>2];h=K;b=aa+h|0;aa=d+X|0;if(aa>>>0<X>>>0){b=b+1|0}aa=W+aa|0;ma=l[c+140>>2];b=ma+b|0;r=aa;G=r>>>0<W>>>0?b+1|0:b;I=_(r^f,G^k,16);b=K;aa=b;l[S+96>>2]=I;l[S+100>>2]=b;b=e+b|0;X=A+I|0;if(X>>>0<A>>>0){b=b+1|0}f=X;l[o+64>>2]=f;l[S+68>>2]=b;v=b;X=_(d^f,h^b,63);b=K;k=b;l[o+32>>2]=X;l[o+36>>2]=b;c=l[o+12>>2];s=g;ga=l[o+148>>2];g=l[o+44>>2];b=ga+g|0;e=l[o+144>>2];d=l[o+40>>2];h=e+d|0;if(h>>>0<d>>>0){b=b+1|0}A=h+l[o+8>>2]|0;b=b+c|0;b=A>>>0<h>>>0?b+1|0:b;c=Q;Q=b;c=_(s^A^725511199,c^b^-1694144372,32);h=c;b=K;Z=b;b=b+ -1150833019|0;c=c+ -2067093701|0;if(c>>>0<2227873595){b=b+1|0}s=d^c;d=b;g=_(s,g^b,24);i=K;b=Q+i|0;Q=g+A|0;if(Q>>>0<A>>>0){b=b+1|0}A=l[o+152>>2];Q=A+Q|0;b=l[o+156>>2]+b|0;x=Q;C=x>>>0<A>>>0?b+1|0:b;T=_(x^h,C^Z,16);b=K;h=b;l[S+104>>2]=T;l[S+108>>2]=b;b=d+b|0;Q=c+T|0;if(Q>>>0<c>>>0){b=b+1|0}n=Q;l[o+72>>2]=n;l[S+76>>2]=b;D=b;A=_(g^n,i^b,63);c=K;Q=l[o+20>>2];s=ca;fa=l[o+164>>2];ca=l[o+52>>2];b=fa+ca|0;H=l[o+160>>2];g=l[o+48>>2];d=H+g|0;if(d>>>0<g>>>0){b=b+1|0}S=d+l[o+16>>2]|0;b=b+Q|0;w=S;Q=w>>>0<d>>>0?b+1|0:b;t=_(s^w^-79577749,Q^ea^528734635,32);b=K;ea=b;b=b+1013904242|0;S=t+ -23791573|0;if(S>>>0<4271175723){b=b+1|0}d=S;s=g^d;g=b;S=_(s,ca^b,24);b=K;ca=S;Z=b;i=ea;na=l[o+172>>2];q=na;b=b+Q|0;Q=w+S|0;if(Q>>>0<S>>>0){b=b+1|0}ea=l[o+168>>2];S=ea+Q|0;b=b+q|0;F=S;B=F>>>0<Q>>>0?b+1|0:b;M=_(F^t,B^i,16);P=K;b=g+P|0;S=d+M|0;if(S>>>0<d>>>0){b=b+1|0}w=S;s=b;d=_(w^ca,b^Z,63);g=K;ca=l[o+28>>2];q=p;oa=l[o+180>>2];t=l[o+60>>2];b=oa+t|0;S=l[o+176>>2];p=l[o+56>>2];Z=S+p|0;if(Z>>>0<p>>>0){b=b+1|0}Q=Z+l[o+24>>2]|0;b=b+ca|0;b=Q>>>0<Z>>>0?b+1|0:b;Z=Q;i=b;E=_(q^Q^327033209,b^ba^1541459225,32);b=K;ba=b;b=b+ -1521486534|0;Q=E+1595750129|0;if(Q>>>0<1595750129){b=b+1|0}ca=Q;Q=_(p^Q,b^t,24);p=Q;q=ca;u=b;z=ba;ca=l[o+188>>2];y=ca;t=K;b=i+t|0;Q=p+Z|0;if(Q>>>0<Z>>>0){b=b+1|0}ba=l[o+184>>2];Z=Q;Q=ba+Q|0;b=b+y|0;N=Q;i=z;z=Q>>>0<Z>>>0?b+1|0:b;Z=_(Q^E,i^z,16);y=p;p=K;b=p+u|0;Q=Z;i=Q+q|0;if(i>>>0<Q>>>0){b=b+1|0}E=i;Q=b;i=_(y^i,b^t,63);t=K;ha=l[o+196>>2];q=ha;u=Z;b=c+G|0;G=r+A|0;if(G>>>0<A>>>0){b=b+1|0}ka=l[o+192>>2];Z=ka+G|0;b=b+q|0;q=Z;r=p;p=q>>>0<G>>>0?b+1|0:b;Z=_(u^q,r^p,32);b=K;G=o;r=b;y=A;b=s+b|0;u=Z;A=w+u|0;if(A>>>0<w>>>0){b=b+1|0}s=c;c=b;L=_(y^A,s^b,24);Z=o;w=l[o+200>>2];y=u;u=K;b=p+u|0;s=q+L|0;if(s>>>0<q>>>0){b=b+1|0}p=w+s|0;ia=l[Z+204>>2];b=ia+b|0;ja=p;s=r;r=p>>>0<w>>>0?b+1|0:b;V=_(y^p,s^r,16);b=K;s=b;l[G+120>>2]=V;l[G+124>>2]=b;b=c+b|0;c=A+V|0;if(c>>>0<A>>>0){b=b+1|0}p=c;l[o+80>>2]=c;l[Z+84>>2]=b;c=c^L;L=b;q=_(c,u^b,63);u=K;Z=g;ra=l[o+212>>2];G=ra;y=I;b=g+C|0;c=d;d=x+c|0;if(d>>>0<x>>>0){b=b+1|0}A=l[o+208>>2];g=d;d=A+d|0;b=b+G|0;I=d;d=d>>>0<g>>>0?b+1|0:b;aa=_(y^I,d^aa,32);x=c;c=K;b=c+Q|0;Q=aa;g=Q+E|0;if(g>>>0<Q>>>0){b=b+1|0}Q=_(x^g,b^Z,24);x=Q;C=b;ta=l[o+220>>2];y=ta;R=aa;Z=K;b=Z+d|0;aa=I+x|0;if(aa>>>0<x>>>0){b=b+1|0}G=l[o+216>>2];Q=G+aa|0;b=b+y|0;E=Q;I=E>>>0<aa>>>0?b+1|0:b;c=_(R^E,I^c,16);b=C;C=K;b=b+C|0;aa=c+g|0;if(aa>>>0<c>>>0){b=b+1|0}y=aa;g=b;d=_(y^x,b^Z,63);x=K;Q=i;R=t;Z=l[o+228>>2];O=Z;b=t+B|0;i=i+F|0;if(i>>>0<F>>>0){b=b+1|0}aa=l[o+224>>2];t=i;i=aa+i|0;b=b+O|0;O=i;B=h;h=i>>>0<t>>>0?b+1|0:b;T=_(i^T,B^h,32);t=Q;i=K;b=v+i|0;Q=f+T|0;if(Q>>>0<f>>>0){b=b+1|0}f=Q;Q=_(t^f,b^R,24);v=Q;F=b;B=i;Y=l[o+236>>2];U=Y;t=K;b=t+h|0;h=v+O|0;if(h>>>0<v>>>0){b=b+1|0}i=l[o+232>>2];Q=i+h|0;b=b+U|0;R=Q;O=B;B=Q>>>0<h>>>0?b+1|0:b;h=_(Q^T,O^B,16);b=F;F=K;b=b+F|0;f=f+h|0;if(f>>>0<h>>>0){b=b+1|0}T=f;f=b;t=_(T^v,b^t,63);v=K;U=k;qa=l[o+244>>2];la=qa;b=k+z|0;O=X;k=O+N|0;if(k>>>0<O>>>0){b=b+1|0}Q=l[o+240>>2];X=Q+k|0;b=b+la|0;b=X>>>0<k>>>0?b+1|0:b;k=X;z=P;P=b;M=_(k^M,z^b,32);z=f;f=c;X=K;b=D+X|0;c=n+M|0;if(c>>>0<n>>>0){b=b+1|0}n=b;O=_(c^O,b^U,24);U=O;b=K;N=b;D=X;la=l[o+252>>2];da=la;b=b+P|0;P=k+U|0;if(P>>>0<k>>>0){b=b+1|0}X=l[o+248>>2];k=X+P|0;b=b+da|0;b=k>>>0<P>>>0?b+1|0:b;P=k;O=D;D=b;da=_(k^M,O^b,16);M=U;O=K;b=n+O|0;k=c+da|0;if(k>>>0<c>>>0){b=b+1|0}U=k;c=b;M=_(M^k,b^N,63);b=K;N=b;k=b;$=f;b=r+qa|0;f=Q;n=f+ja|0;if(n>>>0<f>>>0){b=b+1|0}f=n+M|0;b=b+k|0;k=f;r=C;C=f>>>0<n>>>0?b+1|0:b;f=_($^f,r^C,32);n=o;b=z;z=K;b=b+z|0;T=f+T|0;if(T>>>0<f>>>0){b=b+1|0}r=T;T=b;N=_(M^r,N^b,24);$=N;b=K;sa=b;M=b;ja=f;b=C+ra|0;f=k+A|0;if(f>>>0<k>>>0){b=b+1|0}k=f;f=f+N|0;b=b+M|0;ua=f;C=z;z=f>>>0<k>>>0?b+1|0:b;ja=_(ja^f,C^z,16);M=K;b=T+M|0;f=r+ja|0;if(f>>>0<r>>>0){b=b+1|0}r=f;T=b;k=_(f^$,b^sa,63);b=K;C=b;l[n+32>>2]=k;l[n+36>>2]=b;N=c;$=h;n=u;b=fa+n|0;f=q;c=H+f|0;if(c>>>0<H>>>0){b=b+1|0}c=c+E|0;b=b+I|0;h=c;q=c>>>0<E>>>0?b+1|0:b;c=_($^c,q^F,32);I=f;f=K;b=f+N|0;H=c+U|0;if(H>>>0<c>>>0){b=b+1|0}u=H;E=n;n=b;F=_(I^u,E^b,24);E=F;b=K;I=b;H=b;N=c;b=q+ha|0;c=h+ka|0;if(c>>>0<h>>>0){b=b+1|0}h=c;c=c+F|0;b=b+H|0;q=c;H=c>>>0<h>>>0?b+1|0:b;N=_(N^c,H^f,16);f=E;F=K;b=n+F|0;c=u+N|0;if(c>>>0<u>>>0){b=b+1|0}E=c;h=I;I=b;h=_(f^c,h^b,63);c=K;f=d;n=x;b=n+ia|0;w=d+w|0;if(w>>>0<d>>>0){b=b+1|0}d=w+R|0;b=b+B|0;x=d;d=d>>>0<R>>>0?b+1|0:b;u=_(x^da,d^O,32);B=f;f=K;b=L+f|0;w=p+u|0;if(w>>>0<p>>>0){b=b+1|0}p=n;n=b;B=_(B^w,p^b,24);L=B;b=K;R=b;p=b;O=u;b=d+la|0;d=X;u=d+x|0;if(u>>>0<d>>>0){b=b+1|0}d=u+B|0;b=b+p|0;b=d>>>0<u>>>0?b+1|0:b;u=d;x=b;fa=_(O^d,b^f,16);p=L;B=K;b=n+B|0;d=w+fa|0;if(d>>>0<w>>>0){b=b+1|0}L=d;f=b;n=_(p^d,b^R,63);w=K;R=v;b=v+Y|0;p=t;d=i;t=p+d|0;if(t>>>0<d>>>0){b=b+1|0}d=t+P|0;b=b+D|0;D=d;t=d>>>0<P>>>0?b+1|0:b;d=_(d^V,t^s,32);v=p;b=g;g=K;b=b+g|0;p=d+y|0;if(p>>>0<d>>>0){b=b+1|0}s=p;P=_(v^p,b^R,24);y=P;p=K;R=p;v=b;O=d;b=t+oa|0;d=S;t=d+D|0;if(t>>>0<d>>>0){b=b+1|0}d=t+P|0;b=b+p|0;D=d;P=d>>>0<t>>>0?b+1|0:b;t=_(O^d,P^g,16);p=y;b=v;v=K;b=b+v|0;d=t;g=d+s|0;if(g>>>0<d>>>0){b=b+1|0}y=g;g=b;s=_(p^y,b^R,63);d=K;p=o;R=h;O=c;V=t;U=h;b=z+ma|0;h=W;t=h+ua|0;if(t>>>0<h>>>0){b=b+1|0}h=U+t|0;b=b+c|0;U=h;h=h>>>0<t>>>0?b+1|0:b;c=_(V^U,h^v,32);V=K;b=V+f|0;t=c+L|0;if(t>>>0<c>>>0){b=b+1|0}f=t;t=b;R=_(f^R,b^O,24);b=K;v=b;z=b;b=h+Z|0;h=aa;L=h+U|0;if(L>>>0<h>>>0){b=b+1|0}h=L+R|0;b=b+z|0;z=h;L=h>>>0<L>>>0?b+1|0:b;da=_(c^h,V^L,16);b=K;h=b;l[p+120>>2]=da;l[p+124>>2]=b;p=R;b=b+t|0;c=f+da|0;if(c>>>0<f>>>0){b=b+1|0}R=c;f=b;t=_(p^c,b^v,63);p=K;v=n;O=w;ia=l[o+132>>2];V=ia;b=w+H|0;c=n+q|0;if(c>>>0<q>>>0){b=b+1|0}U=l[o+128>>2];n=c;c=U+c|0;b=b+V|0;b=c>>>0<n>>>0?b+1|0:b;n=c;w=b;c=_(c^ja,b^M,32);H=v;b=g;g=K;b=b+g|0;v=c+y|0;if(v>>>0<c>>>0){b=b+1|0}q=v;y=_(H^q,b^O,24);M=y;v=K;V=v;H=b;$=c;b=w+ga|0;c=e+n|0;if(c>>>0<n>>>0){b=b+1|0}n=c;c=c+y|0;b=b+v|0;y=c;O=c>>>0<n>>>0?b+1|0:b;c=_($^c,O^g,16);n=K;b=n+H|0;w=c+q|0;if(w>>>0<c>>>0){b=b+1|0}H=w;g=w^M;M=b;g=_(g,b^V,63);w=K;v=d;V=N;q=s;N=q;b=x+ta|0;s=u+G|0;if(s>>>0<u>>>0){b=b+1|0}u=s;s=N+u|0;b=b+d|0;N=s;d=s>>>0<u>>>0?b+1|0:b;F=_(V^s,d^F,32);x=q;s=K;b=T+s|0;q=r+F|0;if(q>>>0<r>>>0){b=b+1|0}v=_(x^q,b^v,24);T=v;u=K;V=u;x=b;$=F;r=v;b=d+ca|0;d=ba;v=d+N|0;if(v>>>0<d>>>0){b=b+1|0}d=r+v|0;b=b+u|0;F=d;r=d>>>0<v>>>0?b+1|0:b;s=_($^d,r^s,16);v=T;T=K;b=T+x|0;d=s;q=d+q|0;if(q>>>0<d>>>0){b=b+1|0}x=q;d=b;q=_(v^q,b^V,63);u=K;v=k;N=C;b=C+na|0;k=ea;C=v+k|0;if(C>>>0<k>>>0){b=b+1|0}k=C+D|0;b=b+P|0;b=k>>>0<D>>>0?b+1|0:b;C=b;V=_(k^fa,b^B,32);D=x;B=d;x=c;c=K;b=I+c|0;d=E+V|0;if(d>>>0<E>>>0){b=b+1|0}E=_(d^v,b^N,24);I=E;N=K;fa=N;v=b;P=c;ja=l[o+156>>2];$=ja;b=C+N|0;C=k+E|0;if(C>>>0<k>>>0){b=b+1|0}c=l[o+152>>2];k=c+C|0;b=b+$|0;b=k>>>0<C>>>0?b+1|0:b;C=k;E=P;P=b;k=_(k^V,E^b,16);N=I;E=K;b=E+v|0;v=d;d=k;v=v+d|0;if(v>>>0<d>>>0){b=b+1|0}I=v;d=b;N=_(N^v,b^fa,63);b=K;V=b;v=b;$=x;b=L+ta|0;x=z+G|0;if(x>>>0<z>>>0){b=b+1|0}z=x;x=x+N|0;b=b+v|0;v=x;z=x>>>0<z>>>0?b+1|0:b;n=_($^x,z^n,32);x=o;b=B;B=K;b=b+B|0;L=n+D|0;if(L>>>0<n>>>0){b=b+1|0}D=L;L=b;V=_(N^D,V^b,24);fa=V;b=K;$=b;N=b;sa=n;b=z+ha|0;n=v+ka|0;if(n>>>0<v>>>0){b=b+1|0}v=n;n=n+V|0;b=b+N|0;ka=n;z=B;B=n>>>0<v>>>0?b+1|0:b;ha=_(sa^n,z^B,16);z=K;b=L+z|0;n=D+ha|0;if(n>>>0<D>>>0){b=b+1|0}D=n;L=b;n=_(n^fa,b^$,63);b=K;v=b;l[x+32>>2]=n;l[x+36>>2]=b;x=t;N=p;V=d;b=p+Z|0;d=aa;t=d+t|0;if(t>>>0<d>>>0){b=b+1|0}d=t+y|0;b=b+O|0;b=d>>>0<y>>>0?b+1|0:b;y=d;t=b;d=_(d^s,b^T,32);O=x;s=K;b=s+V|0;x=d+I|0;if(x>>>0<d>>>0){b=b+1|0}p=x;x=b;T=_(O^p,b^N,24);O=T;b=K;V=b;I=b;N=d;b=t+ia|0;d=y+U|0;if(d>>>0<U>>>0){b=b+1|0}t=d;d=d+T|0;b=b+I|0;fa=d;I=d>>>0<t>>>0?b+1|0:b;N=_(N^d,I^s,16);y=K;b=x+y|0;d=p+N|0;if(d>>>0<p>>>0){b=b+1|0}T=d;d=d^O;O=b;t=_(d,b^V,63);d=K;s=g;x=k;p=w;b=na+p|0;g=ea;k=s+g|0;if(k>>>0<g>>>0){b=b+1|0}g=k+F|0;b=b+r|0;k=g;w=g>>>0<F>>>0?b+1|0:b;g=_(x^g,w^E,32);r=s;b=f;f=K;b=b+f|0;x=g+R|0;if(x>>>0<g>>>0){b=b+1|0}s=x;F=_(r^s,b^p,24);E=F;p=K;r=p;x=b;R=g;b=w+ga|0;g=e+k|0;if(g>>>0<k>>>0){b=b+1|0}k=g;g=g+F|0;b=b+p|0;V=g;F=g>>>0<k>>>0?b+1|0:b;w=_(R^g,F^f,16);p=E;E=K;b=E+x|0;g=w;f=g+s|0;if(f>>>0<g>>>0){b=b+1|0}x=f;k=b;s=_(p^f,b^r,63);g=K;p=u;b=la+p|0;f=q;q=X;u=f+q|0;if(u>>>0<q>>>0){b=b+1|0}q=u+C|0;b=b+P|0;b=q>>>0<C>>>0?b+1|0:b;u=h;h=b;P=_(q^da,u^b,32);r=f;f=K;b=M+f|0;u=H+P|0;if(u>>>0<H>>>0){b=b+1|0}C=p;p=b;H=_(r^u,C^b,24);r=H;b=K;R=b;C=b;b=h+Y|0;h=i+q|0;if(h>>>0<q>>>0){b=b+1|0}q=h;h=h+H|0;b=b+C|0;H=h;C=h^P;P=h>>>0<q>>>0?b+1|0:b;U=_(C,P^f,16);q=r;C=K;b=p+C|0;f=u+U|0;if(f>>>0<u>>>0){b=b+1|0}r=f;h=b;p=_(q^f,b^R,63);f=K;q=o;u=t;R=d;M=u;b=B+ra|0;t=A;B=t+ka|0;if(B>>>0<t>>>0){b=b+1|0}t=M+B|0;b=b+d|0;b=t>>>0<B>>>0?b+1|0:b;B=t;t=b;d=_(B^U,b^C,32);C=u;U=K;b=U+k|0;u=d+x|0;if(u>>>0<d>>>0){b=b+1|0}k=u;u=b;R=_(C^k,b^R,24);b=K;x=b;C=b;b=t+qa|0;t=Q;B=t+B|0;if(B>>>0<t>>>0){b=b+1|0}t=B+R|0;b=b+C|0;ia=t;B=t>>>0<B>>>0?b+1|0:b;da=_(d^t,U^B,16);b=K;t=b;l[q+120>>2]=da;l[q+124>>2]=b;q=R;b=b+u|0;d=k+da|0;if(d>>>0<k>>>0){b=b+1|0}R=d;k=b;q=_(q^d,b^x,63);u=K;x=s;C=g;d=s;b=I+ja|0;s=c+fa|0;if(s>>>0<c>>>0){b=b+1|0}d=d+s|0;b=b+g|0;I=d;g=d>>>0<s>>>0?b+1|0:b;d=_(d^ha,g^z,32);z=x;b=h;h=K;b=b+h|0;x=d+r|0;if(x>>>0<d>>>0){b=b+1|0}s=x;z=_(z^s,b^C,24);U=z;x=K;M=x;C=b;$=d;b=g+oa|0;d=S;g=d+I|0;if(g>>>0<d>>>0){b=b+1|0}d=g+z|0;b=b+x|0;z=d;r=d>>>0<g>>>0?b+1|0:b;d=_($^d,r^h,16);h=K;b=h+C|0;s=d+s|0;if(s>>>0<d>>>0){b=b+1|0}I=s;g=s^U;U=b;g=_(g,b^M,63);s=K;x=p;C=f;M=p;b=F+ca|0;p=ba;F=p+V|0;if(F>>>0<p>>>0){b=b+1|0}p=M+F|0;b=b+f|0;M=p;f=p>>>0<F>>>0?b+1|0:b;F=_(p^N,f^y,32);y=x;p=K;b=L+p|0;x=D+F|0;if(x>>>0<D>>>0){b=b+1|0}L=_(y^x,b^C,24);y=L;C=K;N=C;D=b;V=F;b=f+ma|0;f=W;F=f+M|0;if(F>>>0<f>>>0){b=b+1|0}f=F+L|0;b=b+C|0;b=f>>>0<F>>>0?b+1|0:b;F=f;L=b;p=_(V^f,b^p,16);C=y;y=K;b=y+D|0;f=p;x=f+x|0;if(x>>>0<f>>>0){b=b+1|0}D=x;f=b;x=_(C^x,b^N,63);C=K;M=n;N=v;ha=l[o+204>>2];V=ha;$=w;b=v+P|0;n=n+H|0;if(n>>>0<H>>>0){b=b+1|0}ka=l[o+200>>2];w=n;n=ka+n|0;b=b+V|0;b=n>>>0<w>>>0?b+1|0:b;w=n;v=b;V=_($^n,b^E,32);H=f;f=d;d=K;b=O+d|0;n=T+V|0;if(n>>>0<T>>>0){b=b+1|0}T=_(n^M,b^N,24);M=T;O=K;N=O;P=n;E=b;fa=l[o+164>>2];$=fa;b=v+O|0;v=w+T|0;if(v>>>0<w>>>0){b=b+1|0}n=l[o+160>>2];w=n+v|0;b=b+$|0;T=w;O=w>>>0<v>>>0?b+1|0:b;w=_(w^V,O^d,16);b=E;E=K;b=b+E|0;d=w;v=d+P|0;if(v>>>0<d>>>0){b=b+1|0}P=v;d=b;M=_(v^M,b^N,63);b=K;N=b;v=b;V=f;b=B+ca|0;f=ba;B=f+ia|0;if(B>>>0<f>>>0){b=b+1|0}f=B+M|0;b=b+v|0;b=f>>>0<B>>>0?b+1|0:b;B=f;v=h;h=b;f=_(V^f,v^b,32);v=o;b=H;H=K;b=b+H|0;V=f+D|0;if(V>>>0<f>>>0){b=b+1|0}D=V;ia=_(M^D,b^N,24);$=ia;M=K;sa=M;N=D;V=b;D=f;b=h+ha|0;f=B+ka|0;if(f>>>0<B>>>0){b=b+1|0}h=f;f=f+ia|0;b=b+M|0;ia=f;B=f>>>0<h>>>0?b+1|0:b;D=_(D^f,B^H,16);M=K;b=M+V|0;f=D;h=f+N|0;if(h>>>0<f>>>0){b=b+1|0}N=h;f=b;h=_(h^$,b^sa,63);b=K;H=b;l[v+32>>2]=h;l[v+36>>2]=b;v=q;V=u;$=p;b=u+ja|0;p=c+q|0;if(p>>>0<c>>>0){b=b+1|0}c=p+z|0;b=b+r|0;b=c>>>0<z>>>0?b+1|0:b;z=c;p=b;c=_($^c,b^y,32);b=d;d=K;b=b+d|0;u=c+P|0;if(u>>>0<c>>>0){b=b+1|0}q=u;P=_(q^v,b^V,24);r=P;u=K;y=u;v=b;$=c;b=p+ma|0;c=W;p=c+z|0;if(p>>>0<c>>>0){b=b+1|0}c=p+P|0;b=b+u|0;V=c;u=c>>>0<p>>>0?b+1|0:b;p=_($^c,u^d,16);b=v;v=K;b=b+v|0;c=p;d=c+q|0;if(d>>>0<c>>>0){b=b+1|0}P=d;z=b;q=_(d^r,b^y,63);c=K;r=g;y=s;b=s+Y|0;d=g+i|0;if(d>>>0<g>>>0){b=b+1|0}d=d+F|0;b=b+L|0;g=d;i=d>>>0<F>>>0?b+1|0:b;d=_(d^w,i^E,32);b=k;k=K;b=b+k|0;s=d+R|0;if(s>>>0<d>>>0){b=b+1|0}w=s;s=b;E=_(w^r,b^y,24);r=E;b=K;L=b;F=b;y=d;b=i+Z|0;d=g+aa|0;if(d>>>0<g>>>0){b=b+1|0}g=d;d=d+E|0;b=b+F|0;ja=d;F=d>>>0<g>>>0?b+1|0:b;Y=_(y^d,F^k,16);E=K;b=s+E|0;d=w+Y|0;if(d>>>0<w>>>0){b=b+1|0}s=d;k=b;i=_(d^r,b^L,63);d=K;w=C;b=ta+w|0;g=x;x=G;C=g+x|0;if(C>>>0<x>>>0){b=b+1|0}x=C+T|0;b=b+O|0;L=x;r=t;t=x>>>0<T>>>0?b+1|0:b;r=_(x^da,r^t,32);y=g;g=K;b=U+g|0;x=r+I|0;if(x>>>0<I>>>0){b=b+1|0}I=w;w=b;I=_(y^x,I^b,24);y=I;b=K;R=b;C=b;O=r;b=t+qa|0;t=Q;r=t+L|0;if(r>>>0<t>>>0){b=b+1|0}t=r+I|0;b=b+C|0;C=t;r=t>>>0<r>>>0?b+1|0:b;T=_(O^t,r^g,16);L=K;b=w+L|0;g=x+T|0;if(g>>>0<x>>>0){b=b+1|0}x=g;I=b;t=_(g^y,b^R,63);g=K;w=o;y=q;R=c;b=B+ga|0;B=e+ia|0;if(B>>>0<e>>>0){b=b+1|0}q=B+q|0;b=b+c|0;O=q;q=q>>>0<B>>>0?b+1|0:b;c=_(O^T,q^L,32);U=K;b=U+k|0;s=c+s|0;if(s>>>0<c>>>0){b=b+1|0}k=s;B=b;T=_(k^y,b^R,24);b=K;L=b;s=b;b=q+oa|0;q=S;y=q+O|0;if(y>>>0<q>>>0){b=b+1|0}q=y+T|0;b=b+s|0;b=q>>>0<y>>>0?b+1|0:b;y=q;R=b;da=_(c^q,U^b,16);b=K;s=b;l[w+120>>2]=da;l[w+124>>2]=b;b=b+B|0;c=k+da|0;if(c>>>0<k>>>0){b=b+1|0}B=c;k=b;w=_(c^T,b^L,63);q=K;L=d;c=i;O=c;b=u+na|0;i=ea;u=i+V|0;if(u>>>0<i>>>0){b=b+1|0}i=O+u|0;b=b+d|0;T=i;d=i>>>0<u>>>0?b+1|0:b;D=_(i^D,d^M,32);u=c;c=K;b=I+c|0;i=x+D|0;if(i>>>0<x>>>0){b=b+1|0}L=_(u^i,b^L,24);O=L;u=K;U=u;x=b;M=D;b=d+ra|0;d=A;D=d+T|0;if(D>>>0<d>>>0){b=b+1|0}d=D+L|0;b=b+u|0;L=d;I=d>>>0<D>>>0?b+1|0:b;c=_(M^d,I^c,16);D=K;b=D+x|0;i=c+i|0;if(i>>>0<c>>>0){b=b+1|0}T=i;d=i^O;O=b;u=_(d,b^U,63);x=K;U=g;M=p;i=t;p=i;b=F+fa|0;d=n;t=d+ja|0;if(t>>>0<d>>>0){b=b+1|0}d=p+t|0;b=b+g|0;p=d;g=v;v=d>>>0<t>>>0?b+1|0:b;d=_(M^d,g^v,32);g=i;b=f;f=K;b=b+f|0;i=d+N|0;if(i>>>0<d>>>0){b=b+1|0}g=_(g^i,b^U,24);t=K;F=g;U=t;M=b;ja=l[o+132>>2];V=ja;$=d;b=v+t|0;d=g+p|0;if(d>>>0<p>>>0){b=b+1|0}t=l[o+128>>2];g=d;d=t+d|0;b=b+V|0;N=d;V=d>>>0<g>>>0?b+1|0:b;g=_($^d,V^f,16);p=F;F=K;b=F+M|0;d=g;f=d+i|0;if(f>>>0<d>>>0){b=b+1|0}d=b;p=_(p^f,b^U,63);v=K;U=H;b=H+la|0;i=h;h=X;H=i+h|0;if(H>>>0<h>>>0){b=b+1|0}h=C+H|0;b=b+r|0;b=h>>>0<C>>>0?b+1|0:b;H=b;C=_(h^Y,b^E,32);E=f;r=d;f=c;c=K;b=z+c|0;d=C+P|0;if(d>>>0<P>>>0){b=b+1|0}z=_(d^i,b^U,24);M=z;U=K;Y=U;i=d;P=b;ia=l[o+196>>2];$=ia;sa=C;b=H+U|0;d=h+z|0;if(d>>>0<h>>>0){b=b+1|0}C=l[o+192>>2];h=d;d=C+d|0;b=b+$|0;z=d;U=d>>>0<h>>>0?b+1|0:b;d=_(sa^d,U^c,16);H=M;b=P;P=K;b=b+P|0;c=d;h=c+i|0;if(h>>>0<c>>>0){b=b+1|0}M=h;c=b;Y=_(H^h,b^Y,63);b=K;$=b;h=b;H=f;b=R+ha|0;f=y+ka|0;if(f>>>0<y>>>0){b=b+1|0}i=f;f=f+Y|0;b=b+h|0;b=f>>>0<i>>>0?b+1|0:b;i=f;h=D;D=b;f=_(H^f,h^b,32);h=o;H=K;b=H+r|0;r=f+E|0;if(r>>>0<f>>>0){b=b+1|0}E=r;R=_(Y^r,b^$,24);Y=R;r=K;ha=r;y=b;$=f;b=D+ja|0;f=i+t|0;if(f>>>0<i>>>0){b=b+1|0}i=f;f=f+R|0;b=b+r|0;ka=f;r=f>>>0<i>>>0?b+1|0:b;D=_($^f,r^H,16);b=y;y=K;b=b+y|0;f=D;i=f+E|0;if(i>>>0<f>>>0){b=b+1|0}E=i;f=b;i=_(i^Y,b^ha,63);b=K;H=b;l[h+32>>2]=i;l[h+36>>2]=b;R=q;Y=c;$=g;b=q+na|0;h=w;c=ea;g=h+c|0;if(g>>>0<c>>>0){b=b+1|0}c=g+L|0;b=b+I|0;I=c;g=c>>>0<L>>>0?b+1|0:b;c=_($^c,g^F,32);F=h;h=K;b=h+Y|0;q=c+M|0;if(q>>>0<c>>>0){b=b+1|0}w=q;R=_(F^q,b^R,24);M=R;q=K;Y=q;F=w;L=b;w=c;b=g+ca|0;c=ba;g=c+I|0;if(g>>>0<c>>>0){b=b+1|0}c=g+R|0;b=b+q|0;I=c;R=c>>>0<g>>>0?b+1|0:b;w=_(w^c,R^h,16);b=L;L=K;b=b+L|0;c=w;g=c+F|0;if(g>>>0<c>>>0){b=b+1|0}F=g;h=b;q=_(g^M,b^Y,63);c=K;M=x;Y=d;b=x+ga|0;g=u;d=e;u=g+d|0;if(u>>>0<d>>>0){b=b+1|0}d=u+N|0;b=b+V|0;u=d;x=d>>>0<N>>>0?b+1|0:b;d=_(Y^d,x^P,32);P=g;g=K;b=g+k|0;B=d+B|0;if(B>>>0<d>>>0){b=b+1|0}k=B;B=b;M=_(P^k,b^M,24);N=M;b=K;Y=b;P=b;V=d;b=x+fa|0;d=n+u|0;if(d>>>0<u>>>0){b=b+1|0}n=d;d=d+M|0;b=b+P|0;ha=d;x=d>>>0<n>>>0?b+1|0:b;V=_(V^d,x^g,16);P=K;b=B+P|0;d=k+V|0;if(d>>>0<k>>>0){b=b+1|0}u=d;k=b;n=_(d^N,b^Y,63);d=K;B=v;b=v+ra|0;g=p;p=A;v=g+p|0;if(v>>>0<p>>>0){b=b+1|0}p=v+z|0;b=b+U|0;U=p;v=s;s=p>>>0<z>>>0?b+1|0:b;z=_(p^da,v^s,32);M=g;g=K;b=O+g|0;p=z+T|0;if(p>>>0<T>>>0){b=b+1|0}v=b;T=_(M^p,b^B,24);O=T;b=K;M=b;B=b;N=z;b=s+la|0;s=X;z=s+U|0;if(z>>>0<s>>>0){b=b+1|0}s=z+T|0;b=b+B|0;B=s;z=s>>>0<z>>>0?b+1|0:b;N=_(N^s,z^g,16);T=K;b=v+T|0;g=p+N|0;if(g>>>0<p>>>0){b=b+1|0}v=g;g=g^O;O=b;s=_(g,b^M,63);g=K;p=o;U=q;M=c;Y=N;N=q;b=r+qa|0;q=Q;r=q+ka|0;if(r>>>0<q>>>0){b=b+1|0}q=N+r|0;b=b+c|0;N=q;q=q>>>0<r>>>0?b+1|0:b;c=_(Y^N,q^T,32);Y=K;b=Y+k|0;u=c+u|0;if(u>>>0<c>>>0){b=b+1|0}r=b;M=_(u^U,b^M,24);b=K;T=b;k=b;b=q+ma|0;q=W;U=q+N|0;if(U>>>0<q>>>0){b=b+1|0}q=U+M|0;b=b+k|0;ka=q;U=q>>>0<U>>>0?b+1|0:b;da=_(c^q,Y^U,16);b=K;k=b;l[p+120>>2]=da;l[p+124>>2]=b;b=b+r|0;c=u+da|0;if(c>>>0<u>>>0){b=b+1|0}r=c;p=T;T=b;p=_(c^M,p^b,63);q=K;u=d;M=D;c=n;N=c;b=R+ta|0;n=G+I|0;if(n>>>0<I>>>0){b=b+1|0}D=n;n=N+n|0;b=b+d|0;I=n;d=n>>>0<D>>>0?b+1|0:b;D=_(M^n,d^y,32);y=c;c=K;b=O+c|0;n=v+D|0;if(n>>>0<v>>>0){b=b+1|0}v=u;u=b;y=_(y^n,v^b,24);R=y;b=K;O=b;v=b;M=D;b=d+Z|0;d=aa;D=d+I|0;if(D>>>0<d>>>0){b=b+1|0}d=D+y|0;b=b+v|0;v=d;D=d>>>0<D>>>0?b+1|0:b;d=_(M^d,D^c,16);I=K;b=u+I|0;c=d+n|0;if(c>>>0<n>>>0){b=b+1|0}y=c;c=c^R;R=b;n=_(c,b^O,63);u=K;O=s;M=g;N=w;b=x+oa|0;c=S;w=c+ha|0;if(w>>>0<c>>>0){b=b+1|0}c=w+s|0;b=b+g|0;g=c;w=c>>>0<w>>>0?b+1|0:b;c=_(N^c,w^L,32);b=f;f=K;b=b+f|0;x=c+E|0;if(x>>>0<c>>>0){b=b+1|0}s=x;L=_(s^O,b^M,24);O=L;x=K;M=x;E=b;N=c;b=w+ia|0;c=g+C|0;if(c>>>0<g>>>0){b=b+1|0}g=c;c=c+L|0;b=b+x|0;x=c;L=c>>>0<g>>>0?b+1|0:b;g=_(N^c,L^f,16);w=O;b=E;E=K;b=b+E|0;c=g;f=c+s|0;if(f>>>0<c>>>0){b=b+1|0}O=f;c=b;w=_(w^f,b^M,63);s=K;M=i;N=H;ha=l[o+156>>2];Y=ha;$=V;b=z+H|0;f=i+B|0;if(f>>>0<B>>>0){b=b+1|0}V=l[o+152>>2];i=f;f=V+f|0;b=b+Y|0;b=f>>>0<i>>>0?b+1|0:b;i=f;H=b;f=_($^f,b^P,32);B=c;c=K;b=c+h|0;F=f+F|0;if(F>>>0<f>>>0){b=b+1|0}h=F;z=_(h^M,b^N,24);M=z;N=K;Y=N;F=b;fa=l[o+236>>2];$=fa;sa=f;b=H+N|0;f=i+z|0;if(f>>>0<i>>>0){b=b+1|0}P=l[o+232>>2];i=f;f=P+f|0;b=b+$|0;H=f;z=f>>>0<i>>>0?b+1|0:b;c=_(sa^f,z^c,16);f=M;b=F;F=K;b=b+F|0;h=c+h|0;if(h>>>0<c>>>0){b=b+1|0}M=h;N=b;Y=_(f^h,b^Y,63);b=K;$=b;f=b;h=d;b=U+ga|0;d=e+ka|0;if(d>>>0<e>>>0){b=b+1|0}e=d+Y|0;b=b+f|0;U=e;f=e>>>0<d>>>0?b+1|0:b;e=_(h^e,f^I,32);d=o;h=K;b=h+B|0;B=e+O|0;if(B>>>0<e>>>0){b=b+1|0}i=B;O=_(Y^i,b^$,24);Y=O;B=K;ga=B;I=b;$=e;b=f+Z|0;e=aa;f=e+U|0;if(f>>>0<e>>>0){b=b+1|0}e=f+O|0;b=b+B|0;B=e;O=e>>>0<f>>>0?b+1|0:b;h=_($^e,O^h,16);b=I;I=K;b=b+I|0;e=h;f=e+i|0;if(f>>>0<e>>>0){b=b+1|0}U=f;e=f^Y;Y=b;f=_(e,b^ga,63);b=K;i=b;l[d+32>>2]=f;l[d+36>>2]=b;$=g;d=q;b=oa+d|0;e=p;g=S;p=e+g|0;if(p>>>0<g>>>0){b=b+1|0}g=p+v|0;b=b+D|0;D=g;g=g>>>0<v>>>0?b+1|0:b;v=_($^D,g^E,32);q=e;e=K;b=N+e|0;p=v+M|0;if(p>>>0<M>>>0){b=b+1|0}E=d;d=b;E=_(q^p,E^b,24);M=E;b=K;ga=b;q=b;N=v;b=g+ra|0;g=A;v=g+D|0;if(v>>>0<g>>>0){b=b+1|0}g=v+E|0;b=b+q|0;ka=g;v=g>>>0<v>>>0?b+1|0:b;N=_(N^g,v^e,16);D=K;b=d+D|0;e=p+N|0;if(e>>>0<p>>>0){b=b+1|0}E=e;d=e^M;M=b;p=_(d,b^ga,63);q=K;$=c;d=u;b=ja+d|0;e=n;c=t+e|0;if(c>>>0<t>>>0){b=b+1|0}c=c+x|0;b=b+L|0;b=c>>>0<x>>>0?b+1|0:b;g=b;u=_($^c,b^F,32);x=e;e=K;b=T+e|0;n=u+r|0;if(n>>>0<r>>>0){b=b+1|0}r=d;d=b;x=_(x^n,r^b,24);F=x;b=K;r=b;t=b;b=g+ta|0;g=c+G|0;if(g>>>0<c>>>0){b=b+1|0}c=g+x|0;b=b+t|0;ga=c;x=c^u;u=c>>>0<g>>>0?b+1|0:b;T=_(x,u^e,16);x=K;b=d+x|0;e=n+T|0;if(e>>>0<n>>>0){b=b+1|0}t=e;d=b;G=_(e^F,b^r,63);e=K;g=s;b=ia+g|0;c=w;n=C+c|0;if(n>>>0<C>>>0){b=b+1|0}n=n+H|0;b=b+z|0;C=n;s=k;k=n>>>0<H>>>0?b+1|0:b;s=_(n^da,s^k,32);w=c;c=K;b=R+c|0;n=s+y|0;if(n>>>0<y>>>0){b=b+1|0}r=g;g=b;H=_(w^n,r^b,24);F=H;b=K;z=b;w=b;r=s;b=k+ha|0;k=C+V|0;if(k>>>0<V>>>0){b=b+1|0}s=k;k=k+H|0;b=b+w|0;b=k>>>0<s>>>0?b+1|0:b;s=k;C=b;L=_(r^k,b^c,16);w=K;b=g+w|0;c=n+L|0;if(c>>>0<n>>>0){b=b+1|0}H=c;g=b;k=_(c^F,b^z,63);c=K;n=o;F=p;z=q;r=d;y=l[o+164>>2];b=q+O|0;d=p+B|0;if(d>>>0<B>>>0){b=b+1|0}p=d;d=d+l[o+160>>2]|0;b=b+y|0;B=d;q=w;w=d>>>0<p>>>0?b+1|0:b;d=_(d^L,q^w,32);b=r;r=K;b=b+r|0;p=d+t|0;if(p>>>0<d>>>0){b=b+1|0}q=b;z=_(p^F,b^z,24);b=K;F=b;t=b;b=w+fa|0;w=B+P|0;if(w>>>0<P>>>0){b=b+1|0}B=w;w=w+z|0;b=b+t|0;V=w;B=w>>>0<B>>>0?b+1|0:b;R=_(d^w,r^B,16);b=K;t=b;l[n+120>>2]=R;l[n+124>>2]=b;b=b+q|0;d=p+R|0;if(d>>>0<p>>>0){b=b+1|0}p=d;q=b;n=_(d^z,b^F,63);w=K;F=e;r=h;d=G;y=d;b=v+ca|0;h=ba;G=h+ka|0;if(G>>>0<h>>>0){b=b+1|0}h=y+G|0;b=b+e|0;P=h;h=h>>>0<G>>>0?b+1|0:b;e=_(r^P,h^I,32);v=d;d=K;b=d+g|0;G=e+H|0;if(G>>>0<e>>>0){b=b+1|0}g=G;H=_(v^g,b^F,24);z=H;G=K;r=G;v=b;y=e;b=h+na|0;e=ea;h=e+P|0;if(h>>>0<e>>>0){b=b+1|0}e=h+H|0;b=b+G|0;H=e;F=e>>>0<h>>>0?b+1|0:b;e=_(y^e,F^d,16);b=v;v=K;b=b+v|0;d=e;g=d+g|0;if(g>>>0<d>>>0){b=b+1|0}P=g;d=b;g=_(g^z,b^r,63);h=K;G=k;z=c;r=k;b=u+la|0;k=X;u=k+ga|0;if(u>>>0<k>>>0){b=b+1|0}k=r+u|0;b=b+c|0;L=k;c=k>>>0<u>>>0?b+1|0:b;r=_(k^N,c^D,32);y=G;k=K;b=Y+k|0;G=r+U|0;if(G>>>0<U>>>0){b=b+1|0}u=b;z=_(y^G,b^z,24);I=z;b=K;y=b;D=b;N=z;b=c+qa|0;c=Q;z=c+L|0;if(z>>>0<c>>>0){b=b+1|0}c=N+z|0;b=b+D|0;D=c;z=c>>>0<z>>>0?b+1|0:b;O=_(c^r,z^k,16);r=K;b=u+r|0;c=G+O|0;if(c>>>0<G>>>0){b=b+1|0}u=c;c=b;k=_(u^I,b^y,63);G=K;L=f;I=i;b=i+ma|0;f=W;i=L+f|0;if(i>>>0<f>>>0){b=b+1|0}f=i+s|0;b=b+C|0;b=f>>>0<s>>>0?b+1|0:b;i=b;y=_(f^T,b^x,32);s=c;c=K;b=M+c|0;x=E+y|0;if(x>>>0<E>>>0){b=b+1|0}C=b;E=_(x^L,b^I,24);I=E;b=K;U=b;L=l[o+204>>2];b=b+i|0;i=f+E|0;if(i>>>0<f>>>0){b=b+1|0}f=i+l[o+200>>2]|0;b=b+L|0;E=f;L=f>>>0<i>>>0?b+1|0:b;T=_(f^y,L^c,16);f=I;I=K;b=C+I|0;c=x+T|0;if(c>>>0<x>>>0){b=b+1|0}i=c;x=b;C=_(f^c,b^U,63);b=K;y=b;c=b;M=e;b=B+Z|0;e=aa;f=e+V|0;if(f>>>0<e>>>0){b=b+1|0}e=f+C|0;b=b+c|0;B=e;f=e>>>0<f>>>0?b+1|0:b;e=_(M^e,f^v,32);c=o;b=s;s=K;b=b+s|0;v=e+u|0;if(v>>>0<e>>>0){b=b+1|0}u=v;v=b;y=_(C^u,y^b,24);M=y;b=K;N=b;C=b;U=e;b=f+na|0;e=ea;f=e+B|0;if(f>>>0<e>>>0){b=b+1|0}e=f+y|0;b=b+C|0;C=e;y=s;s=e>>>0<f>>>0?b+1|0:b;U=_(U^e,y^s,16);B=K;b=v+B|0;e=u+U|0;if(e>>>0<u>>>0){b=b+1|0}u=e;v=b;e=_(e^M,b^N,63);b=K;f=b;l[c+32>>2]=e;l[c+36>>2]=b;y=w;b=w+ma|0;c=n;n=W;w=c+n|0;if(w>>>0<n>>>0){b=b+1|0}n=w+H|0;b=b+F|0;F=n;n=n>>>0<H>>>0?b+1|0:b;H=_(F^O,n^r,32);r=c;c=K;b=x+c|0;w=i+H|0;if(w>>>0<i>>>0){b=b+1|0}i=w;w=b;r=_(r^i,b^y,24);y=r;b=K;M=b;x=b;O=H;b=n+la|0;n=X;H=n+F|0;if(H>>>0<n>>>0){b=b+1|0}n=H+r|0;b=b+x|0;N=n;x=n>>>0<H>>>0?b+1|0:b;O=_(O^n,x^c,16);H=K;b=w+H|0;c=i+O|0;if(c>>>0<i>>>0){b=b+1|0}w=c;F=b;i=_(c^y,b^M,63);n=K;r=h;b=h+qa|0;c=g;g=Q;h=c+g|0;if(h>>>0<g>>>0){b=b+1|0}g=h+D|0;b=b+z|0;b=g>>>0<D>>>0?b+1|0:b;h=b;I=_(g^T,b^I,32);y=c;D=K;b=q+D|0;c=p+I|0;if(c>>>0<p>>>0){b=b+1|0}p=c;q=b;c=_(y^c,b^r,24);b=K;z=c;r=b;T=l[o+236>>2];y=I;b=h+b|0;c=c+g|0;if(c>>>0<g>>>0){b=b+1|0}g=c;c=c+l[o+232>>2]|0;b=b+T|0;I=c;h=D;D=c>>>0<g>>>0?b+1|0:b;M=_(y^c,h^D,16);h=z;z=K;b=q+z|0;c=p+M|0;if(c>>>0<p>>>0){b=b+1|0}p=c;g=b;h=_(h^c,b^r,63);c=K;q=k;y=d;T=l[o+164>>2];r=G;b=L+r|0;d=k+E|0;if(d>>>0<E>>>0){b=b+1|0}k=d;d=d+l[o+160>>2]|0;b=b+T|0;E=d;k=d>>>0<k>>>0?b+1|0:b;d=_(d^R,k^t,32);L=q;G=K;b=G+y|0;q=d+P|0;if(q>>>0<d>>>0){b=b+1|0}t=q;q=b;r=_(L^t,b^r,24);L=r;b=K;y=b;P=b;R=d;b=k+ra|0;d=A;k=d+E|0;if(k>>>0<d>>>0){b=b+1|0}d=k+r|0;b=b+P|0;V=d;P=d>>>0<k>>>0?b+1|0:b;R=_(R^d,P^G,16);E=K;b=q+E|0;d=t+R|0;if(d>>>0<t>>>0){b=b+1|0}q=d;d=b;k=_(q^L,b^y,63);G=K;t=o;r=i;L=n;y=g;T=l[o+132>>2];Y=R;b=n+s|0;g=i+C|0;if(g>>>0<C>>>0){b=b+1|0}i=g;g=g+l[o+128>>2]|0;b=b+T|0;R=g;i=g>>>0<i>>>0?b+1|0:b;g=_(Y^g,i^E,32);C=r;r=K;b=r+y|0;s=g+p|0;if(s>>>0<g>>>0){b=b+1|0}n=s;s=b;E=_(C^n,b^L,24);b=K;p=b;C=b;b=i+ca|0;i=ba;L=i+R|0;if(L>>>0<i>>>0){b=b+1|0}i=L+E|0;b=b+C|0;Y=i;C=i>>>0<L>>>0?b+1|0:b;T=_(g^i,r^C,16);b=K;g=b;l[t+120>>2]=T;l[t+124>>2]=b;b=b+s|0;i=n+T|0;if(i>>>0<n>>>0){b=b+1|0}s=i;n=p;p=b;i=_(i^E,n^b,63);n=K;t=h;E=c;r=d;y=h;b=x+oa|0;d=S;h=d+N|0;if(h>>>0<d>>>0){b=b+1|0}d=y+h|0;b=b+c|0;L=d;h=d>>>0<h>>>0?b+1|0:b;d=_(d^U,h^B,32);y=t;t=K;b=t+r|0;c=d;q=c+q|0;if(q>>>0<c>>>0){b=b+1|0}x=b;c=_(y^q,b^E,24);b=K;B=c;E=b;y=l[o+156>>2];R=d;b=h+b|0;d=c+L|0;if(d>>>0<c>>>0){b=b+1|0}c=d+l[o+152>>2]|0;b=b+y|0;r=c;L=c>>>0<d>>>0?b+1|0:b;R=_(R^c,L^t,16);t=K;b=x+t|0;c=q+R|0;if(c>>>0<q>>>0){b=b+1|0}q=c;x=b;d=_(c^B,b^E,63);h=K;E=l[o+204>>2];B=G;b=D+B|0;c=k;k=I+c|0;if(k>>>0<I>>>0){b=b+1|0}G=k;k=k+l[o+200>>2]|0;b=b+E|0;b=k>>>0<G>>>0?b+1|0:b;G=b;E=_(k^O,b^H,32);y=c;D=K;b=v+D|0;c=u+E|0;if(c>>>0<u>>>0){b=b+1|0}u=c;v=b;c=_(y^c,b^B,24);b=K;H=c;B=b;y=l[o+148>>2];I=E;b=G+b|0;c=c+k|0;if(c>>>0<k>>>0){b=b+1|0}k=c;c=c+l[o+144>>2]|0;b=b+y|0;E=c;y=D;D=c>>>0<k>>>0?b+1|0:b;O=_(I^c,y^D,16);k=H;H=K;b=v+H|0;c=u+O|0;if(c>>>0<u>>>0){b=b+1|0}u=b;k=_(k^c,b^B,63);G=K;v=e;B=f;I=l[o+196>>2];b=f+P|0;f=e+V|0;if(f>>>0<e>>>0){b=b+1|0}e=f+l[o+192>>2]|0;b=b+I|0;I=e;f=e>>>0<f>>>0?b+1|0:b;z=_(e^M,f^z,32);y=v;v=K;b=F+v|0;e=w+z|0;if(e>>>0<w>>>0){b=b+1|0}w=e;e=_(y^e,b^B,24);B=e;P=b;M=l[o+220>>2];U=M;y=z;F=K;b=F+f|0;f=e+I|0;if(f>>>0<e>>>0){b=b+1|0}z=l[o+216>>2];e=z+f|0;b=b+U|0;I=e;N=v;v=e>>>0<f>>>0?b+1|0:b;f=_(y^e,N^v,16);y=B;B=K;b=B+P|0;e=f;w=e+w|0;if(w>>>0<e>>>0){b=b+1|0}e=F;F=b;e=_(y^w,e^b,63);b=K;P=e;y=b;N=l[o+236>>2];b=C+b|0;C=e+Y|0;if(C>>>0<e>>>0){b=b+1|0}e=C+l[o+232>>2]|0;b=b+N|0;N=e;U=t;t=e>>>0<C>>>0?b+1|0:b;U=_(e^R,U^t,32);C=K;b=u+C|0;e=c+U|0;if(e>>>0<c>>>0){b=b+1|0}u=e;c=e^P;P=b;e=_(c,b^y,24);b=K;c=o;y=e;R=b;b=t+b|0;t=e+N|0;if(t>>>0<e>>>0){b=b+1|0}e=t+z|0;b=b+M|0;M=e;t=C;C=e>>>0<z>>>0?b+1|0:b;U=_(e^U,t^C,16);z=K;b=P+z|0;e=u+U|0;if(e>>>0<u>>>0){b=b+1|0}u=e;P=b;e=_(e^y,b^R,63);b=K;t=b;l[c+32>>2]=e;l[c+36>>2]=b;y=n;b=n+ca|0;c=i;i=ba;n=c+i|0;if(n>>>0<i>>>0){b=b+1|0}i=n+r|0;b=b+L|0;L=i;i=i>>>0<r>>>0?b+1|0:b;r=_(L^O,i^H,32);H=c;c=K;b=F+c|0;n=w+r|0;if(n>>>0<w>>>0){b=b+1|0}w=b;F=_(H^n,b^y,24);R=F;b=K;O=b;H=b;y=F;b=i+qa|0;i=Q;F=i+L|0;if(F>>>0<i>>>0){b=b+1|0}i=y+F|0;b=b+H|0;N=i;H=i>>>0<F>>>0?b+1|0:b;y=_(i^r,H^c,16);F=K;b=w+F|0;c=n+y|0;if(c>>>0<n>>>0){b=b+1|0}r=c;L=b;i=_(c^R,b^O,63);c=K;n=d;w=h;R=f;b=h+Z|0;d=aa;f=n+d|0;if(f>>>0<d>>>0){b=b+1|0}d=f+E|0;b=b+D|0;b=d>>>0<E>>>0?b+1|0:b;E=d;d=b;D=_(R^E,b^B,32);f=K;b=p+f|0;h=s+D|0;if(h>>>0<s>>>0){b=b+1|0}s=h^n;n=b;s=_(s,b^w,24);B=s;b=K;O=b;w=b;p=s;b=d+ma|0;d=W;s=d+E|0;if(s>>>0<d>>>0){b=b+1|0}d=p+s|0;b=b+w|0;b=d>>>0<s>>>0?b+1|0:b;s=d;p=b;R=_(d^D,b^f,16);D=K;b=n+D|0;d=h+R|0;if(d>>>0<h>>>0){b=b+1|0}n=d;w=b;f=_(d^B,b^O,63);d=K;E=l[o+156>>2];B=G;b=v+B|0;h=k;k=I+h|0;if(k>>>0<I>>>0){b=b+1|0}G=k;k=k+l[o+152>>2]|0;b=b+E|0;b=k>>>0<G>>>0?b+1|0:b;G=b;E=_(k^T,b^g,32);v=h;h=K;b=x+h|0;g=q+E|0;if(g>>>0<q>>>0){b=b+1|0}q=g;x=b;g=_(v^g,b^B,24);b=K;v=g;B=b;T=l[o+204>>2];b=G+b|0;g=g+k|0;if(g>>>0<k>>>0){b=b+1|0}k=g;g=g+l[o+200>>2]|0;b=b+T|0;V=g;I=g^E;E=g>>>0<k>>>0?b+1|0:b;I=_(I,E^h,16);G=K;b=x+G|0;g=q+I|0;if(g>>>0<q>>>0){b=b+1|0}q=g;x=b;g=_(g^v,b^B,63);k=K;h=o;v=i;B=c;O=i;b=C+na|0;i=ea;C=i+M|0;if(C>>>0<i>>>0){b=b+1|0}i=O+C|0;b=b+c|0;c=i;i=G;G=c>>>0<C>>>0?b+1|0:b;C=_(c^I,i^G,32);I=K;b=w+I|0;i=n+C|0;if(i>>>0<n>>>0){b=b+1|0}n=b;B=_(i^v,b^B,24);w=K;b=G+w|0;G=c+B|0;if(G>>>0<c>>>0){b=b+1|0}c=G;G=l[o+128>>2];c=c+G|0;b=l[o+132>>2]+b|0;M=c;v=c>>>0<G>>>0?b+1|0:b;T=_(C^c,I^v,16);b=K;G=b;l[h+120>>2]=T;l[h+124>>2]=b;b=n+b|0;c=i+T|0;if(c>>>0<i>>>0){b=b+1|0}C=c;c=c^B;B=b;h=_(c,b^w,63);i=K;n=d;c=f;I=c;b=H+la|0;f=X;w=f+N|0;if(w>>>0<f>>>0){b=b+1|0}f=I+w|0;b=b+d|0;I=f;d=f>>>0<w>>>0?b+1|0:b;H=_(f^U,d^z,32);z=c;f=K;b=x+f|0;c=q+H|0;if(c>>>0<q>>>0){b=b+1|0}w=c;q=n;n=b;c=_(z^c,q^b,24);b=K;q=c;x=b;O=l[o+164>>2];N=H;b=d+b|0;d=c+I|0;if(d>>>0<c>>>0){b=b+1|0}c=d+l[o+160>>2]|0;b=b+O|0;H=c;z=c>>>0<d>>>0?b+1|0:b;d=_(N^c,z^f,16);I=q;f=K;b=n+f|0;c=d+w|0;if(c>>>0<w>>>0){b=b+1|0}q=c;n=x;x=b;n=_(I^c,n^b,63);w=K;I=k;O=l[o+196>>2];N=y;b=k+p|0;c=g;g=s+c|0;if(g>>>0<s>>>0){b=b+1|0}k=g;g=g+l[o+192>>2]|0;b=b+O|0;y=g;g=g>>>0<k>>>0?b+1|0:b;F=_(N^y,g^F,32);p=c;c=K;b=P+c|0;k=u+F|0;if(k>>>0<u>>>0){b=b+1|0}s=b;u=_(p^k,b^I,24);P=u;b=K;I=b;p=b;N=u;b=g+oa|0;g=S;u=g+y|0;if(u>>>0<g>>>0){b=b+1|0}g=N+u|0;b=b+p|0;p=g;u=g>>>0<u>>>0?b+1|0:b;O=_(g^F,u^c,16);F=K;b=s+F|0;c=k+O|0;if(c>>>0<k>>>0){b=b+1|0}s=c;c=b;g=_(s^P,b^I,63);k=K;P=e;I=t;y=l[o+148>>2];N=R;b=t+E|0;t=e+V|0;if(t>>>0<e>>>0){b=b+1|0}e=t+l[o+144>>2]|0;b=b+y|0;R=e;e=e>>>0<t>>>0?b+1|0:b;y=_(N^R,e^D,32);t=c;c=K;b=L+c|0;D=r+y|0;if(D>>>0<r>>>0){b=b+1|0}r=D^P;P=b;r=_(r,b^I,24);L=r;b=K;I=b;E=b;N=r;b=e+ra|0;e=A;r=e+R|0;if(r>>>0<e>>>0){b=b+1|0}e=N+r|0;b=b+E|0;E=e;r=e>>>0<r>>>0?b+1|0:b;U=_(e^y,r^c,16);c=L;L=K;b=P+L|0;e=D+U|0;if(e>>>0<D>>>0){b=b+1|0}D=e;P=b;I=_(c^e,b^I,63);b=K;y=b;e=b;N=d;b=v+oa|0;c=S;d=c+M|0;if(d>>>0<c>>>0){b=b+1|0}c=d+I|0;b=b+e|0;R=c;d=c>>>0<d>>>0?b+1|0:b;e=_(N^c,d^f,32);c=o;f=K;b=f+t|0;s=e+s|0;if(s>>>0<e>>>0){b=b+1|0}t=s;s=b;I=_(I^t,y^b,24);y=I;b=K;N=b;v=b;M=e;b=d+la|0;e=X;d=e+R|0;if(d>>>0<e>>>0){b=b+1|0}e=d+I|0;b=b+v|0;ga=e;v=e>>>0<d>>>0?b+1|0:b;M=_(M^e,v^f,16);d=y;I=K;b=s+I|0;e=t+M|0;if(e>>>0<t>>>0){b=b+1|0}y=e;R=b;f=_(d^e,b^N,63);b=K;t=b;l[c+32>>2]=f;l[c+36>>2]=b;c=i;b=qa+c|0;e=h;d=Q;h=e+d|0;if(h>>>0<d>>>0){b=b+1|0}d=h+H|0;b=b+z|0;b=d>>>0<H>>>0?b+1|0:b;h=b;F=_(d^O,b^F,32);z=e;i=K;b=P+i|0;e=D+F|0;if(e>>>0<D>>>0){b=b+1|0}s=e;D=c;c=b;e=_(z^e,D^b,24);b=K;D=e;H=b;z=l[o+204>>2];b=h+b|0;e=d+e|0;if(e>>>0<d>>>0){b=b+1|0}d=e;e=d+l[o+200>>2]|0;b=b+z|0;O=e;h=e^F;F=e>>>0<d>>>0?b+1|0:b;V=_(h,F^i,16);d=D;D=K;b=c+D|0;e=s+V|0;if(e>>>0<s>>>0){b=b+1|0}P=e;c=H;H=b;h=_(d^e,c^b,63);e=K;s=l[o+220>>2];d=w;b=u+d|0;c=n;i=p+c|0;if(i>>>0<p>>>0){b=b+1|0}n=i;i=i+l[o+216>>2]|0;b=b+s|0;b=i>>>0<n>>>0?b+1|0:b;n=b;z=_(i^U,b^L,32);p=c;w=K;b=B+w|0;c=z+C|0;if(c>>>0<C>>>0){b=b+1|0}s=c;u=d;d=b;c=_(p^c,u^b,24);b=K;p=c;u=b;B=l[o+156>>2];b=n+b|0;c=c+i|0;if(c>>>0<i>>>0){b=b+1|0}i=c;c=c+l[o+152>>2]|0;b=b+B|0;U=c;C=c>>>0<i>>>0?b+1|0:b;Y=_(c^z,C^w,16);B=K;b=d+B|0;c=s+Y|0;if(c>>>0<s>>>0){b=b+1|0}n=c;w=b;c=_(c^p,b^u,63);i=K;s=k;p=l[o+132>>2];b=k+r|0;d=g;g=E+d|0;if(g>>>0<E>>>0){b=b+1|0}k=g;g=g+l[o+128>>2]|0;b=b+p|0;b=g>>>0<k>>>0?b+1|0:b;k=b;z=_(g^T,b^G,32);u=d;G=K;b=x+G|0;d=q+z|0;if(d>>>0<q>>>0){b=b+1|0}p=d;q=s;s=b;d=_(u^d,q^b,24);b=K;q=d;u=b;E=l[o+196>>2];b=k+b|0;d=d+g|0;if(d>>>0<g>>>0){b=b+1|0}g=d;d=d+l[o+192>>2]|0;b=b+E|0;x=d;k=d^z;z=d>>>0<g>>>0?b+1|0:b;E=_(k,z^G,16);G=K;b=s+G|0;d=p+E|0;if(d>>>0<p>>>0){b=b+1|0}s=d;p=b;k=_(d^q,b^u,63);d=K;g=o;q=h;u=e;r=h;b=v+Z|0;h=aa;v=h+ga|0;if(v>>>0<h>>>0){b=b+1|0}h=r+v|0;b=b+e|0;e=h;h=G;G=e>>>0<v>>>0?b+1|0:b;r=_(e^E,h^G,32);T=K;b=w+T|0;h=n+r|0;if(h>>>0<n>>>0){b=b+1|0}n=h;w=b;L=_(h^q,b^u,24);q=o;h=l[o+144>>2];u=K;b=G+u|0;G=e+L|0;if(G>>>0<e>>>0){b=b+1|0}e=h;G=e+G|0;v=l[q+148>>2];b=v+b|0;E=G;q=r^E;r=E>>>0<e>>>0?b+1|0:b;N=_(q,T^r,16);b=K;G=b;l[g+120>>2]=N;l[g+124>>2]=b;q=L;b=w+b|0;e=n+N|0;if(e>>>0<n>>>0){b=b+1|0}L=e;g=b;n=_(q^e,b^u,63);w=K;e=c;q=i;u=l[o+236>>2];b=i+F|0;i=c+O|0;if(i>>>0<c>>>0){b=b+1|0}c=i+l[o+232>>2]|0;b=b+u|0;F=c;c=c>>>0<i>>>0?b+1|0:b;u=_(F^M,c^I,32);I=e;e=K;b=p+e|0;i=u+s|0;if(i>>>0<s>>>0){b=b+1|0}s=b;q=_(I^i,b^q,24);I=q;b=K;O=b;p=b;M=u;u=q;b=c+ca|0;c=ba;q=c+F|0;if(q>>>0<c>>>0){b=b+1|0}c=u+q|0;b=b+p|0;u=c;F=c>>>0<q>>>0?b+1|0:b;c=_(M^c,F^e,16);p=I;I=K;b=s+I|0;e=c+i|0;if(e>>>0<i>>>0){b=b+1|0}T=e;s=O;O=b;i=_(p^e,s^b,63);s=K;p=d;e=k;M=e;b=C+ma|0;k=W;q=k+U|0;if(q>>>0<k>>>0){b=b+1|0}k=M+q|0;b=b+d|0;d=k;k=d>>>0<q>>>0?b+1|0:b;M=_(d^V,k^D,32);D=e;q=K;b=R+q|0;e=y+M|0;if(e>>>0<y>>>0){b=b+1|0}C=e;e=_(D^e,b^p,24);D=e;y=b;b=l[o+164>>2];R=b;U=b;p=K;b=k+p|0;e=d+e|0;if(e>>>0<d>>>0){b=b+1|0}ga=l[o+160>>2];d=e;e=ga+d|0;b=b+U|0;U=e;k=e^M;M=e>>>0<d>>>0?b+1|0:b;k=_(k,M^q,16);q=D;D=K;b=D+y|0;e=k;d=e+C|0;if(d>>>0<e>>>0){b=b+1|0}e=b;p=_(q^d,b^p,63);q=K;C=f;y=t;b=t+ra|0;f=A;t=C+f|0;if(t>>>0<f>>>0){b=b+1|0}f=t+x|0;b=b+z|0;z=f;f=f>>>0<x>>>0?b+1|0:b;B=_(z^Y,f^B,32);t=K;b=H+t|0;x=B+P|0;if(x>>>0<P>>>0){b=b+1|0}H=x^C;C=b;P=_(H,b^y,24);V=P;b=K;Y=b;H=b;y=B;b=f+na|0;f=ea;B=f+z|0;if(B>>>0<f>>>0){b=b+1|0}f=B+P|0;b=b+H|0;H=f;z=t;t=f>>>0<B>>>0?b+1|0:b;y=_(y^f,z^t,16);B=K;b=C+B|0;f=x+y|0;if(f>>>0<x>>>0){b=b+1|0}x=b;V=_(f^V,b^Y,63);b=K;Y=b;C=b;z=c;b=r+ra|0;A=A+E|0;if(A>>>0<E>>>0){b=b+1|0}c=A;A=c+V|0;b=b+C|0;C=A;P=A>>>0<c>>>0?b+1|0:b;A=_(z^A,P^I,32);z=K;b=z+e|0;e=A;c=e+d|0;if(c>>>0<e>>>0){b=b+1|0}d=c;E=b;e=_(V^c,Y^b,24);b=K;c=o;r=e;I=b;V=A;b=P+b|0;A=e+C|0;if(A>>>0<C>>>0){b=b+1|0}e=A;A=e+h|0;b=b+v|0;Y=A;v=A>>>0<e>>>0?b+1|0:b;V=_(V^A,v^z,16);C=K;b=E+C|0;A=d+V|0;if(A>>>0<d>>>0){b=b+1|0}P=A;d=b;A=_(A^r,b^I,63);b=K;h=b;l[c+32>>2]=A;l[c+36>>2]=b;z=l[o+196>>2];r=k;c=w;b=F+c|0;e=n;k=u+e|0;if(k>>>0<u>>>0){b=b+1|0}n=k;k=k+l[o+192>>2]|0;b=b+z|0;F=k;k=k>>>0<n>>>0?b+1|0:b;D=_(r^F,k^D,32);w=e;n=K;b=x+n|0;e=f+D|0;if(e>>>0<f>>>0){b=b+1|0}f=e;x=c;c=b;e=_(w^e,x^b,24);b=K;w=e;u=b;b=k+b|0;k=e+F|0;if(k>>>0<e>>>0){b=b+1|0}e=k+ga|0;b=b+R|0;I=e;x=e>>>0<k>>>0?b+1|0:b;R=_(e^D,x^n,16);D=K;b=c+D|0;e=f+R|0;if(e>>>0<f>>>0){b=b+1|0}F=e;f=b;k=_(e^w,b^u,63);e=K;n=i;w=s;b=ca+w|0;c=ba;i=c+i|0;if(i>>>0<c>>>0){b=b+1|0}c=i+U|0;b=b+M|0;u=c;i=c>>>0<U>>>0?b+1|0:b;c=_(c^y,i^B,32);r=n;b=g;g=K;b=b+g|0;s=c+L|0;if(s>>>0<c>>>0){b=b+1|0}n=s;s=w;w=b;B=_(r^n,s^b,24);z=B;b=K;E=b;s=b;r=c;b=i+oa|0;c=S;i=c+u|0;if(i>>>0<c>>>0){b=b+1|0}c=i+B|0;b=b+s|0;s=c;u=c>>>0<i>>>0?b+1|0:b;y=_(r^c,u^g,16);B=K;b=w+B|0;c=n+y|0;if(c>>>0<n>>>0){b=b+1|0}w=c;g=b;c=_(c^z,b^E,63);i=K;z=q;b=q+ma|0;n=p;p=W;q=n+p|0;if(q>>>0<p>>>0){b=b+1|0}p=q+H|0;b=b+t|0;E=p;q=G;G=p>>>0<H>>>0?b+1|0:b;H=_(p^N,q^G,32);q=n;n=K;b=O+n|0;t=H+T|0;if(t>>>0<T>>>0){b=b+1|0}p=b;z=_(q^t,b^z,24);r=z;b=K;T=b;q=b;L=H;b=G+na|0;G=ea;H=G+E|0;if(H>>>0<G>>>0){b=b+1|0}G=H+z|0;b=b+q|0;U=G;q=G>>>0<H>>>0?b+1|0:b;L=_(L^G,q^n,16);H=K;b=p+H|0;G=t+L|0;if(G>>>0<t>>>0){b=b+1|0}p=G;z=b;G=_(p^r,b^T,63);n=K;t=o;E=k;r=e;M=k;b=v+la|0;k=X;v=k+Y|0;if(v>>>0<k>>>0){b=b+1|0}k=M+v|0;b=b+e|0;b=k>>>0<v>>>0?b+1|0:b;v=b;e=_(k^L,b^H,32);L=K;b=L+g|0;w=e+w|0;if(w>>>0<e>>>0){b=b+1|0}T=w;w=b;E=_(T^E,b^r,24);H=K;b=v+H|0;g=k+E|0;if(g>>>0<k>>>0){b=b+1|0}k=l[o+216>>2];g=k+g|0;b=l[o+220>>2]+b|0;M=g;v=g>>>0<k>>>0?b+1|0:b;g=_(e^g,L^v,16);b=K;k=b;l[t+120>>2]=g;l[t+124>>2]=b;r=E;b=b+w|0;e=g;t=e+T|0;if(t>>>0<e>>>0){b=b+1|0}E=t;e=H;H=b;e=_(r^t,e^b,63);t=K;w=c;r=i;L=l[o+204>>2];b=i+x|0;i=c+I|0;if(i>>>0<c>>>0){b=b+1|0}c=i+l[o+200>>2]|0;b=b+L|0;L=c;c=c>>>0<i>>>0?b+1|0:b;C=_(L^V,c^C,32);x=w;i=K;b=z+i|0;w=p+C|0;if(w>>>0<p>>>0){b=b+1|0}p=b;z=_(x^w,b^r,24);r=z;b=K;I=b;x=b;O=C;b=c+qa|0;c=Q;C=c+L|0;if(C>>>0<c>>>0){b=b+1|0}c=C+z|0;b=b+x|0;N=c;x=c>>>0<C>>>0?b+1|0:b;T=_(O^c,x^i,16);C=K;b=p+C|0;c=w+T|0;if(c>>>0<w>>>0){b=b+1|0}p=c;c=b;i=_(p^r,b^I,63);w=K;r=n;L=d;b=l[o+156>>2];I=b;d=b;O=R;b=n+u|0;z=G;G=s+z|0;if(G>>>0<s>>>0){b=b+1|0}V=l[o+152>>2];n=G;G=V+n|0;b=b+d|0;R=G;G=G>>>0<n>>>0?b+1|0:b;d=_(O^R,G^D,32);n=K;b=n+L|0;u=d+P|0;if(u>>>0<d>>>0){b=b+1|0}s=u;u=b;P=_(s^z,b^r,24);z=P;b=K;r=b;D=b;L=d;b=G+Z|0;d=aa;G=d+R|0;if(G>>>0<d>>>0){b=b+1|0}d=G+P|0;b=b+D|0;D=d;P=d>>>0<G>>>0?b+1|0:b;O=_(L^d,P^n,16);L=z;z=K;b=u+z|0;d=s+O|0;if(d>>>0<s>>>0){b=b+1|0}n=d;s=b;d=_(L^d,b^r,63);G=K;u=A;r=h;L=f;f=l[o+236>>2];R=y;b=h+q|0;h=u+U|0;if(h>>>0<u>>>0){b=b+1|0}A=h+l[o+232>>2]|0;b=b+f|0;y=A;h=A>>>0<h>>>0?b+1|0:b;f=_(R^A,h^B,32);A=u;q=K;b=q+L|0;u=f+F|0;if(u>>>0<f>>>0){b=b+1|0}A=_(A^u,b^r,24);B=A;r=b;R=l[o+132>>2];U=R;Y=f;F=K;b=F+h|0;h=A+y|0;if(h>>>0<A>>>0){b=b+1|0}f=l[o+128>>2];A=f+h|0;b=b+U|0;L=A;y=q;q=A>>>0<h>>>0?b+1|0:b;h=_(Y^A,y^q,16);A=B;B=K;b=B+r|0;u=h+u|0;if(u>>>0<h>>>0){b=b+1|0}r=F;F=b;A=_(A^u,r^b,63);b=K;r=A;y=b;U=T;b=v+b|0;v=A+M|0;if(v>>>0<A>>>0){b=b+1|0}A=f+v|0;b=b+R|0;T=A;f=A>>>0<f>>>0?b+1|0:b;R=_(U^A,f^C,32);A=o;v=K;b=s+v|0;s=n+R|0;if(s>>>0<n>>>0){b=b+1|0}n=s;s=b;r=_(n^r,b^y,24);y=r;b=K;M=b;C=b;U=r;b=f+ma|0;f=W;r=f+T|0;if(r>>>0<f>>>0){b=b+1|0}f=U+r|0;b=b+C|0;C=f;U=v;v=f>>>0<r>>>0?b+1|0:b;U=_(f^R,U^v,16);T=y;r=K;b=s+r|0;f=n+U|0;if(f>>>0<n>>>0){b=b+1|0}y=f;R=b;f=_(T^f,b^M,63);b=K;n=b;l[A+32>>2]=f;l[A+36>>2]=b;A=e;s=t;T=l[o+148>>2];b=t+x|0;t=e+N|0;if(t>>>0<e>>>0){b=b+1|0}e=t+l[o+144>>2]|0;b=b+T|0;T=e;e=e>>>0<t>>>0?b+1|0:b;z=_(T^O,e^z,32);x=A;t=K;b=F+t|0;A=u+z|0;if(A>>>0<u>>>0){b=b+1|0}u=A;A=s;s=b;A=_(x^u,A^b,24);b=K;x=A;F=b;b=e+b|0;e=x+T|0;if(e>>>0<x>>>0){b=b+1|0}A=e+V|0;b=b+I|0;M=A;I=A^z;z=A>>>0<e>>>0?b+1|0:b;I=_(I,z^t,16);e=x;x=K;b=s+x|0;A=u+I|0;if(A>>>0<u>>>0){b=b+1|0}u=A;s=F;F=b;t=_(e^u,s^b,63);s=K;A=i;T=l[o+164>>2];N=h;e=w;b=P+e|0;h=i+D|0;if(h>>>0<D>>>0){b=b+1|0}i=h;h=i+l[o+160>>2]|0;b=b+T|0;P=h;h=h>>>0<i>>>0?b+1|0:b;D=_(N^P,h^B,32);w=A;A=K;b=H+A|0;i=D+E|0;if(i>>>0<E>>>0){b=b+1|0}B=e;e=b;H=_(w^i,B^b,24);B=H;b=K;E=b;w=b;O=D;b=h+na|0;h=ea;D=h+P|0;if(D>>>0<h>>>0){b=b+1|0}h=D+H|0;b=b+w|0;N=h;w=h>>>0<D>>>0?b+1|0:b;O=_(O^h,w^A,16);D=K;b=e+D|0;A=i+O|0;if(A>>>0<i>>>0){b=b+1|0}i=A;H=b;A=_(i^B,b^E,63);h=K;B=d;P=G;b=G+oa|0;e=S;d=e+d|0;if(d>>>0<e>>>0){b=b+1|0}e=d+L|0;b=b+q|0;q=e;d=e>>>0<L>>>0?b+1|0:b;e=_(e^g,d^k,32);b=c;c=K;b=b+c|0;k=e+p|0;if(k>>>0<e>>>0){b=b+1|0}g=k;k=b;p=_(g^B,b^P,24);B=p;b=K;P=b;G=b;E=e;b=d+ca|0;e=ba;d=e+q|0;if(d>>>0<e>>>0){b=b+1|0}e=d+p|0;b=b+G|0;p=e;q=e>>>0<d>>>0?b+1|0:b;E=_(E^e,q^c,16);c=B;G=K;b=k+G|0;e=g+E|0;if(e>>>0<g>>>0){b=b+1|0}B=e;d=b;g=_(c^e,b^P,63);e=K;P=s;c=o;L=l[c+196>>2];b=s+v|0;k=t;t=C+k|0;if(t>>>0<C>>>0){b=b+1|0}s=t;t=t+l[c+192>>2]|0;b=b+L|0;b=t>>>0<s>>>0?b+1|0:b;s=G;G=b;C=_(t^E,s^b,32);v=k;E=K;b=H+E|0;k=i+C|0;if(k>>>0<i>>>0){b=b+1|0}i=k;s=b;H=_(v^i,b^P,24);v=K;b=G+v|0;k=t+H|0;if(k>>>0<t>>>0){b=b+1|0}G=l[o+200>>2];k=G+k|0;b=l[o+204>>2]+b|0;V=k;t=k>>>0<G>>>0?b+1|0:b;T=_(C^k,E^t,16);b=K;k=b;l[c+120>>2]=T;l[c+124>>2]=b;b=b+s|0;c=i+T|0;if(c>>>0<i>>>0){b=b+1|0}s=c;i=v;v=b;c=_(c^H,i^b,63);G=K;C=h;H=d;Y=l[o+212>>2];d=Y;b=h+z|0;i=A;h=i+M|0;if(h>>>0<i>>>0){b=b+1|0}P=l[o+208>>2];A=P+h|0;b=b+d|0;E=A;h=A>>>0<h>>>0?b+1|0:b;d=_(A^U,h^r,32);r=i;i=K;b=i+H|0;H=d+B|0;if(H>>>0<d>>>0){b=b+1|0}A=C;C=b;A=_(r^H,A^b,24);b=K;B=A;z=b;L=l[o+220>>2];r=d;b=h+b|0;d=A+E|0;if(d>>>0<A>>>0){b=b+1|0}A=d+l[o+216>>2]|0;b=b+L|0;U=A;E=A>>>0<d>>>0?b+1|0:b;d=_(r^A,E^i,16);h=B;B=K;b=C+B|0;A=d+H|0;if(A>>>0<H>>>0){b=b+1|0}C=A;H=b;h=_(h^A,b^z,63);i=K;A=g;z=e;r=I;I=g;b=w+Z|0;g=aa;w=g+N|0;if(w>>>0<g>>>0){b=b+1|0}g=I+w|0;b=b+e|0;I=g;e=g>>>0<w>>>0?b+1|0:b;L=_(r^g,e^x,32);r=A;g=K;b=R+g|0;A=y+L|0;if(A>>>0<y>>>0){b=b+1|0}w=A;x=b;A=_(r^w,b^z,24);b=K;z=A;r=b;R=l[o+236>>2];y=L;b=e+b|0;e=A+I|0;if(e>>>0<A>>>0){b=b+1|0}A=e+l[o+232>>2]|0;b=b+R|0;L=A;I=A>>>0<e>>>0?b+1|0:b;y=_(y^A,I^g,16);g=z;z=K;b=x+z|0;A=w+y|0;if(A>>>0<w>>>0){b=b+1|0}e=A;w=b;A=_(g^e,b^r,63);g=K;x=f;r=n;b=n+qa|0;f=Q;n=x+f|0;if(n>>>0<f>>>0){b=b+1|0}f=n+p|0;b=b+q|0;R=f;f=f>>>0<p>>>0?b+1|0:b;D=_(R^O,f^D,32);n=K;b=F+n|0;p=u+D|0;if(p>>>0<u>>>0){b=b+1|0}q=b;x=_(p^x,b^r,24);F=x;b=K;O=b;u=b;r=x;b=f+la|0;f=X;x=f+R|0;if(x>>>0<f>>>0){b=b+1|0}f=r+x|0;b=b+u|0;R=f;f=f>>>0<x>>>0?b+1|0:b;r=_(R^D,f^n,16);n=K;b=q+n|0;q=p+r|0;if(q>>>0<p>>>0){b=b+1|0}p=q;q=b;x=_(p^F,b^O,63);b=K;D=b;u=b;F=d;b=t+qa|0;d=Q+V|0;if(d>>>0<Q>>>0){b=b+1|0}Q=d+x|0;b=b+u|0;O=Q;d=Q>>>0<d>>>0?b+1|0:b;F=_(F^Q,d^B,32);t=K;b=w+t|0;Q=e+F|0;if(Q>>>0<e>>>0){b=b+1|0}w=Q;u=b;Q=_(x^w,D^b,24);b=K;e=o;D=b;b=d+b|0;x=Q;d=x+O|0;if(d>>>0<x>>>0){b=b+1|0}Q=d+P|0;b=b+Y|0;O=Q;d=t;t=Q>>>0<P>>>0?b+1|0:b;B=_(Q^F,d^t,16);d=x;x=K;b=u+x|0;Q=w+B|0;if(Q>>>0<w>>>0){b=b+1|0}w=Q;u=b;Q=_(d^w,b^D,63);b=K;d=b;l[e+32>>2]=Q;l[e+36>>2]=b;e=c;F=l[o+164>>2];D=G;b=D+E|0;G=c+U|0;if(G>>>0<c>>>0){b=b+1|0}c=G+l[o+160>>2]|0;b=b+F|0;E=c;c=c>>>0<G>>>0?b+1|0:b;P=_(E^y,c^z,32);y=e;G=K;b=q+G|0;e=p+P|0;if(e>>>0<p>>>0){b=b+1|0}p=e;q=b;e=_(y^e,b^D,24);b=K;D=e;F=b;y=l[o+196>>2];b=c+b|0;c=e+E|0;if(c>>>0<e>>>0){b=b+1|0}e=c+l[o+192>>2]|0;b=b+y|0;y=e;z=G;G=e>>>0<c>>>0?b+1|0:b;P=_(e^P,z^G,16);U=K;b=q+U|0;e=p+P|0;if(e>>>0<p>>>0){b=b+1|0}p=e;q=b;F=_(e^D,b^F,63);e=K;D=i;z=l[o+204>>2];b=i+I|0;c=h;h=L+c|0;if(h>>>0<L>>>0){b=b+1|0}i=h;h=i+l[o+200>>2]|0;b=b+z|0;E=h;h=h>>>0<i>>>0?b+1|0:b;z=_(E^r,h^n,32);r=c;c=K;b=v+c|0;i=s+z|0;if(i>>>0<s>>>0){b=b+1|0}n=b;v=_(r^i,b^D,24);D=v;b=K;r=b;s=b;b=h+la|0;h=E+X|0;if(h>>>0<X>>>0){b=b+1|0}X=h+v|0;b=b+s|0;L=X;h=L>>>0<h>>>0?b+1|0:b;z=_(L^z,h^c,16);s=K;b=n+s|0;X=i+z|0;if(X>>>0<i>>>0){b=b+1|0}i=X;n=b;X=_(i^D,b^r,63);c=K;v=A;D=g;E=l[o+236>>2];b=f+g|0;g=A+R|0;if(g>>>0<A>>>0){b=b+1|0}A=g+l[o+232>>2]|0;b=b+E|0;r=A;A=A>>>0<g>>>0?b+1|0:b;E=_(r^T,A^k,32);g=K;b=H+g|0;f=C+E|0;if(f>>>0<C>>>0){b=b+1|0}k=b;C=_(f^v,b^D,24);D=C;b=K;I=b;v=b;b=A+oa|0;A=r+S|0;if(A>>>0<S>>>0){b=b+1|0}S=A+C|0;b=b+v|0;v=S;C=v>>>0<A>>>0?b+1|0:b;H=_(v^E,C^g,16);E=K;b=k+E|0;S=f+H|0;if(S>>>0<f>>>0){b=b+1|0}f=S;k=b;A=_(f^D,b^I,63);g=K;S=o;D=e;b=t+ma|0;t=O+W|0;if(t>>>0<W>>>0){b=b+1|0}W=t+F|0;b=b+D|0;b=W>>>0<t>>>0?b+1|0:b;r=Z;Z=b;b=r+b|0;t=W+aa|0;if(t>>>0<W>>>0){b=b+1|0}aa=b;Z=_(H^W,E^Z,32);D=K;b=n+D|0;W=i+Z|0;if(W>>>0<i>>>0){b=b+1|0}n=W;i=e;e=b;W=_(n^F,i^b,24);H=K;b=H+aa|0;i=t+W|0;if(i>>>0<W>>>0){b=b+1|0}l[S>>2]=i;l[S+4>>2]=b;aa=b;S=_(i^Z,b^D,16);b=K;l[o+120>>2]=S;l[o+124>>2]=b;b=e+b|0;e=n+S|0;if(e>>>0<S>>>0){b=b+1|0}l[o+80>>2]=e;l[o+84>>2]=b;va=o,wa=_(e^W,b^H,63),l[va+40>>2]=wa;l[o+44>>2]=K;W=o;e=c;Z=l[o+132>>2];b=c+G|0;S=X;c=S+y|0;if(c>>>0<S>>>0){b=b+1|0}X=c+l[o+128>>2]|0;b=b+Z|0;b=X>>>0<c>>>0?b+1|0:b;c=b;Z=_(X^B,b^x,32);n=S;G=K;b=k+G|0;S=f+Z|0;if(S>>>0<f>>>0){b=b+1|0}f=S;S=b;e=_(n^f,b^e,24);k=K;b=c+k|0;c=e+X|0;if(c>>>0<X>>>0){b=b+1|0}n=c;c=l[o+144>>2];X=n+c|0;b=l[o+148>>2]+b|0;b=X>>>0<c>>>0?b+1|0:b;l[W+8>>2]=X;l[W+12>>2]=b;W=_(X^Z,b^G,16);b=K;l[o+96>>2]=W;l[o+100>>2]=b;b=b+S|0;S=f+W|0;if(S>>>0<W>>>0){b=b+1|0}l[o+88>>2]=S;l[o+92>>2]=b;va=o,wa=_(e^S,b^k,63),l[va+48>>2]=wa;l[o+52>>2]=K;W=o;X=l[o+220>>2];b=g+h|0;e=A+L|0;if(e>>>0<A>>>0){b=b+1|0}S=e+l[o+216>>2]|0;b=b+X|0;b=S>>>0<e>>>0?b+1|0:b;X=b;b=b+ca|0;e=S+ba|0;if(e>>>0<S>>>0){b=b+1|0}c=e;ba=b;e=_(S^P,U^X,32);k=A;A=K;b=u+A|0;S=e+w|0;if(S>>>0<w>>>0){b=b+1|0}f=S;X=b;S=_(k^f,b^g,24);g=K;b=g+ba|0;c=c+S|0;if(c>>>0<S>>>0){b=b+1|0}l[W+16>>2]=c;l[W+20>>2]=b;W=_(e^c,b^A,16);b=K;l[o+104>>2]=W;l[o+108>>2]=b;b=b+X|0;X=f+W|0;if(X>>>0<W>>>0){b=b+1|0}W=X;l[o+64>>2]=W;l[o+68>>2]=b;va=o,wa=_(S^W,b^g,63),l[va+56>>2]=wa;l[o+60>>2]=K;W=o;ba=d;b=d+na|0;S=Q;X=S+ea|0;if(X>>>0<S>>>0){b=b+1|0}Q=v+X|0;b=b+C|0;b=Q>>>0<v>>>0?b+1|0:b;X=b;ea=_(Q^z,b^s,32);c=S;e=K;b=q+e|0;S=p+ea|0;if(S>>>0<p>>>0){b=b+1|0}d=ba;ba=b;A=_(c^S,d^b,24);c=K;b=X+c|0;X=A+Q|0;if(X>>>0<Q>>>0){b=b+1|0}d=X;X=l[o+152>>2];Q=d+X|0;b=l[o+156>>2]+b|0;b=Q>>>0<X>>>0?b+1|0:b;l[W+24>>2]=Q;l[W+28>>2]=b;Q=_(Q^ea,b^e,16);l[o+112>>2]=Q;b=K;l[o+116>>2]=b;b=b+ba|0;ba=S+Q|0;if(ba>>>0<S>>>0){b=b+1|0}S=ba;l[o+72>>2]=S;l[W+76>>2]=b;va=o,wa=_(A^S,b^c,63),l[va+32>>2]=wa;l[o+36>>2]=K;b=a;W=l[o+68>>2]^((m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24))^aa);S=l[o+64>>2]^((m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24))^i);j[b|0]=S;j[b+1|0]=S>>>8;j[b+2|0]=S>>>16;j[b+3|0]=S>>>24;j[b+4|0]=W;j[b+5|0]=W>>>8;j[b+6|0]=W>>>16;j[b+7|0]=W>>>24;W=1;while(1){S=W<<3;b=S+a|0;S=o+S|0;ba=S;Q=l[S>>2]^(m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24));S=S- -64|0;X=l[S>>2];S=l[S+4>>2]^(l[ba+4>>2]^(m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24)));ba=Q^X;j[b|0]=ba;j[b+1|0]=ba>>>8;j[b+2|0]=ba>>>16;j[b+3|0]=ba>>>24;j[b+4|0]=S;j[b+5|0]=S>>>8;j[b+6|0]=S>>>16;j[b+7|0]=S>>>24;W=W+1|0;if((W|0)!=8){continue}break}J=o+256|0}function el(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0,db=0,eb=0,fb=0,gb=0,hb=0,ib=0,jb=0,kb=0;Ca=ia(b);C=m[b+2|0]|m[b+3|0]<<8|(m[b+4|0]<<16|m[b+5|0]<<24);Ya=ia(b+5|0);G=K;v=m[b+7|0]|m[b+8|0]<<8|(m[b+9|0]<<16|m[b+10|0]<<24);w=m[b+10|0]|m[b+11|0]<<8|(m[b+12|0]<<16|m[b+13|0]<<24);ha=ia(b+13|0);u=K;q=m[b+15|0]|m[b+16|0]<<8|(m[b+17|0]<<16|m[b+18|0]<<24);Ia=ia(b+18|0);s=K;ea=ia(b+21|0);l=m[b+23|0]|m[b+24|0]<<8|(m[b+25|0]<<16|m[b+26|0]<<24);o=ia(b+26|0);h=K;e=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);ya=ia(c);b=c;D=m[b+2|0]|m[b+3|0]<<8|(m[b+4|0]<<16|m[b+5|0]<<24);Ja=ia(b+5|0);p=K;x=m[b+7|0]|m[b+8|0]<<8|(m[b+9|0]<<16|m[b+10|0]<<24);t=m[b+10|0]|m[b+11|0]<<8|(m[b+12|0]<<16|m[b+13|0]<<24);Oa=ia(b+13|0);r=K;i=m[b+15|0]|m[b+16|0]<<8|(m[b+17|0]<<16|m[b+18|0]<<24);Pa=ia(b+18|0);g=K;Da=ia(b+21|0);f=m[b+23|0]|m[b+24|0]<<8|(m[b+25|0]<<16|m[b+26|0]<<24);k=ia(b+26|0);c=K;b=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);gb=ia(d);hb=m[d+2|0]|m[d+3|0]<<8|(m[d+4|0]<<16|m[d+5|0]<<24);ib=ia(d+5|0);jb=K;za=m[d+7|0]|m[d+8|0]<<8|(m[d+9|0]<<16|m[d+10|0]<<24);Ea=m[d+10|0]|m[d+11|0]<<8|(m[d+12|0]<<16|m[d+13|0]<<24);Fa=ia(d+13|0);wa=K;ja=m[d+15|0]|m[d+16|0]<<8|(m[d+17|0]<<16|m[d+18|0]<<24);Za=ia(d+18|0);ka=K;E=ia(d+21|0);kb=a;H=b>>>7|0;I=((h&3)<<30|o>>>2)&2097151;b=ql(H,0,I,0);n=K;h=b;J=((c&3)<<30|k>>>2)&2097151;L=e>>>7|0;b=ql(J,0,L,0);c=h+b|0;e=K+n|0;e=c>>>0<b>>>0?e+1|0:e;k=c;b=ql(I,la,J,ma);h=K;M=f>>>5&2097151;c=ql(M,0,L,0);f=c+b|0;b=K+h|0;b=f>>>0<c>>>0?b+1|0:b;c=f;N=l>>>5&2097151;f=ql(H,0,N,0);h=c+f|0;b=K+b|0;n=h;b=h>>>0<f>>>0?b+1|0:b;B=b;b=h;f=B-((b>>>0<4293918720)+ -1|0)|0;y=b- -1048576|0;z=f;c=f>>21;f=(f&2097151)<<11|y>>>21;h=f+k|0;b=c+e|0;b=h>>>0<f>>>0?b+1|0:b;f=h;o=b;b=f;l=o-((b>>>0<4293918720)+ -1|0)|0;F=b- -1048576|0;h=ql(H,0,L,0);b=h;Aa=b- -1048576|0;xa=K;fa=xa-((b>>>0<4293918720)+ -1|0)|0;e=fa;k=l;c=k>>21;l=Aa&-2097152;h=b-l|0;_a=h+((k&2097151)<<11|F>>>21)|0;b=(xa-((b>>>0<l>>>0)+e|0)|0)+c|0;Ga=_a;b=Ga>>>0<h>>>0?b+1|0:b;Qa=b;l=ql(Ga,b,-683901,-1);h=K;c=e>>21;Ra=c;Ka=(e&2097151)<<11|Aa>>>21;b=ql(Ka,c,136657,0);e=b+l|0;c=K+h|0;fa=e;l=e>>>0<b>>>0?c+1|0:c;O=((r&1)<<31|Oa>>>1)&2097151;b=ql(O,0,I,la);e=K;P=t>>>4&2097151;c=ql(P,0,L,0);h=c+b|0;b=K+e|0;e=h;c=e>>>0<c>>>0?b+1|0:b;Q=i>>>6&2097151;b=ql(Q,0,N,0);h=b+e|0;e=K+c|0;e=h>>>0<b>>>0?e+1|0:e;c=h;b=0;ga=b;R=Da&2097151;S=((s&7)<<29|Ia>>>3)&2097151;b=ql(R,b,S,0);h=b+c|0;c=K+e|0;c=h>>>0<b>>>0?c+1|0:c;T=((g&7)<<29|Pa>>>3)&2097151;U=ea&2097151;e=ql(T,0,U,0);h=e+h|0;b=K+c|0;b=h>>>0<e>>>0?b+1|0:b;e=h;c=b;V=q>>>6&2097151;b=ql(M,0,V,0);e=b+e|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;W=((u&1)<<31|ha>>>1)&2097151;e=ql(J,ma,W,0);h=b+e|0;b=K+c|0;b=h>>>0<e>>>0?b+1|0:b;X=w>>>4&2097151;e=ql(H,0,X,0);h=h+e|0;b=K+b|0;s=h;h=h>>>0<e>>>0?b+1|0:b;b=ql(I,la,P,0);c=K;e=b;Y=x>>>7&2097151;b=ql(Y,0,L,0);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(N,0,O,na);g=b+e|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;c=ql(Q,0,U,oa);e=c+g|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(R,ga,V,0);g=c+e|0;e=K+b|0;e=g>>>0<c>>>0?e+1|0:e;b=ql(S,pa,T,qa);g=b+g|0;c=K+e|0;c=g>>>0<b>>>0?c+1|0:c;b=ql(M,0,W,ra);e=b+g|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(J,ma,X,0);g=b+e|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;Z=v>>>7&2097151;e=ql(H,0,Z,0);g=g+e|0;b=K+b|0;t=g;b=g>>>0<e>>>0?b+1|0:b;i=b;b=g;e=i-((b>>>0<4293918720)+ -1|0)|0;r=b- -1048576|0;g=e;c=e>>21;e=(e&2097151)<<11|r>>>21;x=e+s|0;b=c+h|0;b=x>>>0<e>>>0?b+1|0:b;e=x;h=b;c=b+l|0;b=e;l=b+fa|0;if(l>>>0<b>>>0){c=c+1|0}b=l;l=h-((e>>>0<4293918720)+ -1|0)|0;h=l;u=e- -1048576|0;e=u&-2097152;q=b-e|0;s=c-((b>>>0<e>>>0)+h|0)|0;c=F&-2097152;b=o-((f>>>0<c>>>0)+k|0)|0;La=f-c|0;Sa=b;e=ql(Ka,Ra,-997805,-1);f=e+t|0;c=K+i|0;c=f>>>0<e>>>0?c+1|0:c;e=ql(Ga,Qa,136657,0);f=e+f|0;c=K+c|0;c=f>>>0<e>>>0?c+1|0:c;e=ql(La,b,-683901,-1);f=e+f|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;e=f;c=r&-2097152;l=e-c|0;i=b-((e>>>0<c>>>0)+g|0)|0;b=ql(I,la,Y,0);c=K;e=b;_=((p&3)<<30|Ja>>>2)&2097151;b=ql(_,0,L,0);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(N,0,P,0);f=b+e|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;e=ql(O,na,U,oa);f=e+f|0;c=K+b|0;c=f>>>0<e>>>0?c+1|0:c;e=ql(Q,0,S,pa);f=e+f|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;c=ql(R,ga,W,ra);f=c+f|0;e=K+b|0;e=f>>>0<c>>>0?e+1|0:e;b=ql(T,qa,V,0);f=b+f|0;c=K+e|0;c=f>>>0<b>>>0?c+1|0:c;e=ql(M,0,X,0);f=e+f|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;e=ql(J,ma,Z,0);f=e+f|0;c=K+b|0;c=f>>>0<e>>>0?c+1|0:c;$=((G&3)<<30|Ya>>>2)&2097151;e=ql(H,0,$,0);f=e+f|0;b=K+c|0;g=f;f=f>>>0<e>>>0?b+1|0:b;b=ql(I,la,_,sa);c=K;e=b;aa=D>>>5&2097151;b=ql(aa,0,L,0);k=e+b|0;e=K+c|0;e=k>>>0<b>>>0?e+1|0:e;b=ql(N,0,Y,0);k=b+k|0;c=K+e|0;c=k>>>0<b>>>0?c+1|0:c;e=ql(P,0,U,oa);k=e+k|0;b=K+c|0;b=k>>>0<e>>>0?b+1|0:b;e=ql(O,na,S,pa);k=e+k|0;c=K+b|0;c=k>>>0<e>>>0?c+1|0:c;e=ql(Q,0,V,0);k=e+k|0;b=K+c|0;b=k>>>0<e>>>0?b+1|0:b;c=ql(R,ga,X,0);k=c+k|0;e=K+b|0;e=k>>>0<c>>>0?e+1|0:e;b=ql(T,qa,W,ra);k=b+k|0;c=K+e|0;c=k>>>0<b>>>0?c+1|0:c;e=ql(M,0,Z,0);k=e+k|0;b=K+c|0;b=k>>>0<e>>>0?b+1|0:b;e=ql(J,ma,$,ta);k=e+k|0;c=K+b|0;c=k>>>0<e>>>0?c+1|0:c;ba=C>>>5&2097151;e=ql(H,0,ba,0);k=e+k|0;b=K+c|0;x=k;b=k>>>0<e>>>0?b+1|0:b;Ja=b;b=k;e=Ja-((b>>>0<4293918720)+ -1|0)|0;_a=b- -1048576|0;Oa=e;b=e>>21;e=(e&2097151)<<11|_a>>>21;g=e+g|0;c=b+f|0;t=g;c=g>>>0<e>>>0?c+1|0:c;Pa=c;b=g;e=c-((b>>>0<4293918720)+ -1|0)|0;Ya=b- -1048576|0;Da=e;b=e>>21;c=(e&2097151)<<11|Ya>>>21;e=c+l|0;b=b+i|0;r=e;b=e>>>0<c>>>0?b+1|0:b;xa=b;b=e;e=xa-((b>>>0<4293918720)+ -1|0)|0;ha=b- -1048576|0;fa=e;b=e>>21;e=(e&2097151)<<11|ha>>>21;f=e+q|0;c=b+s|0;l=f;c=f>>>0<e>>>0?c+1|0:c;F=c;b=f;e=c-((b>>>0<4293918720)+ -1|0)|0;ea=b- -1048576|0;C=e;o=(e&2097151)<<11|ea>>>21;g=e>>21;c=ql(I,la,Q,0);b=K;e=c;c=ql(L,0,O,na);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(R,ga,U,oa);f=c+e|0;e=K+b|0;e=f>>>0<c>>>0?e+1|0:e;b=ql(N,0,T,qa);f=b+f|0;c=K+e|0;c=f>>>0<b>>>0?c+1|0:c;b=ql(M,0,S,pa);e=b+f|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(J,ma,V,0);f=b+e|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;c=ql(H,0,W,ra);e=c+f|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;f=e;c=ql(Ka,Ra,-683901,-1);i=e+c|0;e=K+b|0;e=i>>>0<c>>>0?e+1|0:e;c=i;i=b;b=f;i=i-((b>>>0<4293918720)+ -1|0)|0;D=b- -1048576|0;b=c;k=D&-2097152;c=b-k|0;f=i;i=e-(f+(b>>>0<k>>>0)|0)|0;b=c;c=h>>21;e=(h&2097151)<<11|u>>>21;h=b+e|0;b=c+i|0;b=h>>>0<e>>>0?b+1|0:b;c=h;p=c- -1048576|0;k=b-((c>>>0<4293918720)+ -1|0)|0;h=k;i=p&-2097152;e=c-i|0;o=e+o|0;c=(b-((c>>>0<i>>>0)+h|0)|0)+g|0;Ta=o;c=o>>>0<e>>>0?c+1|0:c;Ua=c;k=ql(o,c,-683901,-1);i=K;c=ql(N,0,R,ga);b=K;e=c;c=ql(L,0,Q,0);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(I,la,T,qa);g=c+e|0;e=K+b|0;e=g>>>0<c>>>0?e+1|0:e;b=ql(M,0,U,oa);g=b+g|0;c=K+e|0;c=g>>>0<b>>>0?c+1|0:c;e=ql(J,ma,S,pa);g=e+g|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;e=ql(H,0,V,0);g=e+g|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;b=c;c=f>>21;e=(f&2097151)<<11|D>>>21;f=g+e|0;b=b+c|0;b=f>>>0<e>>>0?b+1|0:b;c=f;Ba=c- -1048576|0;g=b-((c>>>0<4293918720)+ -1|0)|0;v=g;f=Ba&-2097152;e=c-f|0;c=b-((c>>>0<f>>>0)+g|0)|0;b=(h&2097151)<<11|p>>>21;f=b+e|0;c=(h>>21)+c|0;Va=f;c=f>>>0<b>>>0?c+1|0:c;Wa=c;c=ql(f,c,136657,0);e=c+k|0;b=K+i|0;Ia=e;w=e>>>0<c>>>0?b+1|0:b;b=ql(U,oa,aa,0);c=K;e=b;ca=ya&2097151;b=ql(ca,0,N,0);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(S,pa,_,sa);f=b+e|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;e=ql(V,0,Y,0);f=e+f|0;c=K+b|0;c=f>>>0<e>>>0?c+1|0:c;e=ql(P,0,W,ra);f=e+f|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;c=ql(O,na,X,0);f=c+f|0;e=K+b|0;e=f>>>0<c>>>0?e+1|0:e;b=ql(Q,0,Z,0);f=b+f|0;c=K+e|0;c=f>>>0<b>>>0?c+1|0:c;e=ql(R,ga,ba,0);f=e+f|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;e=ql(T,qa,$,ta);f=e+f|0;c=K+b|0;c=f>>>0<e>>>0?c+1|0:c;da=Ca&2097151;e=ql(M,0,da,0);f=e+f|0;b=K+c|0;c=f;e=c>>>0<e>>>0?b+1|0:b;c=(m[d+23|0]|m[d+24|0]<<8|(m[d+25|0]<<16|m[d+26|0]<<24))>>>5&2097151;b=f+c|0;if(b>>>0<c>>>0){e=e+1|0}h=b;f=e;c=ql(S,pa,aa,0);b=K;e=c;c=ql(U,oa,ca,ua);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=ql(V,0,_,sa);g=c+e|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;e=ql(W,ra,Y,0);g=e+g|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;e=ql(P,0,X,0);g=e+g|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;b=ql(O,na,Z,0);g=b+g|0;e=K+c|0;e=g>>>0<b>>>0?e+1|0:e;c=ql(Q,0,$,ta);g=c+g|0;b=K+e|0;b=g>>>0<c>>>0?b+1|0:b;e=ql(R,ga,da,va);g=e+g|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;e=ql(T,qa,ba,0);g=e+g|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;e=E&2097151;g=e+g|0;i=g;c=g>>>0<e>>>0?b+1|0:b;u=c;b=g;e=c-((b>>>0<4293918720)+ -1|0)|0;G=b- -1048576|0;q=e;b=e>>21;e=(e&2097151)<<11|G>>>21;h=e+h|0;c=b+f|0;g=h;c=g>>>0<e>>>0?c+1|0:c;p=c;b=y&-2097152;ya=n-b|0;E=B-((n>>>0<b>>>0)+z|0)|0;b=ql(I,la,M,0);c=K;e=b;b=ql(L,0,R,ga);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(J,ma,N,0);f=b+e|0;b=K+c|0;b=f>>>0<e>>>0?b+1|0:b;e=ql(H,0,U,oa);f=e+f|0;c=K+b|0;n=f;f=f>>>0<e>>>0?c+1|0:c;b=ql(L,0,T,qa);c=K;e=b;b=ql(I,la,R,ga);h=e+b|0;e=K+c|0;e=h>>>0<b>>>0?e+1|0:e;c=ql(N,0,M,0);h=c+h|0;b=K+e|0;b=h>>>0<c>>>0?b+1|0:b;e=ql(J,ma,U,oa);h=e+h|0;c=K+b|0;c=h>>>0<e>>>0?c+1|0:c;e=ql(H,0,S,pa);h=e+h|0;b=K+c|0;b=h>>>0<e>>>0?b+1|0:b;o=b;b=h;e=o-((b>>>0<4293918720)+ -1|0)|0;B=b- -1048576|0;k=e;b=(e&2097151)<<11|B>>>21;n=b+n|0;e=(e>>21)+f|0;f=n;e=f>>>0<b>>>0?e+1|0:e;n=e;b=f;y=e-((b>>>0<4293918720)+ -1|0)|0;z=b- -1048576|0;e=y;c=e>>21;y=(e&2097151)<<11|z>>>21;ya=y+ya|0;b=c+E|0;Ha=ya;b=Ha>>>0<y>>>0?b+1|0:b;Xa=b;E=ql(Ha,b,470296,0);y=K;c=z&-2097152;b=n-((f>>>0<c>>>0)+e|0)|0;Ma=f-c|0;Aa=b;e=ql(La,Sa,666643,0);f=e+E|0;c=K+y|0;c=f>>>0<e>>>0?c+1|0:c;e=ql(Ma,b,654183,0);f=e+f|0;b=K+c|0;n=f;e=f>>>0<e>>>0?b+1|0:b;c=B&-2097152;b=h-c|0;h=o-((h>>>0<c>>>0)+k|0)|0;f=(v&2097151)<<11|Ba>>>21;k=f+b|0;c=(v>>21)+h|0;$a=k;c=k>>>0<f>>>0?c+1|0:c;Ca=c;ab=g- -1048576|0;b=p-((g>>>0<4293918720)+ -1|0)|0;f=b;c=ql(k,c,-997805,-1);h=c+n|0;e=K+e|0;e=h>>>0<c>>>0?e+1|0:e;g=h+g|0;c=e+p|0;c=g>>>0<h>>>0?c+1|0:c;e=ab&-2097152;E=g-e|0;y=c-((g>>>0<e>>>0)+b|0)|0;b=ql(Ma,Aa,470296,0);c=K;e=b;b=ql(Ha,Xa,666643,0);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=ql(k,Ca,654183,0);e=b+e|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;e=e+i|0;b=c+u|0;b=e>>>0<i>>>0?b+1|0:b;c=G&-2097152;p=e-c|0;i=b-((e>>>0<c>>>0)+q|0)|0;c=ql(V,0,aa,0);b=K;e=c;c=ql(S,pa,ca,ua);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=ql(W,ra,_,sa);h=c+e|0;c=K+b|0;c=h>>>0<e>>>0?c+1|0:c;e=ql(X,0,Y,0);h=e+h|0;b=K+c|0;b=h>>>0<e>>>0?b+1|0:b;e=ql(P,0,Z,0);h=e+h|0;c=K+b|0;c=h>>>0<e>>>0?c+1|0:c;b=ql(O,na,$,ta);h=b+h|0;e=K+c|0;e=h>>>0<b>>>0?e+1|0:e;c=ql(Q,0,ba,0);h=c+h|0;b=K+e|0;b=h>>>0<c>>>0?b+1|0:b;e=ql(T,qa,da,va);h=e+h|0;c=K+b|0;c=h>>>0<e>>>0?c+1|0:c;b=c;e=((ka&7)<<29|Za>>>3)&2097151;c=h+e|0;if(c>>>0<e>>>0){b=b+1|0}g=c;h=b;b=ql(W,ra,aa,0);c=K;e=b;b=ql(V,0,ca,ua);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=ql(X,0,_,sa);e=b+e|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=ql(Z,0,Y,0);n=b+e|0;e=K+c|0;e=n>>>0<b>>>0?e+1|0:e;c=ql(P,0,$,ta);n=c+n|0;b=K+e|0;b=n>>>0<c>>>0?b+1|0:b;c=ql(O,na,ba,0);e=c+n|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=ql(Q,0,da,va);n=c+e|0;c=K+b|0;c=n>>>0<e>>>0?c+1|0:c;e=ja>>>6&2097151;b=e+n|0;if(b>>>0<e>>>0){c=c+1|0}B=b;o=c;e=c-((b>>>0<4293918720)+ -1|0)|0;z=b- -1048576|0;s=e;b=e>>21;e=(e&2097151)<<11|z>>>21;g=e+g|0;c=b+h|0;c=g>>>0<e>>>0?c+1|0:c;k=c;b=g;e=c-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;n=e;b=e>>21;e=(e&2097151)<<11|v>>>21;h=e+p|0;c=b+i|0;u=h;c=h>>>0<e>>>0?c+1|0:c;i=c;b=h;e=c-((b>>>0<4293918720)+ -1|0)|0;q=b- -1048576|0;D=e;b=e>>21;e=(e&2097151)<<11|q>>>21;h=e+E|0;c=b+y|0;c=h>>>0<e>>>0?c+1|0:c;e=h;h=c;b=c+w|0;c=e;p=c+Ia|0;if(p>>>0<c>>>0){b=b+1|0}c=p;p=h-((e>>>0<4293918720)+ -1|0)|0;h=p;bb=e- -1048576|0;e=bb&-2097152;cb=c-e|0;A=b-((c>>>0<e>>>0)+h|0)|0;c=ql(Va,Wa,-997805,-1);e=c+u|0;b=K+i|0;Ba=e;p=e>>>0<c>>>0?b+1|0:b;c=ql($a,Ca,470296,0);b=K;e=c;c=ql(Ma,Aa,666643,0);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;e=e+g|0;c=b+k|0;c=e>>>0<g>>>0?c+1|0:c;b=v&-2097152;v=e-b|0;w=c-((e>>>0<b>>>0)+n|0)|0;b=ql($a,Ca,666643,0);c=b+B|0;e=K+o|0;u=c;i=c>>>0<b>>>0?e+1|0:e;c=ql(X,0,aa,0);b=K;e=c;c=ql(W,ra,ca,ua);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=ql(Z,0,_,sa);g=c+e|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;e=ql($,ta,Y,0);g=e+g|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;e=ql(P,0,ba,0);g=e+g|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;b=ql(O,na,da,va);g=b+g|0;e=K+c|0;c=g;b=c>>>0<b>>>0?e+1|0:e;e=((wa&1)<<31|Fa>>>1)&2097151;c=e+c|0;if(c>>>0<e>>>0){b=b+1|0}n=c;g=b;b=ql(Z,0,aa,0);c=K;e=b;b=ql(X,0,ca,ua);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=ql($,ta,_,sa);k=b+e|0;e=K+c|0;e=k>>>0<b>>>0?e+1|0:e;c=ql(ba,0,Y,0);k=c+k|0;b=K+e|0;b=k>>>0<c>>>0?b+1|0:b;e=ql(P,0,da,va);k=e+k|0;c=K+b|0;c=k>>>0<e>>>0?c+1|0:c;b=c;e=Ea>>>4&2097151;c=k+e|0;if(c>>>0<e>>>0){b=b+1|0}o=c;G=b;b=c;e=G-((b>>>0<4293918720)+ -1|0)|0;Za=b- -1048576|0;Ea=e;b=e>>21;e=(e&2097151)<<11|Za>>>21;n=e+n|0;c=b+g|0;k=n;c=k>>>0<e>>>0?c+1|0:c;wa=c;b=k;e=c-((b>>>0<4293918720)+ -1|0)|0;Ia=b- -1048576|0;ja=e;b=e>>21;c=(e&2097151)<<11|Ia>>>21;e=c+u|0;b=b+i|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=b;b=z&-2097152;ka=e-((c>>>0<b>>>0)+s|0)|0;n=c-b|0;b=n;c=ka-((b>>>0<4293918720)+ -1|0)|0;ya=b- -1048576|0;B=c;e=c>>21;c=(c&2097151)<<11|ya>>>21;g=c+v|0;b=e+w|0;E=g;b=g>>>0<c>>>0?b+1|0:b;z=b;b=g;c=z-((b>>>0<4293918720)+ -1|0)|0;y=b- -1048576|0;v=c;b=ea&-2097152;g=F-((l>>>0<b>>>0)+C|0)|0;Na=l-b|0;Fa=g;b=(c&2097151)<<11|y>>>21;i=b+Ba|0;c=(c>>21)+p|0;c=i>>>0<b>>>0?c+1|0:c;e=ql(Ta,Ua,136657,0);b=q&-2097152;l=e+(i-b|0)|0;b=K+(c-((i>>>0<b>>>0)+D|0)|0)|0;b=l>>>0<e>>>0?b+1|0:b;e=ql(Na,g,-683901,-1);g=e+l|0;c=K+b|0;l=g;c=g>>>0<e>>>0?c+1|0:c;w=c;b=g;c=c-((b>>>0<4293918720)+ -1|0)|0;ea=b- -1048576|0;u=c;e=c>>21;c=(c&2097151)<<11|ea>>>21;g=c+cb|0;b=e+A|0;i=g;b=g>>>0<c>>>0?b+1|0:b;q=b;b=g;c=q-((b>>>0<4293918720)+ -1|0)|0;F=b- -1048576|0;s=c;Ba=(c&2097151)<<11|F>>>21;D=c>>21;b=ql(N,0,aa,0);c=K;e=b;b=ql(I,la,ca,ua);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=ql(U,oa,_,sa);e=b+e|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(S,pa,Y,0);g=b+e|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;c=ql(P,0,V,0);e=c+g|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(O,na,W,ra);g=c+e|0;e=K+b|0;e=g>>>0<c>>>0?e+1|0:e;b=ql(Q,0,X,0);g=b+g|0;c=K+e|0;c=g>>>0<b>>>0?c+1|0:c;b=ql(R,ga,$,ta);e=b+g|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(T,qa,Z,0);g=b+e|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;c=ql(M,0,ba,0);e=c+g|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(J,ma,da,va);g=c+e|0;e=K+b|0;b=g;c=b>>>0<c>>>0?e+1|0:e;b=ia(d+26|0);e=K;e=((e&3)<<30|b>>>2)&2097151;b=g+e|0;if(b>>>0<e>>>0){c=c+1|0}C=b;g=c;b=ql(La,Sa,470296,0);c=K;e=b;b=ql(Ga,Qa,666643,0);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(Ha,Xa,654183,0);A=b+e|0;b=K+c|0;b=A>>>0<e>>>0?b+1|0:b;c=ql(Ma,Aa,-997805,-1);A=c+A|0;e=K+b|0;e=A>>>0<c>>>0?e+1|0:e;c=ql($a,Ca,136657,0);A=c+A|0;b=K+e|0;b=A>>>0<c>>>0?b+1|0:b;e=A;A=e+C|0;c=b+g|0;c=A>>>0<e>>>0?c+1|0:c;b=C;p=g-((b>>>0<4293918720)+ -1|0)|0;db=b- -1048576|0;g=p;e=f>>21;b=(f&2097151)<<11|ab>>>21;f=A+b|0;c=c+e|0;c=f>>>0<b>>>0?c+1|0:c;C=f;f=db&-2097152;b=C-f|0;e=ql(Va,Wa,-683901,-1);A=b+e|0;f=c-((C>>>0<f>>>0)+g|0)|0;c=f+K|0;c=A>>>0<e>>>0?c+1|0:c;eb=b- -1048576|0;p=f-((b>>>0<4293918720)+ -1|0)|0;f=p;e=h>>21;b=(h&2097151)<<11|bb>>>21;h=A+b|0;c=c+e|0;c=h>>>0<b>>>0?c+1|0:c;e=eb&-2097152;b=h-e|0;p=c-((h>>>0<e>>>0)+f|0)|0;c=p+D|0;h=b+Ba|0;if(h>>>0<b>>>0){c=c+1|0}e=h;fb=b- -1048576|0;p=p-((b>>>0<4293918720)+ -1|0)|0;h=p;b=e;e=fb&-2097152;ab=b-e|0;bb=c-((b>>>0<e>>>0)+h|0)|0;b=F&-2097152;cb=i-b|0;A=q-((i>>>0<b>>>0)+s|0)|0;b=ea&-2097152;Ba=l-b|0;ea=w-((l>>>0<b>>>0)+u|0)|0;c=ql(Va,Wa,654183,0);e=c+E|0;b=K+z|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(Ta,Ua,-997805,-1);i=e;e=y&-2097152;l=c+(i-e|0)|0;e=K+(b-((i>>>0<e>>>0)+v|0)|0)|0;b=ql(Na,Fa,136657,0);i=b+l|0;c=K+(l>>>0<c>>>0?e+1|0:e)|0;F=i;l=i>>>0<b>>>0?c+1|0:c;b=ha&-2097152;C=r-b|0;w=xa-((r>>>0<b>>>0)+fa|0)|0;c=ql(Ga,Qa,-997805,-1);b=K;e=c;c=ql(Ka,Ra,654183,0);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(La,Sa,136657,0);i=c+e|0;e=K+b|0;e=i>>>0<c>>>0?e+1|0:e;b=ql(Ha,Xa,-683901,-1);i=b+i|0;c=K+e|0;c=i>>>0<b>>>0?c+1|0:c;b=i+t|0;c=c+Pa|0;c=b>>>0<t>>>0?c+1|0:c;e=b;b=Ya&-2097152;u=e-b|0;q=c-((e>>>0<b>>>0)+Da|0)|0;c=ql(Ga,Qa,654183,0);b=K;e=c;c=ql(Ka,Ra,470296,0);e=e+c|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=ql(La,Sa,-997805,-1);i=c+e|0;c=K+b|0;b=i+x|0;c=Ja+(i>>>0<e>>>0?c+1|0:c)|0;c=b>>>0<x>>>0?c+1|0:c;e=b;b=ql(Ha,Xa,136657,0);i=e+b|0;e=K+c|0;e=i>>>0<b>>>0?e+1|0:e;c=ql(Ma,Aa,-683901,-1);i=c+i|0;b=K+e|0;b=i>>>0<c>>>0?b+1|0:b;e=i;c=_a&-2097152;t=e-c|0;r=b-((e>>>0<c>>>0)+Oa|0)|0;b=ql(I,la,aa,0);c=K;e=b;b=ql(L,0,ca,ua);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=ql(N,0,_,sa);i=b+e|0;e=K+c|0;e=i>>>0<b>>>0?e+1|0:e;c=ql(U,oa,Y,0);i=c+i|0;b=K+e|0;b=i>>>0<c>>>0?b+1|0:b;e=ql(P,0,S,pa);i=e+i|0;c=K+b|0;c=i>>>0<e>>>0?c+1|0:c;e=ql(O,na,V,0);i=e+i|0;b=K+c|0;b=i>>>0<e>>>0?b+1|0:b;e=ql(Q,0,W,ra);i=e+i|0;c=K+b|0;c=i>>>0<e>>>0?c+1|0:c;b=ql(R,ga,Z,0);i=b+i|0;e=K+c|0;e=i>>>0<b>>>0?e+1|0:e;c=ql(T,qa,X,0);i=c+i|0;b=K+e|0;b=i>>>0<c>>>0?b+1|0:b;e=ql(M,0,$,ta);i=e+i|0;c=K+b|0;c=i>>>0<e>>>0?c+1|0:c;e=ql(H,0,da,va);i=e+i|0;b=K+c|0;b=i>>>0<e>>>0?b+1|0:b;e=ql(J,ma,ba,0);i=e+i|0;c=K+b|0;b=i;e=b>>>0<e>>>0?c+1|0:c;c=(m[d+28|0]|m[d+29|0]<<8|(m[d+30|0]<<16|m[d+31|0]<<24))>>>7|0;b=c+b|0;if(b>>>0<c>>>0){e=e+1|0}c=g>>21;d=(g&2097151)<<11|db>>>21;g=d+b|0;b=c+e|0;i=g;b=g>>>0<d>>>0?b+1|0:b;s=b;b=g;d=s-((b>>>0<4293918720)+ -1|0)|0;z=b- -1048576|0;D=d;c=d>>21;b=(d&2097151)<<11|z>>>21;d=b+t|0;c=c+r|0;g=d;c=d>>>0<b>>>0?c+1|0:c;p=c;b=d;d=c-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;x=d;c=d>>21;d=(d&2097151)<<11|v>>>21;e=d+u|0;b=c+q|0;b=e>>>0<d>>>0?b+1|0:b;d=e;t=b;b=e;e=t-((b>>>0<4293918720)+ -1|0)|0;q=b- -1048576|0;r=e;c=e>>21;b=(e&2097151)<<11|q>>>21;e=b+C|0;c=c+w|0;ha=e;c=e>>>0<b>>>0?c+1|0:c;fa=c;b=ql(e,c,-683901,-1);c=b+F|0;e=K+l|0;u=c;l=c>>>0<b>>>0?e+1|0:e;b=q&-2097152;r=t-((d>>>0<b>>>0)+r|0)|0;E=d-b|0;F=r;c=ql(Va,Wa,470296,0)+n|0;b=ka+K|0;b=c>>>0<n>>>0?b+1|0:b;d=ql(Ta,Ua,654183,0);e=c;c=ya&-2097152;n=d+(e-c|0)|0;c=K+(b-((e>>>0<c>>>0)+B|0)|0)|0;c=n>>>0<d>>>0?c+1|0:c;b=ql(Na,Fa,-997805,-1);d=b+n|0;e=K+c|0;e=d>>>0<b>>>0?e+1|0:e;c=ql(ha,fa,136657,0);d=c+d|0;b=K+e|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(E,r,-683901,-1);d=c+d|0;b=K+b|0;e=d;b=e>>>0<c>>>0?b+1|0:b;t=b;b=e;d=t-((b>>>0<4293918720)+ -1|0)|0;w=b- -1048576|0;r=d;c=d>>21;d=(d&2097151)<<11|w>>>21;n=d+u|0;b=c+l|0;b=n>>>0<d>>>0?b+1|0:b;d=n;n=b;b=d;u=n-((b>>>0<4293918720)+ -1|0)|0;q=b- -1048576|0;l=u;c=l>>21;u=(l&2097151)<<11|q>>>21;B=u+Ba|0;b=c+ea|0;ea=B;u=B>>>0<u>>>0?b+1|0:b;b=q&-2097152;Ja=d-b|0;Oa=n-((d>>>0<b>>>0)+l|0)|0;b=w&-2097152;Da=e-b|0;xa=t-((e>>>0<b>>>0)+r|0)|0;b=ql(Va,Wa,666643,0);c=Ia&-2097152;d=b+(k-c|0)|0;c=K+(wa-((k>>>0<c>>>0)+ja|0)|0)|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(Ta,Ua,470296,0);e=b+d|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;c=ql(Na,Fa,654183,0);d=c+e|0;b=K+b|0;r=d;d=d>>>0<c>>>0?b+1|0:b;b=v&-2097152;k=g-b|0;l=p-((g>>>0<b>>>0)+x|0)|0;b=ql(Ga,Qa,470296,0);c=K;e=b;b=ql(Ka,Ra,666643,0);e=e+b|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;b=e;e=ql(La,Sa,654183,0);g=b+e|0;b=K+c|0;b=g>>>0<e>>>0?b+1|0:b;c=ql(Ha,Xa,-997805,-1);e=c+g|0;b=K+b|0;b=e>>>0<c>>>0?b+1|0:b;c=e;e=ql(Ma,Aa,136657,0);g=c+e|0;c=K+b|0;c=g>>>0<e>>>0?c+1|0:c;b=ql($a,Ca,-683901,-1);g=b+g|0;e=K+c|0;e=g>>>0<b>>>0?e+1|0:e;b=g+i|0;c=e+s|0;c=b>>>0<i>>>0?c+1|0:c;g=b;e=z&-2097152;b=b-e|0;g=c-((g>>>0<e>>>0)+D|0)|0;c=f>>21;e=(f&2097151)<<11|eb>>>21;f=e+b|0;b=c+g|0;n=f;b=f>>>0<e>>>0?b+1|0:b;p=b;b=f;e=p-((b>>>0<4293918720)+ -1|0)|0;ka=b- -1048576|0;x=e;c=e>>21;b=(e&2097151)<<11|ka>>>21;e=b+k|0;c=c+l|0;y=e;c=e>>>0<b>>>0?c+1|0:c;C=c;c=ql(e,c,-683901,-1);e=c+r|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(ha,fa,-997805,-1);d=c+e|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(E,F,136657,0);d=c+d|0;e=K+b|0;k=d;g=d>>>0<c>>>0?e+1|0:e;b=ql($,ta,aa,0);c=K;d=b;b=ql(Z,0,ca,ua);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(ba,0,_,sa);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(da,va,Y,0);e=b+d|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=za>>>7&2097151;c=d+e|0;if(c>>>0<d>>>0){b=b+1|0}i=c;d=b;b=ql(ba,0,aa,0);c=K;e=b;b=ql($,ta,ca,ua);f=e+b|0;e=K+c|0;e=f>>>0<b>>>0?e+1|0:e;c=ql(da,va,_,sa);f=c+f|0;b=K+e|0;e=f;c=e>>>0<c>>>0?b+1|0:b;e=((jb&3)<<30|ib>>>2)&2097151;b=f+e|0;if(b>>>0<e>>>0){c=c+1|0}l=b;f=c;c=c-((b>>>0<4293918720)+ -1|0)|0;ja=b- -1048576|0;q=c;e=c>>>21|0;c=(c&2097151)<<11|ja>>>21;i=c+i|0;b=d+e|0;b=i>>>0<c>>>0?b+1|0:b;s=b;b=i;c=s-((b>>>0<4293918720)+ -1|0)|0;B=b- -1048576|0;t=c;b=o+((c&2097151)<<11|B>>>21)|0;c=G+(c>>21)|0;c=b>>>0<o>>>0?c+1|0:c;d=ql(Ta,Ua,666643,0);e=b;b=Za&-2097152;o=d+(e-b|0)|0;b=K+(c-((e>>>0<b>>>0)+Ea|0)|0)|0;b=o>>>0<d>>>0?b+1|0:b;c=ql(Na,Fa,470296,0);d=c+o|0;e=K+b|0;e=d>>>0<c>>>0?e+1|0:e;b=ql(y,C,136657,0);d=b+d|0;c=K+e|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(ha,fa,654183,0);e=b+d|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(E,F,-997805,-1);e=d+e|0;c=K+b|0;z=e;c=e>>>0<d>>>0?c+1|0:c;r=c;b=e;d=c-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;o=d;b=d>>21;c=(d&2097151)<<11|v>>>21;d=c+k|0;e=b+g|0;g=d;e=d>>>0<c>>>0?e+1|0:e;d=e;b=g;e=e-((b>>>0<4293918720)+ -1|0)|0;w=b- -1048576|0;k=e;b=e>>21;e=(e&2097151)<<11|w>>>21;D=e+Da|0;c=b+xa|0;Pa=D;D=D>>>0<e>>>0?c+1|0:c;c=ka&-2097152;b=n-c|0;e=p-((n>>>0<c>>>0)+x|0)|0;n=b;c=h>>21;b=(h&2097151)<<11|fb>>>21;h=n+b|0;e=c+e|0;e=h>>>0<b>>>0?e+1|0:e;p=e;b=h;e=e-((b>>>0<4293918720)+ -1|0)|0;ka=b- -1048576|0;x=e;c=e>>21;wa=c;za=(e&2097151)<<11|ka>>>21;b=ql(za,c,-683901,-1);e=b+g|0;c=K+d|0;c=e>>>0<b>>>0?c+1|0:c;b=w&-2097152;Da=e-b|0;xa=c-((e>>>0<b>>>0)+k|0)|0;b=ql(za,wa,136657,0);c=b+z|0;e=K+r|0;e=c>>>0<b>>>0?e+1|0:e;b=v&-2097152;G=c-b|0;Ea=e-((c>>>0<b>>>0)+o|0)|0;c=ql(Na,Fa,666643,0);b=B&-2097152;d=c+(i-b|0)|0;b=K+(s-((i>>>0<b>>>0)+t|0)|0)|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(y,C,-997805,-1);d=c+d|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(ha,fa,470296,0);e=c+d|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql(E,F,654183,0);d=b+e|0;e=K+c|0;s=d;k=d>>>0<b>>>0?e+1|0:e;g=f;b=ql(da,va,aa,0);c=K;d=b;b=ql(ba,0,ca,ua);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=c;c=d;d=hb>>>5&2097151;c=c+d|0;if(c>>>0<d>>>0){b=b+1|0}i=c;d=b;c=gb&2097151;e=ql(da,va,ca,ua)+c|0;b=K;f=e;b=e>>>0<c>>>0?b+1|0:b;t=b;b=e;e=t-((b>>>0<4293918720)+ -1|0)|0;B=b- -1048576|0;r=e;b=(e&2097151)<<11|B>>>21;i=b+i|0;e=(e>>>21|0)+d|0;d=i;e=d>>>0<b>>>0?e+1|0:e;o=e;b=d;e=e-((b>>>0<4293918720)+ -1|0)|0;z=b- -1048576|0;n=e;c=e>>>21|0;e=(e&2097151)<<11|z>>>21;i=e+l|0;b=c+g|0;b=i>>>0<e>>>0?b+1|0:b;c=ql(y,C,654183,0);g=i;e=ja&-2097152;i=c+(g-e|0)|0;e=K+(b-((q&16383)+(g>>>0<e>>>0)|0)|0)|0;b=ql(ha,fa,666643,0);g=b+i|0;c=K+(i>>>0<c>>>0?e+1|0:e)|0;c=g>>>0<b>>>0?c+1|0:c;e=ql(E,F,470296,0);g=e+g|0;b=K+c|0;v=g;b=g>>>0<e>>>0?b+1|0:b;l=b;b=g;e=l-((b>>>0<4293918720)+ -1|0)|0;w=b- -1048576|0;i=e;c=e>>21;b=(e&2097151)<<11|w>>>21;e=b+s|0;c=c+k|0;q=e;c=e>>>0<b>>>0?c+1|0:c;g=c;b=e;k=c-((b>>>0<4293918720)+ -1|0)|0;s=b- -1048576|0;e=k;c=e>>21;k=(e&2097151)<<11|s>>>21;ja=k+G|0;b=c+Ea|0;G=ja;k=G>>>0<k>>>0?b+1|0:b;c=ql(za,wa,-997805,-1);q=c+q|0;b=K+g|0;b=q>>>0<c>>>0?b+1|0:b;g=q;c=s&-2097152;Ea=g-c|0;ja=b-((g>>>0<c>>>0)+e|0)|0;b=ql(za,wa,654183,0);c=b+v|0;e=K+l|0;e=c>>>0<b>>>0?e+1|0:e;b=w&-2097152;q=c-b|0;s=e-((c>>>0<b>>>0)+i|0)|0;b=ql(y,C,470296,0);c=z&-2097152;e=b+(d-c|0)|0;c=K+(o-((n&16383)+(d>>>0<c>>>0)|0)|0)|0;c=e>>>0<b>>>0?c+1|0:c;b=ql(E,F,666643,0);d=b+e|0;c=K+c|0;i=d;g=d>>>0<b>>>0?c+1|0:c;b=ql(y,C,666643,0);c=B&-2097152;d=b+(f-c|0)|0;e=K+(t-((r&4095)+(f>>>0<c>>>0)|0)|0)|0;e=d>>>0<b>>>0?e+1|0:e;n=e;b=d;e=e-((b>>>0<4293918720)+ -1|0)|0;t=b- -1048576|0;l=e;b=e>>21;e=(e&2097151)<<11|t>>>21;f=e+i|0;c=b+g|0;r=f;c=f>>>0<e>>>0?c+1|0:c;i=c;b=f;e=c-((b>>>0<4293918720)+ -1|0)|0;o=b- -1048576|0;g=e;c=(e&2097151)<<11|o>>>21;f=c+q|0;e=(e>>21)+s|0;s=f;f=f>>>0<c>>>0?e+1|0:e;b=ql(za,wa,470296,0);e=b+r|0;c=K+i|0;c=e>>>0<b>>>0?c+1|0:c;i=e;e=o&-2097152;b=i-e|0;g=c-((i>>>0<e>>>0)+g|0)|0;r=b;b=ql(za,wa,666643,0);c=t&-2097152;i=b+(d-c|0)|0;e=K+(n-((d>>>0<c>>>0)+l|0)|0)|0;e=i>>>0<b>>>0?e+1|0:e;l=i;b=i;c=e>>21;d=(e&2097151)<<11|b>>>21;e=r+d|0;b=c+g|0;g=e;c=e;b=c>>>0<d>>>0?b+1|0:b;e=b>>21;b=(b&2097151)<<11|c>>>21;d=b+s|0;c=e+f|0;c=d>>>0<b>>>0?c+1|0:c;i=d;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+Ea|0;b=b+ja|0;b=d>>>0<c>>>0?b+1|0:b;o=d;c=b>>21;b=(b&2097151)<<11|d>>>21;d=b+G|0;c=c+k|0;c=d>>>0<b>>>0?c+1|0:c;z=d;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+Da|0;e=b+xa|0;v=d;b=d;e=b>>>0<c>>>0?e+1|0:e;c=e>>21;d=(e&2097151)<<11|b>>>21;e=d+Pa|0;b=c+D|0;w=e;c=e;b=c>>>0<d>>>0?b+1|0:b;e=b>>21;b=(b&2097151)<<11|c>>>21;d=b+Ja|0;c=e+Oa|0;c=d>>>0<b>>>0?c+1|0:c;q=d;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+ea|0;b=b+u|0;b=d>>>0<c>>>0?b+1|0:b;s=d;c=b>>21;b=(b&2097151)<<11|d>>>21;d=b+cb|0;c=c+A|0;c=d>>>0<b>>>0?c+1|0:c;D=d;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+ab|0;e=b+bb|0;t=d;b=d;e=b>>>0<c>>>0?e+1|0:e;c=e>>21;e=(e&2097151)<<11|b>>>21;d=ka&-2097152;b=h-d|0;e=e+b|0;c=(p-((h>>>0<d>>>0)+x|0)|0)+c|0;r=e;c=e>>>0<b>>>0?c+1|0:c;x=(c&2097151)<<11|e>>>21;b=c>>21;n=b;c=ql(x,b,666643,0);b=l&2097151;c=c+b|0;e=K;l=c;e=c>>>0<b>>>0?e+1|0:e;d=e;j[kb|0]=c;j[a+1|0]=(e&255)<<24|c>>>8;b=g&2097151;f=ql(x,n,470296,0)+b|0;c=K;c=f>>>0<b>>>0?c+1|0:c;e=f;b=d>>21;f=(d&2097151)<<11|l>>>21;h=e+f|0;c=b+c|0;g=h;c=g>>>0<f>>>0?c+1|0:c;e=g;j[a+4|0]=(c&2047)<<21|e>>>11;b=c;j[a+3|0]=(b&7)<<29|e>>>3;c=a;f=i&2097151;h=ql(x,n,654183,0)+f|0;e=K;e=h>>>0<f>>>0?e+1|0:e;f=b;b=b>>21;f=(f&2097151)<<11|g>>>21;h=f+h|0;b=b+e|0;i=h;b=h>>>0<f>>>0?b+1|0:b;e=b;j[c+6|0]=(b&63)<<26|h>>>6;h=0;k=g&2097151;b=k;j[c+2|0]=((d&65535)<<16|l>>>16)&31|b<<5;f=c;b=o&2097151;d=ql(x,n,-997805,-1)+b|0;c=K;c=d>>>0<b>>>0?c+1|0:c;g=d;b=e>>21;d=(e&2097151)<<11|i>>>21;e=g+d|0;c=b+c|0;l=e;c=e>>>0<d>>>0?c+1|0:c;j[f+9|0]=(c&511)<<23|e>>>9;d=c;b=c;c=e;j[f+8|0]=(b&1)<<31|c>>>1;g=0;o=i&2097151;c=o;j[f+5|0]=(h&524287)<<13|k>>>19|c<<2;c=z&2097151;e=ql(x,n,136657,0)+c|0;b=K;b=e>>>0<c>>>0?b+1|0:b;c=d>>21;d=(d&2097151)<<11|l>>>21;h=d+e|0;e=b+c|0;i=h;e=h>>>0<d>>>0?e+1|0:e;j[f+12|0]=(e&4095)<<20|h>>>12;c=e;j[f+11|0]=(c&15)<<28|h>>>4;h=0;k=l&2097151;d=k;j[f+7|0]=(g&16383)<<18|o>>>14|d<<7;d=f;e=v&2097151;f=ql(x,n,-683901,-1)+e|0;b=K;b=f>>>0<e>>>0?b+1|0:b;e=f;f=(c&2097151)<<11|i>>>21;g=e+f|0;c=(c>>21)+b|0;c=g>>>0<f>>>0?c+1|0:c;b=c;j[d+14|0]=(b&127)<<25|g>>>7;f=0;l=i&2097151;d=l;j[a+10|0]=(h&131071)<<15|k>>>17|d<<4;b=b>>21;e=(c&2097151)<<11|g>>>21;i=e+(w&2097151)|0;c=i>>>0<e>>>0?b+1|0:b;d=i;j[a+17|0]=(c&1023)<<22|d>>>10;b=c;j[a+16|0]=(b&3)<<30|d>>>2;e=0;n=g&2097151;d=n;j[a+13|0]=(f&1048575)<<12|l>>>20|d<<1;b=b>>21;c=(c&2097151)<<11|i>>>21;f=c+(q&2097151)|0;g=f;b=f>>>0<c>>>0?b+1|0:b;d=f;j[a+20|0]=(b&8191)<<19|d>>>13;c=b;j[a+19|0]=(b&31)<<27|d>>>5;l=i&2097151;d=l;j[a+15|0]=(e&32767)<<17|n>>>15|d<<6;b=b>>21;d=(c&2097151)<<11|f>>>21;n=d+(s&2097151)|0;e=b;f=a;i=n;j[f+21|0]=i;b=g;j[f+18|0]=(h&262143)<<14|l>>>18|b<<3;d=i>>>0<d>>>0?e+1|0:e;j[f+22|0]=(d&255)<<24|i>>>8;b=d;e=b>>21;b=(b&2097151)<<11|i>>>21;g=b+(D&2097151)|0;c=e;h=g;c=g>>>0<b>>>0?c+1|0:c;e=g;j[f+25|0]=(c&2047)<<21|e>>>11;b=c;j[f+24|0]=(b&7)<<29|e>>>3;e=f;b=b>>21;c=(c&2097151)<<11|g>>>21;f=c+(t&2097151)|0;if(f>>>0<c>>>0){b=b+1|0}c=b;j[e+27|0]=(b&63)<<26|f>>>6;e=0;d=((d&65535)<<16|i>>>16)&31;i=h&2097151;b=i;j[a+23|0]=d|b<<5;h=(c&2097151)<<11|f>>>21;l=h+(r&2097151)|0;c=c>>21;c=l>>>0<h>>>0?c+1|0:c;h=l;d=h;j[a+31|0]=(c&131071)<<15|d>>>17;b=c;j[a+30|0]=(b&511)<<23|d>>>9;j[a+29|0]=(b&1)<<31|d>>>1;c=0;f=f&2097151;j[a+26|0]=(e&524287)<<13|i>>>19|f<<2;j[a+28|0]=(c&16383)<<18|f>>>14|d<<7}function va(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0,Fa=0,Ga=0,Ha=0,Ia=0,Ja=0,Ka=0,La=0,Ma=0,Na=0,Oa=0,Pa=0,Qa=0,Ra=0,Sa=0,Ta=0,Ua=0,Va=0,Wa=0,Xa=0,Ya=0,Za=0,_a=0,$a=0,ab=0,bb=0,cb=0;ma=ia(b);d=b;u=m[b+2|0]|m[b+3|0]<<8|(m[b+4|0]<<16|m[b+5|0]<<24);I=ia(b+5|0);w=K;p=m[b+7|0]|m[b+8|0]<<8|(m[b+9|0]<<16|m[b+10|0]<<24);r=m[b+10|0]|m[b+11|0]<<8|(m[b+12|0]<<16|m[b+13|0]<<24);H=ia(b+13|0);y=K;C=m[b+15|0]|m[b+16|0]<<8|(m[b+17|0]<<16|m[b+18|0]<<24);F=ia(b+18|0);s=K;G=ia(b+21|0);i=m[b+23|0]|m[b+24|0]<<8|(m[b+25|0]<<16|m[b+26|0]<<24);t=ia(b+26|0);b=K;d=m[d+28|0]|m[d+29|0]<<8|(m[d+30|0]<<16|m[d+31|0]<<24);z=ia(c);k=c;l=m[c+2|0]|m[c+3|0]<<8|(m[c+4|0]<<16|m[c+5|0]<<24);A=ia(c+5|0);o=K;q=m[c+7|0]|m[c+8|0]<<8|(m[c+9|0]<<16|m[c+10|0]<<24);n=m[c+10|0]|m[c+11|0]<<8|(m[c+12|0]<<16|m[c+13|0]<<24);v=ia(c+13|0);h=K;f=m[c+15|0]|m[c+16|0]<<8|(m[c+17|0]<<16|m[c+18|0]<<24);J=ia(c+18|0);g=K;wa=ia(c+21|0);e=m[c+23|0]|m[c+24|0]<<8|(m[c+25|0]<<16|m[c+26|0]<<24);x=ia(c+26|0);c=K;bb=a;L=(m[k+28|0]|m[k+29|0]<<8|(m[k+30|0]<<16|m[k+31|0]<<24))>>>7|0;M=((b&3)<<30|t>>>2)&2097151;b=ql(L,0,M,0);t=K;k=b;N=((c&3)<<30|x>>>2)&2097151;O=d>>>7|0;b=ql(N,0,O,0);c=k+b|0;d=K+t|0;d=c>>>0<b>>>0?d+1|0:d;B=c;b=ql(M,na,N,oa);k=K;P=e>>>5&2097151;c=ql(P,0,O,0);e=c+b|0;b=K+k|0;b=e>>>0<c>>>0?b+1|0:b;c=e;Q=i>>>5&2097151;e=ql(L,0,Q,0);i=c+e|0;b=K+b|0;b=i>>>0<e>>>0?b+1|0:b;e=i;k=b;b=e;t=k-((b>>>0<4293918720)+ -1|0)|0;x=b- -1048576|0;i=t;c=i>>21;t=(i&2097151)<<11|x>>>21;B=t+B|0;b=c+d|0;c=B;Aa=c- -1048576|0;b=c>>>0<t>>>0?b+1|0:b;d=b-((c>>>0<4293918720)+ -1|0)|0;t=d;d=Aa&-2097152;b=b-(t+(c>>>0<d>>>0)|0)|0;Ea=c-d|0;Ja=b;ja=ql(Ea,b,666643,0);B=K;R=l>>>5&2097151;S=G&2097151;b=ql(R,0,S,0);c=K;d=b;T=z&2097151;b=ql(T,0,Q,0);l=d+b|0;d=K+c|0;d=l>>>0<b>>>0?d+1|0:d;U=((o&3)<<30|A>>>2)&2097151;V=((s&7)<<29|F>>>3)&2097151;c=ql(U,0,V,0);o=c+l|0;b=K+d|0;d=o;c=d>>>0<c>>>0?b+1|0:b;W=q>>>7&2097151;X=C>>>6&2097151;b=ql(W,0,X,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;Y=n>>>4&2097151;Z=((y&1)<<31|H>>>1)&2097151;b=ql(Y,0,Z,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;_=((h&1)<<31|v>>>1)&2097151;$=r>>>4&2097151;d=ql(_,0,$,0);h=b+d|0;b=K+c|0;b=h>>>0<d>>>0?b+1|0:b;d=h;c=b;aa=f>>>6&2097151;ba=p>>>7&2097151;b=ql(aa,0,ba,0);f=b+d|0;d=K+c|0;d=f>>>0<b>>>0?d+1|0:d;b=0;ka=b;ca=wa&2097151;da=u>>>5&2097151;c=ql(ca,b,da,0);f=f+c|0;b=K+d|0;d=f;c=d>>>0<c>>>0?b+1|0:b;ea=((g&7)<<29|J>>>3)&2097151;fa=((w&3)<<30|I>>>2)&2097151;b=ql(ea,0,fa,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;ga=ma&2097151;d=ql(P,0,ga,0);g=b+d|0;b=K+c|0;h=g;g=h>>>0<d>>>0?b+1|0:b;b=ql(V,pa,R,0);c=K;d=b;b=ql(S,qa,T,ra);f=d+b|0;d=K+c|0;d=f>>>0<b>>>0?d+1|0:d;b=ql(X,0,U,sa);f=b+f|0;c=K+d|0;c=f>>>0<b>>>0?c+1|0:c;b=ql(W,0,Z,ta);d=b+f|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(Y,0,$,0);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;c=ql(_,E,ba,0);d=c+f|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(fa,ua,aa,0);f=c+d|0;d=K+b|0;d=f>>>0<c>>>0?d+1|0:d;b=ql(da,0,ea,D);f=b+f|0;c=K+d|0;c=f>>>0<b>>>0?c+1|0:c;b=ql(ga,va,ca,ka);d=b+f|0;c=K+c|0;f=d;c=d>>>0<b>>>0?c+1|0:c;C=c;b=d;d=c-((b>>>0<4293918720)+ -1|0)|0;y=b- -1048576|0;s=d;c=d>>21;d=(d&2097151)<<11|y>>>21;h=d+h|0;b=c+g|0;c=h;g=c>>>0<d>>>0?b+1|0:b;d=g+B|0;b=c;h=b+ja|0;if(h>>>0<b>>>0){d=d+1|0}b=h;g=g-((c>>>0<4293918720)+ -1|0)|0;h=g;Ba=c- -1048576|0;c=Ba&-2097152;u=b-c|0;w=d-((b>>>0<c>>>0)+h|0)|0;b=x&-2097152;p=e-b|0;r=k-((e>>>0<b>>>0)+i|0)|0;b=ql(M,na,P,0);c=K;d=b;b=ql(O,0,ca,ka);e=d+b|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(N,oa,Q,0);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(L,0,S,qa);d=c+e|0;b=K+b|0;i=d;e=d>>>0<c>>>0?b+1|0:b;b=ql(O,0,ea,D);c=K;d=b;b=ql(M,na,ca,ka);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(Q,0,P,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(N,oa,S,qa);g=b+d|0;d=K+c|0;d=g>>>0<b>>>0?d+1|0:d;c=ql(L,0,V,pa);g=c+g|0;b=K+d|0;b=g>>>0<c>>>0?b+1|0:b;q=b;b=g;c=q-((b>>>0<4293918720)+ -1|0)|0;o=b- -1048576|0;n=c;b=(c&2097151)<<11|o>>>21;i=b+i|0;c=(c>>21)+e|0;e=i;c=e>>>0<b>>>0?c+1|0:c;i=c;b=e;l=c-((b>>>0<4293918720)+ -1|0)|0;k=b- -1048576|0;c=l;d=c>>21;l=(c&2097151)<<11|k>>>21;p=l+p|0;b=d+r|0;Ka=p;b=p>>>0<l>>>0?b+1|0:b;La=b;d=k&-2097152;c=i-((e>>>0<d>>>0)+c|0)|0;Fa=e-d|0;Ma=c;d=ql(p,b,470296,0);e=d+u|0;b=K+w|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(Fa,c,654183,0);e=d+e|0;c=K+b|0;p=e;k=e>>>0<d>>>0?c+1|0:c;b=o&-2097152;r=g-b|0;n=q-((g>>>0<b>>>0)+n|0)|0;c=ql(Q,0,ca,ka);b=K;d=c;c=ql(O,0,aa,0);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(M,na,ea,D);e=c+d|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql(S,qa,P,0);d=b+e|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(N,oa,V,pa);e=b+d|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(L,0,X,0);e=c+e|0;b=K+d|0;g=e;e=e>>>0<c>>>0?b+1|0:b;c=ql(M,na,aa,0);b=K;d=c;c=ql(O,0,_,E);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(S,qa,ca,ka);i=c+d|0;c=K+b|0;c=i>>>0<d>>>0?c+1|0:c;b=ql(Q,0,ea,D);d=b+i|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(V,pa,P,0);i=b+d|0;d=K+c|0;d=i>>>0<b>>>0?d+1|0:d;c=ql(N,oa,X,0);i=c+i|0;b=K+d|0;b=i>>>0<c>>>0?b+1|0:b;c=ql(L,0,Z,ta);d=c+i|0;b=K+b|0;l=d;b=d>>>0<c>>>0?b+1|0:b;i=b;b=d;d=i-((b>>>0<4293918720)+ -1|0)|0;G=b- -1048576|0;A=d;b=d>>21;d=(d&2097151)<<11|G>>>21;g=d+g|0;c=b+e|0;o=g;c=g>>>0<d>>>0?c+1|0:c;v=c;b=g;d=c-((b>>>0<4293918720)+ -1|0)|0;z=b- -1048576|0;w=d;b=d>>21;c=(d&2097151)<<11|z>>>21;d=c+r|0;b=b+n|0;Na=d;b=d>>>0<c>>>0?b+1|0:b;Oa=b;b=ql(d,b,-997805,-1);d=b+p|0;c=K+k|0;r=d;g=d>>>0<b>>>0?c+1|0:c;b=y&-2097152;q=f-b|0;n=C-((f>>>0<b>>>0)+s|0)|0;b=ql(X,0,R,0);c=K;d=b;b=ql(V,pa,T,ra);e=d+b|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(U,sa,Z,ta);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(W,0,$,0);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;d=ql(Y,0,ba,0);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(_,E,fa,ua);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql(da,0,aa,0);e=b+e|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(ga,va,ea,D);e=c+e|0;b=K+d|0;k=e;e=e>>>0<c>>>0?b+1|0:b;b=ql(R,0,Z,ta);c=K;d=b;b=ql(X,0,T,ra);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(U,sa,$,0);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;d=ql(W,0,ba,0);f=d+f|0;c=K+b|0;c=f>>>0<d>>>0?c+1|0:c;b=ql(Y,0,fa,ua);f=b+f|0;d=K+c|0;d=f>>>0<b>>>0?d+1|0:d;c=ql(_,E,da,0);f=c+f|0;b=K+d|0;b=f>>>0<c>>>0?b+1|0:b;d=ql(ga,va,aa,0);f=d+f|0;c=K+b|0;y=f;c=f>>>0<d>>>0?c+1|0:c;f=c;b=y;d=c-((b>>>0<4293918720)+ -1|0)|0;Ca=b- -1048576|0;xa=d;b=d>>21;d=(d&2097151)<<11|Ca>>>21;k=d+k|0;c=b+e|0;C=k;c=k>>>0<d>>>0?c+1|0:c;ya=c;b=k;d=c-((b>>>0<4293918720)+ -1|0)|0;ha=b- -1048576|0;J=d;b=d>>21;d=(d&2097151)<<11|ha>>>21;e=d+q|0;c=b+n|0;c=e>>>0<d>>>0?c+1|0:c;d=ql(Ka,La,666643,0);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(Fa,Ma,470296,0);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql(Na,Oa,654183,0);e=b+e|0;d=K+c|0;q=e;d=e>>>0<b>>>0?d+1|0:d;wa=d;b=e;d=d-((b>>>0<4293918720)+ -1|0)|0;Da=b- -1048576|0;ja=d;c=d>>21;b=(d&2097151)<<11|Da>>>21;d=b+r|0;c=c+g|0;n=d;c=d>>>0<b>>>0?c+1|0:c;B=c;b=d;d=c-((b>>>0<4293918720)+ -1|0)|0;F=b- -1048576|0;x=d;Va=(d&2097151)<<11|F>>>21;p=d>>21;b=ql(Q,0,R,0);c=K;d=b;b=ql(M,na,T,ra);e=d+b|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(S,qa,U,sa);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(V,pa,W,0);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;d=ql(X,0,Y,0);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(Z,ta,_,E);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql($,0,aa,0);e=b+e|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(fa,ua,ca,ka);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(ba,0,ea,D);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;d=ql(P,0,da,0);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(N,oa,ga,va);e=d+e|0;c=K+b|0;g=e;c=e>>>0<d>>>0?c+1|0:c;k=c;ma=ql(Ea,Ja,470296,0);I=K;b=ql(L,0,O,0);la=b- -1048576|0;H=K;d=H-((b>>>0<4293918720)+ -1|0)|0;e=d;c=la&-2097152;u=b-c|0;c=H-((b>>>0<c>>>0)+d|0)|0;d=t>>21;b=(t&2097151)<<11|Aa>>>21;t=b+u|0;c=c+d|0;Pa=t;c=t>>>0<b>>>0?c+1|0:c;Qa=c;b=ql(t,c,666643,0);d=b+ma|0;c=K+I|0;c=d>>>0<b>>>0?c+1|0:c;s=d+g|0;b=c+k|0;b=s>>>0<d>>>0?b+1|0:b;_a=g- -1048576|0;k=k-((g>>>0<4293918720)+ -1|0)|0;g=k;c=h>>21;d=(h&2097151)<<11|Ba>>>21;h=s+d|0;b=b+c|0;b=h>>>0<d>>>0?b+1|0:b;c=ql(Ka,La,654183,0);h=c+h|0;d=K+b|0;d=h>>>0<c>>>0?d+1|0:d;b=ql(Fa,Ma,-997805,-1);h=b+h|0;c=K+d|0;c=h>>>0<b>>>0?c+1|0:c;d=ql(Na,Oa,136657,0);b=_a&-2097152;s=d+(h-b|0)|0;b=K+(c-((h>>>0<b>>>0)+g|0)|0)|0;k=s;u=k>>>0<d>>>0?b+1|0:b;c=u+p|0;b=k;d=b+Va|0;if(d>>>0<b>>>0){c=c+1|0}ma=d;t=c;b=z&-2097152;I=o-b|0;H=v-((o>>>0<b>>>0)+w|0)|0;c=e>>21;Ra=c;Ga=(e&2097151)<<11|la>>>21;b=ql(Ga,c,-683901,-1);c=b+l|0;d=K+i|0;d=c>>>0<b>>>0?d+1|0:d;b=G&-2097152;l=c-b|0;o=d-((c>>>0<b>>>0)+A|0)|0;b=ql(M,na,_,E);c=K;d=b;b=ql(O,0,Y,0);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(Q,0,aa,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(V,pa,ca,ka);e=b+d|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(S,qa,ea,D);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;c=ql(P,0,X,0);d=c+e|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(N,oa,Z,ta);e=c+d|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql(L,0,$,0);d=b+e|0;c=K+c|0;i=d;e=d>>>0<b>>>0?c+1|0:c;b=ql(M,na,Y,0);c=K;d=b;b=ql(O,0,W,0);h=d+b|0;d=K+c|0;d=h>>>0<b>>>0?d+1|0:d;c=ql(Q,0,_,E);h=c+h|0;b=K+d|0;b=h>>>0<c>>>0?b+1|0:b;c=ql(S,qa,aa,0);d=c+h|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(X,0,ca,ka);h=c+d|0;c=K+b|0;c=h>>>0<d>>>0?c+1|0:c;b=ql(V,pa,ea,D);d=b+h|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(P,0,Z,ta);h=b+d|0;d=K+c|0;d=h>>>0<b>>>0?d+1|0:d;c=ql(N,oa,$,0);h=c+h|0;b=K+d|0;b=h>>>0<c>>>0?b+1|0:b;c=ql(L,0,ba,0);d=c+h|0;b=K+b|0;G=d;b=d>>>0<c>>>0?b+1|0:b;w=b;b=d;d=w-((b>>>0<4293918720)+ -1|0)|0;z=b- -1048576|0;p=d;b=d>>21;d=(d&2097151)<<11|z>>>21;i=d+i|0;c=b+e|0;h=i;c=h>>>0<d>>>0?c+1|0:c;r=c;b=h;d=c-((b>>>0<4293918720)+ -1|0)|0;A=b- -1048576|0;s=d;b=d>>21;c=(d&2097151)<<11|A>>>21;d=c+l|0;b=b+o|0;i=d;b=d>>>0<c>>>0?b+1|0:b;l=b;b=d;d=l-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;o=d;b=d>>21;d=(d&2097151)<<11|v>>>21;e=d+I|0;c=b+H|0;Ha=e;c=e>>>0<d>>>0?c+1|0:c;Sa=c;$a=k- -1048576|0;b=u-((k>>>0<4293918720)+ -1|0)|0;e=b;c=ql(Ha,c,-683901,-1);k=c+ma|0;d=K+t|0;d=k>>>0<c>>>0?d+1|0:d;c=k;b=$a&-2097152;k=d-(e+(c>>>0<b>>>0)|0)|0;b=c-b|0;ab=b- -1048576|0;d=k-((b>>>0<4293918720)+ -1|0)|0;ma=d;c=ab&-2097152;cb=b-c|0;Wa=k-((b>>>0<c>>>0)+d|0)|0;b=ql(Ha,Sa,136657,0);c=F&-2097152;d=b+(n-c|0)|0;c=K+(B-((n>>>0<c>>>0)+x|0)|0)|0;B=d;k=d>>>0<b>>>0?c+1|0:c;b=v&-2097152;x=i-b|0;u=l-((i>>>0<b>>>0)+o|0)|0;b=ql(Pa,Qa,-683901,-1);c=K;d=b;b=ql(Ga,Ra,136657,0);i=d+b|0;d=K+c|0;c=h+i|0;b=r+(i>>>0<b>>>0?d+1|0:d)|0;b=c>>>0<h>>>0?b+1|0:b;d=c;c=A&-2097152;t=d-c|0;r=b-((d>>>0<c>>>0)+s|0)|0;c=ql(Ga,Ra,-997805,-1);d=c+G|0;b=K+w|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(Pa,Qa,136657,0);i=c+d|0;d=K+b|0;d=i>>>0<c>>>0?d+1|0:d;c=ql(Ea,Ja,-683901,-1);i=c+i|0;b=K+d|0;b=i>>>0<c>>>0?b+1|0:b;d=i;c=z&-2097152;o=d-c|0;n=b-((d>>>0<c>>>0)+p|0)|0;b=ql(M,na,W,0);c=K;d=b;b=ql(O,0,U,sa);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(Q,0,Y,0);i=b+d|0;d=K+c|0;d=i>>>0<b>>>0?d+1|0:d;c=ql(S,qa,_,E);i=c+i|0;b=K+d|0;b=i>>>0<c>>>0?b+1|0:b;c=ql(V,pa,aa,0);d=c+i|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(Z,ta,ca,ka);i=c+d|0;c=K+b|0;c=i>>>0<d>>>0?c+1|0:c;b=ql(X,0,ea,D);d=b+i|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(P,0,$,0);i=b+d|0;d=K+c|0;d=i>>>0<b>>>0?d+1|0:d;c=ql(N,oa,ba,0);i=c+i|0;b=K+d|0;b=i>>>0<c>>>0?b+1|0:b;c=ql(L,0,fa,ua);d=c+i|0;b=K+b|0;h=d;i=d>>>0<c>>>0?b+1|0:b;b=ql(M,na,U,sa);c=K;d=b;b=ql(O,0,R,0);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(Q,0,W,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(S,qa,Y,0);l=b+d|0;d=K+c|0;d=l>>>0<b>>>0?d+1|0:d;c=ql(V,pa,_,E);l=c+l|0;b=K+d|0;b=l>>>0<c>>>0?b+1|0:b;c=ql(X,0,aa,0);d=c+l|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql($,0,ca,ka);l=c+d|0;c=K+b|0;c=l>>>0<d>>>0?c+1|0:c;b=ql(Z,ta,ea,D);d=b+l|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(P,0,ba,0);l=b+d|0;d=K+c|0;d=l>>>0<b>>>0?d+1|0:d;c=ql(N,oa,fa,ua);l=c+l|0;b=K+d|0;b=l>>>0<c>>>0?b+1|0:b;c=ql(L,0,da,0);d=c+l|0;b=K+b|0;s=d;b=d>>>0<c>>>0?b+1|0:b;I=b;b=d;d=I-((b>>>0<4293918720)+ -1|0)|0;za=b- -1048576|0;H=d;b=d>>21;d=(d&2097151)<<11|za>>>21;h=d+h|0;c=b+i|0;l=h;c=h>>>0<d>>>0?c+1|0:c;F=c;b=h;d=c-((b>>>0<4293918720)+ -1|0)|0;Aa=b- -1048576|0;G=d;b=d>>21;c=(d&2097151)<<11|Aa>>>21;d=c+o|0;b=b+n|0;o=d;b=d>>>0<c>>>0?b+1|0:b;z=b;b=d;d=z-((b>>>0<4293918720)+ -1|0)|0;Ba=b- -1048576|0;A=d;b=d>>21;d=(d&2097151)<<11|Ba>>>21;i=d+t|0;c=b+r|0;h=i;c=h>>>0<d>>>0?c+1|0:c;v=c;b=h;d=c-((b>>>0<4293918720)+ -1|0)|0;la=b- -1048576|0;r=d;b=d>>21;c=(d&2097151)<<11|la>>>21;d=c+x|0;b=b+u|0;Ta=d;b=d>>>0<c>>>0?b+1|0:b;Ua=b;b=ql(d,b,-683901,-1);d=b+B|0;c=K+k|0;Xa=d;t=d>>>0<b>>>0?c+1|0:c;b=Da&-2097152;Ya=q-b|0;Za=wa-((q>>>0<b>>>0)+ja|0)|0;c=ql(Fa,Ma,666643,0);b=ha&-2097152;d=c+(C-b|0)|0;b=K+(ya-((C>>>0<b>>>0)+J|0)|0)|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(Na,Oa,470296,0);d=c+d|0;b=K+b|0;p=d;C=d>>>0<c>>>0?b+1|0:b;i=f;b=ql(R,0,$,0);c=K;d=b;b=ql(T,ra,Z,ta);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(U,sa,ba,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(W,0,fa,ua);f=b+d|0;d=K+c|0;d=f>>>0<b>>>0?d+1|0:d;c=ql(Y,0,da,0);f=c+f|0;b=K+d|0;b=f>>>0<c>>>0?b+1|0:b;c=ql(_,E,ga,va);d=c+f|0;b=K+b|0;k=d;f=d>>>0<c>>>0?b+1|0:b;b=ql(R,0,ba,0);c=K;d=b;b=ql(T,ra,$,0);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(U,sa,fa,ua);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(W,0,da,0);n=b+d|0;d=K+c|0;d=n>>>0<b>>>0?d+1|0:d;c=ql(Y,0,ga,va);n=c+n|0;b=K+d|0;q=n;b=n>>>0<c>>>0?b+1|0:b;J=b;b=n;c=J-((b>>>0<4293918720)+ -1|0)|0;Va=b- -1048576|0;wa=c;b=(c&2097151)<<11|Va>>>21;k=b+k|0;c=(c>>21)+f|0;n=k;c=k>>>0<b>>>0?c+1|0:c;ja=c;b=k;c=c-((b>>>0<4293918720)+ -1|0)|0;ha=b- -1048576|0;B=c;d=c>>21;c=(c&2097151)<<11|ha>>>21;f=c+y|0;b=d+i|0;b=f>>>0<c>>>0?b+1|0:b;d=ql(Na,Oa,666643,0);c=Ca&-2097152;i=d+(f-c|0)|0;c=K+(b-((f>>>0<c>>>0)+xa|0)|0)|0;k=i;c=i>>>0<d>>>0?c+1|0:c;x=c;b=i;d=c-((b>>>0<4293918720)+ -1|0)|0;Da=b- -1048576|0;u=d;b=d>>21;c=(d&2097151)<<11|Da>>>21;d=c+p|0;b=b+C|0;i=d;b=d>>>0<c>>>0?b+1|0:b;w=b;b=d;d=w-((b>>>0<4293918720)+ -1|0)|0;xa=b- -1048576|0;p=d;b=la&-2097152;f=v-((h>>>0<b>>>0)+r|0)|0;Ia=h-b|0;la=f;b=d>>21;d=(d&2097151)<<11|xa>>>21;h=d+Ya|0;c=b+Za|0;c=h>>>0<d>>>0?c+1|0:c;b=ql(Ha,Sa,-997805,-1);h=b+h|0;d=K+c|0;d=h>>>0<b>>>0?d+1|0:d;c=ql(Ta,Ua,136657,0);h=c+h|0;b=K+d|0;b=h>>>0<c>>>0?b+1|0:b;c=ql(Ia,f,-683901,-1);d=c+h|0;b=K+b|0;f=d;b=d>>>0<c>>>0?b+1|0:b;r=b;b=d;d=r-((b>>>0<4293918720)+ -1|0)|0;ya=b- -1048576|0;y=d;c=d>>21;d=(d&2097151)<<11|ya>>>21;h=d+Xa|0;b=c+t|0;b=h>>>0<d>>>0?b+1|0:b;d=h;C=b;b=d;t=C-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;h=t;c=h>>21;t=(h&2097151)<<11|v>>>21;Ca=t+cb|0;b=c+Wa|0;Wa=Ca;t=Ca>>>0<t>>>0?b+1|0:b;b=v&-2097152;Xa=d-b|0;Ya=C-((d>>>0<b>>>0)+h|0)|0;b=ya&-2097152;Za=f-b|0;Ca=r-((f>>>0<b>>>0)+y|0)|0;b=ql(Ha,Sa,654183,0);c=xa&-2097152;d=b+(i-c|0)|0;c=K+(w-((i>>>0<c>>>0)+p|0)|0)|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(Ta,Ua,-997805,-1);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;c=ql(Ia,la,136657,0);d=c+f|0;b=K+b|0;xa=d;w=d>>>0<c>>>0?b+1|0:b;b=Ba&-2097152;ya=o-b|0;z=z-((o>>>0<b>>>0)+A|0)|0;b=ql(Pa,Qa,-997805,-1);c=K;d=b;b=ql(Ga,Ra,654183,0);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(Ea,Ja,136657,0);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;c=ql(Ka,La,-683901,-1);d=c+f|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;d=d+l|0;c=b+F|0;c=d>>>0<l>>>0?c+1|0:c;b=Aa&-2097152;l=d-b|0;o=c-((d>>>0<b>>>0)+G|0)|0;b=ql(Pa,Qa,654183,0);c=K;d=b;b=ql(Ga,Ra,470296,0);d=d+b|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(Ea,Ja,-997805,-1);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;d=f+s|0;c=b+I|0;c=d>>>0<s>>>0?c+1|0:c;b=d;d=ql(Ka,La,136657,0);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;c=ql(Fa,Ma,-683901,-1);f=c+f|0;d=K+b|0;d=f>>>0<c>>>0?d+1|0:d;c=f;b=za&-2097152;i=c-b|0;f=d-((c>>>0<b>>>0)+H|0)|0;c=ql(M,na,R,0);b=K;d=c;c=ql(O,0,T,ra);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(Q,0,U,sa);d=c+d|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(S,qa,W,0);h=c+d|0;d=K+b|0;d=h>>>0<c>>>0?d+1|0:d;b=ql(V,pa,Y,0);h=b+h|0;c=K+d|0;c=h>>>0<b>>>0?c+1|0:c;b=ql(X,0,_,E);d=b+h|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(Z,ta,aa,0);h=b+d|0;b=K+c|0;b=h>>>0<d>>>0?b+1|0:b;c=ql(ba,0,ca,ka);d=c+h|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=ql($,0,ea,D);h=c+d|0;d=K+b|0;d=h>>>0<c>>>0?d+1|0:d;b=ql(P,0,fa,ua);h=b+h|0;c=K+d|0;c=h>>>0<b>>>0?c+1|0:c;b=ql(N,oa,da,0);d=b+h|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(L,0,ga,va);h=b+d|0;b=K+c|0;b=h>>>0<d>>>0?b+1|0:b;c=g>>21;d=(g&2097151)<<11|_a>>>21;g=d+h|0;b=b+c|0;h=g;b=h>>>0<d>>>0?b+1|0:b;p=b;b=h;d=p-((b>>>0<4293918720)+ -1|0)|0;A=b- -1048576|0;r=d;c=d>>21;b=(d&2097151)<<11|A>>>21;d=b+i|0;c=c+f|0;i=d;c=d>>>0<b>>>0?c+1|0:c;y=c;b=d;d=c-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;C=d;c=d>>21;d=(d&2097151)<<11|v>>>21;g=d+l|0;b=c+o|0;b=g>>>0<d>>>0?b+1|0:b;d=g;o=b;b=d;g=o-((b>>>0<4293918720)+ -1|0)|0;l=b- -1048576|0;f=g;c=f>>21;b=(f&2097151)<<11|l>>>21;g=b+ya|0;c=c+z|0;E=g;c=g>>>0<b>>>0?c+1|0:c;F=c;c=ql(g,c,-683901,-1);g=c+xa|0;b=K+w|0;w=g;g=g>>>0<c>>>0?b+1|0:b;b=l&-2097152;f=o-((d>>>0<b>>>0)+f|0)|0;D=d-b|0;G=f;b=ql(Ha,Sa,470296,0);c=Da&-2097152;o=b+(k-c|0)|0;d=K+(x-((k>>>0<c>>>0)+u|0)|0)|0;d=o>>>0<b>>>0?d+1|0:d;b=ql(Ta,Ua,654183,0);k=b+o|0;c=K+d|0;c=k>>>0<b>>>0?c+1|0:c;d=ql(Ia,la,-997805,-1);k=d+k|0;b=K+c|0;b=k>>>0<d>>>0?b+1|0:b;d=ql(E,F,136657,0);k=d+k|0;c=K+b|0;b=ql(D,f,-683901,-1);f=b+k|0;d=K+(k>>>0<d>>>0?c+1|0:c)|0;d=f>>>0<b>>>0?d+1|0:d;s=d;b=f;d=d-((b>>>0<4293918720)+ -1|0)|0;x=b- -1048576|0;l=d;b=d>>21;d=(d&2097151)<<11|x>>>21;k=d+w|0;c=b+g|0;g=k;c=g>>>0<d>>>0?c+1|0:c;o=c;b=g;d=c-((b>>>0<4293918720)+ -1|0)|0;u=b- -1048576|0;k=d;c=(d&2097151)<<11|u>>>21;w=c+Za|0;d=(d>>21)+Ca|0;Aa=w;w=w>>>0<c>>>0?d+1|0:d;b=u&-2097152;Ba=g-b|0;Da=o-((g>>>0<b>>>0)+k|0)|0;b=x&-2097152;I=f-b|0;H=s-((f>>>0<b>>>0)+l|0)|0;b=ql(Ha,Sa,666643,0);c=ha&-2097152;d=b+(n-c|0)|0;c=K+(ja-((n>>>0<c>>>0)+B|0)|0)|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(Ta,Ua,470296,0);g=b+d|0;d=K+c|0;d=g>>>0<b>>>0?d+1|0:d;b=ql(Ia,la,654183,0);g=b+g|0;c=K+d|0;o=g;g=g>>>0<b>>>0?c+1|0:c;b=v&-2097152;n=i-b|0;i=y-((i>>>0<b>>>0)+C|0)|0;c=ql(Pa,Qa,470296,0);b=K;d=c;c=ql(Ga,Ra,666643,0);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=ql(Ea,Ja,654183,0);f=c+d|0;d=K+b|0;d=f>>>0<c>>>0?d+1|0:d;b=ql(Ka,La,-997805,-1);f=b+f|0;c=K+d|0;c=f>>>0<b>>>0?c+1|0:c;b=ql(Fa,Ma,136657,0);d=b+f|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;d=d+h|0;b=c+p|0;b=d>>>0<h>>>0?b+1|0:b;c=ql(Na,Oa,-683901,-1);d=c+d|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;f=d;d=A&-2097152;c=f-d|0;f=b-((f>>>0<d>>>0)+r|0)|0;b=e>>21;d=(e&2097151)<<11|$a>>>21;e=d+c|0;c=b+f|0;k=e;c=e>>>0<d>>>0?c+1|0:c;C=c;b=e;d=c-((b>>>0<4293918720)+ -1|0)|0;A=b- -1048576|0;s=d;b=d>>21;d=(d&2097151)<<11|A>>>21;e=d+n|0;c=b+i|0;za=e;c=e>>>0<d>>>0?c+1|0:c;z=c;b=ql(e,c,-683901,-1);c=b+o|0;d=K+g|0;d=c>>>0<b>>>0?d+1|0:d;b=ql(E,F,-997805,-1);e=b+c|0;c=K+d|0;c=e>>>0<b>>>0?c+1|0:c;d=ql(D,G,136657,0);e=d+e|0;b=K+c|0;n=e;e=e>>>0<d>>>0?b+1|0:b;c=ql(R,0,fa,ua);b=K;d=c;c=ql(T,ra,ba,0);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(U,sa,da,0);g=c+d|0;c=K+b|0;c=g>>>0<d>>>0?c+1|0:c;b=ql(W,0,ga,va);g=b+g|0;d=K+c|0;d=g>>>0<b>>>0?d+1|0:d;i=g;b=ql(R,0,da,0);c=K;g=b;b=ql(T,ra,fa,ua);g=g+b|0;c=K+c|0;c=g>>>0<b>>>0?c+1|0:c;b=g;g=ql(U,sa,ga,va);f=b+g|0;b=K+c|0;h=f;b=f>>>0<g>>>0?b+1|0:b;g=b;b=f;f=g-((b>>>0<4293918720)+ -1|0)|0;v=b- -1048576|0;p=f;c=f>>>21|0;b=(f&2097151)<<11|v>>>21;f=b+i|0;c=c+d|0;i=f;c=f>>>0<b>>>0?c+1|0:c;r=c;b=f;d=c-((b>>>0<4293918720)+ -1|0)|0;ja=b- -1048576|0;l=d;c=d>>21;d=q+((d&2097151)<<11|ja>>>21)|0;b=c+J|0;b=d>>>0<q>>>0?b+1|0:b;f=d;c=Va&-2097152;d=ql(Ta,Ua,666643,0);q=(f-c|0)+d|0;c=K+(b-((f>>>0<c>>>0)+wa|0)|0)|0;c=q>>>0<d>>>0?c+1|0:c;b=ql(Ia,la,470296,0);d=b+q|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(za,z,136657,0);f=b+d|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;c=ql(E,F,654183,0);f=c+f|0;d=K+b|0;d=f>>>0<c>>>0?d+1|0:d;c=ql(D,G,-997805,-1);f=c+f|0;b=K+d|0;B=f;b=f>>>0<c>>>0?b+1|0:b;o=b;b=f;c=o-((b>>>0<4293918720)+ -1|0)|0;x=b- -1048576|0;q=c;b=(c&2097151)<<11|x>>>21;f=b+n|0;c=(c>>21)+e|0;c=f>>>0<b>>>0?c+1|0:c;e=c;b=f;c=c-((b>>>0<4293918720)+ -1|0)|0;u=b- -1048576|0;n=c;d=c>>21;c=(c&2097151)<<11|u>>>21;y=c+I|0;b=d+H|0;xa=y;y=y>>>0<c>>>0?b+1|0:b;d=f;c=A&-2097152;b=k-c|0;k=C-((k>>>0<c>>>0)+s|0)|0;f=(ma&2097151)<<11|ab>>>21;s=f+b|0;c=(ma>>21)+k|0;c=s>>>0<f>>>0?c+1|0:c;f=s;C=c;b=f;k=c-((b>>>0<4293918720)+ -1|0)|0;wa=b- -1048576|0;s=k;b=k>>21;J=b;ha=(k&2097151)<<11|wa>>>21;c=ql(ha,b,-683901,-1);d=c+d|0;b=K+e|0;b=d>>>0<c>>>0?b+1|0:b;c=u&-2097152;ya=d-c|0;ma=b-((d>>>0<c>>>0)+n|0)|0;b=ql(ha,J,136657,0);d=b+B|0;c=K+o|0;c=d>>>0<b>>>0?c+1|0:c;b=x&-2097152;I=d-b|0;A=c-((d>>>0<b>>>0)+q|0)|0;b=ql(Ia,la,666643,0);c=ja&-2097152;d=b+(i-c|0)|0;c=K+(r-((i>>>0<c>>>0)+l|0)|0)|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(za,z,-997805,-1);e=b+d|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(E,F,470296,0);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(D,G,654183,0);e=d+e|0;c=K+b|0;r=e;q=e>>>0<d>>>0?c+1|0:c;i=g;c=ql(R,0,ga,va);b=K;d=c;c=ql(T,ra,da,0);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=b;g=ql(T,ra,ga,va);b=K;H=b;b=g;e=H-((b>>>0<4293918720)+ -1|0)|0;ja=b- -1048576|0;l=e;k=c;c=e>>>21|0;b=(e&2097151)<<11|ja>>>21;e=k+b|0;d=c+d|0;d=e>>>0<b>>>0?d+1|0:d;o=d;b=e;d=d-((b>>>0<4293918720)+ -1|0)|0;B=b- -1048576|0;n=d;c=d>>>21|0;d=(d&2097151)<<11|B>>>21;h=d+h|0;b=c+i|0;b=h>>>0<d>>>0?b+1|0:b;c=ql(za,z,654183,0);i=h;d=v&-2097152;h=c+(h-d|0)|0;d=K+(b-((p&8191)+(i>>>0<d>>>0)|0)|0)|0;b=ql(E,F,666643,0);i=b+h|0;c=K+(h>>>0<c>>>0?d+1|0:d)|0;c=i>>>0<b>>>0?c+1|0:c;d=ql(D,G,470296,0);i=d+i|0;b=K+c|0;x=i;b=i>>>0<d>>>0?b+1|0:b;k=b;b=i;d=k-((b>>>0<4293918720)+ -1|0)|0;u=b- -1048576|0;h=d;c=d>>21;b=(d&2097151)<<11|u>>>21;d=b+r|0;c=c+q|0;p=d;c=d>>>0<b>>>0?c+1|0:c;i=c;b=d;q=c-((b>>>0<4293918720)+ -1|0)|0;r=b- -1048576|0;d=q;c=d>>21;q=(d&2097151)<<11|r>>>21;v=q+I|0;b=c+A|0;F=v;q=v>>>0<q>>>0?b+1|0:b;c=ql(ha,J,-997805,-1);p=c+p|0;b=K+i|0;b=p>>>0<c>>>0?b+1|0:b;i=p;c=r&-2097152;A=i-c|0;v=b-((i>>>0<c>>>0)+d|0)|0;b=ql(ha,J,654183,0);c=b+x|0;d=K+k|0;d=c>>>0<b>>>0?d+1|0:d;b=u&-2097152;u=c-b|0;p=d-((c>>>0<b>>>0)+h|0)|0;b=ql(za,z,470296,0);c=B&-2097152;d=b+(e-c|0)|0;c=K+(o-((n&8191)+(e>>>0<c>>>0)|0)|0)|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(D,G,666643,0);d=b+d|0;c=K+c|0;h=d;i=d>>>0<b>>>0?c+1|0:c;b=ql(za,z,666643,0);c=ja&-2097152;e=b+(g-c|0)|0;d=K+(H-((l&2047)+(g>>>0<c>>>0)|0)|0)|0;d=e>>>0<b>>>0?d+1|0:d;n=d;b=e;d=d-((b>>>0<4293918720)+ -1|0)|0;r=b- -1048576|0;k=d;b=d>>21;d=(d&2097151)<<11|r>>>21;g=d+h|0;c=b+i|0;l=g;c=g>>>0<d>>>0?c+1|0:c;h=c;b=g;d=c-((b>>>0<4293918720)+ -1|0)|0;o=b- -1048576|0;i=d;c=(d&2097151)<<11|o>>>21;g=c+u|0;d=(d>>21)+p|0;p=g;g=g>>>0<c>>>0?d+1|0:d;b=ql(ha,J,470296,0);d=b+l|0;c=K+h|0;c=d>>>0<b>>>0?c+1|0:c;h=d;d=o&-2097152;b=h-d|0;i=c-((h>>>0<d>>>0)+i|0)|0;o=b;b=ql(ha,J,666643,0);c=r&-2097152;h=b+(e-c|0)|0;d=K+(n-((e>>>0<c>>>0)+k|0)|0)|0;d=h>>>0<b>>>0?d+1|0:d;e=h;b=e;c=d>>21;d=(d&2097151)<<11|b>>>21;h=o+d|0;b=c+i|0;b=h>>>0<d>>>0?b+1|0:b;c=h;d=b>>21;b=(b&2097151)<<11|c>>>21;i=b+p|0;c=d+g|0;c=i>>>0<b>>>0?c+1|0:c;d=i;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+A|0;b=b+v|0;b=d>>>0<c>>>0?b+1|0:b;B=d;c=b>>21;b=(b&2097151)<<11|d>>>21;d=b+F|0;c=c+q|0;c=d>>>0<b>>>0?c+1|0:c;q=d;b=c>>21;c=(c&2097151)<<11|d>>>21;g=c+ya|0;d=b+ma|0;x=g;b=g;d=b>>>0<c>>>0?d+1|0:d;c=d>>21;d=(d&2097151)<<11|b>>>21;g=d+xa|0;b=c+y|0;u=g;c=g;b=c>>>0<d>>>0?b+1|0:b;d=b>>21;b=(b&2097151)<<11|c>>>21;g=b+Ba|0;c=d+Da|0;p=g;d=g;c=d>>>0<b>>>0?c+1|0:c;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+Aa|0;b=b+w|0;b=d>>>0<c>>>0?b+1|0:b;r=d;c=b>>21;b=(b&2097151)<<11|d>>>21;d=b+Xa|0;c=c+Ya|0;c=d>>>0<b>>>0?c+1|0:c;y=d;b=c>>21;c=(c&2097151)<<11|d>>>21;g=c+Wa|0;d=b+t|0;l=g;b=g;d=b>>>0<c>>>0?d+1|0:d;c=d>>21;g=(d&2097151)<<11|b>>>21;d=wa&-2097152;b=f-d|0;g=g+b|0;c=(C-((f>>>0<d>>>0)+s|0)|0)+c|0;o=g;d=g;c=d>>>0<b>>>0?c+1|0:c;s=(c&2097151)<<11|d>>>21;b=c>>21;n=b;c=ql(s,b,666643,0);b=e&2097151;c=c+b|0;d=K;k=c;d=c>>>0<b>>>0?d+1|0:d;e=d;j[bb|0]=c;j[a+1|0]=(d&255)<<24|c>>>8;b=h&2097151;g=ql(s,n,470296,0)+b|0;c=K;c=g>>>0<b>>>0?c+1|0:c;d=g;b=e>>21;g=(e&2097151)<<11|k>>>21;f=d+g|0;c=b+c|0;h=f;c=f>>>0<g>>>0?c+1|0:c;d=f;j[a+4|0]=(c&2047)<<21|d>>>11;b=c;j[a+3|0]=(b&7)<<29|d>>>3;c=a;g=i&2097151;f=ql(s,n,654183,0)+g|0;d=K;d=f>>>0<g>>>0?d+1|0:d;g=b;b=b>>21;g=(g&2097151)<<11|h>>>21;f=g+f|0;b=b+d|0;i=f;b=f>>>0<g>>>0?b+1|0:b;d=b;j[c+6|0]=(b&63)<<26|f>>>6;f=0;h=h&2097151;b=h;j[c+2|0]=((e&65535)<<16|k>>>16)&31|b<<5;e=c;b=B&2097151;g=ql(s,n,-997805,-1)+b|0;c=K;c=g>>>0<b>>>0?c+1|0:c;b=d>>21;d=(d&2097151)<<11|i>>>21;g=d+g|0;c=b+c|0;k=g;c=g>>>0<d>>>0?c+1|0:c;j[e+9|0]=(c&511)<<23|g>>>9;d=c;b=c;c=g;j[e+8|0]=(b&1)<<31|c>>>1;g=0;i=i&2097151;c=i;j[e+5|0]=(f&524287)<<13|h>>>19|c<<2;c=q&2097151;f=ql(s,n,136657,0)+c|0;b=K;b=f>>>0<c>>>0?b+1|0:b;c=f;f=(d&2097151)<<11|k>>>21;h=c+f|0;d=(d>>21)+b|0;d=h>>>0<f>>>0?d+1|0:d;j[e+12|0]=(d&4095)<<20|h>>>12;c=d;b=c;d=h;j[e+11|0]=(b&15)<<28|d>>>4;f=0;q=k&2097151;d=q;j[e+7|0]=(g&16383)<<18|i>>>14|d<<7;d=x&2097151;g=ql(s,n,-683901,-1)+d|0;b=K;b=g>>>0<d>>>0?b+1|0:b;d=g;g=(c&2097151)<<11|h>>>21;i=d+g|0;c=(c>>21)+b|0;c=i>>>0<g>>>0?c+1|0:c;b=c;j[e+14|0]=(b&127)<<25|i>>>7;g=0;k=h&2097151;d=k;j[e+10|0]=(f&131071)<<15|q>>>17|d<<4;b=b>>21;e=(c&2097151)<<11|i>>>21;h=e+(u&2097151)|0;c=h>>>0<e>>>0?b+1|0:b;d=h;j[a+17|0]=(c&1023)<<22|d>>>10;b=c;j[a+16|0]=(b&3)<<30|d>>>2;e=0;n=i&2097151;d=n;j[a+13|0]=(g&1048575)<<12|k>>>20|d<<1;b=b>>21;c=(c&2097151)<<11|h>>>21;g=c+(p&2097151)|0;i=g;b=g>>>0<c>>>0?b+1|0:b;d=g;j[a+20|0]=(b&8191)<<19|d>>>13;j[a+19|0]=(b&31)<<27|d>>>5;k=h&2097151;d=k;j[a+15|0]=(e&32767)<<17|n>>>15|d<<6;d=b>>21;g=a;e=(b&2097151)<<11|i>>>21;n=e+(r&2097151)|0;h=n;j[g+21|0]=h;b=i;j[g+18|0]=(f&262143)<<14|k>>>18|b<<3;e=h>>>0<e>>>0?d+1|0:d;j[g+22|0]=(e&255)<<24|h>>>8;b=e;d=b>>21;b=(b&2097151)<<11|h>>>21;i=b+(y&2097151)|0;c=d;c=i>>>0<b>>>0?c+1|0:c;d=i;j[g+25|0]=(c&2047)<<21|d>>>11;b=c;j[g+24|0]=(b&7)<<29|d>>>3;d=g;b=b>>21;c=(c&2097151)<<11|i>>>21;g=c+(l&2097151)|0;f=g;b=f>>>0<c>>>0?b+1|0:b;c=b;j[d+27|0]=(b&63)<<26|f>>>6;g=0;e=((e&65535)<<16|h>>>16)&31;h=i&2097151;b=h;j[d+23|0]=e|b<<5;e=(c&2097151)<<11|f>>>21;k=e+(o&2097151)|0;c=c>>21;c=k>>>0<e>>>0?c+1|0:c;e=k;d=e;j[a+31|0]=(c&131071)<<15|d>>>17;b=c;j[a+30|0]=(b&511)<<23|d>>>9;j[a+29|0]=(b&1)<<31|d>>>1;c=0;f=f&2097151;j[a+26|0]=(g&524287)<<13|h>>>19|f<<2;j[a+28|0]=(c&16383)<<18|f>>>14|d<<7}function fc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0;Bk(c,b);b=pa(d,a,64);g=l[c>>2];i=l[c+4>>2];d=0;while(1){f=b;z=l[f+32>>2];o=l[f+36>>2];e=_(z,o,14);k=K;e=_(z,o,18)^e;n=K^k;h=g;g=_(z,o,41)^e;k=h+g|0;e=(K^n)+i|0;e=k>>>0<g>>>0?e+1|0:e;g=k;t=l[f+48>>2];O=d<<3;i=O+35024|0;n=l[i>>2];g=n+g|0;e=l[i+4>>2]+e|0;e=g>>>0<n>>>0?e+1|0:e;A=l[f+40>>2];i=t^(A^t)&z;g=i+g|0;q=l[f+52>>2];y=l[f+44>>2];e=((q^y)&o^q)+e|0;e=g>>>0<i>>>0?e+1|0:e;i=g;g=l[f+56>>2];k=i+g|0;e=l[f+60>>2]+e|0;e=k>>>0<g>>>0?e+1|0:e;n=l[f+24>>2];i=k+n|0;g=e;e=e+l[f+28>>2]|0;h=i;e=h>>>0<n>>>0?e+1|0:e;u=e;l[f+24>>2]=h;l[f+28>>2]=e;p=l[f>>2];i=l[f+4>>2];e=_(p,i,28);n=K;e=_(p,i,34)^e;r=K^n;n=k+(_(p,i,39)^e)|0;e=g+(K^r)|0;e=n>>>0<k>>>0?e+1|0:e;j=n;r=l[f+16>>2];g=l[f+8>>2];n=p&(r|g)|g&r;k=j+n|0;m=l[f+20>>2];s=l[f+12>>2];e=(i&(m|s)|m&s)+e|0;e=k>>>0<n>>>0?e+1|0:e;n=k;k=e;l[f+56>>2]=n;l[f+60>>2]=e;j=r;e=_(h,u,14);r=K;v=_(h,u,18)^e;E=K^r;e=((o^y)&u^y)+q|0;r=(z^A)&h^A;t=r+t|0;if(t>>>0<r>>>0){e=e+1|0}r=t;t=_(h,u,41)^v;r=r+t|0;e=(K^E)+e|0;e=r>>>0<t>>>0?e+1|0:e;t=(d|1)<<3;E=t+c|0;q=E;v=l[q>>2];r=v+r|0;e=l[q+4>>2]+e|0;e=r>>>0<v>>>0?e+1|0:e;t=t+35024|0;q=l[t>>2];r=q+r|0;e=l[t+4>>2]+e|0;e=r>>>0<q>>>0?e+1|0:e;q=e;e=e+m|0;m=r;j=m+j|0;if(j>>>0<m>>>0){e=e+1|0}m=j;t=e;l[f+16>>2]=j;l[f+20>>2]=e;j=b;e=_(n,k,28);f=K;v=_(n,k,34)^e;w=K^f;e=((i|s)&k|i&s)+q|0;f=(g|p)&n|g&p;r=f+r|0;if(r>>>0<f>>>0){e=e+1|0}f=r;r=_(n,k,39)^v;f=f+r|0;e=(K^w)+e|0;e=f>>>0<r>>>0?e+1|0:e;r=f;f=e;l[j+48>>2]=r;l[j+52>>2]=e;v=b;j=g;e=_(m,t,14);g=K;q=_(m,t,18)^e;w=K^g;e=((o^u)&t^o)+y|0;g=(h^z)&m^z;A=g+A|0;if(A>>>0<g>>>0){e=e+1|0}q=_(m,t,41)^q;g=q+A|0;e=(K^w)+e|0;e=g>>>0<q>>>0?e+1|0:e;q=(d|2)<<3;H=q+c|0;A=H;y=l[A>>2];g=y+g|0;e=l[A+4>>2]+e|0;e=g>>>0<y>>>0?e+1|0:e;q=q+35024|0;A=l[q>>2];g=A+g|0;e=l[q+4>>2]+e|0;e=g>>>0<A>>>0?e+1|0:e;q=s;s=e;e=q+e|0;q=g+j|0;if(q>>>0<g>>>0){e=e+1|0}j=q;q=e;l[v+8>>2]=j;l[v+12>>2]=e;e=_(r,f,28);A=K;y=_(r,f,34)^e;A=K^A;e=((i|k)&f|i&k)+s|0;s=g;g=(n|p)&r|n&p;s=s+g|0;if(s>>>0<g>>>0){e=e+1|0}g=s;s=_(r,f,39)^y;g=g+s|0;e=(K^A)+e|0;e=g>>>0<s>>>0?e+1|0:e;s=g;g=e;l[v+40>>2]=s;l[v+44>>2]=e;A=b;v=i;e=_(j,q,14);i=K;y=_(j,q,18)^e;w=K^i;e=(u^(t^u)&q)+o|0;i=h^(h^m)&j;o=i+z|0;if(o>>>0<i>>>0){e=e+1|0}i=o;o=_(j,q,41)^y;i=i+o|0;e=(K^w)+e|0;e=i>>>0<o>>>0?e+1|0:e;o=(d|3)<<3;z=o+c|0;y=z;w=l[y>>2];i=w+i|0;e=l[y+4>>2]+e|0;e=i>>>0<w>>>0?e+1|0:e;o=o+35024|0;y=l[o>>2];i=y+i|0;e=l[o+4>>2]+e|0;e=i>>>0<y>>>0?e+1|0:e;y=e;e=e+v|0;o=i+p|0;if(o>>>0<i>>>0){e=e+1|0}v=e;l[A>>2]=o;l[A+4>>2]=e;e=_(s,g,28);p=K;w=_(s,g,34)^e;p=K^p;e=((f|k)&g|f&k)+y|0;x=i;i=(n|r)&s|n&r;y=x+i|0;if(y>>>0<i>>>0){e=e+1|0}i=y;y=_(s,g,39)^w;i=i+y|0;e=(K^p)+e|0;p=i;e=i>>>0<y>>>0?e+1|0:e;i=e;l[A+32>>2]=p;l[A+36>>2]=e;y=k;e=_(o,v,14);k=K;w=_(o,v,18)^e;x=K^k;e=u+(t^(q^t)&v)|0;k=h+(m^(j^m)&o)|0;if(k>>>0<h>>>0){e=e+1|0}h=_(o,v,41)^w;k=h+k|0;e=(K^x)+e|0;e=k>>>0<h>>>0?e+1|0:e;h=(d|4)<<3;M=h+c|0;u=M;w=l[u>>2];k=w+k|0;e=l[u+4>>2]+e|0;e=k>>>0<w>>>0?e+1|0:e;h=h+35024|0;u=l[h>>2];k=u+k|0;e=l[h+4>>2]+e|0;e=k>>>0<u>>>0?e+1|0:e;h=y;y=e;e=h+e|0;h=k+n|0;if(h>>>0<k>>>0){e=e+1|0}u=e;l[A+56>>2]=h;l[A+60>>2]=e;e=_(p,i,28);n=K;w=_(p,i,34)^e;n=K^n;e=((f|g)&i|f&g)+y|0;x=k;k=(r|s)&p|r&s;y=x+k|0;if(y>>>0<k>>>0){e=e+1|0}k=y;y=_(p,i,39)^w;k=k+y|0;e=(K^n)+e|0;n=k;e=k>>>0<y>>>0?e+1|0:e;k=e;l[A+24>>2]=n;l[A+28>>2]=e;y=b;w=f;e=_(h,u,14);f=K;A=_(h,u,18)^e;x=K^f;e=t+(q^(q^v)&u)|0;f=m+(j^(j^o)&h)|0;if(f>>>0<m>>>0){e=e+1|0}m=_(h,u,41)^A;f=m+f|0;e=(K^x)+e|0;e=f>>>0<m>>>0?e+1|0:e;m=(d|5)<<3;A=m+c|0;t=A;x=l[t>>2];f=x+f|0;e=l[t+4>>2]+e|0;e=f>>>0<x>>>0?e+1|0:e;m=m+35024|0;t=l[m>>2];f=t+f|0;e=l[m+4>>2]+e|0;e=f>>>0<t>>>0?e+1|0:e;m=w;w=e;e=m+e|0;m=f+r|0;if(m>>>0<f>>>0){e=e+1|0}t=e;l[y+48>>2]=m;l[y+52>>2]=e;e=_(n,k,28);r=K;x=_(n,k,34)^e;r=K^r;e=((g|i)&k|g&i)+w|0;w=f;f=(p|s)&n|p&s;w=w+f|0;if(w>>>0<f>>>0){e=e+1|0}f=w;w=_(n,k,39)^x;f=f+w|0;e=(K^r)+e|0;r=f;e=f>>>0<w>>>0?e+1|0:e;f=e;l[y+16>>2]=r;l[y+20>>2]=e;w=g;e=_(m,t,14);g=K;x=_(m,t,18)^e;I=K^g;e=q+(v^(u^v)&t)|0;g=j+(o^(h^o)&m)|0;if(g>>>0<j>>>0){e=e+1|0}j=_(m,t,41)^x;g=j+g|0;e=(K^I)+e|0;e=g>>>0<j>>>0?e+1|0:e;j=(d|6)<<3;P=j+c|0;q=P;x=l[q>>2];g=x+g|0;e=l[q+4>>2]+e|0;e=g>>>0<x>>>0?e+1|0:e;j=j+35024|0;q=l[j>>2];g=q+g|0;e=l[j+4>>2]+e|0;e=g>>>0<q>>>0?e+1|0:e;j=w;w=e;e=j+e|0;j=g+s|0;if(j>>>0<g>>>0){e=e+1|0}q=e;l[y+40>>2]=j;l[y+44>>2]=e;e=_(r,f,28);s=K;x=_(r,f,34)^e;s=K^s;e=((i|k)&f|i&k)+w|0;w=g;g=(n|p)&r|n&p;w=w+g|0;if(w>>>0<g>>>0){e=e+1|0}g=w;w=_(r,f,39)^x;g=g+w|0;e=(K^s)+e|0;s=g;e=g>>>0<w>>>0?e+1|0:e;g=e;l[y+8>>2]=s;l[y+12>>2]=e;w=b;x=i;e=_(j,q,14);i=K;y=_(j,q,18)^e;I=K^i;e=v+(u^(t^u)&q)|0;i=o+(h^(h^m)&j)|0;if(i>>>0<o>>>0){e=e+1|0}o=_(j,q,41)^y;i=o+i|0;e=(K^I)+e|0;e=i>>>0<o>>>0?e+1|0:e;o=(d|7)<<3;y=o+c|0;v=y;I=l[v>>2];i=I+i|0;e=l[v+4>>2]+e|0;e=i>>>0<I>>>0?e+1|0:e;o=o+35024|0;v=l[o>>2];i=v+i|0;e=l[o+4>>2]+e|0;e=i>>>0<v>>>0?e+1|0:e;o=x;x=e;e=o+e|0;o=i+p|0;if(o>>>0<i>>>0){e=e+1|0}v=e;l[w+32>>2]=o;l[w+36>>2]=e;e=_(s,g,28);p=K;I=_(s,g,34)^e;p=K^p;e=((f|k)&g|f&k)+x|0;x=i;i=(n|r)&s|n&r;x=x+i|0;if(x>>>0<i>>>0){e=e+1|0}i=x;x=_(s,g,39)^I;i=i+x|0;e=(K^p)+e|0;p=i;e=i>>>0<x>>>0?e+1|0:e;i=e;l[w>>2]=p;l[w+4>>2]=e;x=k;e=_(o,v,14);k=K;I=_(o,v,18)^e;F=K^k;e=u+(t^(q^t)&v)|0;k=h+(m^(j^m)&o)|0;if(k>>>0<h>>>0){e=e+1|0}h=_(o,v,41)^I;k=h+k|0;e=(K^F)+e|0;e=k>>>0<h>>>0?e+1|0:e;h=(d|8)<<3;I=h+c|0;u=I;F=l[u>>2];k=F+k|0;e=l[u+4>>2]+e|0;e=k>>>0<F>>>0?e+1|0:e;h=h+35024|0;u=l[h>>2];k=u+k|0;e=l[h+4>>2]+e|0;e=k>>>0<u>>>0?e+1|0:e;h=x;x=e;e=h+e|0;h=k+n|0;if(h>>>0<k>>>0){e=e+1|0}u=e;l[w+24>>2]=h;l[w+28>>2]=e;e=_(p,i,28);n=K;F=_(p,i,34)^e;n=K^n;e=((f|g)&i|f&g)+x|0;x=k;k=(r|s)&p|r&s;x=x+k|0;if(x>>>0<k>>>0){e=e+1|0}k=x;x=_(p,i,39)^F;k=k+x|0;e=(K^n)+e|0;n=k;e=k>>>0<x>>>0?e+1|0:e;k=e;l[w+56>>2]=n;l[w+60>>2]=e;x=b;F=f;e=_(h,u,14);f=K;w=_(h,u,18)^e;G=K^f;e=t+(q^(q^v)&u)|0;f=m+(j^(j^o)&h)|0;if(f>>>0<m>>>0){e=e+1|0}m=_(h,u,41)^w;f=m+f|0;e=(K^G)+e|0;e=f>>>0<m>>>0?e+1|0:e;m=(d|9)<<3;w=m+c|0;t=w;G=l[t>>2];f=G+f|0;e=l[t+4>>2]+e|0;e=f>>>0<G>>>0?e+1|0:e;m=m+35024|0;t=l[m>>2];f=t+f|0;e=l[m+4>>2]+e|0;e=f>>>0<t>>>0?e+1|0:e;m=F;F=e;e=m+e|0;m=f+r|0;if(m>>>0<f>>>0){e=e+1|0}t=e;l[x+16>>2]=m;l[x+20>>2]=e;e=_(n,k,28);r=K;G=_(n,k,34)^e;r=K^r;e=((g|i)&k|g&i)+F|0;F=f;f=(p|s)&n|p&s;F=F+f|0;if(F>>>0<f>>>0){e=e+1|0}f=F;F=_(n,k,39)^G;f=f+F|0;e=(K^r)+e|0;r=f;e=f>>>0<F>>>0?e+1|0:e;f=e;l[x+48>>2]=r;l[x+52>>2]=e;G=g;e=_(m,t,14);g=K;F=_(m,t,18)^e;C=K^g;e=q+(v^(u^v)&t)|0;g=j+(o^(h^o)&m)|0;if(g>>>0<j>>>0){e=e+1|0}j=_(m,t,41)^F;g=j+g|0;e=(K^C)+e|0;e=g>>>0<j>>>0?e+1|0:e;j=(d|10)<<3;F=j+c|0;q=F;C=l[q>>2];g=C+g|0;e=l[q+4>>2]+e|0;e=g>>>0<C>>>0?e+1|0:e;j=j+35024|0;q=l[j>>2];g=q+g|0;e=l[j+4>>2]+e|0;e=g>>>0<q>>>0?e+1|0:e;j=e;e=e+G|0;q=g+s|0;if(q>>>0<g>>>0){e=e+1|0}s=q;q=e;l[x+8>>2]=s;l[x+12>>2]=e;e=_(r,f,28);G=K;C=_(r,f,34)^e;G=K^G;e=((i|k)&f|i&k)+j|0;j=g;g=(n|p)&r|n&p;j=j+g|0;if(j>>>0<g>>>0){e=e+1|0}g=j;j=_(r,f,39)^C;g=g+j|0;e=(K^G)+e|0;e=g>>>0<j>>>0?e+1|0:e;j=e;l[x+40>>2]=g;l[x+44>>2]=e;G=b;C=i;e=_(s,q,14);i=K;x=_(s,q,18)^e;D=K^i;e=v+(u^(t^u)&q)|0;i=o+(h^(h^m)&s)|0;if(i>>>0<o>>>0){e=e+1|0}o=_(s,q,41)^x;i=o+i|0;e=(K^D)+e|0;e=i>>>0<o>>>0?e+1|0:e;o=(d|11)<<3;x=o+c|0;v=x;D=l[v>>2];i=D+i|0;e=l[v+4>>2]+e|0;e=i>>>0<D>>>0?e+1|0:e;o=o+35024|0;v=l[o>>2];i=v+i|0;e=l[o+4>>2]+e|0;e=i>>>0<v>>>0?e+1|0:e;o=e;e=e+C|0;v=i+p|0;if(v>>>0<i>>>0){e=e+1|0}p=v;v=e;l[G>>2]=p;l[G+4>>2]=e;e=_(g,j,28);C=K;D=_(g,j,34)^e;C=K^C;e=((f|k)&j|f&k)+o|0;o=i;i=(n|r)&g|n&r;o=o+i|0;if(o>>>0<i>>>0){e=e+1|0}i=o;o=_(g,j,39)^D;i=i+o|0;e=(K^C)+e|0;e=i>>>0<o>>>0?e+1|0:e;o=e;l[G+32>>2]=i;l[G+36>>2]=e;C=b;D=k;e=_(p,v,14);k=K;G=_(p,v,18)^e;J=K^k;e=u+(t^(q^t)&v)|0;k=h+(m^(m^s)&p)|0;if(k>>>0<h>>>0){e=e+1|0}h=_(p,v,41)^G;k=h+k|0;e=(K^J)+e|0;e=k>>>0<h>>>0?e+1|0:e;h=(d|12)<<3;G=h+c|0;u=G;J=l[u>>2];k=J+k|0;e=l[u+4>>2]+e|0;e=k>>>0<J>>>0?e+1|0:e;h=h+35024|0;u=l[h>>2];k=u+k|0;e=l[h+4>>2]+e|0;e=k>>>0<u>>>0?e+1|0:e;h=D;D=e;e=h+e|0;h=k+n|0;if(h>>>0<k>>>0){e=e+1|0}J=h;h=e;l[C+56>>2]=J;l[C+60>>2]=e;u=b;e=_(i,o,28);n=K;C=_(i,o,34)^e;n=K^n;e=((f|j)&o|f&j)+D|0;D=k;k=(g|r)&i|g&r;D=D+k|0;if(D>>>0<k>>>0){e=e+1|0}C=_(i,o,39)^C;k=C+D|0;e=(K^n)+e|0;D=k;e=k>>>0<C>>>0?e+1|0:e;n=e;l[u+24>>2]=k;l[u+28>>2]=e;k=b;u=r;C=f;e=_(J,h,14);f=K;r=_(J,h,18)^e;B=K^f;e=t+(q^(q^v)&h)|0;f=m+(s^(p^s)&J)|0;if(f>>>0<m>>>0){e=e+1|0}r=_(J,h,41)^r;f=r+f|0;e=(K^B)+e|0;e=f>>>0<r>>>0?e+1|0:e;m=(d|13)<<3;r=m+c|0;B=l[r>>2];f=B+f|0;e=l[r+4>>2]+e|0;e=f>>>0<B>>>0?e+1|0:e;m=m+35024|0;t=l[m>>2];f=t+f|0;e=l[m+4>>2]+e|0;e=f>>>0<t>>>0?e+1|0:e;t=e;e=e+C|0;u=f+u|0;if(u>>>0<f>>>0){e=e+1|0}C=u;m=e;l[k+48>>2]=u;l[k+52>>2]=e;e=_(D,n,28);u=K;B=_(D,n,34)^e;u=K^u;e=((j|o)&n|j&o)+t|0;t=f;f=(g|i)&D|g&i;t=t+f|0;if(t>>>0<f>>>0){e=e+1|0}f=t;t=_(D,n,39)^B;f=f+t|0;e=(K^u)+e|0;e=f>>>0<t>>>0?e+1|0:e;t=f;f=e;l[k+16>>2]=t;l[k+20>>2]=e;e=_(C,m,14);u=K;B=_(C,m,18)^e;u=K^u;e=q+(v^(h^v)&m)|0;q=s+(p^(p^J)&C)|0;if(q>>>0<s>>>0){e=e+1|0}s=q;q=_(C,m,41)^B;s=s+q|0;e=(K^u)+e|0;e=s>>>0<q>>>0?e+1|0:e;q=(d|14)<<3;u=q+c|0;L=l[u>>2];s=L+s|0;e=l[u+4>>2]+e|0;e=s>>>0<L>>>0?e+1|0:e;q=q+35024|0;B=l[q>>2];s=B+s|0;e=l[q+4>>2]+e|0;e=s>>>0<B>>>0?e+1|0:e;B=s;s=e;e=j+e|0;j=g+B|0;if(j>>>0<g>>>0){e=e+1|0}q=j;g=e;l[k+40>>2]=j;l[k+44>>2]=e;e=_(t,f,28);j=K;L=_(t,f,34)^e;j=K^j;e=((n|o)&f|n&o)+s|0;s=(i|D)&t|i&D;B=s+B|0;if(B>>>0<s>>>0){e=e+1|0}s=B;B=_(t,f,39)^L;s=s+B|0;e=(K^j)+e|0;e=s>>>0<B>>>0?e+1|0:e;B=s;j=e;l[k+8>>2]=s;l[k+12>>2]=e;e=_(q,g,14);s=K;L=_(q,g,18)^e;s=K^s;e=v+(h^(h^m)&g)|0;h=p+(J^(C^J)&q)|0;if(h>>>0<p>>>0){e=e+1|0}p=_(q,g,41)^L;g=p+h|0;e=(K^s)+e|0;e=g>>>0<p>>>0?e+1|0:e;p=(d|15)<<3;s=p+c|0;h=s;m=l[h>>2];g=m+g|0;e=l[h+4>>2]+e|0;e=g>>>0<m>>>0?e+1|0:e;p=p+35024|0;h=l[p>>2];g=h+g|0;e=l[p+4>>2]+e|0;p=g;g=g>>>0<h>>>0?e+1|0:e;e=o+g|0;h=i+p|0;if(h>>>0<i>>>0){e=e+1|0}l[k+32>>2]=h;l[k+36>>2]=e;e=_(B,j,28);k=K;i=_(B,j,34)^e;h=K^k;e=((f|n)&j|f&n)+g|0;f=(t|D)&B|t&D;g=f+p|0;if(g>>>0<f>>>0){e=e+1|0}f=g;g=_(B,j,39)^i;f=f+g|0;e=(K^h)+e|0;k=b;l[k>>2]=f;l[k+4>>2]=f>>>0<g>>>0?e+1|0:e;if((d|0)==64){while(1){d=N<<3;c=d+a|0;k=c;e=b+d|0;f=l[e>>2];d=f+l[k>>2]|0;e=l[k+4>>2]+l[e+4>>2]|0;l[k>>2]=d;l[k+4>>2]=d>>>0<f>>>0?e+1|0:e;N=N+1|0;if((N|0)!=8){continue}break}}else{d=d+16|0;p=(d<<3)+c|0;k=l[u+4>>2];C=k;e=k>>>6|0;D=l[u>>2];k=((k&63)<<26|D>>>6)^_(D,k,19);e=K^e;k=_(D,C,61)^k;i=l[w+4>>2];e=i+(K^e)|0;f=k;q=l[w>>2];k=q;f=f+k|0;if(f>>>0<k>>>0){e=e+1|0}h=f;f=c+O|0;g=l[f>>2];k=h+g|0;e=l[f+4>>2]+e|0;h=k;k=h>>>0<g>>>0?e+1|0:e;f=l[E+4>>2];g=f;e=f>>>7|0;n=l[E>>2];f=((f&127)<<25|n>>>7)^_(n,f,1);e=K^e;j=h;h=_(n,g,8)^f;f=j+h|0;e=(K^e)+k|0;j=f;e=f>>>0<h>>>0?e+1|0:e;f=e;l[p>>2]=j;l[p+4>>2]=e;h=E;e=l[h+76>>2]+g|0;k=l[h+72>>2];g=k+n|0;if(g>>>0<k>>>0){e=e+1|0}p=g;g=e;n=l[s+4>>2];k=n;e=k>>>6|0;t=l[s>>2];n=((k&63)<<26|t>>>6)^_(t,k,19);e=K^e;m=p;p=_(t,k,61)^n;n=m+p|0;e=(K^e)+g|0;o=n;g=n>>>0<p>>>0?e+1|0:e;m=l[E+12>>2];n=m;e=m>>>7|0;p=l[E+8>>2];m=((m&127)<<25|p>>>7)^_(p,m,1);e=K^e;v=o;o=_(p,n,8)^m;m=v+o|0;e=(K^e)+g|0;e=m>>>0<o>>>0?e+1|0:e;o=m;g=e;l[h+128>>2]=m;l[h+132>>2]=e;h=H;m=n;e=_(j,f,19);v=K;n=e;e=f>>>6|0;f=_(j,f,61)^(n^((f&63)<<26|j>>>6));j=p;n=l[x+4>>2];e=n+(K^(e^v))|0;p=f;v=l[x>>2];f=v;p=p+f|0;if(p>>>0<f>>>0){e=e+1|0}f=j+p|0;e=e+m|0;E=f;f=f>>>0<p>>>0?e+1|0:e;m=l[z+4>>2];p=m;e=m>>>7|0;j=l[z>>2];m=((m&127)<<25|j>>>7)^_(j,m,1);e=K^e;B=E;E=_(j,p,8)^m;m=B+E|0;e=(K^e)+f|0;e=m>>>0<E>>>0?e+1|0:e;E=m;f=e;l[h+128>>2]=m;l[h+132>>2]=e;m=z;e=l[m+76>>2]+p|0;p=l[m+72>>2];h=p+j|0;if(h>>>0<p>>>0){e=e+1|0}p=h;h=e;e=_(o,g,19);j=K;B=p;p=e;e=g>>>6|0;p=_(o,g,61)^(p^((g&63)<<26|o>>>6));g=B+p|0;e=(K^(e^j))+h|0;o=g;g=g>>>0<p>>>0?e+1|0:e;j=l[z+12>>2];p=j;e=j>>>7|0;h=l[z+8>>2];j=((j&127)<<25|h>>>7)^_(h,j,1);e=K^e;z=o;o=_(h,p,8)^j;j=z+o|0;e=(K^e)+g|0;e=j>>>0<o>>>0?e+1|0:e;o=j;g=e;l[m+128>>2]=j;l[m+132>>2]=e;m=M;j=p;e=_(E,f,19);z=K;p=e;e=f>>>6|0;f=_(E,f,61)^(p^((f&63)<<26|E>>>6));B=h;p=l[r+4>>2];e=p+(K^(e^z))|0;h=f;E=l[r>>2];f=E;h=h+f|0;if(h>>>0<f>>>0){e=e+1|0}f=B+h|0;e=e+j|0;H=f;f=f>>>0<h>>>0?e+1|0:e;z=l[A+4>>2];h=z;e=h>>>7|0;j=l[A>>2];z=((h&127)<<25|j>>>7)^_(j,h,1);e=K^e;B=H;H=_(j,h,8)^z;z=B+H|0;e=(K^e)+f|0;e=z>>>0<H>>>0?e+1|0:e;f=e;l[m+128>>2]=z;l[m+132>>2]=e;m=A;e=l[m+76>>2]+h|0;h=l[m+72>>2];j=h+j|0;if(j>>>0<h>>>0){e=e+1|0}h=j;j=e;e=_(o,g,19);H=K;B=h;h=e;e=g>>>6|0;h=_(o,g,61)^(h^((g&63)<<26|o>>>6));g=B+h|0;e=(K^(e^H))+j|0;o=g;g=g>>>0<h>>>0?e+1|0:e;j=l[A+12>>2];h=j;e=h>>>7|0;H=l[A+8>>2];j=((h&127)<<25|H>>>7)^_(H,h,1);e=K^e;A=o;o=_(H,h,8)^j;j=A+o|0;e=(K^e)+g|0;A=j;e=j>>>0<o>>>0?e+1|0:e;g=e;l[m+128>>2]=j;l[m+132>>2]=e;m=P;j=h;e=_(z,f,19);M=K;h=e;e=f>>>6|0;h=_(z,f,61)^(h^((f&63)<<26|z>>>6));f=h+t|0;e=(K^(e^M))+k|0;e=f>>>0<h>>>0?e+1|0:e;h=f;f=f+H|0;e=e+j|0;z=f;f=f>>>0<h>>>0?e+1|0:e;o=l[y+4>>2];h=o;e=h>>>7|0;j=l[y>>2];o=((h&127)<<25|j>>>7)^_(j,h,1);e=K^e;B=z;z=_(j,h,8)^o;o=B+z|0;e=(K^e)+f|0;e=o>>>0<z>>>0?e+1|0:e;f=e;l[m+128>>2]=o;l[m+132>>2]=e;m=y;e=l[m+76>>2]+h|0;h=l[m+72>>2];j=h+j|0;if(j>>>0<h>>>0){e=e+1|0}h=j;j=e;e=_(A,g,19);z=K;B=h;h=e;e=g>>>6|0;h=_(A,g,61)^(h^((g&63)<<26|A>>>6));g=B+h|0;e=(K^(e^z))+j|0;z=g;g=g>>>0<h>>>0?e+1|0:e;j=l[y+12>>2];h=j;e=h>>>7|0;A=l[y+8>>2];j=((h&127)<<25|A>>>7)^_(A,h,1);e=K^e;y=z;z=_(A,h,8)^j;j=y+z|0;e=(K^e)+g|0;e=j>>>0<z>>>0?e+1|0:e;z=j;g=e;l[m+128>>2]=j;l[m+132>>2]=e;j=h;e=_(o,f,19);y=K;h=e;e=f>>>6|0;f=_(o,f,61)^(h^((f&63)<<26|o>>>6));m=I;h=l[m+72>>2];f=f+h|0;e=l[m+76>>2]+(K^(e^y))|0;e=f>>>0<h>>>0?e+1|0:e;h=f;f=f+A|0;e=e+j|0;e=f>>>0<h>>>0?e+1|0:e;h=e;e=_(q,i,1);j=K;y=f;o=e;f=i;e=f>>>7|0;o=o^((f&127)<<25|q>>>7)^_(q,f,8);f=y+o|0;e=(K^(e^j))+h|0;j=f;e=f>>>0<o>>>0?e+1|0:e;f=e;l[m+128>>2]=j;l[m+132>>2]=e;h=w;e=l[h+76>>2]+i|0;i=l[h+72>>2];m=i+q|0;if(m>>>0<i>>>0){e=e+1|0}i=m;m=e;e=_(z,g,19);o=K;q=i;i=e;e=g>>>6|0;i=_(z,g,61)^(i^((g&63)<<26|z>>>6));g=q+i|0;e=(K^(e^o))+m|0;o=g;g=g>>>0<i>>>0?e+1|0:e;m=l[w+12>>2];i=m;e=i>>>7|0;q=l[w+8>>2];m=((i&127)<<25|q>>>7)^_(q,i,1);e=K^e;w=o;o=_(q,i,8)^m;m=w+o|0;e=(K^e)+g|0;e=m>>>0<o>>>0?e+1|0:e;o=m;g=e;l[h+128>>2]=m;l[h+132>>2]=e;m=i;e=_(j,f,19);z=K;i=e;e=f>>>6|0;f=_(j,f,61)^(i^((f&63)<<26|j>>>6));h=F;i=l[h+72>>2];f=f+i|0;e=l[h+76>>2]+(K^(e^z))|0;e=f>>>0<i>>>0?e+1|0:e;i=f;f=f+q|0;e=e+m|0;e=f>>>0<i>>>0?e+1|0:e;i=e;e=_(v,n,1);m=K;q=f;j=e;f=n;e=f>>>7|0;j=j^((f&127)<<25|v>>>7)^_(v,f,8);f=q+j|0;e=(K^(e^m))+i|0;m=f;e=f>>>0<j>>>0?e+1|0:e;f=e;l[h+128>>2]=m;l[h+132>>2]=e;h=x;e=l[h+76>>2]+n|0;i=l[h+72>>2];n=i+v|0;if(n>>>0<i>>>0){e=e+1|0}i=n;n=e;e=_(o,g,19);j=K;q=i;i=e;e=g>>>6|0;i=_(o,g,61)^(i^((g&63)<<26|o>>>6));g=q+i|0;e=(K^(e^j))+n|0;j=g;g=g>>>0<i>>>0?e+1|0:e;n=l[x+12>>2];i=n;e=i>>>7|0;o=l[x+8>>2];n=((i&127)<<25|o>>>7)^_(o,i,1);e=K^e;q=j;j=_(o,i,8)^n;n=q+j|0;e=(K^e)+g|0;e=n>>>0<j>>>0?e+1|0:e;j=n;g=e;l[h+128>>2]=j;l[h+132>>2]=e;h=i;e=_(m,f,19);q=K;i=e;e=f>>>6|0;f=_(m,f,61)^(i^((f&63)<<26|m>>>6));n=G;i=l[n+72>>2];f=f+i|0;e=l[n+76>>2]+(K^(e^q))|0;e=f>>>0<i>>>0?e+1|0:e;i=f;f=f+o|0;e=e+h|0;e=f>>>0<i>>>0?e+1|0:e;i=e;e=_(E,p,1);h=K;o=f;m=e;f=p;e=f>>>7|0;m=m^((f&127)<<25|E>>>7)^_(E,f,8);f=o+m|0;e=(K^(e^h))+i|0;h=f;e=f>>>0<m>>>0?e+1|0:e;f=e;l[n+128>>2]=h;l[n+132>>2]=e;i=r;e=l[i+76>>2]+p|0;n=l[i+72>>2];p=n+E|0;if(p>>>0<n>>>0){e=e+1|0}n=p;p=e;e=_(j,g,19);m=K;o=n;n=e;e=g>>>6|0;n=_(j,g,61)^(n^((g&63)<<26|j>>>6));g=o+n|0;e=(K^(e^m))+p|0;m=g;g=g>>>0<n>>>0?e+1|0:e;n=l[r+12>>2];p=n;e=n>>>7|0;r=l[r+8>>2];n=((n&127)<<25|r>>>7)^_(r,n,1);e=K^e;r=_(r,p,8)^n;n=r+m|0;e=(K^e)+g|0;p=n;e=n>>>0<r>>>0?e+1|0:e;g=e;l[i+128>>2]=n;l[i+132>>2]=e;i=u;e=l[i+76>>2]+C|0;n=l[i+72>>2];r=n+D|0;if(r>>>0<n>>>0){e=e+1|0}n=r;r=e;e=_(h,f,19);m=K;j=n;n=e;e=f>>>6|0;n=_(h,f,61)^(n^((f&63)<<26|h>>>6));f=j+n|0;e=(K^(e^m))+r|0;e=f>>>0<n>>>0?e+1|0:e;n=e;e=_(t,k,1);r=K;j=f;h=e;f=k;e=f>>>7|0;h=h^((f&127)<<25|t>>>7)^_(t,f,8);f=j+h|0;e=(K^(e^r))+n|0;l[i+128>>2]=f;l[i+132>>2]=f>>>0<h>>>0?e+1|0:e;f=s;e=l[f+76>>2]+k|0;k=l[f+72>>2];i=k+t|0;if(i>>>0<k>>>0){e=e+1|0}k=i;i=e;e=_(p,g,19);n=K;h=e;e=g>>>6|0;g=_(p,g,61)^(h^((g&63)<<26|p>>>6));k=g+k|0;e=(K^(e^n))+i|0;r=k;k=k>>>0<g>>>0?e+1|0:e;n=l[s+12>>2];i=n;e=i>>>7|0;g=l[s+8>>2];n=((i&127)<<25|g>>>7)^_(g,i,1);e=K^e;h=r;r=_(g,i,8)^n;n=h+r|0;e=(K^e)+k|0;l[f+128>>2]=n;l[f+132>>2]=n>>>0<r>>>0?e+1|0:e;continue}break}}function tb(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ja=0,ka=0;ea=ia(a);fa=m[a+2|0]|m[a+3|0]<<8|(m[a+4|0]<<16|m[a+5|0]<<24);ga=ia(a+5|0);ha=K;Y=m[a+7|0]|m[a+8|0]<<8|(m[a+9|0]<<16|m[a+10|0]<<24);Z=m[a+10|0]|m[a+11|0]<<8|(m[a+12|0]<<16|m[a+13|0]<<24);ja=ia(a+13|0);_=K;r=m[a+15|0]|m[a+16|0]<<8|(m[a+17|0]<<16|m[a+18|0]<<24);F=ia(a+18|0);s=K;l=ia(a+21|0);g=m[a+23|0]|m[a+24|0]<<8|(m[a+25|0]<<16|m[a+26|0]<<24);f=ia(a+26|0);d=K;R=m[a+28|0]|m[a+29|0]<<8|(m[a+30|0]<<16|m[a+31|0]<<24);z=m[a+31|0]|m[a+32|0]<<8|(m[a+33|0]<<16|m[a+34|0]<<24);D=ia(a+34|0);C=K;t=m[a+36|0]|m[a+37|0]<<8|(m[a+38|0]<<16|m[a+39|0]<<24);G=ia(a+39|0);v=K;i=ia(a+42|0);e=m[a+44|0]|m[a+45|0]<<8|(m[a+46|0]<<16|m[a+47|0]<<24);ka=a;c=ia(a+47|0);h=K;H=((h&3)<<30|c>>>2)&2097151;b=ql(H,0,136657,0);c=K;d=((d&3)<<30|f>>>2)&2097151;b=d+b|0;if(b>>>0<d>>>0){c=c+1|0}I=(m[a+49|0]|m[a+50|0]<<8|(m[a+51|0]<<16|m[a+52|0]<<24))>>>7&2097151;d=ql(I,0,-997805,-1);f=d+b|0;b=K+c|0;b=f>>>0<d>>>0?b+1|0:b;J=(m[a+52|0]|m[a+53|0]<<8|(m[a+54|0]<<16|m[a+55|0]<<24))>>>4&2097151;c=ql(J,0,654183,0);f=c+f|0;d=K+b|0;d=f>>>0<c>>>0?d+1|0:d;b=f;c=ia(a+55|0);f=K;L=((f&1)<<31|c>>>1)&2097151;c=ql(L,0,470296,0);f=b+c|0;b=K+d|0;b=f>>>0<c>>>0?b+1|0:b;M=(m[a+57|0]|m[a+58|0]<<8|(m[a+59|0]<<16|m[a+60|0]<<24))>>>6&2097151;d=ql(M,0,666643,0);f=d+f|0;c=K+b|0;c=f>>>0<d>>>0?c+1|0:c;o=c;d=c;k=e>>>5&2097151;N=(m[a+60|0]|m[a+61|0]<<8|(m[a+62|0]<<16|m[a+63|0]<<24))>>>3|0;c=i&2097151;e=ql(N,0,-683901,-1)+c|0;b=K;i=e;b=e>>>0<c>>>0?b+1|0:b;p=b;b=e;e=p-((b>>>0<4293918720)+ -1|0)|0;q=b- -1048576|0;x=e;b=e>>21;e=(e&2097151)<<11|q>>>21;k=e+k|0;S=k;c=k>>>0<e>>>0?b+1|0:b;B=c;b=ql(k,c,-683901,-1);h=b+f|0;c=K+d|0;E=h;n=h>>>0<b>>>0?c+1|0:c;c=ql(H,V,-997805,-1);b=K;d=g>>>5&2097151;c=d+c|0;if(c>>>0<d>>>0){b=b+1|0}d=c;c=ql(I,0,654183,0);h=d+c|0;d=K+b|0;d=h>>>0<c>>>0?d+1|0:d;b=ql(J,0,470296,0);h=b+h|0;c=K+d|0;c=h>>>0<b>>>0?c+1|0:c;d=ql(L,W,666643,0);h=d+h|0;b=K+c|0;g=h;d=g>>>0<d>>>0?b+1|0:b;b=l&2097151;h=ql(H,V,654183,0)+b|0;c=K;c=h>>>0<b>>>0?c+1|0:c;b=h;h=ql(I,0,470296,0);e=b+h|0;b=K+c|0;b=e>>>0<h>>>0?b+1|0:b;h=ql(J,0,666643,0);e=h+e|0;c=K+b|0;k=e;c=e>>>0<h>>>0?c+1|0:c;e=c;b=k;h=c-((b>>>0<4293918720)+ -1|0)|0;O=b- -1048576|0;u=h;b=h>>>21|0;c=(h&2097151)<<11|O>>>21;h=c+g|0;d=b+d|0;g=h;d=g>>>0<c>>>0?d+1|0:d;l=d;b=g;w=d-((b>>>0<4293918720)+ -1|0)|0;y=b- -1048576|0;ca=f- -1048576|0;o=o-((f>>>0<4293918720)+ -1|0)|0;h=o;d=w;b=d>>21;f=(d&2097151)<<11|y>>>21;w=f+E|0;c=b+n|0;c=w>>>0<f>>>0?c+1|0:c;f=w;b=ca&-2097152;o=c-((f>>>0<b>>>0)+h|0)|0;b=f-b|0;da=b- -1048576|0;f=o-((b>>>0<4293918720)+ -1|0)|0;c=da&-2097152;$=b-c|0;aa=o-((b>>>0<c>>>0)+f|0)|0;c=ql(S,B,136657,0)+g|0;b=l+K|0;b=c>>>0<g>>>0?b+1|0:b;g=c;c=y&-2097152;P=g-c|0;E=b-((g>>>0<c>>>0)+d|0)|0;b=q&-2097152;o=i-b|0;n=p-((i>>>0<b>>>0)+x|0)|0;b=ql(N,0,136657,0);c=K;d=((v&7)<<29|G>>>3)&2097151;b=d+b|0;if(b>>>0<d>>>0){c=c+1|0}d=ql(M,0,-683901,-1);g=d+b|0;b=K+c|0;i=g;g=g>>>0<d>>>0?b+1|0:b;b=ql(L,W,-683901,-1);c=K;d=t>>>6&2097151;b=d+b|0;if(b>>>0<d>>>0){c=c+1|0}d=b;b=ql(N,0,-997805,-1);l=d+b|0;d=K+c|0;d=l>>>0<b>>>0?d+1|0:d;c=ql(M,0,136657,0);l=c+l|0;b=K+d|0;b=l>>>0<c>>>0?b+1|0:b;q=b;b=l;c=q-((b>>>0<4293918720)+ -1|0)|0;G=b- -1048576|0;y=c;b=(c&2097151)<<11|G>>>21;i=b+i|0;c=(c>>21)+g|0;c=i>>>0<b>>>0?c+1|0:c;p=c;b=i;c=c-((b>>>0<4293918720)+ -1|0)|0;w=b- -1048576|0;x=c;d=c>>21;c=(c&2097151)<<11|w>>>21;g=c+o|0;b=d+n|0;T=g;b=g>>>0<c>>>0?b+1|0:b;A=b;c=ql(g,b,-683901,-1);d=c+P|0;b=K+E|0;ba=d;t=d>>>0<c>>>0?b+1|0:b;n=k;b=ql(H,V,470296,0);c=K;d=((s&7)<<29|F>>>3)&2097151;b=d+b|0;if(b>>>0<d>>>0){c=c+1|0}d=b;b=ql(I,0,666643,0);d=d+b|0;c=K+c|0;o=d;d=d>>>0<b>>>0?c+1|0:c;c=ql(H,V,666643,0);b=K;g=r>>>6&2097151;c=g+c|0;if(c>>>0<g>>>0){b=b+1|0}k=c;r=b;b=c;g=r-((b>>>0<4293918720)+ -1|0)|0;P=b- -1048576|0;s=g;c=g>>>21|0;b=(g&2097151)<<11|P>>>21;g=b+o|0;c=c+d|0;c=g>>>0<b>>>0?c+1|0:c;v=c;b=g;F=c-((b>>>0<4293918720)+ -1|0)|0;E=b- -1048576|0;b=w&-2097152;d=p-((i>>>0<b>>>0)+x|0)|0;Q=i-b|0;U=d;o=F;i=(o&2097151)<<11|E>>>21;n=i+n|0;b=(o>>>21|0)+e|0;b=n>>>0<i>>>0?b+1|0:b;e=ql(S,B,-997805,-1);i=n;c=O&-2097152;n=e+(i-c|0)|0;c=K+(b-((u&8191)+(i>>>0<c>>>0)|0)|0)|0;c=n>>>0<e>>>0?c+1|0:c;b=ql(T,A,136657,0);e=b+n|0;c=K+c|0;c=e>>>0<b>>>0?c+1|0:c;d=ql(Q,d,-683901,-1);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;p=b;b=e;d=p-((b>>>0<4293918720)+ -1|0)|0;w=b- -1048576|0;x=d;b=d>>21;d=(d&2097151)<<11|w>>>21;i=d+ba|0;c=b+t|0;c=i>>>0<d>>>0?c+1|0:c;d=i;n=c;b=d;t=c-((b>>>0<4293918720)+ -1|0)|0;u=b- -1048576|0;i=t;b=i>>21;c=(i&2097151)<<11|u>>>21;t=c+$|0;b=b+aa|0;$=t;t=t>>>0<c>>>0?b+1|0:b;b=u&-2097152;aa=d-b|0;ba=n-((d>>>0<b>>>0)+i|0)|0;b=w&-2097152;F=e-b|0;O=p-((e>>>0<b>>>0)+x|0)|0;b=ql(S,B,654183,0);c=E&-2097152;e=b+(g-c|0)|0;d=K+(v-((o&8191)+(g>>>0<c>>>0)|0)|0)|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(T,A,-997805,-1);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(Q,U,136657,0);e=d+e|0;c=K+b|0;w=e;i=e>>>0<d>>>0?c+1|0:c;b=G&-2097152;u=l-b|0;v=q-((l>>>0<b>>>0)+y|0)|0;c=ql(J,0,-683901,-1);b=K;d=((C&1)<<31|D>>>1)&2097151;c=d+c|0;if(c>>>0<d>>>0){b=b+1|0}d=c;c=ql(L,W,136657,0);d=d+c|0;b=K+b|0;b=d>>>0<c>>>0?b+1|0:b;c=d;d=ql(N,0,654183,0);e=c+d|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;b=ql(M,0,-997805,-1);d=b+e|0;c=K+c|0;l=d;e=d>>>0<b>>>0?c+1|0:c;b=ql(I,0,-683901,-1);d=K;c=z>>>4&2097151;b=c+b|0;if(b>>>0<c>>>0){d=d+1|0}c=ql(J,0,136657,0);g=c+b|0;b=K+d|0;b=g>>>0<c>>>0?b+1|0:b;d=ql(L,W,-997805,-1);g=d+g|0;c=K+b|0;c=g>>>0<d>>>0?c+1|0:c;d=ql(N,0,470296,0);g=d+g|0;b=K+c|0;b=g>>>0<d>>>0?b+1|0:b;d=ql(M,0,654183,0);g=d+g|0;c=K+b|0;c=g>>>0<d>>>0?c+1|0:c;p=c;b=g;d=c-((b>>>0<4293918720)+ -1|0)|0;y=b- -1048576|0;x=d;b=d>>21;c=(d&2097151)<<11|y>>>21;d=c+l|0;b=b+e|0;e=d;b=d>>>0<c>>>0?b+1|0:b;n=b;b=d;d=n-((b>>>0<4293918720)+ -1|0)|0;o=b- -1048576|0;l=d;b=d>>21;d=(d&2097151)<<11|o>>>21;q=d+u|0;c=b+v|0;X=q;c=q>>>0<d>>>0?c+1|0:c;z=c;b=ql(q,c,-683901,-1);c=b+w|0;d=K+i|0;v=c;i=c>>>0<b>>>0?d+1|0:d;b=o&-2097152;l=n-((e>>>0<b>>>0)+l|0)|0;D=e-b|0;C=l;b=ql(S,B,470296,0);c=P&-2097152;d=b+(k-c|0)|0;c=K+(r-((s&2047)+(k>>>0<c>>>0)|0)|0)|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(T,A,654183,0);d=b+d|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=ql(Q,U,-997805,-1);e=b+d|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(q,z,136657,0);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(D,l,-683901,-1);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;n=c;b=e;d=c-((b>>>0<4293918720)+ -1|0)|0;s=b- -1048576|0;l=d;b=d>>21;c=(d&2097151)<<11|s>>>21;d=c+v|0;b=b+i|0;b=d>>>0<c>>>0?b+1|0:b;i=b;b=d;v=i-((b>>>0<4293918720)+ -1|0)|0;o=b- -1048576|0;k=v;b=k>>21;v=(k&2097151)<<11|o>>>21;r=v+F|0;c=b+O|0;F=r;v=r>>>0<v>>>0?c+1|0:c;b=o&-2097152;O=d-b|0;G=i-((d>>>0<b>>>0)+k|0)|0;b=s&-2097152;w=e-b|0;q=n-((e>>>0<b>>>0)+l|0)|0;c=ql(S,B,666643,0);b=K;d=((_&1)<<31|ja>>>1)&2097151;c=d+c|0;if(c>>>0<d>>>0){b=b+1|0}d=ql(T,A,470296,0);e=d+c|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;d=ql(Q,U,654183,0);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;c=ql(X,z,-997805,-1);e=c+e|0;d=K+b|0;d=e>>>0<c>>>0?d+1|0:d;b=ql(D,C,136657,0);e=b+e|0;c=K+d|0;l=e;k=e>>>0<b>>>0?c+1|0:c;b=y&-2097152;i=g-b|0;g=p-((g>>>0<b>>>0)+x|0)|0;b=ql(H,V,-683901,-1);c=K;d=R>>>7&2097151;b=d+b|0;if(b>>>0<d>>>0){c=c+1|0}d=b;b=ql(I,0,136657,0);e=d+b|0;d=K+c|0;d=e>>>0<b>>>0?d+1|0:d;c=ql(J,0,-997805,-1);e=c+e|0;b=K+d|0;b=e>>>0<c>>>0?b+1|0:b;d=ql(L,W,654183,0);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;d=ql(N,0,666643,0);e=d+e|0;b=K+c|0;b=e>>>0<d>>>0?b+1|0:b;d=ql(M,0,470296,0);e=d+e|0;c=K+b|0;c=e>>>0<d>>>0?c+1|0:c;d=e;b=c;c=h>>21;h=(h&2097151)<<11|ca>>>21;e=h+d|0;d=b+c|0;d=e>>>0<h>>>0?d+1|0:d;x=d;b=e;d=d-((b>>>0<4293918720)+ -1|0)|0;p=b- -1048576|0;n=d;c=d>>21;d=(d&2097151)<<11|p>>>21;h=d+i|0;b=c+g|0;B=h;b=h>>>0<d>>>0?b+1|0:b;u=b;b=ql(h,b,-683901,-1);d=b+l|0;c=K+k|0;k=d;h=d>>>0<b>>>0?c+1|0:c;b=ql(T,A,666643,0);d=K;c=Z>>>4&2097151;b=c+b|0;if(b>>>0<c>>>0){d=d+1|0}c=ql(Q,U,470296,0);g=c+b|0;b=K+d|0;b=g>>>0<c>>>0?b+1|0:b;d=ql(X,z,654183,0);g=d+g|0;c=K+b|0;c=g>>>0<d>>>0?c+1|0:c;b=ql(D,C,-997805,-1);d=b+g|0;c=K+c|0;c=d>>>0<b>>>0?c+1|0:c;b=d;d=ql(B,u,136657,0);g=b+d|0;b=K+c|0;b=g>>>0<d>>>0?b+1|0:b;l=b;b=g;d=l-((b>>>0<4293918720)+ -1|0)|0;r=b- -1048576|0;i=d;c=d>>21;d=(d&2097151)<<11|r>>>21;k=d+k|0;b=c+h|0;h=k;b=h>>>0<d>>>0?b+1|0:b;d=b;b=h;o=d-((b>>>0<4293918720)+ -1|0)|0;s=b- -1048576|0;k=o;c=k>>21;o=(k&2097151)<<11|s>>>21;y=o+w|0;b=c+q|0;P=y;o=y>>>0<o>>>0?b+1|0:b;c=p&-2097152;b=e-c|0;e=x-((e>>>0<c>>>0)+n|0)|0;n=b;b=f>>21;c=(f&2097151)<<11|da>>>21;f=n+c|0;b=b+e|0;e=f;b=e>>>0<c>>>0?b+1|0:b;p=b;b=e;f=p-((b>>>0<4293918720)+ -1|0)|0;y=b- -1048576|0;x=f;b=f>>21;q=b;A=(f&2097151)<<11|y>>>21;b=ql(A,b,-683901,-1);f=b+h|0;c=K+d|0;c=f>>>0<b>>>0?c+1|0:c;d=f;b=s&-2097152;E=d-b|0;w=c-((d>>>0<b>>>0)+k|0)|0;c=ql(A,q,136657,0)+g|0;b=l+K|0;b=c>>>0<g>>>0?b+1|0:b;d=c;c=r&-2097152;R=d-c|0;r=b-((d>>>0<c>>>0)+i|0)|0;b=ql(Q,U,666643,0);c=K;d=Y>>>7&2097151;b=d+b|0;if(b>>>0<d>>>0){c=c+1|0}d=b;b=ql(X,z,470296,0);f=d+b|0;d=K+c|0;d=f>>>0<b>>>0?d+1|0:d;c=ql(D,C,654183,0);f=c+f|0;b=K+d|0;b=f>>>0<c>>>0?b+1|0:b;c=ql(B,u,-997805,-1);d=c+f|0;b=K+b|0;i=d;d=d>>>0<c>>>0?b+1|0:b;b=ql(X,z,666643,0);c=K;f=((ha&3)<<30|ga>>>2)&2097151;b=f+b|0;if(b>>>0<f>>>0){c=c+1|0}f=b;b=ql(D,C,470296,0);f=f+b|0;c=K+c|0;c=f>>>0<b>>>0?c+1|0:c;b=f;f=ql(B,u,654183,0);h=b+f|0;b=K+c|0;b=h>>>0<f>>>0?b+1|0:b;f=h;k=b;b=f;h=k-((b>>>0<4293918720)+ -1|0)|0;s=b- -1048576|0;g=h;c=g>>21;h=(g&2097151)<<11|s>>>21;i=h+i|0;b=c+d|0;l=i;b=i>>>0<h>>>0?b+1|0:b;d=b;b=i;n=d-((b>>>0<4293918720)+ -1|0)|0;i=b- -1048576|0;h=n;c=h>>21;n=(h&2097151)<<11|i>>>21;z=n+R|0;b=c+r|0;Y=z;n=z>>>0<n>>>0?b+1|0:b;b=ql(A,q,-997805,-1);c=b+l|0;d=K+d|0;d=c>>>0<b>>>0?d+1|0:d;b=i&-2097152;Z=c-b|0;_=d-((c>>>0<b>>>0)+h|0)|0;b=ql(A,q,654183,0)+f|0;c=k+K|0;c=b>>>0<f>>>0?c+1|0:c;d=b;b=s&-2097152;R=d-b|0;z=c-((d>>>0<b>>>0)+g|0)|0;b=ql(D,C,666643,0);d=K;c=fa>>>5&2097151;b=c+b|0;if(b>>>0<c>>>0){d=d+1|0}c=ql(B,u,470296,0);f=c+b|0;b=K+d|0;g=f;d=f>>>0<c>>>0?b+1|0:b;c=ea&2097151;f=ql(B,u,666643,0)+c|0;b=K;h=f;b=f>>>0<c>>>0?b+1|0:b;l=b;b=f;f=l-((b>>>0<4293918720)+ -1|0)|0;r=b- -1048576|0;i=f;c=f>>21;b=(f&2097151)<<11|r>>>21;f=b+g|0;d=c+d|0;d=f>>>0<b>>>0?d+1|0:d;k=d;b=f;d=d-((b>>>0<4293918720)+ -1|0)|0;s=b- -1048576|0;g=d;c=d>>21;d=(d&2097151)<<11|s>>>21;u=d+R|0;b=c+z|0;b=u>>>0<d>>>0?b+1|0:b;d=b;b=ql(A,q,470296,0)+f|0;c=k+K|0;c=b>>>0<f>>>0?c+1|0:c;k=b;f=s&-2097152;b=b-f|0;g=c-((k>>>0<f>>>0)+g|0)|0;k=b;c=ql(A,q,666643,0);b=r&-2097152;f=c+(h-b|0)|0;b=K+(l-((h>>>0<b>>>0)+i|0)|0)|0;b=f>>>0<c>>>0?b+1|0:b;h=f;c=b>>21;b=(b&2097151)<<11|f>>>21;f=k+b|0;c=c+g|0;c=f>>>0<b>>>0?c+1|0:c;C=f;b=c>>21;c=(c&2097151)<<11|f>>>21;f=c+u|0;d=b+d|0;g=f;b=f;d=b>>>0<c>>>0?d+1|0:d;c=d>>21;d=(d&2097151)<<11|b>>>21;f=d+Z|0;b=c+_|0;i=f;c=f;b=c>>>0<d>>>0?b+1|0:b;d=b>>21;b=(b&2097151)<<11|c>>>21;f=b+Y|0;c=d+n|0;n=f;d=f;c=d>>>0<b>>>0?c+1|0:c;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+E|0;b=b+w|0;b=d>>>0<c>>>0?b+1|0:b;u=d;c=b>>21;b=(b&2097151)<<11|d>>>21;d=b+P|0;c=c+o|0;c=d>>>0<b>>>0?c+1|0:c;q=d;b=c>>21;c=(c&2097151)<<11|d>>>21;f=c+O|0;d=b+G|0;r=f;b=f;d=b>>>0<c>>>0?d+1|0:d;c=d>>21;d=(d&2097151)<<11|b>>>21;f=d+F|0;b=c+v|0;s=f;c=f;b=c>>>0<d>>>0?b+1|0:b;d=b>>21;b=(b&2097151)<<11|c>>>21;f=b+aa|0;c=d+ba|0;v=f;d=f;c=d>>>0<b>>>0?c+1|0:c;b=c>>21;c=(c&2097151)<<11|d>>>21;d=c+$|0;b=b+t|0;b=d>>>0<c>>>0?b+1|0:b;o=d;c=b>>21;f=(b&2097151)<<11|d>>>21;d=y&-2097152;b=e-d|0;f=f+b|0;d=(p-((e>>>0<d>>>0)+x|0)|0)+c|0;x=f;c=f;d=c>>>0<b>>>0?d+1|0:d;t=(d&2097151)<<11|c>>>21;b=d>>21;l=b;c=h&2097151;d=ql(t,b,666643,0)+c|0;b=K;k=d;b=d>>>0<c>>>0?b+1|0:b;f=b;j[ka|0]=d;j[a+1|0]=(b&255)<<24|d>>>8;b=C&2097151;d=ql(t,l,470296,0)+b|0;c=K;c=d>>>0<b>>>0?c+1|0:c;h=d;d=f;b=d>>21;e=(d&2097151)<<11|k>>>21;p=h+e|0;d=b+c|0;d=p>>>0<e>>>0?d+1|0:d;e=p;j[a+4|0]=(d&2047)<<21|e>>>11;c=d;b=c;d=e;j[a+3|0]=(b&7)<<29|d>>>3;d=g&2097151;g=ql(t,l,654183,0)+d|0;b=K;b=g>>>0<d>>>0?b+1|0:b;d=g;g=(c&2097151)<<11|e>>>21;p=d+g|0;c=(c>>21)+b|0;c=p>>>0<g>>>0?c+1|0:c;g=p;b=c;j[a+6|0]=(b&63)<<26|g>>>6;h=0;d=((f&65535)<<16|k>>>16)&31;k=e&2097151;c=k;j[a+2|0]=d|c<<5;d=i&2097151;e=ql(t,l,-997805,-1)+d|0;c=K;c=e>>>0<d>>>0?c+1|0:c;d=c;c=b>>21;b=(b&2097151)<<11|g>>>21;e=b+e|0;d=c+d|0;i=e;d=e>>>0<b>>>0?d+1|0:d;j[a+9|0]=(d&511)<<23|e>>>9;c=d;b=c;d=e;j[a+8|0]=(b&1)<<31|d>>>1;e=0;g=g&2097151;d=g;j[a+5|0]=(h&524287)<<13|k>>>19|d<<2;d=n&2097151;h=ql(t,l,136657,0)+d|0;b=K;b=h>>>0<d>>>0?b+1|0:b;d=c>>21;c=(c&2097151)<<11|i>>>21;h=c+h|0;b=b+d|0;k=h;b=h>>>0<c>>>0?b+1|0:b;c=h;j[a+12|0]=(b&4095)<<20|c>>>12;d=b;j[a+11|0]=(b&15)<<28|c>>>4;h=0;n=i&2097151;c=n;j[a+7|0]=(e&16383)<<18|g>>>14|c<<7;b=u&2097151;e=ql(t,l,-683901,-1)+b|0;c=K;c=e>>>0<b>>>0?c+1|0:c;b=d>>21;d=(d&2097151)<<11|k>>>21;e=d+e|0;c=b+c|0;g=e;c=e>>>0<d>>>0?c+1|0:c;b=c;j[a+14|0]=(b&127)<<25|e>>>7;e=0;i=k&2097151;d=i;j[a+10|0]=(h&131071)<<15|n>>>17|d<<4;c=b>>21;b=(b&2097151)<<11|g>>>21;k=b+(q&2097151)|0;d=k>>>0<b>>>0?c+1|0:c;j[a+17|0]=(d&1023)<<22|k>>>10;b=d;d=k;j[a+16|0]=(b&3)<<30|d>>>2;l=g&2097151;d=l;j[a+13|0]=(e&1048575)<<12|i>>>20|d<<1;d=(b&2097151)<<11|k>>>21;g=d+(r&2097151)|0;b=b>>21;b=g>>>0<d>>>0?b+1|0:b;c=g;j[a+20|0]=(b&8191)<<19|c>>>13;j[a+19|0]=(b&31)<<27|c>>>5;i=k&2097151;c=i;j[a+15|0]=(h&32767)<<17|l>>>15|c<<6;c=b>>21;f=(b&2097151)<<11|g>>>21;l=f+(s&2097151)|0;b=c;b=l>>>0<f>>>0?b+1|0:b;f=b;j[a+21|0]=l;b=g;j[a+18|0]=(e&262143)<<14|i>>>18|b<<3;b=f;j[a+22|0]=(b&255)<<24|l>>>8;c=a;d=b;b=b>>21;h=(d&2097151)<<11|l>>>21;g=h+(v&2097151)|0;d=g>>>0<h>>>0?b+1|0:b;j[c+25|0]=(d&2047)<<21|g>>>11;b=d;d=g;j[c+24|0]=(b&7)<<29|d>>>3;d=c;h=(b&2097151)<<11|g>>>21;k=h+(o&2097151)|0;b=b>>21;e=k;b=e>>>0<h>>>0?b+1|0:b;c=b;j[d+27|0]=(b&63)<<26|e>>>6;h=0;k=g&2097151;b=k;j[d+23|0]=((f&65535)<<16|l>>>16)&31|b<<5;b=c;c=b>>21;b=(b&2097151)<<11|e>>>21;f=b+(x&2097151)|0;c=f>>>0<b>>>0?c+1|0:c;d=f;j[a+31|0]=(c&131071)<<15|d>>>17;b=c;j[a+30|0]=(b&511)<<23|d>>>9;j[a+29|0]=(b&1)<<31|d>>>1;c=0;e=e&2097151;j[a+26|0]=(h&524287)<<13|k>>>19|e<<2;j[a+28|0]=(c&16383)<<18|e>>>14|d<<7}function Ma(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,n=0,p=0,q=0;n=J-16|0;J=n;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{if(a>>>0<=244){f=l[9181];g=a>>>0<11?16:a+11&-8;a=g>>>3|0;b=f>>>a|0;if(b&3){c=a+((b^-1)&1)|0;e=c<<3;b=l[e+36772>>2];a=b+8|0;d=l[b+8>>2];e=e+36764|0;l:{if((d|0)==(e|0)){p=36724,q=sl(-2,c)&f,l[p>>2]=q;break l}l[d+12>>2]=e;l[e+8>>2]=d}c=c<<3;l[b+4>>2]=c|3;b=b+c|0;l[b+4>>2]=l[b+4>>2]|1;break a}i=l[9183];if(g>>>0<=i>>>0){break k}if(b){c=2<<a;a=(0-c|c)&b<<a;a=(0-a&a)+ -1|0;b=a>>>12&16;c=b;a=a>>>b|0;b=a>>>5&8;c=c|b;a=a>>>b|0;b=a>>>2&4;c=c|b;a=a>>>b|0;b=a>>>1&2;c=c|b;a=a>>>b|0;b=a>>>1&1;c=(c|b)+(a>>>b|0)|0;d=c<<3;b=l[d+36772>>2];a=l[b+8>>2];d=d+36764|0;m:{if((a|0)==(d|0)){f=sl(-2,c)&f;l[9181]=f;break m}l[a+12>>2]=d;l[d+8>>2]=a}a=b+8|0;l[b+4>>2]=g|3;h=b+g|0;c=c<<3;e=c-g|0;l[h+4>>2]=e|1;l[b+c>>2]=e;if(i){c=i>>>3|0;b=(c<<3)+36764|0;d=l[9186];c=1<<c;n:{if(!(c&f)){l[9181]=c|f;c=b;break n}c=l[b+8>>2]}l[b+8>>2]=d;l[c+12>>2]=d;l[d+12>>2]=b;l[d+8>>2]=c}l[9186]=h;l[9183]=e;break a}k=l[9182];if(!k){break k}a=(k&0-k)+ -1|0;b=a>>>12&16;c=b;a=a>>>b|0;b=a>>>5&8;c=c|b;a=a>>>b|0;b=a>>>2&4;c=c|b;a=a>>>b|0;b=a>>>1&2;c=c|b;a=a>>>b|0;b=a>>>1&1;b=l[((c|b)+(a>>>b|0)<<2)+37028>>2];d=(l[b+4>>2]&-8)-g|0;c=b;while(1){o:{a=l[c+16>>2];if(!a){a=l[c+20>>2];if(!a){break o}}e=(l[a+4>>2]&-8)-g|0;c=e>>>0<d>>>0;d=c?e:d;b=c?a:b;c=a;continue}break}j=l[b+24>>2];e=l[b+12>>2];if((e|0)!=(b|0)){a=l[b+8>>2];l[a+12>>2]=e;l[e+8>>2]=a;break b}c=b+20|0;a=l[c>>2];if(!a){a=l[b+16>>2];if(!a){break j}c=b+16|0}while(1){h=c;e=a;c=a+20|0;a=l[c>>2];if(a){continue}c=e+16|0;a=l[e+16>>2];if(a){continue}break}l[h>>2]=0;break b}g=-1;if(a>>>0>4294967231){break k}b=a+11|0;g=b&-8;i=l[9182];if(!i){break k}c=0-g|0;b=b>>>8|0;f=0;p:{if(!b){break p}f=31;if(g>>>0>16777215){break p}d=b+1048320>>>16&8;b=b<<d;a=b+520192>>>16&4;f=b<<a;b=f+245760>>>16&2;a=(f<<b>>>15|0)-(b|(a|d))|0;f=(a<<1|g>>>a+21&1)+28|0}d=l[(f<<2)+37028>>2];q:{r:{s:{if(!d){a=0;break s}b=g<<((f|0)==31?0:25-(f>>>1|0)|0);a=0;while(1){t:{h=(l[d+4>>2]&-8)-g|0;if(h>>>0>=c>>>0){break t}e=d;c=h;if(c){break t}c=0;a=d;break r}h=l[d+20>>2];d=l[((b>>>29&4)+d|0)+16>>2];a=h?(h|0)==(d|0)?a:h:a;b=b<<((d|0)!=0);if(d){continue}break}}if(!(a|e)){a=2<<f;a=(0-a|a)&i;if(!a){break k}a=(a&0-a)+ -1|0;b=a>>>12&16;d=b;a=a>>>b|0;b=a>>>5&8;d=d|b;a=a>>>b|0;b=a>>>2&4;d=d|b;a=a>>>b|0;b=a>>>1&2;d=d|b;a=a>>>b|0;b=a>>>1&1;a=l[((d|b)+(a>>>b|0)<<2)+37028>>2]}if(!a){break q}}while(1){d=(l[a+4>>2]&-8)-g|0;b=d>>>0<c>>>0;c=b?d:c;e=b?a:e;b=l[a+16>>2];if(b){a=b}else{a=l[a+20>>2]}if(a){continue}break}}if(!e|c>>>0>=l[9183]-g>>>0){break k}h=l[e+24>>2];b=l[e+12>>2];if((e|0)!=(b|0)){a=l[e+8>>2];l[a+12>>2]=b;l[b+8>>2]=a;break c}d=e+20|0;a=l[d>>2];if(!a){a=l[e+16>>2];if(!a){break i}d=e+16|0}while(1){f=d;b=a;d=a+20|0;a=l[d>>2];if(a){continue}d=b+16|0;a=l[b+16>>2];if(a){continue}break}l[f>>2]=0;break c}b=l[9183];if(b>>>0>=g>>>0){a=l[9186];c=b-g|0;u:{if(c>>>0>=16){l[9183]=c;d=a+g|0;l[9186]=d;l[d+4>>2]=c|1;l[a+b>>2]=c;l[a+4>>2]=g|3;break u}l[9186]=0;l[9183]=0;l[a+4>>2]=b|3;b=a+b|0;l[b+4>>2]=l[b+4>>2]|1}a=a+8|0;break a}d=l[9184];if(d>>>0>g>>>0){b=d-g|0;l[9184]=b;a=l[9187];c=a+g|0;l[9187]=c;l[c+4>>2]=b|1;l[a+4>>2]=g|3;a=a+8|0;break a}a=0;e=g+47|0;c=e;if(l[9299]){b=l[9301]}else{l[9302]=-1;l[9303]=-1;l[9300]=4096;l[9301]=4096;l[9299]=n+12&-16^1431655768;l[9304]=0;l[9292]=0;b=4096}f=c+b|0;h=0-b|0;c=f&h;if(c>>>0<=g>>>0){break a}b=l[9291];if(b){i=l[9289];j=i+c|0;if(j>>>0<=i>>>0|j>>>0>b>>>0){break a}}if(m[37168]&4){break f}v:{w:{b=l[9187];if(b){a=37172;while(1){i=l[a>>2];if(i+l[a+4>>2]>>>0>b>>>0?i>>>0<=b>>>0:0){break w}a=l[a+8>>2];if(a){continue}break}}b=ib(0);if((b|0)==-1){break g}f=c;a=l[9300];d=a+ -1|0;if(d&b){f=(c-b|0)+(b+d&0-a)|0}if(f>>>0<=g>>>0|f>>>0>2147483646){break g}a=l[9291];if(a){d=l[9289];h=d+f|0;if(h>>>0<=d>>>0|h>>>0>a>>>0){break g}}a=ib(f);if((b|0)!=(a|0)){break v}break e}f=h&f-d;if(f>>>0>2147483646){break g}b=ib(f);if((b|0)==(l[a>>2]+l[a+4>>2]|0)){break h}a=b}if(!((a|0)==-1|g+48>>>0<=f>>>0)){b=l[9301];b=b+(e-f|0)&0-b;if(b>>>0>2147483646){b=a;break e}if((ib(b)|0)!=-1){f=b+f|0;b=a;break e}ib(0-f|0);break g}b=a;if((a|0)!=-1){break e}break g}e=0;break b}b=0;break c}if((b|0)!=-1){break e}}l[9292]=l[9292]|4}if(c>>>0>2147483646){break d}b=ib(c);a=ib(0);if(b>>>0>=a>>>0|(b|0)==-1|(a|0)==-1){break d}f=a-b|0;if(f>>>0<=g+40>>>0){break d}}a=l[9289]+f|0;l[9289]=a;if(a>>>0>o[9290]){l[9290]=a}x:{y:{z:{c=l[9187];if(c){a=37172;while(1){d=l[a>>2];e=l[a+4>>2];if((d+e|0)==(b|0)){break z}a=l[a+8>>2];if(a){continue}break}break y}a=l[9185];if(!(b>>>0>=a>>>0?a:0)){l[9185]=b}a=0;l[9294]=f;l[9293]=b;l[9189]=-1;l[9190]=l[9299];l[9296]=0;while(1){c=a<<3;d=c+36764|0;l[c+36772>>2]=d;l[c+36776>>2]=d;a=a+1|0;if((a|0)!=32){continue}break}a=f+ -40|0;c=b+8&7?-8-b&7:0;d=a-c|0;l[9184]=d;c=b+c|0;l[9187]=c;l[c+4>>2]=d|1;l[(a+b|0)+4>>2]=40;l[9188]=l[9303];break x}if(m[a+12|0]&8|b>>>0<=c>>>0|d>>>0>c>>>0){break y}l[a+4>>2]=e+f;a=c+8&7?-8-c&7:0;b=a+c|0;l[9187]=b;d=l[9184]+f|0;a=d-a|0;l[9184]=a;l[b+4>>2]=a|1;l[(c+d|0)+4>>2]=40;l[9188]=l[9303];break x}e=l[9185];if(b>>>0<e>>>0){l[9185]=b;e=0}d=b+f|0;a=37172;A:{B:{C:{D:{E:{F:{while(1){if((d|0)!=l[a>>2]){a=l[a+8>>2];if(a){continue}break F}break}if(!(m[a+12|0]&8)){break E}}a=37172;while(1){d=l[a>>2];if(d>>>0<=c>>>0){e=d+l[a+4>>2]|0;if(e>>>0>c>>>0){break D}}a=l[a+8>>2];continue}}l[a>>2]=b;l[a+4>>2]=l[a+4>>2]+f;j=(b+8&7?-8-b&7:0)+b|0;l[j+4>>2]=g|3;b=d+(d+8&7?-8-d&7:0)|0;a=(b-j|0)-g|0;h=g+j|0;if((b|0)==(c|0)){l[9187]=h;a=l[9184]+a|0;l[9184]=a;l[h+4>>2]=a|1;break B}if(l[9186]==(b|0)){l[9186]=h;a=l[9183]+a|0;l[9183]=a;l[h+4>>2]=a|1;l[a+h>>2]=a;break B}c=l[b+4>>2];if((c&3)==1){k=c&-8;G:{if(c>>>0<=255){e=c>>>3|0;c=l[b+8>>2];d=l[b+12>>2];if((d|0)==(c|0)){p=36724,q=l[9181]&sl(-2,e),l[p>>2]=q;break G}l[c+12>>2]=d;l[d+8>>2]=c;break G}i=l[b+24>>2];f=l[b+12>>2];H:{if((f|0)!=(b|0)){c=l[b+8>>2];l[c+12>>2]=f;l[f+8>>2]=c;break H}I:{d=b+20|0;g=l[d>>2];if(g){break I}d=b+16|0;g=l[d>>2];if(g){break I}f=0;break H}while(1){c=d;f=g;d=g+20|0;g=l[d>>2];if(g){continue}d=f+16|0;g=l[f+16>>2];if(g){continue}break}l[c>>2]=0}if(!i){break G}c=l[b+28>>2];d=(c<<2)+37028|0;J:{if(l[d>>2]==(b|0)){l[d>>2]=f;if(f){break J}p=36728,q=l[9182]&sl(-2,c),l[p>>2]=q;break G}l[i+(l[i+16>>2]==(b|0)?16:20)>>2]=f;if(!f){break G}}l[f+24>>2]=i;c=l[b+16>>2];if(c){l[f+16>>2]=c;l[c+24>>2]=f}c=l[b+20>>2];if(!c){break G}l[f+20>>2]=c;l[c+24>>2]=f}b=b+k|0;a=a+k|0}l[b+4>>2]=l[b+4>>2]&-2;l[h+4>>2]=a|1;l[a+h>>2]=a;if(a>>>0<=255){b=a>>>3|0;a=(b<<3)+36764|0;c=l[9181];b=1<<b;K:{if(!(c&b)){l[9181]=b|c;b=a;break K}b=l[a+8>>2]}l[a+8>>2]=h;l[b+12>>2]=h;l[h+12>>2]=a;l[h+8>>2]=b;break B}c=h;d=a>>>8|0;b=0;L:{if(!d){break L}b=31;if(a>>>0>16777215){break L}e=d+1048320>>>16&8;d=d<<e;b=d+520192>>>16&4;g=d<<b;d=g+245760>>>16&2;b=(g<<d>>>15|0)-(d|(b|e))|0;b=(b<<1|a>>>b+21&1)+28|0}l[c+28>>2]=b;l[h+16>>2]=0;l[h+20>>2]=0;c=(b<<2)+37028|0;d=l[9182];e=1<<b;M:{if(!(d&e)){l[9182]=d|e;l[c>>2]=h;break M}d=a<<((b|0)==31?0:25-(b>>>1|0)|0);b=l[c>>2];while(1){c=b;if((l[b+4>>2]&-8)==(a|0)){break C}b=d>>>29|0;d=d<<1;e=(b&4)+c|0;b=l[e+16>>2];if(b){continue}break}l[e+16>>2]=h}l[h+24>>2]=c;l[h+12>>2]=h;l[h+8>>2]=h;break B}a=f+ -40|0;d=b+8&7?-8-b&7:0;h=a-d|0;l[9184]=h;d=b+d|0;l[9187]=d;l[d+4>>2]=h|1;l[(a+b|0)+4>>2]=40;l[9188]=l[9303];a=(e+(e+ -39&7?39-e&7:0)|0)+ -47|0;d=a>>>0<c+16>>>0?c:a;l[d+4>>2]=27;a=l[9296];l[d+16>>2]=l[9295];l[d+20>>2]=a;a=l[9294];l[d+8>>2]=l[9293];l[d+12>>2]=a;l[9295]=d+8;l[9294]=f;l[9293]=b;l[9296]=0;a=d+24|0;while(1){l[a+4>>2]=7;b=a+8|0;a=a+4|0;if(e>>>0>b>>>0){continue}break}if((c|0)==(d|0)){break x}l[d+4>>2]=l[d+4>>2]&-2;e=d-c|0;l[c+4>>2]=e|1;l[d>>2]=e;if(e>>>0<=255){b=e>>>3|0;a=(b<<3)+36764|0;d=l[9181];b=1<<b;N:{if(!(d&b)){l[9181]=b|d;b=a;break N}b=l[a+8>>2]}l[a+8>>2]=c;l[b+12>>2]=c;l[c+12>>2]=a;l[c+8>>2]=b;break x}l[c+16>>2]=0;l[c+20>>2]=0;b=c;d=e>>>8|0;a=0;O:{if(!d){break O}a=31;if(e>>>0>16777215){break O}f=d+1048320>>>16&8;d=d<<f;a=d+520192>>>16&4;h=d<<a;d=h+245760>>>16&2;a=(h<<d>>>15|0)-(d|(a|f))|0;a=(a<<1|e>>>a+21&1)+28|0}l[b+28>>2]=a;b=(a<<2)+37028|0;d=l[9182];f=1<<a;P:{if(!(d&f)){l[9182]=d|f;l[b>>2]=c;l[c+24>>2]=b;break P}a=e<<((a|0)==31?0:25-(a>>>1|0)|0);b=l[b>>2];while(1){d=b;if((e|0)==(l[b+4>>2]&-8)){break A}b=a>>>29|0;a=a<<1;f=d+(b&4)|0;b=l[f+16>>2];if(b){continue}break}l[f+16>>2]=c;l[c+24>>2]=d}l[c+12>>2]=c;l[c+8>>2]=c;break x}a=l[c+8>>2];l[a+12>>2]=h;l[c+8>>2]=h;l[h+24>>2]=0;l[h+12>>2]=c;l[h+8>>2]=a}a=j+8|0;break a}a=l[d+8>>2];l[a+12>>2]=c;l[d+8>>2]=c;l[c+24>>2]=0;l[c+12>>2]=d;l[c+8>>2]=a}a=l[9184];if(a>>>0<=g>>>0){break d}b=a-g|0;l[9184]=b;a=l[9187];c=a+g|0;l[9187]=c;l[c+4>>2]=b|1;l[a+4>>2]=g|3;a=a+8|0;break a}l[9180]=48;a=0;break a}Q:{if(!h){break Q}a=l[e+28>>2];d=(a<<2)+37028|0;R:{if(l[d>>2]==(e|0)){l[d>>2]=b;if(b){break R}i=sl(-2,a)&i;l[9182]=i;break Q}l[h+(l[h+16>>2]==(e|0)?16:20)>>2]=b;if(!b){break Q}}l[b+24>>2]=h;a=l[e+16>>2];if(a){l[b+16>>2]=a;l[a+24>>2]=b}a=l[e+20>>2];if(!a){break Q}l[b+20>>2]=a;l[a+24>>2]=b}S:{if(c>>>0<=15){a=c+g|0;l[e+4>>2]=a|3;a=a+e|0;l[a+4>>2]=l[a+4>>2]|1;break S}l[e+4>>2]=g|3;d=e+g|0;l[d+4>>2]=c|1;l[c+d>>2]=c;if(c>>>0<=255){b=c>>>3|0;a=(b<<3)+36764|0;c=l[9181];b=1<<b;T:{if(!(c&b)){l[9181]=b|c;b=a;break T}b=l[a+8>>2]}l[a+8>>2]=d;l[b+12>>2]=d;l[d+12>>2]=a;l[d+8>>2]=b;break S}b=d;g=c>>>8|0;a=0;U:{if(!g){break U}a=31;if(c>>>0>16777215){break U}f=g+1048320>>>16&8;g=g<<f;a=g+520192>>>16&4;h=g<<a;g=h+245760>>>16&2;a=(h<<g>>>15|0)-(g|(a|f))|0;a=(a<<1|c>>>a+21&1)+28|0}l[b+28>>2]=a;l[d+16>>2]=0;l[d+20>>2]=0;b=(a<<2)+37028|0;V:{g=1<<a;W:{if(!(g&i)){l[9182]=g|i;l[b>>2]=d;break W}a=c<<((a|0)==31?0:25-(a>>>1|0)|0);g=l[b>>2];while(1){b=g;if((l[b+4>>2]&-8)==(c|0)){break V}g=a>>>29|0;a=a<<1;f=(g&4)+b|0;g=l[f+16>>2];if(g){continue}break}l[f+16>>2]=d}l[d+24>>2]=b;l[d+12>>2]=d;l[d+8>>2]=d;break S}a=l[b+8>>2];l[a+12>>2]=d;l[b+8>>2]=d;l[d+24>>2]=0;l[d+12>>2]=b;l[d+8>>2]=a}a=e+8|0;break a}X:{if(!j){break X}a=l[b+28>>2];c=(a<<2)+37028|0;Y:{if(l[c>>2]==(b|0)){l[c>>2]=e;if(e){break Y}p=36728,q=sl(-2,a)&k,l[p>>2]=q;break X}l[j+(l[j+16>>2]==(b|0)?16:20)>>2]=e;if(!e){break X}}l[e+24>>2]=j;a=l[b+16>>2];if(a){l[e+16>>2]=a;l[a+24>>2]=e}a=l[b+20>>2];if(!a){break X}l[e+20>>2]=a;l[a+24>>2]=e}Z:{if(d>>>0<=15){a=d+g|0;l[b+4>>2]=a|3;a=a+b|0;l[a+4>>2]=l[a+4>>2]|1;break Z}l[b+4>>2]=g|3;g=b+g|0;l[g+4>>2]=d|1;l[d+g>>2]=d;if(i){c=i>>>3|0;a=(c<<3)+36764|0;e=l[9186];c=1<<c;_:{if(!(c&f)){l[9181]=c|f;c=a;break _}c=l[a+8>>2]}l[a+8>>2]=e;l[c+12>>2]=e;l[e+12>>2]=a;l[e+8>>2]=c}l[9186]=g;l[9183]=d}a=b+8|0}J=n+16|0;return a|0}function ca(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0,ra=0,sa=0,ta=0,ua=0,va=0,wa=0,xa=0,ya=0,za=0,Aa=0,Ba=0,Ca=0,Da=0,Ea=0;j=a;S=l[c+4>>2];d=S;G=d;H=d>>31;t=l[b+20>>2];d=t<<1;na=d;Z=d>>31;d=ql(G,H,d,Z);f=K;e=d;d=l[c>>2];z=d;A=d>>31;d=l[b+24>>2];I=d;B=d>>31;h=ql(z,A,d,B);e=e+h|0;d=K+f|0;d=e>>>0<h>>>0?d+1|0:d;f=e;i=l[c+8>>2];e=i;_=e;Q=e>>31;e=l[b+16>>2];J=e;C=e>>31;h=ql(i,Q,e,C);e=f+h|0;f=K+d|0;f=e>>>0<h>>>0?f+1|0:f;v=l[c+12>>2];d=v;oa=d;T=d>>31;p=l[b+12>>2];d=p<<1;pa=d;$=d>>31;h=ql(v,T,d,$);d=h+e|0;e=K+f|0;e=d>>>0<h>>>0?e+1|0:e;f=d;u=l[c+16>>2];d=u;wa=d;X=d>>31;d=l[b+8>>2];L=d;D=d>>31;h=ql(u,X,d,D);f=f+h|0;d=K+e|0;d=f>>>0<h>>>0?d+1|0:d;g=f;n=l[c+20>>2];e=n;xa=e;aa=e>>31;k=l[b+4>>2];e=k<<1;qa=e;ba=e>>31;f=ql(n,aa,e,ba);e=g+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=e;o=l[c+24>>2];e=o;ya=e;ra=e>>31;e=l[b>>2];M=e;E=e>>31;h=ql(o,ra,e,E);f=f+h|0;e=K+d|0;e=f>>>0<h>>>0?e+1|0:e;w=l[c+28>>2];d=r(w,19);U=d;V=d>>31;q=l[b+36>>2];d=q<<1;sa=d;ca=d>>31;h=ql(U,V,d,ca);d=h+f|0;f=K+e|0;f=d>>>0<h>>>0?f+1|0:f;e=d;s=l[c+32>>2];d=r(s,19);x=d;y=d>>31;d=l[b+32>>2];N=d;F=d>>31;h=ql(x,y,d,F);e=e+h|0;d=K+f|0;d=e>>>0<h>>>0?d+1|0:d;f=e;za=l[c+36>>2];c=r(za,19);O=c;P=c>>31;b=l[b+28>>2];c=b<<1;ta=c;da=c>>31;e=ql(O,P,c,da);c=f+e|0;d=K+d|0;m=c;c=c>>>0<e>>>0?d+1|0:d;d=ql(J,C,G,H);e=K;h=t;ea=h>>31;t=ql(z,A,h,ea);d=t+d|0;f=K+e|0;f=d>>>0<t>>>0?f+1|0:f;t=p;fa=p>>31;p=ql(i,Q,p,fa);d=p+d|0;e=K+f|0;e=d>>>0<p>>>0?e+1|0:e;p=ql(L,D,v,T);f=p+d|0;d=K+e|0;d=f>>>0<p>>>0?d+1|0:d;e=f;p=k;ga=k>>31;f=ql(u,X,k,ga);e=e+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(M,E,n,aa);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=e;e=r(o,19);ha=e;Y=e>>31;k=q;ia=k>>31;q=ql(e,Y,k,ia);e=f+q|0;f=K+d|0;f=e>>>0<q>>>0?f+1|0:f;q=ql(N,F,U,V);d=q+e|0;e=K+f|0;e=d>>>0<q>>>0?e+1|0:e;q=b;ja=b>>31;f=ql(x,y,b,ja);b=f+d|0;d=K+e|0;d=b>>>0<f>>>0?d+1|0:d;e=ql(O,P,I,B);b=e+b|0;d=K+d|0;W=b;b=b>>>0<e>>>0?d+1|0:d;d=ql(G,H,pa,$);f=K;o=ql(z,A,J,C);e=o+d|0;d=K+f|0;d=e>>>0<o>>>0?d+1|0:d;o=ql(L,D,i,Q);e=o+e|0;f=K+d|0;f=e>>>0<o>>>0?f+1|0:f;o=ql(v,T,qa,ba);d=o+e|0;e=K+f|0;e=d>>>0<o>>>0?e+1|0:e;o=ql(M,E,u,X);f=o+d|0;d=K+e|0;d=f>>>0<o>>>0?d+1|0:d;g=f;e=r(n,19);ua=e;ka=e>>31;f=ql(e,ka,sa,ca);e=g+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(N,F,ha,Y);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;n=ql(U,V,ta,da);e=n+e|0;f=K+d|0;f=e>>>0<n>>>0?f+1|0:f;n=ql(x,y,I,B);d=n+e|0;e=K+f|0;e=d>>>0<n>>>0?e+1|0:e;n=ql(O,P,na,Z);f=n+d|0;d=K+e|0;d=f>>>0<n>>>0?d+1|0:d;n=f;Ba=d;e=f+33554432|0;if(e>>>0<33554432){d=d+1|0}o=e;Ca=d;f=W;W=(d&67108863)<<6|e>>>26;f=f+W|0;d=(d>>26)+b|0;d=f>>>0<W>>>0?d+1|0:d;W=f;f=d;b=W+16777216|0;if(b>>>0<16777216){f=f+1|0}Da=b;e=f>>25;f=(f&33554431)<<7|b>>>25;b=f+m|0;d=c+e|0;d=b>>>0<f>>>0?d+1|0:d;c=b;b=c+33554432|0;if(b>>>0<33554432){d=d+1|0}la=b;b=d;d=la&-67108864;l[j+24>>2]=c-d;m=a;c=ql(G,H,qa,ba);d=K;e=ql(z,A,L,D);c=e+c|0;f=K+d|0;f=c>>>0<e>>>0?f+1|0:f;e=ql(M,E,_,Q);c=e+c|0;d=K+f|0;d=c>>>0<e>>>0?d+1|0:d;f=c;c=r(v,19);j=c;v=c>>31;e=ql(c,v,sa,ca);c=f+e|0;d=K+d|0;d=c>>>0<e>>>0?d+1|0:d;e=c;c=r(u,19);Aa=c;va=c>>31;f=ql(N,F,c,va);c=e+f|0;e=K+d|0;e=c>>>0<f>>>0?e+1|0:e;f=ql(ta,da,ua,ka);c=f+c|0;d=K+e|0;d=c>>>0<f>>>0?d+1|0:d;e=ql(I,B,ha,Y);c=e+c|0;f=K+d|0;f=c>>>0<e>>>0?f+1|0:f;e=ql(U,V,na,Z);c=e+c|0;d=K+f|0;d=c>>>0<e>>>0?d+1|0:d;e=ql(x,y,J,C);c=e+c|0;d=K+d|0;d=c>>>0<e>>>0?d+1|0:d;f=ql(O,P,pa,$);c=f+c|0;e=K+d|0;g=c;c=c>>>0<f>>>0?e+1|0:e;d=ql(M,E,G,H);f=K;u=ql(z,A,p,ga);e=u+d|0;d=K+f|0;d=e>>>0<u>>>0?d+1|0:d;f=e;e=r(i,19);u=e;R=e>>31;i=ql(e,R,k,ia);e=f+i|0;f=K+d|0;f=e>>>0<i>>>0?f+1|0:f;i=ql(N,F,j,v);e=i+e|0;d=K+f|0;d=e>>>0<i>>>0?d+1|0:d;f=ql(Aa,va,q,ja);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;i=ql(I,B,ua,ka);f=i+e|0;e=K+d|0;e=f>>>0<i>>>0?e+1|0:e;i=ql(ha,Y,h,ea);f=i+f|0;d=K+e|0;d=f>>>0<i>>>0?d+1|0:d;i=ql(J,C,U,V);e=i+f|0;f=K+d|0;f=e>>>0<i>>>0?f+1|0:f;i=ql(x,y,t,fa);e=i+e|0;d=K+f|0;d=e>>>0<i>>>0?d+1|0:d;f=ql(O,P,L,D);e=f+e|0;d=K+d|0;ma=e;i=e>>>0<f>>>0?d+1|0:d;d=r(S,19);d=ql(d,d>>31,sa,ca);e=K;f=ql(z,A,M,E);d=f+d|0;e=K+e|0;e=d>>>0<f>>>0?e+1|0:e;S=ql(N,F,u,R);f=S+d|0;d=K+e|0;j=ql(j,v,ta,da);e=j+f|0;f=K+(f>>>0<S>>>0?d+1|0:d)|0;f=e>>>0<j>>>0?f+1|0:f;j=ql(I,B,Aa,va);e=j+e|0;d=K+f|0;d=e>>>0<j>>>0?d+1|0:d;f=ql(na,Z,ua,ka);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;j=ql(J,C,ha,Y);f=j+e|0;e=K+d|0;e=f>>>0<j>>>0?e+1|0:e;j=ql(U,V,pa,$);f=j+f|0;d=K+e|0;d=f>>>0<j>>>0?d+1|0:d;j=ql(x,y,L,D);e=j+f|0;f=K+d|0;f=e>>>0<j>>>0?f+1|0:f;j=ql(O,P,qa,ba);e=j+e|0;d=K+f|0;d=e>>>0<j>>>0?d+1|0:d;j=e;S=d;e=e+33554432|0;if(e>>>0<33554432){d=d+1|0}v=e;u=d;f=d>>26;R=(d&67108863)<<6|e>>>26;d=R+ma|0;e=f+i|0;i=d;f=g;d=d>>>0<R>>>0?e+1|0:e;e=i+16777216|0;if(e>>>0<16777216){d=d+1|0}Ea=e;g=(d&33554431)<<7|e>>>25;e=f+g|0;d=(d>>25)+c|0;d=e>>>0<g>>>0?d+1|0:d;c=e+33554432|0;if(c>>>0<33554432){d=d+1|0}R=c;c=d;d=R&-67108864;l[m+8>>2]=e-d;g=a;d=ql(I,B,G,H);f=K;m=ql(z,A,q,ja);e=m+d|0;d=K+f|0;d=e>>>0<m>>>0?d+1|0:d;f=ql(_,Q,h,ea);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(J,C,oa,T);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;m=ql(wa,X,t,fa);e=m+e|0;f=K+d|0;f=e>>>0<m>>>0?f+1|0:f;m=ql(L,D,xa,aa);d=m+e|0;e=K+f|0;e=d>>>0<m>>>0?e+1|0:e;m=ql(p,ga,ya,ra);f=m+d|0;d=K+e|0;d=f>>>0<m>>>0?d+1|0:d;e=f;m=w;ma=m>>31;f=ql(M,E,m,ma);e=e+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(x,y,k,ia);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;w=ql(O,P,N,F);e=w+e|0;f=K+d|0;f=e>>>0<w>>>0?f+1|0:f;d=b>>26;w=(b&67108863)<<6|la>>>26;b=w+e|0;e=d+f|0;e=b>>>0<w>>>0?e+1|0:e;f=b;d=e;b=f+16777216|0;if(b>>>0<16777216){d=d+1|0}la=b;b=d;d=la&-33554432;l[g+28>>2]=f-d;w=a;d=ql(L,D,G,H);e=K;g=ql(z,A,t,fa);d=g+d|0;f=K+e|0;f=d>>>0<g>>>0?f+1|0:f;g=ql(_,Q,p,ga);d=g+d|0;e=K+f|0;e=d>>>0<g>>>0?e+1|0:e;g=ql(M,E,oa,T);f=g+d|0;d=K+e|0;d=f>>>0<g>>>0?d+1|0:d;e=f;f=ql(Aa,va,k,ia);e=e+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(N,F,ua,ka);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;g=ql(ha,Y,q,ja);e=g+e|0;f=K+d|0;f=e>>>0<g>>>0?f+1|0:f;g=ql(I,B,U,V);d=g+e|0;e=K+f|0;e=d>>>0<g>>>0?e+1|0:e;g=ql(x,y,h,ea);f=g+d|0;d=K+e|0;d=f>>>0<g>>>0?d+1|0:d;e=f;f=ql(O,P,J,C);e=e+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;g=e;e=c>>26;f=(c&67108863)<<6|R>>>26;c=g+f|0;d=d+e|0;d=c>>>0<f>>>0?d+1|0:d;e=c;f=d;c=e+16777216|0;if(c>>>0<16777216){f=f+1|0}x=c;c=f;d=x&-33554432;l[w+12>>2]=e-d;d=ql(G,H,ta,da);f=K;g=ql(z,A,N,F);e=g+d|0;d=K+f|0;d=e>>>0<g>>>0?d+1|0:d;f=ql(I,B,_,Q);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;g=ql(oa,T,na,Z);e=g+e|0;f=K+d|0;f=e>>>0<g>>>0?f+1|0:f;g=ql(J,C,wa,X);d=g+e|0;e=K+f|0;e=d>>>0<g>>>0?e+1|0:e;g=ql(pa,$,xa,aa);f=g+d|0;d=K+e|0;d=f>>>0<g>>>0?d+1|0:d;e=f;f=ql(L,D,ya,ra);e=e+f|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(m,ma,qa,ba);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;g=s;y=g>>31;s=ql(M,E,g,y);e=s+e|0;f=K+d|0;f=e>>>0<s>>>0?f+1|0:f;s=ql(O,P,sa,ca);d=s+e|0;e=K+f|0;e=d>>>0<s>>>0?e+1|0:e;s=d;d=b>>25;f=(b&33554431)<<7|la>>>25;b=s+f|0;d=d+e|0;d=b>>>0<f>>>0?d+1|0:d;e=b;b=e+33554432|0;if(b>>>0<33554432){d=d+1|0}s=b;b=d;d=s&-67108864;l[w+32>>2]=e-d;d=o&-67108864;e=n-d|0;d=Ba-((n>>>0<d>>>0)+Ca|0)|0;f=e;e=c>>25;n=(c&33554431)<<7|x>>>25;c=f+n|0;d=d+e|0;d=c>>>0<n>>>0?d+1|0:d;e=c+33554432|0;if(e>>>0<33554432){d=d+1|0}f=(W-(Da&-33554432)|0)+((d&67108863)<<6|e>>>26)|0;l[a+20>>2]=f;d=e&-67108864;l[a+16>>2]=c-d;d=ql(N,F,G,H);f=K;k=ql(z,A,k,ia);e=k+d|0;d=K+f|0;d=e>>>0<k>>>0?d+1|0:d;k=ql(_,Q,q,ja);f=k+e|0;e=K+d|0;e=f>>>0<k>>>0?e+1|0:e;k=ql(I,B,oa,T);d=k+f|0;f=K+e|0;h=ql(wa,X,h,ea);e=h+d|0;d=K+(d>>>0<k>>>0?f+1|0:f)|0;d=e>>>0<h>>>0?d+1|0:d;f=ql(J,C,xa,aa);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;f=ql(t,fa,ya,ra);e=f+e|0;d=K+d|0;d=e>>>0<f>>>0?d+1|0:d;h=ql(L,D,m,ma);f=h+e|0;e=K+d|0;e=f>>>0<h>>>0?e+1|0:e;h=ql(g,y,p,ga);d=h+f|0;f=K+e|0;f=d>>>0<h>>>0?f+1|0:f;h=ql(M,E,za,za>>31);e=h+d|0;d=K+f|0;d=e>>>0<h>>>0?d+1|0:d;c=e;e=b>>26;f=(b&67108863)<<6|s>>>26;b=c+f|0;d=d+e|0;d=b>>>0<f>>>0?d+1|0:d;c=b;f=c;b=c+16777216|0;if(b>>>0<16777216){d=d+1|0}e=b;b=e&-33554432;l[a+36>>2]=c-b;c=a;f=i-(Ea&-33554432)|0;b=v&-67108864;h=j-b|0;t=S-((j>>>0<b>>>0)+u|0)|0;b=d;d=d>>25;d=ql((b&33554431)<<7|e>>>25,d,19,0);b=d+h|0;e=K+t|0;e=b>>>0<d>>>0?e+1|0:e;g=c;d=e;c=b+33554432|0;if(c>>>0<33554432){d=d+1|0}e=c;e=((d&67108863)<<6|e>>>26)+f|0;l[g+4>>2]=e;e=a;a=c&-67108864;l[e>>2]=b-a}function ag(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0;T=a;g=l[b+12>>2];c=g<<1;t=c;u=c>>31;k=l[b+4>>2];c=k<<1;v=c;p=c>>31;c=ql(t,u,c,p);e=K;d=c;E=l[b+8>>2];c=E;o=c>>31;U=c;f=ql(c,o,c,o);d=d+f|0;c=K+e|0;c=d>>>0<f>>>0?c+1|0:c;f=d;M=l[b+16>>2];d=M;w=d;x=d>>31;N=l[b>>2];d=N<<1;y=d;q=d>>31;e=ql(w,x,d,q);d=f+e|0;c=K+c|0;c=d>>>0<e>>>0?c+1|0:c;i=d;e=l[b+28>>2];d=r(e,38);O=d;H=d>>31;aa=e;V=e>>31;f=ql(d,H,e,V);d=i+f|0;c=K+c|0;c=d>>>0<f>>>0?c+1|0:c;h=d;i=l[b+32>>2];d=r(i,19);A=d;B=d>>31;f=l[b+24>>2];d=f<<1;j=ql(A,B,d,d>>31);m=h+j|0;d=K+c|0;d=m>>>0<j>>>0?d+1|0:d;h=m;C=l[b+36>>2];c=r(C,38);z=c;s=c>>31;m=l[b+20>>2];b=m<<1;I=b;F=b>>31;j=ql(c,s,b,F);c=h+j|0;b=K+d|0;W=c<<1;c=(c>>>0<j>>>0?b+1|0:b)<<1|c>>>31;fa=c;b=W+33554432|0;if(b>>>0<33554432){c=c+1|0}ba=b;ga=c;b=c>>26;c=(c&67108863)<<6|ba>>>26;d=ql(v,p,w,x);j=K;h=c;c=E<<1;J=c;G=c>>31;P=g;X=g>>31;g=ql(c,G,g,X);d=g+d|0;c=K+j|0;c=d>>>0<g>>>0?c+1|0:c;E=m;Q=m>>31;j=ql(m,Q,y,q);g=j+d|0;d=K+c|0;d=g>>>0<j>>>0?d+1|0:d;L=g;c=e<<1;ca=c;Y=c>>31;g=ql(A,B,c,Y);e=L+g|0;c=K+d|0;c=e>>>0<g>>>0?c+1|0:c;d=e;g=f;D=f>>31;e=ql(z,s,f,D);d=d+e|0;c=K+c|0;c=d>>>0<e>>>0?c+1|0:c;e=d;d=c<<1|d>>>31;e=e<<1;c=h+e|0;b=b+d|0;R=c;c=c>>>0<e>>>0?b+1|0:b;b=R+16777216|0;if(b>>>0<16777216){c=c+1|0}ha=b;b=(c&33554431)<<7|b>>>25;e=c>>25;c=ql(t,u,P,X);d=K;h=b;j=ql(w,x,J,G);b=j+c|0;c=K+d|0;c=b>>>0<j>>>0?c+1|0:c;d=ql(v,p,I,F);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;j=ql(y,q,g,D);d=j+b|0;b=K+c|0;b=d>>>0<j>>>0?b+1|0:b;j=i;S=i>>31;i=ql(A,B,i,S);d=i+d|0;c=K+b|0;c=d>>>0<i>>>0?c+1|0:c;i=ql(z,s,ca,Y);b=i+d|0;d=K+c|0;c=b;b=(c>>>0<i>>>0?d+1|0:d)<<1|c>>>31;i=c<<1;d=h+i|0;c=b+e|0;c=d>>>0<i>>>0?c+1|0:c;b=d;d=b+33554432|0;if(d>>>0<33554432){c=c+1|0}L=d;e=c;c=d&-67108864;l[T+24>>2]=b-c;i=a;b=r(m,38);b=ql(b,b>>31,E,Q);c=K;h=b;b=N;d=b>>31;m=ql(b,d,b,d);b=h+m|0;d=K+c|0;d=b>>>0<m>>>0?d+1|0:d;c=b;b=r(f,19);n=b;Z=b>>31;b=M<<1;da=b;_=b>>31;f=ql(n,Z,b,_);b=c+f|0;c=K+d|0;c=b>>>0<f>>>0?c+1|0:c;d=ql(t,u,O,H);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;f=ql(A,B,J,G);d=f+b|0;b=K+c|0;b=d>>>0<f>>>0?b+1|0:b;f=ql(v,p,z,s);d=f+d|0;c=K+b|0;b=d;m=b<<1;c=(b>>>0<f>>>0?c+1|0:c)<<1|b>>>31;T=c;d=c;b=m+33554432|0;if(b>>>0<33554432){d=d+1|0}N=b;M=d;b=(d&67108863)<<6|b>>>26;f=d>>26;c=ql(n,Z,I,F);d=K;$=b;h=k;ea=h>>31;k=ql(y,q,h,ea);b=k+c|0;c=K+d|0;c=b>>>0<k>>>0?c+1|0:c;k=ql(w,x,O,H);d=k+b|0;b=K+c|0;b=d>>>0<k>>>0?b+1|0:b;k=ql(A,B,t,u);d=k+d|0;c=K+b|0;c=d>>>0<k>>>0?c+1|0:c;k=ql(z,s,U,o);b=k+d|0;d=K+c|0;c=b;b=(c>>>0<k>>>0?d+1|0:d)<<1|c>>>31;k=c<<1;d=$+k|0;c=b+f|0;c=d>>>0<k>>>0?c+1|0:c;k=d;b=d+16777216|0;if(b>>>0<16777216){c=c+1|0}$=b;d=b;b=c>>25;c=(c&33554431)<<7|d>>>25;f=b;b=ql(y,q,U,o);d=K;ia=c;h=ql(v,p,h,ea);b=h+b|0;c=K+d|0;c=b>>>0<h>>>0?c+1|0:c;h=ql(n,Z,g,D);b=h+b|0;d=K+c|0;d=b>>>0<h>>>0?d+1|0:d;h=ql(I,F,O,H);b=h+b|0;c=K+d|0;c=b>>>0<h>>>0?c+1|0:c;d=ql(A,B,da,_);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;h=ql(z,s,t,u);d=h+b|0;b=K+c|0;b=d>>>0<h>>>0?b+1|0:b;c=b<<1|d>>>31;d=d<<1;b=ia+d|0;c=c+f|0;c=b>>>0<d>>>0?c+1|0:c;d=c;c=b+33554432|0;if(c>>>0<33554432){d=d+1|0}h=c;f=d;c=c&-67108864;l[i+8>>2]=b-c;b=ql(J,G,E,Q);d=K;n=ql(w,x,t,u);c=n+b|0;b=K+d|0;b=c>>>0<n>>>0?b+1|0:b;n=ql(v,p,g,D);d=n+c|0;c=K+b|0;c=d>>>0<n>>>0?c+1|0:c;n=ql(y,q,aa,V);b=n+d|0;d=K+c|0;d=b>>>0<n>>>0?d+1|0:d;n=ql(z,s,j,S);b=n+b|0;c=K+d|0;c=b>>>0<n>>>0?c+1|0:c;c=c<<1|b>>>31;d=e>>26;e=(e&67108863)<<6|L>>>26;b=e+(b<<1)|0;c=c+d|0;c=b>>>0<e>>>0?c+1|0:c;d=b;b=c;c=d+16777216|0;if(c>>>0<16777216){b=b+1|0}L=c;e=b;b=c&-33554432;l[i+28>>2]=d-b;b=ql(y,q,P,X);c=K;d=ql(v,p,U,o);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=ql(g,D,O,H);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;o=ql(A,B,I,F);d=o+b|0;b=K+c|0;b=d>>>0<o>>>0?b+1|0:b;o=ql(z,s,w,x);c=o+d|0;d=K+b|0;b=c;c=(c>>>0<o>>>0?d+1|0:d)<<1|c>>>31;d=b<<1;b=f>>26;f=(f&67108863)<<6|h>>>26;d=d+f|0;c=b+c|0;c=d>>>0<f>>>0?c+1|0:c;b=d;d=b+16777216|0;if(d>>>0<16777216){c=c+1|0}P=d;f=c;c=d&-33554432;l[i+12>>2]=b-c;o=a;b=ql(g,D,J,G);c=K;d=ql(w,x,w,x);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=ql(t,u,I,F);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=ql(v,p,ca,Y);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;i=ql(y,q,j,S);d=i+b|0;b=K+c|0;b=d>>>0<i>>>0?b+1|0:b;i=C;h=i>>31;C=ql(z,s,i,h);c=C+d|0;d=K+b|0;b=c;c=(c>>>0<C>>>0?d+1|0:d)<<1|c>>>31;d=b<<1;b=e>>25;e=(e&33554431)<<7|L>>>25;d=d+e|0;c=b+c|0;c=d>>>0<e>>>0?c+1|0:c;b=d;d=b+33554432|0;if(d>>>0<33554432){c=c+1|0}C=d;e=c;c=d&-67108864;l[o+32>>2]=b-c;R=R-(ha&-33554432)|0;c=f>>25;f=(f&33554431)<<7|P>>>25;b=ba&-67108864;d=f+(W-b|0)|0;b=c+(fa-((W>>>0<b>>>0)+ga|0)|0)|0;b=d>>>0<f>>>0?b+1|0:b;c=b;b=d+33554432|0;if(b>>>0<33554432){c=c+1|0}f=((c&67108863)<<6|b>>>26)+R|0;l[o+20>>2]=f;b=b&-67108864;l[a+16>>2]=d-b;b=ql(t,u,g,D);d=K;g=ql(E,Q,da,_);c=g+b|0;b=K+d|0;b=c>>>0<g>>>0?b+1|0:b;g=ql(J,G,aa,V);d=g+c|0;c=K+b|0;c=d>>>0<g>>>0?c+1|0:c;g=ql(v,p,j,S);b=g+d|0;d=K+c|0;d=b>>>0<g>>>0?d+1|0:d;g=ql(y,q,i,h);b=g+b|0;c=K+d|0;c=b>>>0<g>>>0?c+1|0:c;c=c<<1|b>>>31;d=e>>26;e=(e&67108863)<<6|C>>>26;b=e+(b<<1)|0;c=c+d|0;c=b>>>0<e>>>0?c+1|0:c;d=b;e=b;f=b;b=c;c=d+16777216|0;if(c>>>0<16777216){b=b+1|0}d=c&-33554432;l[a+36>>2]=e-d;e=a;f=k-($&-33554432)|0;c=ql((b&33554431)<<7|c>>>25,b>>25,19,0);d=N&-67108864;b=c+(m-d|0)|0;d=K+(T-((m>>>0<d>>>0)+M|0)|0)|0;d=b>>>0<c>>>0?d+1|0:d;c=b;g=e;b=d;d=c+33554432|0;if(d>>>0<33554432){b=b+1|0}e=((b&67108863)<<6|d>>>26)+f|0;l[g+4>>2]=e;b=a;a=d&-67108864;l[b>>2]=c-a}function tc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0;v=J-2048|0;J=v;db(v+1024|0,b);mb(v+1024|0,a);db(v,v+1024|0);mb(v,c);b=0;while(1){a=L<<7;g=(v+1024|0)+(a|96)|0;k=l[g>>2];e=l[g+4>>2];d=k;j=a+(v+1024|0)|0;i=j;k=l[i>>2];h=l[i+4>>2];i=(v+1024|0)+(a|32)|0;f=l[i>>2];m=l[i+4>>2];k=aa(k,h,f,m);h=e;e=K;y=_(d^k,h^e,32);h=y;p=k;r=e;k=(v+1024|0)+(a|64)|0;e=k;d=l[e>>2];q=l[e+4>>2];e=K;y=aa(d,q,y,e);d=m;m=K;d=_(y^f,d^m,24);q=K;G=aa(p,r,d,q);E=K;f=_(h^G,E^e,16);e=K;h=e;l[g>>2]=f;l[g+4>>2]=e;m=aa(y,m,f,e);e=K;s=e;l[k>>2]=m;l[k+4>>2]=e;y=_(d^m,e^q,63);e=K;q=e;l[i>>2]=y;l[i+4>>2]=e;D=(v+1024|0)+(a|104)|0;e=D;d=l[e>>2];C=l[e+4>>2];e=(v+1024|0)+(a|72)|0;z=l[e>>2];o=l[e+4>>2];n=d;r=(v+1024|0)+(a|8)|0;d=r;t=l[d>>2];w=l[d+4>>2];x=(v+1024|0)+(a|40)|0;d=x;p=l[d>>2];F=l[d+4>>2];t=aa(t,w,p,F);d=C;C=K;N=_(n^t,d^C,32);w=K;d=aa(z,o,N,w);n=t;z=d^p;p=K;F=_(z,p^F,24);t=K;Y=aa(n,C,F,t);Z=K;C=_(Y^N,Z^w,16);$=K;d=aa(d,p,C,$);N=K;p=N;l[e>>2]=d;l[e+4>>2]=p;F=_(d^F,p^t,63);t=K;N=(v+1024|0)+(a|112)|0;w=N;O=l[w>>2];H=l[w+4>>2];w=(v+1024|0)+(a|80)|0;A=l[w>>2];Q=l[w+4>>2];o=O;O=(v+1024|0)+(a|16)|0;z=O;B=l[z>>2];u=l[z+4>>2];z=(v+1024|0)+(a|48)|0;n=z;I=l[n>>2];n=l[n+4>>2];B=aa(B,u,I,n);u=H;H=K;M=_(o^B,u^H,32);u=K;o=aa(A,Q,M,u);A=o^I;I=K;n=_(A,n^I,24);A=H;H=K;ba=aa(B,A,n,H);ca=K;da=_(ba^M,ca^u,16);ea=K;Q=aa(o,I,da,ea);U=K;H=_(n^Q,U^H,63);n=K;I=(v+1024|0)+(a|120)|0;B=I;M=l[B>>2];u=l[B+4>>2];B=(v+1024|0)+(a|88)|0;o=B;S=l[o>>2];X=l[o+4>>2];T=M;M=(v+1024|0)+(a|24)|0;o=M;V=l[o>>2];P=l[o+4>>2];a=(v+1024|0)+(a|56)|0;A=l[a>>2];o=l[a+4>>2];W=aa(V,P,A,o);V=u;u=K;P=_(T^W,V^u,32);R=K;S=aa(S,X,P,R);T=S^A;A=K;o=_(T,o^A,24);T=A;A=u;u=K;A=aa(W,A,o,u);W=K;P=_(A^P,W^R,16);R=K;S=aa(S,T,P,R);X=K;u=_(o^S,X^u,63);o=K;T=Q;V=U;G=aa(G,E,F,t);E=K;Q=_(P^G,R^E,32);U=K;P=aa(T,V,Q,U);R=K;F=_(P^F,R^t,24);t=G;G=K;t=aa(t,E,F,G);E=K;l[j>>2]=t;l[j+4>>2]=E;j=_(t^Q,U^E,16);t=K;l[I>>2]=j;l[I+4>>2]=t;j=aa(P,R,j,t);t=K;l[w>>2]=j;l[w+4>>2]=t;fa=x,ga=_(j^F,t^G,63),l[fa>>2]=ga;l[x+4>>2]=K;j=aa(Y,Z,H,n);t=h;h=K;x=_(j^f,t^h,32);F=K;t=aa(S,X,x,F);w=K;f=_(t^H,w^n,24);n=h;h=K;j=aa(j,n,f,h);H=K;n=H;l[r>>2]=j;l[r+4>>2]=n;j=_(j^x,n^F,16);r=K;l[g>>2]=j;l[g+4>>2]=r;g=aa(t,w,j,r);l[B>>2]=g;j=K;l[B+4>>2]=j;fa=z,ga=_(f^g,j^h,63),l[fa>>2]=ga;l[z+4>>2]=K;r=m;f=aa(ba,ca,u,o);m=K;j=_(C^f,$^m,32);h=K;s=aa(r,s,j,h);r=K;g=_(s^u,r^o,24);n=m;m=K;f=aa(f,n,g,m);x=K;l[O>>2]=f;l[O+4>>2]=x;f=_(f^j,h^x,16);j=K;l[D>>2]=f;l[D+4>>2]=j;f=aa(s,r,f,j);l[k>>2]=f;h=k;k=K;l[h+4>>2]=k;fa=a,ga=_(f^g,k^m,63),l[fa>>2]=ga;l[a+4>>2]=K;a=y;g=aa(A,W,y,q);k=K;f=_(da^g,ea^k,32);m=K;y=aa(d,p,f,m);d=K;a=_(a^y,d^q,24);h=k;k=K;g=aa(g,h,a,k);j=K;l[M>>2]=g;l[M+4>>2]=j;g=_(f^g,m^j,16);f=K;l[N>>2]=g;l[N+4>>2]=f;g=aa(y,d,g,f);l[e>>2]=g;d=e;e=K;l[d+4>>2]=e;fa=i,ga=_(a^g,e^k,63),l[fa>>2]=ga;l[i+4>>2]=K;L=L+1|0;if((L|0)!=8){continue}break}while(1){e=b<<4;a=e+(v+1024|0)|0;g=a+768|0;i=l[g>>2];g=l[g+4>>2];d=i;i=l[a+256>>2];k=l[a+260>>2];f=aa(l[a>>2],l[a+4>>2],i,k);m=g;g=K;m=_(d^f,m^g,32);h=g;d=i;g=K;i=aa(l[a+512>>2],l[a+516>>2],m,g);q=k;k=K;y=_(d^i,q^k,24);d=K;C=aa(f,h,y,d);p=K;g=_(m^C,p^g,16);m=K;f=m;l[a+768>>2]=g;l[a+772>>2]=f;i=aa(i,k,g,f);k=K;m=k;l[a+512>>2]=i;l[a+516>>2]=k;k=_(i^y,d^k,63);d=K;y=d;l[a+256>>2]=k;l[a+260>>2]=d;L=l[a+780>>2];r=l[a+520>>2];n=l[a+524>>2];q=l[a+776>>2];d=(v+1024|0)+(e|8)|0;e=d;j=l[a+264>>2];h=l[a+268>>2];s=aa(l[e>>2],l[e+4>>2],j,h);e=L;L=K;q=_(q^s,e^L,32);D=K;e=aa(r,n,q,D);r=s;n=e^j;j=K;h=_(n,h^j,24);s=K;F=aa(r,L,h,s);t=K;L=_(F^q,t^D,16);N=K;e=aa(e,j,L,N);q=K;j=q;l[a+520>>2]=e;l[a+524>>2]=j;h=_(e^h,j^s,63);s=K;q=l[a+900>>2];z=l[a+640>>2];o=l[a+644>>2];w=l[a+896>>2];D=l[a+384>>2];r=l[a+388>>2];x=aa(l[a+128>>2],l[a+132>>2],D,r);n=q;q=K;w=_(w^x,n^q,32);O=K;z=aa(z,o,w,O);n=z^D;D=K;r=_(n,r^D,24);n=z;z=w;o=q;q=K;w=aa(x,o,r,q);o=O;O=K;z=_(z^w,o^O,16);H=K;n=aa(n,D,z,H);I=K;q=_(r^n,I^q,63);D=K;r=l[a+908>>2];G=l[a+648>>2];E=l[a+652>>2];u=l[a+904>>2];x=l[a+392>>2];B=l[a+396>>2];M=aa(l[a+136>>2],l[a+140>>2],x,B);o=r;r=K;u=_(u^M,o^r,32);o=K;G=aa(G,E,u,o);E=G^x;x=K;B=_(E,B^x,24);A=B;E=r;r=K;B=aa(M,E,B,r);M=K;u=_(B^u,M^o,16);o=K;G=aa(G,x,u,o);E=K;r=_(A^G,E^r,63);x=K;A=n;Q=I;C=aa(C,p,h,s);p=K;n=_(u^C,o^p,32);I=K;u=aa(A,Q,n,I);o=K;h=_(u^h,o^s,24);s=C;C=K;s=aa(s,p,h,C);p=K;l[a>>2]=s;l[a+4>>2]=p;s=_(s^n,I^p,16);p=K;l[a+904>>2]=s;l[a+908>>2]=p;s=aa(u,o,s,p);p=K;l[a+640>>2]=s;l[a+644>>2]=p;fa=a,ga=_(h^s,p^C,63),l[fa+264>>2]=ga;l[a+268>>2]=K;p=q;h=aa(F,t,q,D);q=f;f=K;s=_(h^g,q^f,32);q=K;C=aa(G,E,s,q);n=D;D=K;g=_(p^C,n^D,24);p=h;h=K;f=aa(p,f,g,h);p=K;l[d>>2]=f;l[d+4>>2]=p;f=_(f^s,q^p,16);d=K;l[a+768>>2]=f;l[a+772>>2]=d;f=aa(C,D,f,d);l[a+648>>2]=f;d=K;l[a+652>>2]=d;fa=a,ga=_(f^g,d^h,63),l[fa+384>>2]=ga;l[a+388>>2]=K;h=i;q=m;i=aa(w,O,r,x);f=K;m=_(L^i,N^f,32);d=K;L=aa(h,q,m,d);h=K;g=_(L^r,h^x,24);q=f;f=K;i=aa(i,q,g,f);s=K;l[a+128>>2]=i;l[a+132>>2]=s;i=_(i^m,d^s,16);m=K;d=m;l[a+776>>2]=i;l[a+780>>2]=d;i=aa(L,h,i,d);l[a+512>>2]=i;m=K;l[a+516>>2]=m;fa=a,ga=_(g^i,f^m,63),l[fa+392>>2]=ga;l[a+396>>2]=K;d=k;m=e;i=aa(B,M,k,y);k=K;e=_(z^i,H^k,32);f=K;m=aa(m,j,e,f);h=y;y=K;g=_(d^m,h^y,24);d=k;k=K;i=aa(i,d,g,k);d=K;l[a+136>>2]=i;l[a+140>>2]=d;i=_(e^i,f^d,16);e=K;l[a+896>>2]=i;l[a+900>>2]=e;i=aa(m,y,i,e);l[a+520>>2]=i;e=K;l[a+524>>2]=e;fa=a,ga=_(g^i,e^k,63),l[fa+256>>2]=ga;l[a+260>>2]=K;b=b+1|0;if((b|0)!=8){continue}break}db(c,v);mb(c,v+1024|0);J=v+2048|0}function Zg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,$=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0;v=J-2048|0;J=v;db(v+1024|0,b);mb(v+1024|0,a);db(v,v+1024|0);b=0;while(1){a=L<<7;g=(v+1024|0)+(a|96)|0;k=l[g>>2];e=l[g+4>>2];d=k;j=a+(v+1024|0)|0;i=j;k=l[i>>2];h=l[i+4>>2];i=(v+1024|0)+(a|32)|0;f=l[i>>2];m=l[i+4>>2];k=aa(k,h,f,m);h=e;e=K;y=_(d^k,h^e,32);h=y;p=k;r=e;k=(v+1024|0)+(a|64)|0;e=k;d=l[e>>2];q=l[e+4>>2];e=K;y=aa(d,q,y,e);d=m;m=K;d=_(y^f,d^m,24);q=K;G=aa(p,r,d,q);E=K;f=_(h^G,E^e,16);e=K;h=e;l[g>>2]=f;l[g+4>>2]=e;m=aa(y,m,f,e);e=K;s=e;l[k>>2]=m;l[k+4>>2]=e;y=_(d^m,e^q,63);e=K;q=e;l[i>>2]=y;l[i+4>>2]=e;D=(v+1024|0)+(a|104)|0;e=D;d=l[e>>2];C=l[e+4>>2];e=(v+1024|0)+(a|72)|0;z=l[e>>2];o=l[e+4>>2];n=d;r=(v+1024|0)+(a|8)|0;d=r;t=l[d>>2];w=l[d+4>>2];x=(v+1024|0)+(a|40)|0;d=x;p=l[d>>2];F=l[d+4>>2];t=aa(t,w,p,F);d=C;C=K;N=_(n^t,d^C,32);w=K;d=aa(z,o,N,w);n=t;z=d^p;p=K;F=_(z,p^F,24);t=K;Y=aa(n,C,F,t);Z=K;C=_(Y^N,Z^w,16);$=K;d=aa(d,p,C,$);N=K;p=N;l[e>>2]=d;l[e+4>>2]=p;F=_(d^F,p^t,63);t=K;N=(v+1024|0)+(a|112)|0;w=N;O=l[w>>2];H=l[w+4>>2];w=(v+1024|0)+(a|80)|0;A=l[w>>2];Q=l[w+4>>2];o=O;O=(v+1024|0)+(a|16)|0;z=O;B=l[z>>2];u=l[z+4>>2];z=(v+1024|0)+(a|48)|0;n=z;I=l[n>>2];n=l[n+4>>2];B=aa(B,u,I,n);u=H;H=K;M=_(o^B,u^H,32);u=K;o=aa(A,Q,M,u);A=o^I;I=K;n=_(A,n^I,24);A=H;H=K;ba=aa(B,A,n,H);ca=K;da=_(ba^M,ca^u,16);ea=K;Q=aa(o,I,da,ea);U=K;H=_(n^Q,U^H,63);n=K;I=(v+1024|0)+(a|120)|0;B=I;M=l[B>>2];u=l[B+4>>2];B=(v+1024|0)+(a|88)|0;o=B;S=l[o>>2];X=l[o+4>>2];T=M;M=(v+1024|0)+(a|24)|0;o=M;V=l[o>>2];P=l[o+4>>2];a=(v+1024|0)+(a|56)|0;A=l[a>>2];o=l[a+4>>2];W=aa(V,P,A,o);V=u;u=K;P=_(T^W,V^u,32);R=K;S=aa(S,X,P,R);T=S^A;A=K;o=_(T,o^A,24);T=A;A=u;u=K;A=aa(W,A,o,u);W=K;P=_(A^P,W^R,16);R=K;S=aa(S,T,P,R);X=K;u=_(o^S,X^u,63);o=K;T=Q;V=U;G=aa(G,E,F,t);E=K;Q=_(P^G,R^E,32);U=K;P=aa(T,V,Q,U);R=K;F=_(P^F,R^t,24);t=G;G=K;t=aa(t,E,F,G);E=K;l[j>>2]=t;l[j+4>>2]=E;j=_(t^Q,U^E,16);t=K;l[I>>2]=j;l[I+4>>2]=t;j=aa(P,R,j,t);t=K;l[w>>2]=j;l[w+4>>2]=t;fa=x,ga=_(j^F,t^G,63),l[fa>>2]=ga;l[x+4>>2]=K;j=aa(Y,Z,H,n);t=h;h=K;x=_(j^f,t^h,32);F=K;t=aa(S,X,x,F);w=K;f=_(t^H,w^n,24);n=h;h=K;j=aa(j,n,f,h);H=K;n=H;l[r>>2]=j;l[r+4>>2]=n;j=_(j^x,n^F,16);r=K;l[g>>2]=j;l[g+4>>2]=r;g=aa(t,w,j,r);l[B>>2]=g;j=K;l[B+4>>2]=j;fa=z,ga=_(f^g,j^h,63),l[fa>>2]=ga;l[z+4>>2]=K;r=m;f=aa(ba,ca,u,o);m=K;j=_(C^f,$^m,32);h=K;s=aa(r,s,j,h);r=K;g=_(s^u,r^o,24);n=m;m=K;f=aa(f,n,g,m);x=K;l[O>>2]=f;l[O+4>>2]=x;f=_(f^j,h^x,16);j=K;l[D>>2]=f;l[D+4>>2]=j;f=aa(s,r,f,j);l[k>>2]=f;h=k;k=K;l[h+4>>2]=k;fa=a,ga=_(f^g,k^m,63),l[fa>>2]=ga;l[a+4>>2]=K;a=y;g=aa(A,W,y,q);k=K;f=_(da^g,ea^k,32);m=K;y=aa(d,p,f,m);d=K;a=_(a^y,d^q,24);h=k;k=K;g=aa(g,h,a,k);j=K;l[M>>2]=g;l[M+4>>2]=j;g=_(f^g,m^j,16);f=K;l[N>>2]=g;l[N+4>>2]=f;g=aa(y,d,g,f);l[e>>2]=g;d=e;e=K;l[d+4>>2]=e;fa=i,ga=_(a^g,e^k,63),l[fa>>2]=ga;l[i+4>>2]=K;L=L+1|0;if((L|0)!=8){continue}break}while(1){e=b<<4;a=e+(v+1024|0)|0;g=a+768|0;i=l[g>>2];g=l[g+4>>2];d=i;i=l[a+256>>2];k=l[a+260>>2];f=aa(l[a>>2],l[a+4>>2],i,k);m=g;g=K;m=_(d^f,m^g,32);h=g;d=i;g=K;i=aa(l[a+512>>2],l[a+516>>2],m,g);q=k;k=K;y=_(d^i,q^k,24);d=K;C=aa(f,h,y,d);p=K;g=_(m^C,p^g,16);m=K;f=m;l[a+768>>2]=g;l[a+772>>2]=f;i=aa(i,k,g,f);k=K;m=k;l[a+512>>2]=i;l[a+516>>2]=k;k=_(i^y,d^k,63);d=K;y=d;l[a+256>>2]=k;l[a+260>>2]=d;L=l[a+780>>2];r=l[a+520>>2];n=l[a+524>>2];q=l[a+776>>2];d=(v+1024|0)+(e|8)|0;e=d;j=l[a+264>>2];h=l[a+268>>2];s=aa(l[e>>2],l[e+4>>2],j,h);e=L;L=K;q=_(q^s,e^L,32);D=K;e=aa(r,n,q,D);r=s;n=e^j;j=K;h=_(n,h^j,24);s=K;F=aa(r,L,h,s);t=K;L=_(F^q,t^D,16);N=K;e=aa(e,j,L,N);q=K;j=q;l[a+520>>2]=e;l[a+524>>2]=j;h=_(e^h,j^s,63);s=K;q=l[a+900>>2];z=l[a+640>>2];o=l[a+644>>2];w=l[a+896>>2];D=l[a+384>>2];r=l[a+388>>2];x=aa(l[a+128>>2],l[a+132>>2],D,r);n=q;q=K;w=_(w^x,n^q,32);O=K;z=aa(z,o,w,O);n=z^D;D=K;r=_(n,r^D,24);n=z;z=w;o=q;q=K;w=aa(x,o,r,q);o=O;O=K;z=_(z^w,o^O,16);H=K;n=aa(n,D,z,H);I=K;q=_(r^n,I^q,63);D=K;r=l[a+908>>2];G=l[a+648>>2];E=l[a+652>>2];u=l[a+904>>2];x=l[a+392>>2];B=l[a+396>>2];M=aa(l[a+136>>2],l[a+140>>2],x,B);o=r;r=K;u=_(u^M,o^r,32);o=K;G=aa(G,E,u,o);E=G^x;x=K;B=_(E,B^x,24);A=B;E=r;r=K;B=aa(M,E,B,r);M=K;u=_(B^u,M^o,16);o=K;G=aa(G,x,u,o);E=K;r=_(A^G,E^r,63);x=K;A=n;Q=I;C=aa(C,p,h,s);p=K;n=_(u^C,o^p,32);I=K;u=aa(A,Q,n,I);o=K;h=_(u^h,o^s,24);s=C;C=K;s=aa(s,p,h,C);p=K;l[a>>2]=s;l[a+4>>2]=p;s=_(s^n,I^p,16);p=K;l[a+904>>2]=s;l[a+908>>2]=p;s=aa(u,o,s,p);p=K;l[a+640>>2]=s;l[a+644>>2]=p;fa=a,ga=_(h^s,p^C,63),l[fa+264>>2]=ga;l[a+268>>2]=K;p=q;h=aa(F,t,q,D);q=f;f=K;s=_(h^g,q^f,32);q=K;C=aa(G,E,s,q);n=D;D=K;g=_(p^C,n^D,24);p=h;h=K;f=aa(p,f,g,h);p=K;l[d>>2]=f;l[d+4>>2]=p;f=_(f^s,q^p,16);d=K;l[a+768>>2]=f;l[a+772>>2]=d;f=aa(C,D,f,d);l[a+648>>2]=f;d=K;l[a+652>>2]=d;fa=a,ga=_(f^g,d^h,63),l[fa+384>>2]=ga;l[a+388>>2]=K;h=i;q=m;i=aa(w,O,r,x);f=K;m=_(L^i,N^f,32);d=K;L=aa(h,q,m,d);h=K;g=_(L^r,h^x,24);q=f;f=K;i=aa(i,q,g,f);s=K;l[a+128>>2]=i;l[a+132>>2]=s;i=_(i^m,d^s,16);m=K;d=m;l[a+776>>2]=i;l[a+780>>2]=d;i=aa(L,h,i,d);l[a+512>>2]=i;m=K;l[a+516>>2]=m;fa=a,ga=_(g^i,f^m,63),l[fa+392>>2]=ga;l[a+396>>2]=K;d=k;m=e;i=aa(B,M,k,y);k=K;e=_(z^i,H^k,32);f=K;m=aa(m,j,e,f);h=y;y=K;g=_(d^m,h^y,24);d=k;k=K;i=aa(i,d,g,k);d=K;l[a+136>>2]=i;l[a+140>>2]=d;i=_(e^i,f^d,16);e=K;l[a+896>>2]=i;l[a+900>>2]=e;i=aa(m,y,i,e);l[a+520>>2]=i;e=K;l[a+524>>2]=e;fa=a,ga=_(g^i,e^k,63),l[fa+256>>2]=ga;l[a+260>>2]=K;b=b+1|0;if((b|0)!=8){continue}break}db(c,v);mb(c,v+1024|0);J=v+2048|0}function ha(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0;h=a;c=l[b+12>>2];d=c<<1;z=d;s=d>>31;j=c;V=c>>31;c=ql(d,s,c,V);e=K;d=c;Q=l[b+16>>2];c=Q;t=c;u=c>>31;m=l[b+8>>2];c=m<<1;J=c;E=c>>31;g=ql(t,u,c,E);d=d+g|0;c=K+e|0;c=d>>>0<g>>>0?c+1|0:c;e=d;g=l[b+20>>2];d=g<<1;F=d;G=d>>31;n=l[b+4>>2];d=n<<1;v=d;o=d>>31;f=ql(F,G,d,o);e=e+f|0;d=K+c|0;d=e>>>0<f>>>0?d+1|0:d;i=l[b+24>>2];c=i;L=c;A=c>>31;M=l[b>>2];c=M<<1;w=c;p=c>>31;f=ql(i,A,c,p);e=f+e|0;c=K+d|0;c=e>>>0<f>>>0?c+1|0:c;k=e;d=l[b+32>>2];e=r(d,19);H=e;B=e>>31;W=d;R=d>>31;e=ql(e,B,d,R);d=k+e|0;c=K+c|0;c=d>>>0<e>>>0?c+1|0:c;k=d;C=l[b+36>>2];d=r(C,38);x=d;q=d>>31;e=l[b+28>>2];b=e<<1;aa=b;X=b>>31;f=ql(d,q,b,X);d=k+f|0;b=K+c|0;D=d;y=d>>>0<f>>>0?b+1|0:b;b=ql(v,o,t,u);c=K;d=ql(J,E,j,V);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;Y=g;S=g>>31;f=ql(g,S,w,p);b=f+b|0;d=K+c|0;d=b>>>0<f>>>0?d+1|0:d;f=ql(H,B,aa,X);b=f+b|0;c=K+d|0;c=b>>>0<f>>>0?c+1|0:c;d=ql(x,q,i,A);b=d+b|0;c=K+c|0;k=b;N=b>>>0<d>>>0?c+1|0:c;b=ql(v,o,z,s);d=K;f=m;O=f>>31;m=ql(f,O,f,O);c=m+b|0;b=K+d|0;b=c>>>0<m>>>0?b+1|0:b;m=ql(w,p,t,u);d=m+c|0;c=K+b|0;c=d>>>0<m>>>0?c+1|0:c;b=r(e,38);T=b;P=b>>31;m=e;Z=e>>31;e=ql(b,P,e,Z);b=e+d|0;d=K+c|0;d=b>>>0<e>>>0?d+1|0:d;c=b;b=i<<1;e=ql(H,B,b,b>>31);b=c+e|0;c=K+d|0;c=b>>>0<e>>>0?c+1|0:c;d=ql(x,q,F,G);b=d+b|0;c=K+c|0;_=b;c=b>>>0<d>>>0?c+1|0:c;da=c;b=c;c=_+33554432|0;if(c>>>0<33554432){b=b+1|0}ba=c;ea=b;c=b>>26;d=(b&67108863)<<6|ba>>>26;b=d+k|0;c=c+N|0;N=b;d=b>>>0<d>>>0?c+1|0:c;b=b+16777216|0;if(b>>>0<16777216){d=d+1|0}fa=b;c=d>>25;d=(d&33554431)<<7|b>>>25;b=d+D|0;c=c+y|0;c=b>>>0<d>>>0?c+1|0:c;d=b;b=c;c=d+33554432|0;if(c>>>0<33554432){b=b+1|0}k=c;e=b;b=c&-67108864;l[h+24>>2]=d-b;y=a;b=ql(w,p,f,O);c=K;h=n;I=h>>31;n=ql(v,o,h,I);b=n+b|0;d=K+c|0;d=b>>>0<n>>>0?d+1|0:d;c=b;b=r(i,19);n=b;D=b>>31;i=ql(b,D,L,A);b=c+i|0;c=K+d|0;c=b>>>0<i>>>0?c+1|0:c;i=ql(F,G,T,P);d=i+b|0;b=K+c|0;b=d>>>0<i>>>0?b+1|0:b;c=Q<<1;ca=c;$=c>>31;i=ql(H,B,c,$);d=i+d|0;c=K+b|0;c=d>>>0<i>>>0?c+1|0:c;b=d;d=ql(x,q,z,s);b=b+d|0;c=K+c|0;U=b;i=b>>>0<d>>>0?c+1|0:c;b=ql(F,G,n,D);c=K;h=ql(w,p,h,I);b=h+b|0;d=K+c|0;d=b>>>0<h>>>0?d+1|0:d;h=ql(t,u,T,P);b=h+b|0;c=K+d|0;c=b>>>0<h>>>0?c+1|0:c;h=ql(H,B,z,s);d=h+b|0;b=K+c|0;b=d>>>0<h>>>0?b+1|0:b;h=ql(x,q,f,O);d=h+d|0;c=K+b|0;I=d;h=d>>>0<h>>>0?c+1|0:c;b=r(g,38);b=ql(b,b>>31,Y,S);c=K;g=b;b=M;d=b>>31;d=ql(b,d,b,d);b=g+d|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;g=ql(n,D,ca,$);b=g+b|0;d=K+c|0;d=b>>>0<g>>>0?d+1|0:d;g=ql(z,s,T,P);b=g+b|0;c=K+d|0;c=b>>>0<g>>>0?c+1|0:c;g=ql(H,B,J,E);d=g+b|0;b=K+c|0;b=d>>>0<g>>>0?b+1|0:b;g=ql(v,o,x,q);d=g+d|0;c=K+b|0;n=d;c=d>>>0<g>>>0?c+1|0:c;D=c;b=d+33554432|0;if(b>>>0<33554432){c=c+1|0}M=b;Q=c;b=c>>26;g=(c&67108863)<<6|M>>>26;c=g+I|0;d=b+h|0;h=c;c=c>>>0<g>>>0?d+1|0:d;b=h+16777216|0;if(b>>>0<16777216){c=c+1|0}I=b;g=(c&33554431)<<7|b>>>25;d=g+U|0;c=(c>>25)+i|0;c=d>>>0<g>>>0?c+1|0:c;b=d;d=b+33554432|0;if(d>>>0<33554432){c=c+1|0}i=d;g=c;c=d&-67108864;l[y+8>>2]=b-c;b=ql(J,E,Y,S);c=K;d=ql(t,u,z,s);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=ql(v,o,L,A);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=ql(w,p,m,Z);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;U=ql(x,q,W,R);d=U+b|0;b=K+c|0;b=d>>>0<U>>>0?b+1|0:b;c=e>>26;k=(e&67108863)<<6|k>>>26;e=k+d|0;d=b+c|0;d=e>>>0<k>>>0?d+1|0:d;b=e;c=d;d=b+16777216|0;if(d>>>0<16777216){c=c+1|0}k=d;e=c;c=d&-33554432;l[y+28>>2]=b-c;b=ql(w,p,j,V);d=K;f=ql(v,o,f,O);c=f+b|0;b=K+d|0;b=c>>>0<f>>>0?b+1|0:b;f=ql(L,A,T,P);c=f+c|0;d=K+b|0;d=c>>>0<f>>>0?d+1|0:d;f=ql(H,B,F,G);b=f+c|0;c=K+d|0;c=b>>>0<f>>>0?c+1|0:c;d=ql(x,q,t,u);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=g>>26;g=(g&67108863)<<6|i>>>26;b=g+b|0;c=c+d|0;c=b>>>0<g>>>0?c+1|0:c;d=b;b=c;c=d+16777216|0;if(c>>>0<16777216){b=b+1|0}i=c;g=b;b=c&-33554432;l[y+12>>2]=d-b;f=a;b=ql(L,A,J,E);c=K;d=ql(t,u,t,u);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=ql(z,s,F,G);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;j=ql(v,o,aa,X);d=j+b|0;b=K+c|0;b=d>>>0<j>>>0?b+1|0:b;j=ql(w,p,W,R);c=j+d|0;d=K+b|0;d=c>>>0<j>>>0?d+1|0:d;j=C;y=j>>31;C=ql(x,q,j,y);b=C+c|0;c=K+d|0;c=b>>>0<C>>>0?c+1|0:c;d=b;b=e>>25;e=(e&33554431)<<7|k>>>25;d=d+e|0;c=b+c|0;c=d>>>0<e>>>0?c+1|0:c;b=d;d=b+33554432|0;if(d>>>0<33554432){c=c+1|0}C=d;e=c;c=d&-67108864;l[f+32>>2]=b-c;N=N-(fa&-33554432)|0;c=g>>25;g=(g&33554431)<<7|i>>>25;b=ba&-67108864;d=g+(_-b|0)|0;b=c+(da-((_>>>0<b>>>0)+ea|0)|0)|0;b=d>>>0<g>>>0?b+1|0:b;c=b;b=d+33554432|0;if(b>>>0<33554432){c=c+1|0}g=((c&67108863)<<6|b>>>26)+N|0;l[f+20>>2]=g;b=b&-67108864;l[a+16>>2]=d-b;g=a;b=ql(z,s,L,A);d=K;f=ql(Y,S,ca,$);c=f+b|0;b=K+d|0;b=c>>>0<f>>>0?b+1|0:b;f=ql(J,E,m,Z);d=f+c|0;c=K+b|0;c=d>>>0<f>>>0?c+1|0:c;f=ql(v,o,W,R);b=f+d|0;d=K+c|0;d=b>>>0<f>>>0?d+1|0:d;f=ql(w,p,j,y);b=f+b|0;c=K+d|0;d=b;b=b>>>0<f>>>0?c+1|0:c;c=e>>26;e=(e&67108863)<<6|C>>>26;d=e+d|0;c=b+c|0;c=d>>>0<e>>>0?c+1|0:c;e=d;i=d;b=c;c=d+16777216|0;if(c>>>0<16777216){b=b+1|0}d=c&-33554432;l[g+36>>2]=e-d;f=ql((b&33554431)<<7|c>>>25,b>>25,19,0);d=M&-67108864;b=f+(n-d|0)|0;c=K+(D-((n>>>0<d>>>0)+Q|0)|0)|0;d=b;b=b>>>0<f>>>0?c+1|0:c;c=d+33554432|0;if(c>>>0<33554432){b=b+1|0}e=(h-(I&-33554432)|0)+((b&67108863)<<6|c>>>26)|0;l[a+4>>2]=e;b=a;a=c&-67108864;l[b>>2]=d-a}function ec(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;vk(c,b);b=a;e=l[b+28>>2];l[d+24>>2]=l[b+24>>2];l[d+28>>2]=e;e=l[b+20>>2];l[d+16>>2]=l[b+16>>2];l[d+20>>2]=e;e=l[b+12>>2];l[d+8>>2]=l[b+8>>2];l[d+12>>2]=e;e=l[b+4>>2];l[d>>2]=l[b>>2];l[d+4>>2]=e;e=l[c>>2];b=0;while(1){j=l[d+16>>2];e=($(j,6)^$(j,11)^$(j,25))+e|0;A=b<<2;g=l[d+24>>2];h=l[d+20>>2];e=l[d+28>>2]+((l[A+35840>>2]+e|0)+(j&(g^h)^g)|0)|0;m=e+l[d+12>>2]|0;l[d+12>>2]=m;f=l[d>>2];e=e+($(f,2)^$(f,13)^$(f,22))|0;n=l[d+8>>2];i=l[d+4>>2];e=e+(f&(n|i)|i&n)|0;l[d+28>>2]=e;k=(g+(h^m&(h^j))|0)+($(m,6)^$(m,11)^$(m,25))|0;g=(b|1)<<2;o=g+c|0;g=(k+l[o>>2]|0)+l[g+35840>>2]|0;n=g+n|0;l[d+8>>2]=n;g=(g+(e&(f|i)|f&i)|0)+($(e,2)^$(e,13)^$(e,22))|0;l[d+24>>2]=g;k=i;i=(b|2)<<2;B=i+c|0;i=(((h+(j^n&(j^m))|0)+($(n,6)^$(n,11)^$(n,25))|0)+l[B>>2]|0)+l[i+35840>>2]|0;h=k+i|0;l[d+4>>2]=h;i=(i+(g&(e|f)|e&f)|0)+($(g,2)^$(g,13)^$(g,22))|0;l[d+20>>2]=i;k=f;f=(b|3)<<2;p=f+c|0;f=(((j+(m^h&(m^n))|0)+($(h,6)^$(h,11)^$(h,25))|0)+l[p>>2]|0)+l[f+35840>>2]|0;j=k+f|0;l[d>>2]=j;f=(f+(i&(e|g)|e&g)|0)+($(i,2)^$(i,13)^$(i,22))|0;l[d+16>>2]=f;k=e;e=(b|4)<<2;C=e+c|0;e=(((m+(n^j&(h^n))|0)+($(j,6)^$(j,11)^$(j,25))|0)+l[C>>2]|0)+l[e+35840>>2]|0;m=k+e|0;l[d+28>>2]=m;e=(e+(f&(g|i)|g&i)|0)+($(f,2)^$(f,13)^$(f,22))|0;l[d+12>>2]=e;k=g;g=(b|5)<<2;q=g+c|0;g=(((n+(h^m&(h^j))|0)+($(m,6)^$(m,11)^$(m,25))|0)+l[q>>2]|0)+l[g+35840>>2]|0;n=k+g|0;l[d+24>>2]=n;g=(g+(e&(f|i)|f&i)|0)+($(e,2)^$(e,13)^$(e,22))|0;l[d+8>>2]=g;k=i;i=(b|6)<<2;D=i+c|0;i=(((h+(j^n&(j^m))|0)+($(n,6)^$(n,11)^$(n,25))|0)+l[D>>2]|0)+l[i+35840>>2]|0;h=k+i|0;l[d+20>>2]=h;i=(i+(g&(e|f)|e&f)|0)+($(g,2)^$(g,13)^$(g,22))|0;l[d+4>>2]=i;k=f;f=(b|7)<<2;r=f+c|0;f=(((j+(m^h&(m^n))|0)+($(h,6)^$(h,11)^$(h,25))|0)+l[r>>2]|0)+l[f+35840>>2]|0;j=k+f|0;l[d+16>>2]=j;f=(f+(i&(e|g)|e&g)|0)+($(i,2)^$(i,13)^$(i,22))|0;l[d>>2]=f;k=e;e=(b|8)<<2;w=e+c|0;e=(((m+(n^j&(h^n))|0)+($(j,6)^$(j,11)^$(j,25))|0)+l[w>>2]|0)+l[e+35840>>2]|0;m=k+e|0;l[d+12>>2]=m;e=(e+(f&(g|i)|g&i)|0)+($(f,2)^$(f,13)^$(f,22))|0;l[d+28>>2]=e;k=g;g=(b|9)<<2;s=g+c|0;g=(((n+(h^m&(h^j))|0)+($(m,6)^$(m,11)^$(m,25))|0)+l[s>>2]|0)+l[g+35840>>2]|0;n=k+g|0;l[d+8>>2]=n;g=(g+(e&(f|i)|f&i)|0)+($(e,2)^$(e,13)^$(e,22))|0;l[d+24>>2]=g;k=i;i=(b|10)<<2;x=i+c|0;i=(((h+(j^n&(j^m))|0)+($(n,6)^$(n,11)^$(n,25))|0)+l[x>>2]|0)+l[i+35840>>2]|0;h=k+i|0;l[d+4>>2]=h;i=(i+(g&(e|f)|e&f)|0)+($(g,2)^$(g,13)^$(g,22))|0;l[d+20>>2]=i;k=f;f=(b|11)<<2;t=f+c|0;f=(((j+(m^h&(m^n))|0)+($(h,6)^$(h,11)^$(h,25))|0)+l[t>>2]|0)+l[f+35840>>2]|0;j=k+f|0;l[d>>2]=j;f=(f+(i&(e|g)|e&g)|0)+($(i,2)^$(i,13)^$(i,22))|0;l[d+16>>2]=f;k=e;e=(b|12)<<2;y=e+c|0;e=(((m+(n^j&(h^n))|0)+($(j,6)^$(j,11)^$(j,25))|0)+l[y>>2]|0)+l[e+35840>>2]|0;m=k+e|0;l[d+28>>2]=m;e=(e+(f&(g|i)|g&i)|0)+($(f,2)^$(f,13)^$(f,22))|0;l[d+12>>2]=e;k=g;g=(b|13)<<2;u=g+c|0;g=(((n+(h^m&(h^j))|0)+($(m,6)^$(m,11)^$(m,25))|0)+l[u>>2]|0)+l[g+35840>>2]|0;n=k+g|0;l[d+24>>2]=n;g=(g+(e&(f|i)|f&i)|0)+($(e,2)^$(e,13)^$(e,22))|0;l[d+8>>2]=g;k=i;i=(b|14)<<2;v=i+c|0;h=(((h+(j^n&(j^m))|0)+($(n,6)^$(n,11)^$(n,25))|0)+l[v>>2]|0)+l[i+35840>>2]|0;i=k+h|0;l[d+20>>2]=i;h=(h+(g&(e|f)|e&f)|0)+($(g,2)^$(g,13)^$(g,22))|0;l[d+4>>2]=h;k=f;j=(j+(m^i&(m^n))|0)+($(i,6)^$(i,11)^$(i,25))|0;f=(b|15)<<2;i=f+c|0;f=(j+l[i>>2]|0)+l[f+35840>>2]|0;l[d+16>>2]=k+f;E=d,F=(f+(h&(e|g)|e&g)|0)+($(h,2)^$(h,13)^$(h,22))|0,l[E>>2]=F;if((b|0)==48){while(1){b=z<<2;c=b+a|0;l[c>>2]=l[c>>2]+l[b+d>>2];z=z+1|0;if((z|0)!=8){continue}break}}else{b=b+16|0;n=l[v>>2];f=n>>>10^$(n,17)^$(n,19);g=l[s>>2];e=l[o>>2];f=((f+g|0)+l[c+A>>2]|0)+(e>>>3^$(e,7)^$(e,18))|0;l[(b<<2)+c>>2]=f;k=e+l[o+36>>2]|0;e=l[i>>2];k=k+(e>>>10^$(e,17)^$(e,19))|0;m=l[o+4>>2];h=k+(m>>>3^$(m,7)^$(m,18))|0;l[o- -64>>2]=h;k=$(f,17)^f>>>10^$(f,19);f=l[t>>2];k=m+(k+f|0)|0;m=l[p>>2];j=k+(m>>>3^$(m,7)^$(m,18))|0;l[B- -64>>2]=j;k=(m+l[p+36>>2]|0)+($(h,17)^h>>>10^$(h,19))|0;h=l[p+4>>2];o=k+(h>>>3^$(h,7)^$(h,18))|0;l[p- -64>>2]=o;k=$(j,17)^j>>>10^$(j,19);m=l[u>>2];k=h+(k+m|0)|0;h=l[q>>2];j=k+(h>>>3^$(h,7)^$(h,18))|0;l[C- -64>>2]=j;k=(h+l[q+36>>2]|0)+($(o,17)^o>>>10^$(o,19))|0;h=l[q+4>>2];o=k+(h>>>3^$(h,7)^$(h,18))|0;l[q- -64>>2]=o;k=h+(e+($(j,17)^j>>>10^$(j,19))|0)|0;h=l[r>>2];j=k+(h>>>3^$(h,7)^$(h,18))|0;l[D- -64>>2]=j;k=(h+l[r+36>>2]|0)+($(o,17)^o>>>10^$(o,19))|0;h=l[r+4>>2];o=k+(h>>>3^$(h,7)^$(h,18))|0;l[r- -64>>2]=o;h=(h+(($(j,17)^j>>>10^$(j,19))+l[w+36>>2]|0)|0)+($(g,7)^g>>>3^$(g,18))|0;l[w- -64>>2]=h;k=(g+l[s+36>>2]|0)+($(o,17)^o>>>10^$(o,19))|0;g=l[s+4>>2];j=k+(g>>>3^$(g,7)^$(g,18))|0;l[s- -64>>2]=j;g=(g+(($(h,17)^h>>>10^$(h,19))+l[x+36>>2]|0)|0)+($(f,7)^f>>>3^$(f,18))|0;l[x- -64>>2]=g;k=(f+l[t+36>>2]|0)+($(j,17)^j>>>10^$(j,19))|0;f=l[t+4>>2];h=k+(f>>>3^$(f,7)^$(f,18))|0;l[t- -64>>2]=h;g=(f+(($(g,17)^g>>>10^$(g,19))+l[y+36>>2]|0)|0)+($(m,7)^m>>>3^$(m,18))|0;l[y- -64>>2]=g;k=(m+l[u+36>>2]|0)+($(h,17)^h>>>10^$(h,19))|0;f=l[u+4>>2];f=k+(f>>>3^$(f,7)^$(f,18))|0;l[u- -64>>2]=f;E=v- -64|0,F=((n+l[v+36>>2]|0)+($(g,17)^g>>>10^$(g,19))|0)+($(e,7)^e>>>3^$(e,18))|0,l[E>>2]=F;f=(e+l[i+36>>2]|0)+($(f,17)^f>>>10^$(f,19))|0;e=l[i+4>>2];E=i- -64|0,F=f+(e>>>3^$(e,7)^$(e,18))|0,l[E>>2]=F;continue}break}}function wi(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;f=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);g=f^1886610805;e=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);j=e^1936682341;k=f^1852142177;i=e^1819895653;f=m[d+8|0]|m[d+9|0]<<8|(m[d+10|0]<<16|m[d+11|0]<<24);e=f^1852075907;d=m[d+12|0]|m[d+13|0]<<8|(m[d+14|0]<<16|m[d+15|0]<<24);h=d^1685025377;l=f^2037671283;n=d^1952801890;r=c&7;f=(b+c|0)-r|0;if((f|0)!=(b|0)){while(1){o=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);q=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);p=da(e,h,13);d=h+j|0;j=K;e=e+g|0;if(e>>>0<g>>>0){d=d+1|0}g=d;h=e;s=da(e,d,32);v=K;d=n^q;l=l^o;n=da(l,d,16);t=K;d=d+i|0;e=k+l|0;if(e>>>0<k>>>0){d=d+1|0}k=e^n;i=d^t;l=i;n=da(k,i,21);t=K;g=g^j;h=h^p;p=da(h,g,17);u=K;d=d+g|0;g=e+h|0;if(g>>>0<e>>>0){d=d+1|0}i=da(g,d,32);j=K;h=g^p;p=d^u;u=da(h,p,13);d=l+v|0;l=p;e=k+s|0;if(e>>>0<k>>>0){d=d+1|0}g=d;d=l+g|0;s=K;p=e+h|0;if(p>>>0<e>>>0){d=d+1|0}h=d;k=da(p,d,32);l=K;d=g^t;e=e^n;n=da(e,d,16);d=d+j|0;j=e+i|0;if(j>>>0<i>>>0){d=d+1|0}e=d;i=e^K;d=i+l|0;l=j^n;g=k+l|0;if(g>>>0<l>>>0){d=d+1|0}l=da(l,i,21)^g;k=d;n=d^K;d=h^s;i=p^u;p=da(i,d,17);s=K;d=e+d|0;i=j+i|0;if(i>>>0<j>>>0){d=d+1|0}e=i^p;h=d^s;g=g^o;j=k^q;k=da(i,d,32);i=K;b=b+8|0;if((f|0)!=(b|0)){continue}break}b=f}f=c<<24;c=0;a:{switch(r+ -1|0){case 6:f=f|m[b+6|0]<<16;case 5:f=f|m[b+5|0]<<8;case 4:f=f|m[b+4|0];case 3:c=m[b+3|0];d=c>>>8|0;c=c<<24;f=d|f;case 2:d=m[b+2|0];o=d>>>16|0;c=c|d<<16;f=f|o;case 1:d=m[b+1|0];o=d>>>24|0;c=c|d<<8;f=f|o;case 0:c=m[b|0]|c;break;default:break a}}o=da(e,h,13);d=h+j|0;j=K;b=e+g|0;if(b>>>0<g>>>0){d=d+1|0}e=d;g=b;q=da(b,d,32);p=K;b=f^n;d=b;h=c^l;l=da(h,d,16);n=K;d=d+i|0;b=h+k|0;if(b>>>0<k>>>0){d=d+1|0}h=b^l;k=d^n;i=k;l=da(h,i,21);n=K;e=e^j;g=g^o;j=da(g,e,17);o=K;d=d+e|0;e=b+g|0;if(e>>>0<b>>>0){d=d+1|0}k=da(e,d,32);r=K;g=e^j;j=d^o;o=da(g,j,13);d=i+p|0;b=h+q|0;if(b>>>0<h>>>0){d=d+1|0}e=d;d=j+e|0;j=K;h=b+g|0;if(h>>>0<b>>>0){d=d+1|0}g=d;i=da(h,d,32);q=K;d=e^n;b=b^l;l=da(b,d,16);n=K;d=d+r|0;b=b+k|0;if(b>>>0<k>>>0){d=d+1|0}e=b^l;k=d^n;l=k;k=da(e,k,21);n=K;g=g^j;h=h^o;o=da(h,g,17);p=K;d=d+g|0;g=b+h|0;if(g>>>0<b>>>0){d=d+1|0}j=da(g,d,32);r=K;h=g^o;b=d^p;o=da(h,b,13);d=l+q|0;l=b;g=e+i|0;if(g>>>0<e>>>0){b=d+1|0}else{b=d}d=l+(b^f)|0;i=K;f=c^g;c=f+h|0;if(c>>>0<f>>>0){d=d+1|0}f=d;h=da(c,d,32);l=K;b=b^n;d=b;e=g^k;g=da(e,d,16);k=K;d=d+r|0;b=e+(j^238)|0;if(b>>>0<e>>>0){d=d+1|0}e=b^g;g=d^k;k=g;j=da(e,g,21);n=K;f=f^i;g=f;c=c^o;f=da(c,f,17);i=K;d=d+g|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}o=da(c,d,32);q=K;c=c^f;f=d^i;i=da(c,f,13);d=k+l|0;e=e+h|0;if(e>>>0<h>>>0){b=d+1|0}else{b=d}d=f+b|0;h=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);k=K;b=b^n;d=b;e=e^j;j=da(e,d,16);l=K;d=d+q|0;b=e+o|0;if(b>>>0<e>>>0){d=d+1|0}e=b^j;j=d^l;l=j;j=da(e,j,21);n=K;f=f^h;h=f;c=c^i;f=da(c,f,17);i=K;d=d+h|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}h=da(c,d,32);o=K;c=c^f;f=d^i;i=da(c,f,13);d=k+l|0;e=e+g|0;if(e>>>0<g>>>0){b=d+1|0}else{b=d}d=f+b|0;k=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);l=K;b=b^n;d=b;e=e^j;j=da(e,d,16);n=K;d=d+o|0;b=e+h|0;if(b>>>0<e>>>0){d=d+1|0}e=b^j;h=d^n;j=h;h=da(e,h,21);n=K;f=f^k;k=f;c=c^i;f=da(c,f,17);i=K;d=d+k|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}k=da(c,d,32);o=K;c=c^f;f=d^i;i=da(c,f,13);d=j+l|0;e=e+g|0;if(e>>>0<g>>>0){b=d+1|0}else{b=d}d=f+b|0;j=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);l=K;b=b^n;d=b;e=e^h;h=da(e,d,16);n=K;d=d+o|0;b=e+k|0;if(b>>>0<e>>>0){d=d+1|0}h=b^h;e=d^n;n=e;o=da(h,e,21);q=K;e=a;f=f^j;k=f;c=c^i;f=da(c,f,17);j=K;d=d+k|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}k=c^f;b=d;i=d^j;j=i;p=e;d=l+n|0;f=g+h|0;if(f>>>0<g>>>0){d=d+1|0}e=da(c,b,32);b=f;g=b^o;h=d^q;l=K;qa(p,e^(b^k)^g,h^(l^(d^i)));c=k^221;i=da(c,j,13);d=d+j|0;j=K;b=b+c|0;if(b>>>0<c>>>0){d=d+1|0}c=d;f=b;k=da(b,d,32);n=K;o=da(g,h,16);q=K;d=h+l|0;b=e+g|0;if(b>>>0<e>>>0){d=d+1|0}e=b^o;g=d^q;h=g;l=da(e,g,21);o=K;c=c^j;f=f^i;j=da(f,c,17);i=K;d=d+c|0;c=b+f|0;if(c>>>0<b>>>0){d=d+1|0}q=da(c,d,32);p=K;c=c^j;f=d^i;j=da(c,f,13);d=h+n|0;e=e+k|0;if(e>>>0<k>>>0){b=d+1|0}else{b=d}d=f+b|0;h=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);k=K;b=b^o;d=b;e=e^l;i=da(e,d,16);l=K;d=d+p|0;b=e+q|0;if(b>>>0<e>>>0){d=d+1|0}e=b^i;i=d^l;l=i;i=da(e,i,21);n=K;f=f^h;h=f;c=c^j;f=da(c,f,17);j=K;d=d+h|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}h=da(c,d,32);o=K;c=c^f;f=d^j;j=da(c,f,13);d=k+l|0;e=e+g|0;if(e>>>0<g>>>0){b=d+1|0}else{b=d}d=f+b|0;k=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);l=K;b=b^n;d=b;e=e^i;i=da(e,d,16);n=K;d=d+o|0;b=e+h|0;if(b>>>0<e>>>0){d=d+1|0}e=b^i;h=d^n;i=h;h=da(e,h,21);n=K;f=f^k;k=f;c=c^j;f=da(c,f,17);j=K;d=d+k|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}k=da(c,d,32);o=K;b=d^j;j=b;q=c^f;p=da(q,b,13);d=i+l|0;b=e+g|0;if(b>>>0<g>>>0){d=d+1|0}g=K;f=d;c=n^d;d=c;e=b^h;h=da(e,d,16);i=K;d=d+o|0;c=e+k|0;if(c>>>0<e>>>0){d=d+1|0}e=d;h=da(c^h,d^i,21);d=f+j|0;f=b+q|0;if(f>>>0<b>>>0){d=d+1|0}g=d^g;d=e+g|0;f=f^p;b=f+c|0;if(b>>>0<c>>>0){d=d+1|0}c=K;f=da(f,g,17)^(b^h);c=K^(c^d);qa(a+8|0,da(b,d,32)^f,K^c);return 0}function zi(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;f=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);g=f^1886610805;e=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);h=e^1936682341;j=f^1852142177;k=e^1819895653;f=m[d+8|0]|m[d+9|0]<<8|(m[d+10|0]<<16|m[d+11|0]<<24);e=f^1852075885;d=m[d+12|0]|m[d+13|0]<<8|(m[d+14|0]<<16|m[d+15|0]<<24);i=d^1685025377;n=f^2037671283;l=d^1952801890;s=c&7;f=(b+c|0)-s|0;if((f|0)!=(b|0)){while(1){o=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);q=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);p=da(e,i,13);d=h+i|0;r=K;e=e+g|0;if(e>>>0<g>>>0){d=d+1|0}g=d;t=da(e,d,32);u=K;d=l^q;h=n^o;n=da(h,d,16);l=K;d=d+k|0;i=h+j|0;if(i>>>0<h>>>0){d=d+1|0}h=i^n;j=d^l;n=j;j=da(h,j,21);l=K;g=g^r;k=g;e=e^p;g=da(e,g,17);p=K;d=d+k|0;e=e+i|0;if(e>>>0<i>>>0){d=d+1|0}k=da(e,d,32);r=K;i=e^g;p=d^p;v=da(i,p,13);d=n+u|0;e=h+t|0;if(e>>>0<h>>>0){d=d+1|0}g=d;d=p+g|0;t=K;p=e+i|0;if(p>>>0<e>>>0){d=d+1|0}i=d;h=da(p,d,32);n=K;d=g^l;e=e^j;l=da(e,d,16);d=d+r|0;j=e+k|0;if(j>>>0<k>>>0){d=d+1|0}e=d;k=e^K;d=k+n|0;n=j^l;l=n;g=h+l|0;if(g>>>0<l>>>0){d=d+1|0}n=da(n,k,21)^g;h=d;l=d^K;d=i^t;k=p^v;p=da(k,d,17);r=K;d=e+d|0;k=k+j|0;if(k>>>0<j>>>0){d=d+1|0}e=k^p;i=d^r;g=g^o;h=h^q;j=da(k,d,32);k=K;b=b+8|0;if((f|0)!=(b|0)){continue}break}b=f}f=c<<24;c=0;a:{switch(s+ -1|0){case 6:f=f|m[b+6|0]<<16;case 5:f=f|m[b+5|0]<<8;case 4:f=f|m[b+4|0];case 3:c=m[b+3|0];d=c>>>8|0;c=c<<24;f=d|f;case 2:d=m[b+2|0];o=d>>>16|0;c=c|d<<16;f=f|o;case 1:d=m[b+1|0];o=d>>>24|0;c=c|d<<8;f=f|o;case 0:c=m[b|0]|c;break;default:break a}}o=da(e,i,13);d=h+i|0;h=K;b=e+g|0;if(b>>>0<g>>>0){d=d+1|0}e=d;q=da(b,d,32);p=K;d=f^l;i=c^n;n=da(i,d,16);l=K;d=d+k|0;g=i+j|0;if(g>>>0<i>>>0){d=d+1|0}i=g^n;j=d^l;k=j;n=da(i,j,21);l=K;e=e^h;h=e;b=b^o;e=da(b,e,17);j=K;d=d+h|0;b=b+g|0;if(b>>>0<g>>>0){d=d+1|0}h=da(b,d,32);o=K;g=b^e;j=d^j;s=da(g,j,13);d=k+p|0;b=i+q|0;if(b>>>0<i>>>0){d=d+1|0}e=d;d=j+e|0;k=K;g=b+g|0;if(g>>>0<b>>>0){d=d+1|0}i=d;j=da(g,d,32);q=K;d=e^l;b=b^n;n=da(b,d,16);l=K;d=d+o|0;b=b+h|0;if(b>>>0<h>>>0){d=d+1|0}e=b^n;h=d^l;n=h;h=da(e,h,21);l=K;i=i^k;k=i;g=g^s;i=da(g,i,17);o=K;d=d+k|0;g=b+g|0;if(g>>>0<b>>>0){d=d+1|0}k=da(g,d,32);p=K;g=g^i;b=d^o;i=da(g,b,13);d=n+q|0;n=b;e=e+j|0;if(e>>>0<j>>>0){b=d+1|0}else{b=d}d=n+(f^b)|0;j=K;f=c^e;c=g+f|0;if(c>>>0<f>>>0){d=d+1|0}f=d;g=da(c,d,32);n=K;b=b^l;d=b;e=e^h;h=da(e,d,16);l=K;d=d+p|0;b=e+(k^255)|0;if(b>>>0<e>>>0){d=d+1|0}e=b^h;h=d^l;k=h;h=da(e,h,21);l=K;f=f^j;j=f;c=c^i;f=da(c,f,17);i=K;d=d+j|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}j=da(c,d,32);o=K;c=c^f;b=d^i;i=da(c,b,13);d=k+n|0;f=b;e=e+g|0;if(e>>>0<g>>>0){b=d+1|0}else{b=d}d=f+b|0;k=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);n=K;b=b^l;d=b;e=e^h;h=da(e,d,16);l=K;d=d+o|0;b=e+j|0;if(b>>>0<e>>>0){d=d+1|0}e=b^h;h=d^l;j=h;h=da(e,h,21);l=K;f=f^k;k=f;c=c^i;f=da(c,f,17);i=K;d=d+k|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}k=da(c,d,32);o=K;c=c^f;f=d^i;i=da(c,f,13);d=j+n|0;e=e+g|0;if(e>>>0<g>>>0){b=d+1|0}else{b=d}d=f+b|0;j=K;c=c+e|0;if(c>>>0<e>>>0){d=d+1|0}f=d;g=da(c,d,32);n=K;b=b^l;d=b;e=e^h;h=da(e,d,16);l=K;d=d+o|0;b=e+k|0;if(b>>>0<e>>>0){d=d+1|0}e=b^h;h=d^l;k=h;h=da(e,h,21);l=K;f=f^j;j=f;c=c^i;f=da(c,f,17);i=K;d=d+j|0;c=b+c|0;if(c>>>0<b>>>0){d=d+1|0}j=da(c,d,32);o=K;b=d^i;i=b;q=c^f;p=da(q,b,13);d=k+n|0;b=e+g|0;if(b>>>0<g>>>0){d=d+1|0}g=K;f=d;c=l^d;d=c;e=b^h;h=da(e,d,16);k=K;d=d+o|0;c=e+j|0;if(c>>>0<e>>>0){d=d+1|0}e=d;h=da(c^h,d^k,21);d=f+i|0;f=b+q|0;if(f>>>0<b>>>0){d=d+1|0}g=d^g;d=e+g|0;f=f^p;b=f+c|0;if(b>>>0<c>>>0){d=d+1|0}c=K;f=da(f,g,17)^(b^h);c=K^(c^d);qa(a,da(b,d,32)^f,K^c);return 0}function Aa(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(!a){break a}d=a+ -8|0;c=l[a+ -4>>2];a=c&-8;f=d+a|0;b:{if(c&1){break b}if(!(c&3)){break a}c=l[d>>2];d=d-c|0;if(d>>>0<o[9185]){break a}a=a+c|0;if(l[9186]!=(d|0)){if(c>>>0<=255){e=l[d+8>>2];c=c>>>3|0;b=l[d+12>>2];if((b|0)==(e|0)){i=36724,j=l[9181]&sl(-2,c),l[i>>2]=j;break b}l[e+12>>2]=b;l[b+8>>2]=e;break b}h=l[d+24>>2];c=l[d+12>>2];c:{if((d|0)!=(c|0)){b=l[d+8>>2];l[b+12>>2]=c;l[c+8>>2]=b;break c}d:{e=d+20|0;b=l[e>>2];if(b){break d}e=d+16|0;b=l[e>>2];if(b){break d}c=0;break c}while(1){g=e;c=b;e=c+20|0;b=l[e>>2];if(b){continue}e=c+16|0;b=l[c+16>>2];if(b){continue}break}l[g>>2]=0}if(!h){break b}e=l[d+28>>2];b=(e<<2)+37028|0;e:{if(l[b>>2]==(d|0)){l[b>>2]=c;if(c){break e}i=36728,j=l[9182]&sl(-2,e),l[i>>2]=j;break b}l[h+(l[h+16>>2]==(d|0)?16:20)>>2]=c;if(!c){break b}}l[c+24>>2]=h;b=l[d+16>>2];if(b){l[c+16>>2]=b;l[b+24>>2]=c}b=l[d+20>>2];if(!b){break b}l[c+20>>2]=b;l[b+24>>2]=c;break b}c=l[f+4>>2];if((c&3)!=3){break b}l[9183]=a;l[f+4>>2]=c&-2;l[d+4>>2]=a|1;l[a+d>>2]=a;return}if(f>>>0<=d>>>0){break a}c=l[f+4>>2];if(!(c&1)){break a}f:{if(!(c&2)){if(l[9187]==(f|0)){l[9187]=d;a=l[9184]+a|0;l[9184]=a;l[d+4>>2]=a|1;if(l[9186]!=(d|0)){break a}l[9183]=0;l[9186]=0;return}if(l[9186]==(f|0)){l[9186]=d;a=l[9183]+a|0;l[9183]=a;l[d+4>>2]=a|1;l[a+d>>2]=a;return}a=(c&-8)+a|0;g:{if(c>>>0<=255){b=l[f+8>>2];c=c>>>3|0;e=l[f+12>>2];if((b|0)==(e|0)){i=36724,j=l[9181]&sl(-2,c),l[i>>2]=j;break g}l[b+12>>2]=e;l[e+8>>2]=b;break g}h=l[f+24>>2];c=l[f+12>>2];h:{if((f|0)!=(c|0)){b=l[f+8>>2];l[b+12>>2]=c;l[c+8>>2]=b;break h}i:{e=f+20|0;b=l[e>>2];if(b){break i}e=f+16|0;b=l[e>>2];if(b){break i}c=0;break h}while(1){g=e;c=b;e=c+20|0;b=l[e>>2];if(b){continue}e=c+16|0;b=l[c+16>>2];if(b){continue}break}l[g>>2]=0}if(!h){break g}e=l[f+28>>2];b=(e<<2)+37028|0;j:{if(l[b>>2]==(f|0)){l[b>>2]=c;if(c){break j}i=36728,j=l[9182]&sl(-2,e),l[i>>2]=j;break g}l[h+(l[h+16>>2]==(f|0)?16:20)>>2]=c;if(!c){break g}}l[c+24>>2]=h;b=l[f+16>>2];if(b){l[c+16>>2]=b;l[b+24>>2]=c}b=l[f+20>>2];if(!b){break g}l[c+20>>2]=b;l[b+24>>2]=c}l[d+4>>2]=a|1;l[a+d>>2]=a;if(l[9186]!=(d|0)){break f}l[9183]=a;return}l[f+4>>2]=c&-2;l[d+4>>2]=a|1;l[a+d>>2]=a}if(a>>>0<=255){a=a>>>3|0;c=(a<<3)+36764|0;b=l[9181];a=1<<a;k:{if(!(b&a)){l[9181]=a|b;a=c;break k}a=l[c+8>>2]}l[c+8>>2]=d;l[a+12>>2]=d;l[d+12>>2]=c;l[d+8>>2]=a;return}l[d+16>>2]=0;l[d+20>>2]=0;f=d;e=a>>>8|0;b=0;l:{if(!e){break l}b=31;if(a>>>0>16777215){break l}c=e;e=e+1048320>>>16&8;b=c<<e;h=b+520192>>>16&4;b=b<<h;g=b+245760>>>16&2;b=(b<<g>>>15|0)-(g|(e|h))|0;b=(b<<1|a>>>b+21&1)+28|0}l[f+28>>2]=b;g=(b<<2)+37028|0;m:{n:{e=l[9182];c=1<<b;o:{if(!(e&c)){l[9182]=c|e;l[g>>2]=d;l[d+24>>2]=g;break o}e=a<<((b|0)==31?0:25-(b>>>1|0)|0);c=l[g>>2];while(1){b=c;if((l[c+4>>2]&-8)==(a|0)){break n}c=e>>>29|0;e=e<<1;g=b+(c&4)|0;c=l[g+16>>2];if(c){continue}break}l[g+16>>2]=d;l[d+24>>2]=b}l[d+12>>2]=d;l[d+8>>2]=d;break m}a=l[b+8>>2];l[a+12>>2]=d;l[b+8>>2]=d;l[d+24>>2]=0;l[d+12>>2]=b;l[d+8>>2]=a}a=l[9189]+ -1|0;l[9189]=a;if(a){break a}d=37180;while(1){a=l[d>>2];d=a+8|0;if(a){continue}break}l[9189]=-1}}function hc(a,b,c,d,e){var f=0,g=0,h=0,i=0,k=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ca=0,da=0,ea=0;E=J+ -64|0;J=E;F=l[a+60>>2];G=l[a+56>>2];A=l[a+52>>2];B=l[a+48>>2];H=l[a+44>>2];I=l[a+40>>2];K=l[a+36>>2];L=l[a+32>>2];M=l[a+28>>2];N=l[a+24>>2];O=l[a+20>>2];P=l[a+16>>2];Q=l[a+12>>2];R=l[a+8>>2];S=l[a+4>>2];T=l[a>>2];while(1){a:{if(!e&d>>>0>63|e>>>0>0){i=c;break a}f=0;g=na(E,0,64);i=g;if(d|e){while(1){j[f+g|0]=m[b+f|0];f=f+1|0;if(!e&d>>>0>f>>>0|e>>>0>0){continue}break}}b=i;U=c}C=20;p=T;q=S;r=R;s=Q;f=P;g=O;c=N;t=M;k=L;n=K;u=I;v=F;w=G;h=A;x=B;z=H;while(1){o=f;f=f+p|0;p=ba(f^x,16);k=p+k|0;x=ba(o^k,12);o=k;k=p;p=f+x|0;k=ba(k^p,8);y=o+k|0;f=ba(x^y,7);o=g;g=g+q|0;q=ba(g^h,16);n=q+n|0;h=ba(o^n,12);o=n;n=q;q=g+h|0;n=ba(n^q,8);D=o+n|0;g=ba(h^D,7);h=c;c=c+r|0;r=ba(c^w,16);u=r+u|0;w=ba(h^u,12);o=w;h=r;r=c+w|0;w=ba(h^r,8);u=w+u|0;c=ba(o^u,7);h=t;t=t+s|0;s=ba(t^v,16);v=s+z|0;h=ba(h^v,12);z=h;o=v;v=s;s=t+h|0;v=ba(v^s,8);h=o+v|0;t=ba(z^h,7);o=u;p=g+p|0;u=ba(p^v,16);x=o+u|0;g=ba(x^g,12);p=g+p|0;v=ba(u^p,8);u=x+v|0;g=ba(g^u,7);q=c+q|0;k=ba(q^k,16);h=k+h|0;c=ba(h^c,12);q=c+q|0;x=ba(k^q,8);z=h+x|0;c=ba(c^z,7);r=t+r|0;k=ba(r^n,16);n=k+y|0;t=ba(n^t,12);r=t+r|0;h=ba(k^r,8);k=n+h|0;t=ba(t^k,7);s=f+s|0;n=ba(s^w,16);y=n+D|0;f=ba(y^f,12);s=f+s|0;w=ba(n^s,8);n=y+w|0;f=ba(f^n,7);C=C+ -2|0;if(C){continue}break}C=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);y=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);D=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);V=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);W=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);X=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);Y=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);Z=m[b+32|0]|m[b+33|0]<<8|(m[b+34|0]<<16|m[b+35|0]<<24);_=m[b+36|0]|m[b+37|0]<<8|(m[b+38|0]<<16|m[b+39|0]<<24);$=m[b+40|0]|m[b+41|0]<<8|(m[b+42|0]<<16|m[b+43|0]<<24);aa=m[b+44|0]|m[b+45|0]<<8|(m[b+46|0]<<16|m[b+47|0]<<24);ca=m[b+48|0]|m[b+49|0]<<8|(m[b+50|0]<<16|m[b+51|0]<<24);da=m[b+52|0]|m[b+53|0]<<8|(m[b+54|0]<<16|m[b+55|0]<<24);ea=m[b+56|0]|m[b+57|0]<<8|(m[b+58|0]<<16|m[b+59|0]<<24);o=m[b+60|0]|m[b+61|0]<<8|(m[b+62|0]<<16|m[b+63|0]<<24);ga(i,p+T^(m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24)));ga(i+4|0,q+S^C);ga(i+8|0,r+R^y);ga(i+12|0,s+Q^D);ga(i+16|0,f+P^V);ga(i+20|0,g+O^W);ga(i+24|0,c+N^X);ga(i+28|0,t+M^Y);ga(i+32|0,k+L^Z);ga(i+36|0,n+K^_);ga(i+40|0,$^u+I);ga(i+44|0,aa^z+H);ga(i+48|0,ca^x+B);ga(i+52|0,da^h+A);ga(i+56|0,ea^w+G);ga(i+60|0,o^v+F);f=B+1|0;A=(f>>>0<B>>>0)+A|0;if(!e&d>>>0<=64|e>>>0<0){if(!(!d|(!e&d>>>0>63|e>>>0>0))){g=0;while(1){j[g+U|0]=m[i+g|0];g=g+1|0;if((d|0)!=(g|0)){continue}break}}l[a+52>>2]=A;l[a+48>>2]=f;J=E- -64|0}else{b=b- -64|0;c=i- -64|0;e=e+ -1|0;d=d+ -64|0;if(d>>>0<4294967232){e=e+1|0}B=f;continue}break}}function fg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=a+b|0;a:{b:{c=l[a+4>>2];if(c&1){break b}if(!(c&3)){break a}c=l[a>>2];b=c+b|0;a=a-c|0;if((a|0)!=l[9186]){if(c>>>0<=255){e=c>>>3|0;c=l[a+8>>2];d=l[a+12>>2];if((d|0)==(c|0)){i=36724,j=l[9181]&sl(-2,e),l[i>>2]=j;break b}l[c+12>>2]=d;l[d+8>>2]=c;break b}h=l[a+24>>2];c=l[a+12>>2];c:{if((c|0)!=(a|0)){d=l[a+8>>2];l[d+12>>2]=c;l[c+8>>2]=d;break c}d:{d=a+20|0;e=l[d>>2];if(e){break d}d=a+16|0;e=l[d>>2];if(e){break d}c=0;break c}while(1){g=d;c=e;d=c+20|0;e=l[d>>2];if(e){continue}d=c+16|0;e=l[c+16>>2];if(e){continue}break}l[g>>2]=0}if(!h){break b}d=l[a+28>>2];e=(d<<2)+37028|0;e:{if(l[e>>2]==(a|0)){l[e>>2]=c;if(c){break e}i=36728,j=l[9182]&sl(-2,d),l[i>>2]=j;break b}l[h+(l[h+16>>2]==(a|0)?16:20)>>2]=c;if(!c){break b}}l[c+24>>2]=h;d=l[a+16>>2];if(d){l[c+16>>2]=d;l[d+24>>2]=c}d=l[a+20>>2];if(!d){break b}l[c+20>>2]=d;l[d+24>>2]=c;break b}c=l[f+4>>2];if((c&3)!=3){break b}l[9183]=b;l[f+4>>2]=c&-2;l[a+4>>2]=b|1;l[f>>2]=b;return}c=l[f+4>>2];f:{if(!(c&2)){if(l[9187]==(f|0)){l[9187]=a;b=l[9184]+b|0;l[9184]=b;l[a+4>>2]=b|1;if(l[9186]!=(a|0)){break a}l[9183]=0;l[9186]=0;return}if(l[9186]==(f|0)){l[9186]=a;b=l[9183]+b|0;l[9183]=b;l[a+4>>2]=b|1;l[a+b>>2]=b;return}b=(c&-8)+b|0;g:{if(c>>>0<=255){e=c>>>3|0;c=l[f+8>>2];d=l[f+12>>2];if((d|0)==(c|0)){i=36724,j=l[9181]&sl(-2,e),l[i>>2]=j;break g}l[c+12>>2]=d;l[d+8>>2]=c;break g}h=l[f+24>>2];c=l[f+12>>2];h:{if((f|0)!=(c|0)){d=l[f+8>>2];l[d+12>>2]=c;l[c+8>>2]=d;break h}i:{d=f+20|0;e=l[d>>2];if(e){break i}d=f+16|0;e=l[d>>2];if(e){break i}c=0;break h}while(1){g=d;c=e;d=c+20|0;e=l[d>>2];if(e){continue}d=c+16|0;e=l[c+16>>2];if(e){continue}break}l[g>>2]=0}if(!h){break g}d=l[f+28>>2];e=(d<<2)+37028|0;j:{if(l[e>>2]==(f|0)){l[e>>2]=c;if(c){break j}i=36728,j=l[9182]&sl(-2,d),l[i>>2]=j;break g}l[h+(l[h+16>>2]==(f|0)?16:20)>>2]=c;if(!c){break g}}l[c+24>>2]=h;d=l[f+16>>2];if(d){l[c+16>>2]=d;l[d+24>>2]=c}d=l[f+20>>2];if(!d){break g}l[c+20>>2]=d;l[d+24>>2]=c}l[a+4>>2]=b|1;l[a+b>>2]=b;if(l[9186]!=(a|0)){break f}l[9183]=b;return}l[f+4>>2]=c&-2;l[a+4>>2]=b|1;l[a+b>>2]=b}if(b>>>0<=255){c=b>>>3|0;b=(c<<3)+36764|0;d=l[9181];c=1<<c;k:{if(!(d&c)){l[9181]=c|d;c=b;break k}c=l[b+8>>2]}l[b+8>>2]=a;l[c+12>>2]=a;l[a+12>>2]=b;l[a+8>>2]=c;return}l[a+16>>2]=0;l[a+20>>2]=0;d=a;e=b>>>8|0;c=0;l:{if(!e){break l}c=31;if(b>>>0>16777215){break l}g=e+1048320>>>16&8;e=e<<g;c=e+520192>>>16&4;f=e<<c;e=f+245760>>>16&2;c=(f<<e>>>15|0)-(e|(c|g))|0;c=(c<<1|b>>>c+21&1)+28|0}l[d+28>>2]=c;e=(c<<2)+37028|0;m:{d=l[9182];g=1<<c;n:{if(!(d&g)){l[9182]=d|g;l[e>>2]=a;break n}d=b<<((c|0)==31?0:25-(c>>>1|0)|0);c=l[e>>2];while(1){e=c;if((l[c+4>>2]&-8)==(b|0)){break m}c=d>>>29|0;d=d<<1;g=e+(c&4)|0;c=l[g+16>>2];if(c){continue}break}l[g+16>>2]=a}l[a+24>>2]=e;l[a+12>>2]=a;l[a+8>>2]=a;return}b=l[e+8>>2];l[b+12>>2]=a;l[e+8>>2]=a;l[a+24>>2]=0;l[a+12>>2]=e;l[a+8>>2]=b}}function qc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0;f=l[a+36>>2];h=l[a+32>>2];k=l[a+28>>2];g=l[a+24>>2];j=l[a+20>>2];if(!d&c>>>0>=16|d>>>0>0){A=!m[a+80|0]<<24;p=l[a+4>>2];B=r(p,5);v=l[a+8>>2];z=r(v,5);x=l[a+12>>2];y=r(x,5);e=l[a+16>>2];w=r(e,5);C=e;q=l[a>>2];while(1){i=((m[b+3|0]|m[b+4|0]<<8|(m[b+5|0]<<16|m[b+6|0]<<24))>>>2&67108863)+g|0;e=ql(i,0,x,0);g=K;j=((m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24))&67108863)+j|0;o=ql(j,0,C,0);e=o+e|0;g=K+g|0;g=e>>>0<o>>>0?g+1|0:g;s=((m[b+6|0]|m[b+7|0]<<8|(m[b+8|0]<<16|m[b+9|0]<<24))>>>4&67108863)+k|0;o=ql(s,0,v,0);k=o+e|0;e=K+g|0;t=((m[b+9|0]|m[b+10|0]<<8|(m[b+11|0]<<16|m[b+12|0]<<24))>>>6|0)+h|0;h=ql(t,0,p,0);g=h+k|0;e=K+(k>>>0<o>>>0?e+1|0:e)|0;e=g>>>0<h>>>0?e+1|0:e;u=((m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24))>>>8|A)+f|0;f=ql(u,0,q,0);g=f+g|0;e=K+e|0;D=g;k=g>>>0<f>>>0?e+1|0:e;e=ql(i,0,v,0);g=K;h=ql(j,0,x,0);e=h+e|0;f=K+g|0;f=e>>>0<h>>>0?f+1|0:f;h=ql(s,0,p,0);e=h+e|0;g=K+f|0;g=e>>>0<h>>>0?g+1|0:g;h=ql(t,0,q,0);f=h+e|0;e=K+g|0;e=f>>>0<h>>>0?e+1|0:e;g=f;f=ql(u,0,w,0);g=g+f|0;e=K+e|0;E=g;o=g>>>0<f>>>0?e+1|0:e;e=ql(i,0,p,0);f=K;h=ql(j,0,v,0);g=h+e|0;e=K+f|0;e=g>>>0<h>>>0?e+1|0:e;h=ql(s,0,q,0);g=h+g|0;f=K+e|0;f=g>>>0<h>>>0?f+1|0:f;h=ql(t,0,w,0);e=h+g|0;g=K+f|0;g=e>>>0<h>>>0?g+1|0:g;h=ql(u,0,y,0);f=h+e|0;e=K+g|0;F=f;h=f>>>0<h>>>0?e+1|0:e;e=ql(i,0,q,0);f=K;n=ql(j,0,p,0);g=n+e|0;e=K+f|0;e=g>>>0<n>>>0?e+1|0:e;f=ql(s,0,w,0);g=f+g|0;e=K+e|0;e=g>>>0<f>>>0?e+1|0:e;n=ql(t,0,y,0);g=n+g|0;f=K+e|0;f=g>>>0<n>>>0?f+1|0:f;n=ql(u,0,z,0);e=n+g|0;g=K+f|0;g=e>>>0<n>>>0?g+1|0:g;n=e;e=ql(i,0,w,0);i=K;j=ql(j,0,q,0);f=j+e|0;e=K+i|0;e=f>>>0<j>>>0?e+1|0:e;i=ql(s,0,y,0);f=i+f|0;e=K+e|0;e=f>>>0<i>>>0?e+1|0:e;i=ql(t,0,z,0);f=i+f|0;e=K+e|0;e=f>>>0<i>>>0?e+1|0:e;j=ql(u,0,B,0);i=j+f|0;f=K+e|0;f=i>>>0<j>>>0?f+1|0:f;e=i;e=(f&67108863)<<6|e>>>26;f=e+n|0;if(f>>>0<e>>>0){g=g+1|0}j=f;e=h;g=(g&67108863)<<6|f>>>26;f=g+F|0;if(f>>>0<g>>>0){e=e+1|0}h=f;f=o;e=(e&67108863)<<6|h>>>26;g=e+E|0;if(g>>>0<e>>>0){f=f+1|0}e=g;g=k;f=(f&67108863)<<6|e>>>26;k=f+D|0;if(k>>>0<f>>>0){g=g+1|0}f=k;i=r((g&67108863)<<6|f>>>26,5)+(i&67108863)|0;g=(j&67108863)+(i>>>26|0)|0;k=h&67108863;h=e&67108863;f=f&67108863;j=i&67108863;b=b+16|0;e=d+ -1|0;c=c+ -16|0;if(c>>>0<4294967280){e=e+1|0}d=e;if(!e&c>>>0>15|e>>>0>0){continue}break}}l[a+20>>2]=j;l[a+36>>2]=f;l[a+32>>2]=h;l[a+28>>2]=k;l[a+24>>2]=g}function yc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,k=0,l=0,n=0;l=J-160|0;J=l;Fb(b,c,32,0);j[b|0]=m[b|0]&248;j[b+31|0]=m[b+31|0]&63|64;Nb(l,b);cb(a,l);f=c;g=m[f+8|0]|m[f+9|0]<<8|(m[f+10|0]<<16|m[f+11|0]<<24);e=m[f+12|0]|m[f+13|0]<<8|(m[f+14|0]<<16|m[f+15|0]<<24);h=m[f+16|0]|m[f+17|0]<<8|(m[f+18|0]<<16|m[f+19|0]<<24);i=m[f+20|0]|m[f+21|0]<<8|(m[f+22|0]<<16|m[f+23|0]<<24);k=m[f|0]|m[f+1|0]<<8|(m[f+2|0]<<16|m[f+3|0]<<24);c=m[f+4|0]|m[f+5|0]<<8|(m[f+6|0]<<16|m[f+7|0]<<24);d=b;n=m[f+28|0]|m[f+29|0]<<8|(m[f+30|0]<<16|m[f+31|0]<<24);b=m[f+24|0]|m[f+25|0]<<8|(m[f+26|0]<<16|m[f+27|0]<<24);j[d+24|0]=b;j[d+25|0]=b>>>8;j[d+26|0]=b>>>16;j[d+27|0]=b>>>24;j[d+28|0]=n;j[d+29|0]=n>>>8;j[d+30|0]=n>>>16;j[d+31|0]=n>>>24;j[d+16|0]=h;j[d+17|0]=h>>>8;j[d+18|0]=h>>>16;j[d+19|0]=h>>>24;j[d+20|0]=i;j[d+21|0]=i>>>8;j[d+22|0]=i>>>16;j[d+23|0]=i>>>24;j[d+8|0]=g;j[d+9|0]=g>>>8;j[d+10|0]=g>>>16;j[d+11|0]=g>>>24;j[d+12|0]=e;j[d+13|0]=e>>>8;j[d+14|0]=e>>>16;j[d+15|0]=e>>>24;j[d|0]=k;j[d+1|0]=k>>>8;j[d+2|0]=k>>>16;j[d+3|0]=k>>>24;j[d+4|0]=c;j[d+5|0]=c>>>8;j[d+6|0]=c>>>16;j[d+7|0]=c>>>24;e=a;h=m[e+8|0]|m[e+9|0]<<8|(m[e+10|0]<<16|m[e+11|0]<<24);i=m[e+12|0]|m[e+13|0]<<8|(m[e+14|0]<<16|m[e+15|0]<<24);k=m[e+16|0]|m[e+17|0]<<8|(m[e+18|0]<<16|m[e+19|0]<<24);c=m[e+20|0]|m[e+21|0]<<8|(m[e+22|0]<<16|m[e+23|0]<<24);b=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);a=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);g=m[e+28|0]|m[e+29|0]<<8|(m[e+30|0]<<16|m[e+31|0]<<24);e=m[e+24|0]|m[e+25|0]<<8|(m[e+26|0]<<16|m[e+27|0]<<24);j[d+56|0]=e;j[d+57|0]=e>>>8;j[d+58|0]=e>>>16;j[d+59|0]=e>>>24;j[d+60|0]=g;j[d+61|0]=g>>>8;j[d+62|0]=g>>>16;j[d+63|0]=g>>>24;j[d+48|0]=k;j[d+49|0]=k>>>8;j[d+50|0]=k>>>16;j[d+51|0]=k>>>24;j[d+52|0]=c;j[d+53|0]=c>>>8;j[d+54|0]=c>>>16;j[d+55|0]=c>>>24;j[d+40|0]=h;j[d+41|0]=h>>>8;j[d+42|0]=h>>>16;j[d+43|0]=h>>>24;j[d+44|0]=i;j[d+45|0]=i>>>8;j[d+46|0]=i>>>16;j[d+47|0]=i>>>24;j[d+32|0]=b;j[d+33|0]=b>>>8;j[d+34|0]=b>>>16;j[d+35|0]=b>>>24;j[d+36|0]=a;j[d+37|0]=a>>>8;j[d+38|0]=a>>>16;j[d+39|0]=a>>>24;J=l+160|0;return 0}function nd(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0;D=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);E=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);F=m[c+8|0]|m[c+9|0]<<8|(m[c+10|0]<<16|m[c+11|0]<<24);G=m[c+12|0]|m[c+13|0]<<8|(m[c+14|0]<<16|m[c+15|0]<<24);H=m[c+16|0]|m[c+17|0]<<8|(m[c+18|0]<<16|m[c+19|0]<<24);I=m[c+24|0]|m[c+25|0]<<8|(m[c+26|0]<<16|m[c+27|0]<<24);J=m[c+28|0]|m[c+29|0]<<8|(m[c+30|0]<<16|m[c+31|0]<<24);K=m[c+20|0]|m[c+21|0]<<8|(m[c+22|0]<<16|m[c+23|0]<<24);c=K;f=I;k=J;a:{if(!d){w=857760878;x=2036477234;y=1634760805;z=1797285236;break a}y=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);w=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);x=m[d+8|0]|m[d+9|0]<<8|(m[d+10|0]<<16|m[d+11|0]<<24);z=m[d+12|0]|m[d+13|0]<<8|(m[d+14|0]<<16|m[d+15|0]<<24)}d=z;o=H;r=x;A=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);l=A;L=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);n=L;M=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);g=M;N=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);b=N;s=w;p=G;h=F;i=E;q=D;j=y;if((e|0)>=1){l=A;while(1){t=ba(c+j|0,7)^p;B=ba(t+j|0,9)^n;O=ba(t+B|0,13)^c;n=ba(B+O|0,18);u=ba(s+q|0,7)^l;C=ba(u+s|0,9)^f;f=ba(u+C|0,13)^q;p=ba(C+f|0,18);v=ba(b+r|0,7)^k;i=ba(v+r|0,9)^i;b=ba(i+v|0,13)^b;l=ba(i+b|0,18);h=ba(d+o|0,7)^h;g=ba(h+d|0,9)^g;k=ba(g+h|0,13)^o;c=ba(g+k|0,18);j=j^n;q=ba(j+h|0,7)^f;i=ba(q+j|0,9)^i;h=ba(i+q|0,13)^h;j=ba(h+i|0,18)^j;f=s^p;b=ba(f+t|0,7)^b;g=ba(b+f|0,9)^g;p=ba(b+g|0,13)^t;s=ba(g+p|0,18)^f;f=l^r;o=ba(f+u|0,7)^k;n=ba(o+f|0,9)^B;l=ba(n+o|0,13)^u;r=ba(l+n|0,18)^f;d=c^d;c=ba(d+v|0,7)^O;f=ba(c+d|0,9)^C;k=ba(c+f|0,13)^v;d=ba(f+k|0,18)^d;P=P+2|0;if((P|0)<(e|0)){continue}break}}ga(a,j+y|0);ga(a+4|0,q+D|0);ga(a+8|0,i+E|0);ga(a+12|0,h+F|0);ga(a+16|0,p+G|0);ga(a+20|0,s+w|0);ga(a+24|0,b+N|0);ga(a+28|0,g+M|0);ga(a+32|0,n+L|0);ga(a+36|0,l+A|0);ga(a+40|0,r+x|0);ga(a+44|0,o+H|0);ga(a+48|0,c+K|0);ga(a+52|0,f+I|0);ga(a+56|0,k+J|0);ga(a+60|0,d+z|0)}function Wk(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;c=b;d=l[c+4>>2];n=d;k=d>>31;d=l[c+8>>2];o=d;t=d>>31;d=l[c+12>>2];j=d;m=d>>31;d=l[c+16>>2];p=d;u=d>>31;d=l[c+20>>2];i=d;h=d>>31;d=l[c+24>>2];q=d;v=d>>31;d=l[c>>2];w=d;x=d>>31;f=a;c=l[c+36>>2];d=ql(c,c>>31,121666,0);g=d;c=K;d=d+16777216|0;if(d>>>0<16777216){c=c+1|0}s=d;d=c;y=g-(s&-33554432)|0;c=l[b+32>>2];e=ql(c,c>>31,121666,0);z=K;b=l[b+28>>2];g=ql(b,b>>31,121666,0);c=K;r=e;b=g+16777216|0;if(b>>>0<16777216){c=c+1|0}A=b;e=b;b=c>>25;e=(c&33554431)<<7|e>>>25;c=r+e|0;b=b+z|0;b=c>>>0<e>>>0?b+1|0:b;e=c;r=f;c=b;b=e+33554432|0;if(b>>>0<33554432){c=c+1|0}f=((c&67108863)<<6|b>>>26)+y|0;l[r+36>>2]=f;b=b&-67108864;l[a+32>>2]=e-b;f=g-(A&-33554432)|0;c=ql(q,v,121666,0);q=K;g=ql(i,h,121666,0);b=K;e=c;c=g+16777216|0;if(c>>>0<16777216){b=b+1|0}i=c;h=c;c=b>>25;h=(b&33554431)<<7|h>>>25;b=e+h|0;c=c+q|0;c=b>>>0<h>>>0?c+1|0:c;e=b+33554432|0;if(e>>>0<33554432){c=c+1|0}f=f+((c&67108863)<<6|e>>>26)|0;l[a+28>>2]=f;c=e&-67108864;l[a+24>>2]=b-c;f=a;i=g-(i&-33554432)|0;b=ql(p,u,121666,0);p=K;g=ql(j,m,121666,0);c=K;e=b;b=g+16777216|0;if(b>>>0<16777216){c=c+1|0}j=b;m=(c&33554431)<<7|b>>>25;e=e+m|0;c=(c>>25)+p|0;c=e>>>0<m>>>0?c+1|0:c;h=f;b=c;c=e+33554432|0;if(c>>>0<33554432){b=b+1|0}f=((b&67108863)<<6|c>>>26)+i|0;l[h+20>>2]=f;b=c&-67108864;l[a+16>>2]=e-b;f=a;j=g-(j&-33554432)|0;c=ql(o,t,121666,0);o=K;g=ql(n,k,121666,0);b=K;e=c;c=g+16777216|0;if(c>>>0<16777216){b=b+1|0}n=c;k=(b&33554431)<<7|c>>>25;e=e+k|0;b=(b>>25)+o|0;b=e>>>0<k>>>0?b+1|0:b;i=f;c=b;b=e+33554432|0;if(b>>>0<33554432){c=c+1|0}f=((c&67108863)<<6|b>>>26)+j|0;l[i+12>>2]=f;b=b&-67108864;l[a+8>>2]=e-b;b=ql((d&33554431)<<7|s>>>25,d>>25,19,0);c=K;f=g-(n&-33554432)|0;d=ql(w,x,121666,0);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=b+33554432|0;if(d>>>0<33554432){c=c+1|0}g=f+((c&67108863)<<6|d>>>26)|0;l[a+4>>2]=g;c=a;a=d&-67108864;l[c>>2]=b-a}function Uf(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;c=b;d=l[c+4>>2];n=d;k=d>>31;d=l[c+8>>2];o=d;t=d>>31;d=l[c+12>>2];j=d;m=d>>31;d=l[c+16>>2];p=d;u=d>>31;d=l[c+20>>2];i=d;h=d>>31;d=l[c+24>>2];q=d;v=d>>31;d=l[c>>2];w=d;x=d>>31;f=a;c=l[c+36>>2];d=ql(c,c>>31,486662,0);g=d;c=K;d=d+16777216|0;if(d>>>0<16777216){c=c+1|0}s=d;d=c;y=g-(s&-33554432)|0;c=l[b+32>>2];e=ql(c,c>>31,486662,0);z=K;b=l[b+28>>2];g=ql(b,b>>31,486662,0);c=K;r=e;b=g+16777216|0;if(b>>>0<16777216){c=c+1|0}A=b;e=b;b=c>>25;e=(c&33554431)<<7|e>>>25;c=r+e|0;b=b+z|0;b=c>>>0<e>>>0?b+1|0:b;e=c;r=f;c=b;b=e+33554432|0;if(b>>>0<33554432){c=c+1|0}f=((c&67108863)<<6|b>>>26)+y|0;l[r+36>>2]=f;b=b&-67108864;l[a+32>>2]=e-b;f=g-(A&-33554432)|0;c=ql(q,v,486662,0);q=K;g=ql(i,h,486662,0);b=K;e=c;c=g+16777216|0;if(c>>>0<16777216){b=b+1|0}i=c;h=c;c=b>>25;h=(b&33554431)<<7|h>>>25;b=e+h|0;c=c+q|0;c=b>>>0<h>>>0?c+1|0:c;e=b+33554432|0;if(e>>>0<33554432){c=c+1|0}f=f+((c&67108863)<<6|e>>>26)|0;l[a+28>>2]=f;c=e&-67108864;l[a+24>>2]=b-c;f=a;i=g-(i&-33554432)|0;b=ql(p,u,486662,0);p=K;g=ql(j,m,486662,0);c=K;e=b;b=g+16777216|0;if(b>>>0<16777216){c=c+1|0}j=b;m=(c&33554431)<<7|b>>>25;e=e+m|0;c=(c>>25)+p|0;c=e>>>0<m>>>0?c+1|0:c;h=f;b=c;c=e+33554432|0;if(c>>>0<33554432){b=b+1|0}f=((b&67108863)<<6|c>>>26)+i|0;l[h+20>>2]=f;b=c&-67108864;l[a+16>>2]=e-b;f=a;j=g-(j&-33554432)|0;c=ql(o,t,486662,0);o=K;g=ql(n,k,486662,0);b=K;e=c;c=g+16777216|0;if(c>>>0<16777216){b=b+1|0}n=c;k=(b&33554431)<<7|c>>>25;e=e+k|0;b=(b>>25)+o|0;b=e>>>0<k>>>0?b+1|0:b;i=f;c=b;b=e+33554432|0;if(b>>>0<33554432){c=c+1|0}f=((c&67108863)<<6|b>>>26)+j|0;l[i+12>>2]=f;b=b&-67108864;l[a+8>>2]=e-b;b=ql((d&33554431)<<7|s>>>25,d>>25,19,0);c=K;f=g-(n&-33554432)|0;d=ql(w,x,486662,0);b=d+b|0;c=K+c|0;c=b>>>0<d>>>0?c+1|0:c;d=b+33554432|0;if(d>>>0<33554432){c=c+1|0}g=f+((c&67108863)<<6|d>>>26)|0;l[a+4>>2]=g;c=a;a=d&-67108864;l[c>>2]=b-a}function Dc(a,b,c){var d=0,e=0,f=0,g=0;e=J+ -64|0;J=e;a:{if(!(!c|c>>>0>=65)){d=-1;if(!(m[a+80|0]|m[a+81|0]<<8|(m[a+82|0]<<16|m[a+83|0]<<24)|(m[a+84|0]|m[a+85|0]<<8|(m[a+86|0]<<16|m[a+87|0]<<24)))){f=a;d=m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24);if(d>>>0>=129){Gc(a,128);g=a+96|0;Yc(a,g);d=(m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24))+ -128|0;j[a+352|0]=d;j[a+353|0]=d>>>8;j[a+354|0]=d>>>16;j[a+355|0]=d>>>24;if(d>>>0>=129){break a}pa(g,a+224|0,d);d=m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24)}Gc(f,d);if(m[a+356|0]){j[a+88|0]=-1;j[a+89|0]=16777215;j[a+90|0]=65535;j[a+91|0]=255;j[a+92|0]=-1;j[a+93|0]=16777215;j[a+94|0]=65535;j[a+95|0]=255}j[a+80|0]=-1;j[a+81|0]=16777215;j[a+82|0]=65535;j[a+83|0]=255;j[a+84|0]=-1;j[a+85|0]=16777215;j[a+86|0]=65535;j[a+87|0]=255;d=a+96|0;f=m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24);na(d+f|0,0,256-f|0);Yc(a,d);qa(e,m[a|0]|m[a+1|0]<<8|(m[a+2|0]<<16|m[a+3|0]<<24),m[a+4|0]|m[a+5|0]<<8|(m[a+6|0]<<16|m[a+7|0]<<24));qa(e|8,m[a+8|0]|m[a+9|0]<<8|(m[a+10|0]<<16|m[a+11|0]<<24),m[a+12|0]|m[a+13|0]<<8|(m[a+14|0]<<16|m[a+15|0]<<24));qa(e+16|0,m[a+16|0]|m[a+17|0]<<8|(m[a+18|0]<<16|m[a+19|0]<<24),m[a+20|0]|m[a+21|0]<<8|(m[a+22|0]<<16|m[a+23|0]<<24));qa(e+24|0,m[a+24|0]|m[a+25|0]<<8|(m[a+26|0]<<16|m[a+27|0]<<24),m[a+28|0]|m[a+29|0]<<8|(m[a+30|0]<<16|m[a+31|0]<<24));qa(e+32|0,m[a+32|0]|m[a+33|0]<<8|(m[a+34|0]<<16|m[a+35|0]<<24),m[a+36|0]|m[a+37|0]<<8|(m[a+38|0]<<16|m[a+39|0]<<24));qa(e+40|0,m[a+40|0]|m[a+41|0]<<8|(m[a+42|0]<<16|m[a+43|0]<<24),m[a+44|0]|m[a+45|0]<<8|(m[a+46|0]<<16|m[a+47|0]<<24));qa(e+48|0,m[a+48|0]|m[a+49|0]<<8|(m[a+50|0]<<16|m[a+51|0]<<24),m[a+52|0]|m[a+53|0]<<8|(m[a+54|0]<<16|m[a+55|0]<<24));qa(e+56|0,m[a+56|0]|m[a+57|0]<<8|(m[a+58|0]<<16|m[a+59|0]<<24),m[a+60|0]|m[a+61|0]<<8|(m[a+62|0]<<16|m[a+63|0]<<24));pa(b,e,c);ea(a,64);ea(d,256);d=0}J=e- -64|0;return d}ra();A()}D(1857,1889,306,1934);A()}function Va(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;q=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);n=ia(b+4|0);c=K;j=ia(b+7|0);e=K;k=ia(b+10|0);d=K;r=ia(b+13|0);i=K;f=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);s=ia(b+20|0);o=K;t=ia(b+23|0);u=K;v=ia(b+26|0);w=K;x=ia(b+29|0);h=a;b=d<<3|k>>>29;d=k<<3;p=d;d=d+16777216|0;if(d>>>0<16777216){b=b+1|0}k=d;d=b;b=e<<5|j>>>27;g=j<<5;e=b;j=n;b=c<<6|j>>>26;j=j<<6;y=h;h=g;c=b;b=j+16777216|0;if(b>>>0<16777216){c=c+1|0}n=b;g=b;b=c>>25;g=(c&33554431)<<7|g>>>25;c=h+g|0;b=b+e|0;b=c>>>0<g>>>0?b+1|0:b;e=c+33554432|0;if(e>>>0<33554432){b=b+1|0}h=(p-(k&-33554432)|0)+((b&67108863)<<6|e>>>26)|0;l[y+12>>2]=h;b=e&-67108864;l[a+8>>2]=c-b;c=a;e=f;b=0;f=e+16777216|0;if(f>>>0<16777216){b=1}h=f;f=b;p=e-(h&-33554432)|0;e=r;b=i<<2|e>>>30;i=e<<2;e=b;g=i;b=d>>25;i=(d&33554431)<<7|k>>>25;d=g+i|0;b=b+e|0;b=d>>>0<i>>>0?b+1|0:b;g=c;c=b;b=d+33554432|0;if(b>>>0<33554432){c=c+1|0}e=((c&67108863)<<6|b>>>26)+p|0;l[g+20>>2]=e;b=b&-67108864;l[a+16>>2]=d-b;d=a;c=s;b=o<<7|c>>>25;g=c<<7;c=f>>25;e=(f&33554431)<<7|h>>>25;f=g+e|0;b=b+c|0;b=f>>>0<e>>>0?b+1|0:b;c=f;f=c;c=c+33554432|0;if(c>>>0<33554432){b=b+1|0}e=c;c=b;b=e&-67108864;l[d+24>>2]=f-b;f=a;d=t;b=u<<5|d>>>27;d=d<<5;o=d;d=d+16777216|0;if(d>>>0<16777216){b=b+1|0}i=d;d=b;c=(o-(i&-33554432)|0)+((c&67108863)<<6|e>>>26)|0;l[f+28>>2]=c;c=v;b=w<<4|c>>>28;e=c<<4;c=b;h=e;b=d>>25;e=(d&33554431)<<7|i>>>25;d=h+e|0;b=b+c|0;b=d>>>0<e>>>0?b+1|0:b;c=d;d=c;c=c+33554432|0;if(c>>>0<33554432){b=b+1|0}e=c;c=b;b=e&-67108864;l[f+32>>2]=d-b;b=0;f=x;f=f<<2&33554428;d=f;f=f+16777216|0;if(f>>>0<16777216){b=b+1|0}d=(d-(f&33554432)|0)+((c&67108863)<<6|e>>>26)|0;l[a+36>>2]=d;f=ql((b&33554431)<<7|f>>>25,b>>>25|0,19,0);c=f+q|0;b=K;b=c>>>0<f>>>0?b+1|0:b;d=c+33554432|0;if(d>>>0<33554432){b=b+1|0}f=(j-(n&-33554432)|0)+((b&67108863)<<6|d>>>26)|0;l[a+4>>2]=f;b=a;a=d&-67108864;l[b>>2]=c-a}function Pa(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;a:{if(!d){e=2036477234;l=857760878;n=1634760805;f=1797285236;break a}n=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);l=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);e=m[d+8|0]|m[d+9|0]<<8|(m[d+10|0]<<16|m[d+11|0]<<24);f=m[d+12|0]|m[d+13|0]<<8|(m[d+14|0]<<16|m[d+15|0]<<24)}d=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);g=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);h=m[c+8|0]|m[c+9|0]<<8|(m[c+10|0]<<16|m[c+11|0]<<24);j=m[c+12|0]|m[c+13|0]<<8|(m[c+14|0]<<16|m[c+15|0]<<24);p=m[c+16|0]|m[c+17|0]<<8|(m[c+18|0]<<16|m[c+19|0]<<24);q=m[c+20|0]|m[c+21|0]<<8|(m[c+22|0]<<16|m[c+23|0]<<24);s=m[c+24|0]|m[c+25|0]<<8|(m[c+26|0]<<16|m[c+27|0]<<24);t=m[c+28|0]|m[c+29|0]<<8|(m[c+30|0]<<16|m[c+31|0]<<24);c=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);o=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);i=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);b=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);while(1){k=d;r=c;c=d+n|0;d=ba(r^c,16);n=d+p|0;p=ba(k^n,12);k=p;r=n;n=c+p|0;p=ba(n^d,8);u=r+p|0;d=ba(k^u,7);k=g;c=g+l|0;l=ba(c^o,16);g=l+q|0;o=ba(k^g,12);k=o;r=l;l=c+o|0;o=ba(r^l,8);q=o+g|0;c=ba(k^q,7);k=h;e=e+h|0;g=ba(e^i,16);h=g+s|0;i=ba(k^h,12);k=i;i=e+i|0;r=ba(g^i,8);g=r+h|0;e=ba(k^g,7);h=b;b=f+j|0;f=ba(h^b,16);h=f+t|0;j=ba(h^j,12);v=b+j|0;b=ba(f^v,8);h=b+h|0;f=ba(j^h,7);k=g;g=b;b=c+n|0;g=ba(g^b,16);j=k+g|0;c=ba(j^c,12);n=b+c|0;b=ba(g^n,8);s=j+b|0;g=ba(c^s,7);k=h;c=e+l|0;h=ba(c^p,16);j=k+h|0;e=ba(j^e,12);l=c+e|0;c=ba(h^l,8);t=j+c|0;h=ba(e^t,7);e=f+i|0;j=ba(e^o,16);i=j+u|0;f=ba(i^f,12);e=e+f|0;o=ba(j^e,8);p=i+o|0;j=ba(f^p,7);f=d+v|0;i=ba(f^r,16);q=i+q|0;d=ba(q^d,12);f=d+f|0;i=ba(i^f,8);q=q+i|0;d=ba(d^q,7);w=w+1|0;if((w|0)!=10){continue}break}ga(a,n);ga(a+4|0,l);ga(a+8|0,e);ga(a+12|0,f);ga(a+16|0,c);ga(a+20|0,o);ga(a+24|0,i);ga(a+28|0,b);return 0}function nj(a,b,c,d){var e=0,f=0,g=0;f=J-16|0;J=f;e=-31;a:{b:{c:{d:{switch(d+ -1|0){case 1:if(b>>>0<13){break b}d=m[36413]|m[36414]<<8|(m[36415]<<16|m[36416]<<24);e=m[36409]|m[36410]<<8|(m[36411]<<16|m[36412]<<24);j[a|0]=e;j[a+1|0]=e>>>8;j[a+2|0]=e>>>16;j[a+3|0]=e>>>24;j[a+4|0]=d;j[a+5|0]=d>>>8;j[a+6|0]=d>>>16;j[a+7|0]=d>>>24;d=m[36418]|m[36419]<<8|(m[36420]<<16|m[36421]<<24);e=m[36414]|m[36415]<<8|(m[36416]<<16|m[36417]<<24);j[a+5|0]=e;j[a+6|0]=e>>>8;j[a+7|0]=e>>>16;j[a+8|0]=e>>>24;j[a+9|0]=d;j[a+10|0]=d>>>8;j[a+11|0]=d>>>16;j[a+12|0]=d>>>24;g=-12;d=12;break c;case 0:break d;default:break a}}if(b>>>0<12){break b}d=m[36426]|m[36427]<<8|(m[36428]<<16|m[36429]<<24);e=m[36422]|m[36423]<<8|(m[36424]<<16|m[36425]<<24);j[a|0]=e;j[a+1|0]=e>>>8;j[a+2|0]=e>>>16;j[a+3|0]=e>>>24;j[a+4|0]=d;j[a+5|0]=d>>>8;j[a+6|0]=d>>>16;j[a+7|0]=d>>>24;d=m[36430]|m[36431]<<8|(m[36432]<<16|m[36433]<<24);j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;g=-11;d=11}e=sc(c);if(e){break a}Ub(f+5|0,19);e=b+g|0;b=Ja(f+5|0);if(e>>>0<=b>>>0){break b}a=pa(a+d|0,f+5|0,b+1|0);d=e-b|0;if(d>>>0<4){break b}a=a+b|0;j[a|0]=4025636;j[a+1|0]=15725;j[a+2|0]=61;j[a+3|0]=0;Ub(f+5|0,l[c+44>>2]);d=d+ -3|0;b=Ja(f+5|0);if(d>>>0<=b>>>0){break b}a=pa(a+3|0,f+5|0,b+1|0);d=d-b|0;if(d>>>0<4){break b}a=a+b|0;j[a|0]=4027436;j[a+1|0]=15732;j[a+2|0]=61;j[a+3|0]=0;Ub(f+5|0,l[c+40>>2]);d=d+ -3|0;b=Ja(f+5|0);if(d>>>0<=b>>>0){break b}a=pa(a+3|0,f+5|0,b+1|0);d=d-b|0;if(d>>>0<4){break b}a=a+b|0;j[a|0]=4026412;j[a+1|0]=15728;j[a+2|0]=61;j[a+3|0]=0;Ub(f+5|0,l[c+48>>2]);d=d+ -3|0;b=Ja(f+5|0);if(d>>>0<=b>>>0){break b}a=pa(a+3|0,f+5|0,b+1|0);d=d-b|0;if(d>>>0<2){break b}a=a+b|0;j[a|0]=36;j[a+1|0]=0;a=a+1|0;b=d+ -1|0;if(!Nc(a,b,l[c+16>>2],l[c+20>>2],3)){break b}e=-31;d=b;b=Ja(a);d=d-b|0;if(d>>>0<2){break a}a=a+b|0;j[a|0]=36;j[a+1|0]=0;a=Nc(a+1|0,d+ -1|0,l[c>>2],l[c+4>>2],3);J=f+16|0;return a?0:-31}e=-31}J=f+16|0;return e}function wc(a,b,c,d){var e=0,f=0;e=J;f=e;e=e-576&-64;J=e;l[e+188>>2]=0;ga(e+188|0,b);a:{if(b>>>0<=64){if((yb(e+192|0,0,0,b)|0)<0){break a}if((za(e+192|0,e+188|0,4,0)|0)<0){break a}if((za(e+192|0,c,d,0)|0)<0){break a}xb(e+192|0,a,b);break a}if((yb(e+192|0,0,0,64)|0)<0){break a}if((za(e+192|0,e+188|0,4,0)|0)<0){break a}if((za(e+192|0,c,d,0)|0)<0){break a}if((xb(e+192|0,e+112|0,64)|0)<0){break a}c=l[e+116>>2];d=l[e+112>>2];j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=c;j[a+5|0]=c>>>8;j[a+6|0]=c>>>16;j[a+7|0]=c>>>24;c=l[e+124>>2];d=l[e+120>>2];j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=c;j[a+13|0]=c>>>8;j[a+14|0]=c>>>16;j[a+15|0]=c>>>24;c=l[e+140>>2];d=l[e+136>>2];j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=c;j[a+29|0]=c>>>8;j[a+30|0]=c>>>16;j[a+31|0]=c>>>24;c=l[e+132>>2];d=l[e+128>>2];j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=c;j[a+21|0]=c>>>8;j[a+22|0]=c>>>16;j[a+23|0]=c>>>24;pa(e+48|0,e+112|0,64);a=a+32|0;b=b+ -32|0;if(b>>>0>=65){while(1){if((Rb(e+112|0,64,e+48|0,64,0,0,0)|0)<0){break a}c=l[e+116>>2];d=l[e+112>>2];j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=c;j[a+5|0]=c>>>8;j[a+6|0]=c>>>16;j[a+7|0]=c>>>24;c=l[e+124>>2];d=l[e+120>>2];j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=c;j[a+13|0]=c>>>8;j[a+14|0]=c>>>16;j[a+15|0]=c>>>24;c=l[e+140>>2];d=l[e+136>>2];j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=c;j[a+29|0]=c>>>8;j[a+30|0]=c>>>16;j[a+31|0]=c>>>24;c=l[e+132>>2];d=l[e+128>>2];j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=c;j[a+21|0]=c>>>8;j[a+22|0]=c>>>16;j[a+23|0]=c>>>24;a=a+32|0;pa(e+48|0,e+112|0,64);b=b+ -32|0;if(b>>>0>64){continue}break}}if((Rb(e+112|0,b,e+48|0,64,0,0,0)|0)<0){break a}pa(a,e+112|0,b)}ea(e+192|0,384);J=f}function pb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;a:{if(!d){e=2036477234;f=857760878;g=1634760805;d=1797285236;break a}g=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);f=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);e=m[d+8|0]|m[d+9|0]<<8|(m[d+10|0]<<16|m[d+11|0]<<24);d=m[d+12|0]|m[d+13|0]<<8|(m[d+14|0]<<16|m[d+15|0]<<24)}s=20;k=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);r=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);t=m[c+8|0]|m[c+9|0]<<8|(m[c+10|0]<<16|m[c+11|0]<<24);q=m[c+12|0]|m[c+13|0]<<8|(m[c+14|0]<<16|m[c+15|0]<<24);l=m[c+16|0]|m[c+17|0]<<8|(m[c+18|0]<<16|m[c+19|0]<<24);i=m[c+20|0]|m[c+21|0]<<8|(m[c+22|0]<<16|m[c+23|0]<<24);n=m[c+24|0]|m[c+25|0]<<8|(m[c+26|0]<<16|m[c+27|0]<<24);o=m[c+28|0]|m[c+29|0]<<8|(m[c+30|0]<<16|m[c+31|0]<<24);c=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);j=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);h=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);b=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);while(1){p=h;h=ba(g+i|0,7)^q;p=p^ba(h+g|0,9);u=ba(h+p|0,13)^i;q=ba(p+u|0,18);b=ba(f+k|0,7)^b;n=ba(b+f|0,9)^n;k=ba(b+n|0,13)^k;w=ba(n+k|0,18);o=ba(c+e|0,7)^o;i=ba(o+e|0,9)^r;v=ba(i+o|0,13)^c;x=ba(i+v|0,18);c=ba(d+l|0,7)^t;j=ba(c+d|0,9)^j;l=ba(c+j|0,13)^l;y=ba(j+l|0,18);g=g^q;k=ba(g+c|0,7)^k;r=ba(k+g|0,9)^i;t=ba(k+r|0,13)^c;g=ba(r+t|0,18)^g;f=f^w;c=ba(f+h|0,7)^v;j=ba(c+f|0,9)^j;q=ba(c+j|0,13)^h;f=ba(j+q|0,18)^f;e=e^x;l=ba(e+b|0,7)^l;h=ba(l+e|0,9)^p;b=ba(h+l|0,13)^b;e=ba(b+h|0,18)^e;d=d^y;i=ba(d+o|0,7)^u;n=ba(i+d|0,9)^n;o=ba(i+n|0,13)^o;d=ba(n+o|0,18)^d;p=s>>>0>2;s=s+ -2|0;if(p){continue}break}ga(a,g);ga(a+4|0,f);ga(a+8|0,e);ga(a+12|0,d);ga(a+16|0,c);ga(a+20|0,j);ga(a+24|0,h);ga(a+28|0,b);return 0}function $e(a,b){a=a|0;b=b|0;var c=0,d=0;c=J-128|0;J=c;l[c+80>>2]=0;l[c+84>>2]=0;l[c+88>>2]=0;l[c+92>>2]=0;l[c+40>>2]=0;l[c+44>>2]=0;l[c+48>>2]=0;l[c+52>>2]=0;l[c+56>>2]=0;l[c+60>>2]=0;d=l[9063];l[c+104>>2]=l[9062];l[c+108>>2]=d;d=l[9065];l[c+112>>2]=l[9064];l[c+116>>2]=d;d=l[9067];l[c+120>>2]=l[9066];l[c+124>>2]=d;l[c+64>>2]=0;l[c+68>>2]=0;l[c+72>>2]=0;l[c+76>>2]=0;j[c+64|0]=1;l[c+32>>2]=0;l[c+36>>2]=0;d=l[9061];l[c+96>>2]=l[9060];l[c+100>>2]=d;d=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);l[c+24>>2]=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);l[c+28>>2]=d;d=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);l[c+16>>2]=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);l[c+20>>2]=d;d=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);l[c+8>>2]=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);l[c+12>>2]=d;d=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);l[c>>2]=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);l[c+4>>2]=d;sf(c- -64|0,c);tb(c- -64|0);b=l[c+92>>2];d=l[c+88>>2];j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=b;j[a+29|0]=b>>>8;j[a+30|0]=b>>>16;j[a+31|0]=b>>>24;b=l[c+84>>2];d=l[c+80>>2];j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;b=l[c+76>>2];d=l[c+72>>2];j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=b;j[a+13|0]=b>>>8;j[a+14|0]=b>>>16;j[a+15|0]=b>>>24;b=l[c+68>>2];d=l[c+64>>2];j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;J=c+128|0}function Tc(a,b){a=a|0;b=b|0;var c=0,d=0;c=J-128|0;J=c;l[c+80>>2]=0;l[c+84>>2]=0;l[c+88>>2]=0;l[c+92>>2]=0;l[c+40>>2]=0;l[c+44>>2]=0;l[c+48>>2]=0;l[c+52>>2]=0;l[c+56>>2]=0;l[c+60>>2]=0;d=l[9063];l[c+104>>2]=l[9062];l[c+108>>2]=d;d=l[9065];l[c+112>>2]=l[9064];l[c+116>>2]=d;d=l[9067];l[c+120>>2]=l[9066];l[c+124>>2]=d;l[c+64>>2]=0;l[c+68>>2]=0;l[c+72>>2]=0;l[c+76>>2]=0;l[c+32>>2]=0;l[c+36>>2]=0;d=l[9061];l[c+96>>2]=l[9060];l[c+100>>2]=d;d=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);l[c+16>>2]=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);l[c+20>>2]=d;d=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);l[c+24>>2]=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);l[c+28>>2]=d;d=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);l[c>>2]=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);l[c+4>>2]=d;d=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);l[c+8>>2]=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);l[c+12>>2]=d;sf(c- -64|0,c);tb(c- -64|0);b=l[c+92>>2];d=l[c+88>>2];j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=b;j[a+29|0]=b>>>8;j[a+30|0]=b>>>16;j[a+31|0]=b>>>24;b=l[c+84>>2];d=l[c+80>>2];j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;b=l[c+76>>2];d=l[c+72>>2];j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=b;j[a+13|0]=b>>>8;j[a+14|0]=b>>>16;j[a+15|0]=b>>>24;b=l[c+68>>2];d=l[c+64>>2];j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;J=c+128|0}function zc(a){a=a|0;var b=0,c=0,d=0;c=J-48|0;J=c;b=m[a+28|0]|m[a+29|0]<<8|(m[a+30|0]<<16|m[a+31|0]<<24);l[c+24>>2]=m[a+24|0]|m[a+25|0]<<8|(m[a+26|0]<<16|m[a+27|0]<<24);l[c+28>>2]=b;b=m[a+20|0]|m[a+21|0]<<8|(m[a+22|0]<<16|m[a+23|0]<<24);l[c+16>>2]=m[a+16|0]|m[a+17|0]<<8|(m[a+18|0]<<16|m[a+19|0]<<24);l[c+20>>2]=b;b=m[a+4|0]|m[a+5|0]<<8|(m[a+6|0]<<16|m[a+7|0]<<24);l[c>>2]=m[a|0]|m[a+1|0]<<8|(m[a+2|0]<<16|m[a+3|0]<<24);l[c+4>>2]=b;b=m[a+12|0]|m[a+13|0]<<8|(m[a+14|0]<<16|m[a+15|0]<<24);l[c+8>>2]=m[a+8|0]|m[a+9|0]<<8|(m[a+10|0]<<16|m[a+11|0]<<24);l[c+12>>2]=b;b=m[a+40|0]|m[a+41|0]<<8|(m[a+42|0]<<16|m[a+43|0]<<24);l[c+32>>2]=m[a+36|0]|m[a+37|0]<<8|(m[a+38|0]<<16|m[a+39|0]<<24);l[c+36>>2]=b;Of(c,c,40,0,a+32|0,a);b=l[c+28>>2];d=l[c+24>>2];j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=b;j[a+29|0]=b>>>8;j[a+30|0]=b>>>16;j[a+31|0]=b>>>24;b=l[c+20>>2];d=l[c+16>>2];j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;b=l[c+12>>2];d=l[c+8>>2];j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=b;j[a+13|0]=b>>>8;j[a+14|0]=b>>>16;j[a+15|0]=b>>>24;b=l[c+4>>2];d=l[c>>2];j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;b=l[c+36>>2];d=l[c+32>>2];j[a+36|0]=d;j[a+37|0]=d>>>8;j[a+38|0]=d>>>16;j[a+39|0]=d>>>24;j[a+40|0]=b;j[a+41|0]=b>>>8;j[a+42|0]=b>>>16;j[a+43|0]=b>>>24;Ac(a);J=c+48|0}function ee(a,b,c,d,e,f,g){var h=0,i=0,k=0,n=0,o=0,p=0,q=0,r=0;i=J-560|0;J=i;xc(i+352|0,g);Fb(i+288|0,f,32,0);Da(i+352|0,i+320|0,32,0);Da(i+352|0,c,d,e);Oa(i+352|0,i+224|0);h=f;k=m[h+32|0]|m[h+33|0]<<8|(m[h+34|0]<<16|m[h+35|0]<<24);n=m[h+36|0]|m[h+37|0]<<8|(m[h+38|0]<<16|m[h+39|0]<<24);o=m[h+40|0]|m[h+41|0]<<8|(m[h+42|0]<<16|m[h+43|0]<<24);p=m[h+44|0]|m[h+45|0]<<8|(m[h+46|0]<<16|m[h+47|0]<<24);q=m[h+48|0]|m[h+49|0]<<8|(m[h+50|0]<<16|m[h+51|0]<<24);f=m[h+52|0]|m[h+53|0]<<8|(m[h+54|0]<<16|m[h+55|0]<<24);r=m[h+60|0]|m[h+61|0]<<8|(m[h+62|0]<<16|m[h+63|0]<<24);h=m[h+56|0]|m[h+57|0]<<8|(m[h+58|0]<<16|m[h+59|0]<<24);j[a+56|0]=h;j[a+57|0]=h>>>8;j[a+58|0]=h>>>16;j[a+59|0]=h>>>24;j[a+60|0]=r;j[a+61|0]=r>>>8;j[a+62|0]=r>>>16;j[a+63|0]=r>>>24;j[a+48|0]=q;j[a+49|0]=q>>>8;j[a+50|0]=q>>>16;j[a+51|0]=q>>>24;j[a+52|0]=f;j[a+53|0]=f>>>8;j[a+54|0]=f>>>16;j[a+55|0]=f>>>24;j[a+40|0]=o;j[a+41|0]=o>>>8;j[a+42|0]=o>>>16;j[a+43|0]=o>>>24;j[a+44|0]=p;j[a+45|0]=p>>>8;j[a+46|0]=p>>>16;j[a+47|0]=p>>>24;f=a+32|0;j[f|0]=k;j[f+1|0]=k>>>8;j[f+2|0]=k>>>16;j[f+3|0]=k>>>24;j[f+4|0]=n;j[f+5|0]=n>>>8;j[f+6|0]=n>>>16;j[f+7|0]=n>>>24;tb(i+224|0);Nb(i,i+224|0);cb(a,i);xc(i+352|0,g);Da(i+352|0,a,64,0);Da(i+352|0,c,d,e);Oa(i+352|0,i+160|0);tb(i+160|0);j[i+288|0]=m[i+288|0]&248;j[i+319|0]=m[i+319|0]&63|64;el(f,i+160|0,i+288|0,i+224|0);ea(i+288|0,64);ea(i+224|0,64);if(b){l[b>>2]=64;l[b+4>>2]=0}J=i+560|0;return 0}function Rk(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,k=0,n=0;k=J-112|0;J=k;if(c|d){i=m[h+28|0]|m[h+29|0]<<8|(m[h+30|0]<<16|m[h+31|0]<<24);l[k+24>>2]=m[h+24|0]|m[h+25|0]<<8|(m[h+26|0]<<16|m[h+27|0]<<24);l[k+28>>2]=i;i=m[h+20|0]|m[h+21|0]<<8|(m[h+22|0]<<16|m[h+23|0]<<24);l[k+16>>2]=m[h+16|0]|m[h+17|0]<<8|(m[h+18|0]<<16|m[h+19|0]<<24);l[k+20>>2]=i;i=m[h+4|0]|m[h+5|0]<<8|(m[h+6|0]<<16|m[h+7|0]<<24);l[k>>2]=m[h|0]|m[h+1|0]<<8|(m[h+2|0]<<16|m[h+3|0]<<24);l[k+4>>2]=i;i=8;n=m[h+12|0]|m[h+13|0]<<8|(m[h+14|0]<<16|m[h+15|0]<<24);l[k+8>>2]=m[h+8|0]|m[h+9|0]<<8|(m[h+10|0]<<16|m[h+11|0]<<24);l[k+12>>2]=n;h=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[k+96>>2]=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);l[k+100>>2]=h;while(1){j[(k+96|0)+i|0]=f;f=(g&255)<<24|f>>>8;g=g>>>8|0;i=i+1|0;if((i|0)!=16){continue}break}if(!d&c>>>0>63|d>>>0>0){while(1){i=0;Jb(k+32|0,k+96|0,k,0);while(1){j[a+i|0]=m[(k+32|0)+i|0]^m[b+i|0];h=1;i=i+1|0;if((i|0)!=64){continue}break}i=8;while(1){f=(k+96|0)+i|0;e=m[f|0]+h|0;j[f|0]=e;h=e>>>8|0;i=i+1|0;if((i|0)!=16){continue}break}b=b- -64|0;a=a- -64|0;d=d+ -1|0;c=c+ -64|0;if(c>>>0<4294967232){d=d+1|0}if(!d&c>>>0>63|d>>>0>0){continue}break}}a:{if(!(c|d)){break a}i=0;Jb(k+32|0,k+96|0,k,0);if(!c){break a}while(1){j[a+i|0]=m[(k+32|0)+i|0]^m[b+i|0];i=i+1|0;if((c|0)!=(i|0)){continue}break}}ea(k+32|0,64);ea(k,32)}J=k+112|0;return 0}function Sc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=J-128|0;J=d;l[d+104>>2]=0;l[d+108>>2]=0;l[d+112>>2]=0;l[d+116>>2]=0;l[d+120>>2]=0;l[d+124>>2]=0;l[d+96>>2]=0;l[d+100>>2]=0;e=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);l[d+80>>2]=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);l[d+84>>2]=e;e=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);l[d+88>>2]=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);l[d+92>>2]=e;e=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);f=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);g=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);b=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);l[d+40>>2]=0;l[d+44>>2]=0;l[d+48>>2]=0;l[d+52>>2]=0;l[d+56>>2]=0;l[d+60>>2]=0;l[d+64>>2]=g;l[d+68>>2]=b;l[d+72>>2]=e;l[d+76>>2]=f;l[d+32>>2]=0;l[d+36>>2]=0;b=m[c+20|0]|m[c+21|0]<<8|(m[c+22|0]<<16|m[c+23|0]<<24);l[d+16>>2]=m[c+16|0]|m[c+17|0]<<8|(m[c+18|0]<<16|m[c+19|0]<<24);l[d+20>>2]=b;b=m[c+28|0]|m[c+29|0]<<8|(m[c+30|0]<<16|m[c+31|0]<<24);l[d+24>>2]=m[c+24|0]|m[c+25|0]<<8|(m[c+26|0]<<16|m[c+27|0]<<24);l[d+28>>2]=b;b=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);l[d>>2]=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);l[d+4>>2]=b;b=m[c+12|0]|m[c+13|0]<<8|(m[c+14|0]<<16|m[c+15|0]<<24);l[d+8>>2]=m[c+8|0]|m[c+9|0]<<8|(m[c+10|0]<<16|m[c+11|0]<<24);l[d+12>>2]=b;qk(d- -64|0,d);Rc(a,d- -64|0);J=d+128|0}function hi(a,b,c,d,e,f){var g=0,h=0;g=J-112|0;J=g;if(c|d){h=m[f+28|0]|m[f+29|0]<<8|(m[f+30|0]<<16|m[f+31|0]<<24);l[g+24>>2]=m[f+24|0]|m[f+25|0]<<8|(m[f+26|0]<<16|m[f+27|0]<<24);l[g+28>>2]=h;h=m[f+20|0]|m[f+21|0]<<8|(m[f+22|0]<<16|m[f+23|0]<<24);l[g+16>>2]=m[f+16|0]|m[f+17|0]<<8|(m[f+18|0]<<16|m[f+19|0]<<24);l[g+20>>2]=h;h=m[f+4|0]|m[f+5|0]<<8|(m[f+6|0]<<16|m[f+7|0]<<24);l[g>>2]=m[f|0]|m[f+1|0]<<8|(m[f+2|0]<<16|m[f+3|0]<<24);l[g+4>>2]=h;h=m[f+12|0]|m[f+13|0]<<8|(m[f+14|0]<<16|m[f+15|0]<<24);l[g+8>>2]=m[f+8|0]|m[f+9|0]<<8|(m[f+10|0]<<16|m[f+11|0]<<24);l[g+12>>2]=h;f=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);e=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[g+104>>2]=0;l[g+108>>2]=0;l[g+96>>2]=f;l[g+100>>2]=e;a:{if(!d&c>>>0>=64|d>>>0>0){while(1){f=0;Ib(g+32|0,g+96|0,g,0);while(1){j[a+f|0]=m[(g+32|0)+f|0]^m[b+f|0];e=1;f=f+1|0;if((f|0)!=64){continue}break}f=8;while(1){h=(g+96|0)+f|0;e=m[h|0]+e|0;j[h|0]=e;e=e>>>8|0;f=f+1|0;if((f|0)!=16){continue}break}b=b- -64|0;a=a- -64|0;d=d+ -1|0;c=c+ -64|0;if(c>>>0<4294967232){d=d+1|0}if(!d&c>>>0>63|d>>>0>0){continue}break}if(!(c|d)){break a}}f=0;Ib(g+32|0,g+96|0,g,0);if(!c){break a}while(1){j[a+f|0]=m[(g+32|0)+f|0]^m[b+f|0];f=f+1|0;if((c|0)!=(f|0)){continue}break}}ea(g+32|0,64);ea(g,32)}J=g+112|0;return 0}function ei(a,b,c,d,e,f){var g=0,h=0;g=J-112|0;J=g;if(c|d){h=m[f+28|0]|m[f+29|0]<<8|(m[f+30|0]<<16|m[f+31|0]<<24);l[g+24>>2]=m[f+24|0]|m[f+25|0]<<8|(m[f+26|0]<<16|m[f+27|0]<<24);l[g+28>>2]=h;h=m[f+20|0]|m[f+21|0]<<8|(m[f+22|0]<<16|m[f+23|0]<<24);l[g+16>>2]=m[f+16|0]|m[f+17|0]<<8|(m[f+18|0]<<16|m[f+19|0]<<24);l[g+20>>2]=h;h=m[f+4|0]|m[f+5|0]<<8|(m[f+6|0]<<16|m[f+7|0]<<24);l[g>>2]=m[f|0]|m[f+1|0]<<8|(m[f+2|0]<<16|m[f+3|0]<<24);l[g+4>>2]=h;h=m[f+12|0]|m[f+13|0]<<8|(m[f+14|0]<<16|m[f+15|0]<<24);l[g+8>>2]=m[f+8|0]|m[f+9|0]<<8|(m[f+10|0]<<16|m[f+11|0]<<24);l[g+12>>2]=h;f=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);e=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[g+104>>2]=0;l[g+108>>2]=0;l[g+96>>2]=f;l[g+100>>2]=e;a:{if(!d&c>>>0>=64|d>>>0>0){while(1){f=0;Hb(g+32|0,g+96|0,g,0);while(1){j[a+f|0]=m[(g+32|0)+f|0]^m[b+f|0];e=1;f=f+1|0;if((f|0)!=64){continue}break}f=8;while(1){h=(g+96|0)+f|0;e=m[h|0]+e|0;j[h|0]=e;e=e>>>8|0;f=f+1|0;if((f|0)!=16){continue}break}b=b- -64|0;a=a- -64|0;d=d+ -1|0;c=c+ -64|0;if(c>>>0<4294967232){d=d+1|0}if(!d&c>>>0>63|d>>>0>0){continue}break}if(!(c|d)){break a}}f=0;Hb(g+32|0,g+96|0,g,0);if(!c){break a}while(1){j[a+f|0]=m[(g+32|0)+f|0]^m[b+f|0];f=f+1|0;if((c|0)!=(f|0)){continue}break}}ea(g+32|0,64);ea(g,32)}J=g+112|0;return 0}function te(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;b=J+ -64|0;J=b;Sb(b,a);h=l[b+28>>2];i=l[b+12>>2];d=l[b+44>>2];e=l[b+60>>2];j=l[b+8>>2];s=l[b+56>>2];f=l[b+24>>2];p=l[b+40>>2];q=l[b+52>>2];t=l[b+36>>2];g=l[b+4>>2];r=l[b+20>>2];n=l[b+32>>2];k=l[b+16>>2];o=l[b+48>>2];c=l[b>>2];while(1){m=sl(g+r|0,7)^t;u=sl(m+r|0,9)^q;k=sl(c+o|0,7)^k;v=sl(k+c|0,9)^n;w=sl(v+k|0,13)^o;i=sl(d+e|0,7)^i;h=sl(i+e|0,9)^h;n=sl(h+i|0,13)^d;e=sl(h+n|0,18)^e;d=sl(f+p|0,7)^s;o=w^sl(e+d|0,7);q=u^sl(o+e|0,9);s=sl(o+q|0,13)^d;e=sl(q+s|0,18)^e;j=sl(d+p|0,9)^j;x=sl(j+d|0,13)^f;f=sl(x+j|0,18)^p;d=sl(f+m|0,7)^n;n=sl(d+f|0,9)^v;t=sl(d+n|0,13)^m;p=sl(n+t|0,18)^f;m=sl(m+u|0,13)^g;g=sl(m+u|0,18)^r;f=sl(g+k|0,7)^x;h=sl(f+g|0,9)^h;k=sl(f+h|0,13)^k;r=sl(h+k|0,18)^g;c=sl(v+w|0,18)^c;g=sl(c+i|0,7)^m;j=sl(g+c|0,9)^j;i=sl(j+g|0,13)^i;c=sl(j+i|0,18)^c;m=y>>>0<6;y=y+2|0;if(m){continue}break}l[b+48>>2]=o;l[b+32>>2]=n;l[b+16>>2]=k;l[b+20>>2]=r;l[b+52>>2]=q;l[b+36>>2]=t;l[b+4>>2]=g;l[b+40>>2]=p;l[b+56>>2]=s;l[b+24>>2]=f;l[b+60>>2]=e;l[b+8>>2]=j;l[b+44>>2]=d;l[b+28>>2]=h;l[b+12>>2]=i;l[b>>2]=c;l[a>>2]=l[a>>2]+c;c=1;while(1){d=c<<2;e=d+a|0;l[e>>2]=l[e>>2]+l[b+d>>2];c=c+1|0;if((c|0)!=16){continue}break}J=b- -64|0}function kl(a,b,c,d){var e=0;e=J-2272|0;J=e;bg(e+2016|0,b);bg(e+1760|0,d);sa(e+480|0,c);ab(e+320|0,c);ma(e,e+320|0);ta(e+320|0,e,e+480|0);ma(e+160|0,e+320|0);b=e+640|0;sa(b,e+160|0);ta(e+320|0,e,b);ma(e+160|0,e+320|0);b=e+800|0;sa(b,e+160|0);ta(e+320|0,e,b);ma(e+160|0,e+320|0);b=e+960|0;sa(b,e+160|0);ta(e+320|0,e,b);ma(e+160|0,e+320|0);b=e+1120|0;sa(b,e+160|0);ta(e+320|0,e,b);ma(e+160|0,e+320|0);b=e+1280|0;sa(b,e+160|0);ta(e+320|0,e,b);ma(e+160|0,e+320|0);b=e+1440|0;sa(b,e+160|0);ta(e+320|0,e,b);ma(e+160|0,e+320|0);sa(e+1600|0,e+160|0);jb(a);wa(a+40|0);wa(a+80|0);d=255;a:{while(1){c=d;if(!(m[c+(e+2016|0)|0]|m[(e+1760|0)+c|0])){d=c+ -1|0;if(c){continue}break a}break}if((c|0)<0){break a}while(1){La(e+320|0,a);b=c;c=j[b+(e+2016|0)|0];b:{if((c|0)>=1){ma(e+160|0,e+320|0);ta(e+320|0,e+160|0,(e+480|0)+r((c&254)>>>1|0,160)|0);break b}if((c|0)>-1){break b}ma(e+160|0,e+320|0);pc(e+320|0,e+160|0,(e+480|0)+r((c|0)/-2<<24>>24,160)|0)}c=j[b+(e+1760|0)|0];c:{if((c|0)>=1){ma(e+160|0,e+320|0);td(e+320|0,e+160|0,r((c&254)>>>1|0,120)+2272|0);break c}if((c|0)>-1){break c}ma(e+160|0,e+320|0);jl(e+320|0,e+160|0,r((c|0)/-2<<24>>24,120)+2272|0)}Ra(a,e+320|0);c=b+ -1|0;if((b|0)>0){continue}break}}J=e+2272|0}function Da(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,k=0,n=0,o=0;k=J-704|0;J=k;a:{if(!(c|d)){break a}e=a;n=l[e+72>>2];f=c;g=f<<3;i=n+g|0;h=l[e+76>>2];f=h+(d<<3|f>>>29)|0;f=i>>>0<g>>>0?f+1|0:f;l[e+72>>2]=i;l[e+76>>2]=f;e=l[e+64>>2];g=l[a+68>>2];if((f|0)==(h|0)&i>>>0<n>>>0|f>>>0<h>>>0){e=e+1|0;if(e>>>0<1){g=g+1|0}f=a;l[f+64>>2]=e;l[f+68>>2]=g}o=d>>>29|0;e=o+e|0;if(e>>>0<o>>>0){g=g+1|0}f=a;l[f+64>>2]=e;l[f+68>>2]=g;f=((h&7)<<29|n>>>3)&127;h=128-f|0;e=h;i=0-(128<f>>>0)|0;g=i;if((d|0)==(g|0)&e>>>0<=c>>>0|g>>>0<d>>>0){e=0;g=0;while(1){o=e+f|0;j[(a+o|0)+80|0]=m[b+e|0];e=e+1|0;if(e>>>0<1){g=g+1|0}if((h|0)!=(e|0)|(g|0)!=(i|0)){continue}break}g=k+640|0;fc(a,a+80|0,k,g);b=b+h|0;d=d-((c>>>0<h>>>0)+i|0)|0;c=c-h|0;if(!d&c>>>0>127|d>>>0>0){while(1){fc(a,b,k,g);b=b+128|0;f=d+ -1|0;c=c+ -128|0;if(c>>>0<4294967168){f=f+1|0}d=f;if(!f&c>>>0>127|f>>>0>0){continue}break}}if(c|d){e=0;g=0;while(1){j[(a+e|0)+80|0]=m[b+e|0];f=e+1|0;if(f>>>0<1){g=g+1|0}e=f;if((c|0)!=(e|0)|(d|0)!=(g|0)){continue}break}}ea(k,704);break a}e=c;c=!d&c>>>0>1|d>>>0>0;h=c?e:1;d=c?d:0;e=0;g=0;while(1){n=e+f|0;j[(a+n|0)+80|0]=m[b+e|0];c=e+1|0;if(c>>>0<1){g=g+1|0}e=c;if((h|0)!=(e|0)|(d|0)!=(g|0)){continue}break}}J=k+704|0;return 0}function Tk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;f=J-112|0;J=f;if(b|c){g=m[e+28|0]|m[e+29|0]<<8|(m[e+30|0]<<16|m[e+31|0]<<24);l[f+24>>2]=m[e+24|0]|m[e+25|0]<<8|(m[e+26|0]<<16|m[e+27|0]<<24);l[f+28>>2]=g;g=m[e+20|0]|m[e+21|0]<<8|(m[e+22|0]<<16|m[e+23|0]<<24);l[f+16>>2]=m[e+16|0]|m[e+17|0]<<8|(m[e+18|0]<<16|m[e+19|0]<<24);l[f+20>>2]=g;g=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[f>>2]=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);l[f+4>>2]=g;g=m[e+12|0]|m[e+13|0]<<8|(m[e+14|0]<<16|m[e+15|0]<<24);l[f+8>>2]=m[e+8|0]|m[e+9|0]<<8|(m[e+10|0]<<16|m[e+11|0]<<24);l[f+12>>2]=g;e=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);d=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);l[f+104>>2]=0;l[f+108>>2]=0;l[f+96>>2]=e;l[f+100>>2]=d;a:{if(!c&b>>>0>=64|c>>>0>0){while(1){Jb(a,f+96|0,f,0);e=8;d=1;while(1){g=(f+96|0)+e|0;d=m[g|0]+d|0;j[g|0]=d;d=d>>>8|0;e=e+1|0;if((e|0)!=16){continue}break}a=a- -64|0;c=c+ -1|0;b=b+ -64|0;if(b>>>0<4294967232){c=c+1|0}if(!c&b>>>0>63|c>>>0>0){continue}break}if(!(b|c)){break a}}e=0;Jb(f+32|0,f+96|0,f,0);if(!b){break a}while(1){j[a+e|0]=m[(f+32|0)+e|0];e=e+1|0;if((b|0)!=(e|0)){continue}break}}ea(f+32|0,64);ea(f,32)}J=f+112|0;return 0}function ii(a,b,c,d,e){var f=0,g=0;f=J-112|0;J=f;if(b|c){g=m[e+28|0]|m[e+29|0]<<8|(m[e+30|0]<<16|m[e+31|0]<<24);l[f+24>>2]=m[e+24|0]|m[e+25|0]<<8|(m[e+26|0]<<16|m[e+27|0]<<24);l[f+28>>2]=g;g=m[e+20|0]|m[e+21|0]<<8|(m[e+22|0]<<16|m[e+23|0]<<24);l[f+16>>2]=m[e+16|0]|m[e+17|0]<<8|(m[e+18|0]<<16|m[e+19|0]<<24);l[f+20>>2]=g;g=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[f>>2]=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);l[f+4>>2]=g;g=m[e+12|0]|m[e+13|0]<<8|(m[e+14|0]<<16|m[e+15|0]<<24);l[f+8>>2]=m[e+8|0]|m[e+9|0]<<8|(m[e+10|0]<<16|m[e+11|0]<<24);l[f+12>>2]=g;e=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);d=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);l[f+104>>2]=0;l[f+108>>2]=0;l[f+96>>2]=e;l[f+100>>2]=d;a:{if(!c&b>>>0>=64|c>>>0>0){while(1){Ib(a,f+96|0,f,0);e=8;d=1;while(1){g=(f+96|0)+e|0;d=m[g|0]+d|0;j[g|0]=d;d=d>>>8|0;e=e+1|0;if((e|0)!=16){continue}break}a=a- -64|0;c=c+ -1|0;b=b+ -64|0;if(b>>>0<4294967232){c=c+1|0}if(!c&b>>>0>63|c>>>0>0){continue}break}if(!(b|c)){break a}}e=0;Ib(f+32|0,f+96|0,f,0);if(!b){break a}while(1){j[a+e|0]=m[(f+32|0)+e|0];e=e+1|0;if((b|0)!=(e|0)){continue}break}}ea(f+32|0,64);ea(f,32)}J=f+112|0;return 0}function gi(a,b,c,d,e){var f=0,g=0;f=J-112|0;J=f;if(b|c){g=m[e+28|0]|m[e+29|0]<<8|(m[e+30|0]<<16|m[e+31|0]<<24);l[f+24>>2]=m[e+24|0]|m[e+25|0]<<8|(m[e+26|0]<<16|m[e+27|0]<<24);l[f+28>>2]=g;g=m[e+20|0]|m[e+21|0]<<8|(m[e+22|0]<<16|m[e+23|0]<<24);l[f+16>>2]=m[e+16|0]|m[e+17|0]<<8|(m[e+18|0]<<16|m[e+19|0]<<24);l[f+20>>2]=g;g=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[f>>2]=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);l[f+4>>2]=g;g=m[e+12|0]|m[e+13|0]<<8|(m[e+14|0]<<16|m[e+15|0]<<24);l[f+8>>2]=m[e+8|0]|m[e+9|0]<<8|(m[e+10|0]<<16|m[e+11|0]<<24);l[f+12>>2]=g;e=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);d=m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24);l[f+104>>2]=0;l[f+108>>2]=0;l[f+96>>2]=e;l[f+100>>2]=d;a:{if(!c&b>>>0>=64|c>>>0>0){while(1){Hb(a,f+96|0,f,0);e=8;d=1;while(1){g=(f+96|0)+e|0;d=m[g|0]+d|0;j[g|0]=d;d=d>>>8|0;e=e+1|0;if((e|0)!=16){continue}break}a=a- -64|0;c=c+ -1|0;b=b+ -64|0;if(b>>>0<4294967232){c=c+1|0}if(!c&b>>>0>63|c>>>0>0){continue}break}if(!(b|c)){break a}}e=0;Hb(f+32|0,f+96|0,f,0);if(!b){break a}while(1){j[a+e|0]=m[(f+32|0)+e|0];e=e+1|0;if((b|0)!=(e|0)){continue}break}}ea(f+32|0,64);ea(f,32)}J=f+112|0;return 0}function $f(a,b,c){var d=0,e=0,f=0,g=0;d=J-4032|0;J=d;sa(d+160|0,c);ab(d+3528|0,c);ma(d+2408|0,d+3528|0);e=d+320|0;sa(e,d+2408|0);ta(d+3368|0,c,e);ma(d+2248|0,d+3368|0);sa(d+480|0,d+2248|0);ab(d+3208|0,d+2408|0);ma(d+2088|0,d+3208|0);e=d+640|0;sa(e,d+2088|0);ta(d+3048|0,c,e);ma(d+1928|0,d+3048|0);sa(d+800|0,d+1928|0);ab(d+2888|0,d+2248|0);ma(d+1768|0,d+2888|0);e=d+960|0;sa(e,d+1768|0);ta(d+2728|0,c,e);ma(d+1608|0,d+2728|0);sa(d+1120|0,d+1608|0);ab(d+2568|0,d+2088|0);ma(d+1448|0,d+2568|0);sa(d+1280|0,d+1448|0);e=0;c=0;while(1){f=c<<1;g=m[b+c|0];j[f+(d+3968|0)|0]=g&15;j[(d+3968|0)+(f|1)|0]=g>>>4;c=c+1|0;if((c|0)!=32){continue}break}c=0;while(1){b=c;c=(d+3968|0)+e|0;f=b+m[c|0]|0;b=f+8|0;j[c|0]=f-(b&240);c=b<<24>>28;e=e+1|0;if((e|0)!=63){continue}break}b=m[d+4031|0]+c|0;j[d+4031|0]=b;sd(a);_f(d,d+160|0,b<<24>>24);ta(d+3808|0,a,d);c=63;while(1){Ra(d+3688|0,d+3808|0);La(d+3808|0,d+3688|0);Ra(d+3688|0,d+3808|0);La(d+3808|0,d+3688|0);Ra(d+3688|0,d+3808|0);La(d+3808|0,d+3688|0);Ra(d+3688|0,d+3808|0);La(d+3808|0,d+3688|0);ma(a,d+3808|0);c=c+ -1|0;_f(d,d+160|0,j[c+(d+3968|0)|0]);ta(d+3808|0,a,d);if(c){continue}break}ma(a,d+3808|0);J=d+4032|0}function pa(a,b,c){var d=0,e=0,f=0;if(c>>>0>=512){G(a|0,b|0,c|0)|0;return a}e=a+c|0;a:{if(!((a^b)&3)){b:{if((c|0)<1){c=a;break b}if(!(a&3)){c=a;break b}c=a;while(1){j[c|0]=m[b|0];b=b+1|0;c=c+1|0;if(c>>>0>=e>>>0){break b}if(c&3){continue}break}}d=e&-4;c:{if(d>>>0<64){break c}f=d+ -64|0;if(c>>>0>f>>>0){break c}while(1){l[c>>2]=l[b>>2];l[c+4>>2]=l[b+4>>2];l[c+8>>2]=l[b+8>>2];l[c+12>>2]=l[b+12>>2];l[c+16>>2]=l[b+16>>2];l[c+20>>2]=l[b+20>>2];l[c+24>>2]=l[b+24>>2];l[c+28>>2]=l[b+28>>2];l[c+32>>2]=l[b+32>>2];l[c+36>>2]=l[b+36>>2];l[c+40>>2]=l[b+40>>2];l[c+44>>2]=l[b+44>>2];l[c+48>>2]=l[b+48>>2];l[c+52>>2]=l[b+52>>2];l[c+56>>2]=l[b+56>>2];l[c+60>>2]=l[b+60>>2];b=b- -64|0;c=c- -64|0;if(c>>>0<=f>>>0){continue}break}}if(c>>>0>=d>>>0){break a}while(1){l[c>>2]=l[b>>2];b=b+4|0;c=c+4|0;if(c>>>0<d>>>0){continue}break}break a}if(e>>>0<4){c=a;break a}d=e+ -4|0;if(d>>>0<a>>>0){c=a;break a}c=a;while(1){j[c|0]=m[b|0];j[c+1|0]=m[b+1|0];j[c+2|0]=m[b+2|0];j[c+3|0]=m[b+3|0];b=b+4|0;c=c+4|0;if(c>>>0<=d>>>0){continue}break}}if(c>>>0<e>>>0){while(1){j[c|0]=m[b|0];b=b+1|0;c=c+1|0;if((e|0)!=(c|0)){continue}break}}return a}function Mc(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;k=J-16|0;J=k;l[k+12>>2]=0;Oc(h);a:{b:{if(!d){break b}s=h&4;c:{d:{e:{while(1){i=o;f:{g:{while(1){q=j[c+i|0];h:{if(s){n=qj(q);break h}n=pj(q)}if((n|0)!=255){break g}if(!e){break f}if(!Wb(e,q)){break e}i=i+1|0;if(i>>>0<d>>>0){continue}break}a=o+1|0;l[k+12>>2]=a>>>0<d>>>0?d:a;break d}r=(r<<6)+n|0;n=m+6|0;i:{if(n>>>0<8){m=n;break i}m=m+ -2|0;if(p>>>0>=b>>>0){l[k+12>>2]=i;l[9180]=68;i=1;break c}j[a+p|0]=r>>>m;p=p+1|0}o=i+1|0;if(o>>>0<d>>>0){continue}}break}l[k+12>>2]=o;break d}l[k+12>>2]=i}i=0}if(m>>>0<=4){break b}a=-1;break a}a=-1;if((-1<<m^-1)&r|i){break a}if(!(h&2)){a=oj(c,d,k+12|0,e,m>>>1|0);if(a){break a}}a=0;j:{if(!e){break j}i=l[k+12>>2];if(i>>>0>=d>>>0){break j}k:{while(1){if(!Wb(e,j[c+i|0])){break k}i=i+1|0;if((i|0)!=(d|0)){continue}break}l[k+12>>2]=d;break j}l[k+12>>2]=i}t=p}b=l[k+12>>2];l:{if(g){l[g>>2]=b+c;break l}if((b|0)==(d|0)){break l}l[9180]=28;a=-1}if(f){l[f>>2]=t}J=k+16|0;return a|0}function cl(a,b){var c=0,d=0,e=0;e=J-48|0;J=e;c=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);d=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=c;j[a+29|0]=c>>>8;j[a+30|0]=c>>>16;j[a+31|0]=c>>>24;c=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);d=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=c;j[a+5|0]=c>>>8;j[a+6|0]=c>>>16;j[a+7|0]=c>>>24;c=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);d=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=c;j[a+21|0]=c>>>8;j[a+22|0]=c>>>16;j[a+23|0]=c>>>24;c=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);b=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);j[a+8|0]=b;j[a+9|0]=b>>>8;j[a+10|0]=b>>>16;j[a+11|0]=b>>>24;j[a+12|0]=c;j[a+13|0]=c>>>8;j[a+14|0]=c>>>16;j[a+15|0]=c>>>24;b=m[a+31|0];j[a+31|0]=b&127;Va(e,a);Vf(a,e,b&128);J=e+48|0}function qi(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=b;d=m[c+32|0]|m[c+33|0]<<8|(m[c+34|0]<<16|m[c+35|0]<<24);e=m[c+36|0]|m[c+37|0]<<8|(m[c+38|0]<<16|m[c+39|0]<<24);f=m[c+40|0]|m[c+41|0]<<8|(m[c+42|0]<<16|m[c+43|0]<<24);g=m[c+44|0]|m[c+45|0]<<8|(m[c+46|0]<<16|m[c+47|0]<<24);h=m[c+48|0]|m[c+49|0]<<8|(m[c+50|0]<<16|m[c+51|0]<<24);b=m[c+52|0]|m[c+53|0]<<8|(m[c+54|0]<<16|m[c+55|0]<<24);i=m[c+60|0]|m[c+61|0]<<8|(m[c+62|0]<<16|m[c+63|0]<<24);c=m[c+56|0]|m[c+57|0]<<8|(m[c+58|0]<<16|m[c+59|0]<<24);j[a+24|0]=c;j[a+25|0]=c>>>8;j[a+26|0]=c>>>16;j[a+27|0]=c>>>24;j[a+28|0]=i;j[a+29|0]=i>>>8;j[a+30|0]=i>>>16;j[a+31|0]=i>>>24;j[a+16|0]=h;j[a+17|0]=h>>>8;j[a+18|0]=h>>>16;j[a+19|0]=h>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;j[a+8|0]=f;j[a+9|0]=f>>>8;j[a+10|0]=f>>>16;j[a+11|0]=f>>>24;j[a+12|0]=g;j[a+13|0]=g>>>8;j[a+14|0]=g>>>16;j[a+15|0]=g>>>24;j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=e;j[a+5|0]=e>>>8;j[a+6|0]=e>>>16;j[a+7|0]=e>>>24;return 0}function yd(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,k=0,m=0,n=0,o=0,p=0,q=0,s=0,t=0,u=0,v=0;f=l[a+60>>2];c=f;d=l[a+56>>2];if(c|d){f=d;h=d+a|0;j[h- -64|0]=1;d=d+1|0;if(d>>>0<1){c=c+1|0}if(!c&d>>>0<=15|c>>>0<0){na(h+65|0,0,15-f|0)}j[a+80|0]=1;qc(a,a- -64|0,16,0)}v=l[a+52>>2];o=l[a+48>>2];i=l[a+44>>2];c=l[a+24>>2];f=l[a+28>>2]+(c>>>26|0)|0;e=l[a+32>>2]+(f>>>26|0)|0;p=l[a+36>>2]+(e>>>26|0)|0;n=l[a+20>>2]+r(p>>>26|0,5)|0;d=n&67108863;h=d+5|0;q=e&67108863;g=f&67108863;c=(c&67108863)+(n>>>26|0)|0;e=c+(h>>>26|0)|0;s=g+(e>>>26|0)|0;t=q+(s>>>26|0)|0;n=(p|-67108864)+(t>>>26|0)|0;f=n>>31;k=e;u=(n>>>31|0)+ -1|0;e=u&67108863;m=f&c|k&e;k=b;c=0;h=d&f|e&h|m<<26;d=h+l[a+40>>2]|0;if(d>>>0<h>>>0){c=1}ga(k,d);h=b+4|0;d=0;k=i;i=f&g|e&s;m=i<<20|m>>>6;g=k+m|0;if(g>>>0<m>>>0){d=1}k=g;g=c;m=k+c|0;c=d;c=m>>>0<g>>>0?c+1|0:c;ga(h,m);k=b+8|0;d=0;g=o;o=f&q|e&t;e=o<<14|i>>>12;i=g+e|0;if(i>>>0<e>>>0){d=1}g=i;i=c;e=g+c|0;c=d;c=e>>>0<i>>>0?c+1|0:c;ga(k,e);d=b+12|0;b=(n&u|f&p)<<8|o>>>18;f=b+v|0;c=c+f|0;ga(d,c);ea(a,88)}function ri(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=b;d=m[c+8|0]|m[c+9|0]<<8|(m[c+10|0]<<16|m[c+11|0]<<24);e=m[c+12|0]|m[c+13|0]<<8|(m[c+14|0]<<16|m[c+15|0]<<24);f=m[c+16|0]|m[c+17|0]<<8|(m[c+18|0]<<16|m[c+19|0]<<24);g=m[c+20|0]|m[c+21|0]<<8|(m[c+22|0]<<16|m[c+23|0]<<24);h=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);b=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);i=m[c+28|0]|m[c+29|0]<<8|(m[c+30|0]<<16|m[c+31|0]<<24);c=m[c+24|0]|m[c+25|0]<<8|(m[c+26|0]<<16|m[c+27|0]<<24);j[a+24|0]=c;j[a+25|0]=c>>>8;j[a+26|0]=c>>>16;j[a+27|0]=c>>>24;j[a+28|0]=i;j[a+29|0]=i>>>8;j[a+30|0]=i>>>16;j[a+31|0]=i>>>24;j[a+16|0]=f;j[a+17|0]=f>>>8;j[a+18|0]=f>>>16;j[a+19|0]=f>>>24;j[a+20|0]=g;j[a+21|0]=g>>>8;j[a+22|0]=g>>>16;j[a+23|0]=g>>>24;j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=e;j[a+13|0]=e>>>8;j[a+14|0]=e>>>16;j[a+15|0]=e>>>24;j[a|0]=h;j[a+1|0]=h>>>8;j[a+2|0]=h>>>16;j[a+3|0]=h>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;return 0}function vb(a,b){var c=0;c=J-192|0;J=c;ha(c+144|0,b);ha(c+96|0,c+144|0);ha(c+96|0,c+96|0);ca(c+96|0,b,c+96|0);ca(c+144|0,c+144|0,c+96|0);ha(c+48|0,c+144|0);ca(c+96|0,c+96|0,c+48|0);ha(c+48|0,c+96|0);b=1;while(1){ha(c+48|0,c+48|0);b=b+1|0;if((b|0)!=5){continue}break}ca(c+96|0,c+48|0,c+96|0);ha(c+48|0,c+96|0);b=1;while(1){ha(c+48|0,c+48|0);b=b+1|0;if((b|0)!=10){continue}break}ca(c+48|0,c+48|0,c+96|0);ha(c,c+48|0);b=1;while(1){ha(c,c);b=b+1|0;if((b|0)!=20){continue}break}ca(c+48|0,c,c+48|0);b=1;while(1){ha(c+48|0,c+48|0);b=b+1|0;if((b|0)!=11){continue}break}ca(c+96|0,c+48|0,c+96|0);ha(c+48|0,c+96|0);b=1;while(1){ha(c+48|0,c+48|0);b=b+1|0;if((b|0)!=50){continue}break}ca(c+48|0,c+48|0,c+96|0);ha(c,c+48|0);b=1;while(1){ha(c,c);b=b+1|0;if((b|0)!=100){continue}break}ca(c+48|0,c,c+48|0);b=1;while(1){ha(c+48|0,c+48|0);b=b+1|0;if((b|0)!=51){continue}break}ca(c+96|0,c+48|0,c+96|0);b=1;while(1){ha(c+96|0,c+96|0);b=b+1|0;if((b|0)!=6){continue}break}ca(a,c+96|0,c+144|0);J=c+192|0}function Se(a,b,c){var d=0,e=0,f=0,g=0;d=J-16|0;J=d;f=l[a+20>>2];l[a+20>>2]=0;g=l[a+4>>2];l[a+4>>2]=0;e=-26;a:{b:{c:{d:{switch(c+ -1|0){case 1:e=-32;if(Na(b,36374,9)){break a}b=b+9|0;break c;case 0:break d;default:break a}}e=-32;if(Na(b,36384,8)){break a}b=b+8|0}if(Na(b,36393,3)){break b}b=Vb(b+3|0,d+12|0);if(!b){break b}e=-26;if(l[d+12>>2]!=19){break a}if(Na(b,36397,3)){break b}b=Vb(b+3|0,d+12|0);if(!b){break b}l[a+44>>2]=l[d+12>>2];if(Na(b,36401,3)){break b}b=Vb(b+3|0,d+12|0);if(!b){break b}l[a+40>>2]=l[d+12>>2];if(Na(b,36405,3)){break b}b=Vb(b+3|0,d+12|0);if(!b){break b}c=l[d+12>>2];l[a+48>>2]=c;l[a+52>>2]=c;c=m[b|0]==36;if(!c){break b}l[d+12>>2]=f;b=c?b+1|0:b;if(Mc(l[a+16>>2],f,b,Ja(b),0,d+12|0,d+8|0,3)){break b}l[a+20>>2]=l[d+12>>2];b=l[d+8>>2];c=m[b|0];if((c|0)!=36){break b}l[d+12>>2]=g;b=(c|0)==36?b+1|0:b;if(Mc(l[a>>2],g,b,Ja(b),0,d+12|0,d+8|0,3)){break b}l[a+4>>2]=l[d+12>>2];b=l[d+8>>2];e=sc(a);if(e){break a}e=m[b|0]?-32:0;break a}e=-32}J=d+16|0;return e}function pl(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{e=b;if(e){d=c;if(!d){break i}break h}b=a;a=(a>>>0)/(c>>>0)|0;nl(b-r(a,c)|0,0);K=0;return a}if(!a){break g}break f}g=d+ -1|0;if(!(g&d)){break e}g=(u(d)+33|0)-u(e)|0;h=0-g|0;break c}a=(e>>>0)/0|0;nl(0,e-r(a,0)|0);K=0;return a}d=32-u(e)|0;if(d>>>0<31){break d}break b}nl(a&g,0);if((d|0)==1){break a}if(d){d=31-u(d+ -1^d)|0}else{d=32}c=d&31;if(32<=(d&63)>>>0){e=0;a=b>>>c|0}else{e=b>>>c|0;a=((1<<c)-1&b)<<32-c|a>>>c}K=e;return a}g=d+1|0;h=63-d|0}d=b;e=g&63;f=e&31;if(32<=e>>>0){e=0;f=d>>>f|0}else{e=d>>>f|0;f=((1<<f)-1&d)<<32-f|a>>>f}h=h&63;d=h&31;if(32<=h>>>0){b=a<<d;a=0}else{b=(1<<d)-1&a>>>32-d|b<<d;a=a<<d}if(g){d=-1;h=c+ -1|0;if(h>>>0<4294967295){d=0}while(1){i=f<<1|b>>>31;j=i;e=e<<1|f>>>31;i=d-(e+(h>>>0<i>>>0)|0)>>31;k=c&i;f=j-k|0;e=e-(j>>>0<k>>>0)|0;b=b<<1|a>>>31;a=l|a<<1;i=i&1;l=i;g=g+ -1|0;if(g){continue}break}}nl(f,e);K=b<<1|a>>>31;return i|a<<1}nl(a,b);a=0;b=0}K=b;return a}function Nc(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,k=0,l=0,n=0,o=0,p=0,q=0;Oc(e);f=(d>>>0)/3|0;g=f<<2;f=r(f,-3)+d|0;a:{if(!f){break a}if(!(e&2)){g=g+4|0;break a}g=(g|2)+(f>>>1|0)|0}b:{c:{o=g;d:{e:{if(g>>>0<b>>>0){f:{if(e&4){h=0;if(!d){break d}e=0;f=0;break f}h=0;if(!d){break d}e=0;f=0;break e}while(1){k=m[c+i|0]|k<<8;e=e+8|0;while(1){l=f;n=e;e=e+ -6|0;p=a+f|0,q=Ve(k>>>e&63),j[p|0]=q;f=f+1|0;if(e>>>0>5){continue}break}i=i+1|0;if((i|0)!=(d|0)){continue}break}h=f;if(!e){break d}p=a+f|0,q=Ve(k<<12-n&63),j[p|0]=q;h=l+2|0;break d}ra();A()}while(1){k=m[c+i|0]|k<<8;e=e+8|0;while(1){l=f;n=e;e=e+ -6|0;p=a+f|0,q=Ue(k>>>e&63),j[p|0]=q;f=f+1|0;if(e>>>0>5){continue}break}i=i+1|0;if((i|0)!=(d|0)){continue}break}h=f;if(!e){break d}p=a+f|0,q=Ue(k<<12-n&63),j[p|0]=q;h=l+2|0}f=h;if(o>>>0>=f>>>0){if(g>>>0>f>>>0){break c}g=f;break b}D(36321,36340,230,36356);A()}na(a+f|0,61,g-f|0)}c=g+1|0;na(a+g|0,0,(c>>>0<b>>>0?b:c)-g|0);return a|0}function ud(a,b){var c=0,d=0;c=J-144|0;J=c;ha(c+96|0,b);ha(c+48|0,c+96|0);ha(c+48|0,c+48|0);ca(c+48|0,b,c+48|0);ca(c+96|0,c+96|0,c+48|0);ha(c+96|0,c+96|0);ca(c+96|0,c+48|0,c+96|0);ha(c+48|0,c+96|0);d=1;while(1){ha(c+48|0,c+48|0);d=d+1|0;if((d|0)!=5){continue}break}ca(c+96|0,c+48|0,c+96|0);ha(c+48|0,c+96|0);d=1;while(1){ha(c+48|0,c+48|0);d=d+1|0;if((d|0)!=10){continue}break}ca(c+48|0,c+48|0,c+96|0);ha(c,c+48|0);d=1;while(1){ha(c,c);d=d+1|0;if((d|0)!=20){continue}break}ca(c+48|0,c,c+48|0);d=1;while(1){ha(c+48|0,c+48|0);d=d+1|0;if((d|0)!=11){continue}break}ca(c+96|0,c+48|0,c+96|0);ha(c+48|0,c+96|0);d=1;while(1){ha(c+48|0,c+48|0);d=d+1|0;if((d|0)!=50){continue}break}ca(c+48|0,c+48|0,c+96|0);ha(c,c+48|0);d=1;while(1){ha(c,c);d=d+1|0;if((d|0)!=100){continue}break}ca(c+48|0,c,c+48|0);d=1;while(1){ha(c+48|0,c+48|0);d=d+1|0;if((d|0)!=51){continue}break}ca(c+96|0,c+48|0,c+96|0);ha(c+96|0,c+96|0);ha(c+96|0,c+96|0);ca(a,c+96|0,b);J=c+144|0}function eb(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,k=0,n=0,o=0;i=J-288|0;J=i;a:{if(!(c|d)){break a}e=l[a+36>>2];n=e;h=l[a+32>>2];o=c<<3;k=h+o|0;e=e+(d<<3|c>>>29)|0;l[a+32>>2]=k;l[a+36>>2]=k>>>0<o>>>0?e+1|0:e;e=n;n=((e&7)<<29|h>>>3)&63;h=n;e=64-h|0;k=0-(64<h>>>0)|0;h=k;if((d|0)==(h|0)&e>>>0>c>>>0|h>>>0>d>>>0){while(1){h=g+n|0;j[(a+h|0)+40|0]=m[b+g|0];e=f;f=g+1|0;if(f>>>0<1){e=e+1|0}g=f;f=e;if((c|0)!=(g|0)|(d|0)!=(e|0)){continue}break a}}while(1){o=g+n|0;j[(a+o|0)+40|0]=m[b+g|0];g=g+1|0;if(g>>>0<1){f=f+1|0}if((e|0)!=(g|0)|(f|0)!=(k|0)){continue}break}f=i+256|0;ec(a,a+40|0,i,f);b=b+e|0;d=d-((c>>>0<e>>>0)+k|0)|0;c=c-e|0;if(!d&c>>>0>63|d>>>0>0){while(1){ec(a,b,i,f);b=b- -64|0;d=d+ -1|0;c=c+ -64|0;if(c>>>0<4294967232){d=d+1|0}if(!d&c>>>0>63|d>>>0>0){continue}break}}if(c|d){g=0;f=0;while(1){e=g;j[(e+a|0)+40|0]=m[b+e|0];e=e+1|0;if(e>>>0<1){f=f+1|0}g=e;if((c|0)!=(e|0)|(d|0)!=(f|0)){continue}break}}ea(i,288)}J=i+288|0;return 0}function Yk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=J-336|0;J=d;e=-1;if(!Xk(c)){e=0;while(1){j[a+e|0]=m[b+e|0];e=e+1|0;if((e|0)!=32){continue}break}j[a|0]=m[a|0]&248;j[a+31|0]=m[a+31|0]&63|64;Va(d+288|0,c);wa(d+240|0);jb(d+192|0);Ba(d+144|0,d+288|0);wa(d+96|0);c=254;b=0;while(1){e=b;f=c;b=m[(c>>>3|0)+a|0]>>>(c&7)&1;e=e^b;nc(d+240|0,d+144|0,e);nc(d+192|0,d+96|0,e);c=c+ -1|0;oa(d+48|0,d+144|0,d+96|0);oa(d,d+240|0,d+192|0);la(d+240|0,d+240|0,d+192|0);la(d+192|0,d+144|0,d+96|0);ca(d+96|0,d+48|0,d+240|0);ca(d+192|0,d+192|0,d);ha(d+48|0,d);ha(d,d+240|0);la(d+144|0,d+96|0,d+192|0);oa(d+192|0,d+96|0,d+192|0);ca(d+240|0,d,d+48|0);oa(d,d,d+48|0);ha(d+192|0,d+192|0);Wk(d+96|0,d);ha(d+144|0,d+144|0);la(d+48|0,d+48|0,d+96|0);ca(d+96|0,d+288|0,d+192|0);ca(d+192|0,d,d+48|0);if(f){continue}break}nc(d+240|0,d+144|0,b);nc(d+192|0,d+96|0,b);vb(d+192|0,d+192|0);ca(d+240|0,d+240|0,d+192|0);Ua(a,d+240|0);e=0}J=d+336|0;return e|0}function mg(a,b,c){var d=0,e=0;d=J;e=d;d=d-448&-64;J=d;if(!(!a|!b)){yb(d- -64|0,0,0,64);ga(d+60|0,l[b+48>>2]);za(d- -64|0,d+60|0,4,0);ga(d+60|0,l[b+4>>2]);za(d- -64|0,d+60|0,4,0);ga(d+60|0,l[b+44>>2]);za(d- -64|0,d+60|0,4,0);ga(d+60|0,l[b+40>>2]);za(d- -64|0,d+60|0,4,0);ga(d+60|0,19);za(d- -64|0,d+60|0,4,0);ga(d+60|0,c);za(d- -64|0,d+60|0,4,0);ga(d+60|0,l[b+12>>2]);za(d- -64|0,d+60|0,4,0);c=l[b+8>>2];a:{if(!c){break a}za(d- -64|0,c,l[b+12>>2],0);if(!(j[b+56|0]&1)){break a}ea(l[b+8>>2],l[b+12>>2]);l[b+12>>2]=0}ga(d+60|0,l[b+20>>2]);za(d- -64|0,d+60|0,4,0);c=l[b+16>>2];if(c){za(d- -64|0,c,l[b+20>>2],0)}ga(d+60|0,l[b+28>>2]);za(d- -64|0,d+60|0,4,0);c=l[b+24>>2];b:{if(!c){break b}za(d- -64|0,c,l[b+28>>2],0);if(!(m[b+56|0]&2)){break b}ea(l[b+24>>2],l[b+28>>2]);l[b+28>>2]=0}ga(d+60|0,l[b+36>>2]);za(d- -64|0,d+60|0,4,0);c=l[b+32>>2];if(c){za(d- -64|0,c,l[b+36>>2],0)}xb(d- -64|0,a,64)}J=e}function Di(a,b,c,d,e,f,g,h,i,k){var n=0,o=0,p=0,q=0,r=0,s=0;n=J-352|0;J=n;if(c){l[c>>2]=0;l[c+4>>2]=0}if(d){j[d|0]=255}s=-1;a:{b:{if(!g&f>>>0<17|g>>>0<0){break b}o=g+ -1|0;p=f+ -17|0;if(p>>>0<4294967279){o=o+1|0}q=p;p=o;if(!o&q>>>0>=4294967279|o>>>0>0){break a}r=a+32|0;qb(n+32|0,64,0,r,a);Ia(n+96|0,n+32|0);ea(n+32|0,64);ja(n+96|0,h,i,k);ja(n+96|0,36576,0-i&15,0);na(n+32|0,0,64);j[n+32|0]=m[e|0];hb(n+32|0,n+32|0,64,0,r,1,a);h=m[n+32|0];j[n+32|0]=m[e|0];ja(n+96|0,n+32|0,64,0);e=e+1|0;ja(n+96|0,e,q,p);o=f+ -1|0;ja(n+96|0,36576,o&15,0);qa(n+24|0,i,k);ja(n+96|0,n+24|0,8,0);i=n+24|0;o=g;f=f+47|0;if(f>>>0<47){o=o+1|0}qa(i,f,o);ja(n+96|0,n+24|0,8,0);Ha(n+96|0,n);ea(n+96|0,256);if(fb(n,e+q|0,16)){ea(n,16);break b}hb(b,e,q,p,r,2,a);ge(a+36|0,n);zf(r);c:{if(!(h&2)){if(!Ya(r,4)){break c}}zc(a)}if(c){l[c>>2]=q;l[c+4>>2]=p}s=0;if(!d){break b}j[d|0]=h}J=n+352|0;return s}ra();A()}function dl(a,b){var c=0;c=J-736|0;J=c;ub(c+704|0,b);va(c+224|0,b,c+704|0);va(c+672|0,b,c+224|0);ub(c+640|0,c+672|0);va(c+416|0,c+704|0,c+640|0);va(c+320|0,b,c+416|0);ub(c+608|0,c+640|0);ub(c+288|0,c+320|0);va(c+576|0,c+416|0,c+288|0);va(c+448|0,c+608|0,c+288|0);ub(c+544|0,c+576|0);va(c+384|0,c+608|0,c+544|0);va(c+352|0,c+224|0,c+384|0);va(c+192|0,c+608|0,c+352|0);va(c+160|0,c+672|0,c+192|0);va(c+96|0,c+672|0,c+160|0);va(c+512|0,c+544|0,c+352|0);va(c+480|0,c+672|0,c+512|0);va(c+256|0,c+448|0,c+480|0);va(c+128|0,c+288|0,c+256|0);va(c- -64|0,c+384|0,c+480|0);va(c+32|0,c+672|0,c- -64|0);va(c,c+416|0,c+32|0);va(a,c+320|0,c);Ga(a,126,c+352|0);Ga(a,9,c+704|0);va(a,a,c);Ga(a,7,c+160|0);Ga(a,9,c);Ga(a,11,c+256|0);Ga(a,8,c- -64|0);Ga(a,9,c+96|0);Ga(a,6,c+320|0);Ga(a,14,c+512|0);Ga(a,10,c+192|0);Ga(a,9,c+480|0);Ga(a,10,c);Ga(a,8,c+128|0);Ga(a,8,c+32|0);J=c+736|0}function zd(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,k=0;a:{h=l[a+56>>2];i=l[a+60>>2];if(h|i){e=h;f=16-e|0;e=0-((16<e>>>0)+i|0)|0;g=(d|0)==(e|0)&f>>>0>c>>>0|e>>>0>d>>>0;f=g?c:f;e=g?d:e;k=e;if(e|f){g=0;e=0;while(1){i=g+h|0;j[(a+i|0)- -64|0]=m[b+g|0];h=l[a+56>>2];i=l[a+60>>2];g=g+1|0;if(g>>>0<1){e=e+1|0}if((f|0)!=(g|0)|(e|0)!=(k|0)){continue}break}}e=i+k|0;i=f+h|0;if(i>>>0<f>>>0){e=e+1|0}h=i;l[a+56>>2]=h;l[a+60>>2]=e;if(!e&h>>>0<16|e>>>0<0){break a}qc(a,a- -64|0,16,0);l[a+56>>2]=0;l[a+60>>2]=0;e=c;c=e-f|0;d=d-((e>>>0<f>>>0)+k|0)|0;b=b+f|0}if(!d&c>>>0>=16|d>>>0>0){e=c&-16;qc(a,b,e,d);c=c&15;d=0;b=b+e|0}if(!(c|d)){break a}g=0;e=0;while(1){f=g;h=f+l[a+56>>2]|0;j[(a+h|0)- -64|0]=m[b+f|0];f=f+1|0;if(f>>>0<1){e=e+1|0}g=f;if((c|0)!=(f|0)|(d|0)!=(e|0)){continue}break}b=a;e=a;d=d+l[a+60>>2]|0;a=c+l[a+56>>2]|0;if(a>>>0<c>>>0){d=d+1|0}l[e+56>>2]=a;l[b+60>>2]=d}}function fl(a,b){var c=0,d=0;c=J-1760|0;J=c;sa(c+480|0,b);ab(c+320|0,b);ma(c,c+320|0);ta(c+320|0,c,c+480|0);ma(c+160|0,c+320|0);b=c+640|0;sa(b,c+160|0);ta(c+320|0,c,b);ma(c+160|0,c+320|0);b=c+800|0;sa(b,c+160|0);ta(c+320|0,c,b);ma(c+160|0,c+320|0);b=c+960|0;sa(b,c+160|0);ta(c+320|0,c,b);ma(c+160|0,c+320|0);b=c+1120|0;sa(b,c+160|0);ta(c+320|0,c,b);ma(c+160|0,c+320|0);b=c+1280|0;sa(b,c+160|0);ta(c+320|0,c,b);ma(c+160|0,c+320|0);b=c+1440|0;sa(b,c+160|0);ta(c+320|0,c,b);ma(c+160|0,c+320|0);sa(c+1600|0,c+160|0);sd(a);b=252;while(1){ab(c+320|0,a);d=b;b=j[b+34256|0];a:{if((b|0)>=1){ma(c+160|0,c+320|0);ta(c+320|0,c+160|0,(c+480|0)+r((b&254)>>>1|0,160)|0);break a}if((b|0)>-1){break a}ma(c+160|0,c+320|0);pc(c+320|0,c+160|0,(c+480|0)+r((b|0)/-2<<24>>24,160)|0)}ma(a,c+320|0);b=d+ -1|0;if(d){continue}break}J=c+1760|0}function nc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;n=l[b+4>>2];o=l[a+4>>2];p=l[b+8>>2];e=l[a+8>>2];q=l[b+12>>2];f=l[a+12>>2];r=l[b+16>>2];g=l[a+16>>2];s=l[b+20>>2];h=l[a+20>>2];t=l[b+24>>2];i=l[a+24>>2];u=l[b+28>>2];j=l[a+28>>2];v=l[b+32>>2];k=l[a+32>>2];w=l[b+36>>2];m=l[a+36>>2];c=0-c|0;x=l[b>>2];d=l[a>>2];y=c&(x^d);l[a>>2]=y^d;d=m;m=c&(m^w);l[a+36>>2]=d^m;d=k;k=c&(k^v);l[a+32>>2]=d^k;d=j;j=c&(j^u);l[a+28>>2]=d^j;d=i;i=c&(i^t);l[a+24>>2]=d^i;d=h;h=c&(h^s);l[a+20>>2]=d^h;d=g;g=c&(g^r);l[a+16>>2]=d^g;d=f;f=c&(f^q);l[a+12>>2]=d^f;d=e;e=c&(e^p);l[a+8>>2]=d^e;d=a;a=c&(n^o);l[d+4>>2]=a^o;l[b+36>>2]=m^w;l[b+32>>2]=k^v;l[b+28>>2]=j^u;l[b+24>>2]=i^t;l[b+20>>2]=h^s;l[b+16>>2]=g^r;l[b+12>>2]=f^q;l[b+8>>2]=e^p;l[b+4>>2]=a^n;l[b>>2]=x^y}function Sf(a,b){var c=0,d=0;c=J-672|0;J=c;wa(c+528|0);ha(c+480|0,b);ca(c+480|0,2176,c+480|0);la(c+240|0,c+480|0,c+528|0);ca(c+240|0,c+240|0,34560);wa(c+624|0);Sa(c+624|0,c+624|0);la(c+432|0,c+480|0,2128);ca(c+192|0,c+480|0,2128);oa(c+192|0,c+624|0,c+192|0);ca(c+192|0,c+192|0,c+432|0);d=od(c+384|0,c+240|0,c+192|0);ca(c+336|0,c+384|0,b);oc(c+336|0,c+336|0);Sa(c+336|0,c+336|0);b=1-d|0;Ca(c+384|0,c+336|0,b);Ca(c+624|0,c+480|0,b);oa(c+576|0,c+480|0,c+528|0);ca(c+576|0,c+576|0,c+624|0);ca(c+576|0,c+576|0,34608);oa(c+576|0,c+576|0,c+192|0);la(c+144|0,c+384|0,c+384|0);ca(c+144|0,c+144|0,c+192|0);ca(c+96|0,c+576|0,34656);ha(c+288|0,c+384|0);oa(c+48|0,c+528|0,c+288|0);la(c,c+528|0,c+288|0);ca(a,c+144|0,c);ca(a+40|0,c+48|0,c+96|0);ca(a+80|0,c+96|0,c);ca(a+120|0,c+144|0,c+48|0);J=c+672|0}function wh(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,n=0;a:{if(!a){break a}b:{c:{if(l[a+36>>2]!=2){break c}d=l[b>>2];if(m[b+8|0]<2?!d:0){break c}k=l[a+4>>2];n=0;break b}k=l[a+4>>2];sh(a,b,k);d=l[b>>2];n=1}h=d;d=m[b+8|0];f=!(h|d)<<1;c=l[a+20>>2];if(f>>>0>=c>>>0){break a}e=l[a+24>>2];d=(r(e,l[b+4>>2])+f|0)+r(c,d)|0;c=d+((d>>>0)%(e>>>0)|0?-1:e+ -1|0)|0;while(1){e=((d>>>0)%(e>>>0)|0)==1?d+ -1|0:c;c=n?(f<<3)+k|0:l[l[a>>2]+4>>2]+(e<<10)|0;g=l[c+4>>2];i=l[c>>2];c=l[a+28>>2];l[b+12>>2]=f;c=(g>>>0)%(c>>>0)|0;g=l[b+4>>2];j=m[b+8|0]?c:g;h=j;j=l[b>>2];h=j?c:h;c=l[l[a>>2]+4>>2];g=((r(h,l[a+24>>2])<<10)+c|0)+(ih(a,b,i,!0&(g|0)==(h|0))<<10)|0;i=c+(e<<10)|0;c=c+(d<<10)|0;d:{if(j){tc(i,g,c);break d}Zg(i,g,c)}f=f+1|0;if(f>>>0>=o[a+20>>2]){break a}d=d+1|0;c=e+1|0;e=l[a+24>>2];continue}}}function dk(a,b,c,d,e){var f=0,g=0;f=J-96|0;J=f;g=-1;if(!bc(f+32|0,f)){Zb(f- -64|0,f+32|0,e);g=nf(a+32|0,b,c,d,f- -64|0,e,f);b=l[f+60>>2];c=l[f+56>>2];j[a+24|0]=c;j[a+25|0]=c>>>8;j[a+26|0]=c>>>16;j[a+27|0]=c>>>24;j[a+28|0]=b;j[a+29|0]=b>>>8;j[a+30|0]=b>>>16;j[a+31|0]=b>>>24;b=l[f+52>>2];c=l[f+48>>2];j[a+16|0]=c;j[a+17|0]=c>>>8;j[a+18|0]=c>>>16;j[a+19|0]=c>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;b=l[f+44>>2];c=l[f+40>>2];j[a+8|0]=c;j[a+9|0]=c>>>8;j[a+10|0]=c>>>16;j[a+11|0]=c>>>24;j[a+12|0]=b;j[a+13|0]=b>>>8;j[a+14|0]=b>>>16;j[a+15|0]=b>>>24;b=l[f+36>>2];c=l[f+32>>2];j[a|0]=c;j[a+1|0]=c>>>8;j[a+2|0]=c>>>16;j[a+3|0]=c>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;ea(f,32);ea(f+32|0,32);ea(f- -64|0,24)}J=f+96|0;return g}function Zj(a,b,c,d,e){var f=0,g=0;f=J-96|0;J=f;g=-1;if(!pf(f+32|0,f)){Zb(f- -64|0,f+32|0,e);g=ff(a+32|0,b,c,d,f- -64|0,e,f);b=l[f+60>>2];c=l[f+56>>2];j[a+24|0]=c;j[a+25|0]=c>>>8;j[a+26|0]=c>>>16;j[a+27|0]=c>>>24;j[a+28|0]=b;j[a+29|0]=b>>>8;j[a+30|0]=b>>>16;j[a+31|0]=b>>>24;b=l[f+52>>2];c=l[f+48>>2];j[a+16|0]=c;j[a+17|0]=c>>>8;j[a+18|0]=c>>>16;j[a+19|0]=c>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;b=l[f+44>>2];c=l[f+40>>2];j[a+8|0]=c;j[a+9|0]=c>>>8;j[a+10|0]=c>>>16;j[a+11|0]=c>>>24;j[a+12|0]=b;j[a+13|0]=b>>>8;j[a+14|0]=b>>>16;j[a+15|0]=b>>>24;b=l[f+36>>2];c=l[f+32>>2];j[a|0]=c;j[a+1|0]=c>>>8;j[a+2|0]=c>>>16;j[a+3|0]=c>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;ea(f,32);ea(f+32|0,32);ea(f- -64|0,24)}J=f+96|0;return g}function Bc(a,b,c,d,e,f){var g=0,h=0,i=0,j=0;l[f>>2]=8;g=a;a=!b&a>>>0>32768|b>>>0>0;g=a?g:32768;i=a?b:0;a=i;a:{if(!a&g>>>0>=c>>>5>>>0|a>>>0>0){l[d>>2]=1;j=c>>>11|0;a=1;b=0;while(1){b:{if(!(32<=(a&63)>>>0?0:j>>>(a&31)|0)){c=a;break b}a=a+1|0;if(a>>>0<1){b=b+1|0}l[d>>2]=a;c=63;if((a|0)!=63|b){continue}}break}b=i>>>2|0;d=(i&3)<<30|g>>>2;a=c&31;if(32<=(c&63)>>>0){a=b>>>a|0}else{h=b>>>a|0;a=((1<<a)-1&b)<<32-a|d>>>a}l[e>>2]=((!h&a>>>0<1073741823|h>>>0<0?a:1073741823)>>>0)/o[f>>2];break a}l[e>>2]=1;a=l[f>>2];l[d>>2]=1;a=pl(g,i,a<<2);b=K;c=b>>>1|0;i=(b&1)<<31|a>>>1;a=1;b=0;while(1){e=c;g=i;h=a&31;if(32<=(a&63)>>>0){f=0;e=e>>>h|0}else{f=e>>>h|0;e=((1<<h)-1&e)<<32-h|g>>>h}if(!(e|f)){break a}a=a+1|0;if(a>>>0<1){b=b+1|0}l[d>>2]=a;if((a|0)!=63|b){continue}break}}}function Ad(a,b){var c=0;l[a>>2]=(m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24))&67108863;l[a+4>>2]=(m[b+3|0]|m[b+4|0]<<8|(m[b+5|0]<<16|m[b+6|0]<<24))>>>2&67108611;l[a+8>>2]=(m[b+6|0]|m[b+7|0]<<8|(m[b+8|0]<<16|m[b+9|0]<<24))>>>4&67092735;l[a+12>>2]=(m[b+9|0]|m[b+10|0]<<8|(m[b+11|0]<<16|m[b+12|0]<<24))>>>6&66076671;c=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);l[a+20>>2]=0;l[a+24>>2]=0;l[a+28>>2]=0;l[a+32>>2]=0;l[a+36>>2]=0;l[a+16>>2]=c>>>8&1048575;l[a+40>>2]=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);l[a+44>>2]=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);l[a+48>>2]=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);b=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24);j[a+80|0]=0;l[a+56>>2]=0;l[a+60>>2]=0;l[a+52>>2]=b}function ob(a,b,c){var d=0;a:{if((a|0)==(b|0)){break a}if((b-a|0)-c>>>0<=0-(c<<1)>>>0){return pa(a,b,c)}d=(a^b)&3;b:{c:{if(a>>>0<b>>>0){if(d){d=a;break b}if(!(a&3)){d=a;break c}d=a;while(1){if(!c){break a}j[d|0]=m[b|0];b=b+1|0;c=c+ -1|0;d=d+1|0;if(d&3){continue}break}break c}d:{if(d){break d}if(a+c&3){while(1){if(!c){break a}c=c+ -1|0;d=c+a|0;j[d|0]=m[b+c|0];if(d&3){continue}break}}if(c>>>0<=3){break d}while(1){c=c+ -4|0;l[c+a>>2]=l[b+c>>2];if(c>>>0>3){continue}break}}if(!c){break a}while(1){c=c+ -1|0;j[c+a|0]=m[b+c|0];if(c){continue}break}break a}if(c>>>0<=3){break b}while(1){l[d>>2]=l[b>>2];b=b+4|0;d=d+4|0;c=c+ -4|0;if(c>>>0>3){continue}break}}if(!c){break a}while(1){j[d|0]=m[b|0];d=d+1|0;b=b+1|0;c=c+ -1|0;if(c){continue}break}}return a}function zb(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,k=0;a:{if(!(c|d)){break a}k=a+224|0;g=a+96|0;e=m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24);while(1){h=(a+e|0)+96|0;f=256-e|0;i=f;if(!d&c>>>0<=f>>>0|d>>>0<0){pa(h,b,c);b=c+(m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24))|0;j[a+352|0]=b;j[a+353|0]=b>>>8;j[a+354|0]=b>>>16;j[a+355|0]=b>>>24;break a}pa(h,b,f);e=(m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24))+f|0;j[a+352|0]=e;j[a+353|0]=e>>>8;j[a+354|0]=e>>>16;j[a+355|0]=e>>>24;Gc(a,128);Yc(a,g);pa(g,k,128);e=(m[a+352|0]|m[a+353|0]<<8|(m[a+354|0]<<16|m[a+355|0]<<24))+ -128|0;j[a+352|0]=e;j[a+353|0]=e>>>8;j[a+354|0]=e>>>16;j[a+355|0]=e>>>24;b=b+f|0;f=c;c=f-i|0;d=d-(f>>>0<i>>>0)|0;if(c|d){continue}break}}return 0}function ze(a,b,c,d,e,f,g,h,i,j,k){var m=0,n=0,p=0,q=0,s=0;n=ql(i,0,h,0);p=K;if(!p&n>>>0>=1073741824|p>>>0>0){l[9180]=22;return-1}if((g|0)==1&f>>>0>=0|g>>>0>1){l[9180]=22;return-1}n=rl(f,g);p=K;if(!(!p&n>>>0<2|p>>>0<0?!g&f>>>0>=2|g>>>0>0:0)){l[9180]=28;return-1}if(!(i?h:0)){l[9180]=28;return-1}a:{if(!(!g&33554431/(h>>>0)>>>0>=f>>>0|0>g>>>0?!(33554431/(i>>>0)>>>0<h>>>0|h>>>0>16777215):0)){break a}p=h<<7;n=r(p,i);s=r(f,p);m=n+s|0;if(m>>>0<n>>>0){break a}q=m+(h<<8|64)|0;if(q>>>0<m>>>0){break a}b:{if(o[a+8>>2]<q>>>0){m=-1;if(Ce(a)){break b}if(!_i(a,q)){break b}}m=d;d=l[a+4>>2];Ae(b,c,m,e,d,n);e=d+n|0;m=e+s|0;a=0;while(1){Zi(d+r(a,p)|0,h,f,g,e,m);a=a+1|0;if((i|0)!=(a|0)){continue}break}Ae(b,c,d,n,j,k);m=0}return m}l[9180]=48;return-1}function Ua(a,b){var c=0,d=0;d=J-48|0;J=d;eg(d,b);b=l[d>>2];j[a|0]=b;j[a+2|0]=b>>>16;j[a+1|0]=b>>>8;c=l[d+4>>2];j[a+5|0]=c>>>14;j[a+4|0]=c>>>6;j[a+3|0]=c<<2|b>>>24;b=l[d+8>>2];j[a+8|0]=b>>>13;j[a+7|0]=b>>>5;j[a+6|0]=b<<3|c>>>22;c=l[d+12>>2];j[a+11|0]=c>>>11;j[a+10|0]=c>>>3;j[a+9|0]=c<<5|b>>>21;b=l[d+16>>2];j[a+15|0]=b>>>18;j[a+14|0]=b>>>10;j[a+13|0]=b>>>2;j[a+12|0]=b<<6|c>>>19;b=l[d+20>>2];j[a+16|0]=b;j[a+18|0]=b>>>16;j[a+17|0]=b>>>8;c=l[d+24>>2];j[a+21|0]=c>>>15;j[a+20|0]=c>>>7;j[a+19|0]=c<<1|b>>>24;b=l[d+28>>2];j[a+24|0]=b>>>13;j[a+23|0]=b>>>5;j[a+22|0]=b<<3|c>>>23;c=l[d+32>>2];j[a+27|0]=c>>>12;j[a+26|0]=c>>>4;j[a+25|0]=c<<4|b>>>21;b=l[d+36>>2];j[a+31|0]=b>>>18;j[a+30|0]=b>>>10;j[a+29|0]=b>>>2;j[a+28|0]=b<<6|c>>>20;J=d+48|0}function Zi(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,n=0,o=0,p=0,q=0;i=b<<5;if(i){while(1){h=g<<2;k=h+f|0;h=a+h|0;l[k>>2]=m[h|0]|m[h+1|0]<<8|(m[h+2|0]<<16|m[h+3|0]<<24);g=g+1|0;if((i|0)!=(g|0)){continue}break}}if(c|d){p=(b<<8)+f|0;h=(b<<7)+f|0;k=b<<7;while(1){g=n;xe((r(g,i)<<2)+e|0,f,k);Tb(f,h,p,b);xe((r(g|1,i)<<2)+e|0,h,k);Tb(h,f,p,b);g=j;j=n+2|0;if(j>>>0<2){g=g+1|0}n=j;j=g;if((d|0)==(g|0)&n>>>0<c>>>0|g>>>0<d>>>0){continue}break}j=b<<7;n=c+ -1|0;while(1){ve(f,(r(we(f,b)&n,i)<<2)+e|0,j);Tb(f,h,p,b);ve(h,(r(we(h,b)&n,i)<<2)+e|0,j);Tb(h,f,p,b);g=o;o=q+2|0;if(o>>>0<2){g=g+1|0}q=o;k=o;o=g;if((d|0)==(g|0)&k>>>0<c>>>0|g>>>0<d>>>0){continue}break}}if(i){g=0;while(1){b=g<<2;ga(b+a|0,l[b+f>>2]);g=g+1|0;if((i|0)!=(g|0)){continue}break}}}function sj(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,k=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;a:{if(!d){break a}b:{c:{d:while(1){i=h;while(1){e:{p=m[c+i|0];q=(p&223)+ -55&255;s=(q+65526^q+65520)>>>8|0;t=p^48;k=t+65526>>>8|0;if(!((s|k)&255)){k=1;if(!e|o&255){break c}if(Wb(e,p)){break e}h=i;break a}if(n>>>0>=b>>>0){l[9180]=68;k=0;break c}h=q&s|k&t;f:{if(!(o&255)){u=h<<4;break f}j[a+n|0]=h|u;n=n+1|0}o=o^-1;k=1;h=i+1|0;if(h>>>0<d>>>0){continue d}break b}o=0;i=i+1|0;if(i>>>0<d>>>0){continue}break}break}a=h+1|0;h=a>>>0<d>>>0?d:a;break a}h=i}if(o&255){l[9180]=28;r=-1;h=h+ -1|0;n=0;break a}if(k){break a}n=0;r=-1}g:{if(g){l[g>>2]=c+h;break g}if((d|0)==(h|0)){break g}l[9180]=28;r=-1}if(f){l[f>>2]=n}return r|0}function ui(a,b){a=a|0;b=b|0;var c=0,d=0;d=J+ -64|0;J=d;Fb(d,b,32,0);j[d|0]=m[d|0]&248;j[d+31|0]=m[d+31|0]&63|64;b=l[d+20>>2];c=l[d+16>>2];j[a+16|0]=c;j[a+17|0]=c>>>8;j[a+18|0]=c>>>16;j[a+19|0]=c>>>24;j[a+20|0]=b;j[a+21|0]=b>>>8;j[a+22|0]=b>>>16;j[a+23|0]=b>>>24;b=l[d+12>>2];c=l[d+8>>2];j[a+8|0]=c;j[a+9|0]=c>>>8;j[a+10|0]=c>>>16;j[a+11|0]=c>>>24;j[a+12|0]=b;j[a+13|0]=b>>>8;j[a+14|0]=b>>>16;j[a+15|0]=b>>>24;b=l[d+4>>2];c=l[d>>2];j[a|0]=c;j[a+1|0]=c>>>8;j[a+2|0]=c>>>16;j[a+3|0]=c>>>24;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24;b=l[d+28>>2];c=l[d+24>>2];j[a+24|0]=c;j[a+25|0]=c>>>8;j[a+26|0]=c>>>16;j[a+27|0]=c>>>24;j[a+28|0]=b;j[a+29|0]=b>>>8;j[a+30|0]=b>>>16;j[a+31|0]=b>>>24;ea(d,64);J=d- -64|0;return 0}function na(a,b,c){var d=0,e=0,f=0,g=0;a:{if(!c){break a}d=a+c|0;j[d+ -1|0]=b;j[a|0]=b;if(c>>>0<3){break a}j[d+ -2|0]=b;j[a+1|0]=b;j[d+ -3|0]=b;j[a+2|0]=b;if(c>>>0<7){break a}j[d+ -4|0]=b;j[a+3|0]=b;if(c>>>0<9){break a}d=0-a&3;e=d+a|0;b=r(b&255,16843009);l[e>>2]=b;c=c-d&-4;d=c+e|0;l[d+ -4>>2]=b;if(c>>>0<9){break a}l[e+8>>2]=b;l[e+4>>2]=b;l[d+ -8>>2]=b;l[d+ -12>>2]=b;if(c>>>0<25){break a}l[e+24>>2]=b;l[e+20>>2]=b;l[e+16>>2]=b;l[e+12>>2]=b;l[d+ -16>>2]=b;l[d+ -20>>2]=b;l[d+ -24>>2]=b;l[d+ -28>>2]=b;g=e&4|24;c=c-g|0;if(c>>>0<32){break a}d=b;f=b;b=e+g|0;while(1){l[b+24>>2]=f;l[b+28>>2]=d;l[b+16>>2]=f;l[b+20>>2]=d;l[b+8>>2]=f;l[b+12>>2]=d;l[b>>2]=f;l[b+4>>2]=d;b=b+32|0;c=c+ -32|0;if(c>>>0>31){continue}break}}return a}function Nb(a,b){var c=0,d=0,e=0,f=0,g=0;c=J-464|0;J=c;while(1){e=d<<1;g=m[b+d|0];j[e+(c+400|0)|0]=g&15;j[(c+400|0)+(e|1)|0]=g>>>4;d=d+1|0;if((d|0)!=32){continue}break}d=0;while(1){b=d;d=(c+400|0)+f|0;e=b+m[d|0]|0;b=e+8|0;j[d|0]=e-(b&240);d=b<<24>>28;f=f+1|0;if((f|0)!=63){continue}break}j[c+463|0]=m[c+463|0]+d;sd(a);d=1;while(1){Yf(c,d>>>1|0,j[(c+400|0)+d|0]);td(c+240|0,a,c);ma(a,c+240|0);b=d>>>0<62;d=d+2|0;if(b){continue}break}ab(c+240|0,a);Ra(c+120|0,c+240|0);La(c+240|0,c+120|0);Ra(c+120|0,c+240|0);La(c+240|0,c+120|0);Ra(c+120|0,c+240|0);La(c+240|0,c+120|0);ma(a,c+240|0);d=0;while(1){Yf(c,d>>>1|0,j[(c+400|0)+d|0]);td(c+240|0,a,c);ma(a,c+240|0);b=d>>>0<62;d=d+2|0;if(b){continue}break}J=c+464|0}function dd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=J+ -64|0;J=e;Fb(e,c,32,0);c=l[e+28>>2];d=l[e+24>>2];j[b+24|0]=d;j[b+25|0]=d>>>8;j[b+26|0]=d>>>16;j[b+27|0]=d>>>24;j[b+28|0]=c;j[b+29|0]=c>>>8;j[b+30|0]=c>>>16;j[b+31|0]=c>>>24;c=l[e+20>>2];d=l[e+16>>2];j[b+16|0]=d;j[b+17|0]=d>>>8;j[b+18|0]=d>>>16;j[b+19|0]=d>>>24;j[b+20|0]=c;j[b+21|0]=c>>>8;j[b+22|0]=c>>>16;j[b+23|0]=c>>>24;c=l[e+12>>2];d=l[e+8>>2];j[b+8|0]=d;j[b+9|0]=d>>>8;j[b+10|0]=d>>>16;j[b+11|0]=d>>>24;j[b+12|0]=c;j[b+13|0]=c>>>8;j[b+14|0]=c>>>16;j[b+15|0]=c>>>24;c=l[e+4>>2];d=l[e>>2];j[b|0]=d;j[b+1|0]=d>>>8;j[b+2|0]=d>>>16;j[b+3|0]=d>>>24;j[b+4|0]=c;j[b+5|0]=c>>>8;j[b+6|0]=c>>>16;j[b+7|0]=c>>>24;ea(e,64);a=lc(a,b);J=e- -64|0;return a|0}function Kb(a,b){var c=0,d=0,e=0,f=0;c=J-864|0;J=c;f=b+80|0;e=b+40|0;la(c+336|0,f,e);oa(c,f,e);ca(c+336|0,c+336|0,c);ca(c+288|0,b,e);ha(c+240|0,c+288|0);ca(c+240|0,c+336|0,c+240|0);wa(c+480|0);od(c+624|0,c+480|0,c+240|0);ca(c+816|0,c+624|0,c+336|0);ca(c+768|0,c+624|0,c+288|0);ca(c+48|0,c+816|0,c+768|0);d=b+120|0;ca(c+48|0,c+48|0,d);ca(c+576|0,b,2176);ca(c+528|0,e,2176);ca(c+672|0,c+816|0,3488);ca(c+384|0,d,c+48|0);d=kb(c+384|0);Ba(c+192|0,b);Ba(c+144|0,e);Ba(c+720|0,c+768|0);Ca(c+192|0,c+528|0,d);Ca(c+144|0,c+576|0,d);Ca(c+720|0,c+672|0,d);ca(c+96|0,c+192|0,c+48|0);Tf(c+144|0,c+144|0,kb(c+96|0));oa(c+432|0,f,c+144|0);ca(c+432|0,c+720|0,c+432|0);oc(c+432|0,c+432|0);Ua(a,c+432|0);J=c+864|0}function Vf(a,b,c){var d=0;d=J-832|0;J=d;ag(d+688|0,b);l[d+688>>2]=l[d+688>>2]+1;vb(d+688|0,d+688|0);Uf(d+640|0,d+688|0);Sa(d+640|0,d+640|0);ha(d+592|0,d+640|0);ca(d+544|0,d+640|0,d+592|0);la(d+784|0,d+544|0,d+640|0);Uf(d+592|0,d+592|0);la(d+784|0,d+592|0,d+784|0);b=bl(d+784|0);Sa(d+736|0,d+640|0);Ca(d+640|0,d+736|0,b);jb(d+592|0);Ca(d+592|0,34512,b);oa(d+640|0,d+640|0,d+592|0);wa(d+384|0);la(d+224|0,d+640|0,d+384|0);oa(d+48|0,d+640|0,d+384|0);vb(d+96|0,d+224|0);ca(d,d+48|0,d+96|0);Ua(a,d);j[a+31|0]=m[a+31|0]|c;if(lb(d+384|0,a)){F();A()}ab(d+224|0,d+384|0);Ra(d+96|0,d+224|0);La(d+224|0,d+96|0);Ra(d+96|0,d+224|0);La(d+224|0,d+96|0);ma(d+384|0,d+224|0);cb(a,d+384|0);J=d+832|0}function Rc(a,b){a=a|0;b=b|0;var c=0,d=0;c=J+ -64|0;J=c;b=pa(c,b,64);tb(b);c=l[b+28>>2];d=l[b+24>>2];j[a+24|0]=d;j[a+25|0]=d>>>8;j[a+26|0]=d>>>16;j[a+27|0]=d>>>24;j[a+28|0]=c;j[a+29|0]=c>>>8;j[a+30|0]=c>>>16;j[a+31|0]=c>>>24;c=l[b+20>>2];d=l[b+16>>2];j[a+16|0]=d;j[a+17|0]=d>>>8;j[a+18|0]=d>>>16;j[a+19|0]=d>>>24;j[a+20|0]=c;j[a+21|0]=c>>>8;j[a+22|0]=c>>>16;j[a+23|0]=c>>>24;c=l[b+12>>2];d=l[b+8>>2];j[a+8|0]=d;j[a+9|0]=d>>>8;j[a+10|0]=d>>>16;j[a+11|0]=d>>>24;j[a+12|0]=c;j[a+13|0]=c>>>8;j[a+14|0]=c>>>16;j[a+15|0]=c>>>24;c=l[b+4>>2];d=l[b>>2];j[a|0]=d;j[a+1|0]=d>>>8;j[a+2|0]=d>>>16;j[a+3|0]=d>>>24;j[a+4|0]=c;j[a+5|0]=c>>>8;j[a+6|0]=c>>>16;j[a+7|0]=c>>>24;ea(b,64);J=b- -64|0}function Ei(a,b,c,d,e,f,g,h,i,k){var n=0,o=0;n=J-336|0;J=n;if(c){l[c>>2]=0;l[c+4>>2]=0}if(!f&e>>>0<4294967279|f>>>0<0){o=a+32|0;qb(n+16|0,64,0,o,a);Ia(n+80|0,n+16|0);ea(n+16|0,64);ja(n+80|0,g,h,i);ja(n+80|0,36576,0-h&15,0);na(n+16|0,0,64);j[n+16|0]=k;hb(n+16|0,n+16|0,64,0,o,1,a);ja(n+80|0,n+16|0,64,0);j[b|0]=m[n+16|0];g=b+1|0;hb(g,d,e,f,o,2,a);ja(n+80|0,g,e,f);ja(n+80|0,36576,e&15,0);qa(n+8|0,h,i);ja(n+80|0,n+8|0,8,0);qa(n+8|0,e- -64|0,f-((e>>>0<4294967232)+ -1|0)|0);ja(n+80|0,n+8|0,8,0);b=e+g|0;Ha(n+80|0,b);ea(n+80|0,256);ge(a+36|0,b);zf(o);a:{if(!(k&2)){if(!Ya(o,4)){break a}}zc(a)}if(c){a=e+17|0;if(a>>>0<17){f=f+1|0}l[c>>2]=a;l[c+4>>2]=f}J=n+336|0;return 0}ra();A()}function Bf(a,b){a=a|0;b=b|0;var c=0,d=0;d=J+ -64|0;J=d;hd(a,d);c=l[d+28>>2];a=l[d+24>>2];j[b+24|0]=a;j[b+25|0]=a>>>8;j[b+26|0]=a>>>16;j[b+27|0]=a>>>24;j[b+28|0]=c;j[b+29|0]=c>>>8;j[b+30|0]=c>>>16;j[b+31|0]=c>>>24;c=l[d+20>>2];a=l[d+16>>2];j[b+16|0]=a;j[b+17|0]=a>>>8;j[b+18|0]=a>>>16;j[b+19|0]=a>>>24;j[b+20|0]=c;j[b+21|0]=c>>>8;j[b+22|0]=c>>>16;j[b+23|0]=c>>>24;c=l[d+12>>2];a=l[d+8>>2];j[b+8|0]=a;j[b+9|0]=a>>>8;j[b+10|0]=a>>>16;j[b+11|0]=a>>>24;j[b+12|0]=c;j[b+13|0]=c>>>8;j[b+14|0]=c>>>16;j[b+15|0]=c>>>24;c=l[d+4>>2];a=l[d>>2];j[b|0]=a;j[b+1|0]=a>>>8;j[b+2|0]=a>>>16;j[b+3|0]=a>>>24;j[b+4|0]=c;j[b+5|0]=c>>>8;j[b+6|0]=c>>>16;j[b+7|0]=c>>>24;J=d- -64|0;return 0}function Xc(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,m=0,n=0,o=0;h=J-352|0;J=h;pb(h,f,g,0);if(!(!e&c-a>>>0>=d>>>0|0>e>>>0|c>>>0<=a>>>0?!(!e&a-c>>>0<d>>>0|0<e>>>0?a>>>0>c>>>0:0):0)){c=ob(a,c,d)}l[h+56>>2]=0;l[h+60>>2]=0;l[h+48>>2]=0;l[h+52>>2]=0;l[h+40>>2]=0;l[h+44>>2]=0;l[h+32>>2]=0;l[h+36>>2]=0;i=!e&d>>>0>32|e>>>0>0;g=i?32:d;j=i?0:e;i=j;k=!(g|i);if(!k){pa(h- -64|0,c,g)}j=f+16|0;n=h+32|0;o=h+32|0;f=i;m=g+32|0;if(m>>>0<32){f=f+1|0}jc(n,o,m,f,j,h);Ia(h+96|0,h+32|0);if(!k){pa(a,h- -64|0,g)}ea(h+32|0,64);if(!e&d>>>0>=33|e>>>0>0){f=c+g|0;c=d;kc(a+g|0,f,c-g|0,e-(i+(c>>>0<g>>>0)|0)|0,j,1,0,h)}ea(h,32);ja(h+96|0,a,d,e);Ha(h+96|0,b);ea(h+96|0,256);J=h+352|0;return 0}\n\n\n\nfunction sh(a,b,c){var d=0,e=0,f=0,g=0;d=J-4096|0;J=d;Qb(d+3072|0);Qb(d+2048|0);a:{if(!a|!b){break a}l[d+2048>>2]=l[b>>2];l[d+2052>>2]=0;l[d+2056>>2]=l[b+4>>2];l[d+2060>>2]=0;l[d+2064>>2]=m[b+8|0];l[d+2068>>2]=0;l[d+2072>>2]=l[a+16>>2];l[d+2076>>2]=0;l[d+2080>>2]=l[a+8>>2];l[d+2084>>2]=0;l[d+2088>>2]=l[a+36>>2];l[d+2092>>2]=0;if(!l[a+20>>2]){break a}b=0;while(1){g=b&127;if(!g){e=l[d+2100>>2];f=l[d+2096>>2]+1|0;if(f>>>0<1){e=e+1|0}l[d+2096>>2]=f;l[d+2100>>2]=e;Qb(d);Qb(d+1024|0);tc(d+3072|0,d+2048|0,d);tc(d+3072|0,d,d+1024|0)}f=(d+1024|0)+(g<<3)|0;g=l[f+4>>2];e=(b<<3)+c|0;l[e>>2]=l[f>>2];l[e+4>>2]=g;b=b+1|0;if(b>>>0<o[a+20>>2]){continue}break}}J=d+4096|0}function bd(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,m=0,n=0,o=0;h=J-352|0;J=h;Pa(h,f,g,0);if(!(!e&c-a>>>0>=d>>>0|0>e>>>0|c>>>0<=a>>>0?!(!e&a-c>>>0<d>>>0|0<e>>>0?a>>>0>c>>>0:0):0)){c=ob(a,c,d)}l[h+56>>2]=0;l[h+60>>2]=0;l[h+48>>2]=0;l[h+52>>2]=0;l[h+40>>2]=0;l[h+44>>2]=0;l[h+32>>2]=0;l[h+36>>2]=0;i=!e&d>>>0>32|e>>>0>0;g=i?32:d;j=i?0:e;i=j;k=!(g|i);if(!k){pa(h- -64|0,c,g)}j=f+16|0;n=h+32|0;o=h+32|0;f=i;m=g+32|0;if(m>>>0<32){f=f+1|0}gc(n,o,m,f,j,h);Ia(h+96|0,h+32|0);if(!k){pa(a,h- -64|0,g)}ea(h+32|0,64);if(!e&d>>>0>=33|e>>>0>0){f=c+g|0;c=d;rb(a+g|0,f,c-g|0,e-(i+(c>>>0<g>>>0)|0)|0,j,1,0,h)}ea(h,32);ja(h+96|0,a,d,e);Ha(h+96|0,b);ea(h+96|0,256);J=h+352|0;return 0}function ad(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=J-96|0;J=h;Pa(h,f,g,0);j=f+16|0;Gb(h+32|0,32,0,j,h);f=-1;a:{b:{if(Ob(c,b,d,e,h+32|0)){break b}f=0;if(!a){break a}if(!(!e&a-b>>>0>=d>>>0|0>e>>>0|a>>>0<=b>>>0?!(!e&b-a>>>0<d>>>0|0<e>>>0?b>>>0>a>>>0:0):0)){b=ob(a,b,d)}f=!e&d>>>0>32|e>>>0>0;c=f?32:d;f=f?0:e;g=f;c:{if(!(c|f)){k=h+32|0;l=h+32|0;f=g;i=c+32|0;if(i>>>0<32){f=f+1|0}gc(k,l,i,f,j,h);break c}i=c;l=pa(h- -64|0,b,c);m=h+32|0;n=h+32|0;f=g;k=c+32|0;if(k>>>0<32){f=f+1|0}gc(m,n,k,f,j,h);pa(a,l,i)}f=0;if(!e&d>>>0<33|e>>>0<0){break b}i=a;a=c;rb(i+a|0,a+b|0,d-a|0,e-(g+(d>>>0<a>>>0)|0)|0,j,1,0,h)}ea(h,32)}J=h+96|0;return f}function Wc(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=J-96|0;J=h;pb(h,f,g,0);j=f+16|0;md(h+32|0,32,0,j,h);f=-1;a:{b:{if(Ob(c,b,d,e,h+32|0)){break b}f=0;if(!a){break a}if(!(!e&a-b>>>0>=d>>>0|0>e>>>0|a>>>0<=b>>>0?!(!e&b-a>>>0<d>>>0|0<e>>>0?b>>>0>a>>>0:0):0)){b=ob(a,b,d)}f=!e&d>>>0>32|e>>>0>0;c=f?32:d;f=f?0:e;g=f;c:{if(!(c|f)){k=h+32|0;l=h+32|0;f=g;i=c+32|0;if(i>>>0<32){f=f+1|0}jc(k,l,i,f,j,h);break c}i=c;l=pa(h- -64|0,b,c);m=h+32|0;n=h+32|0;f=g;k=c+32|0;if(k>>>0<32){f=f+1|0}jc(m,n,k,f,j,h);pa(a,l,i)}f=0;if(!e&d>>>0<33|e>>>0<0){break b}i=a;a=c;kc(i+a|0,a+b|0,d-a|0,e-(g+(d>>>0<a>>>0)|0)|0,j,1,0,h)}ea(h,32)}J=h+96|0;return f}function eg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=l[b+28>>2];f=l[b+24>>2];g=l[b+20>>2];h=l[b+16>>2];i=l[b+12>>2];j=l[b+8>>2];k=l[b+4>>2];c=l[b>>2];d=l[b+36>>2];b=l[b+32>>2];c=r(((e+(f+(g+(h+(i+(j+(k+(c+(r(d,19)+16777216>>>25|0)>>26)>>25)>>26)>>25)>>26)>>25)>>26)>>25)+b>>26)+d>>25,19)+c|0;l[a>>2]=c&67108863;c=k+(c>>26)|0;l[a+4>>2]=c&33554431;c=j+(c>>25)|0;l[a+8>>2]=c&67108863;c=i+(c>>26)|0;l[a+12>>2]=c&33554431;c=h+(c>>25)|0;l[a+16>>2]=c&67108863;c=g+(c>>26)|0;l[a+20>>2]=c&33554431;c=f+(c>>25)|0;l[a+24>>2]=c&67108863;c=e+(c>>26)|0;l[a+28>>2]=c&33554431;b=b+(c>>25)|0;l[a+32>>2]=b&67108863;l[a+36>>2]=d+(b>>26)&33554431}function tf(a,b,c,d,e,f){var g=0,h=0,i=0,k=0,l=0,m=0;g=J-32|0;J=g;i=-1;a:{if(!d&c>>>0<32|d>>>0<0){break a}wf(g,32,0,e,f);l=b+16|0;m=b+32|0;h=d+ -1|0;k=c+ -32|0;if(k>>>0<4294967264){h=h+1|0}if(Ob(l,m,k,h,g)){break a}ed(a,b,c,d,e,f);j[a+24|0]=0;j[a+25|0]=0;j[a+26|0]=0;j[a+27|0]=0;j[a+28|0]=0;j[a+29|0]=0;j[a+30|0]=0;j[a+31|0]=0;j[a+16|0]=0;j[a+17|0]=0;j[a+18|0]=0;j[a+19|0]=0;j[a+20|0]=0;j[a+21|0]=0;j[a+22|0]=0;j[a+23|0]=0;j[a+8|0]=0;j[a+9|0]=0;j[a+10|0]=0;j[a+11|0]=0;j[a+12|0]=0;j[a+13|0]=0;j[a+14|0]=0;j[a+15|0]=0;j[a|0]=0;j[a+1|0]=0;j[a+2|0]=0;j[a+3|0]=0;j[a+4|0]=0;j[a+5|0]=0;j[a+6|0]=0;j[a+7|0]=0;i=0}J=g+32|0;return i}function Gc(a,b){var c=0,d=0,e=0,f=0;e=m[a+68|0]|m[a+69|0]<<8|(m[a+70|0]<<16|m[a+71|0]<<24);d=e;f=m[a+64|0]|m[a+65|0]<<8|(m[a+66|0]<<16|m[a+67|0]<<24);c=b+f|0;if(c>>>0<f>>>0){d=d+1|0}j[a+64|0]=c;j[a+65|0]=c>>>8;j[a+66|0]=c>>>16;j[a+67|0]=c>>>24;j[a+68|0]=d;j[a+69|0]=d>>>8;j[a+70|0]=d>>>16;j[a+71|0]=d>>>24;b=m[a+76|0]|m[a+77|0]<<8|(m[a+78|0]<<16|m[a+79|0]<<24);d=(d|0)==(e|0)&c>>>0<f>>>0|d>>>0<e>>>0;c=d+(m[a+72|0]|m[a+73|0]<<8|(m[a+74|0]<<16|m[a+75|0]<<24))|0;if(c>>>0<d>>>0){b=b+1|0}j[a+72|0]=c;j[a+73|0]=c>>>8;j[a+74|0]=c>>>16;j[a+75|0]=c>>>24;j[a+76|0]=b;j[a+77|0]=b>>>8;j[a+78|0]=b>>>16;j[a+79|0]=b>>>24}function ic(a,b){l[a>>2]=1634760805;l[a+4>>2]=857760878;l[a+8>>2]=2036477234;l[a+12>>2]=1797285236;l[a+16>>2]=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);l[a+20>>2]=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);l[a+24>>2]=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);l[a+28>>2]=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);l[a+32>>2]=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);l[a+36>>2]=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);l[a+40>>2]=m[b+24|0]|m[b+25|0]<<8|(m[b+26|0]<<16|m[b+27|0]<<24);l[a+44>>2]=m[b+28|0]|m[b+29|0]<<8|(m[b+30|0]<<16|m[b+31|0]<<24)}function kg(a){var b=0,c=0,d=0,e=0,f=0,g=0;if(4294967168<=a>>>0){l[9180]=48;return 0}d=a>>>0<11?16:a+11&-8;a=Ma(d+76|0);if(!a){return 0}b=a+ -8|0;a:{if(!(a&63)){a=b;break a}f=a+ -4|0;g=l[f>>2];a=(a+63&-64)+ -8|0;a=a-b>>>0>15?a:a- -64|0;c=a-b|0;e=(g&-8)-c|0;if(!(g&3)){b=l[b>>2];l[a+4>>2]=e;l[a>>2]=b+c;break a}l[a+4>>2]=e|l[a+4>>2]&1|2;e=a+e|0;l[e+4>>2]=l[e+4>>2]|1;l[f>>2]=c|l[f>>2]&1|2;l[a+4>>2]=l[a+4>>2]|1;fg(b,c)}b=l[a+4>>2];b:{if(!(b&3)){break b}c=b&-8;if(c>>>0<=d+16>>>0){break b}l[a+4>>2]=d|b&1|2;b=a+d|0;d=c-d|0;l[b+4>>2]=d|3;c=a+c|0;l[c+4>>2]=l[c+4>>2]|1;fg(b,d)}return a+8|0}function bl(a){var b=0;b=J-464|0;J=b;ca(b+416|0,a,a);ca(b+368|0,a,b+416|0);ha(b+320|0,b+368|0);ha(b+320|0,b+320|0);ca(b+272|0,b+368|0,b+320|0);ha(b+224|0,b+272|0);ha(b+224|0,b+224|0);ha(b+224|0,b+224|0);ha(b+224|0,b+224|0);ca(b+176|0,b+272|0,b+224|0);Ba(b+128|0,b+176|0);bb(b+128|0,2,b+368|0);Ba(b+80|0,b+128|0);bb(b+128|0,10,b+80|0);bb(b+128|0,10,b+80|0);Ba(b+32|0,b+128|0);bb(b+128|0,30,b+32|0);Ba(b+32|0,b+128|0);bb(b+128|0,60,b+32|0);Ba(b+32|0,b+128|0);bb(b+128|0,120,b+32|0);bb(b+128|0,10,b+80|0);bb(b+128|0,3,b+368|0);ha(b+128|0,b+128|0);Ua(b,b+128|0);J=b+464|0;return j[b+1|0]&1}function bg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,k=0,l=0,n=0;while(1){j[a+c|0]=m[(c>>>3|0)+b|0]>>>(c&7)&1;c=c+1|0;if((c|0)!=256){continue}break}e=254;while(1){f=h;h=f+1|0;g=a+f|0;a:{if(!m[g|0]|f>>>0>254){break a}b=1;n=(e>>>0<5?e:5)+1|0;c=h;while(1){i=b;b=a+c|0;d=j[b|0];b:{if(!d){break b}k=j[g|0];d=d<<i;l=k+d|0;if((l|0)<=15){j[g|0]=l;j[b|0]=0;break b}b=k-d|0;if((b|0)<-15){break a}j[g|0]=b;while(1){b=a+c|0;if(!m[b|0]){j[b|0]=1;break b}j[b|0]=0;b=c>>>0<255;c=c+1|0;if(b){continue}break}}b=i+1|0;c=f+b|0;if((i|0)!=(n|0)){continue}break}}e=e+ -1|0;if((h|0)!=256){continue}break}}function sc(a){var b=0,c=0,d=0;if(!a){return-25}if(!l[a>>2]){return-1}a:{b=-2;b:{if(o[a+4>>2]<16){break b}if(!l[a+8>>2]){b=-18;if(l[a+12>>2]){break b}}c=l[a+20>>2];if(!l[a+16>>2]){break a}b=-6;if(c>>>0<8){break b}if(!l[a+24>>2]){b=-20;if(l[a+28>>2]){break b}}if(!l[a+32>>2]){b=-21;if(l[a+36>>2]){break b}}c=l[a+48>>2];if(!c){return-16}b=-17;if(c>>>0>16777215){break b}d=l[a+44>>2];b=-14;if(d>>>0<8){break b}b=-15;if(d>>>0>2097152){break b}b=-14;if(d>>>0<c<<3>>>0){break b}if(!l[a+40>>2]){return-12}a=l[a+52>>2];if(!a){return-28}b=a>>>0>16777215?-29:0}return b}return c?-19:-6}function jd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=J-192|0;J=d;if(c>>>0>=129){gb(a);Da(a,b,c,0);Oa(a,d);c=64;b=d}gb(a);na(d- -64|0,54,128);a:{if(!c){break a}j[d+64|0]=m[b|0]^54;e=1;if((c|0)==1){break a}while(1){f=(d- -64|0)+e|0;j[f|0]=m[f|0]^m[b+e|0];e=e+1|0;if((e|0)!=(c|0)){continue}break}}Da(a,d- -64|0,128,0);a=a+208|0;gb(a);na(d- -64|0,92,128);b:{if(!c){break b}j[d+64|0]=m[b|0]^92;e=1;if((c|0)==1){break b}while(1){f=(d- -64|0)+e|0;j[f|0]=m[f|0]^m[b+e|0];e=e+1|0;if((e|0)!=(c|0)){continue}break}}Da(a,d- -64|0,128,0);ea(d- -64|0,128);ea(d,64);J=d+192|0;return 0}function Ca(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;o=l[b+4>>2];d=l[a+4>>2];p=l[b+8>>2];e=l[a+8>>2];q=l[b+12>>2];f=l[a+12>>2];r=l[b+16>>2];g=l[a+16>>2];s=l[b+20>>2];h=l[a+20>>2];t=l[b+24>>2];i=l[a+24>>2];u=l[b+28>>2];j=l[a+28>>2];v=l[b+32>>2];k=l[a+32>>2];w=l[b+36>>2];m=l[a+36>>2];n=l[a>>2];x=l[b>>2]^n;b=0-c|0;l[a>>2]=n^x&b;l[a+36>>2]=b&(m^w)^m;l[a+32>>2]=b&(k^v)^k;l[a+28>>2]=b&(j^u)^j;l[a+24>>2]=b&(i^t)^i;l[a+20>>2]=b&(h^s)^h;l[a+16>>2]=b&(g^r)^g;l[a+12>>2]=b&(f^q)^f;l[a+8>>2]=b&(e^p)^e;l[a+4>>2]=b&(d^o)^d}function gd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=J-96|0;J=d;if(c>>>0>=65){Eb(a);eb(a,b,c,0);Db(a,d);c=32;b=d}Eb(a);na(d+32|0,54,64);a:{if(!c){break a}j[d+32|0]=m[b|0]^54;e=1;if((c|0)==1){break a}while(1){f=(d+32|0)+e|0;j[f|0]=m[f|0]^m[b+e|0];e=e+1|0;if((e|0)!=(c|0)){continue}break}}eb(a,d+32|0,64,0);a=a+104|0;Eb(a);na(d+32|0,92,64);b:{if(!c){break b}j[d+32|0]=m[b|0]^92;e=1;if((c|0)==1){break b}while(1){f=(d+32|0)+e|0;j[f|0]=m[f|0]^m[b+e|0];e=e+1|0;if((e|0)!=(c|0)){continue}break}}eb(a,d+32|0,64,0);ea(d+32|0,64);ea(d,32);J=d+96|0;return 0}function Re(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;e=J+ -64|0;J=e;na(e+8|0,0,52);f=Ja(a);l[e+20>>2]=f;l[e+36>>2]=f;l[e+4>>2]=f;g=Ma(f);l[e+32>>2]=g;h=Ma(f);l[e+16>>2]=h;i=Ma(f);l[e>>2]=i;a:{b:{if(!i|(!g|!h)){break b}f=Ma(f);if(!f){break b}a=Se(e,a,d);if(a){Aa(l[e+32>>2]);Aa(l[e+16>>2]);Aa(l[e>>2]);Aa(f);break a}a=0;b=Cb(l[e+40>>2],l[e+44>>2],l[e+52>>2],b,c,l[e+16>>2],l[e+20>>2],f,l[e+4>>2],0,0,d);Aa(l[e+32>>2]);Aa(l[e+16>>2]);c:{if(!b){if(!fb(f,l[e>>2],l[e+4>>2])){break c}}a=-35}Aa(f);Aa(l[e>>2]);break a}Aa(g);Aa(h);Aa(i);a=-22}J=e- -64|0;return a}function sb(a,b){var c=0,d=0,e=0;c=J-480|0;J=c;d=-1;a:{if(!$k(b)){break a}Va(c+336|0,b);ha(c+288|0,c+336|0);wa(c+240|0);oa(c+240|0,c+240|0,c+288|0);ha(c+144|0,c+240|0);wa(c+192|0);la(c+192|0,c+192|0,c+288|0);ha(c+96|0,c+192|0);ca(c+48|0,2128,c+144|0);Sa(c+48|0,c+48|0);oa(c+48|0,c+48|0,c+96|0);ca(c,c+48|0,c+96|0);wa(c+384|0);d=od(c+432|0,c+384|0,c);ca(a,c+432|0,c+192|0);b=a+40|0;ca(b,c+432|0,a);ca(b,b,c+48|0);ca(a,a,c+336|0);la(a,a,a);oc(a,a);ca(b,c+240|0,b);wa(a+80|0);e=a+120|0;ca(e,a,b);d=0-(kb(e)|1-d|Ta(b))|0}J=c+480|0;return d}function dg(a,b){var c=0,d=0,e=0;c=J-288|0;J=c;e=a+40|0;Va(e,b);d=a+80|0;wa(d);ha(c+240|0,e);ca(c+192|0,c+240|0,2128);oa(c+240|0,c+240|0,d);la(c+192|0,c+192|0,d);ha(c+144|0,c+192|0);ca(c+144|0,c+144|0,c+192|0);ha(a,c+144|0);ca(a,a,c+192|0);ca(a,a,c+240|0);ud(a,a);ca(a,a,c+144|0);ca(a,a,c+240|0);ha(c+96|0,a);ca(c+96|0,c+96|0,c+192|0);oa(c+48|0,c+96|0,c+240|0);a:{if(!Ta(c+48|0)){la(c,c+96|0,c+240|0);d=-1;if(!Ta(c)){break a}ca(a,a,2176)}if((kb(a)|0)==(m[b+31|0]>>>7|0)){Sa(a,a)}ca(a+120|0,a,e);d=0}J=c+288|0;return d}function pe(a,b,c,d,e){var f=0,g=0,h=0,i=0,k=0,m=0,n=0,o=0;f=J-48|0;J=f;g=se(d,f+12|0,f+8|0,f+4|0);a:{if(!g){break a}m=l[f+12>>2];h=$i(g,Ja(g)+1|0);b:{if(h){h=h-g|0;break b}h=Ja(g)}k=h+(g-d|0)|0;i=k+45|0;if(i>>>0>102|i>>>0<h>>>0){break a}i=a;n=b;a=m&31;if(32<=(m&63)>>>0){b=1<<a;a=0}else{b=(1<<a)-1&1>>>32-a;a=1<<a}if(ze(i,n,c,g,h,a,b,l[f+8>>2],l[f+4>>2],f+16|0,32)){break a}a=pa(e,d,k);b=a+k|0;j[b|0]=36;b=b+1|0;c=a+102|0;b=oe(b,c-b|0,f+16|0);ea(f+16|0,32);if(!b|b>>>0>=c>>>0){break a}j[b|0]=0;o=a}J=f+48|0;return o}function ye(a,b,c,d,e,f){var g=0;g=J-192|0;J=g;if(!(!c|(b+ -1&255)>>>0>=64|(d+ -1&255)>>>0>=64)){k[g+130>>1]=257;j[g+129|0]=d;j[g+128|0]=b;Xb(g+128|4);qa(g+128|8,0,0);l[g+152>>2]=0;l[g+156>>2]=0;l[g+144>>2]=0;l[g+148>>2]=0;a:{if(e){Te(g+128|0,e);break a}l[g+168>>2]=0;l[g+172>>2]=0;l[g+160>>2]=0;l[g+164>>2]=0}b:{if(f){Qe(g+128|0,f);break b}l[g+184>>2]=0;l[g+188>>2]=0;l[g+176>>2]=0;l[g+180>>2]=0}Yb(a,g+128|0);na(d+g|0,0,128-d|0);b=a;a=pa(g,c,d);zb(b,a,128,0);ea(a,128);J=a+192|0;return 0}ra();A()}function Te(a,b){var c=0,d=0;c=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);d=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);j[a+32|0]=d;j[a+33|0]=d>>>8;j[a+34|0]=d>>>16;j[a+35|0]=d>>>24;j[a+36|0]=c;j[a+37|0]=c>>>8;j[a+38|0]=c>>>16;j[a+39|0]=c>>>24;c=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);b=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);j[a+40|0]=b;j[a+41|0]=b>>>8;j[a+42|0]=b>>>16;j[a+43|0]=b>>>24;j[a+44|0]=c;j[a+45|0]=c>>>8;j[a+46|0]=c>>>16;j[a+47|0]=c>>>24}function Qe(a,b){var c=0,d=0;c=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);d=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);j[a+48|0]=d;j[a+49|0]=d>>>8;j[a+50|0]=d>>>16;j[a+51|0]=d>>>24;j[a+52|0]=c;j[a+53|0]=c>>>8;j[a+54|0]=c>>>16;j[a+55|0]=c>>>24;c=m[b+12|0]|m[b+13|0]<<8|(m[b+14|0]<<16|m[b+15|0]<<24);b=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24);j[a+56|0]=b;j[a+57|0]=b>>>8;j[a+58|0]=b>>>16;j[a+59|0]=b>>>24;j[a+60|0]=c;j[a+61|0]=c>>>8;j[a+62|0]=c>>>16;j[a+63|0]=c>>>24}function oa(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=l[c+4>>2];e=l[b+4>>2];f=l[c+8>>2];g=l[b+8>>2];h=l[c+12>>2];i=l[b+12>>2];j=l[c+16>>2];k=l[b+16>>2];m=l[c+20>>2];n=l[b+20>>2];o=l[c+24>>2];p=l[b+24>>2];q=l[c+28>>2];r=l[b+28>>2];s=l[c+32>>2];t=l[b+32>>2];u=l[c+36>>2];v=l[b+36>>2];l[a>>2]=l[b>>2]-l[c>>2];l[a+36>>2]=v-u;l[a+32>>2]=t-s;l[a+28>>2]=r-q;l[a+24>>2]=p-o;l[a+20>>2]=n-m;l[a+16>>2]=k-j;l[a+12>>2]=i-h;l[a+8>>2]=g-f;l[a+4>>2]=e-d}function la(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=l[c+4>>2];e=l[b+4>>2];f=l[c+8>>2];g=l[b+8>>2];h=l[c+12>>2];i=l[b+12>>2];j=l[c+16>>2];k=l[b+16>>2];m=l[c+20>>2];n=l[b+20>>2];o=l[c+24>>2];p=l[b+24>>2];q=l[c+28>>2];r=l[b+28>>2];s=l[c+32>>2];t=l[b+32>>2];u=l[c+36>>2];v=l[b+36>>2];l[a>>2]=l[c>>2]+l[b>>2];l[a+36>>2]=u+v;l[a+32>>2]=s+t;l[a+28>>2]=q+r;l[a+24>>2]=o+p;l[a+20>>2]=m+n;l[a+16>>2]=j+k;l[a+12>>2]=h+i;l[a+8>>2]=f+g;l[a+4>>2]=d+e}function Ae(a,b,c,d,e,f){var g=0,h=0;g=J-496|0;J=g;gd(g+288|0,a,b);cc(g+288|0,c,d,0);if(f){d=0;while(1){h=h+1|0;yf(g+76|0,h);pa(g+80|0,g+288|0,208);cc(g+80|0,g+76|0,4,0);fd(g+80|0,g+32|0);a=l[g+60>>2];l[g+24>>2]=l[g+56>>2];l[g+28>>2]=a;a=l[g+52>>2];l[g+16>>2]=l[g+48>>2];l[g+20>>2]=a;a=l[g+44>>2];l[g+8>>2]=l[g+40>>2];l[g+12>>2]=a;a=l[g+36>>2];l[g>>2]=l[g+32>>2];l[g+4>>2]=a;a=f-d|0;pa(d+e|0,g,a>>>0<32?a:32);d=h<<5;if(d>>>0<f>>>0){continue}break}}ea(g+288|0,208);J=g+496|0}function kk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;g=J-16|0;J=g;a:{b:{if(!d){i=-1;break b}f=d+ -1|0;c:{if(!(f&d)){h=c&f;break c}h=(c>>>0)%(d>>>0)|0}i=-1;f=f-h|0;if(f>>>0>=(c^-1)>>>0){break a}c=c+f|0;if(c>>>0>=e>>>0){break b}if(a){l[a>>2]=c+1}a=b+c|0;i=0;j[g+15|0]=0;b=d>>>0>1?d:1;d=0;while(1){c=a-d|0;e=c;h=m[c|0]&m[g+15|0];c=(d^f)+ -1>>>24|0;j[e|0]=h|c&128;j[g+15|0]=c|m[g+15|0];d=d+1|0;if((b|0)!=(d|0)){continue}break}}J=g+16|0;return i|0}ra();A()}function Xk(a){var b=0,c=0,d=0,e=0,f=0;c=J-16|0;j[c+11|0]=0;j[c+12|0]=0;j[c+13|0]=0;j[c+14|0]=0;l[c+8>>2]=0;while(1){e=m[a+d|0];b=0;while(1){f=(c+8|0)+b|0;j[f|0]=m[f|0]|e^m[((b<<5)+34704|0)+d|0];b=b+1|0;if((b|0)!=7){continue}break}d=d+1|0;if((d|0)!=31){continue}break}d=m[a+31|0]&127;a=0;b=0;while(1){e=(c+8|0)+b|0;j[e|0]=m[e|0]|d^m[(b<<5)+34735|0];b=b+1|0;if((b|0)!=7){continue}break}b=0;while(1){b=m[(c+8|0)+a|0]+ -1|b;a=a+1|0;if((a|0)!=7){continue}break}return b>>>8&1}function Lb(a){var b=0,c=0,d=0,e=0,f=0;c=J-16|0;j[c+11|0]=0;j[c+12|0]=0;j[c+13|0]=0;j[c+14|0]=0;l[c+8>>2]=0;while(1){e=m[a+d|0];b=0;while(1){f=(c+8|0)+b|0;j[f|0]=m[f|0]|e^m[((b<<5)+3232|0)+d|0];b=b+1|0;if((b|0)!=7){continue}break}d=d+1|0;if((d|0)!=31){continue}break}d=m[a+31|0]&127;a=0;b=0;while(1){e=(c+8|0)+b|0;j[e|0]=m[e|0]|d^m[(b<<5)+3263|0];b=b+1|0;if((b|0)!=7){continue}break}b=0;while(1){b=m[(c+8|0)+a|0]+ -1|b;a=a+1|0;if((a|0)!=7){continue}break}return b>>>8&1}function Yb(a,b){var c=0,d=0,e=0,f=0,g=0;na(pa(a,1952,64)- -64|0,0,293);while(1){c=f<<3;d=c+a|0;e=d;c=b+c|0;g=m[d|0]|m[d+1|0]<<8|(m[d+2|0]<<16|m[d+3|0]<<24);d=(m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24))^(m[d+4|0]|m[d+5|0]<<8|(m[d+6|0]<<16|m[d+7|0]<<24));c=(m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24))^g;j[e|0]=c;j[e+1|0]=c>>>8;j[e+2|0]=c>>>16;j[e+3|0]=c>>>24;j[e+4|0]=d;j[e+5|0]=d>>>8;j[e+6|0]=d>>>16;j[e+7|0]=d>>>24;f=f+1|0;if((f|0)!=8){continue}break}}function mj(a,b){var c=0,d=0,e=0,f=0,g=0;c=J-48|0;J=c;d=sc(a);a:{if(d){break a}d=-26;if(b+ -1>>>0>1){break a}f=l[a+44>>2];d=l[a+48>>2];l[c>>2]=0;e=l[a+40>>2];l[c+28>>2]=d;l[c+12>>2]=-1;l[c+8>>2]=e;e=d<<3;e=f>>>0<e>>>0?e:f;f=d<<2;d=(e>>>0)/(f>>>0)|0;l[c+20>>2]=d;l[c+24>>2]=d<<2;l[c+16>>2]=r(d,f);d=l[a+52>>2];l[c+36>>2]=b;l[c+32>>2]=d;d=og(c,a);if(d){break a}if(l[c+8>>2]){while(1){qg(c,g);g=g+1|0;if(g>>>0<o[c+8>>2]){continue}break}}tg(a,c);d=0}J=c+48|0;return d}function al(a,b){var c=0,d=0,e=0,f=0;c=J-160|0;J=c;f=m[b|0];while(1){e=b-d|0;j[(c+128|0)+d|0]=m[e+63|0];j[(c+96|0)+d|0]=m[e+31|0];d=d+1|0;if((d|0)!=32){continue}break}j[c+159|0]=m[c+159|0]&127;j[c+127|0]=m[c+127|0]&127;Va(c+48|0,c+128|0);Va(c,c+96|0);l[c+48>>2]=(l[c+48>>2]+(j[b+32|0]>>>7&19)|0)+r(l[c>>2],38);d=1;while(1){b=d<<2;e=b+(c+48|0)|0;l[e>>2]=l[e>>2]+r(l[b+c>>2],38);d=d+1|0;if((d|0)!=10){continue}break}eg(c+48|0,c+48|0);Vf(a,c+48|0,f&128);J=c+160|0}function ih(a,b,c,d){var f=0,g=0;a:{b:{c:{if(!l[b>>2]){g=m[b+8|0];f=l[b+12>>2]+ -1|0;if(!g){break b}g=r(g,l[a+20>>2]);b=l[b+12>>2];if(!d){break c}f=(b+g|0)+ -1|0;break b}g=l[a+24>>2];a=l[a+20>>2];f=l[b+12>>2];d=(g-a|0)+(d?f+ -1|0:f?0:-1)|0;b=m[b+8|0];f=0;if((b|0)==3){break a}f=r(a,b+1|0);break a}f=g-!b|0}d=f;g=l[a+24>>2];f=0}b=f;a=0;f=d+ -1|0;b=f+b|0;if(b>>>0<f>>>0){a=1}ql(c,0,c,0);ql(d,0,K,0);c=K;pl(b-c|0,a-(b>>>0<c>>>0)|0,g);a=e()|0;K=I()|0;return a}function lb(a,b){var c=0,d=0,e=0,f=0;c=J-336|0;J=c;e=a+40|0;Va(e,b);d=a+80|0;wa(d);ha(c+288|0,e);ca(c+240|0,c+288|0,2128);oa(c+288|0,c+288|0,d);la(c+240|0,c+240|0,d);ca(a,c+288|0,c+240|0);ud(a,a);ca(a,c+288|0,a);ha(c+192|0,a);ca(c+192|0,c+192|0,c+240|0);oa(c+144|0,c+192|0,c+288|0);la(c+96|0,c+192|0,c+288|0);d=Ta(c+144|0);f=Ta(c+96|0);ca(c,a,2176);Ca(a,c,1-d|0);Sa(c+48|0,a);Ca(a,c+48|0,kb(a)^m[b+31|0]>>>7);ca(a+120|0,a,e);J=c+336|0;return(d|f)+ -1|0}function Cb(a,b,c,d,e,f,g,h,i,j,k,m){var n=0,o=0;n=J+ -64|0;J=n;o=Ma(i);a:{if(!o){c=-22;break a}l[n+32>>2]=0;l[n+36>>2]=0;l[n+24>>2]=0;l[n+28>>2]=0;l[n+20>>2]=g;l[n+16>>2]=f;l[n+12>>2]=e;l[n+8>>2]=d;l[n+4>>2]=i;l[n>>2]=o;l[n+56>>2]=0;l[n+52>>2]=c;l[n+48>>2]=c;l[n+44>>2]=b;l[n+40>>2]=a;c=mj(n,m);b:{if(c){ea(o,i);break b}c:{if(!j|!k){break c}if(!nj(j,k,n,m)){break c}ea(o,i);ea(j,k);c=-31;break b}if(h){pa(h,o,i)}ea(o,i);c=0}Aa(o)}J=n- -64|0;return c}function uj(a,b){var c=0,d=0;a:{d=b&255;if(d){if(a&3){while(1){c=m[a|0];if(!c|(c|0)==(b&255)){break a}a=a+1|0;if(a&3){continue}break}}c=l[a>>2];b:{if((c^-1)&c+ -16843009&-2139062144){break b}d=r(d,16843009);while(1){c=c^d;if((c^-1)&c+ -16843009&-2139062144){break b}c=l[a+4>>2];a=a+4|0;if(!(c+ -16843009&(c^-1)&-2139062144)){continue}break}}while(1){c=a;d=m[c|0];if(d){a=c+1|0;if((d|0)!=(b&255)){continue}}break}return c}return Ja(a)+a|0}return a}function Je(a,b,c,d,e){var f=0,g=0,h=0;h=J+ -64|0;J=h;a:{b:{f=Ja(a);c:{if(!(f>>>0<128?!c&b>>>0<=4294967295|c>>>0<0:0)){l[9180]=28;break c}c=na(h,0,60);g=pg(f);if(g){break b}}a=-1;break a}l[c+32>>2]=0;l[c+36>>2]=0;l[c+8>>2]=g;l[c+16>>2]=g;l[c+20>>2]=f;l[c>>2]=g;l[c+12>>2]=f;l[c+24>>2]=0;l[c+28>>2]=0;l[c+4>>2]=f;d:{if(Se(c,a,e)){l[9180]=28;a=-1;break d}a=1;if((b|0)!=l[c+40>>2]){break d}a=l[c+44>>2]!=(d>>>10|0)}Aa(g)}J=h- -64|0;return a}function Ne(a,b,c,d,e,f,g,h,i,j,k){var m=0;m=a;a=b;m=na(m,0,b);a:{if((c|0)==1&b>>>0>=0|c>>>0>1){l[9180]=22;break a}if(!c&b>>>0<=15|c>>>0<0){l[9180]=28;break a}b=f|i;if(!(j>>>0<2147483649?!b&(e|h)>>>0<=4294967295|b>>>0<0:0)){l[9180]=22;break a}if(!(j>>>0>8191?!i&h>>>0>=3|i>>>0>0:0)){l[9180]=28;break a}if((d|0)==(m|0)){l[9180]=28;break a}if((k|0)==1){return Cb(h,j>>>10|0,1,d,e,g,16,m,a,0,0,1)?-1:0}l[9180]=28}return-1}function be(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;g=J-592|0;J=g;h=-1;i=a+32|0;a:{if(!Wf(i)){break a}if(Lb(a)){break a}if(!pd(e)){break a}if(Lb(e)){break a}if(dg(g+128|0,e)){break a}xc(g+384|0,f);Da(g+384|0,a,32,0);Da(g+384|0,e,32,0);Da(g+384|0,b,c,d);Oa(g+384|0,g+320|0);tb(g+320|0);kl(g+8|0,g+320|0,g+128|0,i);cb(g+288|0,g+8|0);h=(j=-1,k=Pb(g+288|0,a),l=(g+288|0)==(a|0),l?j:k)|fb(a,g+288|0,32)}J=g+592|0;return h}function zj(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=J;h=f;f=f-512&-64;J=f;g=a?a:b;if(g){a=-1;if(!Pc(f+96|0,d,e)){b=b?b:g;a=0;$b(f+128|0,0,0,64);Xa(f+128|0,f+96|0,32,0);ea(f+96|0,32);Xa(f+128|0,e,32,0);Xa(f+128|0,c,32,0);_b(f+128|0,f+32|0,64);ea(f+128|0,384);while(1){c=(f+32|0)+a|0;j[a+b|0]=m[c|0];j[a+g|0]=m[c+32|0];a=a+1|0;if((a|0)!=32){continue}break}ea(f+32|0,64);a=0}J=h;return a|0}ra();A()}function Aj(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=J;h=f;f=f-512&-64;J=f;g=a?a:b;if(g){a=-1;if(!Pc(f+96|0,d,e)){b=b?b:g;a=0;$b(f+128|0,0,0,64);Xa(f+128|0,f+96|0,32,0);ea(f+96|0,32);Xa(f+128|0,c,32,0);Xa(f+128|0,e,32,0);_b(f+128|0,f+32|0,64);ea(f+128|0,384);while(1){c=(f+32|0)+a|0;j[a+g|0]=m[c|0];j[a+b|0]=m[c+32|0];a=a+1|0;if((a|0)!=32){continue}break}ea(f+32|0,64);a=0}J=h;return a|0}ra();A()}function vl(a,b,c){var d=0,e=0,f=0,g=0,h=0;g=c&63;d=g&31;if(32<=g>>>0){e=-1<<d;h=0}else{e=(1<<d)-1&-1>>>32-d|-1<<d;h=-1<<d}h=h&a;d=b&e;f=g&31;if(32<=g>>>0){e=0;g=d>>>f|0}else{e=d>>>f|0;g=((1<<f)-1&d)<<32-f|h>>>f}h=e;d=0-c&63;f=d&31;if(32<=d>>>0){e=0;c=-1>>>f|0}else{e=-1>>>f|0;c=(1<<f)-1<<32-f|-1>>>f}a=c&a;b=b&e;e=d&31;if(32<=d>>>0){c=a<<e;a=0}else{c=(1<<e)-1&a>>>32-e|b<<e;a=a<<e}a=a|g;K=c|h;return a}\n\n\n\nfunction Si(a,b,c,d,e,f,g,h,i,j){var k=0,m=0;k=J-16|0;J=k;m=a;a=b;m=na(m,0,b);f=c|f;a:{if((f|0)==1&(b|e)>>>0>=0|f>>>0>1){l[9180]=22;a=-1;break a}if(!c&b>>>0>=16|c>>>0>0){Bc(h,i,j,k+12|0,k+8|0,k+4|0);if((d|0)==(m|0)){l[9180]=28;a=-1;break a}c=l[k+12>>2];b=c&31;if(32<=(c&63)>>>0){c=1<<b;b=0}else{c=(1<<b)-1&1>>>32-b;b=1<<b}a=ne(d,e,g,32,b,c,l[k+4>>2],l[k+8>>2],m,a);break a}l[9180]=28;a=-1}J=k+16|0;return a}function Fe(a,b,c,d,e,f,g,h,i,j,k){var m=0;m=a;a=b;m=na(m,0,b);a:{if((c|0)==1&b>>>0>=0|c>>>0>1){l[9180]=22;break a}if(!c&b>>>0<=15|c>>>0<0){l[9180]=28;break a}b=f|i;if(!(j>>>0<2147483649?!b&(e|h)>>>0<=4294967295|b>>>0<0:0)){l[9180]=22;break a}if(!(j>>>0>8191?!!(h|i):0)){l[9180]=28;break a}if((d|0)==(m|0)){l[9180]=28;break a}if((k|0)==2){return Cb(h,j>>>10|0,1,d,e,g,16,m,a,0,0,2)?-1:0}l[9180]=28}return-1}function tl(a,b,c){var d=0,e=0,f=0,g=0;g=c&63;f=g;d=f&31;if(32<=f>>>0){d=-1>>>d|0}else{e=-1>>>d|0;d=(1<<d)-1<<32-d|-1>>>d}f=d&a;d=b&e;e=g&31;if(32<=g>>>0){d=f<<e;g=0}else{d=(1<<e)-1&f>>>32-e|d<<e;g=f<<e}f=d;e=0-c&63;d=e;c=d&31;if(32<=d>>>0){d=-1<<c;c=0}else{d=(1<<c)-1&-1>>>32-c|-1<<c;c=-1<<c}a=c&a;d=b&d;b=e&31;if(32<=e>>>0){c=0;a=d>>>b|0}else{c=d>>>b|0;a=((1<<b)-1&d)<<32-b|a>>>b}a=a|g;K=c|f;return a}function Gi(a,b,c){a=a|0;b=b|0;c=c|0;Fa(b,24);Pa(a,b,c,0);Ac(a);c=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);b=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);j[a+44|0]=0;j[a+45|0]=0;j[a+46|0]=0;j[a+47|0]=0;j[a+48|0]=0;j[a+49|0]=0;j[a+50|0]=0;j[a+51|0]=0;j[a+36|0]=c;j[a+37|0]=c>>>8;j[a+38|0]=c>>>16;j[a+39|0]=c>>>24;j[a+40|0]=b;j[a+41|0]=b>>>8;j[a+42|0]=b>>>16;j[a+43|0]=b>>>24;return 0}function Kf(a,b,c,d,e,f,g,h,i,j){var k=0;k=J-352|0;J=k;qb(k+32|0,64,0,i,j);Ia(k+96|0,k+32|0);ea(k+32|0,64);ja(k+96|0,f,g,h);ja(k+96|0,34928,0-g&15,0);ja(k+96|0,b,c,d);ja(k+96|0,34928,0-c&15,0);qa(k+24|0,g,h);ja(k+96|0,k+24|0,8,0);qa(k+24|0,c,d);ja(k+96|0,k+24|0,8,0);Ha(k+96|0,k);ea(k+96|0,256);e=wb(k,e);ea(k,16);a:{if(!a){break a}if(e){na(a,0,c);e=-1;break a}hb(a,b,c,d,i,1,j);e=0}J=k+352|0;return e}function Dk(a,b,c,d,e,f,g,h,i,j){var k=0;k=J-352|0;J=k;ld(k+32|0,64,0,i,j);Ia(k+96|0,k+32|0);ea(k+32|0,64);ja(k+96|0,f,g,h);ja(k+96|0,34944,0-g&15,0);ja(k+96|0,b,c,d);ja(k+96|0,34944,0-c&15,0);qa(k+24|0,g,h);ja(k+96|0,k+24|0,8,0);qa(k+24|0,c,d);ja(k+96|0,k+24|0,8,0);Ha(k+96|0,k);ea(k+96|0,256);e=wb(k,e);ea(k,16);a:{if(!a){break a}if(e){na(a,0,c);e=-1;break a}kd(a,b,c,d,i,1,j);e=0}J=k+352|0;return e}function Fi(a,b,c){a=a|0;b=b|0;c=c|0;Pa(a,b,c,0);Ac(a);c=m[b+16|0]|m[b+17|0]<<8|(m[b+18|0]<<16|m[b+19|0]<<24);b=m[b+20|0]|m[b+21|0]<<8|(m[b+22|0]<<16|m[b+23|0]<<24);j[a+44|0]=0;j[a+45|0]=0;j[a+46|0]=0;j[a+47|0]=0;j[a+48|0]=0;j[a+49|0]=0;j[a+50|0]=0;j[a+51|0]=0;j[a+36|0]=c;j[a+37|0]=c>>>8;j[a+38|0]=c>>>16;j[a+39|0]=c>>>24;j[a+40|0]=b;j[a+41|0]=b>>>8;j[a+42|0]=b>>>16;j[a+43|0]=b>>>24;return 0}function We(a,b,c,d){var e=0;e=J+ -64|0;J=e;if((b+ -1&255)>>>0<64){j[e+3|0]=1;j[e+1|0]=256;j[e+2|0]=1;j[e|0]=b;Xb(e|4);qa(e|8,0,0);l[e+24>>2]=0;l[e+28>>2]=0;l[e+16>>2]=0;l[e+20>>2]=0;a:{if(c){Te(e,c);break a}l[e+40>>2]=0;l[e+44>>2]=0;l[e+32>>2]=0;l[e+36>>2]=0}b:{if(d){Qe(e,d);break b}l[e+56>>2]=0;l[e+60>>2]=0;l[e+48>>2]=0;l[e+52>>2]=0}Yb(a,e);J=e- -64|0;return 0}ra();A()}function _f(a,b,c){var d=0,e=0;d=J-160|0;J=d;e=Zf(c);wa(a);wa(a+40|0);wa(a+80|0);jb(a+120|0);c=c-((0-e&c)<<1)<<24>>24;$a(a,b,Ea(c,1));$a(a,b+160|0,Ea(c,2));$a(a,b+320|0,Ea(c,3));$a(a,b+480|0,Ea(c,4));$a(a,b+640|0,Ea(c,5));$a(a,b+800|0,Ea(c,6));$a(a,b+960|0,Ea(c,7));$a(a,b+1120|0,Ea(c,8));Ba(d,a+40|0);Ba(d+40|0,a);Ba(d+80|0,a+80|0);Sa(d+120|0,a+120|0);$a(a,d,e);J=d+160|0}function tg(a,b){var c=0,d=0,e=0;c=J-2048|0;J=c;if(!(!a|!b)){db(c+1024|0,(l[l[b>>2]+4>>2]+(l[b+24>>2]<<10)|0)+ -1024|0);if(o[b+28>>2]>=2){d=1;while(1){e=l[b+24>>2];mb(c+1024|0,(l[l[b>>2]+4>>2]+(e+r(d,e)<<10)|0)+ -1024|0);d=d+1|0;if(d>>>0<o[b+28>>2]){continue}break}}sg(c,c+1024|0);wc(l[a>>2],l[a+4>>2],c,1024);ea(c+1024|0,1024);ea(c,1024);Ed(b,l[a+56>>2])}J=c+2048|0}function od(a,b,c){var d=0,e=0;d=J-288|0;J=d;ha(d+240|0,c);ca(d+240|0,d+240|0,c);ha(a,d+240|0);ca(a,a,c);ca(a,a,b);ud(a,a);ca(a,a,d+240|0);ca(a,a,b);ha(d+192|0,a);ca(d+192|0,d+192|0,c);oa(d+144|0,d+192|0,b);la(d+96|0,d+192|0,b);ca(d+48|0,b,2176);la(d+48|0,d+192|0,d+48|0);c=Ta(d+144|0);b=Ta(d+96|0);e=Ta(d+48|0);ca(d,a,2176);Ca(a,d,b|e);oc(a,a);J=d+288|0;return b|c}function ng(a,b){var c=0,d=0,e=0;c=J-16|0;J=c;e=-22;a:{if(!a|!b){break a}d=b<<10;if(((d>>>0)/(b>>>0)|0)!=1024){break a}b=Ma(12);l[a>>2]=b;if(!b){break a}l[b>>2]=0;l[b+4>>2]=0;b=xd(c+12|0,d);l[9180]=b;b:{c:{if(b){l[c+12>>2]=0;break c}b=l[c+12>>2];if(b){break b}}Aa(l[a>>2]);l[a>>2]=0;break a}l[l[a>>2]>>2]=b;l[l[a>>2]+4>>2]=b;l[l[a>>2]+8>>2]=d;e=0}J=c+16|0;return e}function qg(a,b){var c=0,d=0,e=0,f=0;c=J-32|0;J=c;if(!(!a|!l[a+28>>2])){l[c+16>>2]=b;d=1;while(1){j[c+24|0]=e;b=0;f=0;if(d){while(1){l[c+28>>2]=0;d=l[c+28>>2];l[c+8>>2]=l[c+24>>2];l[c+12>>2]=d;l[c+20>>2]=b;d=l[c+20>>2];l[c>>2]=l[c+16>>2];l[c+4>>2]=d;wh(a,c);b=b+1|0;f=l[a+28>>2];if(b>>>0<f>>>0){continue}break}}d=f;e=e+1|0;if((e|0)!=4){continue}break}}J=c+32|0}function Mf(a,b,c,d,e,f,g,h,i,j,k){var m=0;m=J-336|0;J=m;qb(m+16|0,64,0,j,k);Ia(m+80|0,m+16|0);ea(m+16|0,64);ja(m+80|0,g,h,i);ja(m+80|0,34928,0-h&15,0);hb(a,d,e,f,j,1,k);ja(m+80|0,a,e,f);ja(m+80|0,34928,0-e&15,0);qa(m+8|0,h,i);ja(m+80|0,m+8|0,8,0);qa(m+8|0,e,f);ja(m+80|0,m+8|0,8,0);Ha(m+80|0,b);ea(m+80|0,256);if(c){l[c>>2]=16;l[c+4>>2]=0}J=m+336|0;return 0}function Ri(a,b,c,d,e,f,g){var h=0;h=J-128|0;J=h;a=na(a,0,102);a:{b:{if((d|0)==1&c>>>0>=0|d>>>0>1){l[9180]=22;break b}Bc(e,f,g,h+12|0,h+8|0,h+4|0);Fa(h+96|0,32);if(!Yi(l[h+12>>2],l[h+4>>2],l[h+8>>2],h+96|0,h+32|0)){l[9180]=28;break b}d=-1;if(Fc(h+16|0)){break a}a=pe(h+16|0,b,c,h+32|0,a);Ec(h+16|0);d=0;if(a){break a}l[9180]=28}d=-1}J=h+128|0;return d}function Lf(a,b,c,d,e,f,g,h,i,j){var k=0;k=J-352|0;J=k;Gb(k+32|0,64,0,i,j);Ia(k+96|0,k+32|0);ea(k+32|0,64);ja(k+96|0,f,g,h);qa(k+24|0,g,h);ja(k+96|0,k+24|0,8,0);ja(k+96|0,b,c,d);qa(k+24|0,c,d);ja(k+96|0,k+24|0,8,0);Ha(k+96|0,k);ea(k+96|0,256);e=wb(k,e);ea(k,16);a:{if(!a){break a}if(e){na(a,0,c);e=-1;break a}rb(a,b,c,d,i,1,0,j);e=0}J=k+352|0;return e}function uf(a,b,c,d,e,f){if(!d&c>>>0>=32|d>>>0>0){ed(a,b,c,d,e,f);e=a+16|0;f=a+32|0;b=d+ -1|0;c=c+ -32|0;if(c>>>0<4294967264){b=b+1|0}wd(e,f,c,b,a);j[a+8|0]=0;j[a+9|0]=0;j[a+10|0]=0;j[a+11|0]=0;j[a+12|0]=0;j[a+13|0]=0;j[a+14|0]=0;j[a+15|0]=0;j[a|0]=0;j[a+1|0]=0;j[a+2|0]=0;j[a+3|0]=0;j[a+4|0]=0;j[a+5|0]=0;j[a+6|0]=0;j[a+7|0]=0;a=0}else{a=-1}return a}function Fk(a,b,c,d,e,f,g,h,i,j,k){var m=0;m=J-336|0;J=m;ld(m+16|0,64,0,j,k);Ia(m+80|0,m+16|0);ea(m+16|0,64);ja(m+80|0,g,h,i);ja(m+80|0,34944,0-h&15,0);kd(a,d,e,f,j,1,k);ja(m+80|0,a,e,f);ja(m+80|0,34944,0-e&15,0);qa(m+8|0,h,i);ja(m+80|0,m+8|0,8,0);qa(m+8|0,e,f);ja(m+80|0,m+8|0,8,0);Ha(m+80|0,b);ea(m+80|0,256);if(c){l[c>>2]=16;l[c+4>>2]=0}J=m+336|0}function gl(a,b,c){var d=0,e=0;d=J-128|0;J=d;e=Zf(c);wa(a);wa(a+40|0);jb(a+80|0);c=c-((0-e&c)<<1)<<24>>24;_a(a,b,Ea(c,1));_a(a,b+120|0,Ea(c,2));_a(a,b+240|0,Ea(c,3));_a(a,b+360|0,Ea(c,4));_a(a,b+480|0,Ea(c,5));_a(a,b+600|0,Ea(c,6));_a(a,b+720|0,Ea(c,7));_a(a,b+840|0,Ea(c,8));Ba(d+8|0,a+40|0);Ba(d+48|0,a);Sa(d+88|0,a+80|0);_a(a,d+8|0,e);J=d+128|0}function si(a,b,c,d,e,f){var g=0;a:{b:{c:{if(!e&d>>>0<64|e>>>0<0){break c}e=e+ -1|0;d=d+ -64|0;if(d>>>0<4294967232){e=e+1|0}if(!e&d>>>0>4294967231|e>>>0>0){break c}g=c- -64|0;if(!ae(c,g,d,e,f)){break b}if(!a){break c}na(a,0,d)}c=-1;if(!b){break a}l[b>>2]=0;l[b+4>>2]=0;return-1}if(b){l[b>>2]=d;l[b+4>>2]=e}c=0;if(!a){break a}ob(a,g,d)}return c}function gk(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;e=J-16|0;l[e+12>>2]=0;if(d+ -1>>>0<c>>>0){f=c+ -1|0;j=f+b|0;c=0;b=0;while(1){g=m[j-c|0];i=((g^128)+ -1&(l[e+12>>2]+ -1&h+ -1))>>>8&1;l[e+12>>2]=l[e+12>>2]|0-i&c;b=b|i;h=h|g;c=c+1|0;if((d|0)!=(c|0)){continue}break}l[a>>2]=f-l[e+12>>2];a=b+ -1|0}else{a=-1}return a|0}function tj(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;if(!(d>>>0>2147483646|d<<1>>>0>=b>>>0)){b=0;if(d){while(1){e=b<<1;g=m[b+c|0];f=g>>>4|0;j[e+a|0]=(f+(f+65526>>>8&217)|0)+87;f=(e|1)+a|0;e=g&15;j[f|0]=((e<<8)+(e+65526&55552)|0)+22272>>>8;b=b+1|0;if((d|0)!=(b|0)){continue}break}b=d<<1}else{b=0}j[b+a|0]=0;return a|0}ra();A()}function Vb(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=m[a|0];a:{if((e+ -48&255)>>>0>9){break a}d=e;c=a;while(1){g=c;if(f>>>0>429496729){break a}c=(d&255)+ -48|0;d=r(f,10);if(c>>>0>(d^-1)>>>0){break a}f=c+d|0;c=g+1|0;d=m[c|0];if((d+ -48&255)>>>0<10){continue}break}if((a|0)==(c|0)|((e|0)==48?(a|0)!=(g|0):0)){break a}l[b>>2]=f;h=c}return h}function Fj(a,b,c,d,e,f){var g=0,h=0;g=J-32|0;J=g;h=m[e|0]|m[e+1|0]<<8|(m[e+2|0]<<16|m[e+3|0]<<24);e=m[e+4|0]|m[e+5|0]<<8|(m[e+6|0]<<16|m[e+7|0]<<24);l[g+24>>2]=0;l[g+28>>2]=0;l[g+16>>2]=h;l[g+20>>2]=e;qa(g,c,d);l[g+8>>2]=0;l[g+12>>2]=0;a:{if(b+ -16>>>0>=49){l[9180]=28;a=-1;break a}a=ce(a,b,0,0,0,f,32,g,g+16|0)}J=g+32|0;return a}function Ja(a){var b=0,c=0,d=0;a:{b:{b=a;if(!(b&3)){break b}if(!m[a|0]){return 0}while(1){b=b+1|0;if(!(b&3)){break b}if(m[b|0]){continue}break}break a}while(1){c=b;b=b+4|0;d=l[c>>2];if(!((d^-1)&d+ -16843009&-2139062144)){continue}break}if(!(d&255)){return c-a|0}while(1){d=m[c+1|0];b=c+1|0;c=b;if(d){continue}break}}return b-a|0}function Sa(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c=l[b+4>>2];d=l[b+8>>2];e=l[b+12>>2];f=l[b+16>>2];g=l[b+20>>2];h=l[b+24>>2];i=l[b+28>>2];j=l[b+32>>2];k=l[b+36>>2];l[a>>2]=0-l[b>>2];l[a+36>>2]=0-k;l[a+32>>2]=0-j;l[a+28>>2]=0-i;l[a+24>>2]=0-h;l[a+20>>2]=0-g;l[a+16>>2]=0-f;l[a+12>>2]=0-e;l[a+8>>2]=0-d;l[a+4>>2]=0-c}function lg(a,b){var c=0,d=0,e=0,f=0;c=J-1024|0;J=c;if(l[b+28>>2]){f=a+68|0;e=a- -64|0;while(1){ga(e,0);ga(f,d);wc(c,1024,a,72);Dd(l[l[b>>2]+4>>2]+(r(l[b+24>>2],d)<<10)|0,c);ga(e,1);wc(c,1024,a,72);Dd((l[l[b>>2]+4>>2]+(r(l[b+24>>2],d)<<10)|0)+1024|0,c);d=d+1|0;if(d>>>0<o[b+28>>2]){continue}break}}ea(c,1024);J=c+1024|0}function ke(a,b,c,d){var e=0,f=0;e=J-320|0;J=e;f=-1;a:{if(!pd(c)){break a}if(Lb(c)){break a}if(lb(e,c)){break a}if(!qd(e)){break a}c=0;while(1){j[a+c|0]=m[b+c|0];c=c+1|0;if((c|0)!=32){continue}break}if(d){je(a)}j[a+31|0]=m[a+31|0]&127;$f(e+160|0,a,e);cb(a,e+160|0);if(ie(a)){break a}f=Ya(b,32)?-1:0}J=e+320|0;return f}function Gf(a,b,c){var d=0,e=0,f=0,g=0;d=b<<8&16711680|b<<24;e=c<<24|b>>>8;f=e&65280;e=c<<8|b>>>24;d=e&255|f|d;b=((c&255)<<24|b>>>8)&-16777216|((c&16777215)<<8|b>>>24)&16711680|(c>>>8&65280|c>>>24)|g;j[a|0]=b;j[a+1|0]=b>>>8;j[a+2|0]=b>>>16;j[a+3|0]=b>>>24;b=d;j[a+4|0]=b;j[a+5|0]=b>>>8;j[a+6|0]=b>>>16;j[a+7|0]=b>>>24}function Yi(a,b,c,d,e){var f=0,g=0,h=0;g=ql(c,0,b,0);f=K;a:{if(!f&g>>>0>1073741823|f>>>0>0|a>>>0>63){break a}j[e|0]=14116;j[e+1|0]=55;j[e+2|0]=36;j[e+3|0]=m[a+36484|0];a=Cc(e+4|0,54,b,30);if(!a){break a}b=e+58|0;a=Cc(a,b-a|0,c,30);if(!a){break a}a=oe(a,b-a|0,d);if(!a|a>>>0>=b>>>0){break a}j[a|0]=0;h=e}return h}function aj(a){var b=0,c=0,d=0,e=0;b=65;c=36484;a:{if(m[36484]==(a&255)){break a}e=r(a&255,16843009);while(1){d=l[c>>2]^e;if((d^-1)&d+ -16843009&-2139062144){break a}c=c+4|0;b=b+ -4|0;if(b>>>0>3){continue}break}}if(b){a=a&255;while(1){if((a|0)==m[c|0]){return c}c=c+1|0;b=b+ -1|0;if(b){continue}break}}return 0}function Nf(a,b,c,d,e,f,g,h,i,j,k){var m=0;m=J-336|0;J=m;Gb(m+16|0,64,0,j,k);Ia(m+80|0,m+16|0);ea(m+16|0,64);ja(m+80|0,g,h,i);qa(m+8|0,h,i);ja(m+80|0,m+8|0,8,0);rb(a,d,e,f,j,1,0,k);ja(m+80|0,a,e,f);qa(m+8|0,e,f);ja(m+80|0,m+8|0,8,0);Ha(m+80|0,b);ea(m+80|0,256);if(c){l[c>>2]=16;l[c+4>>2]=0}J=m+336|0;return 0}function Rf(a,b,c){var d=0;d=a;a:{if(c){l[a+48>>2]=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);c=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);break a}l[a+48>>2]=0;c=0}l[d+52>>2]=c;l[a+56>>2]=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);l[a+60>>2]=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24)}function Ba(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;c=l[b+8>>2];d=l[b+12>>2];e=l[b+16>>2];f=l[b+20>>2];g=l[b+24>>2];h=l[b+28>>2];i=l[b>>2];j=l[b+4>>2];k=l[b+36>>2];l[a+32>>2]=l[b+32>>2];l[a+36>>2]=k;l[a+24>>2]=g;l[a+28>>2]=h;l[a+16>>2]=e;l[a+20>>2]=f;l[a+8>>2]=c;l[a+12>>2]=d;l[a>>2]=i;l[a+4>>2]=j}function zk(a){var b=0,c=0,d=0;b=m[a|0]|m[a+1|0]<<8|(m[a+2|0]<<16|m[a+3|0]<<24);a=m[a+4|0]|m[a+5|0]<<8|(m[a+6|0]<<16|m[a+7|0]<<24);c=a<<24|b>>>8;c=c&65280|(a<<8|b>>>24)&255|(b<<8&16711680|b<<24);a=((a&255)<<24|b>>>8)&-16777216|((a&16777215)<<8|b>>>24)&16711680|(a>>>8&65280|a>>>24)|d;K=c;return a}function Me(a,b,c,d,e,f,g){var h=0;h=J-16|0;J=h;a=na(a,0,128);d=d|f;a:{if(!(g>>>0<2147483649?!d&(c|e)>>>0<=4294967295|d>>>0<0:0)){l[9180]=22;a=-1;break a}if(!(g>>>0>8191?!f&e>>>0>=3|f>>>0>0:0)){l[9180]=28;a=-1;break a}Fa(h,16);a=Cb(e,g>>>10|0,1,b,c,h,16,0,32,a,128,1)?-1:0}J=h+16|0;return a}function Jf(a,b,c,d,e,f,g,h,i,j,k){var n=0;n=J-48|0;J=n;l[n+4>>2]=0;Pa(n+16|0,j,k,0);k=m[j+16|0]|m[j+17|0]<<8|(m[j+18|0]<<16|m[j+19|0]<<24);j=m[j+20|0]|m[j+21|0]<<8|(m[j+22|0]<<16|m[j+23|0]<<24);l[n+8>>2]=k;l[n+12>>2]=j;Fk(a,b,c,d,e,f,g,h,i,n+4|0,n+16|0);ea(n+16|0,32);J=n+48|0;return 0}function If(a,b,c,d,e,f,g,h,i,j){var k=0;k=J-48|0;J=k;l[k+4>>2]=0;Pa(k+16|0,i,j,0);j=m[i+16|0]|m[i+17|0]<<8|(m[i+18|0]<<16|m[i+19|0]<<24);i=m[i+20|0]|m[i+21|0]<<8|(m[i+22|0]<<16|m[i+23|0]<<24);l[k+8>>2]=j;l[k+12>>2]=i;a=Dk(a,b,c,d,e,f,g,h,k+4|0,k+16|0);ea(k+16|0,32);J=k+48|0;return a}function Oe(a,b,c,d){var e=0;e=J-192|0;J=e;if(!(!c|(b+ -1&255)>>>0>=64|(d+ -1&255)>>>0>=64)){k[e+130>>1]=257;j[e+129|0]=d;j[e+128|0]=b;Xb(e+128|4);qa(e+128|8,0,0);na(e+144|0,0,48);Yb(a,e+128|0);na(d+e|0,0,128-d|0);b=a;a=pa(e,c,d);zb(b,a,128,0);ea(a,128);J=a+192|0;return 0}ra();A()}function Ee(a,b,c,d,e,f,g){var h=0;h=J-16|0;J=h;a=na(a,0,128);d=d|f;a:{if(!(g>>>0<2147483649?!d&(c|e)>>>0<=4294967295|d>>>0<0:0)){l[9180]=22;a=-1;break a}if(!(g>>>0>8191?!!(e|f):0)){l[9180]=28;a=-1;break a}Fa(h,16);a=Cb(e,g>>>10|0,1,b,c,h,16,0,32,a,128,2)?-1:0}J=h+16|0;return a}function Pi(a,b,c,d){var e=0;e=J-32|0;J=e;Bc(b,c,d,e+28|0,e+20|0,e+12|0);a:{if((le(a)|0)!=101){l[9180]=28;a=-1;break a}if(!se(a,e+24|0,e+8|0,e+16|0)){l[9180]=28;a=-1;break a}a=1;if(l[e+28>>2]!=l[e+24>>2]|l[e+12>>2]!=l[e+8>>2]){break a}a=l[e+20>>2]!=l[e+16>>2]}J=e+32|0;return a}function Hk(a,b,c,d,e,f,g,h,i,j){var k=0,m=0,n=0;k=-1;if(!e&d>>>0>=16|e>>>0>0){m=a;n=c;a=e+ -1|0;k=d+ -16|0;if(k>>>0<4294967280){a=a+1|0}k=Lf(m,n,k,a,(c+d|0)+ -16|0,f,g,h,i,j)}if(b){f=b;a=e+ -1|0;c=d+ -16|0;if(c>>>0<4294967280){a=a+1|0}l[f>>2]=k?0:c;l[b+4>>2]=k?0:a}return k}function Gk(a,b,c,d,e,f,g,h,i,j){var k=0,m=0,n=0;k=-1;if(!e&d>>>0>=16|e>>>0>0){m=a;n=c;a=e+ -1|0;k=d+ -16|0;if(k>>>0<4294967280){a=a+1|0}k=Kf(m,n,k,a,(c+d|0)+ -16|0,f,g,h,i,j)}if(b){f=b;a=e+ -1|0;c=d+ -16|0;if(c>>>0<4294967280){a=a+1|0}l[f>>2]=k?0:c;l[b+4>>2]=k?0:a}return k}function Ck(a,b,c,d,e,f,g,h,i,j){var k=0,m=0,n=0;k=-1;if(!e&d>>>0>=16|e>>>0>0){m=a;n=c;a=e+ -1|0;k=d+ -16|0;if(k>>>0<4294967280){a=a+1|0}k=If(m,n,k,a,(c+d|0)+ -16|0,f,g,h,i,j)}if(b){f=b;a=e+ -1|0;c=d+ -16|0;if(c>>>0<4294967280){a=a+1|0}l[f>>2]=k?0:c;l[b+4>>2]=k?0:a}return k}function ti(a,b,c,d,e,f){var g=0,h=0;g=J-16|0;J=g;h=c;c=d;de(a,g+8|0,ob(a- -64|0,h,d),d,e,f);a:{if(l[g+8>>2]!=64|l[g+12>>2]){if(b){l[b>>2]=0;l[b+4>>2]=0}na(a,0,c- -64|0);a=-1;break a}a=0;if(!b){break a}l[b>>2]=d- -64;l[b+4>>2]=e-((d>>>0<4294967232)+ -1|0)}J=g+16|0;return a}function uk(a,b){var c=0,d=0,e=0,f=0;c=l[a+36>>2];e=l[a+32>>2];d=e>>>3&63;a:{if(d>>>0<=55){f=56-d|0;if(!f){break a}pa((a+d|0)+40|0,36096,f);break a}c=a+40|0;pa(c+d|0,36096,64-d|0);ec(a,c,b,b+256|0);na(c,0,56);e=l[a+32>>2];c=l[a+36>>2]}Gf(a+96|0,e,c);ec(a,a+40|0,b,b+256|0)}function Wj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=J-800|0;J=d;e=-1;a:{if(lb(d+640|0,b)){break a}if(!Mb(d+640|0)){break a}if(lb(d+480|0,c)){break a}if(!Mb(d+480|0)){break a}sa(d,d+480|0);ta(d+160|0,d+640|0,d);ma(d+320|0,d+160|0);cb(a,d+320|0);e=0}J=d+800|0;return e|0}function Vj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=J-800|0;J=d;e=-1;a:{if(lb(d+640|0,b)){break a}if(!Mb(d+640|0)){break a}if(lb(d+480|0,c)){break a}if(!Mb(d+480|0)){break a}sa(d,d+480|0);pc(d+160|0,d+640|0,d);ma(d+320|0,d+160|0);cb(a,d+320|0);e=0}J=d+800|0;return e|0}function Mb(a){var b=0;b=J-288|0;J=b;ha(b+240|0,a);ha(b+192|0,a+40|0);ha(b+144|0,a+80|0);oa(b+48|0,b+192|0,b+240|0);ca(b+48|0,b+48|0,b+144|0);ca(b,b+240|0,b+192|0);ca(b,b,2128);ha(b+96|0,b+144|0);la(b,b,b+96|0);oa(b+48|0,b+48|0,b);a=Ta(b+48|0);J=b+288|0;return a}function oj(a,b,c,d,e){var f=0,g=0,h=0;a:{if(!e){break a}f=l[c>>2];while(1){b:{c:{if(f>>>0>=b>>>0){l[9180]=68;break c}g=j[a+f|0];if((g|0)==61){e=e+ -1|0;break b}if(d){if(Wb(d,g)){break b}}l[9180]=28}h=-1;break a}f=f+1|0;l[c>>2]=f;if(e){continue}break}}return h}function Qf(a,b,c){l[a+48>>2]=c?m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24):0;l[a+52>>2]=m[b|0]|m[b+1|0]<<8|(m[b+2|0]<<16|m[b+3|0]<<24);l[a+56>>2]=m[b+4|0]|m[b+5|0]<<8|(m[b+6|0]<<16|m[b+7|0]<<24);l[a+60>>2]=m[b+8|0]|m[b+9|0]<<8|(m[b+10|0]<<16|m[b+11|0]<<24)}function vi(a,b){a=a|0;b=b|0;var c=0,d=0;c=J-256|0;J=c;d=-1;a:{if(Lb(b)){break a}if(dg(c+96|0,b)){break a}if(!qd(c+96|0)){break a}wa(c);b=c+136|0;oa(c,c,b);wa(c+48|0);la(c+48|0,c+48|0,b);vb(c,c);ca(c+48|0,c+48|0,c);Ua(a,c+48|0);d=0}J=c+256|0;return d|0}function oe(a,b,c){var d=0,e=0,f=0,g=0,h=0;while(1){f=0;d=0;if(e>>>0>=32){return a}while(1){a:{g=d+8|0;f=m[c+e|0]<<d|f;e=e+1|0;if(e>>>0>=32){break a}h=d>>>0<16;d=g;if(h){continue}}break}d=a;a=Cc(a,b,f,g);b=(a?d-a|0:0)+b|0;if(a){continue}break}return 0}function og(a,b){var c=0,d=0;d=J-80|0;J=d;c=-25;a:{if(!a|!b){break a}c=Ma(l[a+20>>2]<<3);l[a+4>>2]=c;if(!c){c=-22;break a}c=ng(a,l[a+16>>2]);if(c){Ed(a,l[b+56>>2]);break a}mg(d,b,l[a+36>>2]);ea(d- -64|0,8);lg(d,a);ea(d,72);c=0}J=d+80|0;return c}function qj(a){var b=0;b=a+ -65|0;b=a+4&(a+65488>>>8^-1)&(57-a>>>8^-1)&255|((b>>>8^-1)&b&(90-a>>>8^-1)&255|(a+185&(a+65439>>>8^-1)&(122-a>>>8^-1)&255|(((a^16288)+1>>>8^-1)&63|((a^16338)+1>>>8^-1)&62)));return(0-b>>>8^-1)&(a^65470)+1>>>8&255|b}function pj(a){var b=0;b=a+ -65|0;b=a+4&(a+65488>>>8^-1)&(57-a>>>8^-1)&255|((b>>>8^-1)&b&(90-a>>>8^-1)&255|(a+185&(a+65439>>>8^-1)&(122-a>>>8^-1)&255|(((a^16336)+1>>>8^-1)&63|((a^16340)+1>>>8^-1)&62)));return(0-b>>>8^-1)&(a^65470)+1>>>8&255|b}function Ub(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=J-16|0;J=d;c=10;while(1){a:{g=c;c=c+ -1|0;e=c+(d+6|0)|0;f=(b>>>0)/10|0;j[e|0]=b-r(f,10)|48;if(b>>>0<10){break a}b=f;if(c){continue}}break}b=a;a=11-g|0;h=pa(b,e,a)+a|0,i=0,j[h|0]=i;J=d+16|0}function Ji(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;e=J-320|0;J=e;d=-1;if(!sb(e,c)){d=0;while(1){j[a+d|0]=m[b+d|0];d=d+1|0;if((d|0)!=32){continue}break}j[a+31|0]=m[a+31|0]&127;$f(e+160|0,a,e);Kb(a,e+160|0);d=Ya(a,32)?-1:0}J=e+320|0;return d|0}function Ak(a,b){var c=0,d=0;d=l[a+72>>2]>>>3&127;a:{if(d>>>0<=111){c=112-d|0;if(!c){break a}pa((a+d|0)+80|0,35664,c);break a}c=a+80|0;pa(c+d|0,35664,128-d|0);fc(a,c,b,b+640|0);na(c,0,112)}Hf(a+192|0,a- -64|0,16);fc(a,a+80|0,b,b+640|0)}function ta(a,b,c){var d=0,e=0,f=0,g=0;f=J-48|0;J=f;d=b+40|0;la(a,d,b);e=a+40|0;oa(e,d,b);d=a+80|0;ca(d,a,c);ca(e,e,c+40|0);g=a+120|0;ca(g,c+120|0,b+120|0);ca(a,b+80|0,c+80|0);la(f,a,a);oa(a,d,e);la(e,d,e);la(d,f,g);oa(g,f,g);J=f+48|0}function pc(a,b,c){var d=0,e=0,f=0,g=0;f=J-48|0;J=f;d=b+40|0;la(a,d,b);e=a+40|0;oa(e,d,b);d=a+80|0;ca(d,a,c+40|0);ca(e,e,c);g=a+120|0;ca(g,c+120|0,b+120|0);ca(a,b+80|0,c+80|0);la(f,a,a);oa(a,d,e);la(e,d,e);oa(d,f,g);la(g,f,g);J=f+48|0}function Na(a,b,c){var d=0,e=0,f=0;if(!c){return 0}d=m[a|0];a:{if(!d){break a}while(1){b:{e=m[b|0];if((e|0)!=(d|0)){break b}c=c+ -1|0;if(!c|!e){break b}b=b+1|0;d=m[a+1|0];a=a+1|0;if(d){continue}break a}break}f=d}return(f&255)-m[b|0]|0}function Dd(a,b){var c=0,d=0,e=0,f=0;while(1){c=d<<3;e=c+a|0;c=b+c|0;f=m[c|0]|m[c+1|0]<<8|(m[c+2|0]<<16|m[c+3|0]<<24);c=m[c+4|0]|m[c+5|0]<<8|(m[c+6|0]<<16|m[c+7|0]<<24);l[e>>2]=f;l[e+4>>2]=c;d=d+1|0;if((d|0)!=128){continue}break}}function rc(a,b,c){var d=0;d=J-16|0;l[d+12>>2]=a;l[d+8>>2]=b;b=0;l[d+4>>2]=0;if((c|0)>=1){while(1){l[d+4>>2]=l[d+4>>2]|m[l[d+8>>2]+b|0]^m[l[d+12>>2]+b|0];b=b+1|0;if((c|0)!=(b|0)){continue}break}}return(l[d+4>>2]+ -1>>>8&1)+ -1|0}function mc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;d=J-16|0;J=d;j[d+15|0]=0;f=-1;if(!i[l[9172]](a,b,c)){while(1){j[d+15|0]=m[a+e|0]|m[d+15|0];e=e+1|0;if((e|0)!=32){continue}break}f=0-(m[d+15|0]+ -1>>>8&1)|0}J=d+16|0;return f|0}function jl(a,b,c){var d=0,e=0,f=0,g=0;f=J-48|0;J=f;d=b+40|0;la(a,d,b);e=a+40|0;oa(e,d,b);d=a+80|0;ca(d,a,c+40|0);ca(e,e,c);g=a+120|0;ca(g,c+80|0,b+120|0);b=b+80|0;la(f,b,b);oa(a,d,e);la(e,d,e);oa(d,f,g);la(g,f,g);J=f+48|0}\n\n\n\nfunction Eb(a){a=a|0;var b=0;l[a+32>>2]=0;l[a+36>>2]=0;b=l[8953];l[a>>2]=l[8952];l[a+4>>2]=b;b=l[8955];l[a+8>>2]=l[8954];l[a+12>>2]=b;b=l[8957];l[a+16>>2]=l[8956];l[a+20>>2]=b;b=l[8959];l[a+24>>2]=l[8958];l[a+28>>2]=b;return 0}function Tb(a,b,c,d){var e=0,f=0,g=0;Sb(c,((d<<7)+a|0)+ -64|0);e=d<<1;if(e){g=d<<4;d=0;while(1){f=d<<6;ue(c,f+a|0);te(c);Sb((d<<5)+b|0,c);ue(c,(f|64)+a|0);te(c);Sb(((d<<3)+g<<2)+b|0,c);d=d+2|0;if(d>>>0<e>>>0){continue}break}}}function Vk(a,b){a=a|0;b=b|0;var c=0,d=0;c=J-208|0;J=c;while(1){j[a+d|0]=m[b+d|0];d=d+1|0;if((d|0)!=32){continue}break}j[a|0]=m[a|0]&248;j[a+31|0]=m[a+31|0]&63|64;Nb(c+48|0,a);Uk(c,c+88|0,c+128|0);Ua(a,c);J=c+208|0;return 0}function td(a,b,c){var d=0,e=0,f=0,g=0;f=J-48|0;J=f;d=b+40|0;la(a,d,b);e=a+40|0;oa(e,d,b);d=a+80|0;ca(d,a,c);ca(e,e,c+40|0);g=a+120|0;ca(g,c+80|0,b+120|0);b=b+80|0;la(f,b,b);oa(a,d,e);la(e,d,e);la(d,f,g);oa(g,f,g);J=f+48|0}function ol(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;e=c>>>16|0;f=a>>>16|0;j=r(e,f);g=c&65535;h=a&65535;i=r(g,h);f=(i>>>16|0)+r(f,g)|0;e=(f&65535)+r(e,h)|0;a=(r(b,c)+j|0)+r(a,d)+(f>>>16)+(e>>>16)|0;b=i&65535|e<<16;K=a;return b}function fb(a,b,c){var d=0;d=J-16|0;l[d+12>>2]=a;l[d+8>>2]=b;b=0;j[d+7|0]=0;if(c){while(1){j[d+7|0]=m[d+7|0]|m[l[d+8>>2]+b|0]^m[l[d+12>>2]+b|0];b=b+1|0;if((c|0)!=(b|0)){continue}break}}return(m[d+7|0]+ -1>>>8&1)+ -1|0}function Rj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=J-800|0;J=d;e=-1;a:{if(sb(d+640|0,b)){break a}if(sb(d+480|0,c)){break a}sa(d,d+480|0);ta(d+160|0,d+640|0,d);ma(d+320|0,d+160|0);Kb(a,d+320|0);e=0}J=d+800|0;return e|0}function Qj(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=J-800|0;J=d;e=-1;a:{if(sb(d+640|0,b)){break a}if(sb(d+480|0,c)){break a}sa(d,d+480|0);pc(d+160|0,d+640|0,d);ma(d+320|0,d+160|0);Kb(a,d+320|0);e=0}J=d+800|0;return e|0}function Ni(a,b,c,d,e,f,g,h,i){var j=0,k=0;j=J;k=j;j=j-384&-64;J=j;if(!(!a|(d+ -1&255)>>>0>=64|(e|f?!b:0)|(g>>>0>=65|(g?!c:0)))){a:{if(g){ye(j,d,c,g,h,i);break a}We(j,d,h,i)}zb(j,b,e,f);Dc(j,a,d);J=k;return 0}ra();A()}function fi(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0;g=-1;a:{if(c>>>0>64|d+ -1>>>0>63){break a}b:{if(!(c?b:0)){if(!We(a,d&255,e,f)){break b}break a}if(ye(a,d&255,b,c&255,e,f)){break a}}g=0}return g|0}function Nk(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0;i=J-80|0;J=i;if(c|d){ga(i+8|0,f);ga(i+12|0,g);ic(i+16|0,h);Rf(i+16|0,e,i+8|0);hc(i+16|0,b,a,c,d);ea(i+16|0,64)}J=i+80|0;return 0}function he(a,b,c){var d=0,e=0;e=J-160|0;J=e;while(1){j[a+d|0]=m[b+d|0];d=d+1|0;if((d|0)!=32){continue}break}if(c){je(a)}j[a+31|0]=m[a+31|0]&127;Nb(e,a);cb(a,e);d=-1;if(!ie(a)){d=Ya(b,32)?-1:0}J=e+160|0;return d}function Qi(a,b,c){var d=0,e=0;d=J-128|0;J=d;e=-1;a:{if((le(a)|0)!=101){break a}if(Fc(d)){break a}na(d+16|0,0,102);b=pe(d,b,c,a,d+16|0);Ec(d);if(!b){break a}e=fb(d+16|0,a,102);ea(d+16|0,102)}J=d+128|0;return e}function Ti(a,b,c,d,e,f,g){var h=0,i=0;h=J;i=h;h=h-384&-64;J=h;if(!(!a|(d+ -1&255)>>>0>=64|(e|f?!b:0)|(g>>>0>=65|(g?!c:0)))){a:{if(g){Oe(h,d,c,g);break a}Ye(h,d)}zb(h,b,e,f);Dc(h,a,d);J=i;return 0}ra();A()}function qe(a,b){var c=0,d=0,e=0,f=0;c=J-16|0;J=c;a:{while(1){if(re(c+12|0,m[b|0])){b=0;l[a>>2]=0;break a}b=b+1|0;e=l[c+12>>2]<<d|e;f=d>>>0<24;d=d+6|0;if(f){continue}break}l[a>>2]=e}J=c+16|0;return b}function hb(a,b,c,d,e,f,g){var h=0,i=0,j=0;h=d;i=c+63|0;if(i>>>0<63){h=h+1|0}j=h>>>6|0;h=(h&63)<<26|i>>>6;i=0-h|0;h=1-(j+(0<h>>>0)|0)|0;if(!h&i>>>0<f>>>0|h>>>0<0){ra();A()}return kd(a,b,c,d,e,f,g)}function Ii(a,b){a=a|0;b=b|0;var c=0,d=0;c=J-160|0;J=c;while(1){j[a+d|0]=m[b+d|0];d=d+1|0;if((d|0)!=32){continue}break}j[a+31|0]=m[a+31|0]&127;Nb(c,a);Kb(a,c);a=Ya(a,32);J=c+160|0;return(a?-1:0)|0}function Mk(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0;h=J-80|0;J=h;if(c|d){ga(h+12|0,f);ic(h+16|0,g);Qf(h+16|0,e,h+12|0);hc(h+16|0,b,a,c,d);ea(h+16|0,64)}J=h+80|0;return 0}function yb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=-1;a:{if(c>>>0>64|d+ -1>>>0>63){break a}b:{if(!(c?b:0)){if(!Ye(a,d&255)){break b}break a}if(Oe(a,d&255,b,c&255)){break a}}e=0}return e|0}function Zk(a,b){var c=0;c=J-896|0;J=c;Va(c+848|0,b);Va(c+800|0,b+32|0);Sf(c+320|0,c+848|0);Sf(c+160|0,c+800|0);sa(c+640|0,c+160|0);ta(c+480|0,c+320|0,c+640|0);ma(c,c+480|0);Kb(a,c);J=c+896|0}function ck(a,b,c,d,e,f){var g=0,h=0;g=J-32|0;J=g;h=-1;if(!d&c>>>0>=48|d>>>0>0){Zb(g,b,e);e=a;h=b+32|0;a=d+ -1|0;c=c+ -32|0;if(c>>>0<4294967264){a=a+1|0}h=lf(e,h,c,a,g,b,f)}J=g+32|0;return h}function Yj(a,b,c,d,e,f){var g=0,h=0;g=J-32|0;J=g;h=-1;if(!d&c>>>0>=48|d>>>0>0){Zb(g,b,e);e=a;h=b+32|0;a=d+ -1|0;c=c+ -32|0;if(c>>>0<4294967264){a=a+1|0}h=df(e,h,c,a,g,b,f)}J=g+32|0;return h}function La(a,b){var c=0,d=0,e=0,f=0,g=0;d=J-48|0;J=d;ha(a,b);c=a+80|0;g=b+40|0;ha(c,g);f=a+120|0;ag(f,b+80|0);e=a+40|0;la(e,b,g);ha(d,e);la(e,c,a);oa(c,c,a);oa(a,d,e);oa(f,f,c);J=d+48|0}function Ye(a,b){var c=0;c=J+ -64|0;J=c;if((b+ -1&255)>>>0>=64){ra();A()}j[c+3|0]=1;j[c+1|0]=256;j[c+2|0]=1;j[c|0]=b;Xb(c|4);qa(c|8,0,0);na(c+16|0,0,48);Yb(a,c);J=c- -64|0;return 0}function lf(a,b,c,d,e,f,g){var h=0,i=0,j=0;if(!d&c>>>0>=16|d>>>0>0){h=a;i=b+16|0;j=b;a=d+ -1|0;b=c+ -16|0;if(b>>>0<4294967280){a=a+1|0}a=mf(h,i,j,b,a,e,f,g)}else{a=-1}return a}function df(a,b,c,d,e,f,g){var h=0,i=0,j=0;if(!d&c>>>0>=16|d>>>0>0){h=a;i=b+16|0;j=b;a=d+ -1|0;b=c+ -16|0;if(b>>>0<4294967280){a=a+1|0}a=ef(h,i,j,b,a,e,f,g)}else{a=-1}return a}function ib(a){var b=0,c=0;b=l[9328];c=a+3&-4;a=b+c|0;a:{if(a>>>0<=b>>>0?(c|0)>=1:0){break a}if(a>>>0>L()<<16>>>0){if(!H(a|0)){break a}}l[9328]=a;return b}l[9180]=48;return-1}function $k(a){var b=0,c=0,d=0;d=m[a+31|0];c=(d^-1)&127;b=30;while(1){c=m[a+b|0]^-1|c;b=b+ -1|0;if(b){continue}break}a=m[a|0];return((((c&255)+ -1&236-a)>>>8|(a|d>>>7))^-1)&1}function ik(a,b,c,d,e,f){var g=0,h=0,i=0;if(!d&c>>>0>=16|d>>>0>0){g=a;h=b+16|0;i=b;a=d+ -1|0;b=c+ -16|0;if(b>>>0<4294967280){a=a+1|0}a=ad(g,h,i,b,a,e,f)}else{a=-1}return a}function fk(a,b,c,d,e,f){var g=0,h=0,i=0;if(!d&c>>>0>=16|d>>>0>0){g=a;h=b+16|0;i=b;a=d+ -1|0;b=c+ -16|0;if(b>>>0<4294967280){a=a+1|0}a=Zc(g,h,i,b,a,e,f)}else{a=-1}return a}function ak(a,b,c,d,e,f){var g=0,h=0,i=0;if(!d&c>>>0>=16|d>>>0>0){g=a;h=b+16|0;i=b;a=d+ -1|0;b=c+ -16|0;if(b>>>0<4294967280){a=a+1|0}a=Wc(g,h,i,b,a,e,f)}else{a=-1}return a}function _j(a,b,c,d,e,f){var g=0,h=0,i=0;if(!d&c>>>0>=16|d>>>0>0){g=a;h=b+16|0;i=b;a=d+ -1|0;b=c+ -16|0;if(b>>>0<4294967280){a=a+1|0}a=Uc(g,h,i,b,a,e,f)}else{a=-1}return a}function _i(a,b){var c=0,d=0,e=0;d=J-16|0;J=d;c=xd(d+12|0,b);l[9180]=c;e=a;if(c){l[d+12>>2]=0;c=0}else{c=l[d+12>>2]}l[e+4>>2]=c;l[a>>2]=c;l[a+8>>2]=c?b:0;J=d+16|0;return c}function fj(a,b,c,d,e,f,g,h,i,j,k){a:{switch(k+ -1|0){case 0:return Ne(a,b,c,d,e,f,g,h,i,j,1);case 1:return Fe(a,b,c,d,e,f,g,h,i,j,2);default:break a}}l[9180]=28;return-1}function Kk(a,b,c,d,e,f,g,h,i,j){if(!e&d>>>0<4294967280|e>>>0<0){Nf(a,a+d|0,0,c,d,e,f,g,h,i,j);if(b){a=d+16|0;if(a>>>0<16){e=e+1|0}l[b>>2]=a;l[b+4>>2]=e}return 0}ra();A()}function Jk(a,b,c,d,e,f,g,h,i,j){if(!e&d>>>0<4294967280|e>>>0<0){Mf(a,a+d|0,0,c,d,e,f,g,h,i,j);if(b){a=d+16|0;if(a>>>0<16){e=e+1|0}l[b>>2]=a;l[b+4>>2]=e}return 0}ra();A()}function Ek(a,b,c,d,e,f,g,h,i,j){if(!e&d>>>0<4294967280|e>>>0<0){Jf(a,a+d|0,0,c,d,e,f,g,h,i,j);if(b){a=d+16|0;if(a>>>0<16){e=e+1|0}l[b>>2]=a;l[b+4>>2]=e}return 0}ra();A()}function mb(a,b){var c=0,d=0,e=0,f=0;while(1){c=e<<3;d=c+a|0;c=b+c|0;f=l[c>>2];c=l[d+4>>2]^l[c+4>>2];l[d>>2]=l[d>>2]^f;l[d+4>>2]=c;e=e+1|0;if((e|0)!=128){continue}break}}function Ve(a){var b=0,c=0;b=a+65510>>>8&255;c=a+65484>>>8|0;return((a^32704)+1>>>8^-1)&95|(((a^16321)+1>>>8^-1)&45|b&a+65)|c&a+71&(b^255)|a+252&a+65474>>>8&(c^-1)&255}function Ue(a){var b=0,c=0;b=a+65510>>>8&255;c=a+65484>>>8|0;return((a^16320)+1>>>8^-1)&47|(((a^16321)+1>>>8^-1)&43|b&a+65)|c&a+71&(b^255)|a+252&a+65474>>>8&(c^-1)&255}function cb(a,b){var c=0,d=0,e=0;c=J-144|0;J=c;vb(c+96|0,b+80|0);ca(c+48|0,b,c+96|0);ca(c,b+40|0,c+96|0);Ua(a,c);d=a,e=kb(c+48|0)<<7^m[a+31|0],j[d+31|0]=e;J=c+144|0}function Wf(a){var b=0,c=0,d=0,e=0,f=0;b=32;c=1;while(1){b=b+ -1|0;d=m[b+a|0];e=m[b+3456|0];f=d-e>>8&c|f&255;c=(d^e)+65535>>>8&c;if(b){continue}break}return(f|0)!=0}function Ya(a,b){var c=0,d=0;c=J-16|0;j[c+15|0]=0;if(b){while(1){j[c+15|0]=m[a+d|0]|m[c+15|0];d=d+1|0;if((d|0)!=(b|0)){continue}break}}return m[c+15|0]+ -1>>>8&1}function Xj(a){a=a|0;var b=0,c=0;b=J-160|0;J=b;a:{if(!pd(a)){break a}if(Lb(a)){break a}if(lb(b,a)){break a}if(!Mb(b)){break a}c=(qd(b)|0)!=0}J=b+160|0;return c|0}function Cc(a,b,c,d){var e=0;if(d){while(1){if(!b){return 0}j[a|0]=m[(c&63)+36484|0];c=c>>>6|0;b=b+ -1|0;a=a+1|0;e=e+6|0;if(e>>>0<d>>>0){continue}break}}return a}function Pk(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0;f=J+ -64|0;J=f;if(b|c){ic(f,e);Rf(f,d,0);a=na(a,0,b);hc(f,a,a,b,c);ea(f,64)}J=f- -64|0;return 0}function Ok(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0;f=J+ -64|0;J=f;if(b|c){ic(f,e);Qf(f,d,0);a=na(a,0,b);hc(f,a,a,b,c);ea(f,64)}J=f- -64|0;return 0}function se(a,b,c,d){var e=0;a:{if(m[a|0]!=36|m[a+1|0]!=55|m[a+2|0]!=36){break a}if(re(b,m[a+3|0])){break a}a=qe(c,a+4|0);if(!a){break a}e=qe(d,a)}return e}function aa(a,b,c,d){var e=0;d=b+d|0;e=a+c|0;if(e>>>0<c>>>0){d=d+1|0}b=b<<1|a>>>31;c=ql(a<<1&-2,b&1,c,0);b=c+e|0;a=K+d|0;a=b>>>0<c>>>0?a+1|0:a;K=a;return b}function ne(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0;k=J-16|0;J=k;l=-1;if(!Fc(k)){l=(m=-1,n=ze(k,a,b,c,d,e,f,g,h,i,j),o=Ec(k),o?m:n)}J=k+16|0;return l}function _k(a){a=a|0;var b=0,c=0;if(a>>>0>=2){c=(0-a>>>0)%(a>>>0)|0;while(1){b=rd();if(b>>>0<c>>>0){continue}break}a=(b>>>0)%(a>>>0)|0}else{a=0}return a|0}function Le(a,b,c,d){a:{b:{if((d|0)==1&c>>>0>=0|d>>>0>1){l[9180]=22;break b}a=Re(a,b,c,1);if(!a){break a}if((a|0)!=-35){break b}l[9180]=28}a=-1}return a}function Hf(a,b,c){var d=0,e=0,f=0;e=c>>>3|0;if(e){c=0;while(1){d=c<<3;f=d+a|0;d=b+d|0;Gf(f,l[d>>2],l[d+4>>2]);c=c+1|0;if((e|0)!=(c|0)){continue}break}}}function De(a,b,c,d){a:{b:{if((d|0)==1&c>>>0>=0|d>>>0>1){l[9180]=22;break b}a=Re(a,b,c,2);if(!a){break a}if((a|0)!=-35){break b}l[9180]=28}a=-1}return a}function pd(a){var b=0,c=0;c=(m[a+31|0]^-1)&127;b=30;while(1){c=m[a+b|0]^-1|c;b=b+ -1|0;if(b){continue}break}return(((c&255)+ -1&236-m[a|0])>>>8^-1)&1}function rl(a,b){var c=0,d=0,e=0,f=0;while(1){f=d;c=e;if(a|b){c=a;a=c-1&c;b=b-(c>>>0<1)&b;c=d+1|0;if(c>>>0<1){e=e+1|0}d=c;continue}break}K=c;return f}function ve(a,b,c){var d=0,e=0,f=0;d=c>>>2|0;if(d){c=0;while(1){e=c<<2;f=e+a|0;l[f>>2]=l[f>>2]^l[b+e>>2];c=c+1|0;if((d|0)!=(c|0)){continue}break}}}function pg(a){var b=0,c=0;b=0;a:{if(!a){break a}c=a;b=a;if((a|1)>>>0<65536){break a}b=c}c=b;a=Ma(b);if(!(!a|!(m[a+ -4|0]&3))){na(a,0,c)}return a}function Zh(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return Mf(a,b,c,d,e,f,g,h,i,k,l)|0}function Th(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return Jf(a,b,c,d,e,f,g,h,i,k,l)|0}function $h(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return Nf(a,b,c,d,e,f,g,h,i,k,l)|0}function Bk(a,b){var c=0,d=0,e=0,f=0,g=0;while(1){d=c<<3;e=d+a|0;f=e,g=zk(b+d|0),l[f>>2]=g;l[e+4>>2]=K;c=c+1|0;if((c|0)!=16){continue}break}}function ie(a){var b=0,c=0;c=m[a|0]^1;b=1;while(1){c=m[a+b|0]|c;b=b+1|0;if((b|0)!=31){continue}break}return(m[a+31|0]&127|c&255)+ -1>>>8&1}function ej(a,b,c,d,e,f,g,h){a:{switch(h+ -1|0){case 1:return Ee(a,b,c,d,e,f,g);default:ra();A();case 0:break a}}return Me(a,b,c,d,e,f,g)}function th(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Ne(a,b,c,d,e,f,g,h,i,j,k)|0}function nh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Fe(a,b,c,d,e,f,g,h,i,j,k)|0}function lh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return fj(a,b,c,d,e,f,g,h,i,j,k)|0}function Ed(a,b){var c=0;rg(a,b&4);Aa(l[a+4>>2]);l[a+4>>2]=0;b=l[a>>2];a:{if(!b){break a}c=l[b>>2];if(!c){break a}Aa(c)}Aa(b);l[a>>2]=0}function _h(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Kk(a,b,c,d,e,f,g,h,j,k)|0}function Yh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Jk(a,b,c,d,e,f,g,h,j,k)|0}function Xh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Lf(a,c,d,e,f,g,h,i,j,k)|0}function Wh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Hk(a,b,d,e,f,g,h,i,j,k)|0}function Vh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Kf(a,c,d,e,f,g,h,i,j,k)|0}function Uh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Gk(a,b,d,e,f,g,h,i,j,k)|0}function Sh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Ek(a,b,c,d,e,f,g,h,j,k)|0}function Rh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return If(a,c,d,e,f,g,h,i,j,k)|0}function Qh(a,b,c,d,e,f,g,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;return Ck(a,b,d,e,f,g,h,i,j,k)|0}function sf(a,b){var c=0,d=0,e=0;while(1){e=a+c|0;d=(m[e|0]-m[b+c|0]|0)-d|0;j[e|0]=d;d=d>>>8&1;c=c+1|0;if((c|0)!=64){continue}break}}function qk(a,b){var c=0,d=0,e=0;while(1){e=a+c|0;d=m[b+c|0]+(m[e|0]+d|0)|0;j[e|0]=d;d=d>>>8|0;c=c+1|0;if((c|0)!=32){continue}break}}function qa(a,b,c){j[a|0]=b;j[a+1|0]=b>>>8;j[a+2|0]=b>>>16;j[a+3|0]=b>>>24;j[a+4|0]=c;j[a+5|0]=c>>>8;j[a+6|0]=c>>>16;j[a+7|0]=c>>>24}function xe(a,b,c){var d=0,e=0;d=c>>>2|0;if(d){c=0;while(1){e=c<<2;l[e+a>>2]=l[b+e>>2];c=c+1|0;if((d|0)!=(c|0)){continue}break}}}function sg(a,b){var c=0,d=0,e=0;while(1){c=d<<3;e=c+a|0;c=b+c|0;qa(e,l[c>>2],l[c+4>>2]);d=d+1|0;if((d|0)!=128){continue}break}}function rg(a,b){a:{if(!b){break a}b=l[a>>2];if(b){ea(l[b+4>>2],l[a+16>>2]<<10)}b=l[a+4>>2];if(!b){break a}ea(b,l[a+20>>2]<<3)}}function ea(a,b){var c=0;c=J-16|0;l[c+12>>2]=a;if(b){a=0;while(1){j[l[c+12>>2]+a|0]=0;a=a+1|0;if((b|0)!=(a|0)){continue}break}}}function rj(a,b){a=a|0;b=b|0;var c=0;Oc(b);c=(a>>>0)/3|0;a=r(c,-3)+a|0;return r(4-(3-a&0-(b>>>1&1))|0,(a|a>>>1)&1)+(c<<2|1)|0}function eh(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return Ei(a,b,c,d,e,f,g,h,i,j)|0}function dh(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return Di(a,b,c,d,e,f,g,h,i,j)|0}function Ig(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return ne(a,b,c,d,e,f,g,h,i,j)|0}function Hg(a,b,c,d,e,f,g,h,i,j){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return Si(a,b,c,d,e,f,g,h,i,j)|0}function Fa(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;if(b){while(1){d=a+c|0,e=rd(),j[d|0]=e;c=c+1|0;if((c|0)!=(b|0)){continue}break}}}function Bd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;g=J;f=g-128&-64;J=f;Ad(f,e);zd(f,b,c,d);yd(f,a);J=g;return 0}function yk(a,b,c,d,e){var f=0;f=J+ -64|0;J=f;Ef(f,b,c,d,e);b=Cd(a,f);c=fb(f,a,64);J=f- -64|0;return c|((a|0)==(f|0)?-1:b)}function zf(a){var b=0,c=0,d=0;b=1;while(1){d=a+c|0;b=m[d|0]+b|0;j[d|0]=b;b=b>>>8|0;c=c+1|0;if((c|0)!=4){continue}break}}function vk(a,b){var c=0,d=0,e=0,f=0;while(1){d=c<<2;e=d+a|0,f=rk(b+d|0),l[e>>2]=f;c=c+1|0;if((c|0)!=16){continue}break}}function ue(a,b){var c=0,d=0,e=0;while(1){d=c<<2;e=d+a|0;l[e>>2]=l[e>>2]^l[b+d>>2];c=c+1|0;if((c|0)!=16){continue}break}}function of(a,b,c,d,e,f,g,h){var i=0,j=0;i=J-32|0;J=i;j=-1;if(!$c(i,g,h)){j=_c(a,b,c,d,e,f,i);ea(i,32)}J=i+32|0;return j}function mf(a,b,c,d,e,f,g,h){var i=0,j=0;i=J-32|0;J=i;j=-1;if(!$c(i,g,h)){j=Zc(a,b,c,d,e,f,i);ea(i,32)}J=i+32|0;return j}function gf(a,b,c,d,e,f,g,h){var i=0,j=0;i=J-32|0;J=i;j=-1;if(!cd(i,g,h)){j=Vc(a,b,c,d,e,f,i);ea(i,32)}J=i+32|0;return j}function ef(a,b,c,d,e,f,g,h){var i=0,j=0;i=J-32|0;J=i;j=-1;if(!cd(i,g,h)){j=Uc(a,b,c,d,e,f,i);ea(i,32)}J=i+32|0;return j}function hd(a,b){a=a|0;b=b|0;var c=0;c=J+ -64|0;J=c;Oa(a,c);a=a+208|0;Da(a,c,64,0);Oa(a,b);ea(c,64);J=c- -64|0;return 0}function ac(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=J-32|0;J=d;e=-1;if(!mc(d,c,b)){e=pb(a,36160,d,0)}J=d+32|0;return e|0}function $c(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=J-32|0;J=d;e=-1;if(!mc(d,c,b)){e=Pa(a,36208,d,0)}J=d+32|0;return e|0}function xk(a,b,c,d,e){var f=0;f=J-32|0;J=f;Af(f,b,c,d,e);b=Pb(a,f);c=fb(f,a,32);J=f+32|0;return c|((a|0)==(f|0)?-1:b)}function pk(a,b,c,d,e){var f=0;f=J-32|0;J=f;xf(f,b,c,d,e);b=Pb(a,f);c=fb(f,a,32);J=f+32|0;return c|((a|0)==(f|0)?-1:b)}function Zd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;e=J+ -64|0;J=e;Oa(a,e);a=ee(b,c,e,64,0,d,1);J=e- -64|0;return a|0}function jg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0;f=J-16|0;J=f;Bd(f,b,c,d,e);a=wb(a,f);J=f+16|0;return a|0}function dj(a,b,c,d){if(!Na(a,36455,10)){return De(a,b,c,d)}if(!Na(a,36466,9)){return Le(a,b,c,d)}l[9180]=28;return-1}function cj(a,b,c,d){if(!Na(a,36455,10)){return Ie(a,b,c,d)}if(!Na(a,36466,9)){return Ke(a,b,c,d)}l[9180]=28;return-1}function ok(a,b,c,d,e,f,g){var h=0,i=0;h=J-32|0;J=h;i=-1;if(!ac(h,f,g)){i=rf(a,b,c,d,e,h);ea(h,32)}J=h+32|0;return i}function nk(a,b,c,d,e,f,g){var h=0,i=0;h=J-32|0;J=h;i=-1;if(!ac(h,f,g)){i=qf(a,b,c,d,e,h);ea(h,32)}J=h+32|0;return i}function ma(a,b){var c=0,d=0,e=0;c=b+120|0;ca(a,b,c);d=b+40|0;e=b+80|0;ca(a+40|0,d,e);ca(a+80|0,e,c);ca(a+120|0,b,d)}function yf(a,b){b=b<<8&16711680|b<<24|(b>>>8&65280|b>>>24);j[a|0]=b;j[a+1|0]=b>>>8;j[a+2|0]=b>>>16;j[a+3|0]=b>>>24}function xh(a,b,c,d,e,f,g,h,i){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return ce(a,b,c,d,e,f,g,h,i)|0}function vf(a,b,c,d,e,f,g,h){var i=0;i=J-32|0;J=i;pb(i,e,h,0);a=kc(a,b,c,d,e+16|0,f,g,i);ea(i,32);J=i+32|0;return a}function fd(a,b){a=a|0;b=b|0;var c=0;c=J-32|0;J=c;Db(a,c);a=a+104|0;eb(a,c,32,0);Db(a,b);ea(c,32);J=c+32|0;return 0}function rk(a){a=m[a|0]|m[a+1|0]<<8|(m[a+2|0]<<16|m[a+3|0]<<24);return a<<24|a<<8&16711680|(a>>>8&65280|a>>>24)}function bf(a){a=a|0;while(1){Fa(a,32);j[a+31|0]=m[a+31|0]&31;if(!Wf(a)){continue}if(Ya(a,32)){continue}break}}function Qk(){var a=0;if(l[9324]){a=1}else{l[9306]=0;ll();l[9305]=1;Xf();Fa(37280,16);l[9324]=1;a=0}return a|0}function Yd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=J+ -64|0;J=d;Oa(a,d);a=be(b,d,64,0,c,1);J=d- -64|0;return a|0}function Oa(a,b){a=a|0;b=b|0;var c=0;c=J-704|0;J=c;Ak(a,c);Hf(b,a,64);ea(c,704);ea(a,208);J=c+704|0;return 0}function ce(a,b,c,d,e,f,g,h,i){if(b+ -1>>>0>63|g>>>0>64){a=-1}else{a=Ni(a,c,f,b&255,d,e,g&255,h,i)}return a}function bb(a,b,c){var d=0;if((b|0)>=1){while(1){ha(a,a);d=d+1|0;if((d|0)!=(b|0)){continue}break}}ca(a,a,c)}function Ga(a,b,c){var d=0;if((b|0)>=1){while(1){ub(a,a);d=d+1|0;if((d|0)!=(b|0)){continue}break}}va(a,a,c)}function Xd(a,b,c,d,e,f,g,h){var i=0;i=J-32|0;J=i;Pa(i,e,h,0);a=rb(a,b,c,d,e+16|0,f,g,i);J=i+32|0;return a}function $i(a,b){var c=0;while(1){if(!b){return 0}b=b+ -1|0;c=b+a|0;if(m[c|0]!=36){continue}break}return c}function vg(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return Xd(a,b,c,d,e,f,g,h)|0}function kh(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return ej(a,b,c,d,e,f,g,h)|0}function ge(a,b){var c=0,d=0;while(1){d=a+c|0;j[d|0]=m[d|0]^m[b+c|0];c=c+1|0;if((c|0)!=8){continue}break}}function bh(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return rb(a,b,c,d,e,f,g,h)|0}function Wg(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return kc(a,b,c,d,e,f,g,h)|0}function Ug(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return vf(a,b,c,d,e,f,g,h)|0}function Rg(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return of(a,b,c,d,e,f,g,h)|0}function Ng(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return mf(a,b,c,d,e,f,g,h)|0}function Ih(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return gf(a,b,c,d,e,f,g,h)|0}function Eh(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return ef(a,b,c,d,e,f,g,h)|0}function Db(a,b){a=a|0;b=b|0;var c=0;c=J-288|0;J=c;uk(a,c);tk(b,a);ea(c,288);ea(a,104);J=c+288|0;return 0}function rb(a,b,c,d,e,f,g,h){if((d|0)==1&c>>>0>=0|d>>>0>1){ra();A()}return i[l[9178]](a,b,c,d,e,f,g,h)|0}function Zb(a,b,c){var d=0,e=0;e=J;d=e-384&-64;J=d;$b(d,0,0,24);Xa(d,b,32,0);Xa(d,c,32,0);_b(d,a,24);J=e}function wf(a,b,c,d,e){var f=0;f=J-32|0;J=f;pb(f,d,e,0);a=md(a,b,c,d+16|0,f);ea(f,32);J=f+32|0;return a}function le(a){var b=0;while(1){if(!m[a+b|0]){return b}b=b+1|0;if((b|0)!=102){continue}break}return 102}function Lk(){var a=0,b=0;a=l[9317];a:{if(!a){break a}a=l[a+20>>2];if(!a){break a}b=i[a]()|0}return b|0}function Sb(a,b){var c=0,d=0;while(1){d=c<<2;l[d+a>>2]=l[b+d>>2];c=c+1|0;if((c|0)!=16){continue}break}}function tk(a,b){var c=0,d=0;while(1){d=c<<2;yf(d+a|0,l[b+d>>2]);c=c+1|0;if((c|0)!=8){continue}break}}function sa(a,b){var c=0;c=b+40|0;la(a,c,b);oa(a+40|0,c,b);Ba(a+80|0,b+80|0);ca(a+120|0,b+120|0,2224)}function xb(a,b,c){a=a|0;b=b|0;c=c|0;if(c>>>0>=256){D(2016,2036,107,2089);A()}return Dc(a,b,c&255)|0}function nf(a,b,c,d,e,f,g){if(!d&c>>>0>=4294967280|d>>>0>0){ra();A()}return of(a+16|0,a,b,c,d,e,f,g)}function kd(a,b,c,d,e,f,g){if((d|0)==1&c>>>0>=0|d>>>0>1){ra();A()}return i[l[9179]](a,b,c,d,e,f,g)|0}function gc(a,b,c,d,e,f){if((d|0)==1&c>>>0>=0|d>>>0>1){ra();A()}return i[l[9178]](a,b,c,d,e,0,0,f)|0}function ff(a,b,c,d,e,f,g){if(!d&c>>>0>=4294967280|d>>>0>0){ra();A()}return gf(a+16|0,a,b,c,d,e,f,g)}function sk(a,b,c,d){var e=0;e=J-112|0;J=e;Eb(e+8|0);eb(e+8|0,b,c,d);Db(e+8|0,a);J=e+112|0;return 0}function Rb(a,b,c,d,e,f,g){if(b+ -1>>>0>63|g>>>0>64){a=-1}else{a=Ti(a,c,f,b&255,d,e,g&255)}return a}function jk(a,b,c,d,e,f){if(!d&c>>>0>=4294967280|d>>>0>0){ra();A()}bd(a+16|0,a,b,c,d,e,f);return 0}function bk(a,b,c,d,e,f){if(!d&c>>>0>=4294967280|d>>>0>0){ra();A()}Xc(a+16|0,a,b,c,d,e,f);return 0}function Of(a,b,c,d,e,f){if((d|0)==1&c>>>0>=0|d>>>0>1){ra();A()}return i[l[9179]](a,b,c,d,e,0,f)|0}function hk(a,b,c,d,e,f){if(!d&c>>>0>=4294967280|d>>>0>0){ra();A()}return _c(a+16|0,a,b,c,d,e,f)}function gb(a){a=a|0;l[a+64>>2]=0;l[a+68>>2]=0;l[a+72>>2]=0;l[a+76>>2]=0;pa(a,34960,64);return 0}function Uk(a,b,c){var d=0;d=J-96|0;J=d;la(d+48|0,c,b);oa(d,c,b);vb(d,d);ca(a,d+48|0,d);J=d+96|0}function Ra(a,b){var c=0,d=0;c=b+120|0;ca(a,b,c);d=b+40|0;b=b+80|0;ca(a+40|0,d,b);ca(a+80|0,b,c)}function $j(a,b,c,d,e,f){if(!d&c>>>0>=4294967280|d>>>0>0){ra();A()}return Vc(a+16|0,a,b,c,d,e,f)}function zh(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return jf(a,b,c,d,e,f,g)|0}function xd(a,b){if(4294967168<b>>>0){a=48}else{b=kg(b);if(!b){return 48}l[a>>2]=b;a=0}return a}function rh(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Me(a,b,c,d,e,f,g)|0}function fe(a,b){a=a|0;b=b|0;var c=0;c=J-32|0;J=c;Fa(c,32);yc(a,b,c);ea(c,32);J=c+32|0;return 0}function _g(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return hb(a,b,c,d,e,f,g)|0}function Ud(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return ok(a,b,c,d,e,f,g)|0}function Td(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return nk(a,b,c,d,e,f,g)|0}function Sg(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return _c(a,b,c,d,e,f,g)|0}function Pg(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return nf(a,b,c,d,e,f,g)|0}function Og(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Zc(a,b,c,d,e,f,g)|0}function Nd(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Ee(a,b,c,d,e,f,g)|0}function Lg(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return lf(a,b,c,d,e,f,g)|0}function Jh(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Vc(a,b,c,d,e,f,g)|0}function Gh(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return ff(a,b,c,d,e,f,g)|0}function Gg(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Ri(a,b,c,d,e,f,g)|0}function Fh(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return Uc(a,b,c,d,e,f,g)|0}function Ch(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;return df(a,b,c,d,e,f,g)|0}function xf(a,b,c,d,e){var f=0;f=J-208|0;J=f;gd(f,e,32);cc(f,b,c,d);fd(f,a);J=f+208|0;return 0}function di(a,b,c,d,e){var f=0;f=J-32|0;J=f;Pa(f,d,e,0);a=Gb(a,b,c,d+16|0,f);J=f+32|0;return a}function Ef(a,b,c,d,e){var f=0;f=J-416|0;J=f;jd(f,e,32);id(f,b,c,d);hd(f,a);J=f+416|0;return 0}function Af(a,b,c,d,e){var f=0;f=J-416|0;J=f;Df(f,e,32);Cf(f,b,c,d);Bf(f,a);J=f+416|0;return 0}function ld(a,b,c,d,e){if((c|0)==1&b>>>0>=0|c>>>0>1){ra();A()}return i[l[9177]](a,b,c,d,e)|0}function ia(a){var b=0,c=0;b=m[a|0]|m[a+1|0]<<8;a=m[a+2|0];c=a>>>16|0;a=b|a<<16;K=c;return a}function Gb(a,b,c,d,e){if((c|0)==1&b>>>0>=0|c>>>0>1){ra();A()}return i[l[9176]](a,b,c,d,e)|0}function rd(){var a=0,b=0;a=J-16|0;J=a;j[a+15|0]=0;b=E(1027,a+15|0,0)|0;J=a+16|0;return b|0}function $a(a,b,c){Ca(a,b,c);Ca(a+40|0,b+40|0,c);Ca(a+80|0,b+80|0,c);Ca(a+120|0,b+120|0,c)}function ul(a,b){var c=0,d=0;c=b&31;d=(-1<<c&a)>>>c|0;c=a;a=0-b&31;return d|(c&-1>>>a)<<a}function ug(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Xd(a,b,c,d,e,0,0,f)|0}function sl(a,b){var c=0,d=0;c=b&31;d=(-1>>>c&a)<<c;c=a;a=0-b&31;return d|(c&-1<<a)>>>a}function Fb(a,b,c,d){var e=0;e=J-208|0;J=e;gb(e);Da(e,b,c,d);Oa(e,a);J=e+208|0;return 0}function zg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return hi(a,b,c,d,e,f)|0}function xg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return ei(a,b,c,d,e,f)|0}function vc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return rf(a,b,c,d,e,f)|0}function uc(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return qf(a,b,c,d,e,f)|0}function gh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return bk(a,b,c,d,e,f)|0}function fh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return ak(a,b,c,d,e,f)|0}function ah(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return gc(a,b,c,d,e,f)|0}function Yg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Of(a,b,c,d,e,f)|0}function Vg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return jc(a,b,c,d,e,f)|0}function Rd(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Fj(a,b,c,d,e,f)|0}function Qg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return hk(a,b,c,d,e,f)|0}function Mg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return fk(a,b,c,d,e,f)|0}function Ld(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return ti(a,b,c,d,e,f)|0}function Kd(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return si(a,b,c,d,e,f)|0}function Jg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return ck(a,b,c,d,e,f)|0}function Jd(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return de(a,b,c,d,e,f)|0}function Hh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return $j(a,b,c,d,e,f)|0}function Fd(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return ed(a,b,c,d,e,f)|0}function Dh(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return _j(a,b,c,d,e,f)|0}function Dg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return jk(a,b,c,d,e,f)|0}function Cg(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return ik(a,b,c,d,e,f)|0}function Ah(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;return Yj(a,b,c,d,e,f)|0}function _e(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=J-32|0;J=d;Tc(d,c);Sc(a,b,d);J=d+32|0}function qb(a,b,c,d,e){if((c|0)==1&b>>>0>=0|c>>>0>1){ra();A()}return ld(a,b,c,d,e)}function ll(){var a=0;a=J-16|0;J=a;cg(a);if(l[a>>2]){cg(a);na(37228,0,40)}J=a+16|0}function Ik(a,b,c){if((c|0)==1&b>>>0>=0|c>>>0>1){D(1799,1819,197,1845);A()}Fa(a,b)}function yg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return gi(a,b,c,d,e)|0}function wg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return di(a,b,c,d,e)|0}function ch(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Gb(a,b,c,d,e)|0}function Xg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return md(a,b,c,d,e)|0}function Wd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Af(a,b,c,d,e)|0}function Vd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return xk(a,b,c,d,e)|0}function Qd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return wd(a,b,c,d,e)|0}function Pd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Ob(a,b,c,d,e)|0}function Oh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return xf(a,b,c,d,e)|0}function Nh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return pk(a,b,c,d,e)|0}function Mh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Ef(a,b,c,d,e)|0}function Lh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return yk(a,b,c,d,e)|0}function Kg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return dk(a,b,c,d,e)|0}function Id(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return ae(a,b,c,d,e)|0}function Gd(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return wf(a,b,c,d,e)|0}function Bh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return Zj(a,b,c,d,e)|0}function Ag(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return ii(a,b,c,d,e)|0}function $g(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return qb(a,b,c,d,e)|0}function Xf(){var a=0;a=J-16|0;J=a;j[a+15|0]=0;E(1065,a+15|0,0)|0;J=a+16|0}function Tf(a,b,c){var d=0;d=J-48|0;J=d;Sa(d,b);Ba(a,b);Ca(a,d,c);J=d+48|0}function Sj(a){a=a|0;var b=0;b=J-160|0;J=b;a=sb(b,a);J=b+160|0;return!a|0}function Md(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return zi(a,b,c,e)|0}function Cj(a,b,c){a=a|0;b=b|0;c=c|0;jf(b,32,c,32,0,0,0);return Qc(a,b)|0}function Bg(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return wi(a,b,c,e)|0}function re(a,b){var c=0;c=a;a=aj(b);l[c>>2]=a?a-36484|0:0;return a?0:-1}function ga(a,b){j[a|0]=b;j[a+1|0]=b>>>8;j[a+2|0]=b>>>16;j[a+3|0]=b>>>24}function ab(a,b){var c=0;c=J-128|0;J=c;il(c+8|0,b);La(a,c+8|0);J=c+128|0}function Ta(a){var b=0;b=J-32|0;J=b;Ua(b,a);a=Ya(b,32);J=b+32|0;return a}function qd(a){var b=0;b=J-160|0;J=b;fl(b,a);a=Ta(b);J=b+160|0;return a}function Pj(a){a=a|0;var b=0;b=J+ -64|0;J=b;Fa(b,64);Xe(a,b);J=b- -64|0}function we(a,b){a=((b<<7)+a|0)+ -64|0;b=l[a>>2];K=l[a+4>>2];return b}function kb(a){var b=0;b=J-32|0;J=b;Ua(b,a);J=b+32|0;return j[b|0]&1}function _a(a,b,c){Ca(a,b,c);Ca(a+40|0,b+40|0,c);Ca(a+80|0,b+80|0,c)}function Jb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;nd(a,b,c,d,20);return 0}function Ib(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;nd(a,b,c,d,12);return 0}function Tj(a){a=a|0;var b=0;b=J-32|0;J=b;Fa(b,32);cf(a,b);J=b+32|0}function Hb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;nd(a,b,c,d,8);return 0}function yh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Xa(a,b,c,d)|0}function vh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return eb(a,b,c,d)|0}function uh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return sk(a,b,c,d)|0}function qh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Le(a,b,c,d)|0}function ph(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Ke(a,b,c,d)|0}function oh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Ie(a,b,c,d)|0}function mh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return De(a,b,c,d)|0}function li(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Zd(a,b,c,d)|0}function kc(a,b,c,d,e,f,g,h){return i[l[9175]](a,b,c,d,e,f,g,h)|0}function jh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return dj(a,b,c,d)|0}function hh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return cj(a,b,c,d)|0}function hg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;zd(a,b,c,d);return 0}function Sd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Fb(a,b,c,d)|0}function Ph(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return cc(a,b,c,d)|0}function Od(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return ja(a,b,c,d)|0}function Kh(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Cf(a,b,c,d)|0}function Hd(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Da(a,b,c,d)|0}function Eg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Pi(a,b,c,d)|0}function $b(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return yb(a,b,c,d)|0}function Fg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return Qi(a,b,c)|0}function Ac(a){j[a+32|0]=1;j[a+33|0]=0;j[a+34|0]=0;j[a+35|0]=0}function jc(a,b,c,d,e,f){return i[l[9175]](a,b,c,d,e,0,0,f)|0}function cg(a){l[a>>2]=0;l[a+4>>2]=0;l[a+8>>2]=0;l[a+12>>2]=0}function il(a,b){Ba(a,b);Ba(a+40|0,b+40|0);Ba(a+80|0,b+80|0)}function Ce(a){var b=0;b=l[a>>2];if(b){Aa(b)}Be(a);return 0}function Oi(a,b,c){a=a|0;b=b|0;c=c|0;return ke(a,b,c,1)|0}function Mi(a,b,c){a=a|0;b=b|0;c=c|0;return ke(a,b,c,0)|0}function af(a,b){a=a|0;b=b|0;dl(a,b);return 0-Ya(b,32)|0}function Xb(a){j[a|0]=0;j[a+1|0]=0;j[a+2|0]=0;j[a+3|0]=0}function oi(a,b,c){a=a|0;b=b|0;c=c|0;return yc(a,b,c)|0}function lk(a,b,c){a=a|0;b=b|0;c=c|0;return dd(a,b,c)|0}function ki(a,b,c){a=a|0;b=b|0;c=c|0;return Yd(a,b,c)|0}function je(a){j[a|0]=m[a|0]&248;j[a+31|0]=m[a+31|0]|64}function cd(a,b,c){a=a|0;b=b|0;c=c|0;return ac(a,b,c)|0}function _b(a,b,c){a=a|0;b=b|0;c=c|0;return xb(a,b,c)|0}function Pc(a,b,c){a=a|0;b=b|0;c=c|0;return mc(a,b,c)|0}function Df(a,b,c){a=a|0;b=b|0;c=c|0;return jd(a,b,c)|0}function sd(a){jb(a);wa(a+40|0);wa(a+80|0);jb(a+120|0)}function bc(a,b){a=a|0;b=b|0;Fa(b,32);return lc(a,b)|0}function Bj(a,b){a=a|0;b=b|0;Fa(b,32);return Qc(a,b)|0}function wd(a,b,c,d,e){return i[l[9167]](a,b,c,d,e)|0}function md(a,b,c,d,e){return i[l[9174]](a,b,c,d,e)|0}function lc(a,b){a=a|0;b=b|0;return i[l[9173]](a,b)|0}function Wb(a,b){a=uj(a,b);return m[a|0]==(b&255)?a:0}function Sk(a,b,c){a=a|0;b=b|0;c=c|0;qb(a,b,0,1787,c)}function Ob(a,b,c,d,e){return i[l[9168]](a,b,c,d,e)|0}function Ia(a,b){a=a|0;b=b|0;return i[l[9169]](a,b)|0}function Ha(a,b){a=a|0;b=b|0;return i[l[9171]](a,b)|0}function ra(){var a=0;a=l[9325];if(a){i[a]()}F();A()}function jf(a,b,c,d,e,f,g){return Rb(a,b,c,d,e,f,g)}function ed(a,b,c,d,e,f){return vf(a,b,c,d,e,0,0,f)}function de(a,b,c,d,e,f){ee(a,b,c,d,e,f,0);return 0}function _c(a,b,c,d,e,f,g){return bd(a,b,c,d,e,f,g)}function Zc(a,b,c,d,e,f,g){return ad(a,b,c,d,e,f,g)}function Vc(a,b,c,d,e,f,g){return Xc(a,b,c,d,e,f,g)}function Uc(a,b,c,d,e,f,g){return Wc(a,b,c,d,e,f,g)}function ja(a,b,c,d){return i[l[9170]](a,b,c,d)|0}function wb(a,b){a=a|0;b=b|0;return rc(a,b,16)|0}function Pb(a,b){a=a|0;b=b|0;return rc(a,b,32)|0}function Cd(a,b){a=a|0;b=b|0;return rc(a,b,64)|0}function Be(a){l[a+8>>2]=0;l[a>>2]=0;l[a+4>>2]=0}function rf(a,b,c,d,e,f){return uf(a,b,c,d,e,f)}function qf(a,b,c,d,e,f){return tf(a,b,c,d,e,f)}function Li(a,b){a=a|0;b=b|0;return he(a,b,1)|0}function Ki(a,b){a=a|0;b=b|0;return he(a,b,0)|0}function xc(a,b){gb(a);if(b){Da(a,36608,34,0)}}function Ze(a,b,c){a=a|0;b=b|0;c=c|0;va(a,b,c)}function Tg(a,b,c){a=a|0;b=b|0;c=c|0;Ik(a,b,c)}function Kj(a,b,c){a=a|0;b=b|0;c=c|0;Sc(a,b,c)}function Jj(a,b,c){a=a|0;b=b|0;c=c|0;_e(a,b,c)}function xj(a,b){a=a|0;b=b|0;return Ia(a,b)|0}function wj(a,b){a=a|0;b=b|0;return Ha(a,b)|0}function pf(a,b){a=a|0;b=b|0;return bc(a,b)|0}function ni(a,b){a=a|0;b=b|0;return fe(a,b)|0}function ig(a,b){a=a|0;b=b|0;Ad(a,b);return 0}function gg(a,b){a=a|0;b=b|0;yd(a,b);return 0}function cf(a,b){a=a|0;b=b|0;cl(a,b);return 0}function ae(a,b,c,d,e){return be(a,b,c,d,e,0)}function Xe(a,b){a=a|0;b=b|0;Zk(a,b);return 0}function Uj(a,b){a=a|0;b=b|0;al(a,b);return 0}function Qc(a,b){a=a|0;b=b|0;return lc(a,b)|0}function Nj(a,b){a=a|0;b=b|0;return af(a,b)|0}function Ea(a,b){return((a^b)&255)+ -1>>>31|0}function ql(a,b,c,d){a=ol(a,b,c,d);return a}function Yf(a,b,c){gl(a,r(b,960)+3536|0,c)}function id(a,b,c,d){Da(a,b,c,d);return 0}function cc(a,b,c,d){eb(a,b,c,d);return 0}function Ke(a,b,c,d){return Je(a,b,c,d,1)}function Ie(a,b,c,d){return Je(a,b,c,d,2)}function za(a,b,c,d){return zb(a,b,c,d)}function wa(a){l[a>>2]=1;na(a+4|0,0,36)}function da(a,b,c){a=tl(a,b,c);return a}function Xa(a,b,c,d){return za(a,b,c,d)}function Cf(a,b,c,d){return id(a,b,c,d)}function _(a,b,c){a=vl(a,b,c);return a}function Oc(a){if((a&-7)!=1){ra();A()}}function ai(a){a=a|0;return M(a|0)|0}function Mj(a,b){a=a|0;b=b|0;Tc(a,b)}function Lj(a,b){a=a|0;b=b|0;$e(a,b)}function Ij(a,b){a=a|0;b=b|0;Rc(a,b)}function mi(a){a=a|0;return _d(a)|0}function _d(a){a=a|0;gb(a);return 0}function Zf(a){return(a&128)>>>7|0}function ba(a,b){return sl(a,b)}function Jc(){return-2147483648}function Hc(){return 1073741824}function oc(a,b){Tf(a,b,kb(b))}function jj(){return 134217728}function ij(){return 536870912}function Ge(){return 268435456}function $(a,b){return ul(a,b)}function xi(a){a=a|0;Fa(a,16)}function ua(a){a=a|0;Fa(a,32)}function me(){return 16777216}function db(a,b){pa(a,b,1024)}function Pe(){return 33554432}function He(){return 67108864}function Fc(a){Be(a);return 0}function Ec(a){Ce(a);return 0}function nl(a,b){f(a|0,b|0)}function Ui(){return 524288}function Qb(a){na(a,0,1024)}function yj(){return 36298}function yi(){return 36592}function wk(){return 35792}function vj(){return 36312}function ub(a,b){va(a,b,b)}function pi(){return 36642}function mk(){return 36176}function lj(){return 36434}function ji(){return 36650}function hj(){return 36444}function gj(){return 36455}function ek(){return 36224}function ci(){return 36659}function bj(){return 36476}function Wi(){return 36549}function Vi(){return 32768}function Oj(a){a=a|0;bf(a)}function Hj(){return 36272}function Hi(){return 36553}function Ej(){return 36279}function Dj(){return 36287}function jb(a){na(a,0,40)}function hl(){return 1024}function Kc(){return 8192}function vd(){return 256}function kf(){return 384}function dc(){return 208}function Xi(){return 102}function Lc(){return 128}function Gj(){return 104}function Ff(){return 416}function xa(){return 64}function ka(){return 16}function hf(){return 48}function fa(){return 32}function bi(){return 10}function Za(){return-17}function Pf(){return 12}function Ka(){return 24}function Ci(){return 52}function Bi(){return 17}function Ai(){return-18}function $d(){return-65}function ya(){return-1}function nb(){return 2}function kj(){return 6}function Wa(){return 0}function Qa(){return 8}function Ic(){return 4}function Bb(){return 1}function Ab(){return 3}function ml(){}\n// EMSCRIPTEN_END_FUNCS\ni[1]=Bd;i[2]=jg;i[3]=ig;i[4]=hg;i[5]=gg;i[6]=Yk;i[7]=Vk;i[8]=Tk;i[9]=Rk;i[10]=Pk;i[11]=Ok;i[12]=Nk;i[13]=Mk;function L(){return buffer.byteLength/65536|0}function M(pagesToAdd){pagesToAdd=pagesToAdd|0;var N=L()|0;var O=N+pagesToAdd|0;if(N<O&&O<65536){var P=new ArrayBuffer(r(O,65536));var Q=new global.Int8Array(P);Q.set(j);j=Q;j=new global.Int8Array(P);k=new global.Int16Array(P);l=new global.Int32Array(P);m=new global.Uint8Array(P);n=new global.Uint16Array(P);o=new global.Uint32Array(P);p=new global.Float32Array(P);q=new global.Float64Array(P);buffer=P;h.buffer=P}return N}return{\"__wasm_call_ctors\":ml,\"crypto_aead_chacha20poly1305_encrypt_detached\":$h,\"crypto_aead_chacha20poly1305_encrypt\":_h,\"crypto_aead_chacha20poly1305_ietf_encrypt_detached\":Zh,\"crypto_aead_chacha20poly1305_ietf_encrypt\":Yh,\"crypto_aead_chacha20poly1305_decrypt_detached\":Xh,\"crypto_aead_chacha20poly1305_decrypt\":Wh,\"crypto_aead_chacha20poly1305_ietf_decrypt_detached\":Vh,\"crypto_aead_chacha20poly1305_ietf_decrypt\":Uh,\"crypto_aead_chacha20poly1305_ietf_keybytes\":fa,\"crypto_aead_chacha20poly1305_ietf_npubbytes\":Pf,\"crypto_aead_chacha20poly1305_ietf_nsecbytes\":Wa,\"crypto_aead_chacha20poly1305_ietf_abytes\":ka,\"crypto_aead_chacha20poly1305_ietf_messagebytes_max\":Za,\"crypto_aead_chacha20poly1305_ietf_keygen\":ua,\"crypto_aead_chacha20poly1305_keybytes\":fa,\"crypto_aead_chacha20poly1305_npubbytes\":Qa,\"crypto_aead_chacha20poly1305_nsecbytes\":Wa,\"crypto_aead_chacha20poly1305_abytes\":ka,\"crypto_aead_chacha20poly1305_messagebytes_max\":Za,\"crypto_aead_chacha20poly1305_keygen\":ua,\"crypto_aead_xchacha20poly1305_ietf_encrypt_detached\":Th,\"crypto_aead_xchacha20poly1305_ietf_encrypt\":Sh,\"crypto_aead_xchacha20poly1305_ietf_decrypt_detached\":Rh,\"crypto_aead_xchacha20poly1305_ietf_decrypt\":Qh,\"crypto_aead_xchacha20poly1305_ietf_keybytes\":fa,\"crypto_aead_xchacha20poly1305_ietf_npubbytes\":Ka,\"crypto_aead_xchacha20poly1305_ietf_nsecbytes\":Wa,\"crypto_aead_xchacha20poly1305_ietf_abytes\":ka,\"crypto_aead_xchacha20poly1305_ietf_messagebytes_max\":Za,\"crypto_aead_xchacha20poly1305_ietf_keygen\":ua,\"crypto_auth_bytes\":fa,\"crypto_auth_keybytes\":fa,\"crypto_auth_primitive\":wk,\"crypto_auth\":Wd,\"crypto_auth_verify\":Vd,\"crypto_auth_keygen\":ua,\"crypto_auth_hmacsha256_bytes\":fa,\"crypto_auth_hmacsha256_keybytes\":fa,\"crypto_auth_hmacsha256_statebytes\":dc,\"crypto_auth_hmacsha256_keygen\":ua,\"crypto_auth_hmacsha256_init\":gd,\"crypto_auth_hmacsha256_update\":Ph,\"crypto_auth_hmacsha256_final\":fd,\"crypto_auth_hmacsha256\":Oh,\"crypto_auth_hmacsha256_verify\":Nh,\"crypto_auth_hmacsha512_bytes\":xa,\"crypto_auth_hmacsha512_keybytes\":fa,\"crypto_auth_hmacsha512_statebytes\":Ff,\"crypto_auth_hmacsha512_keygen\":ua,\"crypto_auth_hmacsha512_init\":jd,\"crypto_auth_hmacsha512_update\":Cf,\"crypto_auth_hmacsha512_final\":hd,\"crypto_auth_hmacsha512\":Mh,\"crypto_auth_hmacsha512_verify\":Lh,\"crypto_auth_hmacsha512256_bytes\":fa,\"crypto_auth_hmacsha512256_keybytes\":fa,\"crypto_auth_hmacsha512256_statebytes\":Ff,\"crypto_auth_hmacsha512256_keygen\":ua,\"crypto_auth_hmacsha512256_init\":Df,\"crypto_auth_hmacsha512256_update\":Kh,\"crypto_auth_hmacsha512256_final\":Bf,\"crypto_auth_hmacsha512256\":Wd,\"crypto_auth_hmacsha512256_verify\":Vd,\"crypto_box_seedbytes\":fa,\"crypto_box_publickeybytes\":fa,\"crypto_box_secretkeybytes\":fa,\"crypto_box_beforenmbytes\":fa,\"crypto_box_noncebytes\":Ka,\"crypto_box_zerobytes\":fa,\"crypto_box_boxzerobytes\":ka,\"crypto_box_macbytes\":ka,\"crypto_box_messagebytes_max\":Za,\"crypto_box_primitive\":mk,\"crypto_box_seed_keypair\":lk,\"crypto_box_keypair\":pf,\"crypto_box_beforenm\":cd,\"crypto_box_afternm\":vc,\"crypto_box_open_afternm\":uc,\"crypto_box\":Ud,\"crypto_box_open\":Td,\"crypto_box_detached_afternm\":Jh,\"crypto_box_detached\":Ih,\"crypto_box_easy_afternm\":Hh,\"crypto_box_easy\":Gh,\"crypto_box_open_detached_afternm\":Fh,\"crypto_box_open_detached\":Eh,\"crypto_box_open_easy_afternm\":Dh,\"crypto_box_open_easy\":Ch,\"crypto_box_seal\":Bh,\"crypto_box_seal_open\":Ah,\"crypto_box_sealbytes\":hf,\"crypto_box_curve25519xsalsa20poly1305_seed_keypair\":dd,\"crypto_box_curve25519xsalsa20poly1305_keypair\":bc,\"crypto_box_curve25519xsalsa20poly1305_beforenm\":ac,\"crypto_box_curve25519xsalsa20poly1305_afternm\":vc,\"crypto_box_curve25519xsalsa20poly1305_open_afternm\":uc,\"crypto_box_curve25519xsalsa20poly1305\":Ud,\"crypto_box_curve25519xsalsa20poly1305_open\":Td,\"crypto_box_curve25519xsalsa20poly1305_seedbytes\":fa,\"crypto_box_curve25519xsalsa20poly1305_publickeybytes\":fa,\"crypto_box_curve25519xsalsa20poly1305_secretkeybytes\":fa,\"crypto_box_curve25519xsalsa20poly1305_beforenmbytes\":fa,\"crypto_box_curve25519xsalsa20poly1305_noncebytes\":Ka,\"crypto_box_curve25519xsalsa20poly1305_zerobytes\":fa,\"crypto_box_curve25519xsalsa20poly1305_boxzerobytes\":ka,\"crypto_box_curve25519xsalsa20poly1305_macbytes\":ka,\"crypto_box_curve25519xsalsa20poly1305_messagebytes_max\":Za,\"crypto_core_hchacha20\":Pa,\"crypto_core_hchacha20_outputbytes\":fa,\"crypto_core_hchacha20_inputbytes\":ka,\"crypto_core_hchacha20_keybytes\":fa,\"crypto_core_hchacha20_constbytes\":ka,\"crypto_core_hsalsa20\":pb,\"crypto_core_hsalsa20_outputbytes\":fa,\"crypto_core_hsalsa20_inputbytes\":ka,\"crypto_core_hsalsa20_keybytes\":fa,\"crypto_core_hsalsa20_constbytes\":ka,\"crypto_core_salsa20\":Jb,\"crypto_core_salsa20_outputbytes\":xa,\"crypto_core_salsa20_inputbytes\":ka,\"crypto_core_salsa20_keybytes\":fa,\"crypto_core_salsa20_constbytes\":ka,\"crypto_core_salsa2012\":Ib,\"crypto_core_salsa2012_outputbytes\":xa,\"crypto_core_salsa2012_inputbytes\":ka,\"crypto_core_salsa2012_keybytes\":fa,\"crypto_core_salsa2012_constbytes\":ka,\"crypto_core_salsa208\":Hb,\"crypto_core_salsa208_outputbytes\":xa,\"crypto_core_salsa208_inputbytes\":ka,\"crypto_core_salsa208_keybytes\":fa,\"crypto_core_salsa208_constbytes\":ka,\"crypto_generichash_bytes_min\":ka,\"crypto_generichash_bytes_max\":xa,\"crypto_generichash_bytes\":fa,\"crypto_generichash_keybytes_min\":ka,\"crypto_generichash_keybytes_max\":xa,\"crypto_generichash_keybytes\":fa,\"crypto_generichash_primitive\":ek,\"crypto_generichash_statebytes\":kf,\"crypto_generichash\":zh,\"crypto_generichash_init\":$b,\"crypto_generichash_update\":yh,\"crypto_generichash_final\":_b,\"crypto_generichash_keygen\":ua,\"crypto_generichash_blake2b_bytes_min\":ka,\"crypto_generichash_blake2b_bytes_max\":xa,\"crypto_generichash_blake2b_bytes\":fa,\"crypto_generichash_blake2b_keybytes_min\":ka,\"crypto_generichash_blake2b_keybytes_max\":xa,\"crypto_generichash_blake2b_keybytes\":fa,\"crypto_generichash_blake2b_saltbytes\":ka,\"crypto_generichash_blake2b_personalbytes\":ka,\"crypto_generichash_blake2b_statebytes\":kf,\"crypto_generichash_blake2b_keygen\":ua,\"crypto_generichash_blake2b\":jf,\"crypto_generichash_blake2b_salt_personal\":xh,\"crypto_generichash_blake2b_init\":yb,\"crypto_generichash_blake2b_init_salt_personal\":fi,\"crypto_generichash_blake2b_update\":Xa,\"crypto_generichash_blake2b_final\":xb,\"crypto_hash_bytes\":xa,\"crypto_hash\":Sd,\"crypto_hash_primitive\":Hj,\"crypto_hash_sha256_bytes\":fa,\"crypto_hash_sha256_statebytes\":Gj,\"crypto_hash_sha256_init\":Eb,\"crypto_hash_sha256_update\":vh,\"crypto_hash_sha256_final\":Db,\"crypto_hash_sha256\":uh,\"crypto_hash_sha512_bytes\":xa,\"crypto_hash_sha512_statebytes\":dc,\"crypto_hash_sha512_init\":gb,\"crypto_hash_sha512_update\":Hd,\"crypto_hash_sha512_final\":Oa,\"crypto_hash_sha512\":Sd,\"crypto_kdf_blake2b_bytes_min\":ka,\"crypto_kdf_blake2b_bytes_max\":xa,\"crypto_kdf_blake2b_contextbytes\":Qa,\"crypto_kdf_blake2b_keybytes\":fa,\"crypto_kdf_blake2b_derive_from_key\":Rd,\"crypto_kdf_primitive\":Ej,\"crypto_kdf_bytes_min\":ka,\"crypto_kdf_bytes_max\":xa,\"crypto_kdf_contextbytes\":Qa,\"crypto_kdf_keybytes\":fa,\"crypto_kdf_derive_from_key\":Rd,\"crypto_kdf_keygen\":ua,\"crypto_kx_seed_keypair\":Cj,\"crypto_kx_keypair\":Bj,\"crypto_kx_client_session_keys\":Aj,\"crypto_kx_server_session_keys\":zj,\"crypto_kx_publickeybytes\":fa,\"crypto_kx_secretkeybytes\":fa,\"crypto_kx_seedbytes\":fa,\"crypto_kx_sessionkeybytes\":fa,\"crypto_kx_primitive\":yj,\"crypto_onetimeauth_statebytes\":vd,\"crypto_onetimeauth_bytes\":ka,\"crypto_onetimeauth_keybytes\":fa,\"crypto_onetimeauth\":Qd,\"crypto_onetimeauth_verify\":Pd,\"crypto_onetimeauth_init\":xj,\"crypto_onetimeauth_update\":Od,\"crypto_onetimeauth_final\":wj,\"crypto_onetimeauth_primitive\":vj,\"crypto_onetimeauth_keygen\":ua,\"crypto_onetimeauth_poly1305\":Qd,\"crypto_onetimeauth_poly1305_verify\":Pd,\"crypto_onetimeauth_poly1305_init\":Ia,\"crypto_onetimeauth_poly1305_update\":Od,\"crypto_onetimeauth_poly1305_final\":Ha,\"crypto_onetimeauth_poly1305_bytes\":ka,\"crypto_onetimeauth_poly1305_keybytes\":fa,\"crypto_onetimeauth_poly1305_statebytes\":vd,\"crypto_onetimeauth_poly1305_keygen\":ua,\"crypto_pwhash_argon2i_alg_argon2i13\":Bb,\"crypto_pwhash_argon2i_bytes_min\":ka,\"crypto_pwhash_argon2i_bytes_max\":ya,\"crypto_pwhash_argon2i_passwd_min\":Wa,\"crypto_pwhash_argon2i_passwd_max\":ya,\"crypto_pwhash_argon2i_saltbytes\":ka,\"crypto_pwhash_argon2i_strbytes\":Lc,\"crypto_pwhash_argon2i_strprefix\":lj,\"crypto_pwhash_argon2i_opslimit_min\":Ab,\"crypto_pwhash_argon2i_opslimit_max\":ya,\"crypto_pwhash_argon2i_memlimit_min\":Kc,\"crypto_pwhash_argon2i_memlimit_max\":Jc,\"crypto_pwhash_argon2i_opslimit_interactive\":Ic,\"crypto_pwhash_argon2i_memlimit_interactive\":Pe,\"crypto_pwhash_argon2i_opslimit_moderate\":kj,\"crypto_pwhash_argon2i_memlimit_moderate\":jj,\"crypto_pwhash_argon2i_opslimit_sensitive\":Qa,\"crypto_pwhash_argon2i_memlimit_sensitive\":ij,\"crypto_pwhash_argon2i\":th,\"crypto_pwhash_argon2i_str\":rh,\"crypto_pwhash_argon2i_str_verify\":qh,\"crypto_pwhash_argon2i_str_needs_rehash\":ph,\"crypto_pwhash_argon2id_str_needs_rehash\":oh,\"crypto_pwhash_argon2id_alg_argon2id13\":nb,\"crypto_pwhash_argon2id_bytes_min\":ka,\"crypto_pwhash_argon2id_bytes_max\":ya,\"crypto_pwhash_argon2id_passwd_min\":Wa,\"crypto_pwhash_argon2id_passwd_max\":ya,\"crypto_pwhash_argon2id_saltbytes\":ka,\"crypto_pwhash_argon2id_strbytes\":Lc,\"crypto_pwhash_argon2id_strprefix\":hj,\"crypto_pwhash_argon2id_opslimit_min\":Bb,\"crypto_pwhash_argon2id_opslimit_max\":ya,\"crypto_pwhash_argon2id_memlimit_min\":Kc,\"crypto_pwhash_argon2id_memlimit_max\":Jc,\"crypto_pwhash_argon2id_opslimit_interactive\":nb,\"crypto_pwhash_argon2id_memlimit_interactive\":He,\"crypto_pwhash_argon2id_opslimit_moderate\":Ab,\"crypto_pwhash_argon2id_memlimit_moderate\":Ge,\"crypto_pwhash_argon2id_opslimit_sensitive\":Ic,\"crypto_pwhash_argon2id_memlimit_sensitive\":Hc,\"crypto_pwhash_argon2id\":nh,\"crypto_pwhash_argon2id_str\":Nd,\"crypto_pwhash_argon2id_str_verify\":mh,\"crypto_pwhash_alg_argon2i13\":Bb,\"crypto_pwhash_alg_argon2id13\":nb,\"crypto_pwhash_alg_default\":nb,\"crypto_pwhash_bytes_min\":ka,\"crypto_pwhash_bytes_max\":ya,\"crypto_pwhash_passwd_min\":Wa,\"crypto_pwhash_passwd_max\":ya,\"crypto_pwhash_saltbytes\":ka,\"crypto_pwhash_strbytes\":Lc,\"crypto_pwhash_strprefix\":gj,\"crypto_pwhash_opslimit_min\":Bb,\"crypto_pwhash_opslimit_max\":ya,\"crypto_pwhash_memlimit_min\":Kc,\"crypto_pwhash_memlimit_max\":Jc,\"crypto_pwhash_opslimit_interactive\":nb,\"crypto_pwhash_memlimit_interactive\":He,\"crypto_pwhash_opslimit_moderate\":Ab,\"crypto_pwhash_memlimit_moderate\":Ge,\"crypto_pwhash_opslimit_sensitive\":Ic,\"crypto_pwhash_memlimit_sensitive\":Hc,\"crypto_pwhash\":lh,\"crypto_pwhash_str\":Nd,\"crypto_pwhash_str_alg\":kh,\"crypto_pwhash_str_verify\":jh,\"crypto_pwhash_str_needs_rehash\":hh,\"crypto_pwhash_primitive\":bj,\"crypto_scalarmult_primitive\":Dj,\"crypto_scalarmult_base\":Qc,\"crypto_scalarmult\":Pc,\"crypto_scalarmult_bytes\":fa,\"crypto_scalarmult_scalarbytes\":fa,\"crypto_scalarmult_curve25519\":mc,\"crypto_scalarmult_curve25519_base\":lc,\"crypto_scalarmult_curve25519_bytes\":fa,\"crypto_scalarmult_curve25519_scalarbytes\":fa,\"crypto_secretbox_keybytes\":fa,\"crypto_secretbox_noncebytes\":Ka,\"crypto_secretbox_zerobytes\":fa,\"crypto_secretbox_boxzerobytes\":ka,\"crypto_secretbox_macbytes\":ka,\"crypto_secretbox_messagebytes_max\":Za,\"crypto_secretbox_primitive\":Hi,\"crypto_secretbox\":vc,\"crypto_secretbox_open\":uc,\"crypto_secretbox_keygen\":ua,\"crypto_secretbox_detached\":Vc,\"crypto_secretbox_easy\":gh,\"crypto_secretbox_open_detached\":Uc,\"crypto_secretbox_open_easy\":fh,\"crypto_secretbox_xsalsa20poly1305\":rf,\"crypto_secretbox_xsalsa20poly1305_open\":qf,\"crypto_secretbox_xsalsa20poly1305_keybytes\":fa,\"crypto_secretbox_xsalsa20poly1305_noncebytes\":Ka,\"crypto_secretbox_xsalsa20poly1305_zerobytes\":fa,\"crypto_secretbox_xsalsa20poly1305_boxzerobytes\":ka,\"crypto_secretbox_xsalsa20poly1305_macbytes\":ka,\"crypto_secretbox_xsalsa20poly1305_messagebytes_max\":Za,\"crypto_secretbox_xsalsa20poly1305_keygen\":ua,\"crypto_secretstream_xchacha20poly1305_keygen\":ua,\"crypto_secretstream_xchacha20poly1305_init_push\":Gi,\"crypto_secretstream_xchacha20poly1305_init_pull\":Fi,\"crypto_secretstream_xchacha20poly1305_rekey\":zc,\"crypto_secretstream_xchacha20poly1305_push\":eh,\"crypto_secretstream_xchacha20poly1305_pull\":dh,\"crypto_secretstream_xchacha20poly1305_statebytes\":Ci,\"crypto_secretstream_xchacha20poly1305_abytes\":Bi,\"crypto_secretstream_xchacha20poly1305_headerbytes\":Ka,\"crypto_secretstream_xchacha20poly1305_keybytes\":fa,\"crypto_secretstream_xchacha20poly1305_messagebytes_max\":Ai,\"crypto_secretstream_xchacha20poly1305_tag_message\":Wa,\"crypto_secretstream_xchacha20poly1305_tag_push\":Bb,\"crypto_secretstream_xchacha20poly1305_tag_rekey\":nb,\"crypto_secretstream_xchacha20poly1305_tag_final\":Ab,\"crypto_shorthash_bytes\":Qa,\"crypto_shorthash_keybytes\":ka,\"crypto_shorthash_primitive\":yi,\"crypto_shorthash\":Md,\"crypto_shorthash_keygen\":xi,\"crypto_shorthash_siphash24_bytes\":Qa,\"crypto_shorthash_siphash24_keybytes\":ka,\"crypto_shorthash_siphash24\":Md,\"crypto_sign_statebytes\":dc,\"crypto_sign_bytes\":xa,\"crypto_sign_seedbytes\":fa,\"crypto_sign_publickeybytes\":fa,\"crypto_sign_secretkeybytes\":xa,\"crypto_sign_messagebytes_max\":$d,\"crypto_sign_primitive\":pi,\"crypto_sign_seed_keypair\":oi,\"crypto_sign_keypair\":ni,\"crypto_sign\":Ld,\"crypto_sign_open\":Kd,\"crypto_sign_detached\":Jd,\"crypto_sign_verify_detached\":Id,\"crypto_sign_init\":mi,\"crypto_sign_update\":Hd,\"crypto_sign_final_create\":li,\"crypto_sign_final_verify\":ki,\"crypto_sign_ed25519ph_statebytes\":dc,\"crypto_sign_ed25519_bytes\":xa,\"crypto_sign_ed25519_seedbytes\":fa,\"crypto_sign_ed25519_publickeybytes\":fa,\"crypto_sign_ed25519_secretkeybytes\":xa,\"crypto_sign_ed25519_messagebytes_max\":$d,\"crypto_sign_ed25519_sk_to_seed\":ri,\"crypto_sign_ed25519_sk_to_pk\":qi,\"crypto_sign_ed25519ph_init\":_d,\"crypto_sign_ed25519ph_update\":Hd,\"crypto_sign_ed25519ph_final_create\":Zd,\"crypto_sign_ed25519ph_final_verify\":Yd,\"crypto_sign_ed25519_seed_keypair\":yc,\"crypto_sign_ed25519_keypair\":fe,\"crypto_sign_ed25519_pk_to_curve25519\":vi,\"crypto_sign_ed25519_sk_to_curve25519\":ui,\"crypto_sign_ed25519_verify_detached\":Id,\"crypto_sign_ed25519_open\":Kd,\"crypto_sign_ed25519_detached\":Jd,\"crypto_sign_ed25519\":Ld,\"crypto_stream_chacha20_keybytes\":fa,\"crypto_stream_chacha20_noncebytes\":Qa,\"crypto_stream_chacha20_messagebytes_max\":ya,\"crypto_stream_chacha20_ietf_keybytes\":fa,\"crypto_stream_chacha20_ietf_noncebytes\":Pf,\"crypto_stream_chacha20_ietf_messagebytes_max\":ya,\"crypto_stream_chacha20\":ch,\"crypto_stream_chacha20_xor_ic\":bh,\"crypto_stream_chacha20_xor\":ah,\"crypto_stream_chacha20_ietf\":$g,\"crypto_stream_chacha20_ietf_xor_ic\":_g,\"crypto_stream_chacha20_ietf_xor\":Yg,\"crypto_stream_chacha20_ietf_keygen\":ua,\"crypto_stream_chacha20_keygen\":ua,\"crypto_stream_keybytes\":fa,\"crypto_stream_noncebytes\":Ka,\"crypto_stream_messagebytes_max\":ya,\"crypto_stream_primitive\":ji,\"crypto_stream\":Gd,\"crypto_stream_xor\":Fd,\"crypto_stream_keygen\":ua,\"crypto_stream_salsa20_keybytes\":fa,\"crypto_stream_salsa20_noncebytes\":Qa,\"crypto_stream_salsa20_messagebytes_max\":ya,\"crypto_stream_salsa20\":Xg,\"crypto_stream_salsa20_xor_ic\":Wg,\"crypto_stream_salsa20_xor\":Vg,\"crypto_stream_salsa20_keygen\":ua,\"crypto_stream_xsalsa20\":Gd,\"crypto_stream_xsalsa20_xor_ic\":Ug,\"crypto_stream_xsalsa20_xor\":Fd,\"crypto_stream_xsalsa20_keybytes\":fa,\"crypto_stream_xsalsa20_noncebytes\":Ka,\"crypto_stream_xsalsa20_messagebytes_max\":ya,\"crypto_stream_xsalsa20_keygen\":ua,\"crypto_verify_16_bytes\":ka,\"crypto_verify_32_bytes\":fa,\"crypto_verify_64_bytes\":xa,\"crypto_verify_16\":wb,\"crypto_verify_32\":Pb,\"crypto_verify_64\":Cd,\"randombytes_implementation_name\":hl,\"randombytes_random\":rd,\"randombytes_stir\":Xf,\"randombytes_uniform\":_k,\"randombytes_buf\":Fa,\"randombytes_buf_deterministic\":Sk,\"randombytes_seedbytes\":fa,\"randombytes_close\":Lk,\"randombytes\":Tg,\"sodium_bin2hex\":tj,\"sodium_hex2bin\":sj,\"sodium_base64_encoded_len\":rj,\"sodium_bin2base64\":Nc,\"sodium_base642bin\":Mc,\"sodium_init\":Qk,\"sodium_pad\":kk,\"sodium_unpad\":gk,\"sodium_version_string\":ci,\"sodium_library_version_major\":bi,\"sodium_library_version_minor\":Ab,\"sodium_library_minimal\":Wa,\"crypto_box_curve25519xchacha20poly1305_seed_keypair\":dd,\"crypto_box_curve25519xchacha20poly1305_keypair\":bc,\"crypto_box_curve25519xchacha20poly1305_beforenm\":$c,\"crypto_box_curve25519xchacha20poly1305_detached_afternm\":Sg,\"crypto_box_curve25519xchacha20poly1305_detached\":Rg,\"crypto_box_curve25519xchacha20poly1305_easy_afternm\":Qg,\"crypto_box_curve25519xchacha20poly1305_easy\":Pg,\"crypto_box_curve25519xchacha20poly1305_open_detached_afternm\":Og,\"crypto_box_curve25519xchacha20poly1305_open_detached\":Ng,\"crypto_box_curve25519xchacha20poly1305_open_easy_afternm\":Mg,\"crypto_box_curve25519xchacha20poly1305_open_easy\":Lg,\"crypto_box_curve25519xchacha20poly1305_seedbytes\":fa,\"crypto_box_curve25519xchacha20poly1305_publickeybytes\":fa,\"crypto_box_curve25519xchacha20poly1305_secretkeybytes\":fa,\"crypto_box_curve25519xchacha20poly1305_beforenmbytes\":fa,\"crypto_box_curve25519xchacha20poly1305_noncebytes\":Ka,\"crypto_box_curve25519xchacha20poly1305_macbytes\":ka,\"crypto_box_curve25519xchacha20poly1305_messagebytes_max\":Za,\"crypto_box_curve25519xchacha20poly1305_seal\":Kg,\"crypto_box_curve25519xchacha20poly1305_seal_open\":Jg,\"crypto_box_curve25519xchacha20poly1305_sealbytes\":hf,\"crypto_core_ed25519_is_valid_point\":Xj,\"crypto_core_ed25519_add\":Wj,\"crypto_core_ed25519_sub\":Vj,\"crypto_core_ed25519_from_uniform\":cf,\"crypto_core_ed25519_from_hash\":Uj,\"crypto_core_ed25519_random\":Tj,\"crypto_core_ed25519_scalar_random\":bf,\"crypto_core_ed25519_scalar_invert\":af,\"crypto_core_ed25519_scalar_negate\":Tc,\"crypto_core_ed25519_scalar_complement\":$e,\"crypto_core_ed25519_scalar_add\":Sc,\"crypto_core_ed25519_scalar_reduce\":Rc,\"crypto_core_ed25519_scalar_sub\":_e,\"crypto_core_ed25519_scalar_mul\":Ze,\"crypto_core_ed25519_bytes\":fa,\"crypto_core_ed25519_nonreducedscalarbytes\":xa,\"crypto_core_ed25519_uniformbytes\":fa,\"crypto_core_ed25519_hashbytes\":xa,\"crypto_core_ed25519_scalarbytes\":fa,\"crypto_core_ristretto255_is_valid_point\":Sj,\"crypto_core_ristretto255_add\":Rj,\"crypto_core_ristretto255_sub\":Qj,\"crypto_core_ristretto255_from_hash\":Xe,\"crypto_core_ristretto255_random\":Pj,\"crypto_core_ristretto255_scalar_random\":Oj,\"crypto_core_ristretto255_scalar_invert\":Nj,\"crypto_core_ristretto255_scalar_negate\":Mj,\"crypto_core_ristretto255_scalar_complement\":Lj,\"crypto_core_ristretto255_scalar_add\":Kj,\"crypto_core_ristretto255_scalar_sub\":Jj,\"crypto_core_ristretto255_scalar_mul\":Ze,\"crypto_core_ristretto255_scalar_reduce\":Ij,\"crypto_core_ristretto255_bytes\":fa,\"crypto_core_ristretto255_nonreducedscalarbytes\":xa,\"crypto_core_ristretto255_hashbytes\":xa,\"crypto_core_ristretto255_scalarbytes\":fa,\"crypto_pwhash_scryptsalsa208sha256_ll\":Ig,\"crypto_pwhash_scryptsalsa208sha256_bytes_min\":ka,\"crypto_pwhash_scryptsalsa208sha256_bytes_max\":ya,\"crypto_pwhash_scryptsalsa208sha256_passwd_min\":Wa,\"crypto_pwhash_scryptsalsa208sha256_passwd_max\":ya,\"crypto_pwhash_scryptsalsa208sha256_saltbytes\":fa,\"crypto_pwhash_scryptsalsa208sha256_strbytes\":Xi,\"crypto_pwhash_scryptsalsa208sha256_strprefix\":Wi,\"crypto_pwhash_scryptsalsa208sha256_opslimit_min\":Vi,\"crypto_pwhash_scryptsalsa208sha256_opslimit_max\":ya,\"crypto_pwhash_scryptsalsa208sha256_memlimit_min\":me,\"crypto_pwhash_scryptsalsa208sha256_memlimit_max\":ya,\"crypto_pwhash_scryptsalsa208sha256_opslimit_interactive\":Ui,\"crypto_pwhash_scryptsalsa208sha256_memlimit_interactive\":me,\"crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive\":Pe,\"crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive\":Hc,\"crypto_pwhash_scryptsalsa208sha256\":Hg,\"crypto_pwhash_scryptsalsa208sha256_str\":Gg,\"crypto_pwhash_scryptsalsa208sha256_str_verify\":Fg,\"crypto_pwhash_scryptsalsa208sha256_str_needs_rehash\":Eg,\"crypto_scalarmult_ed25519\":Oi,\"crypto_scalarmult_ed25519_noclamp\":Mi,\"crypto_scalarmult_ed25519_base\":Li,\"crypto_scalarmult_ed25519_base_noclamp\":Ki,\"crypto_scalarmult_ed25519_bytes\":fa,\"crypto_scalarmult_ed25519_scalarbytes\":fa,\"crypto_scalarmult_ristretto255\":Ji,\"crypto_scalarmult_ristretto255_base\":Ii,\"crypto_scalarmult_ristretto255_bytes\":fa,\"crypto_scalarmult_ristretto255_scalarbytes\":fa,\"crypto_secretbox_xchacha20poly1305_detached\":_c,\"crypto_secretbox_xchacha20poly1305_easy\":Dg,\"crypto_secretbox_xchacha20poly1305_open_detached\":Zc,\"crypto_secretbox_xchacha20poly1305_open_easy\":Cg,\"crypto_secretbox_xchacha20poly1305_keybytes\":fa,\"crypto_secretbox_xchacha20poly1305_noncebytes\":Ka,\"crypto_secretbox_xchacha20poly1305_macbytes\":ka,\"crypto_secretbox_xchacha20poly1305_messagebytes_max\":Za,\"crypto_shorthash_siphashx24_bytes\":ka,\"crypto_shorthash_siphashx24_keybytes\":ka,\"crypto_shorthash_siphashx24\":Bg,\"crypto_stream_salsa2012\":Ag,\"crypto_stream_salsa2012_xor\":zg,\"crypto_stream_salsa2012_keybytes\":fa,\"crypto_stream_salsa2012_noncebytes\":Qa,\"crypto_stream_salsa2012_messagebytes_max\":ya,\"crypto_stream_salsa2012_keygen\":ua,\"crypto_stream_salsa208\":yg,\"crypto_stream_salsa208_xor\":xg,\"crypto_stream_salsa208_keybytes\":fa,\"crypto_stream_salsa208_noncebytes\":Qa,\"crypto_stream_salsa208_messagebytes_max\":ya,\"crypto_stream_salsa208_keygen\":ua,\"crypto_stream_xchacha20_keybytes\":fa,\"crypto_stream_xchacha20_noncebytes\":Ka,\"crypto_stream_xchacha20_messagebytes_max\":ya,\"crypto_stream_xchacha20\":wg,\"crypto_stream_xchacha20_xor_ic\":vg,\"crypto_stream_xchacha20_xor\":ug,\"crypto_stream_xchacha20_keygen\":ua,\"malloc\":Ma,\"free\":Aa,\"__growWasmMemory\":ai}}for(var R=new Uint8Array(123),S=25;S>=0;--S){R[48+S]=52+S;R[65+S]=S;R[97+S]=26+S}R[43]=62;R[47]=63;function T(uint8Array,offset,b64){var U,V,S=0,W=offset,X=b64.length,Y=offset+(X*3>>2)-(b64[X-2]==\"=\")-(b64[X-1]==\"=\");for(;S<X;S+=4){U=R[b64.charCodeAt(S+1)];V=R[b64.charCodeAt(S+2)];uint8Array[W++]=R[b64.charCodeAt(S)]<<2|U>>4;if(W<Y)uint8Array[W++]=U<<4|V>>2;if(W<Y)uint8Array[W++]=V<<6|R[b64.charCodeAt(S+3)]}}var Z=new Uint8Array(wasmMemory.buffer);T(Z,1024,\"anMAInsgcmV0dXJuIE1vZHVsZS5nZXRSYW5kb21WYWx1ZSgpOyB9IgB7IGlmIChNb2R1bGUuZ2V0UmFuZG9tVmFsdWUgPT09IHVuZGVmaW5lZCkgeyB0cnkgeyB2YXIgd2luZG93XyA9ICdvYmplY3QnID09PSB0eXBlb2Ygd2luZG93ID8gd2luZG93IDogc2VsZjsgdmFyIGNyeXB0b18gPSB0eXBlb2Ygd2luZG93Xy5jcnlwdG8gIT09ICd1bmRlZmluZWQnID8gd2luZG93Xy5jcnlwdG8gOiB3aW5kb3dfLm1zQ3J5cHRvOyB2YXIgcmFuZG9tVmFsdWVzU3RhbmRhcmQgPSBmdW5jdGlvbigpIHsgdmFyIGJ1ZiA9IG5ldyBVaW50MzJBcnJheSgxKTsgY3J5cHRvXy5nZXRSYW5kb21WYWx1ZXMoYnVmKTsgcmV0dXJuIGJ1ZlswXSA+Pj4gMDsgfTsgcmFuZG9tVmFsdWVzU3RhbmRhcmQoKTsgTW9kdWxlLmdldFJhbmRvbVZhbHVlID0gcmFuZG9tVmFsdWVzU3RhbmRhcmQ7IH0gY2F0Y2ggKGUpIHsgdHJ5IHsgdmFyIGNyeXB0byA9IHJlcXVpcmUoJ2NyeXB0bycpOyB2YXIgcmFuZG9tVmFsdWVOb2RlSlMgPSBmdW5jdGlvbigpIHsgdmFyIGJ1ZiA9IGNyeXB0b1sncmFuZG9tQnl0ZXMnXSg0KTsgcmV0dXJuIChidWZbMF0gPDwgMjQgfCBidWZbMV0gPDwgMTYgfCBidWZbMl0gPDwgOCB8IGJ1ZlszXSkgPj4+IDA7IH07IHJhbmRvbVZhbHVlTm9kZUpTKCk7IE1vZHVsZS5nZXRSYW5kb21WYWx1ZSA9IHJhbmRvbVZhbHVlTm9kZUpTOyB9IGNhdGNoIChlKSB7IHRocm93ICdObyBzZWN1cmUgcmFuZG9tIG51bWJlciBnZW5lcmF0b3IgZm91bmQnOyB9IH0gfSB9AExpYnNvZGl1bURSR2J1Zl9sZW4gPD0gU0laRV9NQVgAcmFuZG9tYnl0ZXMvcmFuZG9tYnl0ZXMuYwByYW5kb21ieXRlcwBTLT5idWZsZW4gPD0gQkxBS0UyQl9CTE9DS0JZVEVTAGNyeXB0b19nZW5lcmljaGFzaC9ibGFrZTJiL3JlZi9ibGFrZTJiLXJlZi5jAGJsYWtlMmJfZmluYWwAAAAAAAjJvPNn5glqO6fKhIWuZ7sr+JT+cvNuPPE2HV869U+l0YLmrX9SDlEfbD4rjGgFm2u9Qfur2YMfeSF+ExnN4FtvdXRsZW4gPD0gVUlOVDhfTUFYAGNyeXB0b19nZW5lcmljaGFzaC9ibGFrZTJiL3JlZi9nZW5lcmljaGFzaF9ibGFrZTJiLmMAY3J5cHRvX2dlbmVyaWNoYXNoX2JsYWtlMmJfZmluYWwAAAAAAAAAtnhZ/4Vy0wC9bhX/DwpqACnAAQCY6Hn/vDyg/5lxzv8At+L+tA1I/wAAAAAAAAAAsKAO/tPJhv+eGI8Af2k1AGAMvQCn1/v/n0yA/mpl4f8e/AQAkgyu\");T(Z,2224,\"WfGy/grlpv973Sr+HhTUAFKAAwAw0fMAd3lA/zLjnP8AbsUBZxuQ\");T(Z,2272,\"hTuMAb3xJP/4JcMBYNw3ALdMPv/DQj0AMkykAeGkTP9MPaP/dT4fAFGRQP92QQ4AonPW/waKLgB85vT/CoqPADQawgC49EwAgY8pAb70E/97qnr/YoFEAHnVkwBWZR7/oWebAIxZQ//v5b4BQwu1AMbwif7uRbz/Q5fuABMqbP/lVXEBMkSH/xFqCQAyZwH/UAGoASOYHv8QqLkBOFno/2XS/AAp+kcAzKpP/w4u7/9QTe8AvdZL/xGN+QAmUEz/vlV1AFbkqgCc2NABw8+k/5ZCTP+v4RD/jVBiAUzb8gDGonIALtqYAJsr8f6boGj/M7ulAAIRrwBCVKAB9zoeACNBNf5F7L8ALYb1AaN73QAgbhT/NBelALrWRwDpsGAA8u82ATlZigBTAFT/iKBkAFyOeP5ofL4AtbE+//opVQCYgioBYPz2AJeXP/7vhT4AIDicAC2nvf+OhbMBg1bTALuzlv76qg7/0qNOACU0lwBjTRoA7pzV/9XA0QFJLlQAFEEpATbOTwDJg5L+qm8Y/7EhMv6rJsv/Tvd0ANHdmQCFgLIBOiwZAMknOwG9E/wAMeXSAXW7dQC1s7gBAHLbADBekwD1KTgAfQ3M/vStdwAs3SD+VOoUAPmgxgHsfur/L2Oo/qrimf9ms9gA4o16/3pCmf629YYA4+QZAdY56//YrTj/tefSAHeAnf+BX4j/bn4zAAKpt/8HgmL+RbBe/3QE4wHZ8pH/yq0fAWkBJ/8ur0UA5C86/9fgRf7POEX/EP6L/xfP1P/KFH7/X9Vg/wmwIQDIBc//8SqA/iMhwP/45cQBgRF4APtnl/8HNHD/jDhC/yji9f/ZRiX+rNYJ/0hDhgGSwNb/LCZwAES4S//OWvsAleuNALWqOgB09O8AXJ0CAGatYgDpiWABfzHLAAWblAAXlAn/03oMACKGGv/bzIgAhggp/+BTK/5VGfcAbX8A/qmIMADud9v/563VAM4S/v4Iugf/fgkHAW8qSABvNOz+YD+NAJO/f/7NTsD/DmrtAbvbTACv87v+aVmtAFUZWQGi85QAAnbR/iGeCQCLoy7/XUYoAGwqjv5v/I7/m9+QADPlp/9J/Jv/XnQM/5ig2v+c7iX/s+rP/8UAs/+apI0A4cRoAAojGf7R1PL/Yf3e/rhl5QDeEn8BpIiH/x7PjP6SYfMAgcAa/slUIf9vCk7/k1Gy/wQEGACh7tf/Bo0hADXXDv8ptdD/54udALPL3f//uXEAveKs/3FC1v/KPi3/ZkAI/06uEP6FdUT/\");T(Z,3264,\"AQ==\");T(Z,3296,\"JuiVj8KyJ7BFw/SJ8u+Y8NXfrAXTxjM5sTgCiG1T/AXHF2pwPU3YT7o8C3YNEGcPKiBT+iw5zMZOx/13kqwDeuz///////////////////////////////////////9/7f///////////////////////////////////////3/u////////////////////////////////////////f+3T9VwaYxJY1pz3ot753hQ=\");T(Z,3487,\"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\");T(Z,34508,\"AQAAAAZtBw==\");T(Z,34560,\"dsFfAGVwAv9Q/KH+8mrG/4UGsgDk33AA3+5V/jPzGgA+K4v+y0EK\");T(Z,34608,\"M03tAJGqVv82JjP/8YBl/yl5Sv/sTpsAqZdp/pwpSADCZq//zqJl/wAAAAAAAAAAGy57ARKo/f/Tr5f+w9tgADh2vv7+0fX/mWR+/uiBFf81uPL/x6Td\");T(Z,34736,\"AQ==\");T(Z,34768,\"4Ot6fDtBuK4WVuP68Z/EatoJjeucMrH9hmIFFl9JuABfnJW8o1CMJLHQsVWcg+9bBERcxFgcjobYIk7d0J8RV+z///////////////////////////////////////9/7f///////////////////////////////////////3/u////////////////////////////////////////fw==\");T(Z,34960,\"CMm882fmCWo7p8qEha5nuyv4lP5y82488TYdXzr1T6XRguatf1IOUR9sPiuMaAWba71B+6vZgx95IX4TGc3gWyKuKNeYL4pCzWXvI5FEN3EvO03sz/vAtbzbiYGl27XpOLVI81vCVjkZ0AW28RHxWZtPGa+kgj+SGIFt2tVeHKtCAgOjmKoH2L5vcEUBW4MSjLLkTr6FMSTitP/Vw30MVW+Je/J0Xb5ysZYWO/6x3oA1Esclpwbcm5Qmac908ZvB0krxnsFpm+TjJU84hke+77XVjIvGncEPZZysd8yhDCR1AitZbyzpLYPkpm6qhHRK1PtBvdypsFy1UxGD2oj5dqvfZu5SUT6YEDK0LW3GMag/IfuYyCcDsOQO777Hf1m/wo+oPfML4MYlpwqTR5Gn1W+CA+BRY8oGcG4OCmcpKRT8L9JGhQq3JybJJlw4IRsu7SrEWvxtLE3fs5WdEw04U95jr4tUcwplqLJ3PLsKanbmru1HLsnCgTs1ghSFLHKSZAPxTKHov6IBMEK8S2YaqJGX+NBwi0vCML5UBqNRbMcYUu/WGeiS0RCpZVUkBpnWKiBxV4U1DvS40bsycKBqEMjQ0rgWwaQZU6tBUQhsNx6Z647fTHdIJ6hIm+G1vLA0Y1rJxbMMHDnLikHjSqrYTnPjY3dPypxbo7iy1vNvLmj8su9d7oKPdGAvF0NvY6V4cqvwoRR4yITsOWQaCALHjCgeYyP6/76Q6b2C3utsUKQVecay96P5vitTcuPyeHHGnGEm6s4+J8oHwsAhx7iG0R7r4M3WfdrqeNFu7n9PffW6bxdyqmfwBqaYyKLFfWMKrg35vgSYPxEbRxwTNQtxG4R9BCP1d9sokyTHQHuryjK8vskVCr6ePEwNEJzEZx1DtkI+y77UxUwqfmX8nCl/Wez61jqrb8tfF1hHSowZRGyA\");T(Z,35792,\"aG1hY3NoYTUxMjI1NgAAAGfmCWqFrme7cvNuPDr1T6V/Ug5RjGgFm6vZgx8ZzeBbmC+KQpFEN3HP+8C1pdu16VvCVjnxEfFZpII/ktVeHKuYqgfYAVuDEr6FMSTDfQxVdF2+cv6x3oCnBtybdPGbwcFpm+SGR77vxp3BD8yhDCRvLOktqoR0StypsFzaiPl2UlE+mG3GMajIJwOwx39Zv/ML4MZHkafVUWPKBmcpKRSFCrcnOCEbLvxtLE0TDThTVHMKZbsKanYuycKBhSxykqHov6JLZhqocItLwqNRbMcZ6JLRJAaZ1oU1DvRwoGoQFsGkGQhsNx5Md0gntbywNLMMHDlKqthOT8qcW/NvLmjugo90b2OleBR4yIQIAseM+v++kOtsUKT3o/m+8nhxxoA=\");T(Z,36176,\"Y3VydmUyNTUxOXhzYWxzYTIwcG9seTEzMDU=\");T(Z,36224,\"Ymxha2UyYg==\");T(Z,36240,\"7dP1XBpjEljWnPei3vneFA==\");T(Z,36271,\"EHNoYTUxMgBibGFrZTJiAGN1cnZlMjU1MTkAeDI1NTE5Ymxha2UyYgBwb2x5MTMwNQBiNjRfcG9zIDw9IGI2NF9sZW4Ac29kaXVtL2NvZGVjcy5jAHNvZGl1bV9iaW4yYmFzZTY0ACRhcmdvbjJpZAAkYXJnb24yaQAkdj0AJG09ACx0PQAscD0AJGFyZ29uMmlkJHY9ACRhcmdvbjJpJHY9ACRhcmdvbjJpJAAkYXJnb24yaWQkACRhcmdvbjJpZCQAJGFyZ29uMmkkAGFyZ29uMmkALi8wMTIzNDU2Nzg5QUJDREVGR0hJSktMTU5PUFFSU1RVVldYWVphYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5egAkNyQAeHNhbHNhMjBwb2x5MTMwNQ==\");T(Z,36592,\"c2lwaGFzaDI0AAAAAAAAAFNpZ0VkMjU1MTkgbm8gRWQyNTUxOSBjb2xsaXNpb25zAQBlZDI1NTE5AHhzYWxzYTIwADEuMC4xOA==\");T(Z,36668,\"AQAAAAIAAAADAAAABAAAAAUAAAAGAAAABwAAAAgAAAAJAAAACgAAAAsAAAAMAAAADQ==\");return g({\"Int8Array\":Int8Array,\"Int16Array\":Int16Array,\"Int32Array\":Int32Array,\"Uint8Array\":Uint8Array,\"Uint16Array\":Uint16Array,\"Uint32Array\":Uint32Array,\"Float32Array\":Float32Array,\"Float64Array\":Float64Array,\"NaN\":NaN,\"Infinity\":Infinity,\"Math\":Math},asmLibraryArg,wasmMemory.buffer)}\n\n\n// EMSCRIPTEN_END_ASM\n\n\n\n\n)(asmLibraryArg,wasmMemory,wasmTable);return{\"exports\":exports}},instantiate:function(binary,info){return{then:function(ok){ok({\"instance\":new WebAssembly.Instance(new WebAssembly.Module(binary))})}}},RuntimeError:Error};wasmBinary=[];if(typeof WebAssembly!==\"object\"){err(\"no native wasm support detected\")}function setValue(ptr,value,type,noSafe){type=type||\"i8\";if(type.charAt(type.length-1)===\"*\")type=\"i32\";switch(type){case\"i1\":HEAP8[ptr>>0]=value;break;case\"i8\":HEAP8[ptr>>0]=value;break;case\"i16\":HEAP16[ptr>>1]=value;break;case\"i32\":HEAP32[ptr>>2]=value;break;case\"i64\":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case\"float\":HEAPF32[ptr>>2]=value;break;case\"double\":HEAPF64[ptr>>3]=value;break;default:abort(\"invalid type for setValue: \"+type)}}function getValue(ptr,type,noSafe){type=type||\"i8\";if(type.charAt(type.length-1)===\"*\")type=\"i32\";switch(type){case\"i1\":return HEAP8[ptr>>0];case\"i8\":return HEAP8[ptr>>0];case\"i16\":return HEAP16[ptr>>1];case\"i32\":return HEAP32[ptr>>2];case\"i64\":return HEAP32[ptr>>2];case\"float\":return HEAPF32[ptr>>2];case\"double\":return HEAPF64[ptr>>3];default:abort(\"invalid type for getValue: \"+type)}return null}var wasmMemory;var wasmTable=new WebAssembly.Table({\"initial\":14,\"maximum\":14+8,\"element\":\"anyfunc\"});var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort(\"Assertion failed: \"+text)}}var UTF8Decoder=typeof TextDecoder!==\"undefined\"?new TextDecoder(\"utf8\"):undefined;function UTF8ArrayToString(heap,idx,maxBytesToRead){var endIdx=idx+maxBytesToRead;var endPtr=idx;while(heap[endPtr]&&!(endPtr>=endIdx))++endPtr;if(endPtr-idx>16&&heap.subarray&&UTF8Decoder){return UTF8Decoder.decode(heap.subarray(idx,endPtr))}else{var str=\"\";while(idx<endPtr){var u0=heap[idx++];if(!(u0&128)){str+=String.fromCharCode(u0);continue}var u1=heap[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}var u2=heap[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u0=(u0&7)<<18|u1<<12|u2<<6|heap[idx++]&63}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}return str}function UTF8ToString(ptr,maxBytesToRead){return ptr?UTF8ArrayToString(HEAPU8,ptr,maxBytesToRead):\"\"}var WASM_PAGE_SIZE=65536;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferAndViews(buf){buffer=buf;Module[\"HEAP8\"]=HEAP8=new Int8Array(buf);Module[\"HEAP16\"]=HEAP16=new Int16Array(buf);Module[\"HEAP32\"]=HEAP32=new Int32Array(buf);Module[\"HEAPU8\"]=HEAPU8=new Uint8Array(buf);Module[\"HEAPU16\"]=HEAPU16=new Uint16Array(buf);Module[\"HEAPU32\"]=HEAPU32=new Uint32Array(buf);Module[\"HEAPF32\"]=HEAPF32=new Float32Array(buf);Module[\"HEAPF64\"]=HEAPF64=new Float64Array(buf)}var DYNAMIC_BASE=5280352,DYNAMICTOP_PTR=37312;var INITIAL_INITIAL_MEMORY=Module[\"INITIAL_MEMORY\"]||16777216;if(Module[\"wasmMemory\"]){wasmMemory=Module[\"wasmMemory\"]}else{wasmMemory=new WebAssembly.Memory({\"initial\":INITIAL_INITIAL_MEMORY/WASM_PAGE_SIZE,\"maximum\":2147483648/WASM_PAGE_SIZE})}if(wasmMemory){buffer=wasmMemory.buffer}INITIAL_INITIAL_MEMORY=buffer.byteLength;updateGlobalBufferAndViews(buffer);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback==\"function\"){callback(Module);continue}var func=callback.func;if(typeof func===\"number\"){if(callback.arg===undefined){Module[\"dynCall_v\"](func)}else{Module[\"dynCall_vi\"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;function preRun(){if(Module[\"preRun\"]){if(typeof Module[\"preRun\"]==\"function\")Module[\"preRun\"]=[Module[\"preRun\"]];while(Module[\"preRun\"].length){addOnPreRun(Module[\"preRun\"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function initRuntime(){runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function postRun(){if(Module[\"postRun\"]){if(typeof Module[\"postRun\"]==\"function\")Module[\"postRun\"]=[Module[\"postRun\"]];while(Module[\"postRun\"].length){addOnPostRun(Module[\"postRun\"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}var Math_abs=Math.abs;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module[\"monitorRunDependencies\"]){Module[\"monitorRunDependencies\"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module[\"monitorRunDependencies\"]){Module[\"monitorRunDependencies\"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module[\"preloadedImages\"]={};Module[\"preloadedAudios\"]={};function abort(what){if(Module[\"onAbort\"]){Module[\"onAbort\"](what)}what+=\"\";out(what);err(what);ABORT=true;EXITSTATUS=1;what=\"abort(\"+what+\"). Build with -s ASSERTIONS=1 for more info.\";throw new WebAssembly.RuntimeError(what)}function hasPrefix(str,prefix){return String.prototype.startsWith?str.startsWith(prefix):str.indexOf(prefix)===0}var dataURIPrefix=\"data:application/octet-stream;base64,\";function isDataURI(filename){return hasPrefix(filename,dataURIPrefix)}var fileURIPrefix=\"file://\";function isFileURI(filename){return hasPrefix(filename,fileURIPrefix)}var wasmBinaryFile=\"\";if(!isDataURI(wasmBinaryFile)){wasmBinaryFile=locateFile(wasmBinaryFile)}function getBinary(){try{if(wasmBinary){return new Uint8Array(wasmBinary)}var binary=tryParseAsDataURI(wasmBinaryFile);if(binary){return binary}if(readBinary){return readBinary(wasmBinaryFile)}else{throw\"both async and sync fetching of the wasm failed\"}}catch(err){abort(err)}}function getBinaryPromise(){if(!wasmBinary&&(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&typeof fetch===\"function\"&&!isFileURI(wasmBinaryFile)){return fetch(wasmBinaryFile,{credentials:\"same-origin\"}).then(function(response){if(!response[\"ok\"]){throw\"failed to load wasm binary file at '\"+wasmBinaryFile+\"'\"}return response[\"arrayBuffer\"]()}).catch(function(){return getBinary()})}return new Promise(function(resolve,reject){resolve(getBinary())})}function createWasm(){var info={\"env\":asmLibraryArg,\"wasi_snapshot_preview1\":asmLibraryArg};function receiveInstance(instance,module){var exports=instance.exports;Module[\"asm\"]=exports;removeRunDependency(\"wasm-instantiate\")}addRunDependency(\"wasm-instantiate\");function receiveInstantiatedSource(output){receiveInstance(output[\"instance\"])}function instantiateArrayBuffer(receiver){return getBinaryPromise().then(function(binary){return WebAssembly.instantiate(binary,info)}).then(receiver,function(reason){err(\"failed to asynchronously prepare wasm: \"+reason);abort(reason)})}function instantiateAsync(){if(!wasmBinary&&typeof WebAssembly.instantiateStreaming===\"function\"&&!isDataURI(wasmBinaryFile)&&!isFileURI(wasmBinaryFile)&&typeof fetch===\"function\"){fetch(wasmBinaryFile,{credentials:\"same-origin\"}).then(function(response){var result=WebAssembly.instantiateStreaming(response,info);return result.then(receiveInstantiatedSource,function(reason){err(\"wasm streaming compile failed: \"+reason);err(\"falling back to ArrayBuffer instantiation\");return instantiateArrayBuffer(receiveInstantiatedSource)})})}else{return instantiateArrayBuffer(receiveInstantiatedSource)}}if(Module[\"instantiateWasm\"]){try{var exports=Module[\"instantiateWasm\"](info,receiveInstance);return exports}catch(e){err(\"Module.instantiateWasm callback failed with error: \"+e);return false}}instantiateAsync();return{}}var tempDouble;var tempI64;var ASM_CONSTS={1027:function(){return Module.getRandomValue()},1065:function(){if(Module.getRandomValue===undefined){try{var window_=\"object\"===typeof window?window:self;var crypto_=typeof window_.crypto!==\"undefined\"?window_.crypto:window_.msCrypto;var randomValuesStandard=function(){var buf=new Uint32Array(1);crypto_.getRandomValues(buf);return buf[0]>>>0};randomValuesStandard();Module.getRandomValue=randomValuesStandard}catch(e){try{var crypto=__webpack_require__(/*! crypto */ \"crypto\");var randomValueNodeJS=function(){var buf=crypto[\"randomBytes\"](4);return(buf[0]<<24|buf[1]<<16|buf[2]<<8|buf[3])>>>0};randomValueNodeJS();Module.getRandomValue=randomValueNodeJS}catch(e){throw\"No secure random number generator found\"}}}}};function _emscripten_asm_const_iii(code,sigPtr,argbuf){var args=readAsmConstArgs(sigPtr,argbuf);return ASM_CONSTS[code].apply(null,args)}__ATINIT__.push({func:function(){___wasm_call_ctors()}});function ___assert_fail(condition,filename,line,func){abort(\"Assertion failed: \"+UTF8ToString(condition)+\", at: \"+[filename?UTF8ToString(filename):\"unknown filename\",line,func?UTF8ToString(func):\"unknown function\"])}function _abort(){abort()}function _emscripten_memcpy_big(dest,src,num){HEAPU8.copyWithin(dest,src,src+num)}function _emscripten_get_heap_size(){return HEAPU8.length}function emscripten_realloc_buffer(size){try{wasmMemory.grow(size-buffer.byteLength+65535>>>16);updateGlobalBufferAndViews(wasmMemory.buffer);return 1}catch(e){}}function _emscripten_resize_heap(requestedSize){requestedSize=requestedSize>>>0;var oldSize=_emscripten_get_heap_size();var PAGE_MULTIPLE=65536;var maxHeapSize=2147483648;if(requestedSize>maxHeapSize){return false}var minHeapSize=16777216;for(var cutDown=1;cutDown<=4;cutDown*=2){var overGrownHeapSize=oldSize*(1+.2/cutDown);overGrownHeapSize=Math.min(overGrownHeapSize,requestedSize+100663296);var newSize=Math.min(maxHeapSize,alignUp(Math.max(minHeapSize,requestedSize,overGrownHeapSize),PAGE_MULTIPLE));var replacement=emscripten_realloc_buffer(newSize);if(replacement){return true}}return false}var __readAsmConstArgsArray=[];function readAsmConstArgs(sigPtr,buf){__readAsmConstArgsArray.length=0;var ch;buf>>=2;while(ch=HEAPU8[sigPtr++]){__readAsmConstArgsArray.push(ch<105?HEAPF64[++buf>>1]:HEAP32[buf]);++buf}return __readAsmConstArgsArray}var ASSERTIONS=false;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,\"Character code \"+chr+\" (\"+String.fromCharCode(chr)+\")  at offset \"+i+\" not in 0x00-0xFF.\")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join(\"\")}var decodeBase64=typeof atob===\"function\"?atob:function(input){var keyStr=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\";var output=\"\";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\\+\\/\\=]/g,\"\");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output};function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE===\"boolean\"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,\"base64\")}catch(_){buf=new Buffer(s,\"base64\")}return new Uint8Array(buf[\"buffer\"],buf[\"byteOffset\"],buf[\"byteLength\"])}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error(\"Converting base64 string to bytes failed.\")}}function tryParseAsDataURI(filename){if(!isDataURI(filename)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}var asmLibraryArg={\"__assert_fail\":___assert_fail,\"abort\":_abort,\"emscripten_asm_const_iii\":_emscripten_asm_const_iii,\"emscripten_memcpy_big\":_emscripten_memcpy_big,\"emscripten_resize_heap\":_emscripten_resize_heap,\"memory\":wasmMemory,\"table\":wasmTable};var asm=createWasm();var ___wasm_call_ctors=Module[\"___wasm_call_ctors\"]=function(){return(___wasm_call_ctors=Module[\"___wasm_call_ctors\"]=Module[\"asm\"][\"__wasm_call_ctors\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_encrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_encrypt_detached\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_encrypt_detached\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_encrypt=Module[\"_crypto_aead_chacha20poly1305_encrypt\"]=function(){return(_crypto_aead_chacha20poly1305_encrypt=Module[\"_crypto_aead_chacha20poly1305_encrypt\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_encrypt\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt_detached\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_encrypt_detached\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_encrypt\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_decrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_decrypt_detached\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_decrypt_detached\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_decrypt=Module[\"_crypto_aead_chacha20poly1305_decrypt\"]=function(){return(_crypto_aead_chacha20poly1305_decrypt=Module[\"_crypto_aead_chacha20poly1305_decrypt\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_decrypt\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt_detached\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_decrypt_detached\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_decrypt\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_chacha20poly1305_ietf_keybytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_chacha20poly1305_ietf_keybytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_keybytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_npubbytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_npubbytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_npubbytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_nsecbytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_nsecbytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_nsecbytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_abytes=Module[\"_crypto_aead_chacha20poly1305_ietf_abytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_abytes=Module[\"_crypto_aead_chacha20poly1305_ietf_abytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_abytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_ietf_messagebytes_max\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_ietf_messagebytes_max\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_messagebytes_max\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_keygen=Module[\"_crypto_aead_chacha20poly1305_ietf_keygen\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_keygen=Module[\"_crypto_aead_chacha20poly1305_ietf_keygen\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_ietf_keygen\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_keybytes=Module[\"_crypto_aead_chacha20poly1305_keybytes\"]=function(){return(_crypto_aead_chacha20poly1305_keybytes=Module[\"_crypto_aead_chacha20poly1305_keybytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_keybytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_npubbytes=Module[\"_crypto_aead_chacha20poly1305_npubbytes\"]=function(){return(_crypto_aead_chacha20poly1305_npubbytes=Module[\"_crypto_aead_chacha20poly1305_npubbytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_npubbytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_nsecbytes\"]=function(){return(_crypto_aead_chacha20poly1305_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_nsecbytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_nsecbytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_abytes=Module[\"_crypto_aead_chacha20poly1305_abytes\"]=function(){return(_crypto_aead_chacha20poly1305_abytes=Module[\"_crypto_aead_chacha20poly1305_abytes\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_abytes\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_messagebytes_max\"]=function(){return(_crypto_aead_chacha20poly1305_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_messagebytes_max\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_keygen=Module[\"_crypto_aead_chacha20poly1305_keygen\"]=function(){return(_crypto_aead_chacha20poly1305_keygen=Module[\"_crypto_aead_chacha20poly1305_keygen\"]=Module[\"asm\"][\"crypto_aead_chacha20poly1305_keygen\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt_detached\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt_detached\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_encrypt_detached\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_encrypt\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt_detached\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt_detached\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_decrypt_detached\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_decrypt\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_keybytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_keybytes\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_keybytes\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_npubbytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_npubbytes\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_npubbytes\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_nsecbytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_nsecbytes\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_nsecbytes\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_abytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_abytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_abytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_abytes\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_abytes\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_xchacha20poly1305_ietf_messagebytes_max\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_xchacha20poly1305_ietf_messagebytes_max\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_messagebytes_max\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_keygen=Module[\"_crypto_aead_xchacha20poly1305_ietf_keygen\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_keygen=Module[\"_crypto_aead_xchacha20poly1305_ietf_keygen\"]=Module[\"asm\"][\"crypto_aead_xchacha20poly1305_ietf_keygen\"]).apply(null,arguments)};var _crypto_auth_bytes=Module[\"_crypto_auth_bytes\"]=function(){return(_crypto_auth_bytes=Module[\"_crypto_auth_bytes\"]=Module[\"asm\"][\"crypto_auth_bytes\"]).apply(null,arguments)};var _crypto_auth_keybytes=Module[\"_crypto_auth_keybytes\"]=function(){return(_crypto_auth_keybytes=Module[\"_crypto_auth_keybytes\"]=Module[\"asm\"][\"crypto_auth_keybytes\"]).apply(null,arguments)};var _crypto_auth_primitive=Module[\"_crypto_auth_primitive\"]=function(){return(_crypto_auth_primitive=Module[\"_crypto_auth_primitive\"]=Module[\"asm\"][\"crypto_auth_primitive\"]).apply(null,arguments)};var _crypto_auth=Module[\"_crypto_auth\"]=function(){return(_crypto_auth=Module[\"_crypto_auth\"]=Module[\"asm\"][\"crypto_auth\"]).apply(null,arguments)};var _crypto_auth_verify=Module[\"_crypto_auth_verify\"]=function(){return(_crypto_auth_verify=Module[\"_crypto_auth_verify\"]=Module[\"asm\"][\"crypto_auth_verify\"]).apply(null,arguments)};var _crypto_auth_keygen=Module[\"_crypto_auth_keygen\"]=function(){return(_crypto_auth_keygen=Module[\"_crypto_auth_keygen\"]=Module[\"asm\"][\"crypto_auth_keygen\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_bytes=Module[\"_crypto_auth_hmacsha256_bytes\"]=function(){return(_crypto_auth_hmacsha256_bytes=Module[\"_crypto_auth_hmacsha256_bytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_bytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_keybytes=Module[\"_crypto_auth_hmacsha256_keybytes\"]=function(){return(_crypto_auth_hmacsha256_keybytes=Module[\"_crypto_auth_hmacsha256_keybytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_keybytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_statebytes=Module[\"_crypto_auth_hmacsha256_statebytes\"]=function(){return(_crypto_auth_hmacsha256_statebytes=Module[\"_crypto_auth_hmacsha256_statebytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_statebytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_keygen=Module[\"_crypto_auth_hmacsha256_keygen\"]=function(){return(_crypto_auth_hmacsha256_keygen=Module[\"_crypto_auth_hmacsha256_keygen\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_keygen\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_init=Module[\"_crypto_auth_hmacsha256_init\"]=function(){return(_crypto_auth_hmacsha256_init=Module[\"_crypto_auth_hmacsha256_init\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_init\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_update=Module[\"_crypto_auth_hmacsha256_update\"]=function(){return(_crypto_auth_hmacsha256_update=Module[\"_crypto_auth_hmacsha256_update\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_update\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_final=Module[\"_crypto_auth_hmacsha256_final\"]=function(){return(_crypto_auth_hmacsha256_final=Module[\"_crypto_auth_hmacsha256_final\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_final\"]).apply(null,arguments)};var _crypto_auth_hmacsha256=Module[\"_crypto_auth_hmacsha256\"]=function(){return(_crypto_auth_hmacsha256=Module[\"_crypto_auth_hmacsha256\"]=Module[\"asm\"][\"crypto_auth_hmacsha256\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_verify=Module[\"_crypto_auth_hmacsha256_verify\"]=function(){return(_crypto_auth_hmacsha256_verify=Module[\"_crypto_auth_hmacsha256_verify\"]=Module[\"asm\"][\"crypto_auth_hmacsha256_verify\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_bytes=Module[\"_crypto_auth_hmacsha512_bytes\"]=function(){return(_crypto_auth_hmacsha512_bytes=Module[\"_crypto_auth_hmacsha512_bytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_bytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_keybytes=Module[\"_crypto_auth_hmacsha512_keybytes\"]=function(){return(_crypto_auth_hmacsha512_keybytes=Module[\"_crypto_auth_hmacsha512_keybytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_keybytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_statebytes=Module[\"_crypto_auth_hmacsha512_statebytes\"]=function(){return(_crypto_auth_hmacsha512_statebytes=Module[\"_crypto_auth_hmacsha512_statebytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_statebytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_keygen=Module[\"_crypto_auth_hmacsha512_keygen\"]=function(){return(_crypto_auth_hmacsha512_keygen=Module[\"_crypto_auth_hmacsha512_keygen\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_keygen\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_init=Module[\"_crypto_auth_hmacsha512_init\"]=function(){return(_crypto_auth_hmacsha512_init=Module[\"_crypto_auth_hmacsha512_init\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_init\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_update=Module[\"_crypto_auth_hmacsha512_update\"]=function(){return(_crypto_auth_hmacsha512_update=Module[\"_crypto_auth_hmacsha512_update\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_update\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_final=Module[\"_crypto_auth_hmacsha512_final\"]=function(){return(_crypto_auth_hmacsha512_final=Module[\"_crypto_auth_hmacsha512_final\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_final\"]).apply(null,arguments)};var _crypto_auth_hmacsha512=Module[\"_crypto_auth_hmacsha512\"]=function(){return(_crypto_auth_hmacsha512=Module[\"_crypto_auth_hmacsha512\"]=Module[\"asm\"][\"crypto_auth_hmacsha512\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_verify=Module[\"_crypto_auth_hmacsha512_verify\"]=function(){return(_crypto_auth_hmacsha512_verify=Module[\"_crypto_auth_hmacsha512_verify\"]=Module[\"asm\"][\"crypto_auth_hmacsha512_verify\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_bytes=Module[\"_crypto_auth_hmacsha512256_bytes\"]=function(){return(_crypto_auth_hmacsha512256_bytes=Module[\"_crypto_auth_hmacsha512256_bytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_bytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_keybytes=Module[\"_crypto_auth_hmacsha512256_keybytes\"]=function(){return(_crypto_auth_hmacsha512256_keybytes=Module[\"_crypto_auth_hmacsha512256_keybytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_keybytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_statebytes=Module[\"_crypto_auth_hmacsha512256_statebytes\"]=function(){return(_crypto_auth_hmacsha512256_statebytes=Module[\"_crypto_auth_hmacsha512256_statebytes\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_statebytes\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_keygen=Module[\"_crypto_auth_hmacsha512256_keygen\"]=function(){return(_crypto_auth_hmacsha512256_keygen=Module[\"_crypto_auth_hmacsha512256_keygen\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_keygen\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_init=Module[\"_crypto_auth_hmacsha512256_init\"]=function(){return(_crypto_auth_hmacsha512256_init=Module[\"_crypto_auth_hmacsha512256_init\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_init\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_update=Module[\"_crypto_auth_hmacsha512256_update\"]=function(){return(_crypto_auth_hmacsha512256_update=Module[\"_crypto_auth_hmacsha512256_update\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_update\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_final=Module[\"_crypto_auth_hmacsha512256_final\"]=function(){return(_crypto_auth_hmacsha512256_final=Module[\"_crypto_auth_hmacsha512256_final\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_final\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256=Module[\"_crypto_auth_hmacsha512256\"]=function(){return(_crypto_auth_hmacsha512256=Module[\"_crypto_auth_hmacsha512256\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_verify=Module[\"_crypto_auth_hmacsha512256_verify\"]=function(){return(_crypto_auth_hmacsha512256_verify=Module[\"_crypto_auth_hmacsha512256_verify\"]=Module[\"asm\"][\"crypto_auth_hmacsha512256_verify\"]).apply(null,arguments)};var _crypto_box_seedbytes=Module[\"_crypto_box_seedbytes\"]=function(){return(_crypto_box_seedbytes=Module[\"_crypto_box_seedbytes\"]=Module[\"asm\"][\"crypto_box_seedbytes\"]).apply(null,arguments)};var _crypto_box_publickeybytes=Module[\"_crypto_box_publickeybytes\"]=function(){return(_crypto_box_publickeybytes=Module[\"_crypto_box_publickeybytes\"]=Module[\"asm\"][\"crypto_box_publickeybytes\"]).apply(null,arguments)};var _crypto_box_secretkeybytes=Module[\"_crypto_box_secretkeybytes\"]=function(){return(_crypto_box_secretkeybytes=Module[\"_crypto_box_secretkeybytes\"]=Module[\"asm\"][\"crypto_box_secretkeybytes\"]).apply(null,arguments)};var _crypto_box_beforenmbytes=Module[\"_crypto_box_beforenmbytes\"]=function(){return(_crypto_box_beforenmbytes=Module[\"_crypto_box_beforenmbytes\"]=Module[\"asm\"][\"crypto_box_beforenmbytes\"]).apply(null,arguments)};var _crypto_box_noncebytes=Module[\"_crypto_box_noncebytes\"]=function(){return(_crypto_box_noncebytes=Module[\"_crypto_box_noncebytes\"]=Module[\"asm\"][\"crypto_box_noncebytes\"]).apply(null,arguments)};var _crypto_box_zerobytes=Module[\"_crypto_box_zerobytes\"]=function(){return(_crypto_box_zerobytes=Module[\"_crypto_box_zerobytes\"]=Module[\"asm\"][\"crypto_box_zerobytes\"]).apply(null,arguments)};var _crypto_box_boxzerobytes=Module[\"_crypto_box_boxzerobytes\"]=function(){return(_crypto_box_boxzerobytes=Module[\"_crypto_box_boxzerobytes\"]=Module[\"asm\"][\"crypto_box_boxzerobytes\"]).apply(null,arguments)};var _crypto_box_macbytes=Module[\"_crypto_box_macbytes\"]=function(){return(_crypto_box_macbytes=Module[\"_crypto_box_macbytes\"]=Module[\"asm\"][\"crypto_box_macbytes\"]).apply(null,arguments)};var _crypto_box_messagebytes_max=Module[\"_crypto_box_messagebytes_max\"]=function(){return(_crypto_box_messagebytes_max=Module[\"_crypto_box_messagebytes_max\"]=Module[\"asm\"][\"crypto_box_messagebytes_max\"]).apply(null,arguments)};var _crypto_box_primitive=Module[\"_crypto_box_primitive\"]=function(){return(_crypto_box_primitive=Module[\"_crypto_box_primitive\"]=Module[\"asm\"][\"crypto_box_primitive\"]).apply(null,arguments)};var _crypto_box_seed_keypair=Module[\"_crypto_box_seed_keypair\"]=function(){return(_crypto_box_seed_keypair=Module[\"_crypto_box_seed_keypair\"]=Module[\"asm\"][\"crypto_box_seed_keypair\"]).apply(null,arguments)};var _crypto_box_keypair=Module[\"_crypto_box_keypair\"]=function(){return(_crypto_box_keypair=Module[\"_crypto_box_keypair\"]=Module[\"asm\"][\"crypto_box_keypair\"]).apply(null,arguments)};var _crypto_box_beforenm=Module[\"_crypto_box_beforenm\"]=function(){return(_crypto_box_beforenm=Module[\"_crypto_box_beforenm\"]=Module[\"asm\"][\"crypto_box_beforenm\"]).apply(null,arguments)};var _crypto_box_afternm=Module[\"_crypto_box_afternm\"]=function(){return(_crypto_box_afternm=Module[\"_crypto_box_afternm\"]=Module[\"asm\"][\"crypto_box_afternm\"]).apply(null,arguments)};var _crypto_box_open_afternm=Module[\"_crypto_box_open_afternm\"]=function(){return(_crypto_box_open_afternm=Module[\"_crypto_box_open_afternm\"]=Module[\"asm\"][\"crypto_box_open_afternm\"]).apply(null,arguments)};var _crypto_box=Module[\"_crypto_box\"]=function(){return(_crypto_box=Module[\"_crypto_box\"]=Module[\"asm\"][\"crypto_box\"]).apply(null,arguments)};var _crypto_box_open=Module[\"_crypto_box_open\"]=function(){return(_crypto_box_open=Module[\"_crypto_box_open\"]=Module[\"asm\"][\"crypto_box_open\"]).apply(null,arguments)};var _crypto_box_detached_afternm=Module[\"_crypto_box_detached_afternm\"]=function(){return(_crypto_box_detached_afternm=Module[\"_crypto_box_detached_afternm\"]=Module[\"asm\"][\"crypto_box_detached_afternm\"]).apply(null,arguments)};var _crypto_box_detached=Module[\"_crypto_box_detached\"]=function(){return(_crypto_box_detached=Module[\"_crypto_box_detached\"]=Module[\"asm\"][\"crypto_box_detached\"]).apply(null,arguments)};var _crypto_box_easy_afternm=Module[\"_crypto_box_easy_afternm\"]=function(){return(_crypto_box_easy_afternm=Module[\"_crypto_box_easy_afternm\"]=Module[\"asm\"][\"crypto_box_easy_afternm\"]).apply(null,arguments)};var _crypto_box_easy=Module[\"_crypto_box_easy\"]=function(){return(_crypto_box_easy=Module[\"_crypto_box_easy\"]=Module[\"asm\"][\"crypto_box_easy\"]).apply(null,arguments)};var _crypto_box_open_detached_afternm=Module[\"_crypto_box_open_detached_afternm\"]=function(){return(_crypto_box_open_detached_afternm=Module[\"_crypto_box_open_detached_afternm\"]=Module[\"asm\"][\"crypto_box_open_detached_afternm\"]).apply(null,arguments)};var _crypto_box_open_detached=Module[\"_crypto_box_open_detached\"]=function(){return(_crypto_box_open_detached=Module[\"_crypto_box_open_detached\"]=Module[\"asm\"][\"crypto_box_open_detached\"]).apply(null,arguments)};var _crypto_box_open_easy_afternm=Module[\"_crypto_box_open_easy_afternm\"]=function(){return(_crypto_box_open_easy_afternm=Module[\"_crypto_box_open_easy_afternm\"]=Module[\"asm\"][\"crypto_box_open_easy_afternm\"]).apply(null,arguments)};var _crypto_box_open_easy=Module[\"_crypto_box_open_easy\"]=function(){return(_crypto_box_open_easy=Module[\"_crypto_box_open_easy\"]=Module[\"asm\"][\"crypto_box_open_easy\"]).apply(null,arguments)};var _crypto_box_seal=Module[\"_crypto_box_seal\"]=function(){return(_crypto_box_seal=Module[\"_crypto_box_seal\"]=Module[\"asm\"][\"crypto_box_seal\"]).apply(null,arguments)};var _crypto_box_seal_open=Module[\"_crypto_box_seal_open\"]=function(){return(_crypto_box_seal_open=Module[\"_crypto_box_seal_open\"]=Module[\"asm\"][\"crypto_box_seal_open\"]).apply(null,arguments)};var _crypto_box_sealbytes=Module[\"_crypto_box_sealbytes\"]=function(){return(_crypto_box_sealbytes=Module[\"_crypto_box_sealbytes\"]=Module[\"asm\"][\"crypto_box_sealbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_seed_keypair\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_seed_keypair\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_seed_keypair\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_keypair\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_keypair\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_keypair\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_beforenm=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenm\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_beforenm=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenm\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_beforenm\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_afternm\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_afternm\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_afternm\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_open_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_open_afternm\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_open_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_open_afternm\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_open_afternm\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305=Module[\"_crypto_box_curve25519xsalsa20poly1305\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305=Module[\"_crypto_box_curve25519xsalsa20poly1305\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_open=Module[\"_crypto_box_curve25519xsalsa20poly1305_open\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_open=Module[\"_crypto_box_curve25519xsalsa20poly1305_open\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_open\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_seedbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_seedbytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_seedbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_seedbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_seedbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_publickeybytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_publickeybytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_publickeybytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_secretkeybytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_secretkeybytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_secretkeybytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenmbytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenmbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_beforenmbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_noncebytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_noncebytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_noncebytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_noncebytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_noncebytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_zerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_zerobytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_zerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_zerobytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_zerobytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_boxzerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_boxzerobytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_boxzerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_boxzerobytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_boxzerobytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_macbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_macbytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_macbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_macbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_macbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xsalsa20poly1305_messagebytes_max\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xsalsa20poly1305_messagebytes_max\"]=Module[\"asm\"][\"crypto_box_curve25519xsalsa20poly1305_messagebytes_max\"]).apply(null,arguments)};var _crypto_core_hchacha20=Module[\"_crypto_core_hchacha20\"]=function(){return(_crypto_core_hchacha20=Module[\"_crypto_core_hchacha20\"]=Module[\"asm\"][\"crypto_core_hchacha20\"]).apply(null,arguments)};var _crypto_core_hchacha20_outputbytes=Module[\"_crypto_core_hchacha20_outputbytes\"]=function(){return(_crypto_core_hchacha20_outputbytes=Module[\"_crypto_core_hchacha20_outputbytes\"]=Module[\"asm\"][\"crypto_core_hchacha20_outputbytes\"]).apply(null,arguments)};var _crypto_core_hchacha20_inputbytes=Module[\"_crypto_core_hchacha20_inputbytes\"]=function(){return(_crypto_core_hchacha20_inputbytes=Module[\"_crypto_core_hchacha20_inputbytes\"]=Module[\"asm\"][\"crypto_core_hchacha20_inputbytes\"]).apply(null,arguments)};var _crypto_core_hchacha20_keybytes=Module[\"_crypto_core_hchacha20_keybytes\"]=function(){return(_crypto_core_hchacha20_keybytes=Module[\"_crypto_core_hchacha20_keybytes\"]=Module[\"asm\"][\"crypto_core_hchacha20_keybytes\"]).apply(null,arguments)};var _crypto_core_hchacha20_constbytes=Module[\"_crypto_core_hchacha20_constbytes\"]=function(){return(_crypto_core_hchacha20_constbytes=Module[\"_crypto_core_hchacha20_constbytes\"]=Module[\"asm\"][\"crypto_core_hchacha20_constbytes\"]).apply(null,arguments)};var _crypto_core_hsalsa20=Module[\"_crypto_core_hsalsa20\"]=function(){return(_crypto_core_hsalsa20=Module[\"_crypto_core_hsalsa20\"]=Module[\"asm\"][\"crypto_core_hsalsa20\"]).apply(null,arguments)};var _crypto_core_hsalsa20_outputbytes=Module[\"_crypto_core_hsalsa20_outputbytes\"]=function(){return(_crypto_core_hsalsa20_outputbytes=Module[\"_crypto_core_hsalsa20_outputbytes\"]=Module[\"asm\"][\"crypto_core_hsalsa20_outputbytes\"]).apply(null,arguments)};var _crypto_core_hsalsa20_inputbytes=Module[\"_crypto_core_hsalsa20_inputbytes\"]=function(){return(_crypto_core_hsalsa20_inputbytes=Module[\"_crypto_core_hsalsa20_inputbytes\"]=Module[\"asm\"][\"crypto_core_hsalsa20_inputbytes\"]).apply(null,arguments)};var _crypto_core_hsalsa20_keybytes=Module[\"_crypto_core_hsalsa20_keybytes\"]=function(){return(_crypto_core_hsalsa20_keybytes=Module[\"_crypto_core_hsalsa20_keybytes\"]=Module[\"asm\"][\"crypto_core_hsalsa20_keybytes\"]).apply(null,arguments)};var _crypto_core_hsalsa20_constbytes=Module[\"_crypto_core_hsalsa20_constbytes\"]=function(){return(_crypto_core_hsalsa20_constbytes=Module[\"_crypto_core_hsalsa20_constbytes\"]=Module[\"asm\"][\"crypto_core_hsalsa20_constbytes\"]).apply(null,arguments)};var _crypto_core_salsa20=Module[\"_crypto_core_salsa20\"]=function(){return(_crypto_core_salsa20=Module[\"_crypto_core_salsa20\"]=Module[\"asm\"][\"crypto_core_salsa20\"]).apply(null,arguments)};var _crypto_core_salsa20_outputbytes=Module[\"_crypto_core_salsa20_outputbytes\"]=function(){return(_crypto_core_salsa20_outputbytes=Module[\"_crypto_core_salsa20_outputbytes\"]=Module[\"asm\"][\"crypto_core_salsa20_outputbytes\"]).apply(null,arguments)};var _crypto_core_salsa20_inputbytes=Module[\"_crypto_core_salsa20_inputbytes\"]=function(){return(_crypto_core_salsa20_inputbytes=Module[\"_crypto_core_salsa20_inputbytes\"]=Module[\"asm\"][\"crypto_core_salsa20_inputbytes\"]).apply(null,arguments)};var _crypto_core_salsa20_keybytes=Module[\"_crypto_core_salsa20_keybytes\"]=function(){return(_crypto_core_salsa20_keybytes=Module[\"_crypto_core_salsa20_keybytes\"]=Module[\"asm\"][\"crypto_core_salsa20_keybytes\"]).apply(null,arguments)};var _crypto_core_salsa20_constbytes=Module[\"_crypto_core_salsa20_constbytes\"]=function(){return(_crypto_core_salsa20_constbytes=Module[\"_crypto_core_salsa20_constbytes\"]=Module[\"asm\"][\"crypto_core_salsa20_constbytes\"]).apply(null,arguments)};var _crypto_core_salsa2012=Module[\"_crypto_core_salsa2012\"]=function(){return(_crypto_core_salsa2012=Module[\"_crypto_core_salsa2012\"]=Module[\"asm\"][\"crypto_core_salsa2012\"]).apply(null,arguments)};var _crypto_core_salsa2012_outputbytes=Module[\"_crypto_core_salsa2012_outputbytes\"]=function(){return(_crypto_core_salsa2012_outputbytes=Module[\"_crypto_core_salsa2012_outputbytes\"]=Module[\"asm\"][\"crypto_core_salsa2012_outputbytes\"]).apply(null,arguments)};var _crypto_core_salsa2012_inputbytes=Module[\"_crypto_core_salsa2012_inputbytes\"]=function(){return(_crypto_core_salsa2012_inputbytes=Module[\"_crypto_core_salsa2012_inputbytes\"]=Module[\"asm\"][\"crypto_core_salsa2012_inputbytes\"]).apply(null,arguments)};var _crypto_core_salsa2012_keybytes=Module[\"_crypto_core_salsa2012_keybytes\"]=function(){return(_crypto_core_salsa2012_keybytes=Module[\"_crypto_core_salsa2012_keybytes\"]=Module[\"asm\"][\"crypto_core_salsa2012_keybytes\"]).apply(null,arguments)};var _crypto_core_salsa2012_constbytes=Module[\"_crypto_core_salsa2012_constbytes\"]=function(){return(_crypto_core_salsa2012_constbytes=Module[\"_crypto_core_salsa2012_constbytes\"]=Module[\"asm\"][\"crypto_core_salsa2012_constbytes\"]).apply(null,arguments)};var _crypto_core_salsa208=Module[\"_crypto_core_salsa208\"]=function(){return(_crypto_core_salsa208=Module[\"_crypto_core_salsa208\"]=Module[\"asm\"][\"crypto_core_salsa208\"]).apply(null,arguments)};var _crypto_core_salsa208_outputbytes=Module[\"_crypto_core_salsa208_outputbytes\"]=function(){return(_crypto_core_salsa208_outputbytes=Module[\"_crypto_core_salsa208_outputbytes\"]=Module[\"asm\"][\"crypto_core_salsa208_outputbytes\"]).apply(null,arguments)};var _crypto_core_salsa208_inputbytes=Module[\"_crypto_core_salsa208_inputbytes\"]=function(){return(_crypto_core_salsa208_inputbytes=Module[\"_crypto_core_salsa208_inputbytes\"]=Module[\"asm\"][\"crypto_core_salsa208_inputbytes\"]).apply(null,arguments)};var _crypto_core_salsa208_keybytes=Module[\"_crypto_core_salsa208_keybytes\"]=function(){return(_crypto_core_salsa208_keybytes=Module[\"_crypto_core_salsa208_keybytes\"]=Module[\"asm\"][\"crypto_core_salsa208_keybytes\"]).apply(null,arguments)};var _crypto_core_salsa208_constbytes=Module[\"_crypto_core_salsa208_constbytes\"]=function(){return(_crypto_core_salsa208_constbytes=Module[\"_crypto_core_salsa208_constbytes\"]=Module[\"asm\"][\"crypto_core_salsa208_constbytes\"]).apply(null,arguments)};var _crypto_generichash_bytes_min=Module[\"_crypto_generichash_bytes_min\"]=function(){return(_crypto_generichash_bytes_min=Module[\"_crypto_generichash_bytes_min\"]=Module[\"asm\"][\"crypto_generichash_bytes_min\"]).apply(null,arguments)};var _crypto_generichash_bytes_max=Module[\"_crypto_generichash_bytes_max\"]=function(){return(_crypto_generichash_bytes_max=Module[\"_crypto_generichash_bytes_max\"]=Module[\"asm\"][\"crypto_generichash_bytes_max\"]).apply(null,arguments)};var _crypto_generichash_bytes=Module[\"_crypto_generichash_bytes\"]=function(){return(_crypto_generichash_bytes=Module[\"_crypto_generichash_bytes\"]=Module[\"asm\"][\"crypto_generichash_bytes\"]).apply(null,arguments)};var _crypto_generichash_keybytes_min=Module[\"_crypto_generichash_keybytes_min\"]=function(){return(_crypto_generichash_keybytes_min=Module[\"_crypto_generichash_keybytes_min\"]=Module[\"asm\"][\"crypto_generichash_keybytes_min\"]).apply(null,arguments)};var _crypto_generichash_keybytes_max=Module[\"_crypto_generichash_keybytes_max\"]=function(){return(_crypto_generichash_keybytes_max=Module[\"_crypto_generichash_keybytes_max\"]=Module[\"asm\"][\"crypto_generichash_keybytes_max\"]).apply(null,arguments)};var _crypto_generichash_keybytes=Module[\"_crypto_generichash_keybytes\"]=function(){return(_crypto_generichash_keybytes=Module[\"_crypto_generichash_keybytes\"]=Module[\"asm\"][\"crypto_generichash_keybytes\"]).apply(null,arguments)};var _crypto_generichash_primitive=Module[\"_crypto_generichash_primitive\"]=function(){return(_crypto_generichash_primitive=Module[\"_crypto_generichash_primitive\"]=Module[\"asm\"][\"crypto_generichash_primitive\"]).apply(null,arguments)};var _crypto_generichash_statebytes=Module[\"_crypto_generichash_statebytes\"]=function(){return(_crypto_generichash_statebytes=Module[\"_crypto_generichash_statebytes\"]=Module[\"asm\"][\"crypto_generichash_statebytes\"]).apply(null,arguments)};var _crypto_generichash=Module[\"_crypto_generichash\"]=function(){return(_crypto_generichash=Module[\"_crypto_generichash\"]=Module[\"asm\"][\"crypto_generichash\"]).apply(null,arguments)};var _crypto_generichash_init=Module[\"_crypto_generichash_init\"]=function(){return(_crypto_generichash_init=Module[\"_crypto_generichash_init\"]=Module[\"asm\"][\"crypto_generichash_init\"]).apply(null,arguments)};var _crypto_generichash_update=Module[\"_crypto_generichash_update\"]=function(){return(_crypto_generichash_update=Module[\"_crypto_generichash_update\"]=Module[\"asm\"][\"crypto_generichash_update\"]).apply(null,arguments)};var _crypto_generichash_final=Module[\"_crypto_generichash_final\"]=function(){return(_crypto_generichash_final=Module[\"_crypto_generichash_final\"]=Module[\"asm\"][\"crypto_generichash_final\"]).apply(null,arguments)};var _crypto_generichash_keygen=Module[\"_crypto_generichash_keygen\"]=function(){return(_crypto_generichash_keygen=Module[\"_crypto_generichash_keygen\"]=Module[\"asm\"][\"crypto_generichash_keygen\"]).apply(null,arguments)};var _crypto_generichash_blake2b_bytes_min=Module[\"_crypto_generichash_blake2b_bytes_min\"]=function(){return(_crypto_generichash_blake2b_bytes_min=Module[\"_crypto_generichash_blake2b_bytes_min\"]=Module[\"asm\"][\"crypto_generichash_blake2b_bytes_min\"]).apply(null,arguments)};var _crypto_generichash_blake2b_bytes_max=Module[\"_crypto_generichash_blake2b_bytes_max\"]=function(){return(_crypto_generichash_blake2b_bytes_max=Module[\"_crypto_generichash_blake2b_bytes_max\"]=Module[\"asm\"][\"crypto_generichash_blake2b_bytes_max\"]).apply(null,arguments)};var _crypto_generichash_blake2b_bytes=Module[\"_crypto_generichash_blake2b_bytes\"]=function(){return(_crypto_generichash_blake2b_bytes=Module[\"_crypto_generichash_blake2b_bytes\"]=Module[\"asm\"][\"crypto_generichash_blake2b_bytes\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keybytes_min=Module[\"_crypto_generichash_blake2b_keybytes_min\"]=function(){return(_crypto_generichash_blake2b_keybytes_min=Module[\"_crypto_generichash_blake2b_keybytes_min\"]=Module[\"asm\"][\"crypto_generichash_blake2b_keybytes_min\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keybytes_max=Module[\"_crypto_generichash_blake2b_keybytes_max\"]=function(){return(_crypto_generichash_blake2b_keybytes_max=Module[\"_crypto_generichash_blake2b_keybytes_max\"]=Module[\"asm\"][\"crypto_generichash_blake2b_keybytes_max\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keybytes=Module[\"_crypto_generichash_blake2b_keybytes\"]=function(){return(_crypto_generichash_blake2b_keybytes=Module[\"_crypto_generichash_blake2b_keybytes\"]=Module[\"asm\"][\"crypto_generichash_blake2b_keybytes\"]).apply(null,arguments)};var _crypto_generichash_blake2b_saltbytes=Module[\"_crypto_generichash_blake2b_saltbytes\"]=function(){return(_crypto_generichash_blake2b_saltbytes=Module[\"_crypto_generichash_blake2b_saltbytes\"]=Module[\"asm\"][\"crypto_generichash_blake2b_saltbytes\"]).apply(null,arguments)};var _crypto_generichash_blake2b_personalbytes=Module[\"_crypto_generichash_blake2b_personalbytes\"]=function(){return(_crypto_generichash_blake2b_personalbytes=Module[\"_crypto_generichash_blake2b_personalbytes\"]=Module[\"asm\"][\"crypto_generichash_blake2b_personalbytes\"]).apply(null,arguments)};var _crypto_generichash_blake2b_statebytes=Module[\"_crypto_generichash_blake2b_statebytes\"]=function(){return(_crypto_generichash_blake2b_statebytes=Module[\"_crypto_generichash_blake2b_statebytes\"]=Module[\"asm\"][\"crypto_generichash_blake2b_statebytes\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keygen=Module[\"_crypto_generichash_blake2b_keygen\"]=function(){return(_crypto_generichash_blake2b_keygen=Module[\"_crypto_generichash_blake2b_keygen\"]=Module[\"asm\"][\"crypto_generichash_blake2b_keygen\"]).apply(null,arguments)};var _crypto_generichash_blake2b=Module[\"_crypto_generichash_blake2b\"]=function(){return(_crypto_generichash_blake2b=Module[\"_crypto_generichash_blake2b\"]=Module[\"asm\"][\"crypto_generichash_blake2b\"]).apply(null,arguments)};var _crypto_generichash_blake2b_salt_personal=Module[\"_crypto_generichash_blake2b_salt_personal\"]=function(){return(_crypto_generichash_blake2b_salt_personal=Module[\"_crypto_generichash_blake2b_salt_personal\"]=Module[\"asm\"][\"crypto_generichash_blake2b_salt_personal\"]).apply(null,arguments)};var _crypto_generichash_blake2b_init=Module[\"_crypto_generichash_blake2b_init\"]=function(){return(_crypto_generichash_blake2b_init=Module[\"_crypto_generichash_blake2b_init\"]=Module[\"asm\"][\"crypto_generichash_blake2b_init\"]).apply(null,arguments)};var _crypto_generichash_blake2b_init_salt_personal=Module[\"_crypto_generichash_blake2b_init_salt_personal\"]=function(){return(_crypto_generichash_blake2b_init_salt_personal=Module[\"_crypto_generichash_blake2b_init_salt_personal\"]=Module[\"asm\"][\"crypto_generichash_blake2b_init_salt_personal\"]).apply(null,arguments)};var _crypto_generichash_blake2b_update=Module[\"_crypto_generichash_blake2b_update\"]=function(){return(_crypto_generichash_blake2b_update=Module[\"_crypto_generichash_blake2b_update\"]=Module[\"asm\"][\"crypto_generichash_blake2b_update\"]).apply(null,arguments)};var _crypto_generichash_blake2b_final=Module[\"_crypto_generichash_blake2b_final\"]=function(){return(_crypto_generichash_blake2b_final=Module[\"_crypto_generichash_blake2b_final\"]=Module[\"asm\"][\"crypto_generichash_blake2b_final\"]).apply(null,arguments)};var _crypto_hash_bytes=Module[\"_crypto_hash_bytes\"]=function(){return(_crypto_hash_bytes=Module[\"_crypto_hash_bytes\"]=Module[\"asm\"][\"crypto_hash_bytes\"]).apply(null,arguments)};var _crypto_hash=Module[\"_crypto_hash\"]=function(){return(_crypto_hash=Module[\"_crypto_hash\"]=Module[\"asm\"][\"crypto_hash\"]).apply(null,arguments)};var _crypto_hash_primitive=Module[\"_crypto_hash_primitive\"]=function(){return(_crypto_hash_primitive=Module[\"_crypto_hash_primitive\"]=Module[\"asm\"][\"crypto_hash_primitive\"]).apply(null,arguments)};var _crypto_hash_sha256_bytes=Module[\"_crypto_hash_sha256_bytes\"]=function(){return(_crypto_hash_sha256_bytes=Module[\"_crypto_hash_sha256_bytes\"]=Module[\"asm\"][\"crypto_hash_sha256_bytes\"]).apply(null,arguments)};var _crypto_hash_sha256_statebytes=Module[\"_crypto_hash_sha256_statebytes\"]=function(){return(_crypto_hash_sha256_statebytes=Module[\"_crypto_hash_sha256_statebytes\"]=Module[\"asm\"][\"crypto_hash_sha256_statebytes\"]).apply(null,arguments)};var _crypto_hash_sha256_init=Module[\"_crypto_hash_sha256_init\"]=function(){return(_crypto_hash_sha256_init=Module[\"_crypto_hash_sha256_init\"]=Module[\"asm\"][\"crypto_hash_sha256_init\"]).apply(null,arguments)};var _crypto_hash_sha256_update=Module[\"_crypto_hash_sha256_update\"]=function(){return(_crypto_hash_sha256_update=Module[\"_crypto_hash_sha256_update\"]=Module[\"asm\"][\"crypto_hash_sha256_update\"]).apply(null,arguments)};var _crypto_hash_sha256_final=Module[\"_crypto_hash_sha256_final\"]=function(){return(_crypto_hash_sha256_final=Module[\"_crypto_hash_sha256_final\"]=Module[\"asm\"][\"crypto_hash_sha256_final\"]).apply(null,arguments)};var _crypto_hash_sha256=Module[\"_crypto_hash_sha256\"]=function(){return(_crypto_hash_sha256=Module[\"_crypto_hash_sha256\"]=Module[\"asm\"][\"crypto_hash_sha256\"]).apply(null,arguments)};var _crypto_hash_sha512_bytes=Module[\"_crypto_hash_sha512_bytes\"]=function(){return(_crypto_hash_sha512_bytes=Module[\"_crypto_hash_sha512_bytes\"]=Module[\"asm\"][\"crypto_hash_sha512_bytes\"]).apply(null,arguments)};var _crypto_hash_sha512_statebytes=Module[\"_crypto_hash_sha512_statebytes\"]=function(){return(_crypto_hash_sha512_statebytes=Module[\"_crypto_hash_sha512_statebytes\"]=Module[\"asm\"][\"crypto_hash_sha512_statebytes\"]).apply(null,arguments)};var _crypto_hash_sha512_init=Module[\"_crypto_hash_sha512_init\"]=function(){return(_crypto_hash_sha512_init=Module[\"_crypto_hash_sha512_init\"]=Module[\"asm\"][\"crypto_hash_sha512_init\"]).apply(null,arguments)};var _crypto_hash_sha512_update=Module[\"_crypto_hash_sha512_update\"]=function(){return(_crypto_hash_sha512_update=Module[\"_crypto_hash_sha512_update\"]=Module[\"asm\"][\"crypto_hash_sha512_update\"]).apply(null,arguments)};var _crypto_hash_sha512_final=Module[\"_crypto_hash_sha512_final\"]=function(){return(_crypto_hash_sha512_final=Module[\"_crypto_hash_sha512_final\"]=Module[\"asm\"][\"crypto_hash_sha512_final\"]).apply(null,arguments)};var _crypto_hash_sha512=Module[\"_crypto_hash_sha512\"]=function(){return(_crypto_hash_sha512=Module[\"_crypto_hash_sha512\"]=Module[\"asm\"][\"crypto_hash_sha512\"]).apply(null,arguments)};var _crypto_kdf_blake2b_bytes_min=Module[\"_crypto_kdf_blake2b_bytes_min\"]=function(){return(_crypto_kdf_blake2b_bytes_min=Module[\"_crypto_kdf_blake2b_bytes_min\"]=Module[\"asm\"][\"crypto_kdf_blake2b_bytes_min\"]).apply(null,arguments)};var _crypto_kdf_blake2b_bytes_max=Module[\"_crypto_kdf_blake2b_bytes_max\"]=function(){return(_crypto_kdf_blake2b_bytes_max=Module[\"_crypto_kdf_blake2b_bytes_max\"]=Module[\"asm\"][\"crypto_kdf_blake2b_bytes_max\"]).apply(null,arguments)};var _crypto_kdf_blake2b_contextbytes=Module[\"_crypto_kdf_blake2b_contextbytes\"]=function(){return(_crypto_kdf_blake2b_contextbytes=Module[\"_crypto_kdf_blake2b_contextbytes\"]=Module[\"asm\"][\"crypto_kdf_blake2b_contextbytes\"]).apply(null,arguments)};var _crypto_kdf_blake2b_keybytes=Module[\"_crypto_kdf_blake2b_keybytes\"]=function(){return(_crypto_kdf_blake2b_keybytes=Module[\"_crypto_kdf_blake2b_keybytes\"]=Module[\"asm\"][\"crypto_kdf_blake2b_keybytes\"]).apply(null,arguments)};var _crypto_kdf_blake2b_derive_from_key=Module[\"_crypto_kdf_blake2b_derive_from_key\"]=function(){return(_crypto_kdf_blake2b_derive_from_key=Module[\"_crypto_kdf_blake2b_derive_from_key\"]=Module[\"asm\"][\"crypto_kdf_blake2b_derive_from_key\"]).apply(null,arguments)};var _crypto_kdf_primitive=Module[\"_crypto_kdf_primitive\"]=function(){return(_crypto_kdf_primitive=Module[\"_crypto_kdf_primitive\"]=Module[\"asm\"][\"crypto_kdf_primitive\"]).apply(null,arguments)};var _crypto_kdf_bytes_min=Module[\"_crypto_kdf_bytes_min\"]=function(){return(_crypto_kdf_bytes_min=Module[\"_crypto_kdf_bytes_min\"]=Module[\"asm\"][\"crypto_kdf_bytes_min\"]).apply(null,arguments)};var _crypto_kdf_bytes_max=Module[\"_crypto_kdf_bytes_max\"]=function(){return(_crypto_kdf_bytes_max=Module[\"_crypto_kdf_bytes_max\"]=Module[\"asm\"][\"crypto_kdf_bytes_max\"]).apply(null,arguments)};var _crypto_kdf_contextbytes=Module[\"_crypto_kdf_contextbytes\"]=function(){return(_crypto_kdf_contextbytes=Module[\"_crypto_kdf_contextbytes\"]=Module[\"asm\"][\"crypto_kdf_contextbytes\"]).apply(null,arguments)};var _crypto_kdf_keybytes=Module[\"_crypto_kdf_keybytes\"]=function(){return(_crypto_kdf_keybytes=Module[\"_crypto_kdf_keybytes\"]=Module[\"asm\"][\"crypto_kdf_keybytes\"]).apply(null,arguments)};var _crypto_kdf_derive_from_key=Module[\"_crypto_kdf_derive_from_key\"]=function(){return(_crypto_kdf_derive_from_key=Module[\"_crypto_kdf_derive_from_key\"]=Module[\"asm\"][\"crypto_kdf_derive_from_key\"]).apply(null,arguments)};var _crypto_kdf_keygen=Module[\"_crypto_kdf_keygen\"]=function(){return(_crypto_kdf_keygen=Module[\"_crypto_kdf_keygen\"]=Module[\"asm\"][\"crypto_kdf_keygen\"]).apply(null,arguments)};var _crypto_kx_seed_keypair=Module[\"_crypto_kx_seed_keypair\"]=function(){return(_crypto_kx_seed_keypair=Module[\"_crypto_kx_seed_keypair\"]=Module[\"asm\"][\"crypto_kx_seed_keypair\"]).apply(null,arguments)};var _crypto_kx_keypair=Module[\"_crypto_kx_keypair\"]=function(){return(_crypto_kx_keypair=Module[\"_crypto_kx_keypair\"]=Module[\"asm\"][\"crypto_kx_keypair\"]).apply(null,arguments)};var _crypto_kx_client_session_keys=Module[\"_crypto_kx_client_session_keys\"]=function(){return(_crypto_kx_client_session_keys=Module[\"_crypto_kx_client_session_keys\"]=Module[\"asm\"][\"crypto_kx_client_session_keys\"]).apply(null,arguments)};var _crypto_kx_server_session_keys=Module[\"_crypto_kx_server_session_keys\"]=function(){return(_crypto_kx_server_session_keys=Module[\"_crypto_kx_server_session_keys\"]=Module[\"asm\"][\"crypto_kx_server_session_keys\"]).apply(null,arguments)};var _crypto_kx_publickeybytes=Module[\"_crypto_kx_publickeybytes\"]=function(){return(_crypto_kx_publickeybytes=Module[\"_crypto_kx_publickeybytes\"]=Module[\"asm\"][\"crypto_kx_publickeybytes\"]).apply(null,arguments)};var _crypto_kx_secretkeybytes=Module[\"_crypto_kx_secretkeybytes\"]=function(){return(_crypto_kx_secretkeybytes=Module[\"_crypto_kx_secretkeybytes\"]=Module[\"asm\"][\"crypto_kx_secretkeybytes\"]).apply(null,arguments)};var _crypto_kx_seedbytes=Module[\"_crypto_kx_seedbytes\"]=function(){return(_crypto_kx_seedbytes=Module[\"_crypto_kx_seedbytes\"]=Module[\"asm\"][\"crypto_kx_seedbytes\"]).apply(null,arguments)};var _crypto_kx_sessionkeybytes=Module[\"_crypto_kx_sessionkeybytes\"]=function(){return(_crypto_kx_sessionkeybytes=Module[\"_crypto_kx_sessionkeybytes\"]=Module[\"asm\"][\"crypto_kx_sessionkeybytes\"]).apply(null,arguments)};var _crypto_kx_primitive=Module[\"_crypto_kx_primitive\"]=function(){return(_crypto_kx_primitive=Module[\"_crypto_kx_primitive\"]=Module[\"asm\"][\"crypto_kx_primitive\"]).apply(null,arguments)};var _crypto_onetimeauth_statebytes=Module[\"_crypto_onetimeauth_statebytes\"]=function(){return(_crypto_onetimeauth_statebytes=Module[\"_crypto_onetimeauth_statebytes\"]=Module[\"asm\"][\"crypto_onetimeauth_statebytes\"]).apply(null,arguments)};var _crypto_onetimeauth_bytes=Module[\"_crypto_onetimeauth_bytes\"]=function(){return(_crypto_onetimeauth_bytes=Module[\"_crypto_onetimeauth_bytes\"]=Module[\"asm\"][\"crypto_onetimeauth_bytes\"]).apply(null,arguments)};var _crypto_onetimeauth_keybytes=Module[\"_crypto_onetimeauth_keybytes\"]=function(){return(_crypto_onetimeauth_keybytes=Module[\"_crypto_onetimeauth_keybytes\"]=Module[\"asm\"][\"crypto_onetimeauth_keybytes\"]).apply(null,arguments)};var _crypto_onetimeauth=Module[\"_crypto_onetimeauth\"]=function(){return(_crypto_onetimeauth=Module[\"_crypto_onetimeauth\"]=Module[\"asm\"][\"crypto_onetimeauth\"]).apply(null,arguments)};var _crypto_onetimeauth_verify=Module[\"_crypto_onetimeauth_verify\"]=function(){return(_crypto_onetimeauth_verify=Module[\"_crypto_onetimeauth_verify\"]=Module[\"asm\"][\"crypto_onetimeauth_verify\"]).apply(null,arguments)};var _crypto_onetimeauth_init=Module[\"_crypto_onetimeauth_init\"]=function(){return(_crypto_onetimeauth_init=Module[\"_crypto_onetimeauth_init\"]=Module[\"asm\"][\"crypto_onetimeauth_init\"]).apply(null,arguments)};var _crypto_onetimeauth_update=Module[\"_crypto_onetimeauth_update\"]=function(){return(_crypto_onetimeauth_update=Module[\"_crypto_onetimeauth_update\"]=Module[\"asm\"][\"crypto_onetimeauth_update\"]).apply(null,arguments)};var _crypto_onetimeauth_final=Module[\"_crypto_onetimeauth_final\"]=function(){return(_crypto_onetimeauth_final=Module[\"_crypto_onetimeauth_final\"]=Module[\"asm\"][\"crypto_onetimeauth_final\"]).apply(null,arguments)};var _crypto_onetimeauth_primitive=Module[\"_crypto_onetimeauth_primitive\"]=function(){return(_crypto_onetimeauth_primitive=Module[\"_crypto_onetimeauth_primitive\"]=Module[\"asm\"][\"crypto_onetimeauth_primitive\"]).apply(null,arguments)};var _crypto_onetimeauth_keygen=Module[\"_crypto_onetimeauth_keygen\"]=function(){return(_crypto_onetimeauth_keygen=Module[\"_crypto_onetimeauth_keygen\"]=Module[\"asm\"][\"crypto_onetimeauth_keygen\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305=Module[\"_crypto_onetimeauth_poly1305\"]=function(){return(_crypto_onetimeauth_poly1305=Module[\"_crypto_onetimeauth_poly1305\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_verify=Module[\"_crypto_onetimeauth_poly1305_verify\"]=function(){return(_crypto_onetimeauth_poly1305_verify=Module[\"_crypto_onetimeauth_poly1305_verify\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_verify\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_init=Module[\"_crypto_onetimeauth_poly1305_init\"]=function(){return(_crypto_onetimeauth_poly1305_init=Module[\"_crypto_onetimeauth_poly1305_init\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_init\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_update=Module[\"_crypto_onetimeauth_poly1305_update\"]=function(){return(_crypto_onetimeauth_poly1305_update=Module[\"_crypto_onetimeauth_poly1305_update\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_update\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_final=Module[\"_crypto_onetimeauth_poly1305_final\"]=function(){return(_crypto_onetimeauth_poly1305_final=Module[\"_crypto_onetimeauth_poly1305_final\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_final\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_bytes=Module[\"_crypto_onetimeauth_poly1305_bytes\"]=function(){return(_crypto_onetimeauth_poly1305_bytes=Module[\"_crypto_onetimeauth_poly1305_bytes\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_bytes\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_keybytes=Module[\"_crypto_onetimeauth_poly1305_keybytes\"]=function(){return(_crypto_onetimeauth_poly1305_keybytes=Module[\"_crypto_onetimeauth_poly1305_keybytes\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_keybytes\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_statebytes=Module[\"_crypto_onetimeauth_poly1305_statebytes\"]=function(){return(_crypto_onetimeauth_poly1305_statebytes=Module[\"_crypto_onetimeauth_poly1305_statebytes\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_statebytes\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_keygen=Module[\"_crypto_onetimeauth_poly1305_keygen\"]=function(){return(_crypto_onetimeauth_poly1305_keygen=Module[\"_crypto_onetimeauth_poly1305_keygen\"]=Module[\"asm\"][\"crypto_onetimeauth_poly1305_keygen\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_alg_argon2i13=Module[\"_crypto_pwhash_argon2i_alg_argon2i13\"]=function(){return(_crypto_pwhash_argon2i_alg_argon2i13=Module[\"_crypto_pwhash_argon2i_alg_argon2i13\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_alg_argon2i13\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_bytes_min=Module[\"_crypto_pwhash_argon2i_bytes_min\"]=function(){return(_crypto_pwhash_argon2i_bytes_min=Module[\"_crypto_pwhash_argon2i_bytes_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_bytes_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_bytes_max=Module[\"_crypto_pwhash_argon2i_bytes_max\"]=function(){return(_crypto_pwhash_argon2i_bytes_max=Module[\"_crypto_pwhash_argon2i_bytes_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_bytes_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_passwd_min=Module[\"_crypto_pwhash_argon2i_passwd_min\"]=function(){return(_crypto_pwhash_argon2i_passwd_min=Module[\"_crypto_pwhash_argon2i_passwd_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_passwd_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_passwd_max=Module[\"_crypto_pwhash_argon2i_passwd_max\"]=function(){return(_crypto_pwhash_argon2i_passwd_max=Module[\"_crypto_pwhash_argon2i_passwd_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_passwd_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_saltbytes=Module[\"_crypto_pwhash_argon2i_saltbytes\"]=function(){return(_crypto_pwhash_argon2i_saltbytes=Module[\"_crypto_pwhash_argon2i_saltbytes\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_saltbytes\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_strbytes=Module[\"_crypto_pwhash_argon2i_strbytes\"]=function(){return(_crypto_pwhash_argon2i_strbytes=Module[\"_crypto_pwhash_argon2i_strbytes\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_strbytes\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_strprefix=Module[\"_crypto_pwhash_argon2i_strprefix\"]=function(){return(_crypto_pwhash_argon2i_strprefix=Module[\"_crypto_pwhash_argon2i_strprefix\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_strprefix\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_min=Module[\"_crypto_pwhash_argon2i_opslimit_min\"]=function(){return(_crypto_pwhash_argon2i_opslimit_min=Module[\"_crypto_pwhash_argon2i_opslimit_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_opslimit_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_max=Module[\"_crypto_pwhash_argon2i_opslimit_max\"]=function(){return(_crypto_pwhash_argon2i_opslimit_max=Module[\"_crypto_pwhash_argon2i_opslimit_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_opslimit_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_min=Module[\"_crypto_pwhash_argon2i_memlimit_min\"]=function(){return(_crypto_pwhash_argon2i_memlimit_min=Module[\"_crypto_pwhash_argon2i_memlimit_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_memlimit_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_max=Module[\"_crypto_pwhash_argon2i_memlimit_max\"]=function(){return(_crypto_pwhash_argon2i_memlimit_max=Module[\"_crypto_pwhash_argon2i_memlimit_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_memlimit_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_interactive=Module[\"_crypto_pwhash_argon2i_opslimit_interactive\"]=function(){return(_crypto_pwhash_argon2i_opslimit_interactive=Module[\"_crypto_pwhash_argon2i_opslimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_opslimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_interactive=Module[\"_crypto_pwhash_argon2i_memlimit_interactive\"]=function(){return(_crypto_pwhash_argon2i_memlimit_interactive=Module[\"_crypto_pwhash_argon2i_memlimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_memlimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_moderate=Module[\"_crypto_pwhash_argon2i_opslimit_moderate\"]=function(){return(_crypto_pwhash_argon2i_opslimit_moderate=Module[\"_crypto_pwhash_argon2i_opslimit_moderate\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_opslimit_moderate\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_moderate=Module[\"_crypto_pwhash_argon2i_memlimit_moderate\"]=function(){return(_crypto_pwhash_argon2i_memlimit_moderate=Module[\"_crypto_pwhash_argon2i_memlimit_moderate\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_memlimit_moderate\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_sensitive=Module[\"_crypto_pwhash_argon2i_opslimit_sensitive\"]=function(){return(_crypto_pwhash_argon2i_opslimit_sensitive=Module[\"_crypto_pwhash_argon2i_opslimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_opslimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_sensitive=Module[\"_crypto_pwhash_argon2i_memlimit_sensitive\"]=function(){return(_crypto_pwhash_argon2i_memlimit_sensitive=Module[\"_crypto_pwhash_argon2i_memlimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_memlimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_argon2i=Module[\"_crypto_pwhash_argon2i\"]=function(){return(_crypto_pwhash_argon2i=Module[\"_crypto_pwhash_argon2i\"]=Module[\"asm\"][\"crypto_pwhash_argon2i\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_str=Module[\"_crypto_pwhash_argon2i_str\"]=function(){return(_crypto_pwhash_argon2i_str=Module[\"_crypto_pwhash_argon2i_str\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_str\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_str_verify=Module[\"_crypto_pwhash_argon2i_str_verify\"]=function(){return(_crypto_pwhash_argon2i_str_verify=Module[\"_crypto_pwhash_argon2i_str_verify\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_str_verify\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_str_needs_rehash=Module[\"_crypto_pwhash_argon2i_str_needs_rehash\"]=function(){return(_crypto_pwhash_argon2i_str_needs_rehash=Module[\"_crypto_pwhash_argon2i_str_needs_rehash\"]=Module[\"asm\"][\"crypto_pwhash_argon2i_str_needs_rehash\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_str_needs_rehash=Module[\"_crypto_pwhash_argon2id_str_needs_rehash\"]=function(){return(_crypto_pwhash_argon2id_str_needs_rehash=Module[\"_crypto_pwhash_argon2id_str_needs_rehash\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_str_needs_rehash\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_alg_argon2id13=Module[\"_crypto_pwhash_argon2id_alg_argon2id13\"]=function(){return(_crypto_pwhash_argon2id_alg_argon2id13=Module[\"_crypto_pwhash_argon2id_alg_argon2id13\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_alg_argon2id13\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_bytes_min=Module[\"_crypto_pwhash_argon2id_bytes_min\"]=function(){return(_crypto_pwhash_argon2id_bytes_min=Module[\"_crypto_pwhash_argon2id_bytes_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_bytes_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_bytes_max=Module[\"_crypto_pwhash_argon2id_bytes_max\"]=function(){return(_crypto_pwhash_argon2id_bytes_max=Module[\"_crypto_pwhash_argon2id_bytes_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_bytes_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_passwd_min=Module[\"_crypto_pwhash_argon2id_passwd_min\"]=function(){return(_crypto_pwhash_argon2id_passwd_min=Module[\"_crypto_pwhash_argon2id_passwd_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_passwd_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_passwd_max=Module[\"_crypto_pwhash_argon2id_passwd_max\"]=function(){return(_crypto_pwhash_argon2id_passwd_max=Module[\"_crypto_pwhash_argon2id_passwd_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_passwd_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_saltbytes=Module[\"_crypto_pwhash_argon2id_saltbytes\"]=function(){return(_crypto_pwhash_argon2id_saltbytes=Module[\"_crypto_pwhash_argon2id_saltbytes\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_saltbytes\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_strbytes=Module[\"_crypto_pwhash_argon2id_strbytes\"]=function(){return(_crypto_pwhash_argon2id_strbytes=Module[\"_crypto_pwhash_argon2id_strbytes\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_strbytes\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_strprefix=Module[\"_crypto_pwhash_argon2id_strprefix\"]=function(){return(_crypto_pwhash_argon2id_strprefix=Module[\"_crypto_pwhash_argon2id_strprefix\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_strprefix\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_min=Module[\"_crypto_pwhash_argon2id_opslimit_min\"]=function(){return(_crypto_pwhash_argon2id_opslimit_min=Module[\"_crypto_pwhash_argon2id_opslimit_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_opslimit_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_max=Module[\"_crypto_pwhash_argon2id_opslimit_max\"]=function(){return(_crypto_pwhash_argon2id_opslimit_max=Module[\"_crypto_pwhash_argon2id_opslimit_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_opslimit_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_min=Module[\"_crypto_pwhash_argon2id_memlimit_min\"]=function(){return(_crypto_pwhash_argon2id_memlimit_min=Module[\"_crypto_pwhash_argon2id_memlimit_min\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_memlimit_min\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_max=Module[\"_crypto_pwhash_argon2id_memlimit_max\"]=function(){return(_crypto_pwhash_argon2id_memlimit_max=Module[\"_crypto_pwhash_argon2id_memlimit_max\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_memlimit_max\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_interactive=Module[\"_crypto_pwhash_argon2id_opslimit_interactive\"]=function(){return(_crypto_pwhash_argon2id_opslimit_interactive=Module[\"_crypto_pwhash_argon2id_opslimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_opslimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_interactive=Module[\"_crypto_pwhash_argon2id_memlimit_interactive\"]=function(){return(_crypto_pwhash_argon2id_memlimit_interactive=Module[\"_crypto_pwhash_argon2id_memlimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_memlimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_moderate=Module[\"_crypto_pwhash_argon2id_opslimit_moderate\"]=function(){return(_crypto_pwhash_argon2id_opslimit_moderate=Module[\"_crypto_pwhash_argon2id_opslimit_moderate\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_opslimit_moderate\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_moderate=Module[\"_crypto_pwhash_argon2id_memlimit_moderate\"]=function(){return(_crypto_pwhash_argon2id_memlimit_moderate=Module[\"_crypto_pwhash_argon2id_memlimit_moderate\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_memlimit_moderate\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_sensitive=Module[\"_crypto_pwhash_argon2id_opslimit_sensitive\"]=function(){return(_crypto_pwhash_argon2id_opslimit_sensitive=Module[\"_crypto_pwhash_argon2id_opslimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_opslimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_sensitive=Module[\"_crypto_pwhash_argon2id_memlimit_sensitive\"]=function(){return(_crypto_pwhash_argon2id_memlimit_sensitive=Module[\"_crypto_pwhash_argon2id_memlimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_memlimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_argon2id=Module[\"_crypto_pwhash_argon2id\"]=function(){return(_crypto_pwhash_argon2id=Module[\"_crypto_pwhash_argon2id\"]=Module[\"asm\"][\"crypto_pwhash_argon2id\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_str=Module[\"_crypto_pwhash_argon2id_str\"]=function(){return(_crypto_pwhash_argon2id_str=Module[\"_crypto_pwhash_argon2id_str\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_str\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_str_verify=Module[\"_crypto_pwhash_argon2id_str_verify\"]=function(){return(_crypto_pwhash_argon2id_str_verify=Module[\"_crypto_pwhash_argon2id_str_verify\"]=Module[\"asm\"][\"crypto_pwhash_argon2id_str_verify\"]).apply(null,arguments)};var _crypto_pwhash_alg_argon2i13=Module[\"_crypto_pwhash_alg_argon2i13\"]=function(){return(_crypto_pwhash_alg_argon2i13=Module[\"_crypto_pwhash_alg_argon2i13\"]=Module[\"asm\"][\"crypto_pwhash_alg_argon2i13\"]).apply(null,arguments)};var _crypto_pwhash_alg_argon2id13=Module[\"_crypto_pwhash_alg_argon2id13\"]=function(){return(_crypto_pwhash_alg_argon2id13=Module[\"_crypto_pwhash_alg_argon2id13\"]=Module[\"asm\"][\"crypto_pwhash_alg_argon2id13\"]).apply(null,arguments)};var _crypto_pwhash_alg_default=Module[\"_crypto_pwhash_alg_default\"]=function(){return(_crypto_pwhash_alg_default=Module[\"_crypto_pwhash_alg_default\"]=Module[\"asm\"][\"crypto_pwhash_alg_default\"]).apply(null,arguments)};var _crypto_pwhash_bytes_min=Module[\"_crypto_pwhash_bytes_min\"]=function(){return(_crypto_pwhash_bytes_min=Module[\"_crypto_pwhash_bytes_min\"]=Module[\"asm\"][\"crypto_pwhash_bytes_min\"]).apply(null,arguments)};var _crypto_pwhash_bytes_max=Module[\"_crypto_pwhash_bytes_max\"]=function(){return(_crypto_pwhash_bytes_max=Module[\"_crypto_pwhash_bytes_max\"]=Module[\"asm\"][\"crypto_pwhash_bytes_max\"]).apply(null,arguments)};var _crypto_pwhash_passwd_min=Module[\"_crypto_pwhash_passwd_min\"]=function(){return(_crypto_pwhash_passwd_min=Module[\"_crypto_pwhash_passwd_min\"]=Module[\"asm\"][\"crypto_pwhash_passwd_min\"]).apply(null,arguments)};var _crypto_pwhash_passwd_max=Module[\"_crypto_pwhash_passwd_max\"]=function(){return(_crypto_pwhash_passwd_max=Module[\"_crypto_pwhash_passwd_max\"]=Module[\"asm\"][\"crypto_pwhash_passwd_max\"]).apply(null,arguments)};var _crypto_pwhash_saltbytes=Module[\"_crypto_pwhash_saltbytes\"]=function(){return(_crypto_pwhash_saltbytes=Module[\"_crypto_pwhash_saltbytes\"]=Module[\"asm\"][\"crypto_pwhash_saltbytes\"]).apply(null,arguments)};var _crypto_pwhash_strbytes=Module[\"_crypto_pwhash_strbytes\"]=function(){return(_crypto_pwhash_strbytes=Module[\"_crypto_pwhash_strbytes\"]=Module[\"asm\"][\"crypto_pwhash_strbytes\"]).apply(null,arguments)};var _crypto_pwhash_strprefix=Module[\"_crypto_pwhash_strprefix\"]=function(){return(_crypto_pwhash_strprefix=Module[\"_crypto_pwhash_strprefix\"]=Module[\"asm\"][\"crypto_pwhash_strprefix\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_min=Module[\"_crypto_pwhash_opslimit_min\"]=function(){return(_crypto_pwhash_opslimit_min=Module[\"_crypto_pwhash_opslimit_min\"]=Module[\"asm\"][\"crypto_pwhash_opslimit_min\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_max=Module[\"_crypto_pwhash_opslimit_max\"]=function(){return(_crypto_pwhash_opslimit_max=Module[\"_crypto_pwhash_opslimit_max\"]=Module[\"asm\"][\"crypto_pwhash_opslimit_max\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_min=Module[\"_crypto_pwhash_memlimit_min\"]=function(){return(_crypto_pwhash_memlimit_min=Module[\"_crypto_pwhash_memlimit_min\"]=Module[\"asm\"][\"crypto_pwhash_memlimit_min\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_max=Module[\"_crypto_pwhash_memlimit_max\"]=function(){return(_crypto_pwhash_memlimit_max=Module[\"_crypto_pwhash_memlimit_max\"]=Module[\"asm\"][\"crypto_pwhash_memlimit_max\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_interactive=Module[\"_crypto_pwhash_opslimit_interactive\"]=function(){return(_crypto_pwhash_opslimit_interactive=Module[\"_crypto_pwhash_opslimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_opslimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_interactive=Module[\"_crypto_pwhash_memlimit_interactive\"]=function(){return(_crypto_pwhash_memlimit_interactive=Module[\"_crypto_pwhash_memlimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_memlimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_moderate=Module[\"_crypto_pwhash_opslimit_moderate\"]=function(){return(_crypto_pwhash_opslimit_moderate=Module[\"_crypto_pwhash_opslimit_moderate\"]=Module[\"asm\"][\"crypto_pwhash_opslimit_moderate\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_moderate=Module[\"_crypto_pwhash_memlimit_moderate\"]=function(){return(_crypto_pwhash_memlimit_moderate=Module[\"_crypto_pwhash_memlimit_moderate\"]=Module[\"asm\"][\"crypto_pwhash_memlimit_moderate\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_sensitive=Module[\"_crypto_pwhash_opslimit_sensitive\"]=function(){return(_crypto_pwhash_opslimit_sensitive=Module[\"_crypto_pwhash_opslimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_opslimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_sensitive=Module[\"_crypto_pwhash_memlimit_sensitive\"]=function(){return(_crypto_pwhash_memlimit_sensitive=Module[\"_crypto_pwhash_memlimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_memlimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash=Module[\"_crypto_pwhash\"]=function(){return(_crypto_pwhash=Module[\"_crypto_pwhash\"]=Module[\"asm\"][\"crypto_pwhash\"]).apply(null,arguments)};var _crypto_pwhash_str=Module[\"_crypto_pwhash_str\"]=function(){return(_crypto_pwhash_str=Module[\"_crypto_pwhash_str\"]=Module[\"asm\"][\"crypto_pwhash_str\"]).apply(null,arguments)};var _crypto_pwhash_str_alg=Module[\"_crypto_pwhash_str_alg\"]=function(){return(_crypto_pwhash_str_alg=Module[\"_crypto_pwhash_str_alg\"]=Module[\"asm\"][\"crypto_pwhash_str_alg\"]).apply(null,arguments)};var _crypto_pwhash_str_verify=Module[\"_crypto_pwhash_str_verify\"]=function(){return(_crypto_pwhash_str_verify=Module[\"_crypto_pwhash_str_verify\"]=Module[\"asm\"][\"crypto_pwhash_str_verify\"]).apply(null,arguments)};var _crypto_pwhash_str_needs_rehash=Module[\"_crypto_pwhash_str_needs_rehash\"]=function(){return(_crypto_pwhash_str_needs_rehash=Module[\"_crypto_pwhash_str_needs_rehash\"]=Module[\"asm\"][\"crypto_pwhash_str_needs_rehash\"]).apply(null,arguments)};var _crypto_pwhash_primitive=Module[\"_crypto_pwhash_primitive\"]=function(){return(_crypto_pwhash_primitive=Module[\"_crypto_pwhash_primitive\"]=Module[\"asm\"][\"crypto_pwhash_primitive\"]).apply(null,arguments)};var _crypto_scalarmult_primitive=Module[\"_crypto_scalarmult_primitive\"]=function(){return(_crypto_scalarmult_primitive=Module[\"_crypto_scalarmult_primitive\"]=Module[\"asm\"][\"crypto_scalarmult_primitive\"]).apply(null,arguments)};var _crypto_scalarmult_base=Module[\"_crypto_scalarmult_base\"]=function(){return(_crypto_scalarmult_base=Module[\"_crypto_scalarmult_base\"]=Module[\"asm\"][\"crypto_scalarmult_base\"]).apply(null,arguments)};var _crypto_scalarmult=Module[\"_crypto_scalarmult\"]=function(){return(_crypto_scalarmult=Module[\"_crypto_scalarmult\"]=Module[\"asm\"][\"crypto_scalarmult\"]).apply(null,arguments)};var _crypto_scalarmult_bytes=Module[\"_crypto_scalarmult_bytes\"]=function(){return(_crypto_scalarmult_bytes=Module[\"_crypto_scalarmult_bytes\"]=Module[\"asm\"][\"crypto_scalarmult_bytes\"]).apply(null,arguments)};var _crypto_scalarmult_scalarbytes=Module[\"_crypto_scalarmult_scalarbytes\"]=function(){return(_crypto_scalarmult_scalarbytes=Module[\"_crypto_scalarmult_scalarbytes\"]=Module[\"asm\"][\"crypto_scalarmult_scalarbytes\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519=Module[\"_crypto_scalarmult_curve25519\"]=function(){return(_crypto_scalarmult_curve25519=Module[\"_crypto_scalarmult_curve25519\"]=Module[\"asm\"][\"crypto_scalarmult_curve25519\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519_base=Module[\"_crypto_scalarmult_curve25519_base\"]=function(){return(_crypto_scalarmult_curve25519_base=Module[\"_crypto_scalarmult_curve25519_base\"]=Module[\"asm\"][\"crypto_scalarmult_curve25519_base\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519_bytes=Module[\"_crypto_scalarmult_curve25519_bytes\"]=function(){return(_crypto_scalarmult_curve25519_bytes=Module[\"_crypto_scalarmult_curve25519_bytes\"]=Module[\"asm\"][\"crypto_scalarmult_curve25519_bytes\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519_scalarbytes=Module[\"_crypto_scalarmult_curve25519_scalarbytes\"]=function(){return(_crypto_scalarmult_curve25519_scalarbytes=Module[\"_crypto_scalarmult_curve25519_scalarbytes\"]=Module[\"asm\"][\"crypto_scalarmult_curve25519_scalarbytes\"]).apply(null,arguments)};var _crypto_secretbox_keybytes=Module[\"_crypto_secretbox_keybytes\"]=function(){return(_crypto_secretbox_keybytes=Module[\"_crypto_secretbox_keybytes\"]=Module[\"asm\"][\"crypto_secretbox_keybytes\"]).apply(null,arguments)};var _crypto_secretbox_noncebytes=Module[\"_crypto_secretbox_noncebytes\"]=function(){return(_crypto_secretbox_noncebytes=Module[\"_crypto_secretbox_noncebytes\"]=Module[\"asm\"][\"crypto_secretbox_noncebytes\"]).apply(null,arguments)};var _crypto_secretbox_zerobytes=Module[\"_crypto_secretbox_zerobytes\"]=function(){return(_crypto_secretbox_zerobytes=Module[\"_crypto_secretbox_zerobytes\"]=Module[\"asm\"][\"crypto_secretbox_zerobytes\"]).apply(null,arguments)};var _crypto_secretbox_boxzerobytes=Module[\"_crypto_secretbox_boxzerobytes\"]=function(){return(_crypto_secretbox_boxzerobytes=Module[\"_crypto_secretbox_boxzerobytes\"]=Module[\"asm\"][\"crypto_secretbox_boxzerobytes\"]).apply(null,arguments)};var _crypto_secretbox_macbytes=Module[\"_crypto_secretbox_macbytes\"]=function(){return(_crypto_secretbox_macbytes=Module[\"_crypto_secretbox_macbytes\"]=Module[\"asm\"][\"crypto_secretbox_macbytes\"]).apply(null,arguments)};var _crypto_secretbox_messagebytes_max=Module[\"_crypto_secretbox_messagebytes_max\"]=function(){return(_crypto_secretbox_messagebytes_max=Module[\"_crypto_secretbox_messagebytes_max\"]=Module[\"asm\"][\"crypto_secretbox_messagebytes_max\"]).apply(null,arguments)};var _crypto_secretbox_primitive=Module[\"_crypto_secretbox_primitive\"]=function(){return(_crypto_secretbox_primitive=Module[\"_crypto_secretbox_primitive\"]=Module[\"asm\"][\"crypto_secretbox_primitive\"]).apply(null,arguments)};var _crypto_secretbox=Module[\"_crypto_secretbox\"]=function(){return(_crypto_secretbox=Module[\"_crypto_secretbox\"]=Module[\"asm\"][\"crypto_secretbox\"]).apply(null,arguments)};var _crypto_secretbox_open=Module[\"_crypto_secretbox_open\"]=function(){return(_crypto_secretbox_open=Module[\"_crypto_secretbox_open\"]=Module[\"asm\"][\"crypto_secretbox_open\"]).apply(null,arguments)};var _crypto_secretbox_keygen=Module[\"_crypto_secretbox_keygen\"]=function(){return(_crypto_secretbox_keygen=Module[\"_crypto_secretbox_keygen\"]=Module[\"asm\"][\"crypto_secretbox_keygen\"]).apply(null,arguments)};var _crypto_secretbox_detached=Module[\"_crypto_secretbox_detached\"]=function(){return(_crypto_secretbox_detached=Module[\"_crypto_secretbox_detached\"]=Module[\"asm\"][\"crypto_secretbox_detached\"]).apply(null,arguments)};var _crypto_secretbox_easy=Module[\"_crypto_secretbox_easy\"]=function(){return(_crypto_secretbox_easy=Module[\"_crypto_secretbox_easy\"]=Module[\"asm\"][\"crypto_secretbox_easy\"]).apply(null,arguments)};var _crypto_secretbox_open_detached=Module[\"_crypto_secretbox_open_detached\"]=function(){return(_crypto_secretbox_open_detached=Module[\"_crypto_secretbox_open_detached\"]=Module[\"asm\"][\"crypto_secretbox_open_detached\"]).apply(null,arguments)};var _crypto_secretbox_open_easy=Module[\"_crypto_secretbox_open_easy\"]=function(){return(_crypto_secretbox_open_easy=Module[\"_crypto_secretbox_open_easy\"]=Module[\"asm\"][\"crypto_secretbox_open_easy\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305=Module[\"_crypto_secretbox_xsalsa20poly1305\"]=function(){return(_crypto_secretbox_xsalsa20poly1305=Module[\"_crypto_secretbox_xsalsa20poly1305\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_open=Module[\"_crypto_secretbox_xsalsa20poly1305_open\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_open=Module[\"_crypto_secretbox_xsalsa20poly1305_open\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_open\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_keybytes=Module[\"_crypto_secretbox_xsalsa20poly1305_keybytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_keybytes=Module[\"_crypto_secretbox_xsalsa20poly1305_keybytes\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_keybytes\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_noncebytes=Module[\"_crypto_secretbox_xsalsa20poly1305_noncebytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_noncebytes=Module[\"_crypto_secretbox_xsalsa20poly1305_noncebytes\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_noncebytes\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_zerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_zerobytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_zerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_zerobytes\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_zerobytes\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_boxzerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_boxzerobytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_boxzerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_boxzerobytes\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_boxzerobytes\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_macbytes=Module[\"_crypto_secretbox_xsalsa20poly1305_macbytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_macbytes=Module[\"_crypto_secretbox_xsalsa20poly1305_macbytes\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_macbytes\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xsalsa20poly1305_messagebytes_max\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xsalsa20poly1305_messagebytes_max\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_messagebytes_max\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_keygen=Module[\"_crypto_secretbox_xsalsa20poly1305_keygen\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_keygen=Module[\"_crypto_secretbox_xsalsa20poly1305_keygen\"]=Module[\"asm\"][\"crypto_secretbox_xsalsa20poly1305_keygen\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_keygen=Module[\"_crypto_secretstream_xchacha20poly1305_keygen\"]=function(){return(_crypto_secretstream_xchacha20poly1305_keygen=Module[\"_crypto_secretstream_xchacha20poly1305_keygen\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_keygen\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_init_push=Module[\"_crypto_secretstream_xchacha20poly1305_init_push\"]=function(){return(_crypto_secretstream_xchacha20poly1305_init_push=Module[\"_crypto_secretstream_xchacha20poly1305_init_push\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_init_push\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_init_pull=Module[\"_crypto_secretstream_xchacha20poly1305_init_pull\"]=function(){return(_crypto_secretstream_xchacha20poly1305_init_pull=Module[\"_crypto_secretstream_xchacha20poly1305_init_pull\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_init_pull\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_rekey\"]=function(){return(_crypto_secretstream_xchacha20poly1305_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_rekey\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_rekey\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_push=Module[\"_crypto_secretstream_xchacha20poly1305_push\"]=function(){return(_crypto_secretstream_xchacha20poly1305_push=Module[\"_crypto_secretstream_xchacha20poly1305_push\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_push\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_pull=Module[\"_crypto_secretstream_xchacha20poly1305_pull\"]=function(){return(_crypto_secretstream_xchacha20poly1305_pull=Module[\"_crypto_secretstream_xchacha20poly1305_pull\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_pull\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_statebytes=Module[\"_crypto_secretstream_xchacha20poly1305_statebytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_statebytes=Module[\"_crypto_secretstream_xchacha20poly1305_statebytes\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_statebytes\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_abytes=Module[\"_crypto_secretstream_xchacha20poly1305_abytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_abytes=Module[\"_crypto_secretstream_xchacha20poly1305_abytes\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_abytes\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_headerbytes=Module[\"_crypto_secretstream_xchacha20poly1305_headerbytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_headerbytes=Module[\"_crypto_secretstream_xchacha20poly1305_headerbytes\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_headerbytes\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_keybytes=Module[\"_crypto_secretstream_xchacha20poly1305_keybytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_keybytes=Module[\"_crypto_secretstream_xchacha20poly1305_keybytes\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_keybytes\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretstream_xchacha20poly1305_messagebytes_max\"]=function(){return(_crypto_secretstream_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretstream_xchacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_messagebytes_max\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_message=Module[\"_crypto_secretstream_xchacha20poly1305_tag_message\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_message=Module[\"_crypto_secretstream_xchacha20poly1305_tag_message\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_tag_message\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_push=Module[\"_crypto_secretstream_xchacha20poly1305_tag_push\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_push=Module[\"_crypto_secretstream_xchacha20poly1305_tag_push\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_tag_push\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_tag_rekey\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_tag_rekey\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_tag_rekey\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_final=Module[\"_crypto_secretstream_xchacha20poly1305_tag_final\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_final=Module[\"_crypto_secretstream_xchacha20poly1305_tag_final\"]=Module[\"asm\"][\"crypto_secretstream_xchacha20poly1305_tag_final\"]).apply(null,arguments)};var _crypto_shorthash_bytes=Module[\"_crypto_shorthash_bytes\"]=function(){return(_crypto_shorthash_bytes=Module[\"_crypto_shorthash_bytes\"]=Module[\"asm\"][\"crypto_shorthash_bytes\"]).apply(null,arguments)};var _crypto_shorthash_keybytes=Module[\"_crypto_shorthash_keybytes\"]=function(){return(_crypto_shorthash_keybytes=Module[\"_crypto_shorthash_keybytes\"]=Module[\"asm\"][\"crypto_shorthash_keybytes\"]).apply(null,arguments)};var _crypto_shorthash_primitive=Module[\"_crypto_shorthash_primitive\"]=function(){return(_crypto_shorthash_primitive=Module[\"_crypto_shorthash_primitive\"]=Module[\"asm\"][\"crypto_shorthash_primitive\"]).apply(null,arguments)};var _crypto_shorthash=Module[\"_crypto_shorthash\"]=function(){return(_crypto_shorthash=Module[\"_crypto_shorthash\"]=Module[\"asm\"][\"crypto_shorthash\"]).apply(null,arguments)};var _crypto_shorthash_keygen=Module[\"_crypto_shorthash_keygen\"]=function(){return(_crypto_shorthash_keygen=Module[\"_crypto_shorthash_keygen\"]=Module[\"asm\"][\"crypto_shorthash_keygen\"]).apply(null,arguments)};var _crypto_shorthash_siphash24_bytes=Module[\"_crypto_shorthash_siphash24_bytes\"]=function(){return(_crypto_shorthash_siphash24_bytes=Module[\"_crypto_shorthash_siphash24_bytes\"]=Module[\"asm\"][\"crypto_shorthash_siphash24_bytes\"]).apply(null,arguments)};var _crypto_shorthash_siphash24_keybytes=Module[\"_crypto_shorthash_siphash24_keybytes\"]=function(){return(_crypto_shorthash_siphash24_keybytes=Module[\"_crypto_shorthash_siphash24_keybytes\"]=Module[\"asm\"][\"crypto_shorthash_siphash24_keybytes\"]).apply(null,arguments)};var _crypto_shorthash_siphash24=Module[\"_crypto_shorthash_siphash24\"]=function(){return(_crypto_shorthash_siphash24=Module[\"_crypto_shorthash_siphash24\"]=Module[\"asm\"][\"crypto_shorthash_siphash24\"]).apply(null,arguments)};var _crypto_sign_statebytes=Module[\"_crypto_sign_statebytes\"]=function(){return(_crypto_sign_statebytes=Module[\"_crypto_sign_statebytes\"]=Module[\"asm\"][\"crypto_sign_statebytes\"]).apply(null,arguments)};var _crypto_sign_bytes=Module[\"_crypto_sign_bytes\"]=function(){return(_crypto_sign_bytes=Module[\"_crypto_sign_bytes\"]=Module[\"asm\"][\"crypto_sign_bytes\"]).apply(null,arguments)};var _crypto_sign_seedbytes=Module[\"_crypto_sign_seedbytes\"]=function(){return(_crypto_sign_seedbytes=Module[\"_crypto_sign_seedbytes\"]=Module[\"asm\"][\"crypto_sign_seedbytes\"]).apply(null,arguments)};var _crypto_sign_publickeybytes=Module[\"_crypto_sign_publickeybytes\"]=function(){return(_crypto_sign_publickeybytes=Module[\"_crypto_sign_publickeybytes\"]=Module[\"asm\"][\"crypto_sign_publickeybytes\"]).apply(null,arguments)};var _crypto_sign_secretkeybytes=Module[\"_crypto_sign_secretkeybytes\"]=function(){return(_crypto_sign_secretkeybytes=Module[\"_crypto_sign_secretkeybytes\"]=Module[\"asm\"][\"crypto_sign_secretkeybytes\"]).apply(null,arguments)};var _crypto_sign_messagebytes_max=Module[\"_crypto_sign_messagebytes_max\"]=function(){return(_crypto_sign_messagebytes_max=Module[\"_crypto_sign_messagebytes_max\"]=Module[\"asm\"][\"crypto_sign_messagebytes_max\"]).apply(null,arguments)};var _crypto_sign_primitive=Module[\"_crypto_sign_primitive\"]=function(){return(_crypto_sign_primitive=Module[\"_crypto_sign_primitive\"]=Module[\"asm\"][\"crypto_sign_primitive\"]).apply(null,arguments)};var _crypto_sign_seed_keypair=Module[\"_crypto_sign_seed_keypair\"]=function(){return(_crypto_sign_seed_keypair=Module[\"_crypto_sign_seed_keypair\"]=Module[\"asm\"][\"crypto_sign_seed_keypair\"]).apply(null,arguments)};var _crypto_sign_keypair=Module[\"_crypto_sign_keypair\"]=function(){return(_crypto_sign_keypair=Module[\"_crypto_sign_keypair\"]=Module[\"asm\"][\"crypto_sign_keypair\"]).apply(null,arguments)};var _crypto_sign=Module[\"_crypto_sign\"]=function(){return(_crypto_sign=Module[\"_crypto_sign\"]=Module[\"asm\"][\"crypto_sign\"]).apply(null,arguments)};var _crypto_sign_open=Module[\"_crypto_sign_open\"]=function(){return(_crypto_sign_open=Module[\"_crypto_sign_open\"]=Module[\"asm\"][\"crypto_sign_open\"]).apply(null,arguments)};var _crypto_sign_detached=Module[\"_crypto_sign_detached\"]=function(){return(_crypto_sign_detached=Module[\"_crypto_sign_detached\"]=Module[\"asm\"][\"crypto_sign_detached\"]).apply(null,arguments)};var _crypto_sign_verify_detached=Module[\"_crypto_sign_verify_detached\"]=function(){return(_crypto_sign_verify_detached=Module[\"_crypto_sign_verify_detached\"]=Module[\"asm\"][\"crypto_sign_verify_detached\"]).apply(null,arguments)};var _crypto_sign_init=Module[\"_crypto_sign_init\"]=function(){return(_crypto_sign_init=Module[\"_crypto_sign_init\"]=Module[\"asm\"][\"crypto_sign_init\"]).apply(null,arguments)};var _crypto_sign_update=Module[\"_crypto_sign_update\"]=function(){return(_crypto_sign_update=Module[\"_crypto_sign_update\"]=Module[\"asm\"][\"crypto_sign_update\"]).apply(null,arguments)};var _crypto_sign_final_create=Module[\"_crypto_sign_final_create\"]=function(){return(_crypto_sign_final_create=Module[\"_crypto_sign_final_create\"]=Module[\"asm\"][\"crypto_sign_final_create\"]).apply(null,arguments)};var _crypto_sign_final_verify=Module[\"_crypto_sign_final_verify\"]=function(){return(_crypto_sign_final_verify=Module[\"_crypto_sign_final_verify\"]=Module[\"asm\"][\"crypto_sign_final_verify\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_statebytes=Module[\"_crypto_sign_ed25519ph_statebytes\"]=function(){return(_crypto_sign_ed25519ph_statebytes=Module[\"_crypto_sign_ed25519ph_statebytes\"]=Module[\"asm\"][\"crypto_sign_ed25519ph_statebytes\"]).apply(null,arguments)};var _crypto_sign_ed25519_bytes=Module[\"_crypto_sign_ed25519_bytes\"]=function(){return(_crypto_sign_ed25519_bytes=Module[\"_crypto_sign_ed25519_bytes\"]=Module[\"asm\"][\"crypto_sign_ed25519_bytes\"]).apply(null,arguments)};var _crypto_sign_ed25519_seedbytes=Module[\"_crypto_sign_ed25519_seedbytes\"]=function(){return(_crypto_sign_ed25519_seedbytes=Module[\"_crypto_sign_ed25519_seedbytes\"]=Module[\"asm\"][\"crypto_sign_ed25519_seedbytes\"]).apply(null,arguments)};var _crypto_sign_ed25519_publickeybytes=Module[\"_crypto_sign_ed25519_publickeybytes\"]=function(){return(_crypto_sign_ed25519_publickeybytes=Module[\"_crypto_sign_ed25519_publickeybytes\"]=Module[\"asm\"][\"crypto_sign_ed25519_publickeybytes\"]).apply(null,arguments)};var _crypto_sign_ed25519_secretkeybytes=Module[\"_crypto_sign_ed25519_secretkeybytes\"]=function(){return(_crypto_sign_ed25519_secretkeybytes=Module[\"_crypto_sign_ed25519_secretkeybytes\"]=Module[\"asm\"][\"crypto_sign_ed25519_secretkeybytes\"]).apply(null,arguments)};var _crypto_sign_ed25519_messagebytes_max=Module[\"_crypto_sign_ed25519_messagebytes_max\"]=function(){return(_crypto_sign_ed25519_messagebytes_max=Module[\"_crypto_sign_ed25519_messagebytes_max\"]=Module[\"asm\"][\"crypto_sign_ed25519_messagebytes_max\"]).apply(null,arguments)};var _crypto_sign_ed25519_sk_to_seed=Module[\"_crypto_sign_ed25519_sk_to_seed\"]=function(){return(_crypto_sign_ed25519_sk_to_seed=Module[\"_crypto_sign_ed25519_sk_to_seed\"]=Module[\"asm\"][\"crypto_sign_ed25519_sk_to_seed\"]).apply(null,arguments)};var _crypto_sign_ed25519_sk_to_pk=Module[\"_crypto_sign_ed25519_sk_to_pk\"]=function(){return(_crypto_sign_ed25519_sk_to_pk=Module[\"_crypto_sign_ed25519_sk_to_pk\"]=Module[\"asm\"][\"crypto_sign_ed25519_sk_to_pk\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_init=Module[\"_crypto_sign_ed25519ph_init\"]=function(){return(_crypto_sign_ed25519ph_init=Module[\"_crypto_sign_ed25519ph_init\"]=Module[\"asm\"][\"crypto_sign_ed25519ph_init\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_update=Module[\"_crypto_sign_ed25519ph_update\"]=function(){return(_crypto_sign_ed25519ph_update=Module[\"_crypto_sign_ed25519ph_update\"]=Module[\"asm\"][\"crypto_sign_ed25519ph_update\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_final_create=Module[\"_crypto_sign_ed25519ph_final_create\"]=function(){return(_crypto_sign_ed25519ph_final_create=Module[\"_crypto_sign_ed25519ph_final_create\"]=Module[\"asm\"][\"crypto_sign_ed25519ph_final_create\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_final_verify=Module[\"_crypto_sign_ed25519ph_final_verify\"]=function(){return(_crypto_sign_ed25519ph_final_verify=Module[\"_crypto_sign_ed25519ph_final_verify\"]=Module[\"asm\"][\"crypto_sign_ed25519ph_final_verify\"]).apply(null,arguments)};var _crypto_sign_ed25519_seed_keypair=Module[\"_crypto_sign_ed25519_seed_keypair\"]=function(){return(_crypto_sign_ed25519_seed_keypair=Module[\"_crypto_sign_ed25519_seed_keypair\"]=Module[\"asm\"][\"crypto_sign_ed25519_seed_keypair\"]).apply(null,arguments)};var _crypto_sign_ed25519_keypair=Module[\"_crypto_sign_ed25519_keypair\"]=function(){return(_crypto_sign_ed25519_keypair=Module[\"_crypto_sign_ed25519_keypair\"]=Module[\"asm\"][\"crypto_sign_ed25519_keypair\"]).apply(null,arguments)};var _crypto_sign_ed25519_pk_to_curve25519=Module[\"_crypto_sign_ed25519_pk_to_curve25519\"]=function(){return(_crypto_sign_ed25519_pk_to_curve25519=Module[\"_crypto_sign_ed25519_pk_to_curve25519\"]=Module[\"asm\"][\"crypto_sign_ed25519_pk_to_curve25519\"]).apply(null,arguments)};var _crypto_sign_ed25519_sk_to_curve25519=Module[\"_crypto_sign_ed25519_sk_to_curve25519\"]=function(){return(_crypto_sign_ed25519_sk_to_curve25519=Module[\"_crypto_sign_ed25519_sk_to_curve25519\"]=Module[\"asm\"][\"crypto_sign_ed25519_sk_to_curve25519\"]).apply(null,arguments)};var _crypto_sign_ed25519_verify_detached=Module[\"_crypto_sign_ed25519_verify_detached\"]=function(){return(_crypto_sign_ed25519_verify_detached=Module[\"_crypto_sign_ed25519_verify_detached\"]=Module[\"asm\"][\"crypto_sign_ed25519_verify_detached\"]).apply(null,arguments)};var _crypto_sign_ed25519_open=Module[\"_crypto_sign_ed25519_open\"]=function(){return(_crypto_sign_ed25519_open=Module[\"_crypto_sign_ed25519_open\"]=Module[\"asm\"][\"crypto_sign_ed25519_open\"]).apply(null,arguments)};var _crypto_sign_ed25519_detached=Module[\"_crypto_sign_ed25519_detached\"]=function(){return(_crypto_sign_ed25519_detached=Module[\"_crypto_sign_ed25519_detached\"]=Module[\"asm\"][\"crypto_sign_ed25519_detached\"]).apply(null,arguments)};var _crypto_sign_ed25519=Module[\"_crypto_sign_ed25519\"]=function(){return(_crypto_sign_ed25519=Module[\"_crypto_sign_ed25519\"]=Module[\"asm\"][\"crypto_sign_ed25519\"]).apply(null,arguments)};var _crypto_stream_chacha20_keybytes=Module[\"_crypto_stream_chacha20_keybytes\"]=function(){return(_crypto_stream_chacha20_keybytes=Module[\"_crypto_stream_chacha20_keybytes\"]=Module[\"asm\"][\"crypto_stream_chacha20_keybytes\"]).apply(null,arguments)};var _crypto_stream_chacha20_noncebytes=Module[\"_crypto_stream_chacha20_noncebytes\"]=function(){return(_crypto_stream_chacha20_noncebytes=Module[\"_crypto_stream_chacha20_noncebytes\"]=Module[\"asm\"][\"crypto_stream_chacha20_noncebytes\"]).apply(null,arguments)};var _crypto_stream_chacha20_messagebytes_max=Module[\"_crypto_stream_chacha20_messagebytes_max\"]=function(){return(_crypto_stream_chacha20_messagebytes_max=Module[\"_crypto_stream_chacha20_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_chacha20_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_keybytes=Module[\"_crypto_stream_chacha20_ietf_keybytes\"]=function(){return(_crypto_stream_chacha20_ietf_keybytes=Module[\"_crypto_stream_chacha20_ietf_keybytes\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf_keybytes\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_noncebytes=Module[\"_crypto_stream_chacha20_ietf_noncebytes\"]=function(){return(_crypto_stream_chacha20_ietf_noncebytes=Module[\"_crypto_stream_chacha20_ietf_noncebytes\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf_noncebytes\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_messagebytes_max=Module[\"_crypto_stream_chacha20_ietf_messagebytes_max\"]=function(){return(_crypto_stream_chacha20_ietf_messagebytes_max=Module[\"_crypto_stream_chacha20_ietf_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_chacha20=Module[\"_crypto_stream_chacha20\"]=function(){return(_crypto_stream_chacha20=Module[\"_crypto_stream_chacha20\"]=Module[\"asm\"][\"crypto_stream_chacha20\"]).apply(null,arguments)};var _crypto_stream_chacha20_xor_ic=Module[\"_crypto_stream_chacha20_xor_ic\"]=function(){return(_crypto_stream_chacha20_xor_ic=Module[\"_crypto_stream_chacha20_xor_ic\"]=Module[\"asm\"][\"crypto_stream_chacha20_xor_ic\"]).apply(null,arguments)};var _crypto_stream_chacha20_xor=Module[\"_crypto_stream_chacha20_xor\"]=function(){return(_crypto_stream_chacha20_xor=Module[\"_crypto_stream_chacha20_xor\"]=Module[\"asm\"][\"crypto_stream_chacha20_xor\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf=Module[\"_crypto_stream_chacha20_ietf\"]=function(){return(_crypto_stream_chacha20_ietf=Module[\"_crypto_stream_chacha20_ietf\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_xor_ic=Module[\"_crypto_stream_chacha20_ietf_xor_ic\"]=function(){return(_crypto_stream_chacha20_ietf_xor_ic=Module[\"_crypto_stream_chacha20_ietf_xor_ic\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf_xor_ic\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_xor=Module[\"_crypto_stream_chacha20_ietf_xor\"]=function(){return(_crypto_stream_chacha20_ietf_xor=Module[\"_crypto_stream_chacha20_ietf_xor\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf_xor\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_keygen=Module[\"_crypto_stream_chacha20_ietf_keygen\"]=function(){return(_crypto_stream_chacha20_ietf_keygen=Module[\"_crypto_stream_chacha20_ietf_keygen\"]=Module[\"asm\"][\"crypto_stream_chacha20_ietf_keygen\"]).apply(null,arguments)};var _crypto_stream_chacha20_keygen=Module[\"_crypto_stream_chacha20_keygen\"]=function(){return(_crypto_stream_chacha20_keygen=Module[\"_crypto_stream_chacha20_keygen\"]=Module[\"asm\"][\"crypto_stream_chacha20_keygen\"]).apply(null,arguments)};var _crypto_stream_keybytes=Module[\"_crypto_stream_keybytes\"]=function(){return(_crypto_stream_keybytes=Module[\"_crypto_stream_keybytes\"]=Module[\"asm\"][\"crypto_stream_keybytes\"]).apply(null,arguments)};var _crypto_stream_noncebytes=Module[\"_crypto_stream_noncebytes\"]=function(){return(_crypto_stream_noncebytes=Module[\"_crypto_stream_noncebytes\"]=Module[\"asm\"][\"crypto_stream_noncebytes\"]).apply(null,arguments)};var _crypto_stream_messagebytes_max=Module[\"_crypto_stream_messagebytes_max\"]=function(){return(_crypto_stream_messagebytes_max=Module[\"_crypto_stream_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_primitive=Module[\"_crypto_stream_primitive\"]=function(){return(_crypto_stream_primitive=Module[\"_crypto_stream_primitive\"]=Module[\"asm\"][\"crypto_stream_primitive\"]).apply(null,arguments)};var _crypto_stream=Module[\"_crypto_stream\"]=function(){return(_crypto_stream=Module[\"_crypto_stream\"]=Module[\"asm\"][\"crypto_stream\"]).apply(null,arguments)};var _crypto_stream_xor=Module[\"_crypto_stream_xor\"]=function(){return(_crypto_stream_xor=Module[\"_crypto_stream_xor\"]=Module[\"asm\"][\"crypto_stream_xor\"]).apply(null,arguments)};var _crypto_stream_keygen=Module[\"_crypto_stream_keygen\"]=function(){return(_crypto_stream_keygen=Module[\"_crypto_stream_keygen\"]=Module[\"asm\"][\"crypto_stream_keygen\"]).apply(null,arguments)};var _crypto_stream_salsa20_keybytes=Module[\"_crypto_stream_salsa20_keybytes\"]=function(){return(_crypto_stream_salsa20_keybytes=Module[\"_crypto_stream_salsa20_keybytes\"]=Module[\"asm\"][\"crypto_stream_salsa20_keybytes\"]).apply(null,arguments)};var _crypto_stream_salsa20_noncebytes=Module[\"_crypto_stream_salsa20_noncebytes\"]=function(){return(_crypto_stream_salsa20_noncebytes=Module[\"_crypto_stream_salsa20_noncebytes\"]=Module[\"asm\"][\"crypto_stream_salsa20_noncebytes\"]).apply(null,arguments)};var _crypto_stream_salsa20_messagebytes_max=Module[\"_crypto_stream_salsa20_messagebytes_max\"]=function(){return(_crypto_stream_salsa20_messagebytes_max=Module[\"_crypto_stream_salsa20_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_salsa20_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_salsa20=Module[\"_crypto_stream_salsa20\"]=function(){return(_crypto_stream_salsa20=Module[\"_crypto_stream_salsa20\"]=Module[\"asm\"][\"crypto_stream_salsa20\"]).apply(null,arguments)};var _crypto_stream_salsa20_xor_ic=Module[\"_crypto_stream_salsa20_xor_ic\"]=function(){return(_crypto_stream_salsa20_xor_ic=Module[\"_crypto_stream_salsa20_xor_ic\"]=Module[\"asm\"][\"crypto_stream_salsa20_xor_ic\"]).apply(null,arguments)};var _crypto_stream_salsa20_xor=Module[\"_crypto_stream_salsa20_xor\"]=function(){return(_crypto_stream_salsa20_xor=Module[\"_crypto_stream_salsa20_xor\"]=Module[\"asm\"][\"crypto_stream_salsa20_xor\"]).apply(null,arguments)};var _crypto_stream_salsa20_keygen=Module[\"_crypto_stream_salsa20_keygen\"]=function(){return(_crypto_stream_salsa20_keygen=Module[\"_crypto_stream_salsa20_keygen\"]=Module[\"asm\"][\"crypto_stream_salsa20_keygen\"]).apply(null,arguments)};var _crypto_stream_xsalsa20=Module[\"_crypto_stream_xsalsa20\"]=function(){return(_crypto_stream_xsalsa20=Module[\"_crypto_stream_xsalsa20\"]=Module[\"asm\"][\"crypto_stream_xsalsa20\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_xor_ic=Module[\"_crypto_stream_xsalsa20_xor_ic\"]=function(){return(_crypto_stream_xsalsa20_xor_ic=Module[\"_crypto_stream_xsalsa20_xor_ic\"]=Module[\"asm\"][\"crypto_stream_xsalsa20_xor_ic\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_xor=Module[\"_crypto_stream_xsalsa20_xor\"]=function(){return(_crypto_stream_xsalsa20_xor=Module[\"_crypto_stream_xsalsa20_xor\"]=Module[\"asm\"][\"crypto_stream_xsalsa20_xor\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_keybytes=Module[\"_crypto_stream_xsalsa20_keybytes\"]=function(){return(_crypto_stream_xsalsa20_keybytes=Module[\"_crypto_stream_xsalsa20_keybytes\"]=Module[\"asm\"][\"crypto_stream_xsalsa20_keybytes\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_noncebytes=Module[\"_crypto_stream_xsalsa20_noncebytes\"]=function(){return(_crypto_stream_xsalsa20_noncebytes=Module[\"_crypto_stream_xsalsa20_noncebytes\"]=Module[\"asm\"][\"crypto_stream_xsalsa20_noncebytes\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_messagebytes_max=Module[\"_crypto_stream_xsalsa20_messagebytes_max\"]=function(){return(_crypto_stream_xsalsa20_messagebytes_max=Module[\"_crypto_stream_xsalsa20_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_xsalsa20_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_keygen=Module[\"_crypto_stream_xsalsa20_keygen\"]=function(){return(_crypto_stream_xsalsa20_keygen=Module[\"_crypto_stream_xsalsa20_keygen\"]=Module[\"asm\"][\"crypto_stream_xsalsa20_keygen\"]).apply(null,arguments)};var _crypto_verify_16_bytes=Module[\"_crypto_verify_16_bytes\"]=function(){return(_crypto_verify_16_bytes=Module[\"_crypto_verify_16_bytes\"]=Module[\"asm\"][\"crypto_verify_16_bytes\"]).apply(null,arguments)};var _crypto_verify_32_bytes=Module[\"_crypto_verify_32_bytes\"]=function(){return(_crypto_verify_32_bytes=Module[\"_crypto_verify_32_bytes\"]=Module[\"asm\"][\"crypto_verify_32_bytes\"]).apply(null,arguments)};var _crypto_verify_64_bytes=Module[\"_crypto_verify_64_bytes\"]=function(){return(_crypto_verify_64_bytes=Module[\"_crypto_verify_64_bytes\"]=Module[\"asm\"][\"crypto_verify_64_bytes\"]).apply(null,arguments)};var _crypto_verify_16=Module[\"_crypto_verify_16\"]=function(){return(_crypto_verify_16=Module[\"_crypto_verify_16\"]=Module[\"asm\"][\"crypto_verify_16\"]).apply(null,arguments)};var _crypto_verify_32=Module[\"_crypto_verify_32\"]=function(){return(_crypto_verify_32=Module[\"_crypto_verify_32\"]=Module[\"asm\"][\"crypto_verify_32\"]).apply(null,arguments)};var _crypto_verify_64=Module[\"_crypto_verify_64\"]=function(){return(_crypto_verify_64=Module[\"_crypto_verify_64\"]=Module[\"asm\"][\"crypto_verify_64\"]).apply(null,arguments)};var _randombytes_implementation_name=Module[\"_randombytes_implementation_name\"]=function(){return(_randombytes_implementation_name=Module[\"_randombytes_implementation_name\"]=Module[\"asm\"][\"randombytes_implementation_name\"]).apply(null,arguments)};var _randombytes_random=Module[\"_randombytes_random\"]=function(){return(_randombytes_random=Module[\"_randombytes_random\"]=Module[\"asm\"][\"randombytes_random\"]).apply(null,arguments)};var _randombytes_stir=Module[\"_randombytes_stir\"]=function(){return(_randombytes_stir=Module[\"_randombytes_stir\"]=Module[\"asm\"][\"randombytes_stir\"]).apply(null,arguments)};var _randombytes_uniform=Module[\"_randombytes_uniform\"]=function(){return(_randombytes_uniform=Module[\"_randombytes_uniform\"]=Module[\"asm\"][\"randombytes_uniform\"]).apply(null,arguments)};var _randombytes_buf=Module[\"_randombytes_buf\"]=function(){return(_randombytes_buf=Module[\"_randombytes_buf\"]=Module[\"asm\"][\"randombytes_buf\"]).apply(null,arguments)};var _randombytes_buf_deterministic=Module[\"_randombytes_buf_deterministic\"]=function(){return(_randombytes_buf_deterministic=Module[\"_randombytes_buf_deterministic\"]=Module[\"asm\"][\"randombytes_buf_deterministic\"]).apply(null,arguments)};var _randombytes_seedbytes=Module[\"_randombytes_seedbytes\"]=function(){return(_randombytes_seedbytes=Module[\"_randombytes_seedbytes\"]=Module[\"asm\"][\"randombytes_seedbytes\"]).apply(null,arguments)};var _randombytes_close=Module[\"_randombytes_close\"]=function(){return(_randombytes_close=Module[\"_randombytes_close\"]=Module[\"asm\"][\"randombytes_close\"]).apply(null,arguments)};var _randombytes=Module[\"_randombytes\"]=function(){return(_randombytes=Module[\"_randombytes\"]=Module[\"asm\"][\"randombytes\"]).apply(null,arguments)};var _sodium_bin2hex=Module[\"_sodium_bin2hex\"]=function(){return(_sodium_bin2hex=Module[\"_sodium_bin2hex\"]=Module[\"asm\"][\"sodium_bin2hex\"]).apply(null,arguments)};var _sodium_hex2bin=Module[\"_sodium_hex2bin\"]=function(){return(_sodium_hex2bin=Module[\"_sodium_hex2bin\"]=Module[\"asm\"][\"sodium_hex2bin\"]).apply(null,arguments)};var _sodium_base64_encoded_len=Module[\"_sodium_base64_encoded_len\"]=function(){return(_sodium_base64_encoded_len=Module[\"_sodium_base64_encoded_len\"]=Module[\"asm\"][\"sodium_base64_encoded_len\"]).apply(null,arguments)};var _sodium_bin2base64=Module[\"_sodium_bin2base64\"]=function(){return(_sodium_bin2base64=Module[\"_sodium_bin2base64\"]=Module[\"asm\"][\"sodium_bin2base64\"]).apply(null,arguments)};var _sodium_base642bin=Module[\"_sodium_base642bin\"]=function(){return(_sodium_base642bin=Module[\"_sodium_base642bin\"]=Module[\"asm\"][\"sodium_base642bin\"]).apply(null,arguments)};var _sodium_init=Module[\"_sodium_init\"]=function(){return(_sodium_init=Module[\"_sodium_init\"]=Module[\"asm\"][\"sodium_init\"]).apply(null,arguments)};var _sodium_pad=Module[\"_sodium_pad\"]=function(){return(_sodium_pad=Module[\"_sodium_pad\"]=Module[\"asm\"][\"sodium_pad\"]).apply(null,arguments)};var _sodium_unpad=Module[\"_sodium_unpad\"]=function(){return(_sodium_unpad=Module[\"_sodium_unpad\"]=Module[\"asm\"][\"sodium_unpad\"]).apply(null,arguments)};var _sodium_version_string=Module[\"_sodium_version_string\"]=function(){return(_sodium_version_string=Module[\"_sodium_version_string\"]=Module[\"asm\"][\"sodium_version_string\"]).apply(null,arguments)};var _sodium_library_version_major=Module[\"_sodium_library_version_major\"]=function(){return(_sodium_library_version_major=Module[\"_sodium_library_version_major\"]=Module[\"asm\"][\"sodium_library_version_major\"]).apply(null,arguments)};var _sodium_library_version_minor=Module[\"_sodium_library_version_minor\"]=function(){return(_sodium_library_version_minor=Module[\"_sodium_library_version_minor\"]=Module[\"asm\"][\"sodium_library_version_minor\"]).apply(null,arguments)};var _sodium_library_minimal=Module[\"_sodium_library_minimal\"]=function(){return(_sodium_library_minimal=Module[\"_sodium_library_minimal\"]=Module[\"asm\"][\"sodium_library_minimal\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_seed_keypair\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_seed_keypair\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_seed_keypair\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_keypair\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_keypair\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_keypair\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_beforenm=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_beforenm=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenm\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_beforenm\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_detached_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_detached_afternm\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_detached_afternm\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_detached\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_detached\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_detached\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_easy_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_easy_afternm\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_easy_afternm\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_easy\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_easy\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_easy\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached_afternm\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_open_detached_afternm\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_open_detached\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy_afternm\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_open_easy_afternm\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_open_easy\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seedbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_seedbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seedbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_seedbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_seedbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_publickeybytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_publickeybytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_publickeybytes\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_secretkeybytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_secretkeybytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_secretkeybytes\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenmbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenmbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_beforenmbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_noncebytes=Module[\"_crypto_box_curve25519xchacha20poly1305_noncebytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_noncebytes=Module[\"_crypto_box_curve25519xchacha20poly1305_noncebytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_noncebytes\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_macbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_macbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_macbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_macbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_macbytes\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xchacha20poly1305_messagebytes_max\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xchacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_messagebytes_max\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seal=Module[\"_crypto_box_curve25519xchacha20poly1305_seal\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seal=Module[\"_crypto_box_curve25519xchacha20poly1305_seal\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_seal\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seal_open=Module[\"_crypto_box_curve25519xchacha20poly1305_seal_open\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seal_open=Module[\"_crypto_box_curve25519xchacha20poly1305_seal_open\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_seal_open\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_sealbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_sealbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_sealbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_sealbytes\"]=Module[\"asm\"][\"crypto_box_curve25519xchacha20poly1305_sealbytes\"]).apply(null,arguments)};var _crypto_core_ed25519_is_valid_point=Module[\"_crypto_core_ed25519_is_valid_point\"]=function(){return(_crypto_core_ed25519_is_valid_point=Module[\"_crypto_core_ed25519_is_valid_point\"]=Module[\"asm\"][\"crypto_core_ed25519_is_valid_point\"]).apply(null,arguments)};var _crypto_core_ed25519_add=Module[\"_crypto_core_ed25519_add\"]=function(){return(_crypto_core_ed25519_add=Module[\"_crypto_core_ed25519_add\"]=Module[\"asm\"][\"crypto_core_ed25519_add\"]).apply(null,arguments)};var _crypto_core_ed25519_sub=Module[\"_crypto_core_ed25519_sub\"]=function(){return(_crypto_core_ed25519_sub=Module[\"_crypto_core_ed25519_sub\"]=Module[\"asm\"][\"crypto_core_ed25519_sub\"]).apply(null,arguments)};var _crypto_core_ed25519_from_uniform=Module[\"_crypto_core_ed25519_from_uniform\"]=function(){return(_crypto_core_ed25519_from_uniform=Module[\"_crypto_core_ed25519_from_uniform\"]=Module[\"asm\"][\"crypto_core_ed25519_from_uniform\"]).apply(null,arguments)};var _crypto_core_ed25519_from_hash=Module[\"_crypto_core_ed25519_from_hash\"]=function(){return(_crypto_core_ed25519_from_hash=Module[\"_crypto_core_ed25519_from_hash\"]=Module[\"asm\"][\"crypto_core_ed25519_from_hash\"]).apply(null,arguments)};var _crypto_core_ed25519_random=Module[\"_crypto_core_ed25519_random\"]=function(){return(_crypto_core_ed25519_random=Module[\"_crypto_core_ed25519_random\"]=Module[\"asm\"][\"crypto_core_ed25519_random\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_random=Module[\"_crypto_core_ed25519_scalar_random\"]=function(){return(_crypto_core_ed25519_scalar_random=Module[\"_crypto_core_ed25519_scalar_random\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_random\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_invert=Module[\"_crypto_core_ed25519_scalar_invert\"]=function(){return(_crypto_core_ed25519_scalar_invert=Module[\"_crypto_core_ed25519_scalar_invert\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_invert\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_negate=Module[\"_crypto_core_ed25519_scalar_negate\"]=function(){return(_crypto_core_ed25519_scalar_negate=Module[\"_crypto_core_ed25519_scalar_negate\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_negate\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_complement=Module[\"_crypto_core_ed25519_scalar_complement\"]=function(){return(_crypto_core_ed25519_scalar_complement=Module[\"_crypto_core_ed25519_scalar_complement\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_complement\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_add=Module[\"_crypto_core_ed25519_scalar_add\"]=function(){return(_crypto_core_ed25519_scalar_add=Module[\"_crypto_core_ed25519_scalar_add\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_add\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_reduce=Module[\"_crypto_core_ed25519_scalar_reduce\"]=function(){return(_crypto_core_ed25519_scalar_reduce=Module[\"_crypto_core_ed25519_scalar_reduce\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_reduce\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_sub=Module[\"_crypto_core_ed25519_scalar_sub\"]=function(){return(_crypto_core_ed25519_scalar_sub=Module[\"_crypto_core_ed25519_scalar_sub\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_sub\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_mul=Module[\"_crypto_core_ed25519_scalar_mul\"]=function(){return(_crypto_core_ed25519_scalar_mul=Module[\"_crypto_core_ed25519_scalar_mul\"]=Module[\"asm\"][\"crypto_core_ed25519_scalar_mul\"]).apply(null,arguments)};var _crypto_core_ed25519_bytes=Module[\"_crypto_core_ed25519_bytes\"]=function(){return(_crypto_core_ed25519_bytes=Module[\"_crypto_core_ed25519_bytes\"]=Module[\"asm\"][\"crypto_core_ed25519_bytes\"]).apply(null,arguments)};var _crypto_core_ed25519_nonreducedscalarbytes=Module[\"_crypto_core_ed25519_nonreducedscalarbytes\"]=function(){return(_crypto_core_ed25519_nonreducedscalarbytes=Module[\"_crypto_core_ed25519_nonreducedscalarbytes\"]=Module[\"asm\"][\"crypto_core_ed25519_nonreducedscalarbytes\"]).apply(null,arguments)};var _crypto_core_ed25519_uniformbytes=Module[\"_crypto_core_ed25519_uniformbytes\"]=function(){return(_crypto_core_ed25519_uniformbytes=Module[\"_crypto_core_ed25519_uniformbytes\"]=Module[\"asm\"][\"crypto_core_ed25519_uniformbytes\"]).apply(null,arguments)};var _crypto_core_ed25519_hashbytes=Module[\"_crypto_core_ed25519_hashbytes\"]=function(){return(_crypto_core_ed25519_hashbytes=Module[\"_crypto_core_ed25519_hashbytes\"]=Module[\"asm\"][\"crypto_core_ed25519_hashbytes\"]).apply(null,arguments)};var _crypto_core_ed25519_scalarbytes=Module[\"_crypto_core_ed25519_scalarbytes\"]=function(){return(_crypto_core_ed25519_scalarbytes=Module[\"_crypto_core_ed25519_scalarbytes\"]=Module[\"asm\"][\"crypto_core_ed25519_scalarbytes\"]).apply(null,arguments)};var _crypto_core_ristretto255_is_valid_point=Module[\"_crypto_core_ristretto255_is_valid_point\"]=function(){return(_crypto_core_ristretto255_is_valid_point=Module[\"_crypto_core_ristretto255_is_valid_point\"]=Module[\"asm\"][\"crypto_core_ristretto255_is_valid_point\"]).apply(null,arguments)};var _crypto_core_ristretto255_add=Module[\"_crypto_core_ristretto255_add\"]=function(){return(_crypto_core_ristretto255_add=Module[\"_crypto_core_ristretto255_add\"]=Module[\"asm\"][\"crypto_core_ristretto255_add\"]).apply(null,arguments)};var _crypto_core_ristretto255_sub=Module[\"_crypto_core_ristretto255_sub\"]=function(){return(_crypto_core_ristretto255_sub=Module[\"_crypto_core_ristretto255_sub\"]=Module[\"asm\"][\"crypto_core_ristretto255_sub\"]).apply(null,arguments)};var _crypto_core_ristretto255_from_hash=Module[\"_crypto_core_ristretto255_from_hash\"]=function(){return(_crypto_core_ristretto255_from_hash=Module[\"_crypto_core_ristretto255_from_hash\"]=Module[\"asm\"][\"crypto_core_ristretto255_from_hash\"]).apply(null,arguments)};var _crypto_core_ristretto255_random=Module[\"_crypto_core_ristretto255_random\"]=function(){return(_crypto_core_ristretto255_random=Module[\"_crypto_core_ristretto255_random\"]=Module[\"asm\"][\"crypto_core_ristretto255_random\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_random=Module[\"_crypto_core_ristretto255_scalar_random\"]=function(){return(_crypto_core_ristretto255_scalar_random=Module[\"_crypto_core_ristretto255_scalar_random\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_random\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_invert=Module[\"_crypto_core_ristretto255_scalar_invert\"]=function(){return(_crypto_core_ristretto255_scalar_invert=Module[\"_crypto_core_ristretto255_scalar_invert\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_invert\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_negate=Module[\"_crypto_core_ristretto255_scalar_negate\"]=function(){return(_crypto_core_ristretto255_scalar_negate=Module[\"_crypto_core_ristretto255_scalar_negate\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_negate\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_complement=Module[\"_crypto_core_ristretto255_scalar_complement\"]=function(){return(_crypto_core_ristretto255_scalar_complement=Module[\"_crypto_core_ristretto255_scalar_complement\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_complement\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_add=Module[\"_crypto_core_ristretto255_scalar_add\"]=function(){return(_crypto_core_ristretto255_scalar_add=Module[\"_crypto_core_ristretto255_scalar_add\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_add\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_sub=Module[\"_crypto_core_ristretto255_scalar_sub\"]=function(){return(_crypto_core_ristretto255_scalar_sub=Module[\"_crypto_core_ristretto255_scalar_sub\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_sub\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_mul=Module[\"_crypto_core_ristretto255_scalar_mul\"]=function(){return(_crypto_core_ristretto255_scalar_mul=Module[\"_crypto_core_ristretto255_scalar_mul\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_mul\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_reduce=Module[\"_crypto_core_ristretto255_scalar_reduce\"]=function(){return(_crypto_core_ristretto255_scalar_reduce=Module[\"_crypto_core_ristretto255_scalar_reduce\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalar_reduce\"]).apply(null,arguments)};var _crypto_core_ristretto255_bytes=Module[\"_crypto_core_ristretto255_bytes\"]=function(){return(_crypto_core_ristretto255_bytes=Module[\"_crypto_core_ristretto255_bytes\"]=Module[\"asm\"][\"crypto_core_ristretto255_bytes\"]).apply(null,arguments)};var _crypto_core_ristretto255_nonreducedscalarbytes=Module[\"_crypto_core_ristretto255_nonreducedscalarbytes\"]=function(){return(_crypto_core_ristretto255_nonreducedscalarbytes=Module[\"_crypto_core_ristretto255_nonreducedscalarbytes\"]=Module[\"asm\"][\"crypto_core_ristretto255_nonreducedscalarbytes\"]).apply(null,arguments)};var _crypto_core_ristretto255_hashbytes=Module[\"_crypto_core_ristretto255_hashbytes\"]=function(){return(_crypto_core_ristretto255_hashbytes=Module[\"_crypto_core_ristretto255_hashbytes\"]=Module[\"asm\"][\"crypto_core_ristretto255_hashbytes\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalarbytes=Module[\"_crypto_core_ristretto255_scalarbytes\"]=function(){return(_crypto_core_ristretto255_scalarbytes=Module[\"_crypto_core_ristretto255_scalarbytes\"]=Module[\"asm\"][\"crypto_core_ristretto255_scalarbytes\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_ll=Module[\"_crypto_pwhash_scryptsalsa208sha256_ll\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_ll=Module[\"_crypto_pwhash_scryptsalsa208sha256_ll\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_ll\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_bytes_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_bytes_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_min\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_bytes_min\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_bytes_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_bytes_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_max\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_bytes_max\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_passwd_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_passwd_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_min\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_passwd_min\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_passwd_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_passwd_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_max\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_passwd_max\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_saltbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_saltbytes\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_saltbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_saltbytes\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_saltbytes\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_strbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_strbytes\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_strbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_strbytes\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_strbytes\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_strprefix=Module[\"_crypto_pwhash_scryptsalsa208sha256_strprefix\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_strprefix=Module[\"_crypto_pwhash_scryptsalsa208sha256_strprefix\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_strprefix\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_min\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_opslimit_min\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_max\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_opslimit_max\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_min\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_memlimit_min\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_max\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_memlimit_max\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_opslimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_memlimit_interactive\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256=Module[\"_crypto_pwhash_scryptsalsa208sha256\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256=Module[\"_crypto_pwhash_scryptsalsa208sha256\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_str=Module[\"_crypto_pwhash_scryptsalsa208sha256_str\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_str=Module[\"_crypto_pwhash_scryptsalsa208sha256_str\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_str\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_str_verify=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_verify\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_str_verify=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_verify\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_str_verify\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_str_needs_rehash=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_needs_rehash\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_str_needs_rehash=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_needs_rehash\"]=Module[\"asm\"][\"crypto_pwhash_scryptsalsa208sha256_str_needs_rehash\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519=Module[\"_crypto_scalarmult_ed25519\"]=function(){return(_crypto_scalarmult_ed25519=Module[\"_crypto_scalarmult_ed25519\"]=Module[\"asm\"][\"crypto_scalarmult_ed25519\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_noclamp=Module[\"_crypto_scalarmult_ed25519_noclamp\"]=function(){return(_crypto_scalarmult_ed25519_noclamp=Module[\"_crypto_scalarmult_ed25519_noclamp\"]=Module[\"asm\"][\"crypto_scalarmult_ed25519_noclamp\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_base=Module[\"_crypto_scalarmult_ed25519_base\"]=function(){return(_crypto_scalarmult_ed25519_base=Module[\"_crypto_scalarmult_ed25519_base\"]=Module[\"asm\"][\"crypto_scalarmult_ed25519_base\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_base_noclamp=Module[\"_crypto_scalarmult_ed25519_base_noclamp\"]=function(){return(_crypto_scalarmult_ed25519_base_noclamp=Module[\"_crypto_scalarmult_ed25519_base_noclamp\"]=Module[\"asm\"][\"crypto_scalarmult_ed25519_base_noclamp\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_bytes=Module[\"_crypto_scalarmult_ed25519_bytes\"]=function(){return(_crypto_scalarmult_ed25519_bytes=Module[\"_crypto_scalarmult_ed25519_bytes\"]=Module[\"asm\"][\"crypto_scalarmult_ed25519_bytes\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_scalarbytes=Module[\"_crypto_scalarmult_ed25519_scalarbytes\"]=function(){return(_crypto_scalarmult_ed25519_scalarbytes=Module[\"_crypto_scalarmult_ed25519_scalarbytes\"]=Module[\"asm\"][\"crypto_scalarmult_ed25519_scalarbytes\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255=Module[\"_crypto_scalarmult_ristretto255\"]=function(){return(_crypto_scalarmult_ristretto255=Module[\"_crypto_scalarmult_ristretto255\"]=Module[\"asm\"][\"crypto_scalarmult_ristretto255\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255_base=Module[\"_crypto_scalarmult_ristretto255_base\"]=function(){return(_crypto_scalarmult_ristretto255_base=Module[\"_crypto_scalarmult_ristretto255_base\"]=Module[\"asm\"][\"crypto_scalarmult_ristretto255_base\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255_bytes=Module[\"_crypto_scalarmult_ristretto255_bytes\"]=function(){return(_crypto_scalarmult_ristretto255_bytes=Module[\"_crypto_scalarmult_ristretto255_bytes\"]=Module[\"asm\"][\"crypto_scalarmult_ristretto255_bytes\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255_scalarbytes=Module[\"_crypto_scalarmult_ristretto255_scalarbytes\"]=function(){return(_crypto_scalarmult_ristretto255_scalarbytes=Module[\"_crypto_scalarmult_ristretto255_scalarbytes\"]=Module[\"asm\"][\"crypto_scalarmult_ristretto255_scalarbytes\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_detached=Module[\"_crypto_secretbox_xchacha20poly1305_detached\"]=function(){return(_crypto_secretbox_xchacha20poly1305_detached=Module[\"_crypto_secretbox_xchacha20poly1305_detached\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_detached\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_easy=Module[\"_crypto_secretbox_xchacha20poly1305_easy\"]=function(){return(_crypto_secretbox_xchacha20poly1305_easy=Module[\"_crypto_secretbox_xchacha20poly1305_easy\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_easy\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_open_detached=Module[\"_crypto_secretbox_xchacha20poly1305_open_detached\"]=function(){return(_crypto_secretbox_xchacha20poly1305_open_detached=Module[\"_crypto_secretbox_xchacha20poly1305_open_detached\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_open_detached\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_open_easy=Module[\"_crypto_secretbox_xchacha20poly1305_open_easy\"]=function(){return(_crypto_secretbox_xchacha20poly1305_open_easy=Module[\"_crypto_secretbox_xchacha20poly1305_open_easy\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_open_easy\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_keybytes=Module[\"_crypto_secretbox_xchacha20poly1305_keybytes\"]=function(){return(_crypto_secretbox_xchacha20poly1305_keybytes=Module[\"_crypto_secretbox_xchacha20poly1305_keybytes\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_keybytes\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_noncebytes=Module[\"_crypto_secretbox_xchacha20poly1305_noncebytes\"]=function(){return(_crypto_secretbox_xchacha20poly1305_noncebytes=Module[\"_crypto_secretbox_xchacha20poly1305_noncebytes\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_noncebytes\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_macbytes=Module[\"_crypto_secretbox_xchacha20poly1305_macbytes\"]=function(){return(_crypto_secretbox_xchacha20poly1305_macbytes=Module[\"_crypto_secretbox_xchacha20poly1305_macbytes\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_macbytes\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xchacha20poly1305_messagebytes_max\"]=function(){return(_crypto_secretbox_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xchacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"crypto_secretbox_xchacha20poly1305_messagebytes_max\"]).apply(null,arguments)};var _crypto_shorthash_siphashx24_bytes=Module[\"_crypto_shorthash_siphashx24_bytes\"]=function(){return(_crypto_shorthash_siphashx24_bytes=Module[\"_crypto_shorthash_siphashx24_bytes\"]=Module[\"asm\"][\"crypto_shorthash_siphashx24_bytes\"]).apply(null,arguments)};var _crypto_shorthash_siphashx24_keybytes=Module[\"_crypto_shorthash_siphashx24_keybytes\"]=function(){return(_crypto_shorthash_siphashx24_keybytes=Module[\"_crypto_shorthash_siphashx24_keybytes\"]=Module[\"asm\"][\"crypto_shorthash_siphashx24_keybytes\"]).apply(null,arguments)};var _crypto_shorthash_siphashx24=Module[\"_crypto_shorthash_siphashx24\"]=function(){return(_crypto_shorthash_siphashx24=Module[\"_crypto_shorthash_siphashx24\"]=Module[\"asm\"][\"crypto_shorthash_siphashx24\"]).apply(null,arguments)};var _crypto_stream_salsa2012=Module[\"_crypto_stream_salsa2012\"]=function(){return(_crypto_stream_salsa2012=Module[\"_crypto_stream_salsa2012\"]=Module[\"asm\"][\"crypto_stream_salsa2012\"]).apply(null,arguments)};var _crypto_stream_salsa2012_xor=Module[\"_crypto_stream_salsa2012_xor\"]=function(){return(_crypto_stream_salsa2012_xor=Module[\"_crypto_stream_salsa2012_xor\"]=Module[\"asm\"][\"crypto_stream_salsa2012_xor\"]).apply(null,arguments)};var _crypto_stream_salsa2012_keybytes=Module[\"_crypto_stream_salsa2012_keybytes\"]=function(){return(_crypto_stream_salsa2012_keybytes=Module[\"_crypto_stream_salsa2012_keybytes\"]=Module[\"asm\"][\"crypto_stream_salsa2012_keybytes\"]).apply(null,arguments)};var _crypto_stream_salsa2012_noncebytes=Module[\"_crypto_stream_salsa2012_noncebytes\"]=function(){return(_crypto_stream_salsa2012_noncebytes=Module[\"_crypto_stream_salsa2012_noncebytes\"]=Module[\"asm\"][\"crypto_stream_salsa2012_noncebytes\"]).apply(null,arguments)};var _crypto_stream_salsa2012_messagebytes_max=Module[\"_crypto_stream_salsa2012_messagebytes_max\"]=function(){return(_crypto_stream_salsa2012_messagebytes_max=Module[\"_crypto_stream_salsa2012_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_salsa2012_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_salsa2012_keygen=Module[\"_crypto_stream_salsa2012_keygen\"]=function(){return(_crypto_stream_salsa2012_keygen=Module[\"_crypto_stream_salsa2012_keygen\"]=Module[\"asm\"][\"crypto_stream_salsa2012_keygen\"]).apply(null,arguments)};var _crypto_stream_salsa208=Module[\"_crypto_stream_salsa208\"]=function(){return(_crypto_stream_salsa208=Module[\"_crypto_stream_salsa208\"]=Module[\"asm\"][\"crypto_stream_salsa208\"]).apply(null,arguments)};var _crypto_stream_salsa208_xor=Module[\"_crypto_stream_salsa208_xor\"]=function(){return(_crypto_stream_salsa208_xor=Module[\"_crypto_stream_salsa208_xor\"]=Module[\"asm\"][\"crypto_stream_salsa208_xor\"]).apply(null,arguments)};var _crypto_stream_salsa208_keybytes=Module[\"_crypto_stream_salsa208_keybytes\"]=function(){return(_crypto_stream_salsa208_keybytes=Module[\"_crypto_stream_salsa208_keybytes\"]=Module[\"asm\"][\"crypto_stream_salsa208_keybytes\"]).apply(null,arguments)};var _crypto_stream_salsa208_noncebytes=Module[\"_crypto_stream_salsa208_noncebytes\"]=function(){return(_crypto_stream_salsa208_noncebytes=Module[\"_crypto_stream_salsa208_noncebytes\"]=Module[\"asm\"][\"crypto_stream_salsa208_noncebytes\"]).apply(null,arguments)};var _crypto_stream_salsa208_messagebytes_max=Module[\"_crypto_stream_salsa208_messagebytes_max\"]=function(){return(_crypto_stream_salsa208_messagebytes_max=Module[\"_crypto_stream_salsa208_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_salsa208_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_salsa208_keygen=Module[\"_crypto_stream_salsa208_keygen\"]=function(){return(_crypto_stream_salsa208_keygen=Module[\"_crypto_stream_salsa208_keygen\"]=Module[\"asm\"][\"crypto_stream_salsa208_keygen\"]).apply(null,arguments)};var _crypto_stream_xchacha20_keybytes=Module[\"_crypto_stream_xchacha20_keybytes\"]=function(){return(_crypto_stream_xchacha20_keybytes=Module[\"_crypto_stream_xchacha20_keybytes\"]=Module[\"asm\"][\"crypto_stream_xchacha20_keybytes\"]).apply(null,arguments)};var _crypto_stream_xchacha20_noncebytes=Module[\"_crypto_stream_xchacha20_noncebytes\"]=function(){return(_crypto_stream_xchacha20_noncebytes=Module[\"_crypto_stream_xchacha20_noncebytes\"]=Module[\"asm\"][\"crypto_stream_xchacha20_noncebytes\"]).apply(null,arguments)};var _crypto_stream_xchacha20_messagebytes_max=Module[\"_crypto_stream_xchacha20_messagebytes_max\"]=function(){return(_crypto_stream_xchacha20_messagebytes_max=Module[\"_crypto_stream_xchacha20_messagebytes_max\"]=Module[\"asm\"][\"crypto_stream_xchacha20_messagebytes_max\"]).apply(null,arguments)};var _crypto_stream_xchacha20=Module[\"_crypto_stream_xchacha20\"]=function(){return(_crypto_stream_xchacha20=Module[\"_crypto_stream_xchacha20\"]=Module[\"asm\"][\"crypto_stream_xchacha20\"]).apply(null,arguments)};var _crypto_stream_xchacha20_xor_ic=Module[\"_crypto_stream_xchacha20_xor_ic\"]=function(){return(_crypto_stream_xchacha20_xor_ic=Module[\"_crypto_stream_xchacha20_xor_ic\"]=Module[\"asm\"][\"crypto_stream_xchacha20_xor_ic\"]).apply(null,arguments)};var _crypto_stream_xchacha20_xor=Module[\"_crypto_stream_xchacha20_xor\"]=function(){return(_crypto_stream_xchacha20_xor=Module[\"_crypto_stream_xchacha20_xor\"]=Module[\"asm\"][\"crypto_stream_xchacha20_xor\"]).apply(null,arguments)};var _crypto_stream_xchacha20_keygen=Module[\"_crypto_stream_xchacha20_keygen\"]=function(){return(_crypto_stream_xchacha20_keygen=Module[\"_crypto_stream_xchacha20_keygen\"]=Module[\"asm\"][\"crypto_stream_xchacha20_keygen\"]).apply(null,arguments)};var _malloc=Module[\"_malloc\"]=function(){return(_malloc=Module[\"_malloc\"]=Module[\"asm\"][\"malloc\"]).apply(null,arguments)};var _free=Module[\"_free\"]=function(){return(_free=Module[\"_free\"]=Module[\"asm\"][\"free\"]).apply(null,arguments)};var __growWasmMemory=Module[\"__growWasmMemory\"]=function(){return(__growWasmMemory=Module[\"__growWasmMemory\"]=Module[\"asm\"][\"__growWasmMemory\"]).apply(null,arguments)};Module[\"setValue\"]=setValue;Module[\"getValue\"]=getValue;Module[\"UTF8ToString\"]=UTF8ToString;var calledRun;dependenciesFulfilled=function runCaller(){if(!calledRun)run();if(!calledRun)dependenciesFulfilled=runCaller};function run(args){args=args||arguments_;if(runDependencies>0){return}preRun();if(runDependencies>0)return;function doRun(){if(calledRun)return;calledRun=true;Module[\"calledRun\"]=true;if(ABORT)return;initRuntime();preMain();if(Module[\"onRuntimeInitialized\"])Module[\"onRuntimeInitialized\"]();postRun()}if(Module[\"setStatus\"]){Module[\"setStatus\"](\"Running...\");setTimeout(function(){setTimeout(function(){Module[\"setStatus\"](\"\")},1);doRun()},1)}else{doRun()}}Module[\"run\"]=run;if(Module[\"preInit\"]){if(typeof Module[\"preInit\"]==\"function\")Module[\"preInit\"]=[Module[\"preInit\"]];while(Module[\"preInit\"].length>0){Module[\"preInit\"].pop()()}}noExitRuntime=true;run();\n        });\n      };\n      var Module=typeof Module!==\"undefined\"?Module:{};var moduleOverrides={};var key;for(key in Module){if(Module.hasOwnProperty(key)){moduleOverrides[key]=Module[key]}}var arguments_=[];var thisProgram=\"./this.program\";var quit_=function(status,toThrow){throw toThrow};var ENVIRONMENT_IS_WEB=false;var ENVIRONMENT_IS_WORKER=false;var ENVIRONMENT_IS_NODE=false;var ENVIRONMENT_IS_SHELL=false;ENVIRONMENT_IS_WEB=typeof window===\"object\";ENVIRONMENT_IS_WORKER=typeof importScripts===\"function\";ENVIRONMENT_IS_NODE=typeof process===\"object\"&&typeof process.versions===\"object\"&&typeof process.versions.node===\"string\";ENVIRONMENT_IS_SHELL=!ENVIRONMENT_IS_WEB&&!ENVIRONMENT_IS_NODE&&!ENVIRONMENT_IS_WORKER;var scriptDirectory=\"\";function locateFile(path){if(Module[\"locateFile\"]){return Module[\"locateFile\"](path,scriptDirectory)}return scriptDirectory+path}var read_,readAsync,readBinary,setWindowTitle;var nodeFS;var nodePath;if(ENVIRONMENT_IS_NODE){if(ENVIRONMENT_IS_WORKER){scriptDirectory=(__webpack_require__(/*! path */ \"path\").dirname)(scriptDirectory)+\"/\"}else{scriptDirectory=__dirname+\"/\"}read_=function shell_read(filename,binary){var ret=tryParseAsDataURI(filename);if(ret){return binary?ret:ret.toString()}if(!nodeFS)nodeFS=__webpack_require__(/*! fs */ \"fs\");if(!nodePath)nodePath=__webpack_require__(/*! path */ \"path\");filename=nodePath[\"normalize\"](filename);return nodeFS[\"readFileSync\"](filename,binary?null:\"utf8\")};readBinary=function readBinary(filename){var ret=read_(filename,true);if(!ret.buffer){ret=new Uint8Array(ret)}assert(ret.buffer);return ret};if(process[\"argv\"].length>1){thisProgram=process[\"argv\"][1].replace(/\\\\/g,\"/\")}arguments_=process[\"argv\"].slice(2);if(true){module[\"exports\"]=Module}quit_=function(status){process[\"exit\"](status)};Module[\"inspect\"]=function(){return\"[Emscripten Module object]\"}}else if(ENVIRONMENT_IS_SHELL){if(typeof read!=\"undefined\"){read_=function shell_read(f){var data=tryParseAsDataURI(f);if(data){return intArrayToString(data)}return read(f)}}readBinary=function readBinary(f){var data;data=tryParseAsDataURI(f);if(data){return data}if(typeof readbuffer===\"function\"){return new Uint8Array(readbuffer(f))}data=read(f,\"binary\");assert(typeof data===\"object\");return data};if(typeof scriptArgs!=\"undefined\"){arguments_=scriptArgs}else if(typeof arguments!=\"undefined\"){arguments_=arguments}if(typeof quit===\"function\"){quit_=function(status){quit(status)}}if(typeof print!==\"undefined\"){if(typeof console===\"undefined\")console={};console.log=print;console.warn=console.error=typeof printErr!==\"undefined\"?printErr:print}}else if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){scriptDirectory=self.location.href}else if(document.currentScript){scriptDirectory=document.currentScript.src}if(scriptDirectory.indexOf(\"blob:\")!==0){scriptDirectory=scriptDirectory.substr(0,scriptDirectory.lastIndexOf(\"/\")+1)}else{scriptDirectory=\"\"}{read_=function shell_read(url){try{var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,false);xhr.send(null);return xhr.responseText}catch(err){var data=tryParseAsDataURI(url);if(data){return intArrayToString(data)}throw err}};if(ENVIRONMENT_IS_WORKER){readBinary=function readBinary(url){try{var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,false);xhr.responseType=\"arraybuffer\";xhr.send(null);return new Uint8Array(xhr.response)}catch(err){var data=tryParseAsDataURI(url);if(data){return data}throw err}}}readAsync=function readAsync(url,onload,onerror){var xhr=new XMLHttpRequest;xhr.open(\"GET\",url,true);xhr.responseType=\"arraybuffer\";xhr.onload=function xhr_onload(){if(xhr.status==200||xhr.status==0&&xhr.response){onload(xhr.response);return}var data=tryParseAsDataURI(url);if(data){onload(data.buffer);return}onerror()};xhr.onerror=onerror;xhr.send(null)}}setWindowTitle=function(title){document.title=title}}else{}var out=Module[\"print\"]||console.log.bind(console);var err=Module[\"printErr\"]||console.warn.bind(console);for(key in moduleOverrides){if(moduleOverrides.hasOwnProperty(key)){Module[key]=moduleOverrides[key]}}moduleOverrides=null;if(Module[\"arguments\"])arguments_=Module[\"arguments\"];if(Module[\"thisProgram\"])thisProgram=Module[\"thisProgram\"];if(Module[\"quit\"])quit_=Module[\"quit\"];var wasmBinary;if(Module[\"wasmBinary\"])wasmBinary=Module[\"wasmBinary\"];var noExitRuntime;if(Module[\"noExitRuntime\"])noExitRuntime=Module[\"noExitRuntime\"];if(typeof WebAssembly!==\"object\"){err(\"no native wasm support detected\")}function setValue(ptr,value,type,noSafe){type=type||\"i8\";if(type.charAt(type.length-1)===\"*\")type=\"i32\";switch(type){case\"i1\":HEAP8[ptr>>0]=value;break;case\"i8\":HEAP8[ptr>>0]=value;break;case\"i16\":HEAP16[ptr>>1]=value;break;case\"i32\":HEAP32[ptr>>2]=value;break;case\"i64\":tempI64=[value>>>0,(tempDouble=value,+Math_abs(tempDouble)>=1?tempDouble>0?(Math_min(+Math_floor(tempDouble/4294967296),4294967295)|0)>>>0:~~+Math_ceil((tempDouble-+(~~tempDouble>>>0))/4294967296)>>>0:0)],HEAP32[ptr>>2]=tempI64[0],HEAP32[ptr+4>>2]=tempI64[1];break;case\"float\":HEAPF32[ptr>>2]=value;break;case\"double\":HEAPF64[ptr>>3]=value;break;default:abort(\"invalid type for setValue: \"+type)}}function getValue(ptr,type,noSafe){type=type||\"i8\";if(type.charAt(type.length-1)===\"*\")type=\"i32\";switch(type){case\"i1\":return HEAP8[ptr>>0];case\"i8\":return HEAP8[ptr>>0];case\"i16\":return HEAP16[ptr>>1];case\"i32\":return HEAP32[ptr>>2];case\"i64\":return HEAP32[ptr>>2];case\"float\":return HEAPF32[ptr>>2];case\"double\":return HEAPF64[ptr>>3];default:abort(\"invalid type for getValue: \"+type)}return null}var wasmMemory;var wasmTable=new WebAssembly.Table({\"initial\":14,\"maximum\":14+8,\"element\":\"anyfunc\"});var ABORT=false;var EXITSTATUS=0;function assert(condition,text){if(!condition){abort(\"Assertion failed: \"+text)}}var UTF8Decoder=typeof TextDecoder!==\"undefined\"?new TextDecoder(\"utf8\"):undefined;function UTF8ArrayToString(heap,idx,maxBytesToRead){var endIdx=idx+maxBytesToRead;var endPtr=idx;while(heap[endPtr]&&!(endPtr>=endIdx))++endPtr;if(endPtr-idx>16&&heap.subarray&&UTF8Decoder){return UTF8Decoder.decode(heap.subarray(idx,endPtr))}else{var str=\"\";while(idx<endPtr){var u0=heap[idx++];if(!(u0&128)){str+=String.fromCharCode(u0);continue}var u1=heap[idx++]&63;if((u0&224)==192){str+=String.fromCharCode((u0&31)<<6|u1);continue}var u2=heap[idx++]&63;if((u0&240)==224){u0=(u0&15)<<12|u1<<6|u2}else{u0=(u0&7)<<18|u1<<12|u2<<6|heap[idx++]&63}if(u0<65536){str+=String.fromCharCode(u0)}else{var ch=u0-65536;str+=String.fromCharCode(55296|ch>>10,56320|ch&1023)}}}return str}function UTF8ToString(ptr,maxBytesToRead){return ptr?UTF8ArrayToString(HEAPU8,ptr,maxBytesToRead):\"\"}var WASM_PAGE_SIZE=65536;function alignUp(x,multiple){if(x%multiple>0){x+=multiple-x%multiple}return x}var buffer,HEAP8,HEAPU8,HEAP16,HEAPU16,HEAP32,HEAPU32,HEAPF32,HEAPF64;function updateGlobalBufferAndViews(buf){buffer=buf;Module[\"HEAP8\"]=HEAP8=new Int8Array(buf);Module[\"HEAP16\"]=HEAP16=new Int16Array(buf);Module[\"HEAP32\"]=HEAP32=new Int32Array(buf);Module[\"HEAPU8\"]=HEAPU8=new Uint8Array(buf);Module[\"HEAPU16\"]=HEAPU16=new Uint16Array(buf);Module[\"HEAPU32\"]=HEAPU32=new Uint32Array(buf);Module[\"HEAPF32\"]=HEAPF32=new Float32Array(buf);Module[\"HEAPF64\"]=HEAPF64=new Float64Array(buf)}var DYNAMIC_BASE=5280352,DYNAMICTOP_PTR=37312;var INITIAL_INITIAL_MEMORY=Module[\"INITIAL_MEMORY\"]||16777216;if(Module[\"wasmMemory\"]){wasmMemory=Module[\"wasmMemory\"]}else{wasmMemory=new WebAssembly.Memory({\"initial\":INITIAL_INITIAL_MEMORY/WASM_PAGE_SIZE,\"maximum\":2147483648/WASM_PAGE_SIZE})}if(wasmMemory){buffer=wasmMemory.buffer}INITIAL_INITIAL_MEMORY=buffer.byteLength;updateGlobalBufferAndViews(buffer);HEAP32[DYNAMICTOP_PTR>>2]=DYNAMIC_BASE;function callRuntimeCallbacks(callbacks){while(callbacks.length>0){var callback=callbacks.shift();if(typeof callback==\"function\"){callback(Module);continue}var func=callback.func;if(typeof func===\"number\"){if(callback.arg===undefined){Module[\"dynCall_v\"](func)}else{Module[\"dynCall_vi\"](func,callback.arg)}}else{func(callback.arg===undefined?null:callback.arg)}}}var __ATPRERUN__=[];var __ATINIT__=[];var __ATMAIN__=[];var __ATPOSTRUN__=[];var runtimeInitialized=false;function preRun(){if(Module[\"preRun\"]){if(typeof Module[\"preRun\"]==\"function\")Module[\"preRun\"]=[Module[\"preRun\"]];while(Module[\"preRun\"].length){addOnPreRun(Module[\"preRun\"].shift())}}callRuntimeCallbacks(__ATPRERUN__)}function initRuntime(){runtimeInitialized=true;callRuntimeCallbacks(__ATINIT__)}function preMain(){callRuntimeCallbacks(__ATMAIN__)}function postRun(){if(Module[\"postRun\"]){if(typeof Module[\"postRun\"]==\"function\")Module[\"postRun\"]=[Module[\"postRun\"]];while(Module[\"postRun\"].length){addOnPostRun(Module[\"postRun\"].shift())}}callRuntimeCallbacks(__ATPOSTRUN__)}function addOnPreRun(cb){__ATPRERUN__.unshift(cb)}function addOnPostRun(cb){__ATPOSTRUN__.unshift(cb)}var Math_abs=Math.abs;var Math_ceil=Math.ceil;var Math_floor=Math.floor;var Math_min=Math.min;var runDependencies=0;var runDependencyWatcher=null;var dependenciesFulfilled=null;function addRunDependency(id){runDependencies++;if(Module[\"monitorRunDependencies\"]){Module[\"monitorRunDependencies\"](runDependencies)}}function removeRunDependency(id){runDependencies--;if(Module[\"monitorRunDependencies\"]){Module[\"monitorRunDependencies\"](runDependencies)}if(runDependencies==0){if(runDependencyWatcher!==null){clearInterval(runDependencyWatcher);runDependencyWatcher=null}if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}Module[\"preloadedImages\"]={};Module[\"preloadedAudios\"]={};function abort(what){if(Module[\"onAbort\"]){Module[\"onAbort\"](what)}what+=\"\";out(what);err(what);ABORT=true;EXITSTATUS=1;what=\"abort(\"+what+\"). Build with -s ASSERTIONS=1 for more info.\";throw new WebAssembly.RuntimeError(what)}function hasPrefix(str,prefix){return String.prototype.startsWith?str.startsWith(prefix):str.indexOf(prefix)===0}var dataURIPrefix=\"data:application/octet-stream;base64,\";function isDataURI(filename){return hasPrefix(filename,dataURIPrefix)}var fileURIPrefix=\"file://\";function isFileURI(filename){return hasPrefix(filename,fileURIPrefix)}var wasmBinaryFile=\"data:application/octet-stream;base64,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\";if(!isDataURI(wasmBinaryFile)){wasmBinaryFile=locateFile(wasmBinaryFile)}function getBinary(){try{if(wasmBinary){return new Uint8Array(wasmBinary)}var binary=tryParseAsDataURI(wasmBinaryFile);if(binary){return binary}if(readBinary){return readBinary(wasmBinaryFile)}else{throw\"both async and sync fetching of the wasm failed\"}}catch(err){abort(err)}}function getBinaryPromise(){if(!wasmBinary&&(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER)&&typeof fetch===\"function\"&&!isFileURI(wasmBinaryFile)){return fetch(wasmBinaryFile,{credentials:\"same-origin\"}).then(function(response){if(!response[\"ok\"]){throw\"failed to load wasm binary file at '\"+wasmBinaryFile+\"'\"}return response[\"arrayBuffer\"]()}).catch(function(){return getBinary()})}return new Promise(function(resolve,reject){resolve(getBinary())})}function createWasm(){var info={\"a\":asmLibraryArg};function receiveInstance(instance,module){var exports=instance.exports;Module[\"asm\"]=exports;removeRunDependency(\"wasm-instantiate\")}addRunDependency(\"wasm-instantiate\");function receiveInstantiatedSource(output){receiveInstance(output[\"instance\"])}function instantiateArrayBuffer(receiver){return getBinaryPromise().then(function(binary){return WebAssembly.instantiate(binary,info)}).then(receiver,function(reason){err(\"failed to asynchronously prepare wasm: \"+reason);abort(reason)})}function instantiateAsync(){if(!wasmBinary&&typeof WebAssembly.instantiateStreaming===\"function\"&&!isDataURI(wasmBinaryFile)&&!isFileURI(wasmBinaryFile)&&typeof fetch===\"function\"){fetch(wasmBinaryFile,{credentials:\"same-origin\"}).then(function(response){var result=WebAssembly.instantiateStreaming(response,info);return result.then(receiveInstantiatedSource,function(reason){err(\"wasm streaming compile failed: \"+reason);err(\"falling back to ArrayBuffer instantiation\");return instantiateArrayBuffer(receiveInstantiatedSource)})})}else{return instantiateArrayBuffer(receiveInstantiatedSource)}}if(Module[\"instantiateWasm\"]){try{var exports=Module[\"instantiateWasm\"](info,receiveInstance);return exports}catch(e){err(\"Module.instantiateWasm callback failed with error: \"+e);return false}}instantiateAsync();return{}}var tempDouble;var tempI64;var ASM_CONSTS={1027:function(){return Module.getRandomValue()},1065:function(){if(Module.getRandomValue===undefined){try{var window_=\"object\"===typeof window?window:self;var crypto_=typeof window_.crypto!==\"undefined\"?window_.crypto:window_.msCrypto;var randomValuesStandard=function(){var buf=new Uint32Array(1);crypto_.getRandomValues(buf);return buf[0]>>>0};randomValuesStandard();Module.getRandomValue=randomValuesStandard}catch(e){try{var crypto=__webpack_require__(/*! crypto */ \"crypto\");var randomValueNodeJS=function(){var buf=crypto[\"randomBytes\"](4);return(buf[0]<<24|buf[1]<<16|buf[2]<<8|buf[3])>>>0};randomValueNodeJS();Module.getRandomValue=randomValueNodeJS}catch(e){throw\"No secure random number generator found\"}}}}};function _emscripten_asm_const_iii(code,sigPtr,argbuf){var args=readAsmConstArgs(sigPtr,argbuf);return ASM_CONSTS[code].apply(null,args)}__ATINIT__.push({func:function(){___wasm_call_ctors()}});function ___assert_fail(condition,filename,line,func){abort(\"Assertion failed: \"+UTF8ToString(condition)+\", at: \"+[filename?UTF8ToString(filename):\"unknown filename\",line,func?UTF8ToString(func):\"unknown function\"])}function _abort(){abort()}function _emscripten_memcpy_big(dest,src,num){HEAPU8.copyWithin(dest,src,src+num)}function _emscripten_get_heap_size(){return HEAPU8.length}function emscripten_realloc_buffer(size){try{wasmMemory.grow(size-buffer.byteLength+65535>>>16);updateGlobalBufferAndViews(wasmMemory.buffer);return 1}catch(e){}}function _emscripten_resize_heap(requestedSize){requestedSize=requestedSize>>>0;var oldSize=_emscripten_get_heap_size();var PAGE_MULTIPLE=65536;var maxHeapSize=2147483648;if(requestedSize>maxHeapSize){return false}var minHeapSize=16777216;for(var cutDown=1;cutDown<=4;cutDown*=2){var overGrownHeapSize=oldSize*(1+.2/cutDown);overGrownHeapSize=Math.min(overGrownHeapSize,requestedSize+100663296);var newSize=Math.min(maxHeapSize,alignUp(Math.max(minHeapSize,requestedSize,overGrownHeapSize),PAGE_MULTIPLE));var replacement=emscripten_realloc_buffer(newSize);if(replacement){return true}}return false}var __readAsmConstArgsArray=[];function readAsmConstArgs(sigPtr,buf){__readAsmConstArgsArray.length=0;var ch;buf>>=2;while(ch=HEAPU8[sigPtr++]){__readAsmConstArgsArray.push(ch<105?HEAPF64[++buf>>1]:HEAP32[buf]);++buf}return __readAsmConstArgsArray}var ASSERTIONS=false;function intArrayToString(array){var ret=[];for(var i=0;i<array.length;i++){var chr=array[i];if(chr>255){if(ASSERTIONS){assert(false,\"Character code \"+chr+\" (\"+String.fromCharCode(chr)+\")  at offset \"+i+\" not in 0x00-0xFF.\")}chr&=255}ret.push(String.fromCharCode(chr))}return ret.join(\"\")}var decodeBase64=typeof atob===\"function\"?atob:function(input){var keyStr=\"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\";var output=\"\";var chr1,chr2,chr3;var enc1,enc2,enc3,enc4;var i=0;input=input.replace(/[^A-Za-z0-9\\+\\/\\=]/g,\"\");do{enc1=keyStr.indexOf(input.charAt(i++));enc2=keyStr.indexOf(input.charAt(i++));enc3=keyStr.indexOf(input.charAt(i++));enc4=keyStr.indexOf(input.charAt(i++));chr1=enc1<<2|enc2>>4;chr2=(enc2&15)<<4|enc3>>2;chr3=(enc3&3)<<6|enc4;output=output+String.fromCharCode(chr1);if(enc3!==64){output=output+String.fromCharCode(chr2)}if(enc4!==64){output=output+String.fromCharCode(chr3)}}while(i<input.length);return output};function intArrayFromBase64(s){if(typeof ENVIRONMENT_IS_NODE===\"boolean\"&&ENVIRONMENT_IS_NODE){var buf;try{buf=Buffer.from(s,\"base64\")}catch(_){buf=new Buffer(s,\"base64\")}return new Uint8Array(buf[\"buffer\"],buf[\"byteOffset\"],buf[\"byteLength\"])}try{var decoded=decodeBase64(s);var bytes=new Uint8Array(decoded.length);for(var i=0;i<decoded.length;++i){bytes[i]=decoded.charCodeAt(i)}return bytes}catch(_){throw new Error(\"Converting base64 string to bytes failed.\")}}function tryParseAsDataURI(filename){if(!isDataURI(filename)){return}return intArrayFromBase64(filename.slice(dataURIPrefix.length))}var asmLibraryArg={\"a\":___assert_fail,\"c\":_abort,\"b\":_emscripten_asm_const_iii,\"d\":_emscripten_memcpy_big,\"e\":_emscripten_resize_heap,\"memory\":wasmMemory,\"table\":wasmTable};var asm=createWasm();var ___wasm_call_ctors=Module[\"___wasm_call_ctors\"]=function(){return(___wasm_call_ctors=Module[\"___wasm_call_ctors\"]=Module[\"asm\"][\"f\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_encrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_encrypt_detached\"]=Module[\"asm\"][\"g\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_encrypt=Module[\"_crypto_aead_chacha20poly1305_encrypt\"]=function(){return(_crypto_aead_chacha20poly1305_encrypt=Module[\"_crypto_aead_chacha20poly1305_encrypt\"]=Module[\"asm\"][\"h\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt_detached\"]=Module[\"asm\"][\"i\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_encrypt\"]=Module[\"asm\"][\"j\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_decrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_decrypt_detached\"]=Module[\"asm\"][\"k\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_decrypt=Module[\"_crypto_aead_chacha20poly1305_decrypt\"]=function(){return(_crypto_aead_chacha20poly1305_decrypt=Module[\"_crypto_aead_chacha20poly1305_decrypt\"]=Module[\"asm\"][\"l\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt_detached\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt_detached\"]=Module[\"asm\"][\"m\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_chacha20poly1305_ietf_decrypt\"]=Module[\"asm\"][\"n\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_chacha20poly1305_ietf_keybytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_chacha20poly1305_ietf_keybytes\"]=Module[\"asm\"][\"o\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_npubbytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_npubbytes\"]=Module[\"asm\"][\"p\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_nsecbytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_ietf_nsecbytes\"]=Module[\"asm\"][\"q\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_abytes=Module[\"_crypto_aead_chacha20poly1305_ietf_abytes\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_abytes=Module[\"_crypto_aead_chacha20poly1305_ietf_abytes\"]=Module[\"asm\"][\"r\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_ietf_messagebytes_max\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_ietf_messagebytes_max\"]=Module[\"asm\"][\"s\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_ietf_keygen=Module[\"_crypto_aead_chacha20poly1305_ietf_keygen\"]=function(){return(_crypto_aead_chacha20poly1305_ietf_keygen=Module[\"_crypto_aead_chacha20poly1305_ietf_keygen\"]=Module[\"asm\"][\"t\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_keybytes=Module[\"_crypto_aead_chacha20poly1305_keybytes\"]=function(){return(_crypto_aead_chacha20poly1305_keybytes=Module[\"_crypto_aead_chacha20poly1305_keybytes\"]=Module[\"asm\"][\"u\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_npubbytes=Module[\"_crypto_aead_chacha20poly1305_npubbytes\"]=function(){return(_crypto_aead_chacha20poly1305_npubbytes=Module[\"_crypto_aead_chacha20poly1305_npubbytes\"]=Module[\"asm\"][\"v\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_nsecbytes\"]=function(){return(_crypto_aead_chacha20poly1305_nsecbytes=Module[\"_crypto_aead_chacha20poly1305_nsecbytes\"]=Module[\"asm\"][\"w\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_abytes=Module[\"_crypto_aead_chacha20poly1305_abytes\"]=function(){return(_crypto_aead_chacha20poly1305_abytes=Module[\"_crypto_aead_chacha20poly1305_abytes\"]=Module[\"asm\"][\"x\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_messagebytes_max\"]=function(){return(_crypto_aead_chacha20poly1305_messagebytes_max=Module[\"_crypto_aead_chacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"y\"]).apply(null,arguments)};var _crypto_aead_chacha20poly1305_keygen=Module[\"_crypto_aead_chacha20poly1305_keygen\"]=function(){return(_crypto_aead_chacha20poly1305_keygen=Module[\"_crypto_aead_chacha20poly1305_keygen\"]=Module[\"asm\"][\"z\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt_detached\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_encrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt_detached\"]=Module[\"asm\"][\"A\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_encrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_encrypt\"]=Module[\"asm\"][\"B\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt_detached\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_decrypt_detached=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt_detached\"]=Module[\"asm\"][\"C\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_decrypt=Module[\"_crypto_aead_xchacha20poly1305_ietf_decrypt\"]=Module[\"asm\"][\"D\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_keybytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_keybytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_keybytes\"]=Module[\"asm\"][\"E\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_npubbytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_npubbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_npubbytes\"]=Module[\"asm\"][\"F\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_nsecbytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_nsecbytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_nsecbytes\"]=Module[\"asm\"][\"G\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_abytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_abytes\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_abytes=Module[\"_crypto_aead_xchacha20poly1305_ietf_abytes\"]=Module[\"asm\"][\"H\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_xchacha20poly1305_ietf_messagebytes_max\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_messagebytes_max=Module[\"_crypto_aead_xchacha20poly1305_ietf_messagebytes_max\"]=Module[\"asm\"][\"I\"]).apply(null,arguments)};var _crypto_aead_xchacha20poly1305_ietf_keygen=Module[\"_crypto_aead_xchacha20poly1305_ietf_keygen\"]=function(){return(_crypto_aead_xchacha20poly1305_ietf_keygen=Module[\"_crypto_aead_xchacha20poly1305_ietf_keygen\"]=Module[\"asm\"][\"J\"]).apply(null,arguments)};var _crypto_auth_bytes=Module[\"_crypto_auth_bytes\"]=function(){return(_crypto_auth_bytes=Module[\"_crypto_auth_bytes\"]=Module[\"asm\"][\"K\"]).apply(null,arguments)};var _crypto_auth_keybytes=Module[\"_crypto_auth_keybytes\"]=function(){return(_crypto_auth_keybytes=Module[\"_crypto_auth_keybytes\"]=Module[\"asm\"][\"L\"]).apply(null,arguments)};var _crypto_auth_primitive=Module[\"_crypto_auth_primitive\"]=function(){return(_crypto_auth_primitive=Module[\"_crypto_auth_primitive\"]=Module[\"asm\"][\"M\"]).apply(null,arguments)};var _crypto_auth=Module[\"_crypto_auth\"]=function(){return(_crypto_auth=Module[\"_crypto_auth\"]=Module[\"asm\"][\"N\"]).apply(null,arguments)};var _crypto_auth_verify=Module[\"_crypto_auth_verify\"]=function(){return(_crypto_auth_verify=Module[\"_crypto_auth_verify\"]=Module[\"asm\"][\"O\"]).apply(null,arguments)};var _crypto_auth_keygen=Module[\"_crypto_auth_keygen\"]=function(){return(_crypto_auth_keygen=Module[\"_crypto_auth_keygen\"]=Module[\"asm\"][\"P\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_bytes=Module[\"_crypto_auth_hmacsha256_bytes\"]=function(){return(_crypto_auth_hmacsha256_bytes=Module[\"_crypto_auth_hmacsha256_bytes\"]=Module[\"asm\"][\"Q\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_keybytes=Module[\"_crypto_auth_hmacsha256_keybytes\"]=function(){return(_crypto_auth_hmacsha256_keybytes=Module[\"_crypto_auth_hmacsha256_keybytes\"]=Module[\"asm\"][\"R\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_statebytes=Module[\"_crypto_auth_hmacsha256_statebytes\"]=function(){return(_crypto_auth_hmacsha256_statebytes=Module[\"_crypto_auth_hmacsha256_statebytes\"]=Module[\"asm\"][\"S\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_keygen=Module[\"_crypto_auth_hmacsha256_keygen\"]=function(){return(_crypto_auth_hmacsha256_keygen=Module[\"_crypto_auth_hmacsha256_keygen\"]=Module[\"asm\"][\"T\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_init=Module[\"_crypto_auth_hmacsha256_init\"]=function(){return(_crypto_auth_hmacsha256_init=Module[\"_crypto_auth_hmacsha256_init\"]=Module[\"asm\"][\"U\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_update=Module[\"_crypto_auth_hmacsha256_update\"]=function(){return(_crypto_auth_hmacsha256_update=Module[\"_crypto_auth_hmacsha256_update\"]=Module[\"asm\"][\"V\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_final=Module[\"_crypto_auth_hmacsha256_final\"]=function(){return(_crypto_auth_hmacsha256_final=Module[\"_crypto_auth_hmacsha256_final\"]=Module[\"asm\"][\"W\"]).apply(null,arguments)};var _crypto_auth_hmacsha256=Module[\"_crypto_auth_hmacsha256\"]=function(){return(_crypto_auth_hmacsha256=Module[\"_crypto_auth_hmacsha256\"]=Module[\"asm\"][\"X\"]).apply(null,arguments)};var _crypto_auth_hmacsha256_verify=Module[\"_crypto_auth_hmacsha256_verify\"]=function(){return(_crypto_auth_hmacsha256_verify=Module[\"_crypto_auth_hmacsha256_verify\"]=Module[\"asm\"][\"Y\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_bytes=Module[\"_crypto_auth_hmacsha512_bytes\"]=function(){return(_crypto_auth_hmacsha512_bytes=Module[\"_crypto_auth_hmacsha512_bytes\"]=Module[\"asm\"][\"Z\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_keybytes=Module[\"_crypto_auth_hmacsha512_keybytes\"]=function(){return(_crypto_auth_hmacsha512_keybytes=Module[\"_crypto_auth_hmacsha512_keybytes\"]=Module[\"asm\"][\"_\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_statebytes=Module[\"_crypto_auth_hmacsha512_statebytes\"]=function(){return(_crypto_auth_hmacsha512_statebytes=Module[\"_crypto_auth_hmacsha512_statebytes\"]=Module[\"asm\"][\"$\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_keygen=Module[\"_crypto_auth_hmacsha512_keygen\"]=function(){return(_crypto_auth_hmacsha512_keygen=Module[\"_crypto_auth_hmacsha512_keygen\"]=Module[\"asm\"][\"aa\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_init=Module[\"_crypto_auth_hmacsha512_init\"]=function(){return(_crypto_auth_hmacsha512_init=Module[\"_crypto_auth_hmacsha512_init\"]=Module[\"asm\"][\"ba\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_update=Module[\"_crypto_auth_hmacsha512_update\"]=function(){return(_crypto_auth_hmacsha512_update=Module[\"_crypto_auth_hmacsha512_update\"]=Module[\"asm\"][\"ca\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_final=Module[\"_crypto_auth_hmacsha512_final\"]=function(){return(_crypto_auth_hmacsha512_final=Module[\"_crypto_auth_hmacsha512_final\"]=Module[\"asm\"][\"da\"]).apply(null,arguments)};var _crypto_auth_hmacsha512=Module[\"_crypto_auth_hmacsha512\"]=function(){return(_crypto_auth_hmacsha512=Module[\"_crypto_auth_hmacsha512\"]=Module[\"asm\"][\"ea\"]).apply(null,arguments)};var _crypto_auth_hmacsha512_verify=Module[\"_crypto_auth_hmacsha512_verify\"]=function(){return(_crypto_auth_hmacsha512_verify=Module[\"_crypto_auth_hmacsha512_verify\"]=Module[\"asm\"][\"fa\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_bytes=Module[\"_crypto_auth_hmacsha512256_bytes\"]=function(){return(_crypto_auth_hmacsha512256_bytes=Module[\"_crypto_auth_hmacsha512256_bytes\"]=Module[\"asm\"][\"ga\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_keybytes=Module[\"_crypto_auth_hmacsha512256_keybytes\"]=function(){return(_crypto_auth_hmacsha512256_keybytes=Module[\"_crypto_auth_hmacsha512256_keybytes\"]=Module[\"asm\"][\"ha\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_statebytes=Module[\"_crypto_auth_hmacsha512256_statebytes\"]=function(){return(_crypto_auth_hmacsha512256_statebytes=Module[\"_crypto_auth_hmacsha512256_statebytes\"]=Module[\"asm\"][\"ia\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_keygen=Module[\"_crypto_auth_hmacsha512256_keygen\"]=function(){return(_crypto_auth_hmacsha512256_keygen=Module[\"_crypto_auth_hmacsha512256_keygen\"]=Module[\"asm\"][\"ja\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_init=Module[\"_crypto_auth_hmacsha512256_init\"]=function(){return(_crypto_auth_hmacsha512256_init=Module[\"_crypto_auth_hmacsha512256_init\"]=Module[\"asm\"][\"ka\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_update=Module[\"_crypto_auth_hmacsha512256_update\"]=function(){return(_crypto_auth_hmacsha512256_update=Module[\"_crypto_auth_hmacsha512256_update\"]=Module[\"asm\"][\"la\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_final=Module[\"_crypto_auth_hmacsha512256_final\"]=function(){return(_crypto_auth_hmacsha512256_final=Module[\"_crypto_auth_hmacsha512256_final\"]=Module[\"asm\"][\"ma\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256=Module[\"_crypto_auth_hmacsha512256\"]=function(){return(_crypto_auth_hmacsha512256=Module[\"_crypto_auth_hmacsha512256\"]=Module[\"asm\"][\"na\"]).apply(null,arguments)};var _crypto_auth_hmacsha512256_verify=Module[\"_crypto_auth_hmacsha512256_verify\"]=function(){return(_crypto_auth_hmacsha512256_verify=Module[\"_crypto_auth_hmacsha512256_verify\"]=Module[\"asm\"][\"oa\"]).apply(null,arguments)};var _crypto_box_seedbytes=Module[\"_crypto_box_seedbytes\"]=function(){return(_crypto_box_seedbytes=Module[\"_crypto_box_seedbytes\"]=Module[\"asm\"][\"pa\"]).apply(null,arguments)};var _crypto_box_publickeybytes=Module[\"_crypto_box_publickeybytes\"]=function(){return(_crypto_box_publickeybytes=Module[\"_crypto_box_publickeybytes\"]=Module[\"asm\"][\"qa\"]).apply(null,arguments)};var _crypto_box_secretkeybytes=Module[\"_crypto_box_secretkeybytes\"]=function(){return(_crypto_box_secretkeybytes=Module[\"_crypto_box_secretkeybytes\"]=Module[\"asm\"][\"ra\"]).apply(null,arguments)};var _crypto_box_beforenmbytes=Module[\"_crypto_box_beforenmbytes\"]=function(){return(_crypto_box_beforenmbytes=Module[\"_crypto_box_beforenmbytes\"]=Module[\"asm\"][\"sa\"]).apply(null,arguments)};var _crypto_box_noncebytes=Module[\"_crypto_box_noncebytes\"]=function(){return(_crypto_box_noncebytes=Module[\"_crypto_box_noncebytes\"]=Module[\"asm\"][\"ta\"]).apply(null,arguments)};var _crypto_box_zerobytes=Module[\"_crypto_box_zerobytes\"]=function(){return(_crypto_box_zerobytes=Module[\"_crypto_box_zerobytes\"]=Module[\"asm\"][\"ua\"]).apply(null,arguments)};var _crypto_box_boxzerobytes=Module[\"_crypto_box_boxzerobytes\"]=function(){return(_crypto_box_boxzerobytes=Module[\"_crypto_box_boxzerobytes\"]=Module[\"asm\"][\"va\"]).apply(null,arguments)};var _crypto_box_macbytes=Module[\"_crypto_box_macbytes\"]=function(){return(_crypto_box_macbytes=Module[\"_crypto_box_macbytes\"]=Module[\"asm\"][\"wa\"]).apply(null,arguments)};var _crypto_box_messagebytes_max=Module[\"_crypto_box_messagebytes_max\"]=function(){return(_crypto_box_messagebytes_max=Module[\"_crypto_box_messagebytes_max\"]=Module[\"asm\"][\"xa\"]).apply(null,arguments)};var _crypto_box_primitive=Module[\"_crypto_box_primitive\"]=function(){return(_crypto_box_primitive=Module[\"_crypto_box_primitive\"]=Module[\"asm\"][\"ya\"]).apply(null,arguments)};var _crypto_box_seed_keypair=Module[\"_crypto_box_seed_keypair\"]=function(){return(_crypto_box_seed_keypair=Module[\"_crypto_box_seed_keypair\"]=Module[\"asm\"][\"za\"]).apply(null,arguments)};var _crypto_box_keypair=Module[\"_crypto_box_keypair\"]=function(){return(_crypto_box_keypair=Module[\"_crypto_box_keypair\"]=Module[\"asm\"][\"Aa\"]).apply(null,arguments)};var _crypto_box_beforenm=Module[\"_crypto_box_beforenm\"]=function(){return(_crypto_box_beforenm=Module[\"_crypto_box_beforenm\"]=Module[\"asm\"][\"Ba\"]).apply(null,arguments)};var _crypto_box_afternm=Module[\"_crypto_box_afternm\"]=function(){return(_crypto_box_afternm=Module[\"_crypto_box_afternm\"]=Module[\"asm\"][\"Ca\"]).apply(null,arguments)};var _crypto_box_open_afternm=Module[\"_crypto_box_open_afternm\"]=function(){return(_crypto_box_open_afternm=Module[\"_crypto_box_open_afternm\"]=Module[\"asm\"][\"Da\"]).apply(null,arguments)};var _crypto_box=Module[\"_crypto_box\"]=function(){return(_crypto_box=Module[\"_crypto_box\"]=Module[\"asm\"][\"Ea\"]).apply(null,arguments)};var _crypto_box_open=Module[\"_crypto_box_open\"]=function(){return(_crypto_box_open=Module[\"_crypto_box_open\"]=Module[\"asm\"][\"Fa\"]).apply(null,arguments)};var _crypto_box_detached_afternm=Module[\"_crypto_box_detached_afternm\"]=function(){return(_crypto_box_detached_afternm=Module[\"_crypto_box_detached_afternm\"]=Module[\"asm\"][\"Ga\"]).apply(null,arguments)};var _crypto_box_detached=Module[\"_crypto_box_detached\"]=function(){return(_crypto_box_detached=Module[\"_crypto_box_detached\"]=Module[\"asm\"][\"Ha\"]).apply(null,arguments)};var _crypto_box_easy_afternm=Module[\"_crypto_box_easy_afternm\"]=function(){return(_crypto_box_easy_afternm=Module[\"_crypto_box_easy_afternm\"]=Module[\"asm\"][\"Ia\"]).apply(null,arguments)};var _crypto_box_easy=Module[\"_crypto_box_easy\"]=function(){return(_crypto_box_easy=Module[\"_crypto_box_easy\"]=Module[\"asm\"][\"Ja\"]).apply(null,arguments)};var _crypto_box_open_detached_afternm=Module[\"_crypto_box_open_detached_afternm\"]=function(){return(_crypto_box_open_detached_afternm=Module[\"_crypto_box_open_detached_afternm\"]=Module[\"asm\"][\"Ka\"]).apply(null,arguments)};var _crypto_box_open_detached=Module[\"_crypto_box_open_detached\"]=function(){return(_crypto_box_open_detached=Module[\"_crypto_box_open_detached\"]=Module[\"asm\"][\"La\"]).apply(null,arguments)};var _crypto_box_open_easy_afternm=Module[\"_crypto_box_open_easy_afternm\"]=function(){return(_crypto_box_open_easy_afternm=Module[\"_crypto_box_open_easy_afternm\"]=Module[\"asm\"][\"Ma\"]).apply(null,arguments)};var _crypto_box_open_easy=Module[\"_crypto_box_open_easy\"]=function(){return(_crypto_box_open_easy=Module[\"_crypto_box_open_easy\"]=Module[\"asm\"][\"Na\"]).apply(null,arguments)};var _crypto_box_seal=Module[\"_crypto_box_seal\"]=function(){return(_crypto_box_seal=Module[\"_crypto_box_seal\"]=Module[\"asm\"][\"Oa\"]).apply(null,arguments)};var _crypto_box_seal_open=Module[\"_crypto_box_seal_open\"]=function(){return(_crypto_box_seal_open=Module[\"_crypto_box_seal_open\"]=Module[\"asm\"][\"Pa\"]).apply(null,arguments)};var _crypto_box_sealbytes=Module[\"_crypto_box_sealbytes\"]=function(){return(_crypto_box_sealbytes=Module[\"_crypto_box_sealbytes\"]=Module[\"asm\"][\"Qa\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_seed_keypair\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_seed_keypair\"]=Module[\"asm\"][\"Ra\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_keypair\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_keypair=Module[\"_crypto_box_curve25519xsalsa20poly1305_keypair\"]=Module[\"asm\"][\"Sa\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_beforenm=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenm\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_beforenm=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenm\"]=Module[\"asm\"][\"Ta\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_afternm\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_afternm\"]=Module[\"asm\"][\"Ua\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_open_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_open_afternm\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_open_afternm=Module[\"_crypto_box_curve25519xsalsa20poly1305_open_afternm\"]=Module[\"asm\"][\"Va\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305=Module[\"_crypto_box_curve25519xsalsa20poly1305\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305=Module[\"_crypto_box_curve25519xsalsa20poly1305\"]=Module[\"asm\"][\"Wa\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_open=Module[\"_crypto_box_curve25519xsalsa20poly1305_open\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_open=Module[\"_crypto_box_curve25519xsalsa20poly1305_open\"]=Module[\"asm\"][\"Xa\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_seedbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_seedbytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_seedbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_seedbytes\"]=Module[\"asm\"][\"Ya\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_publickeybytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_publickeybytes\"]=Module[\"asm\"][\"Za\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_secretkeybytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_secretkeybytes\"]=Module[\"asm\"][\"_a\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenmbytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_beforenmbytes\"]=Module[\"asm\"][\"$a\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_noncebytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_noncebytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_noncebytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_noncebytes\"]=Module[\"asm\"][\"ab\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_zerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_zerobytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_zerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_zerobytes\"]=Module[\"asm\"][\"bb\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_boxzerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_boxzerobytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_boxzerobytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_boxzerobytes\"]=Module[\"asm\"][\"cb\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_macbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_macbytes\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_macbytes=Module[\"_crypto_box_curve25519xsalsa20poly1305_macbytes\"]=Module[\"asm\"][\"db\"]).apply(null,arguments)};var _crypto_box_curve25519xsalsa20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xsalsa20poly1305_messagebytes_max\"]=function(){return(_crypto_box_curve25519xsalsa20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xsalsa20poly1305_messagebytes_max\"]=Module[\"asm\"][\"eb\"]).apply(null,arguments)};var _crypto_core_hchacha20=Module[\"_crypto_core_hchacha20\"]=function(){return(_crypto_core_hchacha20=Module[\"_crypto_core_hchacha20\"]=Module[\"asm\"][\"fb\"]).apply(null,arguments)};var _crypto_core_hchacha20_outputbytes=Module[\"_crypto_core_hchacha20_outputbytes\"]=function(){return(_crypto_core_hchacha20_outputbytes=Module[\"_crypto_core_hchacha20_outputbytes\"]=Module[\"asm\"][\"gb\"]).apply(null,arguments)};var _crypto_core_hchacha20_inputbytes=Module[\"_crypto_core_hchacha20_inputbytes\"]=function(){return(_crypto_core_hchacha20_inputbytes=Module[\"_crypto_core_hchacha20_inputbytes\"]=Module[\"asm\"][\"hb\"]).apply(null,arguments)};var _crypto_core_hchacha20_keybytes=Module[\"_crypto_core_hchacha20_keybytes\"]=function(){return(_crypto_core_hchacha20_keybytes=Module[\"_crypto_core_hchacha20_keybytes\"]=Module[\"asm\"][\"ib\"]).apply(null,arguments)};var _crypto_core_hchacha20_constbytes=Module[\"_crypto_core_hchacha20_constbytes\"]=function(){return(_crypto_core_hchacha20_constbytes=Module[\"_crypto_core_hchacha20_constbytes\"]=Module[\"asm\"][\"jb\"]).apply(null,arguments)};var _crypto_core_hsalsa20=Module[\"_crypto_core_hsalsa20\"]=function(){return(_crypto_core_hsalsa20=Module[\"_crypto_core_hsalsa20\"]=Module[\"asm\"][\"kb\"]).apply(null,arguments)};var _crypto_core_hsalsa20_outputbytes=Module[\"_crypto_core_hsalsa20_outputbytes\"]=function(){return(_crypto_core_hsalsa20_outputbytes=Module[\"_crypto_core_hsalsa20_outputbytes\"]=Module[\"asm\"][\"lb\"]).apply(null,arguments)};var _crypto_core_hsalsa20_inputbytes=Module[\"_crypto_core_hsalsa20_inputbytes\"]=function(){return(_crypto_core_hsalsa20_inputbytes=Module[\"_crypto_core_hsalsa20_inputbytes\"]=Module[\"asm\"][\"mb\"]).apply(null,arguments)};var _crypto_core_hsalsa20_keybytes=Module[\"_crypto_core_hsalsa20_keybytes\"]=function(){return(_crypto_core_hsalsa20_keybytes=Module[\"_crypto_core_hsalsa20_keybytes\"]=Module[\"asm\"][\"nb\"]).apply(null,arguments)};var _crypto_core_hsalsa20_constbytes=Module[\"_crypto_core_hsalsa20_constbytes\"]=function(){return(_crypto_core_hsalsa20_constbytes=Module[\"_crypto_core_hsalsa20_constbytes\"]=Module[\"asm\"][\"ob\"]).apply(null,arguments)};var _crypto_core_salsa20=Module[\"_crypto_core_salsa20\"]=function(){return(_crypto_core_salsa20=Module[\"_crypto_core_salsa20\"]=Module[\"asm\"][\"pb\"]).apply(null,arguments)};var _crypto_core_salsa20_outputbytes=Module[\"_crypto_core_salsa20_outputbytes\"]=function(){return(_crypto_core_salsa20_outputbytes=Module[\"_crypto_core_salsa20_outputbytes\"]=Module[\"asm\"][\"qb\"]).apply(null,arguments)};var _crypto_core_salsa20_inputbytes=Module[\"_crypto_core_salsa20_inputbytes\"]=function(){return(_crypto_core_salsa20_inputbytes=Module[\"_crypto_core_salsa20_inputbytes\"]=Module[\"asm\"][\"rb\"]).apply(null,arguments)};var _crypto_core_salsa20_keybytes=Module[\"_crypto_core_salsa20_keybytes\"]=function(){return(_crypto_core_salsa20_keybytes=Module[\"_crypto_core_salsa20_keybytes\"]=Module[\"asm\"][\"sb\"]).apply(null,arguments)};var _crypto_core_salsa20_constbytes=Module[\"_crypto_core_salsa20_constbytes\"]=function(){return(_crypto_core_salsa20_constbytes=Module[\"_crypto_core_salsa20_constbytes\"]=Module[\"asm\"][\"tb\"]).apply(null,arguments)};var _crypto_core_salsa2012=Module[\"_crypto_core_salsa2012\"]=function(){return(_crypto_core_salsa2012=Module[\"_crypto_core_salsa2012\"]=Module[\"asm\"][\"ub\"]).apply(null,arguments)};var _crypto_core_salsa2012_outputbytes=Module[\"_crypto_core_salsa2012_outputbytes\"]=function(){return(_crypto_core_salsa2012_outputbytes=Module[\"_crypto_core_salsa2012_outputbytes\"]=Module[\"asm\"][\"vb\"]).apply(null,arguments)};var _crypto_core_salsa2012_inputbytes=Module[\"_crypto_core_salsa2012_inputbytes\"]=function(){return(_crypto_core_salsa2012_inputbytes=Module[\"_crypto_core_salsa2012_inputbytes\"]=Module[\"asm\"][\"wb\"]).apply(null,arguments)};var _crypto_core_salsa2012_keybytes=Module[\"_crypto_core_salsa2012_keybytes\"]=function(){return(_crypto_core_salsa2012_keybytes=Module[\"_crypto_core_salsa2012_keybytes\"]=Module[\"asm\"][\"xb\"]).apply(null,arguments)};var _crypto_core_salsa2012_constbytes=Module[\"_crypto_core_salsa2012_constbytes\"]=function(){return(_crypto_core_salsa2012_constbytes=Module[\"_crypto_core_salsa2012_constbytes\"]=Module[\"asm\"][\"yb\"]).apply(null,arguments)};var _crypto_core_salsa208=Module[\"_crypto_core_salsa208\"]=function(){return(_crypto_core_salsa208=Module[\"_crypto_core_salsa208\"]=Module[\"asm\"][\"zb\"]).apply(null,arguments)};var _crypto_core_salsa208_outputbytes=Module[\"_crypto_core_salsa208_outputbytes\"]=function(){return(_crypto_core_salsa208_outputbytes=Module[\"_crypto_core_salsa208_outputbytes\"]=Module[\"asm\"][\"Ab\"]).apply(null,arguments)};var _crypto_core_salsa208_inputbytes=Module[\"_crypto_core_salsa208_inputbytes\"]=function(){return(_crypto_core_salsa208_inputbytes=Module[\"_crypto_core_salsa208_inputbytes\"]=Module[\"asm\"][\"Bb\"]).apply(null,arguments)};var _crypto_core_salsa208_keybytes=Module[\"_crypto_core_salsa208_keybytes\"]=function(){return(_crypto_core_salsa208_keybytes=Module[\"_crypto_core_salsa208_keybytes\"]=Module[\"asm\"][\"Cb\"]).apply(null,arguments)};var _crypto_core_salsa208_constbytes=Module[\"_crypto_core_salsa208_constbytes\"]=function(){return(_crypto_core_salsa208_constbytes=Module[\"_crypto_core_salsa208_constbytes\"]=Module[\"asm\"][\"Db\"]).apply(null,arguments)};var _crypto_generichash_bytes_min=Module[\"_crypto_generichash_bytes_min\"]=function(){return(_crypto_generichash_bytes_min=Module[\"_crypto_generichash_bytes_min\"]=Module[\"asm\"][\"Eb\"]).apply(null,arguments)};var _crypto_generichash_bytes_max=Module[\"_crypto_generichash_bytes_max\"]=function(){return(_crypto_generichash_bytes_max=Module[\"_crypto_generichash_bytes_max\"]=Module[\"asm\"][\"Fb\"]).apply(null,arguments)};var _crypto_generichash_bytes=Module[\"_crypto_generichash_bytes\"]=function(){return(_crypto_generichash_bytes=Module[\"_crypto_generichash_bytes\"]=Module[\"asm\"][\"Gb\"]).apply(null,arguments)};var _crypto_generichash_keybytes_min=Module[\"_crypto_generichash_keybytes_min\"]=function(){return(_crypto_generichash_keybytes_min=Module[\"_crypto_generichash_keybytes_min\"]=Module[\"asm\"][\"Hb\"]).apply(null,arguments)};var _crypto_generichash_keybytes_max=Module[\"_crypto_generichash_keybytes_max\"]=function(){return(_crypto_generichash_keybytes_max=Module[\"_crypto_generichash_keybytes_max\"]=Module[\"asm\"][\"Ib\"]).apply(null,arguments)};var _crypto_generichash_keybytes=Module[\"_crypto_generichash_keybytes\"]=function(){return(_crypto_generichash_keybytes=Module[\"_crypto_generichash_keybytes\"]=Module[\"asm\"][\"Jb\"]).apply(null,arguments)};var _crypto_generichash_primitive=Module[\"_crypto_generichash_primitive\"]=function(){return(_crypto_generichash_primitive=Module[\"_crypto_generichash_primitive\"]=Module[\"asm\"][\"Kb\"]).apply(null,arguments)};var _crypto_generichash_statebytes=Module[\"_crypto_generichash_statebytes\"]=function(){return(_crypto_generichash_statebytes=Module[\"_crypto_generichash_statebytes\"]=Module[\"asm\"][\"Lb\"]).apply(null,arguments)};var _crypto_generichash=Module[\"_crypto_generichash\"]=function(){return(_crypto_generichash=Module[\"_crypto_generichash\"]=Module[\"asm\"][\"Mb\"]).apply(null,arguments)};var _crypto_generichash_init=Module[\"_crypto_generichash_init\"]=function(){return(_crypto_generichash_init=Module[\"_crypto_generichash_init\"]=Module[\"asm\"][\"Nb\"]).apply(null,arguments)};var _crypto_generichash_update=Module[\"_crypto_generichash_update\"]=function(){return(_crypto_generichash_update=Module[\"_crypto_generichash_update\"]=Module[\"asm\"][\"Ob\"]).apply(null,arguments)};var _crypto_generichash_final=Module[\"_crypto_generichash_final\"]=function(){return(_crypto_generichash_final=Module[\"_crypto_generichash_final\"]=Module[\"asm\"][\"Pb\"]).apply(null,arguments)};var _crypto_generichash_keygen=Module[\"_crypto_generichash_keygen\"]=function(){return(_crypto_generichash_keygen=Module[\"_crypto_generichash_keygen\"]=Module[\"asm\"][\"Qb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_bytes_min=Module[\"_crypto_generichash_blake2b_bytes_min\"]=function(){return(_crypto_generichash_blake2b_bytes_min=Module[\"_crypto_generichash_blake2b_bytes_min\"]=Module[\"asm\"][\"Rb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_bytes_max=Module[\"_crypto_generichash_blake2b_bytes_max\"]=function(){return(_crypto_generichash_blake2b_bytes_max=Module[\"_crypto_generichash_blake2b_bytes_max\"]=Module[\"asm\"][\"Sb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_bytes=Module[\"_crypto_generichash_blake2b_bytes\"]=function(){return(_crypto_generichash_blake2b_bytes=Module[\"_crypto_generichash_blake2b_bytes\"]=Module[\"asm\"][\"Tb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keybytes_min=Module[\"_crypto_generichash_blake2b_keybytes_min\"]=function(){return(_crypto_generichash_blake2b_keybytes_min=Module[\"_crypto_generichash_blake2b_keybytes_min\"]=Module[\"asm\"][\"Ub\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keybytes_max=Module[\"_crypto_generichash_blake2b_keybytes_max\"]=function(){return(_crypto_generichash_blake2b_keybytes_max=Module[\"_crypto_generichash_blake2b_keybytes_max\"]=Module[\"asm\"][\"Vb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keybytes=Module[\"_crypto_generichash_blake2b_keybytes\"]=function(){return(_crypto_generichash_blake2b_keybytes=Module[\"_crypto_generichash_blake2b_keybytes\"]=Module[\"asm\"][\"Wb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_saltbytes=Module[\"_crypto_generichash_blake2b_saltbytes\"]=function(){return(_crypto_generichash_blake2b_saltbytes=Module[\"_crypto_generichash_blake2b_saltbytes\"]=Module[\"asm\"][\"Xb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_personalbytes=Module[\"_crypto_generichash_blake2b_personalbytes\"]=function(){return(_crypto_generichash_blake2b_personalbytes=Module[\"_crypto_generichash_blake2b_personalbytes\"]=Module[\"asm\"][\"Yb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_statebytes=Module[\"_crypto_generichash_blake2b_statebytes\"]=function(){return(_crypto_generichash_blake2b_statebytes=Module[\"_crypto_generichash_blake2b_statebytes\"]=Module[\"asm\"][\"Zb\"]).apply(null,arguments)};var _crypto_generichash_blake2b_keygen=Module[\"_crypto_generichash_blake2b_keygen\"]=function(){return(_crypto_generichash_blake2b_keygen=Module[\"_crypto_generichash_blake2b_keygen\"]=Module[\"asm\"][\"_b\"]).apply(null,arguments)};var _crypto_generichash_blake2b=Module[\"_crypto_generichash_blake2b\"]=function(){return(_crypto_generichash_blake2b=Module[\"_crypto_generichash_blake2b\"]=Module[\"asm\"][\"$b\"]).apply(null,arguments)};var _crypto_generichash_blake2b_salt_personal=Module[\"_crypto_generichash_blake2b_salt_personal\"]=function(){return(_crypto_generichash_blake2b_salt_personal=Module[\"_crypto_generichash_blake2b_salt_personal\"]=Module[\"asm\"][\"ac\"]).apply(null,arguments)};var _crypto_generichash_blake2b_init=Module[\"_crypto_generichash_blake2b_init\"]=function(){return(_crypto_generichash_blake2b_init=Module[\"_crypto_generichash_blake2b_init\"]=Module[\"asm\"][\"bc\"]).apply(null,arguments)};var _crypto_generichash_blake2b_init_salt_personal=Module[\"_crypto_generichash_blake2b_init_salt_personal\"]=function(){return(_crypto_generichash_blake2b_init_salt_personal=Module[\"_crypto_generichash_blake2b_init_salt_personal\"]=Module[\"asm\"][\"cc\"]).apply(null,arguments)};var _crypto_generichash_blake2b_update=Module[\"_crypto_generichash_blake2b_update\"]=function(){return(_crypto_generichash_blake2b_update=Module[\"_crypto_generichash_blake2b_update\"]=Module[\"asm\"][\"dc\"]).apply(null,arguments)};var _crypto_generichash_blake2b_final=Module[\"_crypto_generichash_blake2b_final\"]=function(){return(_crypto_generichash_blake2b_final=Module[\"_crypto_generichash_blake2b_final\"]=Module[\"asm\"][\"ec\"]).apply(null,arguments)};var _crypto_hash_bytes=Module[\"_crypto_hash_bytes\"]=function(){return(_crypto_hash_bytes=Module[\"_crypto_hash_bytes\"]=Module[\"asm\"][\"fc\"]).apply(null,arguments)};var _crypto_hash=Module[\"_crypto_hash\"]=function(){return(_crypto_hash=Module[\"_crypto_hash\"]=Module[\"asm\"][\"gc\"]).apply(null,arguments)};var _crypto_hash_primitive=Module[\"_crypto_hash_primitive\"]=function(){return(_crypto_hash_primitive=Module[\"_crypto_hash_primitive\"]=Module[\"asm\"][\"hc\"]).apply(null,arguments)};var _crypto_hash_sha256_bytes=Module[\"_crypto_hash_sha256_bytes\"]=function(){return(_crypto_hash_sha256_bytes=Module[\"_crypto_hash_sha256_bytes\"]=Module[\"asm\"][\"ic\"]).apply(null,arguments)};var _crypto_hash_sha256_statebytes=Module[\"_crypto_hash_sha256_statebytes\"]=function(){return(_crypto_hash_sha256_statebytes=Module[\"_crypto_hash_sha256_statebytes\"]=Module[\"asm\"][\"jc\"]).apply(null,arguments)};var _crypto_hash_sha256_init=Module[\"_crypto_hash_sha256_init\"]=function(){return(_crypto_hash_sha256_init=Module[\"_crypto_hash_sha256_init\"]=Module[\"asm\"][\"kc\"]).apply(null,arguments)};var _crypto_hash_sha256_update=Module[\"_crypto_hash_sha256_update\"]=function(){return(_crypto_hash_sha256_update=Module[\"_crypto_hash_sha256_update\"]=Module[\"asm\"][\"lc\"]).apply(null,arguments)};var _crypto_hash_sha256_final=Module[\"_crypto_hash_sha256_final\"]=function(){return(_crypto_hash_sha256_final=Module[\"_crypto_hash_sha256_final\"]=Module[\"asm\"][\"mc\"]).apply(null,arguments)};var _crypto_hash_sha256=Module[\"_crypto_hash_sha256\"]=function(){return(_crypto_hash_sha256=Module[\"_crypto_hash_sha256\"]=Module[\"asm\"][\"nc\"]).apply(null,arguments)};var _crypto_hash_sha512_bytes=Module[\"_crypto_hash_sha512_bytes\"]=function(){return(_crypto_hash_sha512_bytes=Module[\"_crypto_hash_sha512_bytes\"]=Module[\"asm\"][\"oc\"]).apply(null,arguments)};var _crypto_hash_sha512_statebytes=Module[\"_crypto_hash_sha512_statebytes\"]=function(){return(_crypto_hash_sha512_statebytes=Module[\"_crypto_hash_sha512_statebytes\"]=Module[\"asm\"][\"pc\"]).apply(null,arguments)};var _crypto_hash_sha512_init=Module[\"_crypto_hash_sha512_init\"]=function(){return(_crypto_hash_sha512_init=Module[\"_crypto_hash_sha512_init\"]=Module[\"asm\"][\"qc\"]).apply(null,arguments)};var _crypto_hash_sha512_update=Module[\"_crypto_hash_sha512_update\"]=function(){return(_crypto_hash_sha512_update=Module[\"_crypto_hash_sha512_update\"]=Module[\"asm\"][\"rc\"]).apply(null,arguments)};var _crypto_hash_sha512_final=Module[\"_crypto_hash_sha512_final\"]=function(){return(_crypto_hash_sha512_final=Module[\"_crypto_hash_sha512_final\"]=Module[\"asm\"][\"sc\"]).apply(null,arguments)};var _crypto_hash_sha512=Module[\"_crypto_hash_sha512\"]=function(){return(_crypto_hash_sha512=Module[\"_crypto_hash_sha512\"]=Module[\"asm\"][\"tc\"]).apply(null,arguments)};var _crypto_kdf_blake2b_bytes_min=Module[\"_crypto_kdf_blake2b_bytes_min\"]=function(){return(_crypto_kdf_blake2b_bytes_min=Module[\"_crypto_kdf_blake2b_bytes_min\"]=Module[\"asm\"][\"uc\"]).apply(null,arguments)};var _crypto_kdf_blake2b_bytes_max=Module[\"_crypto_kdf_blake2b_bytes_max\"]=function(){return(_crypto_kdf_blake2b_bytes_max=Module[\"_crypto_kdf_blake2b_bytes_max\"]=Module[\"asm\"][\"vc\"]).apply(null,arguments)};var _crypto_kdf_blake2b_contextbytes=Module[\"_crypto_kdf_blake2b_contextbytes\"]=function(){return(_crypto_kdf_blake2b_contextbytes=Module[\"_crypto_kdf_blake2b_contextbytes\"]=Module[\"asm\"][\"wc\"]).apply(null,arguments)};var _crypto_kdf_blake2b_keybytes=Module[\"_crypto_kdf_blake2b_keybytes\"]=function(){return(_crypto_kdf_blake2b_keybytes=Module[\"_crypto_kdf_blake2b_keybytes\"]=Module[\"asm\"][\"xc\"]).apply(null,arguments)};var _crypto_kdf_blake2b_derive_from_key=Module[\"_crypto_kdf_blake2b_derive_from_key\"]=function(){return(_crypto_kdf_blake2b_derive_from_key=Module[\"_crypto_kdf_blake2b_derive_from_key\"]=Module[\"asm\"][\"yc\"]).apply(null,arguments)};var _crypto_kdf_primitive=Module[\"_crypto_kdf_primitive\"]=function(){return(_crypto_kdf_primitive=Module[\"_crypto_kdf_primitive\"]=Module[\"asm\"][\"zc\"]).apply(null,arguments)};var _crypto_kdf_bytes_min=Module[\"_crypto_kdf_bytes_min\"]=function(){return(_crypto_kdf_bytes_min=Module[\"_crypto_kdf_bytes_min\"]=Module[\"asm\"][\"Ac\"]).apply(null,arguments)};var _crypto_kdf_bytes_max=Module[\"_crypto_kdf_bytes_max\"]=function(){return(_crypto_kdf_bytes_max=Module[\"_crypto_kdf_bytes_max\"]=Module[\"asm\"][\"Bc\"]).apply(null,arguments)};var _crypto_kdf_contextbytes=Module[\"_crypto_kdf_contextbytes\"]=function(){return(_crypto_kdf_contextbytes=Module[\"_crypto_kdf_contextbytes\"]=Module[\"asm\"][\"Cc\"]).apply(null,arguments)};var _crypto_kdf_keybytes=Module[\"_crypto_kdf_keybytes\"]=function(){return(_crypto_kdf_keybytes=Module[\"_crypto_kdf_keybytes\"]=Module[\"asm\"][\"Dc\"]).apply(null,arguments)};var _crypto_kdf_derive_from_key=Module[\"_crypto_kdf_derive_from_key\"]=function(){return(_crypto_kdf_derive_from_key=Module[\"_crypto_kdf_derive_from_key\"]=Module[\"asm\"][\"Ec\"]).apply(null,arguments)};var _crypto_kdf_keygen=Module[\"_crypto_kdf_keygen\"]=function(){return(_crypto_kdf_keygen=Module[\"_crypto_kdf_keygen\"]=Module[\"asm\"][\"Fc\"]).apply(null,arguments)};var _crypto_kx_seed_keypair=Module[\"_crypto_kx_seed_keypair\"]=function(){return(_crypto_kx_seed_keypair=Module[\"_crypto_kx_seed_keypair\"]=Module[\"asm\"][\"Gc\"]).apply(null,arguments)};var _crypto_kx_keypair=Module[\"_crypto_kx_keypair\"]=function(){return(_crypto_kx_keypair=Module[\"_crypto_kx_keypair\"]=Module[\"asm\"][\"Hc\"]).apply(null,arguments)};var _crypto_kx_client_session_keys=Module[\"_crypto_kx_client_session_keys\"]=function(){return(_crypto_kx_client_session_keys=Module[\"_crypto_kx_client_session_keys\"]=Module[\"asm\"][\"Ic\"]).apply(null,arguments)};var _crypto_kx_server_session_keys=Module[\"_crypto_kx_server_session_keys\"]=function(){return(_crypto_kx_server_session_keys=Module[\"_crypto_kx_server_session_keys\"]=Module[\"asm\"][\"Jc\"]).apply(null,arguments)};var _crypto_kx_publickeybytes=Module[\"_crypto_kx_publickeybytes\"]=function(){return(_crypto_kx_publickeybytes=Module[\"_crypto_kx_publickeybytes\"]=Module[\"asm\"][\"Kc\"]).apply(null,arguments)};var _crypto_kx_secretkeybytes=Module[\"_crypto_kx_secretkeybytes\"]=function(){return(_crypto_kx_secretkeybytes=Module[\"_crypto_kx_secretkeybytes\"]=Module[\"asm\"][\"Lc\"]).apply(null,arguments)};var _crypto_kx_seedbytes=Module[\"_crypto_kx_seedbytes\"]=function(){return(_crypto_kx_seedbytes=Module[\"_crypto_kx_seedbytes\"]=Module[\"asm\"][\"Mc\"]).apply(null,arguments)};var _crypto_kx_sessionkeybytes=Module[\"_crypto_kx_sessionkeybytes\"]=function(){return(_crypto_kx_sessionkeybytes=Module[\"_crypto_kx_sessionkeybytes\"]=Module[\"asm\"][\"Nc\"]).apply(null,arguments)};var _crypto_kx_primitive=Module[\"_crypto_kx_primitive\"]=function(){return(_crypto_kx_primitive=Module[\"_crypto_kx_primitive\"]=Module[\"asm\"][\"Oc\"]).apply(null,arguments)};var _crypto_onetimeauth_statebytes=Module[\"_crypto_onetimeauth_statebytes\"]=function(){return(_crypto_onetimeauth_statebytes=Module[\"_crypto_onetimeauth_statebytes\"]=Module[\"asm\"][\"Pc\"]).apply(null,arguments)};var _crypto_onetimeauth_bytes=Module[\"_crypto_onetimeauth_bytes\"]=function(){return(_crypto_onetimeauth_bytes=Module[\"_crypto_onetimeauth_bytes\"]=Module[\"asm\"][\"Qc\"]).apply(null,arguments)};var _crypto_onetimeauth_keybytes=Module[\"_crypto_onetimeauth_keybytes\"]=function(){return(_crypto_onetimeauth_keybytes=Module[\"_crypto_onetimeauth_keybytes\"]=Module[\"asm\"][\"Rc\"]).apply(null,arguments)};var _crypto_onetimeauth=Module[\"_crypto_onetimeauth\"]=function(){return(_crypto_onetimeauth=Module[\"_crypto_onetimeauth\"]=Module[\"asm\"][\"Sc\"]).apply(null,arguments)};var _crypto_onetimeauth_verify=Module[\"_crypto_onetimeauth_verify\"]=function(){return(_crypto_onetimeauth_verify=Module[\"_crypto_onetimeauth_verify\"]=Module[\"asm\"][\"Tc\"]).apply(null,arguments)};var _crypto_onetimeauth_init=Module[\"_crypto_onetimeauth_init\"]=function(){return(_crypto_onetimeauth_init=Module[\"_crypto_onetimeauth_init\"]=Module[\"asm\"][\"Uc\"]).apply(null,arguments)};var _crypto_onetimeauth_update=Module[\"_crypto_onetimeauth_update\"]=function(){return(_crypto_onetimeauth_update=Module[\"_crypto_onetimeauth_update\"]=Module[\"asm\"][\"Vc\"]).apply(null,arguments)};var _crypto_onetimeauth_final=Module[\"_crypto_onetimeauth_final\"]=function(){return(_crypto_onetimeauth_final=Module[\"_crypto_onetimeauth_final\"]=Module[\"asm\"][\"Wc\"]).apply(null,arguments)};var _crypto_onetimeauth_primitive=Module[\"_crypto_onetimeauth_primitive\"]=function(){return(_crypto_onetimeauth_primitive=Module[\"_crypto_onetimeauth_primitive\"]=Module[\"asm\"][\"Xc\"]).apply(null,arguments)};var _crypto_onetimeauth_keygen=Module[\"_crypto_onetimeauth_keygen\"]=function(){return(_crypto_onetimeauth_keygen=Module[\"_crypto_onetimeauth_keygen\"]=Module[\"asm\"][\"Yc\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305=Module[\"_crypto_onetimeauth_poly1305\"]=function(){return(_crypto_onetimeauth_poly1305=Module[\"_crypto_onetimeauth_poly1305\"]=Module[\"asm\"][\"Zc\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_verify=Module[\"_crypto_onetimeauth_poly1305_verify\"]=function(){return(_crypto_onetimeauth_poly1305_verify=Module[\"_crypto_onetimeauth_poly1305_verify\"]=Module[\"asm\"][\"_c\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_init=Module[\"_crypto_onetimeauth_poly1305_init\"]=function(){return(_crypto_onetimeauth_poly1305_init=Module[\"_crypto_onetimeauth_poly1305_init\"]=Module[\"asm\"][\"$c\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_update=Module[\"_crypto_onetimeauth_poly1305_update\"]=function(){return(_crypto_onetimeauth_poly1305_update=Module[\"_crypto_onetimeauth_poly1305_update\"]=Module[\"asm\"][\"ad\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_final=Module[\"_crypto_onetimeauth_poly1305_final\"]=function(){return(_crypto_onetimeauth_poly1305_final=Module[\"_crypto_onetimeauth_poly1305_final\"]=Module[\"asm\"][\"bd\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_bytes=Module[\"_crypto_onetimeauth_poly1305_bytes\"]=function(){return(_crypto_onetimeauth_poly1305_bytes=Module[\"_crypto_onetimeauth_poly1305_bytes\"]=Module[\"asm\"][\"cd\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_keybytes=Module[\"_crypto_onetimeauth_poly1305_keybytes\"]=function(){return(_crypto_onetimeauth_poly1305_keybytes=Module[\"_crypto_onetimeauth_poly1305_keybytes\"]=Module[\"asm\"][\"dd\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_statebytes=Module[\"_crypto_onetimeauth_poly1305_statebytes\"]=function(){return(_crypto_onetimeauth_poly1305_statebytes=Module[\"_crypto_onetimeauth_poly1305_statebytes\"]=Module[\"asm\"][\"ed\"]).apply(null,arguments)};var _crypto_onetimeauth_poly1305_keygen=Module[\"_crypto_onetimeauth_poly1305_keygen\"]=function(){return(_crypto_onetimeauth_poly1305_keygen=Module[\"_crypto_onetimeauth_poly1305_keygen\"]=Module[\"asm\"][\"fd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_alg_argon2i13=Module[\"_crypto_pwhash_argon2i_alg_argon2i13\"]=function(){return(_crypto_pwhash_argon2i_alg_argon2i13=Module[\"_crypto_pwhash_argon2i_alg_argon2i13\"]=Module[\"asm\"][\"gd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_bytes_min=Module[\"_crypto_pwhash_argon2i_bytes_min\"]=function(){return(_crypto_pwhash_argon2i_bytes_min=Module[\"_crypto_pwhash_argon2i_bytes_min\"]=Module[\"asm\"][\"hd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_bytes_max=Module[\"_crypto_pwhash_argon2i_bytes_max\"]=function(){return(_crypto_pwhash_argon2i_bytes_max=Module[\"_crypto_pwhash_argon2i_bytes_max\"]=Module[\"asm\"][\"id\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_passwd_min=Module[\"_crypto_pwhash_argon2i_passwd_min\"]=function(){return(_crypto_pwhash_argon2i_passwd_min=Module[\"_crypto_pwhash_argon2i_passwd_min\"]=Module[\"asm\"][\"jd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_passwd_max=Module[\"_crypto_pwhash_argon2i_passwd_max\"]=function(){return(_crypto_pwhash_argon2i_passwd_max=Module[\"_crypto_pwhash_argon2i_passwd_max\"]=Module[\"asm\"][\"kd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_saltbytes=Module[\"_crypto_pwhash_argon2i_saltbytes\"]=function(){return(_crypto_pwhash_argon2i_saltbytes=Module[\"_crypto_pwhash_argon2i_saltbytes\"]=Module[\"asm\"][\"ld\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_strbytes=Module[\"_crypto_pwhash_argon2i_strbytes\"]=function(){return(_crypto_pwhash_argon2i_strbytes=Module[\"_crypto_pwhash_argon2i_strbytes\"]=Module[\"asm\"][\"md\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_strprefix=Module[\"_crypto_pwhash_argon2i_strprefix\"]=function(){return(_crypto_pwhash_argon2i_strprefix=Module[\"_crypto_pwhash_argon2i_strprefix\"]=Module[\"asm\"][\"nd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_min=Module[\"_crypto_pwhash_argon2i_opslimit_min\"]=function(){return(_crypto_pwhash_argon2i_opslimit_min=Module[\"_crypto_pwhash_argon2i_opslimit_min\"]=Module[\"asm\"][\"od\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_max=Module[\"_crypto_pwhash_argon2i_opslimit_max\"]=function(){return(_crypto_pwhash_argon2i_opslimit_max=Module[\"_crypto_pwhash_argon2i_opslimit_max\"]=Module[\"asm\"][\"pd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_min=Module[\"_crypto_pwhash_argon2i_memlimit_min\"]=function(){return(_crypto_pwhash_argon2i_memlimit_min=Module[\"_crypto_pwhash_argon2i_memlimit_min\"]=Module[\"asm\"][\"qd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_max=Module[\"_crypto_pwhash_argon2i_memlimit_max\"]=function(){return(_crypto_pwhash_argon2i_memlimit_max=Module[\"_crypto_pwhash_argon2i_memlimit_max\"]=Module[\"asm\"][\"rd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_interactive=Module[\"_crypto_pwhash_argon2i_opslimit_interactive\"]=function(){return(_crypto_pwhash_argon2i_opslimit_interactive=Module[\"_crypto_pwhash_argon2i_opslimit_interactive\"]=Module[\"asm\"][\"sd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_interactive=Module[\"_crypto_pwhash_argon2i_memlimit_interactive\"]=function(){return(_crypto_pwhash_argon2i_memlimit_interactive=Module[\"_crypto_pwhash_argon2i_memlimit_interactive\"]=Module[\"asm\"][\"td\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_moderate=Module[\"_crypto_pwhash_argon2i_opslimit_moderate\"]=function(){return(_crypto_pwhash_argon2i_opslimit_moderate=Module[\"_crypto_pwhash_argon2i_opslimit_moderate\"]=Module[\"asm\"][\"ud\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_moderate=Module[\"_crypto_pwhash_argon2i_memlimit_moderate\"]=function(){return(_crypto_pwhash_argon2i_memlimit_moderate=Module[\"_crypto_pwhash_argon2i_memlimit_moderate\"]=Module[\"asm\"][\"vd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_opslimit_sensitive=Module[\"_crypto_pwhash_argon2i_opslimit_sensitive\"]=function(){return(_crypto_pwhash_argon2i_opslimit_sensitive=Module[\"_crypto_pwhash_argon2i_opslimit_sensitive\"]=Module[\"asm\"][\"wd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_memlimit_sensitive=Module[\"_crypto_pwhash_argon2i_memlimit_sensitive\"]=function(){return(_crypto_pwhash_argon2i_memlimit_sensitive=Module[\"_crypto_pwhash_argon2i_memlimit_sensitive\"]=Module[\"asm\"][\"xd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i=Module[\"_crypto_pwhash_argon2i\"]=function(){return(_crypto_pwhash_argon2i=Module[\"_crypto_pwhash_argon2i\"]=Module[\"asm\"][\"yd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_str=Module[\"_crypto_pwhash_argon2i_str\"]=function(){return(_crypto_pwhash_argon2i_str=Module[\"_crypto_pwhash_argon2i_str\"]=Module[\"asm\"][\"zd\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_str_verify=Module[\"_crypto_pwhash_argon2i_str_verify\"]=function(){return(_crypto_pwhash_argon2i_str_verify=Module[\"_crypto_pwhash_argon2i_str_verify\"]=Module[\"asm\"][\"Ad\"]).apply(null,arguments)};var _crypto_pwhash_argon2i_str_needs_rehash=Module[\"_crypto_pwhash_argon2i_str_needs_rehash\"]=function(){return(_crypto_pwhash_argon2i_str_needs_rehash=Module[\"_crypto_pwhash_argon2i_str_needs_rehash\"]=Module[\"asm\"][\"Bd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_str_needs_rehash=Module[\"_crypto_pwhash_argon2id_str_needs_rehash\"]=function(){return(_crypto_pwhash_argon2id_str_needs_rehash=Module[\"_crypto_pwhash_argon2id_str_needs_rehash\"]=Module[\"asm\"][\"Cd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_alg_argon2id13=Module[\"_crypto_pwhash_argon2id_alg_argon2id13\"]=function(){return(_crypto_pwhash_argon2id_alg_argon2id13=Module[\"_crypto_pwhash_argon2id_alg_argon2id13\"]=Module[\"asm\"][\"Dd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_bytes_min=Module[\"_crypto_pwhash_argon2id_bytes_min\"]=function(){return(_crypto_pwhash_argon2id_bytes_min=Module[\"_crypto_pwhash_argon2id_bytes_min\"]=Module[\"asm\"][\"Ed\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_bytes_max=Module[\"_crypto_pwhash_argon2id_bytes_max\"]=function(){return(_crypto_pwhash_argon2id_bytes_max=Module[\"_crypto_pwhash_argon2id_bytes_max\"]=Module[\"asm\"][\"Fd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_passwd_min=Module[\"_crypto_pwhash_argon2id_passwd_min\"]=function(){return(_crypto_pwhash_argon2id_passwd_min=Module[\"_crypto_pwhash_argon2id_passwd_min\"]=Module[\"asm\"][\"Gd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_passwd_max=Module[\"_crypto_pwhash_argon2id_passwd_max\"]=function(){return(_crypto_pwhash_argon2id_passwd_max=Module[\"_crypto_pwhash_argon2id_passwd_max\"]=Module[\"asm\"][\"Hd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_saltbytes=Module[\"_crypto_pwhash_argon2id_saltbytes\"]=function(){return(_crypto_pwhash_argon2id_saltbytes=Module[\"_crypto_pwhash_argon2id_saltbytes\"]=Module[\"asm\"][\"Id\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_strbytes=Module[\"_crypto_pwhash_argon2id_strbytes\"]=function(){return(_crypto_pwhash_argon2id_strbytes=Module[\"_crypto_pwhash_argon2id_strbytes\"]=Module[\"asm\"][\"Jd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_strprefix=Module[\"_crypto_pwhash_argon2id_strprefix\"]=function(){return(_crypto_pwhash_argon2id_strprefix=Module[\"_crypto_pwhash_argon2id_strprefix\"]=Module[\"asm\"][\"Kd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_min=Module[\"_crypto_pwhash_argon2id_opslimit_min\"]=function(){return(_crypto_pwhash_argon2id_opslimit_min=Module[\"_crypto_pwhash_argon2id_opslimit_min\"]=Module[\"asm\"][\"Ld\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_max=Module[\"_crypto_pwhash_argon2id_opslimit_max\"]=function(){return(_crypto_pwhash_argon2id_opslimit_max=Module[\"_crypto_pwhash_argon2id_opslimit_max\"]=Module[\"asm\"][\"Md\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_min=Module[\"_crypto_pwhash_argon2id_memlimit_min\"]=function(){return(_crypto_pwhash_argon2id_memlimit_min=Module[\"_crypto_pwhash_argon2id_memlimit_min\"]=Module[\"asm\"][\"Nd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_max=Module[\"_crypto_pwhash_argon2id_memlimit_max\"]=function(){return(_crypto_pwhash_argon2id_memlimit_max=Module[\"_crypto_pwhash_argon2id_memlimit_max\"]=Module[\"asm\"][\"Od\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_interactive=Module[\"_crypto_pwhash_argon2id_opslimit_interactive\"]=function(){return(_crypto_pwhash_argon2id_opslimit_interactive=Module[\"_crypto_pwhash_argon2id_opslimit_interactive\"]=Module[\"asm\"][\"Pd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_interactive=Module[\"_crypto_pwhash_argon2id_memlimit_interactive\"]=function(){return(_crypto_pwhash_argon2id_memlimit_interactive=Module[\"_crypto_pwhash_argon2id_memlimit_interactive\"]=Module[\"asm\"][\"Qd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_moderate=Module[\"_crypto_pwhash_argon2id_opslimit_moderate\"]=function(){return(_crypto_pwhash_argon2id_opslimit_moderate=Module[\"_crypto_pwhash_argon2id_opslimit_moderate\"]=Module[\"asm\"][\"Rd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_moderate=Module[\"_crypto_pwhash_argon2id_memlimit_moderate\"]=function(){return(_crypto_pwhash_argon2id_memlimit_moderate=Module[\"_crypto_pwhash_argon2id_memlimit_moderate\"]=Module[\"asm\"][\"Sd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_opslimit_sensitive=Module[\"_crypto_pwhash_argon2id_opslimit_sensitive\"]=function(){return(_crypto_pwhash_argon2id_opslimit_sensitive=Module[\"_crypto_pwhash_argon2id_opslimit_sensitive\"]=Module[\"asm\"][\"Td\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_memlimit_sensitive=Module[\"_crypto_pwhash_argon2id_memlimit_sensitive\"]=function(){return(_crypto_pwhash_argon2id_memlimit_sensitive=Module[\"_crypto_pwhash_argon2id_memlimit_sensitive\"]=Module[\"asm\"][\"Ud\"]).apply(null,arguments)};var _crypto_pwhash_argon2id=Module[\"_crypto_pwhash_argon2id\"]=function(){return(_crypto_pwhash_argon2id=Module[\"_crypto_pwhash_argon2id\"]=Module[\"asm\"][\"Vd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_str=Module[\"_crypto_pwhash_argon2id_str\"]=function(){return(_crypto_pwhash_argon2id_str=Module[\"_crypto_pwhash_argon2id_str\"]=Module[\"asm\"][\"Wd\"]).apply(null,arguments)};var _crypto_pwhash_argon2id_str_verify=Module[\"_crypto_pwhash_argon2id_str_verify\"]=function(){return(_crypto_pwhash_argon2id_str_verify=Module[\"_crypto_pwhash_argon2id_str_verify\"]=Module[\"asm\"][\"Xd\"]).apply(null,arguments)};var _crypto_pwhash_alg_argon2i13=Module[\"_crypto_pwhash_alg_argon2i13\"]=function(){return(_crypto_pwhash_alg_argon2i13=Module[\"_crypto_pwhash_alg_argon2i13\"]=Module[\"asm\"][\"Yd\"]).apply(null,arguments)};var _crypto_pwhash_alg_argon2id13=Module[\"_crypto_pwhash_alg_argon2id13\"]=function(){return(_crypto_pwhash_alg_argon2id13=Module[\"_crypto_pwhash_alg_argon2id13\"]=Module[\"asm\"][\"Zd\"]).apply(null,arguments)};var _crypto_pwhash_alg_default=Module[\"_crypto_pwhash_alg_default\"]=function(){return(_crypto_pwhash_alg_default=Module[\"_crypto_pwhash_alg_default\"]=Module[\"asm\"][\"_d\"]).apply(null,arguments)};var _crypto_pwhash_bytes_min=Module[\"_crypto_pwhash_bytes_min\"]=function(){return(_crypto_pwhash_bytes_min=Module[\"_crypto_pwhash_bytes_min\"]=Module[\"asm\"][\"$d\"]).apply(null,arguments)};var _crypto_pwhash_bytes_max=Module[\"_crypto_pwhash_bytes_max\"]=function(){return(_crypto_pwhash_bytes_max=Module[\"_crypto_pwhash_bytes_max\"]=Module[\"asm\"][\"ae\"]).apply(null,arguments)};var _crypto_pwhash_passwd_min=Module[\"_crypto_pwhash_passwd_min\"]=function(){return(_crypto_pwhash_passwd_min=Module[\"_crypto_pwhash_passwd_min\"]=Module[\"asm\"][\"be\"]).apply(null,arguments)};var _crypto_pwhash_passwd_max=Module[\"_crypto_pwhash_passwd_max\"]=function(){return(_crypto_pwhash_passwd_max=Module[\"_crypto_pwhash_passwd_max\"]=Module[\"asm\"][\"ce\"]).apply(null,arguments)};var _crypto_pwhash_saltbytes=Module[\"_crypto_pwhash_saltbytes\"]=function(){return(_crypto_pwhash_saltbytes=Module[\"_crypto_pwhash_saltbytes\"]=Module[\"asm\"][\"de\"]).apply(null,arguments)};var _crypto_pwhash_strbytes=Module[\"_crypto_pwhash_strbytes\"]=function(){return(_crypto_pwhash_strbytes=Module[\"_crypto_pwhash_strbytes\"]=Module[\"asm\"][\"ee\"]).apply(null,arguments)};var _crypto_pwhash_strprefix=Module[\"_crypto_pwhash_strprefix\"]=function(){return(_crypto_pwhash_strprefix=Module[\"_crypto_pwhash_strprefix\"]=Module[\"asm\"][\"fe\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_min=Module[\"_crypto_pwhash_opslimit_min\"]=function(){return(_crypto_pwhash_opslimit_min=Module[\"_crypto_pwhash_opslimit_min\"]=Module[\"asm\"][\"ge\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_max=Module[\"_crypto_pwhash_opslimit_max\"]=function(){return(_crypto_pwhash_opslimit_max=Module[\"_crypto_pwhash_opslimit_max\"]=Module[\"asm\"][\"he\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_min=Module[\"_crypto_pwhash_memlimit_min\"]=function(){return(_crypto_pwhash_memlimit_min=Module[\"_crypto_pwhash_memlimit_min\"]=Module[\"asm\"][\"ie\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_max=Module[\"_crypto_pwhash_memlimit_max\"]=function(){return(_crypto_pwhash_memlimit_max=Module[\"_crypto_pwhash_memlimit_max\"]=Module[\"asm\"][\"je\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_interactive=Module[\"_crypto_pwhash_opslimit_interactive\"]=function(){return(_crypto_pwhash_opslimit_interactive=Module[\"_crypto_pwhash_opslimit_interactive\"]=Module[\"asm\"][\"ke\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_interactive=Module[\"_crypto_pwhash_memlimit_interactive\"]=function(){return(_crypto_pwhash_memlimit_interactive=Module[\"_crypto_pwhash_memlimit_interactive\"]=Module[\"asm\"][\"le\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_moderate=Module[\"_crypto_pwhash_opslimit_moderate\"]=function(){return(_crypto_pwhash_opslimit_moderate=Module[\"_crypto_pwhash_opslimit_moderate\"]=Module[\"asm\"][\"me\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_moderate=Module[\"_crypto_pwhash_memlimit_moderate\"]=function(){return(_crypto_pwhash_memlimit_moderate=Module[\"_crypto_pwhash_memlimit_moderate\"]=Module[\"asm\"][\"ne\"]).apply(null,arguments)};var _crypto_pwhash_opslimit_sensitive=Module[\"_crypto_pwhash_opslimit_sensitive\"]=function(){return(_crypto_pwhash_opslimit_sensitive=Module[\"_crypto_pwhash_opslimit_sensitive\"]=Module[\"asm\"][\"oe\"]).apply(null,arguments)};var _crypto_pwhash_memlimit_sensitive=Module[\"_crypto_pwhash_memlimit_sensitive\"]=function(){return(_crypto_pwhash_memlimit_sensitive=Module[\"_crypto_pwhash_memlimit_sensitive\"]=Module[\"asm\"][\"pe\"]).apply(null,arguments)};var _crypto_pwhash=Module[\"_crypto_pwhash\"]=function(){return(_crypto_pwhash=Module[\"_crypto_pwhash\"]=Module[\"asm\"][\"qe\"]).apply(null,arguments)};var _crypto_pwhash_str=Module[\"_crypto_pwhash_str\"]=function(){return(_crypto_pwhash_str=Module[\"_crypto_pwhash_str\"]=Module[\"asm\"][\"re\"]).apply(null,arguments)};var _crypto_pwhash_str_alg=Module[\"_crypto_pwhash_str_alg\"]=function(){return(_crypto_pwhash_str_alg=Module[\"_crypto_pwhash_str_alg\"]=Module[\"asm\"][\"se\"]).apply(null,arguments)};var _crypto_pwhash_str_verify=Module[\"_crypto_pwhash_str_verify\"]=function(){return(_crypto_pwhash_str_verify=Module[\"_crypto_pwhash_str_verify\"]=Module[\"asm\"][\"te\"]).apply(null,arguments)};var _crypto_pwhash_str_needs_rehash=Module[\"_crypto_pwhash_str_needs_rehash\"]=function(){return(_crypto_pwhash_str_needs_rehash=Module[\"_crypto_pwhash_str_needs_rehash\"]=Module[\"asm\"][\"ue\"]).apply(null,arguments)};var _crypto_pwhash_primitive=Module[\"_crypto_pwhash_primitive\"]=function(){return(_crypto_pwhash_primitive=Module[\"_crypto_pwhash_primitive\"]=Module[\"asm\"][\"ve\"]).apply(null,arguments)};var _crypto_scalarmult_primitive=Module[\"_crypto_scalarmult_primitive\"]=function(){return(_crypto_scalarmult_primitive=Module[\"_crypto_scalarmult_primitive\"]=Module[\"asm\"][\"we\"]).apply(null,arguments)};var _crypto_scalarmult_base=Module[\"_crypto_scalarmult_base\"]=function(){return(_crypto_scalarmult_base=Module[\"_crypto_scalarmult_base\"]=Module[\"asm\"][\"xe\"]).apply(null,arguments)};var _crypto_scalarmult=Module[\"_crypto_scalarmult\"]=function(){return(_crypto_scalarmult=Module[\"_crypto_scalarmult\"]=Module[\"asm\"][\"ye\"]).apply(null,arguments)};var _crypto_scalarmult_bytes=Module[\"_crypto_scalarmult_bytes\"]=function(){return(_crypto_scalarmult_bytes=Module[\"_crypto_scalarmult_bytes\"]=Module[\"asm\"][\"ze\"]).apply(null,arguments)};var _crypto_scalarmult_scalarbytes=Module[\"_crypto_scalarmult_scalarbytes\"]=function(){return(_crypto_scalarmult_scalarbytes=Module[\"_crypto_scalarmult_scalarbytes\"]=Module[\"asm\"][\"Ae\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519=Module[\"_crypto_scalarmult_curve25519\"]=function(){return(_crypto_scalarmult_curve25519=Module[\"_crypto_scalarmult_curve25519\"]=Module[\"asm\"][\"Be\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519_base=Module[\"_crypto_scalarmult_curve25519_base\"]=function(){return(_crypto_scalarmult_curve25519_base=Module[\"_crypto_scalarmult_curve25519_base\"]=Module[\"asm\"][\"Ce\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519_bytes=Module[\"_crypto_scalarmult_curve25519_bytes\"]=function(){return(_crypto_scalarmult_curve25519_bytes=Module[\"_crypto_scalarmult_curve25519_bytes\"]=Module[\"asm\"][\"De\"]).apply(null,arguments)};var _crypto_scalarmult_curve25519_scalarbytes=Module[\"_crypto_scalarmult_curve25519_scalarbytes\"]=function(){return(_crypto_scalarmult_curve25519_scalarbytes=Module[\"_crypto_scalarmult_curve25519_scalarbytes\"]=Module[\"asm\"][\"Ee\"]).apply(null,arguments)};var _crypto_secretbox_keybytes=Module[\"_crypto_secretbox_keybytes\"]=function(){return(_crypto_secretbox_keybytes=Module[\"_crypto_secretbox_keybytes\"]=Module[\"asm\"][\"Fe\"]).apply(null,arguments)};var _crypto_secretbox_noncebytes=Module[\"_crypto_secretbox_noncebytes\"]=function(){return(_crypto_secretbox_noncebytes=Module[\"_crypto_secretbox_noncebytes\"]=Module[\"asm\"][\"Ge\"]).apply(null,arguments)};var _crypto_secretbox_zerobytes=Module[\"_crypto_secretbox_zerobytes\"]=function(){return(_crypto_secretbox_zerobytes=Module[\"_crypto_secretbox_zerobytes\"]=Module[\"asm\"][\"He\"]).apply(null,arguments)};var _crypto_secretbox_boxzerobytes=Module[\"_crypto_secretbox_boxzerobytes\"]=function(){return(_crypto_secretbox_boxzerobytes=Module[\"_crypto_secretbox_boxzerobytes\"]=Module[\"asm\"][\"Ie\"]).apply(null,arguments)};var _crypto_secretbox_macbytes=Module[\"_crypto_secretbox_macbytes\"]=function(){return(_crypto_secretbox_macbytes=Module[\"_crypto_secretbox_macbytes\"]=Module[\"asm\"][\"Je\"]).apply(null,arguments)};var _crypto_secretbox_messagebytes_max=Module[\"_crypto_secretbox_messagebytes_max\"]=function(){return(_crypto_secretbox_messagebytes_max=Module[\"_crypto_secretbox_messagebytes_max\"]=Module[\"asm\"][\"Ke\"]).apply(null,arguments)};var _crypto_secretbox_primitive=Module[\"_crypto_secretbox_primitive\"]=function(){return(_crypto_secretbox_primitive=Module[\"_crypto_secretbox_primitive\"]=Module[\"asm\"][\"Le\"]).apply(null,arguments)};var _crypto_secretbox=Module[\"_crypto_secretbox\"]=function(){return(_crypto_secretbox=Module[\"_crypto_secretbox\"]=Module[\"asm\"][\"Me\"]).apply(null,arguments)};var _crypto_secretbox_open=Module[\"_crypto_secretbox_open\"]=function(){return(_crypto_secretbox_open=Module[\"_crypto_secretbox_open\"]=Module[\"asm\"][\"Ne\"]).apply(null,arguments)};var _crypto_secretbox_keygen=Module[\"_crypto_secretbox_keygen\"]=function(){return(_crypto_secretbox_keygen=Module[\"_crypto_secretbox_keygen\"]=Module[\"asm\"][\"Oe\"]).apply(null,arguments)};var _crypto_secretbox_detached=Module[\"_crypto_secretbox_detached\"]=function(){return(_crypto_secretbox_detached=Module[\"_crypto_secretbox_detached\"]=Module[\"asm\"][\"Pe\"]).apply(null,arguments)};var _crypto_secretbox_easy=Module[\"_crypto_secretbox_easy\"]=function(){return(_crypto_secretbox_easy=Module[\"_crypto_secretbox_easy\"]=Module[\"asm\"][\"Qe\"]).apply(null,arguments)};var _crypto_secretbox_open_detached=Module[\"_crypto_secretbox_open_detached\"]=function(){return(_crypto_secretbox_open_detached=Module[\"_crypto_secretbox_open_detached\"]=Module[\"asm\"][\"Re\"]).apply(null,arguments)};var _crypto_secretbox_open_easy=Module[\"_crypto_secretbox_open_easy\"]=function(){return(_crypto_secretbox_open_easy=Module[\"_crypto_secretbox_open_easy\"]=Module[\"asm\"][\"Se\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305=Module[\"_crypto_secretbox_xsalsa20poly1305\"]=function(){return(_crypto_secretbox_xsalsa20poly1305=Module[\"_crypto_secretbox_xsalsa20poly1305\"]=Module[\"asm\"][\"Te\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_open=Module[\"_crypto_secretbox_xsalsa20poly1305_open\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_open=Module[\"_crypto_secretbox_xsalsa20poly1305_open\"]=Module[\"asm\"][\"Ue\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_keybytes=Module[\"_crypto_secretbox_xsalsa20poly1305_keybytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_keybytes=Module[\"_crypto_secretbox_xsalsa20poly1305_keybytes\"]=Module[\"asm\"][\"Ve\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_noncebytes=Module[\"_crypto_secretbox_xsalsa20poly1305_noncebytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_noncebytes=Module[\"_crypto_secretbox_xsalsa20poly1305_noncebytes\"]=Module[\"asm\"][\"We\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_zerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_zerobytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_zerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_zerobytes\"]=Module[\"asm\"][\"Xe\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_boxzerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_boxzerobytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_boxzerobytes=Module[\"_crypto_secretbox_xsalsa20poly1305_boxzerobytes\"]=Module[\"asm\"][\"Ye\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_macbytes=Module[\"_crypto_secretbox_xsalsa20poly1305_macbytes\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_macbytes=Module[\"_crypto_secretbox_xsalsa20poly1305_macbytes\"]=Module[\"asm\"][\"Ze\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xsalsa20poly1305_messagebytes_max\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xsalsa20poly1305_messagebytes_max\"]=Module[\"asm\"][\"_e\"]).apply(null,arguments)};var _crypto_secretbox_xsalsa20poly1305_keygen=Module[\"_crypto_secretbox_xsalsa20poly1305_keygen\"]=function(){return(_crypto_secretbox_xsalsa20poly1305_keygen=Module[\"_crypto_secretbox_xsalsa20poly1305_keygen\"]=Module[\"asm\"][\"$e\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_keygen=Module[\"_crypto_secretstream_xchacha20poly1305_keygen\"]=function(){return(_crypto_secretstream_xchacha20poly1305_keygen=Module[\"_crypto_secretstream_xchacha20poly1305_keygen\"]=Module[\"asm\"][\"af\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_init_push=Module[\"_crypto_secretstream_xchacha20poly1305_init_push\"]=function(){return(_crypto_secretstream_xchacha20poly1305_init_push=Module[\"_crypto_secretstream_xchacha20poly1305_init_push\"]=Module[\"asm\"][\"bf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_init_pull=Module[\"_crypto_secretstream_xchacha20poly1305_init_pull\"]=function(){return(_crypto_secretstream_xchacha20poly1305_init_pull=Module[\"_crypto_secretstream_xchacha20poly1305_init_pull\"]=Module[\"asm\"][\"cf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_rekey\"]=function(){return(_crypto_secretstream_xchacha20poly1305_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_rekey\"]=Module[\"asm\"][\"df\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_push=Module[\"_crypto_secretstream_xchacha20poly1305_push\"]=function(){return(_crypto_secretstream_xchacha20poly1305_push=Module[\"_crypto_secretstream_xchacha20poly1305_push\"]=Module[\"asm\"][\"ef\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_pull=Module[\"_crypto_secretstream_xchacha20poly1305_pull\"]=function(){return(_crypto_secretstream_xchacha20poly1305_pull=Module[\"_crypto_secretstream_xchacha20poly1305_pull\"]=Module[\"asm\"][\"ff\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_statebytes=Module[\"_crypto_secretstream_xchacha20poly1305_statebytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_statebytes=Module[\"_crypto_secretstream_xchacha20poly1305_statebytes\"]=Module[\"asm\"][\"gf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_abytes=Module[\"_crypto_secretstream_xchacha20poly1305_abytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_abytes=Module[\"_crypto_secretstream_xchacha20poly1305_abytes\"]=Module[\"asm\"][\"hf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_headerbytes=Module[\"_crypto_secretstream_xchacha20poly1305_headerbytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_headerbytes=Module[\"_crypto_secretstream_xchacha20poly1305_headerbytes\"]=Module[\"asm\"][\"jf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_keybytes=Module[\"_crypto_secretstream_xchacha20poly1305_keybytes\"]=function(){return(_crypto_secretstream_xchacha20poly1305_keybytes=Module[\"_crypto_secretstream_xchacha20poly1305_keybytes\"]=Module[\"asm\"][\"kf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretstream_xchacha20poly1305_messagebytes_max\"]=function(){return(_crypto_secretstream_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretstream_xchacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"lf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_message=Module[\"_crypto_secretstream_xchacha20poly1305_tag_message\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_message=Module[\"_crypto_secretstream_xchacha20poly1305_tag_message\"]=Module[\"asm\"][\"mf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_push=Module[\"_crypto_secretstream_xchacha20poly1305_tag_push\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_push=Module[\"_crypto_secretstream_xchacha20poly1305_tag_push\"]=Module[\"asm\"][\"nf\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_tag_rekey\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_rekey=Module[\"_crypto_secretstream_xchacha20poly1305_tag_rekey\"]=Module[\"asm\"][\"of\"]).apply(null,arguments)};var _crypto_secretstream_xchacha20poly1305_tag_final=Module[\"_crypto_secretstream_xchacha20poly1305_tag_final\"]=function(){return(_crypto_secretstream_xchacha20poly1305_tag_final=Module[\"_crypto_secretstream_xchacha20poly1305_tag_final\"]=Module[\"asm\"][\"pf\"]).apply(null,arguments)};var _crypto_shorthash_bytes=Module[\"_crypto_shorthash_bytes\"]=function(){return(_crypto_shorthash_bytes=Module[\"_crypto_shorthash_bytes\"]=Module[\"asm\"][\"qf\"]).apply(null,arguments)};var _crypto_shorthash_keybytes=Module[\"_crypto_shorthash_keybytes\"]=function(){return(_crypto_shorthash_keybytes=Module[\"_crypto_shorthash_keybytes\"]=Module[\"asm\"][\"rf\"]).apply(null,arguments)};var _crypto_shorthash_primitive=Module[\"_crypto_shorthash_primitive\"]=function(){return(_crypto_shorthash_primitive=Module[\"_crypto_shorthash_primitive\"]=Module[\"asm\"][\"sf\"]).apply(null,arguments)};var _crypto_shorthash=Module[\"_crypto_shorthash\"]=function(){return(_crypto_shorthash=Module[\"_crypto_shorthash\"]=Module[\"asm\"][\"tf\"]).apply(null,arguments)};var _crypto_shorthash_keygen=Module[\"_crypto_shorthash_keygen\"]=function(){return(_crypto_shorthash_keygen=Module[\"_crypto_shorthash_keygen\"]=Module[\"asm\"][\"uf\"]).apply(null,arguments)};var _crypto_shorthash_siphash24_bytes=Module[\"_crypto_shorthash_siphash24_bytes\"]=function(){return(_crypto_shorthash_siphash24_bytes=Module[\"_crypto_shorthash_siphash24_bytes\"]=Module[\"asm\"][\"vf\"]).apply(null,arguments)};var _crypto_shorthash_siphash24_keybytes=Module[\"_crypto_shorthash_siphash24_keybytes\"]=function(){return(_crypto_shorthash_siphash24_keybytes=Module[\"_crypto_shorthash_siphash24_keybytes\"]=Module[\"asm\"][\"wf\"]).apply(null,arguments)};var _crypto_shorthash_siphash24=Module[\"_crypto_shorthash_siphash24\"]=function(){return(_crypto_shorthash_siphash24=Module[\"_crypto_shorthash_siphash24\"]=Module[\"asm\"][\"xf\"]).apply(null,arguments)};var _crypto_sign_statebytes=Module[\"_crypto_sign_statebytes\"]=function(){return(_crypto_sign_statebytes=Module[\"_crypto_sign_statebytes\"]=Module[\"asm\"][\"yf\"]).apply(null,arguments)};var _crypto_sign_bytes=Module[\"_crypto_sign_bytes\"]=function(){return(_crypto_sign_bytes=Module[\"_crypto_sign_bytes\"]=Module[\"asm\"][\"zf\"]).apply(null,arguments)};var _crypto_sign_seedbytes=Module[\"_crypto_sign_seedbytes\"]=function(){return(_crypto_sign_seedbytes=Module[\"_crypto_sign_seedbytes\"]=Module[\"asm\"][\"Af\"]).apply(null,arguments)};var _crypto_sign_publickeybytes=Module[\"_crypto_sign_publickeybytes\"]=function(){return(_crypto_sign_publickeybytes=Module[\"_crypto_sign_publickeybytes\"]=Module[\"asm\"][\"Bf\"]).apply(null,arguments)};var _crypto_sign_secretkeybytes=Module[\"_crypto_sign_secretkeybytes\"]=function(){return(_crypto_sign_secretkeybytes=Module[\"_crypto_sign_secretkeybytes\"]=Module[\"asm\"][\"Cf\"]).apply(null,arguments)};var _crypto_sign_messagebytes_max=Module[\"_crypto_sign_messagebytes_max\"]=function(){return(_crypto_sign_messagebytes_max=Module[\"_crypto_sign_messagebytes_max\"]=Module[\"asm\"][\"Df\"]).apply(null,arguments)};var _crypto_sign_primitive=Module[\"_crypto_sign_primitive\"]=function(){return(_crypto_sign_primitive=Module[\"_crypto_sign_primitive\"]=Module[\"asm\"][\"Ef\"]).apply(null,arguments)};var _crypto_sign_seed_keypair=Module[\"_crypto_sign_seed_keypair\"]=function(){return(_crypto_sign_seed_keypair=Module[\"_crypto_sign_seed_keypair\"]=Module[\"asm\"][\"Ff\"]).apply(null,arguments)};var _crypto_sign_keypair=Module[\"_crypto_sign_keypair\"]=function(){return(_crypto_sign_keypair=Module[\"_crypto_sign_keypair\"]=Module[\"asm\"][\"Gf\"]).apply(null,arguments)};var _crypto_sign=Module[\"_crypto_sign\"]=function(){return(_crypto_sign=Module[\"_crypto_sign\"]=Module[\"asm\"][\"Hf\"]).apply(null,arguments)};var _crypto_sign_open=Module[\"_crypto_sign_open\"]=function(){return(_crypto_sign_open=Module[\"_crypto_sign_open\"]=Module[\"asm\"][\"If\"]).apply(null,arguments)};var _crypto_sign_detached=Module[\"_crypto_sign_detached\"]=function(){return(_crypto_sign_detached=Module[\"_crypto_sign_detached\"]=Module[\"asm\"][\"Jf\"]).apply(null,arguments)};var _crypto_sign_verify_detached=Module[\"_crypto_sign_verify_detached\"]=function(){return(_crypto_sign_verify_detached=Module[\"_crypto_sign_verify_detached\"]=Module[\"asm\"][\"Kf\"]).apply(null,arguments)};var _crypto_sign_init=Module[\"_crypto_sign_init\"]=function(){return(_crypto_sign_init=Module[\"_crypto_sign_init\"]=Module[\"asm\"][\"Lf\"]).apply(null,arguments)};var _crypto_sign_update=Module[\"_crypto_sign_update\"]=function(){return(_crypto_sign_update=Module[\"_crypto_sign_update\"]=Module[\"asm\"][\"Mf\"]).apply(null,arguments)};var _crypto_sign_final_create=Module[\"_crypto_sign_final_create\"]=function(){return(_crypto_sign_final_create=Module[\"_crypto_sign_final_create\"]=Module[\"asm\"][\"Nf\"]).apply(null,arguments)};var _crypto_sign_final_verify=Module[\"_crypto_sign_final_verify\"]=function(){return(_crypto_sign_final_verify=Module[\"_crypto_sign_final_verify\"]=Module[\"asm\"][\"Of\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_statebytes=Module[\"_crypto_sign_ed25519ph_statebytes\"]=function(){return(_crypto_sign_ed25519ph_statebytes=Module[\"_crypto_sign_ed25519ph_statebytes\"]=Module[\"asm\"][\"Pf\"]).apply(null,arguments)};var _crypto_sign_ed25519_bytes=Module[\"_crypto_sign_ed25519_bytes\"]=function(){return(_crypto_sign_ed25519_bytes=Module[\"_crypto_sign_ed25519_bytes\"]=Module[\"asm\"][\"Qf\"]).apply(null,arguments)};var _crypto_sign_ed25519_seedbytes=Module[\"_crypto_sign_ed25519_seedbytes\"]=function(){return(_crypto_sign_ed25519_seedbytes=Module[\"_crypto_sign_ed25519_seedbytes\"]=Module[\"asm\"][\"Rf\"]).apply(null,arguments)};var _crypto_sign_ed25519_publickeybytes=Module[\"_crypto_sign_ed25519_publickeybytes\"]=function(){return(_crypto_sign_ed25519_publickeybytes=Module[\"_crypto_sign_ed25519_publickeybytes\"]=Module[\"asm\"][\"Sf\"]).apply(null,arguments)};var _crypto_sign_ed25519_secretkeybytes=Module[\"_crypto_sign_ed25519_secretkeybytes\"]=function(){return(_crypto_sign_ed25519_secretkeybytes=Module[\"_crypto_sign_ed25519_secretkeybytes\"]=Module[\"asm\"][\"Tf\"]).apply(null,arguments)};var _crypto_sign_ed25519_messagebytes_max=Module[\"_crypto_sign_ed25519_messagebytes_max\"]=function(){return(_crypto_sign_ed25519_messagebytes_max=Module[\"_crypto_sign_ed25519_messagebytes_max\"]=Module[\"asm\"][\"Uf\"]).apply(null,arguments)};var _crypto_sign_ed25519_sk_to_seed=Module[\"_crypto_sign_ed25519_sk_to_seed\"]=function(){return(_crypto_sign_ed25519_sk_to_seed=Module[\"_crypto_sign_ed25519_sk_to_seed\"]=Module[\"asm\"][\"Vf\"]).apply(null,arguments)};var _crypto_sign_ed25519_sk_to_pk=Module[\"_crypto_sign_ed25519_sk_to_pk\"]=function(){return(_crypto_sign_ed25519_sk_to_pk=Module[\"_crypto_sign_ed25519_sk_to_pk\"]=Module[\"asm\"][\"Wf\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_init=Module[\"_crypto_sign_ed25519ph_init\"]=function(){return(_crypto_sign_ed25519ph_init=Module[\"_crypto_sign_ed25519ph_init\"]=Module[\"asm\"][\"Xf\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_update=Module[\"_crypto_sign_ed25519ph_update\"]=function(){return(_crypto_sign_ed25519ph_update=Module[\"_crypto_sign_ed25519ph_update\"]=Module[\"asm\"][\"Yf\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_final_create=Module[\"_crypto_sign_ed25519ph_final_create\"]=function(){return(_crypto_sign_ed25519ph_final_create=Module[\"_crypto_sign_ed25519ph_final_create\"]=Module[\"asm\"][\"Zf\"]).apply(null,arguments)};var _crypto_sign_ed25519ph_final_verify=Module[\"_crypto_sign_ed25519ph_final_verify\"]=function(){return(_crypto_sign_ed25519ph_final_verify=Module[\"_crypto_sign_ed25519ph_final_verify\"]=Module[\"asm\"][\"_f\"]).apply(null,arguments)};var _crypto_sign_ed25519_seed_keypair=Module[\"_crypto_sign_ed25519_seed_keypair\"]=function(){return(_crypto_sign_ed25519_seed_keypair=Module[\"_crypto_sign_ed25519_seed_keypair\"]=Module[\"asm\"][\"$f\"]).apply(null,arguments)};var _crypto_sign_ed25519_keypair=Module[\"_crypto_sign_ed25519_keypair\"]=function(){return(_crypto_sign_ed25519_keypair=Module[\"_crypto_sign_ed25519_keypair\"]=Module[\"asm\"][\"ag\"]).apply(null,arguments)};var _crypto_sign_ed25519_pk_to_curve25519=Module[\"_crypto_sign_ed25519_pk_to_curve25519\"]=function(){return(_crypto_sign_ed25519_pk_to_curve25519=Module[\"_crypto_sign_ed25519_pk_to_curve25519\"]=Module[\"asm\"][\"bg\"]).apply(null,arguments)};var _crypto_sign_ed25519_sk_to_curve25519=Module[\"_crypto_sign_ed25519_sk_to_curve25519\"]=function(){return(_crypto_sign_ed25519_sk_to_curve25519=Module[\"_crypto_sign_ed25519_sk_to_curve25519\"]=Module[\"asm\"][\"cg\"]).apply(null,arguments)};var _crypto_sign_ed25519_verify_detached=Module[\"_crypto_sign_ed25519_verify_detached\"]=function(){return(_crypto_sign_ed25519_verify_detached=Module[\"_crypto_sign_ed25519_verify_detached\"]=Module[\"asm\"][\"dg\"]).apply(null,arguments)};var _crypto_sign_ed25519_open=Module[\"_crypto_sign_ed25519_open\"]=function(){return(_crypto_sign_ed25519_open=Module[\"_crypto_sign_ed25519_open\"]=Module[\"asm\"][\"eg\"]).apply(null,arguments)};var _crypto_sign_ed25519_detached=Module[\"_crypto_sign_ed25519_detached\"]=function(){return(_crypto_sign_ed25519_detached=Module[\"_crypto_sign_ed25519_detached\"]=Module[\"asm\"][\"fg\"]).apply(null,arguments)};var _crypto_sign_ed25519=Module[\"_crypto_sign_ed25519\"]=function(){return(_crypto_sign_ed25519=Module[\"_crypto_sign_ed25519\"]=Module[\"asm\"][\"gg\"]).apply(null,arguments)};var _crypto_stream_chacha20_keybytes=Module[\"_crypto_stream_chacha20_keybytes\"]=function(){return(_crypto_stream_chacha20_keybytes=Module[\"_crypto_stream_chacha20_keybytes\"]=Module[\"asm\"][\"hg\"]).apply(null,arguments)};var _crypto_stream_chacha20_noncebytes=Module[\"_crypto_stream_chacha20_noncebytes\"]=function(){return(_crypto_stream_chacha20_noncebytes=Module[\"_crypto_stream_chacha20_noncebytes\"]=Module[\"asm\"][\"ig\"]).apply(null,arguments)};var _crypto_stream_chacha20_messagebytes_max=Module[\"_crypto_stream_chacha20_messagebytes_max\"]=function(){return(_crypto_stream_chacha20_messagebytes_max=Module[\"_crypto_stream_chacha20_messagebytes_max\"]=Module[\"asm\"][\"jg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_keybytes=Module[\"_crypto_stream_chacha20_ietf_keybytes\"]=function(){return(_crypto_stream_chacha20_ietf_keybytes=Module[\"_crypto_stream_chacha20_ietf_keybytes\"]=Module[\"asm\"][\"kg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_noncebytes=Module[\"_crypto_stream_chacha20_ietf_noncebytes\"]=function(){return(_crypto_stream_chacha20_ietf_noncebytes=Module[\"_crypto_stream_chacha20_ietf_noncebytes\"]=Module[\"asm\"][\"lg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_messagebytes_max=Module[\"_crypto_stream_chacha20_ietf_messagebytes_max\"]=function(){return(_crypto_stream_chacha20_ietf_messagebytes_max=Module[\"_crypto_stream_chacha20_ietf_messagebytes_max\"]=Module[\"asm\"][\"mg\"]).apply(null,arguments)};var _crypto_stream_chacha20=Module[\"_crypto_stream_chacha20\"]=function(){return(_crypto_stream_chacha20=Module[\"_crypto_stream_chacha20\"]=Module[\"asm\"][\"ng\"]).apply(null,arguments)};var _crypto_stream_chacha20_xor_ic=Module[\"_crypto_stream_chacha20_xor_ic\"]=function(){return(_crypto_stream_chacha20_xor_ic=Module[\"_crypto_stream_chacha20_xor_ic\"]=Module[\"asm\"][\"og\"]).apply(null,arguments)};var _crypto_stream_chacha20_xor=Module[\"_crypto_stream_chacha20_xor\"]=function(){return(_crypto_stream_chacha20_xor=Module[\"_crypto_stream_chacha20_xor\"]=Module[\"asm\"][\"pg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf=Module[\"_crypto_stream_chacha20_ietf\"]=function(){return(_crypto_stream_chacha20_ietf=Module[\"_crypto_stream_chacha20_ietf\"]=Module[\"asm\"][\"qg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_xor_ic=Module[\"_crypto_stream_chacha20_ietf_xor_ic\"]=function(){return(_crypto_stream_chacha20_ietf_xor_ic=Module[\"_crypto_stream_chacha20_ietf_xor_ic\"]=Module[\"asm\"][\"rg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_xor=Module[\"_crypto_stream_chacha20_ietf_xor\"]=function(){return(_crypto_stream_chacha20_ietf_xor=Module[\"_crypto_stream_chacha20_ietf_xor\"]=Module[\"asm\"][\"sg\"]).apply(null,arguments)};var _crypto_stream_chacha20_ietf_keygen=Module[\"_crypto_stream_chacha20_ietf_keygen\"]=function(){return(_crypto_stream_chacha20_ietf_keygen=Module[\"_crypto_stream_chacha20_ietf_keygen\"]=Module[\"asm\"][\"tg\"]).apply(null,arguments)};var _crypto_stream_chacha20_keygen=Module[\"_crypto_stream_chacha20_keygen\"]=function(){return(_crypto_stream_chacha20_keygen=Module[\"_crypto_stream_chacha20_keygen\"]=Module[\"asm\"][\"ug\"]).apply(null,arguments)};var _crypto_stream_keybytes=Module[\"_crypto_stream_keybytes\"]=function(){return(_crypto_stream_keybytes=Module[\"_crypto_stream_keybytes\"]=Module[\"asm\"][\"vg\"]).apply(null,arguments)};var _crypto_stream_noncebytes=Module[\"_crypto_stream_noncebytes\"]=function(){return(_crypto_stream_noncebytes=Module[\"_crypto_stream_noncebytes\"]=Module[\"asm\"][\"wg\"]).apply(null,arguments)};var _crypto_stream_messagebytes_max=Module[\"_crypto_stream_messagebytes_max\"]=function(){return(_crypto_stream_messagebytes_max=Module[\"_crypto_stream_messagebytes_max\"]=Module[\"asm\"][\"xg\"]).apply(null,arguments)};var _crypto_stream_primitive=Module[\"_crypto_stream_primitive\"]=function(){return(_crypto_stream_primitive=Module[\"_crypto_stream_primitive\"]=Module[\"asm\"][\"yg\"]).apply(null,arguments)};var _crypto_stream=Module[\"_crypto_stream\"]=function(){return(_crypto_stream=Module[\"_crypto_stream\"]=Module[\"asm\"][\"zg\"]).apply(null,arguments)};var _crypto_stream_xor=Module[\"_crypto_stream_xor\"]=function(){return(_crypto_stream_xor=Module[\"_crypto_stream_xor\"]=Module[\"asm\"][\"Ag\"]).apply(null,arguments)};var _crypto_stream_keygen=Module[\"_crypto_stream_keygen\"]=function(){return(_crypto_stream_keygen=Module[\"_crypto_stream_keygen\"]=Module[\"asm\"][\"Bg\"]).apply(null,arguments)};var _crypto_stream_salsa20_keybytes=Module[\"_crypto_stream_salsa20_keybytes\"]=function(){return(_crypto_stream_salsa20_keybytes=Module[\"_crypto_stream_salsa20_keybytes\"]=Module[\"asm\"][\"Cg\"]).apply(null,arguments)};var _crypto_stream_salsa20_noncebytes=Module[\"_crypto_stream_salsa20_noncebytes\"]=function(){return(_crypto_stream_salsa20_noncebytes=Module[\"_crypto_stream_salsa20_noncebytes\"]=Module[\"asm\"][\"Dg\"]).apply(null,arguments)};var _crypto_stream_salsa20_messagebytes_max=Module[\"_crypto_stream_salsa20_messagebytes_max\"]=function(){return(_crypto_stream_salsa20_messagebytes_max=Module[\"_crypto_stream_salsa20_messagebytes_max\"]=Module[\"asm\"][\"Eg\"]).apply(null,arguments)};var _crypto_stream_salsa20=Module[\"_crypto_stream_salsa20\"]=function(){return(_crypto_stream_salsa20=Module[\"_crypto_stream_salsa20\"]=Module[\"asm\"][\"Fg\"]).apply(null,arguments)};var _crypto_stream_salsa20_xor_ic=Module[\"_crypto_stream_salsa20_xor_ic\"]=function(){return(_crypto_stream_salsa20_xor_ic=Module[\"_crypto_stream_salsa20_xor_ic\"]=Module[\"asm\"][\"Gg\"]).apply(null,arguments)};var _crypto_stream_salsa20_xor=Module[\"_crypto_stream_salsa20_xor\"]=function(){return(_crypto_stream_salsa20_xor=Module[\"_crypto_stream_salsa20_xor\"]=Module[\"asm\"][\"Hg\"]).apply(null,arguments)};var _crypto_stream_salsa20_keygen=Module[\"_crypto_stream_salsa20_keygen\"]=function(){return(_crypto_stream_salsa20_keygen=Module[\"_crypto_stream_salsa20_keygen\"]=Module[\"asm\"][\"Ig\"]).apply(null,arguments)};var _crypto_stream_xsalsa20=Module[\"_crypto_stream_xsalsa20\"]=function(){return(_crypto_stream_xsalsa20=Module[\"_crypto_stream_xsalsa20\"]=Module[\"asm\"][\"Jg\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_xor_ic=Module[\"_crypto_stream_xsalsa20_xor_ic\"]=function(){return(_crypto_stream_xsalsa20_xor_ic=Module[\"_crypto_stream_xsalsa20_xor_ic\"]=Module[\"asm\"][\"Kg\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_xor=Module[\"_crypto_stream_xsalsa20_xor\"]=function(){return(_crypto_stream_xsalsa20_xor=Module[\"_crypto_stream_xsalsa20_xor\"]=Module[\"asm\"][\"Lg\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_keybytes=Module[\"_crypto_stream_xsalsa20_keybytes\"]=function(){return(_crypto_stream_xsalsa20_keybytes=Module[\"_crypto_stream_xsalsa20_keybytes\"]=Module[\"asm\"][\"Mg\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_noncebytes=Module[\"_crypto_stream_xsalsa20_noncebytes\"]=function(){return(_crypto_stream_xsalsa20_noncebytes=Module[\"_crypto_stream_xsalsa20_noncebytes\"]=Module[\"asm\"][\"Ng\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_messagebytes_max=Module[\"_crypto_stream_xsalsa20_messagebytes_max\"]=function(){return(_crypto_stream_xsalsa20_messagebytes_max=Module[\"_crypto_stream_xsalsa20_messagebytes_max\"]=Module[\"asm\"][\"Og\"]).apply(null,arguments)};var _crypto_stream_xsalsa20_keygen=Module[\"_crypto_stream_xsalsa20_keygen\"]=function(){return(_crypto_stream_xsalsa20_keygen=Module[\"_crypto_stream_xsalsa20_keygen\"]=Module[\"asm\"][\"Pg\"]).apply(null,arguments)};var _crypto_verify_16_bytes=Module[\"_crypto_verify_16_bytes\"]=function(){return(_crypto_verify_16_bytes=Module[\"_crypto_verify_16_bytes\"]=Module[\"asm\"][\"Qg\"]).apply(null,arguments)};var _crypto_verify_32_bytes=Module[\"_crypto_verify_32_bytes\"]=function(){return(_crypto_verify_32_bytes=Module[\"_crypto_verify_32_bytes\"]=Module[\"asm\"][\"Rg\"]).apply(null,arguments)};var _crypto_verify_64_bytes=Module[\"_crypto_verify_64_bytes\"]=function(){return(_crypto_verify_64_bytes=Module[\"_crypto_verify_64_bytes\"]=Module[\"asm\"][\"Sg\"]).apply(null,arguments)};var _crypto_verify_16=Module[\"_crypto_verify_16\"]=function(){return(_crypto_verify_16=Module[\"_crypto_verify_16\"]=Module[\"asm\"][\"Tg\"]).apply(null,arguments)};var _crypto_verify_32=Module[\"_crypto_verify_32\"]=function(){return(_crypto_verify_32=Module[\"_crypto_verify_32\"]=Module[\"asm\"][\"Ug\"]).apply(null,arguments)};var _crypto_verify_64=Module[\"_crypto_verify_64\"]=function(){return(_crypto_verify_64=Module[\"_crypto_verify_64\"]=Module[\"asm\"][\"Vg\"]).apply(null,arguments)};var _randombytes_implementation_name=Module[\"_randombytes_implementation_name\"]=function(){return(_randombytes_implementation_name=Module[\"_randombytes_implementation_name\"]=Module[\"asm\"][\"Wg\"]).apply(null,arguments)};var _randombytes_random=Module[\"_randombytes_random\"]=function(){return(_randombytes_random=Module[\"_randombytes_random\"]=Module[\"asm\"][\"Xg\"]).apply(null,arguments)};var _randombytes_stir=Module[\"_randombytes_stir\"]=function(){return(_randombytes_stir=Module[\"_randombytes_stir\"]=Module[\"asm\"][\"Yg\"]).apply(null,arguments)};var _randombytes_uniform=Module[\"_randombytes_uniform\"]=function(){return(_randombytes_uniform=Module[\"_randombytes_uniform\"]=Module[\"asm\"][\"Zg\"]).apply(null,arguments)};var _randombytes_buf=Module[\"_randombytes_buf\"]=function(){return(_randombytes_buf=Module[\"_randombytes_buf\"]=Module[\"asm\"][\"_g\"]).apply(null,arguments)};var _randombytes_buf_deterministic=Module[\"_randombytes_buf_deterministic\"]=function(){return(_randombytes_buf_deterministic=Module[\"_randombytes_buf_deterministic\"]=Module[\"asm\"][\"$g\"]).apply(null,arguments)};var _randombytes_seedbytes=Module[\"_randombytes_seedbytes\"]=function(){return(_randombytes_seedbytes=Module[\"_randombytes_seedbytes\"]=Module[\"asm\"][\"ah\"]).apply(null,arguments)};var _randombytes_close=Module[\"_randombytes_close\"]=function(){return(_randombytes_close=Module[\"_randombytes_close\"]=Module[\"asm\"][\"bh\"]).apply(null,arguments)};var _randombytes=Module[\"_randombytes\"]=function(){return(_randombytes=Module[\"_randombytes\"]=Module[\"asm\"][\"ch\"]).apply(null,arguments)};var _sodium_bin2hex=Module[\"_sodium_bin2hex\"]=function(){return(_sodium_bin2hex=Module[\"_sodium_bin2hex\"]=Module[\"asm\"][\"dh\"]).apply(null,arguments)};var _sodium_hex2bin=Module[\"_sodium_hex2bin\"]=function(){return(_sodium_hex2bin=Module[\"_sodium_hex2bin\"]=Module[\"asm\"][\"eh\"]).apply(null,arguments)};var _sodium_base64_encoded_len=Module[\"_sodium_base64_encoded_len\"]=function(){return(_sodium_base64_encoded_len=Module[\"_sodium_base64_encoded_len\"]=Module[\"asm\"][\"fh\"]).apply(null,arguments)};var _sodium_bin2base64=Module[\"_sodium_bin2base64\"]=function(){return(_sodium_bin2base64=Module[\"_sodium_bin2base64\"]=Module[\"asm\"][\"gh\"]).apply(null,arguments)};var _sodium_base642bin=Module[\"_sodium_base642bin\"]=function(){return(_sodium_base642bin=Module[\"_sodium_base642bin\"]=Module[\"asm\"][\"hh\"]).apply(null,arguments)};var _sodium_init=Module[\"_sodium_init\"]=function(){return(_sodium_init=Module[\"_sodium_init\"]=Module[\"asm\"][\"ih\"]).apply(null,arguments)};var _sodium_pad=Module[\"_sodium_pad\"]=function(){return(_sodium_pad=Module[\"_sodium_pad\"]=Module[\"asm\"][\"jh\"]).apply(null,arguments)};var _sodium_unpad=Module[\"_sodium_unpad\"]=function(){return(_sodium_unpad=Module[\"_sodium_unpad\"]=Module[\"asm\"][\"kh\"]).apply(null,arguments)};var _sodium_version_string=Module[\"_sodium_version_string\"]=function(){return(_sodium_version_string=Module[\"_sodium_version_string\"]=Module[\"asm\"][\"lh\"]).apply(null,arguments)};var _sodium_library_version_major=Module[\"_sodium_library_version_major\"]=function(){return(_sodium_library_version_major=Module[\"_sodium_library_version_major\"]=Module[\"asm\"][\"mh\"]).apply(null,arguments)};var _sodium_library_version_minor=Module[\"_sodium_library_version_minor\"]=function(){return(_sodium_library_version_minor=Module[\"_sodium_library_version_minor\"]=Module[\"asm\"][\"nh\"]).apply(null,arguments)};var _sodium_library_minimal=Module[\"_sodium_library_minimal\"]=function(){return(_sodium_library_minimal=Module[\"_sodium_library_minimal\"]=Module[\"asm\"][\"oh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_seed_keypair\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seed_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_seed_keypair\"]=Module[\"asm\"][\"ph\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_keypair\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_keypair=Module[\"_crypto_box_curve25519xchacha20poly1305_keypair\"]=Module[\"asm\"][\"qh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_beforenm=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_beforenm=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenm\"]=Module[\"asm\"][\"rh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_detached_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_detached_afternm\"]=Module[\"asm\"][\"sh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_detached\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_detached\"]=Module[\"asm\"][\"th\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_easy_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_easy_afternm\"]=Module[\"asm\"][\"uh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_easy\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_easy\"]=Module[\"asm\"][\"vh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_detached_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached_afternm\"]=Module[\"asm\"][\"wh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_detached=Module[\"_crypto_box_curve25519xchacha20poly1305_open_detached\"]=Module[\"asm\"][\"xh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy_afternm\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_easy_afternm=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy_afternm\"]=Module[\"asm\"][\"yh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_open_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_open_easy=Module[\"_crypto_box_curve25519xchacha20poly1305_open_easy\"]=Module[\"asm\"][\"zh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seedbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_seedbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seedbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_seedbytes\"]=Module[\"asm\"][\"Ah\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_publickeybytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_publickeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_publickeybytes\"]=Module[\"asm\"][\"Bh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_secretkeybytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_secretkeybytes=Module[\"_crypto_box_curve25519xchacha20poly1305_secretkeybytes\"]=Module[\"asm\"][\"Ch\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenmbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_beforenmbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_beforenmbytes\"]=Module[\"asm\"][\"Dh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_noncebytes=Module[\"_crypto_box_curve25519xchacha20poly1305_noncebytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_noncebytes=Module[\"_crypto_box_curve25519xchacha20poly1305_noncebytes\"]=Module[\"asm\"][\"Eh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_macbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_macbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_macbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_macbytes\"]=Module[\"asm\"][\"Fh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xchacha20poly1305_messagebytes_max\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_messagebytes_max=Module[\"_crypto_box_curve25519xchacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"Gh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seal=Module[\"_crypto_box_curve25519xchacha20poly1305_seal\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seal=Module[\"_crypto_box_curve25519xchacha20poly1305_seal\"]=Module[\"asm\"][\"Hh\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_seal_open=Module[\"_crypto_box_curve25519xchacha20poly1305_seal_open\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_seal_open=Module[\"_crypto_box_curve25519xchacha20poly1305_seal_open\"]=Module[\"asm\"][\"Ih\"]).apply(null,arguments)};var _crypto_box_curve25519xchacha20poly1305_sealbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_sealbytes\"]=function(){return(_crypto_box_curve25519xchacha20poly1305_sealbytes=Module[\"_crypto_box_curve25519xchacha20poly1305_sealbytes\"]=Module[\"asm\"][\"Jh\"]).apply(null,arguments)};var _crypto_core_ed25519_is_valid_point=Module[\"_crypto_core_ed25519_is_valid_point\"]=function(){return(_crypto_core_ed25519_is_valid_point=Module[\"_crypto_core_ed25519_is_valid_point\"]=Module[\"asm\"][\"Kh\"]).apply(null,arguments)};var _crypto_core_ed25519_add=Module[\"_crypto_core_ed25519_add\"]=function(){return(_crypto_core_ed25519_add=Module[\"_crypto_core_ed25519_add\"]=Module[\"asm\"][\"Lh\"]).apply(null,arguments)};var _crypto_core_ed25519_sub=Module[\"_crypto_core_ed25519_sub\"]=function(){return(_crypto_core_ed25519_sub=Module[\"_crypto_core_ed25519_sub\"]=Module[\"asm\"][\"Mh\"]).apply(null,arguments)};var _crypto_core_ed25519_from_uniform=Module[\"_crypto_core_ed25519_from_uniform\"]=function(){return(_crypto_core_ed25519_from_uniform=Module[\"_crypto_core_ed25519_from_uniform\"]=Module[\"asm\"][\"Nh\"]).apply(null,arguments)};var _crypto_core_ed25519_from_hash=Module[\"_crypto_core_ed25519_from_hash\"]=function(){return(_crypto_core_ed25519_from_hash=Module[\"_crypto_core_ed25519_from_hash\"]=Module[\"asm\"][\"Oh\"]).apply(null,arguments)};var _crypto_core_ed25519_random=Module[\"_crypto_core_ed25519_random\"]=function(){return(_crypto_core_ed25519_random=Module[\"_crypto_core_ed25519_random\"]=Module[\"asm\"][\"Ph\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_random=Module[\"_crypto_core_ed25519_scalar_random\"]=function(){return(_crypto_core_ed25519_scalar_random=Module[\"_crypto_core_ed25519_scalar_random\"]=Module[\"asm\"][\"Qh\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_invert=Module[\"_crypto_core_ed25519_scalar_invert\"]=function(){return(_crypto_core_ed25519_scalar_invert=Module[\"_crypto_core_ed25519_scalar_invert\"]=Module[\"asm\"][\"Rh\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_negate=Module[\"_crypto_core_ed25519_scalar_negate\"]=function(){return(_crypto_core_ed25519_scalar_negate=Module[\"_crypto_core_ed25519_scalar_negate\"]=Module[\"asm\"][\"Sh\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_complement=Module[\"_crypto_core_ed25519_scalar_complement\"]=function(){return(_crypto_core_ed25519_scalar_complement=Module[\"_crypto_core_ed25519_scalar_complement\"]=Module[\"asm\"][\"Th\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_add=Module[\"_crypto_core_ed25519_scalar_add\"]=function(){return(_crypto_core_ed25519_scalar_add=Module[\"_crypto_core_ed25519_scalar_add\"]=Module[\"asm\"][\"Uh\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_reduce=Module[\"_crypto_core_ed25519_scalar_reduce\"]=function(){return(_crypto_core_ed25519_scalar_reduce=Module[\"_crypto_core_ed25519_scalar_reduce\"]=Module[\"asm\"][\"Vh\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_sub=Module[\"_crypto_core_ed25519_scalar_sub\"]=function(){return(_crypto_core_ed25519_scalar_sub=Module[\"_crypto_core_ed25519_scalar_sub\"]=Module[\"asm\"][\"Wh\"]).apply(null,arguments)};var _crypto_core_ed25519_scalar_mul=Module[\"_crypto_core_ed25519_scalar_mul\"]=function(){return(_crypto_core_ed25519_scalar_mul=Module[\"_crypto_core_ed25519_scalar_mul\"]=Module[\"asm\"][\"Xh\"]).apply(null,arguments)};var _crypto_core_ed25519_bytes=Module[\"_crypto_core_ed25519_bytes\"]=function(){return(_crypto_core_ed25519_bytes=Module[\"_crypto_core_ed25519_bytes\"]=Module[\"asm\"][\"Yh\"]).apply(null,arguments)};var _crypto_core_ed25519_nonreducedscalarbytes=Module[\"_crypto_core_ed25519_nonreducedscalarbytes\"]=function(){return(_crypto_core_ed25519_nonreducedscalarbytes=Module[\"_crypto_core_ed25519_nonreducedscalarbytes\"]=Module[\"asm\"][\"Zh\"]).apply(null,arguments)};var _crypto_core_ed25519_uniformbytes=Module[\"_crypto_core_ed25519_uniformbytes\"]=function(){return(_crypto_core_ed25519_uniformbytes=Module[\"_crypto_core_ed25519_uniformbytes\"]=Module[\"asm\"][\"_h\"]).apply(null,arguments)};var _crypto_core_ed25519_hashbytes=Module[\"_crypto_core_ed25519_hashbytes\"]=function(){return(_crypto_core_ed25519_hashbytes=Module[\"_crypto_core_ed25519_hashbytes\"]=Module[\"asm\"][\"$h\"]).apply(null,arguments)};var _crypto_core_ed25519_scalarbytes=Module[\"_crypto_core_ed25519_scalarbytes\"]=function(){return(_crypto_core_ed25519_scalarbytes=Module[\"_crypto_core_ed25519_scalarbytes\"]=Module[\"asm\"][\"ai\"]).apply(null,arguments)};var _crypto_core_ristretto255_is_valid_point=Module[\"_crypto_core_ristretto255_is_valid_point\"]=function(){return(_crypto_core_ristretto255_is_valid_point=Module[\"_crypto_core_ristretto255_is_valid_point\"]=Module[\"asm\"][\"bi\"]).apply(null,arguments)};var _crypto_core_ristretto255_add=Module[\"_crypto_core_ristretto255_add\"]=function(){return(_crypto_core_ristretto255_add=Module[\"_crypto_core_ristretto255_add\"]=Module[\"asm\"][\"ci\"]).apply(null,arguments)};var _crypto_core_ristretto255_sub=Module[\"_crypto_core_ristretto255_sub\"]=function(){return(_crypto_core_ristretto255_sub=Module[\"_crypto_core_ristretto255_sub\"]=Module[\"asm\"][\"di\"]).apply(null,arguments)};var _crypto_core_ristretto255_from_hash=Module[\"_crypto_core_ristretto255_from_hash\"]=function(){return(_crypto_core_ristretto255_from_hash=Module[\"_crypto_core_ristretto255_from_hash\"]=Module[\"asm\"][\"ei\"]).apply(null,arguments)};var _crypto_core_ristretto255_random=Module[\"_crypto_core_ristretto255_random\"]=function(){return(_crypto_core_ristretto255_random=Module[\"_crypto_core_ristretto255_random\"]=Module[\"asm\"][\"fi\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_random=Module[\"_crypto_core_ristretto255_scalar_random\"]=function(){return(_crypto_core_ristretto255_scalar_random=Module[\"_crypto_core_ristretto255_scalar_random\"]=Module[\"asm\"][\"gi\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_invert=Module[\"_crypto_core_ristretto255_scalar_invert\"]=function(){return(_crypto_core_ristretto255_scalar_invert=Module[\"_crypto_core_ristretto255_scalar_invert\"]=Module[\"asm\"][\"hi\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_negate=Module[\"_crypto_core_ristretto255_scalar_negate\"]=function(){return(_crypto_core_ristretto255_scalar_negate=Module[\"_crypto_core_ristretto255_scalar_negate\"]=Module[\"asm\"][\"ii\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_complement=Module[\"_crypto_core_ristretto255_scalar_complement\"]=function(){return(_crypto_core_ristretto255_scalar_complement=Module[\"_crypto_core_ristretto255_scalar_complement\"]=Module[\"asm\"][\"ji\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_add=Module[\"_crypto_core_ristretto255_scalar_add\"]=function(){return(_crypto_core_ristretto255_scalar_add=Module[\"_crypto_core_ristretto255_scalar_add\"]=Module[\"asm\"][\"ki\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_sub=Module[\"_crypto_core_ristretto255_scalar_sub\"]=function(){return(_crypto_core_ristretto255_scalar_sub=Module[\"_crypto_core_ristretto255_scalar_sub\"]=Module[\"asm\"][\"li\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_mul=Module[\"_crypto_core_ristretto255_scalar_mul\"]=function(){return(_crypto_core_ristretto255_scalar_mul=Module[\"_crypto_core_ristretto255_scalar_mul\"]=Module[\"asm\"][\"mi\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalar_reduce=Module[\"_crypto_core_ristretto255_scalar_reduce\"]=function(){return(_crypto_core_ristretto255_scalar_reduce=Module[\"_crypto_core_ristretto255_scalar_reduce\"]=Module[\"asm\"][\"ni\"]).apply(null,arguments)};var _crypto_core_ristretto255_bytes=Module[\"_crypto_core_ristretto255_bytes\"]=function(){return(_crypto_core_ristretto255_bytes=Module[\"_crypto_core_ristretto255_bytes\"]=Module[\"asm\"][\"oi\"]).apply(null,arguments)};var _crypto_core_ristretto255_nonreducedscalarbytes=Module[\"_crypto_core_ristretto255_nonreducedscalarbytes\"]=function(){return(_crypto_core_ristretto255_nonreducedscalarbytes=Module[\"_crypto_core_ristretto255_nonreducedscalarbytes\"]=Module[\"asm\"][\"pi\"]).apply(null,arguments)};var _crypto_core_ristretto255_hashbytes=Module[\"_crypto_core_ristretto255_hashbytes\"]=function(){return(_crypto_core_ristretto255_hashbytes=Module[\"_crypto_core_ristretto255_hashbytes\"]=Module[\"asm\"][\"qi\"]).apply(null,arguments)};var _crypto_core_ristretto255_scalarbytes=Module[\"_crypto_core_ristretto255_scalarbytes\"]=function(){return(_crypto_core_ristretto255_scalarbytes=Module[\"_crypto_core_ristretto255_scalarbytes\"]=Module[\"asm\"][\"ri\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_ll=Module[\"_crypto_pwhash_scryptsalsa208sha256_ll\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_ll=Module[\"_crypto_pwhash_scryptsalsa208sha256_ll\"]=Module[\"asm\"][\"si\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_bytes_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_bytes_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_min\"]=Module[\"asm\"][\"ti\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_bytes_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_bytes_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_bytes_max\"]=Module[\"asm\"][\"ui\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_passwd_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_passwd_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_min\"]=Module[\"asm\"][\"vi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_passwd_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_passwd_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_passwd_max\"]=Module[\"asm\"][\"wi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_saltbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_saltbytes\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_saltbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_saltbytes\"]=Module[\"asm\"][\"xi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_strbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_strbytes\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_strbytes=Module[\"_crypto_pwhash_scryptsalsa208sha256_strbytes\"]=Module[\"asm\"][\"yi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_strprefix=Module[\"_crypto_pwhash_scryptsalsa208sha256_strprefix\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_strprefix=Module[\"_crypto_pwhash_scryptsalsa208sha256_strprefix\"]=Module[\"asm\"][\"zi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_min\"]=Module[\"asm\"][\"Ai\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_max\"]=Module[\"asm\"][\"Bi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_min\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_min=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_min\"]=Module[\"asm\"][\"Ci\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_max\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_max=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_max\"]=Module[\"asm\"][\"Di\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_interactive\"]=Module[\"asm\"][\"Ei\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_interactive\"]=Module[\"asm\"][\"Fi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_opslimit_sensitive\"]=Module[\"asm\"][\"Gi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive=Module[\"_crypto_pwhash_scryptsalsa208sha256_memlimit_sensitive\"]=Module[\"asm\"][\"Hi\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256=Module[\"_crypto_pwhash_scryptsalsa208sha256\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256=Module[\"_crypto_pwhash_scryptsalsa208sha256\"]=Module[\"asm\"][\"Ii\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_str=Module[\"_crypto_pwhash_scryptsalsa208sha256_str\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_str=Module[\"_crypto_pwhash_scryptsalsa208sha256_str\"]=Module[\"asm\"][\"Ji\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_str_verify=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_verify\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_str_verify=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_verify\"]=Module[\"asm\"][\"Ki\"]).apply(null,arguments)};var _crypto_pwhash_scryptsalsa208sha256_str_needs_rehash=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_needs_rehash\"]=function(){return(_crypto_pwhash_scryptsalsa208sha256_str_needs_rehash=Module[\"_crypto_pwhash_scryptsalsa208sha256_str_needs_rehash\"]=Module[\"asm\"][\"Li\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519=Module[\"_crypto_scalarmult_ed25519\"]=function(){return(_crypto_scalarmult_ed25519=Module[\"_crypto_scalarmult_ed25519\"]=Module[\"asm\"][\"Mi\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_noclamp=Module[\"_crypto_scalarmult_ed25519_noclamp\"]=function(){return(_crypto_scalarmult_ed25519_noclamp=Module[\"_crypto_scalarmult_ed25519_noclamp\"]=Module[\"asm\"][\"Ni\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_base=Module[\"_crypto_scalarmult_ed25519_base\"]=function(){return(_crypto_scalarmult_ed25519_base=Module[\"_crypto_scalarmult_ed25519_base\"]=Module[\"asm\"][\"Oi\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_base_noclamp=Module[\"_crypto_scalarmult_ed25519_base_noclamp\"]=function(){return(_crypto_scalarmult_ed25519_base_noclamp=Module[\"_crypto_scalarmult_ed25519_base_noclamp\"]=Module[\"asm\"][\"Pi\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_bytes=Module[\"_crypto_scalarmult_ed25519_bytes\"]=function(){return(_crypto_scalarmult_ed25519_bytes=Module[\"_crypto_scalarmult_ed25519_bytes\"]=Module[\"asm\"][\"Qi\"]).apply(null,arguments)};var _crypto_scalarmult_ed25519_scalarbytes=Module[\"_crypto_scalarmult_ed25519_scalarbytes\"]=function(){return(_crypto_scalarmult_ed25519_scalarbytes=Module[\"_crypto_scalarmult_ed25519_scalarbytes\"]=Module[\"asm\"][\"Ri\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255=Module[\"_crypto_scalarmult_ristretto255\"]=function(){return(_crypto_scalarmult_ristretto255=Module[\"_crypto_scalarmult_ristretto255\"]=Module[\"asm\"][\"Si\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255_base=Module[\"_crypto_scalarmult_ristretto255_base\"]=function(){return(_crypto_scalarmult_ristretto255_base=Module[\"_crypto_scalarmult_ristretto255_base\"]=Module[\"asm\"][\"Ti\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255_bytes=Module[\"_crypto_scalarmult_ristretto255_bytes\"]=function(){return(_crypto_scalarmult_ristretto255_bytes=Module[\"_crypto_scalarmult_ristretto255_bytes\"]=Module[\"asm\"][\"Ui\"]).apply(null,arguments)};var _crypto_scalarmult_ristretto255_scalarbytes=Module[\"_crypto_scalarmult_ristretto255_scalarbytes\"]=function(){return(_crypto_scalarmult_ristretto255_scalarbytes=Module[\"_crypto_scalarmult_ristretto255_scalarbytes\"]=Module[\"asm\"][\"Vi\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_detached=Module[\"_crypto_secretbox_xchacha20poly1305_detached\"]=function(){return(_crypto_secretbox_xchacha20poly1305_detached=Module[\"_crypto_secretbox_xchacha20poly1305_detached\"]=Module[\"asm\"][\"Wi\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_easy=Module[\"_crypto_secretbox_xchacha20poly1305_easy\"]=function(){return(_crypto_secretbox_xchacha20poly1305_easy=Module[\"_crypto_secretbox_xchacha20poly1305_easy\"]=Module[\"asm\"][\"Xi\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_open_detached=Module[\"_crypto_secretbox_xchacha20poly1305_open_detached\"]=function(){return(_crypto_secretbox_xchacha20poly1305_open_detached=Module[\"_crypto_secretbox_xchacha20poly1305_open_detached\"]=Module[\"asm\"][\"Yi\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_open_easy=Module[\"_crypto_secretbox_xchacha20poly1305_open_easy\"]=function(){return(_crypto_secretbox_xchacha20poly1305_open_easy=Module[\"_crypto_secretbox_xchacha20poly1305_open_easy\"]=Module[\"asm\"][\"Zi\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_keybytes=Module[\"_crypto_secretbox_xchacha20poly1305_keybytes\"]=function(){return(_crypto_secretbox_xchacha20poly1305_keybytes=Module[\"_crypto_secretbox_xchacha20poly1305_keybytes\"]=Module[\"asm\"][\"_i\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_noncebytes=Module[\"_crypto_secretbox_xchacha20poly1305_noncebytes\"]=function(){return(_crypto_secretbox_xchacha20poly1305_noncebytes=Module[\"_crypto_secretbox_xchacha20poly1305_noncebytes\"]=Module[\"asm\"][\"$i\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_macbytes=Module[\"_crypto_secretbox_xchacha20poly1305_macbytes\"]=function(){return(_crypto_secretbox_xchacha20poly1305_macbytes=Module[\"_crypto_secretbox_xchacha20poly1305_macbytes\"]=Module[\"asm\"][\"aj\"]).apply(null,arguments)};var _crypto_secretbox_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xchacha20poly1305_messagebytes_max\"]=function(){return(_crypto_secretbox_xchacha20poly1305_messagebytes_max=Module[\"_crypto_secretbox_xchacha20poly1305_messagebytes_max\"]=Module[\"asm\"][\"bj\"]).apply(null,arguments)};var _crypto_shorthash_siphashx24_bytes=Module[\"_crypto_shorthash_siphashx24_bytes\"]=function(){return(_crypto_shorthash_siphashx24_bytes=Module[\"_crypto_shorthash_siphashx24_bytes\"]=Module[\"asm\"][\"cj\"]).apply(null,arguments)};var _crypto_shorthash_siphashx24_keybytes=Module[\"_crypto_shorthash_siphashx24_keybytes\"]=function(){return(_crypto_shorthash_siphashx24_keybytes=Module[\"_crypto_shorthash_siphashx24_keybytes\"]=Module[\"asm\"][\"dj\"]).apply(null,arguments)};var _crypto_shorthash_siphashx24=Module[\"_crypto_shorthash_siphashx24\"]=function(){return(_crypto_shorthash_siphashx24=Module[\"_crypto_shorthash_siphashx24\"]=Module[\"asm\"][\"ej\"]).apply(null,arguments)};var _crypto_stream_salsa2012=Module[\"_crypto_stream_salsa2012\"]=function(){return(_crypto_stream_salsa2012=Module[\"_crypto_stream_salsa2012\"]=Module[\"asm\"][\"fj\"]).apply(null,arguments)};var _crypto_stream_salsa2012_xor=Module[\"_crypto_stream_salsa2012_xor\"]=function(){return(_crypto_stream_salsa2012_xor=Module[\"_crypto_stream_salsa2012_xor\"]=Module[\"asm\"][\"gj\"]).apply(null,arguments)};var _crypto_stream_salsa2012_keybytes=Module[\"_crypto_stream_salsa2012_keybytes\"]=function(){return(_crypto_stream_salsa2012_keybytes=Module[\"_crypto_stream_salsa2012_keybytes\"]=Module[\"asm\"][\"hj\"]).apply(null,arguments)};var _crypto_stream_salsa2012_noncebytes=Module[\"_crypto_stream_salsa2012_noncebytes\"]=function(){return(_crypto_stream_salsa2012_noncebytes=Module[\"_crypto_stream_salsa2012_noncebytes\"]=Module[\"asm\"][\"ij\"]).apply(null,arguments)};var _crypto_stream_salsa2012_messagebytes_max=Module[\"_crypto_stream_salsa2012_messagebytes_max\"]=function(){return(_crypto_stream_salsa2012_messagebytes_max=Module[\"_crypto_stream_salsa2012_messagebytes_max\"]=Module[\"asm\"][\"jj\"]).apply(null,arguments)};var _crypto_stream_salsa2012_keygen=Module[\"_crypto_stream_salsa2012_keygen\"]=function(){return(_crypto_stream_salsa2012_keygen=Module[\"_crypto_stream_salsa2012_keygen\"]=Module[\"asm\"][\"kj\"]).apply(null,arguments)};var _crypto_stream_salsa208=Module[\"_crypto_stream_salsa208\"]=function(){return(_crypto_stream_salsa208=Module[\"_crypto_stream_salsa208\"]=Module[\"asm\"][\"lj\"]).apply(null,arguments)};var _crypto_stream_salsa208_xor=Module[\"_crypto_stream_salsa208_xor\"]=function(){return(_crypto_stream_salsa208_xor=Module[\"_crypto_stream_salsa208_xor\"]=Module[\"asm\"][\"mj\"]).apply(null,arguments)};var _crypto_stream_salsa208_keybytes=Module[\"_crypto_stream_salsa208_keybytes\"]=function(){return(_crypto_stream_salsa208_keybytes=Module[\"_crypto_stream_salsa208_keybytes\"]=Module[\"asm\"][\"nj\"]).apply(null,arguments)};var _crypto_stream_salsa208_noncebytes=Module[\"_crypto_stream_salsa208_noncebytes\"]=function(){return(_crypto_stream_salsa208_noncebytes=Module[\"_crypto_stream_salsa208_noncebytes\"]=Module[\"asm\"][\"oj\"]).apply(null,arguments)};var _crypto_stream_salsa208_messagebytes_max=Module[\"_crypto_stream_salsa208_messagebytes_max\"]=function(){return(_crypto_stream_salsa208_messagebytes_max=Module[\"_crypto_stream_salsa208_messagebytes_max\"]=Module[\"asm\"][\"pj\"]).apply(null,arguments)};var _crypto_stream_salsa208_keygen=Module[\"_crypto_stream_salsa208_keygen\"]=function(){return(_crypto_stream_salsa208_keygen=Module[\"_crypto_stream_salsa208_keygen\"]=Module[\"asm\"][\"qj\"]).apply(null,arguments)};var _crypto_stream_xchacha20_keybytes=Module[\"_crypto_stream_xchacha20_keybytes\"]=function(){return(_crypto_stream_xchacha20_keybytes=Module[\"_crypto_stream_xchacha20_keybytes\"]=Module[\"asm\"][\"rj\"]).apply(null,arguments)};var _crypto_stream_xchacha20_noncebytes=Module[\"_crypto_stream_xchacha20_noncebytes\"]=function(){return(_crypto_stream_xchacha20_noncebytes=Module[\"_crypto_stream_xchacha20_noncebytes\"]=Module[\"asm\"][\"sj\"]).apply(null,arguments)};var _crypto_stream_xchacha20_messagebytes_max=Module[\"_crypto_stream_xchacha20_messagebytes_max\"]=function(){return(_crypto_stream_xchacha20_messagebytes_max=Module[\"_crypto_stream_xchacha20_messagebytes_max\"]=Module[\"asm\"][\"tj\"]).apply(null,arguments)};var _crypto_stream_xchacha20=Module[\"_crypto_stream_xchacha20\"]=function(){return(_crypto_stream_xchacha20=Module[\"_crypto_stream_xchacha20\"]=Module[\"asm\"][\"uj\"]).apply(null,arguments)};var _crypto_stream_xchacha20_xor_ic=Module[\"_crypto_stream_xchacha20_xor_ic\"]=function(){return(_crypto_stream_xchacha20_xor_ic=Module[\"_crypto_stream_xchacha20_xor_ic\"]=Module[\"asm\"][\"vj\"]).apply(null,arguments)};var _crypto_stream_xchacha20_xor=Module[\"_crypto_stream_xchacha20_xor\"]=function(){return(_crypto_stream_xchacha20_xor=Module[\"_crypto_stream_xchacha20_xor\"]=Module[\"asm\"][\"wj\"]).apply(null,arguments)};var _crypto_stream_xchacha20_keygen=Module[\"_crypto_stream_xchacha20_keygen\"]=function(){return(_crypto_stream_xchacha20_keygen=Module[\"_crypto_stream_xchacha20_keygen\"]=Module[\"asm\"][\"xj\"]).apply(null,arguments)};var _malloc=Module[\"_malloc\"]=function(){return(_malloc=Module[\"_malloc\"]=Module[\"asm\"][\"yj\"]).apply(null,arguments)};var _free=Module[\"_free\"]=function(){return(_free=Module[\"_free\"]=Module[\"asm\"][\"zj\"]).apply(null,arguments)};Module[\"setValue\"]=setValue;Module[\"getValue\"]=getValue;Module[\"UTF8ToString\"]=UTF8ToString;var calledRun;dependenciesFulfilled=function runCaller(){if(!calledRun)run();if(!calledRun)dependenciesFulfilled=runCaller};function run(args){args=args||arguments_;if(runDependencies>0){return}preRun();if(runDependencies>0)return;function doRun(){if(calledRun)return;calledRun=true;Module[\"calledRun\"]=true;if(ABORT)return;initRuntime();preMain();if(Module[\"onRuntimeInitialized\"])Module[\"onRuntimeInitialized\"]();postRun()}if(Module[\"setStatus\"]){Module[\"setStatus\"](\"Running...\");setTimeout(function(){setTimeout(function(){Module[\"setStatus\"](\"\")},1);doRun()},1)}else{doRun()}}Module[\"run\"]=run;if(Module[\"preInit\"]){if(typeof Module[\"preInit\"]==\"function\")Module[\"preInit\"]=[Module[\"preInit\"]];while(Module[\"preInit\"].length>0){Module[\"preInit\"].pop()()}}noExitRuntime=true;run();\n    }).catch(function() {\n      return _Module.useBackupModule();\n    });\nfunction nacl_cooked(nacl_raw) {\n  'use strict';\n  var exports = {};\n\n  //---------------------------------------------------------------------------\n  // Horrifying UTF-8 and hex codecs\n\n  function encode_utf8(s) {\n    return encode_latin1(unescape(encodeURIComponent(s)));\n  }\n\n  function encode_latin1(s) {\n    var result = new Uint8Array(s.length);\n    for (var i = 0; i < s.length; i++) {\n      var c = s.charCodeAt(i);\n      if ((c & 0xff) !== c) throw {message: \"Cannot encode string in Latin1\", str: s};\n      result[i] = (c & 0xff);\n    }\n    return result;\n  }\n\n  function decode_utf8(bs) {\n    return decodeURIComponent(escape(decode_latin1(bs)));\n  }\n\n  function decode_latin1(bs) {\n    var encoded = [];\n    for (var i = 0; i < bs.length; i++) {\n      encoded.push(String.fromCharCode(bs[i]));\n    }\n    return encoded.join('');\n  }\n\n  function to_hex(bs) {\n    var encoded = [];\n    for (var i = 0; i < bs.length; i++) {\n      encoded.push(\"0123456789abcdef\"[(bs[i] >> 4) & 15]);\n      encoded.push(\"0123456789abcdef\"[bs[i] & 15]);\n    }\n    return encoded.join('');\n  }\n\n  function from_hex(s) {\n    var result = new Uint8Array(s.length / 2);\n    for (var i = 0; i < s.length / 2; i++) {\n      result[i] = parseInt(s.substr(2*i,2),16);\n    }\n    return result;\n  }\n\n  //---------------------------------------------------------------------------\n  // Allocation\n\n  function MALLOC(nbytes) {\n    var result = nacl_raw._malloc(nbytes);\n    if (result === 0) {\n      throw {message: \"malloc() failed\", nbytes: nbytes};\n    }\n    return result;\n  }\n\n  function FREE(pointer) {\n    nacl_raw._free(pointer);\n  }\n\n  //---------------------------------------------------------------------------\n\n  function injectBytes(bs, leftPadding) {\n    var p = leftPadding || 0;\n    var address = MALLOC(bs.length + p);\n    nacl_raw.HEAPU8.set(bs, address + p);\n    for (var i = address; i < address + p; i++) {\n      nacl_raw.HEAPU8[i] = 0;\n    }\n    return address;\n  }\n\n  function check_injectBytes(function_name, what, thing, expected_length, leftPadding) {\n    check_length(function_name, what, thing, expected_length);\n    return injectBytes(thing, leftPadding);\n  }\n\n  function extractBytes(address, length) {\n    var result = new Uint8Array(length);\n    result.set(nacl_raw.HEAPU8.subarray(address, address + length));\n    return result;\n  }\n\n  //---------------------------------------------------------------------------\n\n  function check(function_name, result) {\n    if (result !== 0) {\n      throw {message: \"nacl_raw.\" + function_name + \" signalled an error\"};\n    }\n  }\n\n  function check_length(function_name, what, thing, expected_length) {\n    if (thing.length !== expected_length) {\n      throw {message: \"nacl.\" + function_name + \" expected \" +\n\t     expected_length + \"-byte \" + what + \" but got length \" + thing.length};\n    }\n  }\n\n  function Target(length) {\n    this.length = length;\n    this.address = MALLOC(length);\n  }\n\n  Target.prototype.extractBytes = function (offset) {\n    var result = extractBytes(this.address + (offset || 0), this.length - (offset || 0));\n    FREE(this.address);\n    this.address = null;\n    return result;\n  };\n\n  function free_all(addresses) {\n    for (var i = 0; i < addresses.length; i++) {\n      FREE(addresses[i]);\n    }\n  }\n\n  //---------------------------------------------------------------------------\n  // Randomness\n\n  function random_bytes(count) {\n    var bs = new Target(count);\n    nacl_raw._randombytes_buf(bs.address, count);\n    return bs.extractBytes();\n  }\n\n  nacl_raw._randombytes_stir();\n\n  //---------------------------------------------------------------------------\n  // Boxing\n\n  function crypto_box_keypair() {\n    var pk = new Target(nacl_raw._crypto_box_publickeybytes());\n    var sk = new Target(nacl_raw._crypto_box_secretkeybytes());\n    check(\"_crypto_box_keypair\", nacl_raw._crypto_box_keypair(pk.address, sk.address));\n    return {boxPk: pk.extractBytes(), boxSk: sk.extractBytes()};\n  }\n\n  function crypto_box_random_nonce() {\n    return random_bytes(nacl_raw._crypto_box_noncebytes());\n  }\n\n  function crypto_box(msg, nonce, pk, sk) {\n    var m = injectBytes(msg, nacl_raw._crypto_box_zerobytes());\n    var na = check_injectBytes(\"crypto_box\", \"nonce\", nonce, nacl_raw._crypto_box_noncebytes());\n    var pka = check_injectBytes(\"crypto_box\", \"pk\", pk, nacl_raw._crypto_box_publickeybytes());\n    var ska = check_injectBytes(\"crypto_box\", \"sk\", sk, nacl_raw._crypto_box_secretkeybytes());\n    var c = new Target(msg.length + nacl_raw._crypto_box_zerobytes());\n    check(\"_crypto_box\", nacl_raw._crypto_box(c.address, m, c.length, 0, na, pka, ska));\n    free_all([m, na, pka, ska]);\n    return c.extractBytes(nacl_raw._crypto_box_boxzerobytes());\n  }\n\n  function crypto_box_open(ciphertext, nonce, pk, sk) {\n    var c = injectBytes(ciphertext, nacl_raw._crypto_box_boxzerobytes());\n    var na = check_injectBytes(\"crypto_box_open\",\n                               \"nonce\", nonce, nacl_raw._crypto_box_noncebytes());\n    var pka = check_injectBytes(\"crypto_box_open\",\n                                \"pk\", pk, nacl_raw._crypto_box_publickeybytes());\n    var ska = check_injectBytes(\"crypto_box_open\",\n                                \"sk\", sk, nacl_raw._crypto_box_secretkeybytes());\n    var m = new Target(ciphertext.length + nacl_raw._crypto_box_boxzerobytes());\n    check(\"_crypto_box_open\", nacl_raw._crypto_box_open(m.address, c, m.length, 0, na, pka, ska));\n    free_all([c, na, pka, ska]);\n    return m.extractBytes(nacl_raw._crypto_box_zerobytes());\n  }\n\n  function crypto_box_precompute(pk, sk) {\n    var pka = check_injectBytes(\"crypto_box_precompute\",\n\t\t\t\t\"pk\", pk, nacl_raw._crypto_box_publickeybytes());\n    var ska = check_injectBytes(\"crypto_box_precompute\",\n\t\t\t\t\"sk\", sk, nacl_raw._crypto_box_secretkeybytes());\n    var k = new Target(nacl_raw._crypto_box_beforenmbytes());\n    check(\"_crypto_box_beforenm\",\n\t  nacl_raw._crypto_box_beforenm(k.address, pka, ska));\n    free_all([pka, ska]);\n    return {boxK: k.extractBytes()};\n  }\n\n  function crypto_box_precomputed(msg, nonce, state) {\n    var m = injectBytes(msg, nacl_raw._crypto_box_zerobytes());\n    var na = check_injectBytes(\"crypto_box_precomputed\",\n\t\t\t       \"nonce\", nonce, nacl_raw._crypto_box_noncebytes());\n    var ka = check_injectBytes(\"crypto_box_precomputed\",\n\t\t\t       \"boxK\", state.boxK, nacl_raw._crypto_box_beforenmbytes());\n    var c = new Target(msg.length + nacl_raw._crypto_box_zerobytes());\n    check(\"_crypto_box_afternm\",\n\t  nacl_raw._crypto_box_afternm(c.address, m, c.length, 0, na, ka));\n    free_all([m, na, ka]);\n    return c.extractBytes(nacl_raw._crypto_box_boxzerobytes());\n  }\n\n  function crypto_box_open_precomputed(ciphertext, nonce, state) {\n    var c = injectBytes(ciphertext, nacl_raw._crypto_box_boxzerobytes());\n    var na = check_injectBytes(\"crypto_box_open_precomputed\",\n\t\t\t       \"nonce\", nonce, nacl_raw._crypto_box_noncebytes());\n    var ka = check_injectBytes(\"crypto_box_open_precomputed\",\n\t\t\t       \"boxK\", state.boxK, nacl_raw._crypto_box_beforenmbytes());\n    var m = new Target(ciphertext.length + nacl_raw._crypto_box_boxzerobytes());\n    check(\"_crypto_box_open_afternm\",\n\t  nacl_raw._crypto_box_open_afternm(m.address, c, m.length, 0, na, ka));\n    free_all([c, na, ka]);\n    return m.extractBytes(nacl_raw._crypto_box_zerobytes());\n  }\n\n  //---------------------------------------------------------------------------\n  // Hashing\n\n  function crypto_hash(bs) {\n    var address = injectBytes(bs);\n    var hash = new Target(nacl_raw._crypto_hash_bytes());\n    check(\"_crypto_hash\", nacl_raw._crypto_hash(hash.address, address, bs.length, 0));\n    FREE(address);\n    return hash.extractBytes();\n  }\n\n  function crypto_hash_sha256(bs) {\n    var address = injectBytes(bs);\n    var hash = new Target(nacl_raw._crypto_hash_sha256_bytes());\n    check(\"_crypto_hash_sha256\",\n\t  nacl_raw._crypto_hash_sha256(hash.address, address, bs.length, 0));\n    FREE(address);\n    return hash.extractBytes();\n  }\n\n  function crypto_hash_string(s) {\n    return crypto_hash(encode_utf8(s));\n  }\n\n  //---------------------------------------------------------------------------\n  // Symmetric-key encryption\n\n  function crypto_stream_random_nonce() {\n    return random_bytes(nacl_raw._crypto_stream_noncebytes());\n  }\n\n  function crypto_stream(len, nonce, key) {\n    var na = check_injectBytes(\"crypto_stream\",\n\t\t\t       \"nonce\", nonce, nacl_raw._crypto_stream_noncebytes());\n    var ka = check_injectBytes(\"crypto_stream\",\n\t\t\t       \"key\", key, nacl_raw._crypto_stream_keybytes());\n    var out = new Target(len);\n    check(\"_crypto_stream\", nacl_raw._crypto_stream(out.address, len, 0, na, ka));\n    free_all([na, ka]);\n    return out.extractBytes();\n  }\n\n  function crypto_stream_xor(msg, nonce, key) {\n    var na = check_injectBytes(\"crypto_stream_xor\",\n\t\t\t       \"nonce\", nonce, nacl_raw._crypto_stream_noncebytes());\n    var ka = check_injectBytes(\"crypto_stream_xor\",\n\t\t\t       \"key\", key, nacl_raw._crypto_stream_keybytes());\n    var ma = injectBytes(msg);\n    var out = new Target(msg.length);\n    check(\"_crypto_stream_xor\",\n\t  nacl_raw._crypto_stream_xor(out.address, ma, msg.length, 0, na, ka));\n    free_all([na, ka, ma]);\n    return out.extractBytes();\n  }\n\n  //---------------------------------------------------------------------------\n  // One-time authentication\n\n  function crypto_onetimeauth(msg, key) {\n    var ka = check_injectBytes(\"crypto_onetimeauth\",\n\t\t\t       \"key\", key, nacl_raw._crypto_onetimeauth_keybytes());\n    var ma = injectBytes(msg);\n    var authenticator = new Target(nacl_raw._crypto_onetimeauth_bytes());\n    check(\"_crypto_onetimeauth\",\n\t  nacl_raw._crypto_onetimeauth(authenticator.address, ma, msg.length, 0, ka));\n    free_all([ka, ma]);\n    return authenticator.extractBytes();\n  }\n\n  function crypto_onetimeauth_verify(authenticator, msg, key) {\n    if (authenticator.length != nacl_raw._crypto_onetimeauth_bytes()) return false;\n    var ka = check_injectBytes(\"crypto_onetimeauth_verify\",\n\t\t\t       \"key\", key, nacl_raw._crypto_onetimeauth_keybytes());\n    var ma = injectBytes(msg);\n    var aa = injectBytes(authenticator);\n    var result = nacl_raw._crypto_onetimeauth_verify(aa, ma, msg.length, 0, ka);\n    free_all([ka, ma, aa]);\n    return (result == 0);\n  }\n\n  //---------------------------------------------------------------------------\n  // Authentication\n\n  function crypto_auth(msg, key) {\n    var ka = check_injectBytes(\"crypto_auth\", \"key\", key, nacl_raw._crypto_auth_keybytes());\n    var ma = injectBytes(msg);\n    var authenticator = new Target(nacl_raw._crypto_auth_bytes());\n    check(\"_crypto_auth\", nacl_raw._crypto_auth(authenticator.address, ma, msg.length, 0, ka));\n    free_all([ka, ma]);\n    return authenticator.extractBytes();\n  }\n\n  function crypto_auth_verify(authenticator, msg, key) {\n    if (authenticator.length != nacl_raw._crypto_auth_bytes()) return false;\n    var ka = check_injectBytes(\"crypto_auth_verify\",\n\t\t\t       \"key\", key, nacl_raw._crypto_auth_keybytes());\n    var ma = injectBytes(msg);\n    var aa = injectBytes(authenticator);\n    var result = nacl_raw._crypto_auth_verify(aa, ma, msg.length, 0, ka);\n    free_all([ka, ma, aa]);\n    return (result == 0);\n  }\n\n  //---------------------------------------------------------------------------\n  // Authenticated symmetric-key encryption\n\n  function crypto_secretbox_random_nonce() {\n    return random_bytes(nacl_raw._crypto_secretbox_noncebytes());\n  }\n\n  function crypto_secretbox(msg, nonce, key) {\n    var m = injectBytes(msg, nacl_raw._crypto_secretbox_zerobytes());\n    var na = check_injectBytes(\"crypto_secretbox\",\n\t\t\t       \"nonce\", nonce, nacl_raw._crypto_secretbox_noncebytes());\n    var ka = check_injectBytes(\"crypto_secretbox\",\n\t\t\t       \"key\", key, nacl_raw._crypto_secretbox_keybytes());\n    var c = new Target(msg.length + nacl_raw._crypto_secretbox_zerobytes());\n    check(\"_crypto_secretbox\", nacl_raw._crypto_secretbox(c.address, m, c.length, 0, na, ka));\n    free_all([m, na, ka]);\n    return c.extractBytes(nacl_raw._crypto_secretbox_boxzerobytes());\n  }\n\n  function crypto_secretbox_open(ciphertext, nonce, key) {\n    var c = injectBytes(ciphertext, nacl_raw._crypto_secretbox_boxzerobytes());\n    var na = check_injectBytes(\"crypto_secretbox_open\",\n\t\t\t       \"nonce\", nonce, nacl_raw._crypto_secretbox_noncebytes());\n    var ka = check_injectBytes(\"crypto_secretbox_open\",\n\t\t\t       \"key\", key, nacl_raw._crypto_secretbox_keybytes());\n    var m = new Target(ciphertext.length + nacl_raw._crypto_secretbox_boxzerobytes());\n    check(\"_crypto_secretbox_open\",\n\t  nacl_raw._crypto_secretbox_open(m.address, c, m.length, 0, na, ka));\n    free_all([c, na, ka]);\n    return m.extractBytes(nacl_raw._crypto_secretbox_zerobytes());\n  }\n\n  //---------------------------------------------------------------------------\n  // Boxing with ephemeral keys\n\n  function crypto_box_seal(msg, pk) {\n    var m = injectBytes(msg);\n    var pka = check_injectBytes(\"crypto_box_seal\",\n                                \"pk\", pk, nacl_raw._crypto_box_publickeybytes());\n    var c = new Target(msg.length + nacl_raw._crypto_box_sealbytes());\n    check(\"_crypto_box_seal\", nacl_raw._crypto_box_seal(c.address, m, msg.length, 0, pka));\n    free_all([m, pka]);\n    return c.extractBytes();\n  }\n\n  function crypto_box_seal_open(ciphertext, pk, sk) {\n    var c = injectBytes(ciphertext);\n    var pka = check_injectBytes(\"crypto_box_seal_open\",\n                                \"pk\", pk, nacl_raw._crypto_box_publickeybytes());\n    var ska = check_injectBytes(\"crypto_box_seal_open\",\n                                \"sk\", sk, nacl_raw._crypto_box_secretkeybytes());\n    var m = new Target(ciphertext.length - nacl_raw._crypto_box_sealbytes());\n    check(\"_crypto_box_seal_open\",\n          nacl_raw._crypto_box_seal_open(m.address, c, ciphertext.length, 0, pka, ska));\n    free_all([c, pka, ska]);\n    return m.extractBytes();\n  }\n\n  //---------------------------------------------------------------------------\n  // Signing\n\n  function crypto_sign_keypair() {\n    var pk = new Target(nacl_raw._crypto_sign_publickeybytes());\n    var sk = new Target(nacl_raw._crypto_sign_secretkeybytes());\n    check(\"_crypto_sign_keypair\", nacl_raw._crypto_sign_keypair(pk.address, sk.address));\n    return {signPk: pk.extractBytes(), signSk: sk.extractBytes()};\n  }\n\n  function crypto_sign(msg, sk) {\n    var ma = injectBytes(msg);\n    var ska = check_injectBytes(\"crypto_sign\", \"sk\", sk, nacl_raw._crypto_sign_secretkeybytes());\n    var sm = new Target(msg.length + nacl_raw._crypto_sign_bytes());\n    var smlen = new Target(8);\n    check(\"_crypto_sign\",\n\t  nacl_raw._crypto_sign(sm.address, smlen.address, ma, msg.length, 0, ska));\n    free_all([ma, ska]);\n    sm.length = nacl_raw.HEAPU32[smlen.address >> 2];\n    FREE(smlen.address);\n    return sm.extractBytes();\n  }\n\n  function crypto_sign_detached(msg, sk) {\n    // WARNING: Experimental. Works for ed25519 but not necessarily other implementations.\n    var signed_msg = crypto_sign(msg, sk);\n    return signed_msg.subarray(0, nacl_raw._crypto_sign_bytes());\n  }\n\n  function crypto_sign_open(sm, pk) {\n    var sma = injectBytes(sm);\n    var pka = check_injectBytes(\"crypto_sign_open\",\n\t\t\t\t\"pk\", pk, nacl_raw._crypto_sign_publickeybytes());\n    var m = new Target(sm.length);\n    var mlen = new Target(8);\n    if (nacl_raw._crypto_sign_open(m.address, mlen.address, sma, sm.length, 0, pka) === 0) {\n      free_all([sma, pka]);\n      m.length = nacl_raw.HEAPU32[mlen.address >> 2];\n      FREE(mlen.address);\n      return m.extractBytes();\n    } else {\n      free_all([sma, pka, m.address, mlen.address]);\n      return null;\n    }\n  }\n\n  function crypto_sign_verify_detached(detached_signature, msg, pk) {\n    // WARNING: Experimental. Works for ed25519 but not necessarily other implementations.\n    var signed_msg = new Uint8Array(detached_signature.length + msg.length);\n    signed_msg.set(detached_signature, 0);\n    signed_msg.set(msg, detached_signature.length);\n    return crypto_sign_open(signed_msg, pk) !== null;\n  }\n\n  //---------------------------------------------------------------------------\n  // Keys\n\n  function crypto_sign_seed_keypair(bs) {\n    var seeda = check_injectBytes(\"crypto_sign_seed_keypair\",\n\t\t\t\t  \"seed\", bs, nacl_raw._crypto_sign_secretkeybytes() / 2);\n    var pk = new Target(nacl_raw._crypto_sign_publickeybytes());\n    var sk = new Target(nacl_raw._crypto_sign_secretkeybytes());\n    check(\"_crypto_sign_seed_keypair\",\n\t  nacl_raw._crypto_sign_seed_keypair(pk.address, sk.address, seeda));\n    FREE(seeda);\n    return {signPk: pk.extractBytes(), signSk: sk.extractBytes()};\n  }\n\n  function crypto_box_seed_keypair(bs) {\n    var hash = new Uint8Array(crypto_hash(bs));\n    return crypto_box_keypair_from_raw_sk(hash.subarray(0,\n\t\t\t\t\t\t\tnacl_raw._crypto_box_secretkeybytes()));\n  }\n\n  function crypto_box_keypair_from_raw_sk(sk) {\n    return {boxPk: crypto_scalarmult_base(sk), boxSk: sk};\n  }\n\n  //---------------------------------------------------------------------------\n  // Scalarmult\n\n  function crypto_scalarmult(n,p) {\n    var na = check_injectBytes(\"crypto_scalarmult\", \"n\", n,\n\t\t\t       nacl_raw._crypto_scalarmult_curve25519_scalarbytes());\n    var pa = check_injectBytes(\"crypto_scalarmult\", \"p\", p,\n\t\t\t       nacl_raw._crypto_scalarmult_curve25519_bytes());\n    var q = new Target(nacl_raw._crypto_scalarmult_curve25519_bytes());\n    check(\"_crypto_scalarmult_curve25519\",\n          nacl_raw._crypto_scalarmult_curve25519(q.address, na, pa));\n    FREE(na);\n    FREE(pa);\n    return q.extractBytes();\n  }\n\n  function crypto_scalarmult_base(n) {\n    var na = check_injectBytes(\"crypto_scalarmult_base\", \"n\", n,\n\t\t\t       nacl_raw._crypto_scalarmult_curve25519_scalarbytes());\n    var q = new Target(nacl_raw._crypto_scalarmult_curve25519_bytes());\n    check(\"_crypto_scalarmult_curve25519_base\",\n          nacl_raw._crypto_scalarmult_curve25519_base(q.address, na));\n    FREE(na);\n    return q.extractBytes();\n  }\n\n  //---------------------------------------------------------------------------\n\n  exports.crypto_auth_BYTES = nacl_raw._crypto_auth_bytes();\n  exports.crypto_auth_KEYBYTES = nacl_raw._crypto_auth_keybytes();\n  exports.crypto_box_BEFORENMBYTES = nacl_raw._crypto_box_beforenmbytes();\n  exports.crypto_box_BOXZEROBYTES = nacl_raw._crypto_box_boxzerobytes();\n  exports.crypto_box_NONCEBYTES = nacl_raw._crypto_box_noncebytes();\n  exports.crypto_box_PUBLICKEYBYTES = nacl_raw._crypto_box_publickeybytes();\n  exports.crypto_box_SECRETKEYBYTES = nacl_raw._crypto_box_secretkeybytes();\n  exports.crypto_box_ZEROBYTES = nacl_raw._crypto_box_zerobytes();\n  exports.crypto_hash_BYTES = nacl_raw._crypto_hash_bytes();\n  exports.crypto_hash_sha256_BYTES = nacl_raw._crypto_hash_sha256_bytes();\n  // exports.crypto_hashblocks_BLOCKBYTES = nacl_raw._crypto_hashblocks_blockbytes();\n  // exports.crypto_hashblocks_STATEBYTES = nacl_raw._crypto_hashblocks_statebytes();\n  exports.crypto_onetimeauth_BYTES = nacl_raw._crypto_onetimeauth_bytes();\n  exports.crypto_onetimeauth_KEYBYTES = nacl_raw._crypto_onetimeauth_keybytes();\n  exports.crypto_secretbox_BOXZEROBYTES = nacl_raw._crypto_secretbox_boxzerobytes();\n  exports.crypto_secretbox_KEYBYTES = nacl_raw._crypto_secretbox_keybytes();\n  exports.crypto_secretbox_NONCEBYTES = nacl_raw._crypto_secretbox_noncebytes();\n  exports.crypto_secretbox_ZEROBYTES = nacl_raw._crypto_secretbox_zerobytes();\n  exports.crypto_sign_BYTES = nacl_raw._crypto_sign_bytes();\n  exports.crypto_sign_PUBLICKEYBYTES = nacl_raw._crypto_sign_publickeybytes();\n  exports.crypto_sign_SECRETKEYBYTES = nacl_raw._crypto_sign_secretkeybytes();\n  // exports.crypto_stream_BEFORENMBYTES = nacl_raw._crypto_stream_beforenmbytes();\n  exports.crypto_stream_KEYBYTES = nacl_raw._crypto_stream_keybytes();\n  exports.crypto_stream_NONCEBYTES = nacl_raw._crypto_stream_noncebytes();\n  exports.crypto_scalarmult_SCALARBYTES = nacl_raw._crypto_scalarmult_curve25519_scalarbytes();\n  exports.crypto_scalarmult_BYTES = nacl_raw._crypto_scalarmult_curve25519_bytes();\n\n  exports.encode_utf8 = encode_utf8;\n  exports.encode_latin1 = encode_latin1;\n  exports.decode_utf8 = decode_utf8;\n  exports.decode_latin1 = decode_latin1;\n  exports.to_hex = to_hex;\n  exports.from_hex = from_hex;\n\n  exports.random_bytes = random_bytes;\n\n  exports.crypto_box_keypair = crypto_box_keypair;\n  exports.crypto_box_random_nonce = crypto_box_random_nonce;\n  exports.crypto_box = crypto_box;\n  exports.crypto_box_open = crypto_box_open;\n  exports.crypto_box_precompute = crypto_box_precompute;\n  exports.crypto_box_precomputed = crypto_box_precomputed;\n  exports.crypto_box_open_precomputed = crypto_box_open_precomputed;\n\n  exports.crypto_stream_random_nonce = crypto_stream_random_nonce;\n  exports.crypto_stream = crypto_stream;\n  exports.crypto_stream_xor = crypto_stream_xor;\n\n  exports.crypto_onetimeauth = crypto_onetimeauth;\n  exports.crypto_onetimeauth_verify = crypto_onetimeauth_verify;\n\n  exports.crypto_auth = crypto_auth;\n  exports.crypto_auth_verify = crypto_auth_verify;\n\n  exports.crypto_secretbox_random_nonce = crypto_secretbox_random_nonce;\n  exports.crypto_secretbox = crypto_secretbox;\n  exports.crypto_secretbox_open = crypto_secretbox_open;\n\n  exports.crypto_box_seal = crypto_box_seal;\n  exports.crypto_box_seal_open = crypto_box_seal_open;\n\n  exports.crypto_sign_keypair = crypto_sign_keypair;\n  exports.crypto_sign = crypto_sign;\n  exports.crypto_sign_detached = crypto_sign_detached;\n  exports.crypto_sign_open = crypto_sign_open;\n  exports.crypto_sign_verify_detached = crypto_sign_verify_detached;\n\n  exports.crypto_hash = crypto_hash;\n  exports.crypto_hash_sha256 = crypto_hash_sha256;\n  exports.crypto_hash_string = crypto_hash_string;\n\n  exports.crypto_sign_seed_keypair = crypto_sign_seed_keypair;\n  exports.crypto_box_seed_keypair = crypto_box_seed_keypair;\n  exports.crypto_box_keypair_from_raw_sk = crypto_box_keypair_from_raw_sk;\n  // Backwards-compatibility:\n  exports.crypto_sign_keypair_from_seed = crypto_sign_seed_keypair;\n  exports.crypto_box_keypair_from_seed = crypto_box_seed_keypair;\n\n  exports.crypto_scalarmult = crypto_scalarmult;\n  exports.crypto_scalarmult_base = crypto_scalarmult_base;\n\n  return exports;\n}\n      return nacl_raw.ready.then(function () {\n        var nacl = nacl_cooked(nacl_raw);\n        nacl.nacl_raw = nacl_raw;\n        on_ready(nacl);\n        return nacl;\n      });\n    })((typeof window !== 'undefined') ? window : undefined_reference_value,\n       (typeof document !== 'undefined') ? document : undefined_reference_value);\n  }\n};\n\n// export common.js module to allow one js file for browser and node.js\nif ( true && module.exports) {\n    module.exports = nacl_factory;\n}\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/nacl.js?\n}");

/***/ }),

/***/ "../common/crypto/proof.js":
/*!*********************************!*\
  !*** ../common/crypto/proof.js ***!
  \*********************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

eval("{let DJB2 = __webpack_require__(/*! ./hashDJB2 */ \"../common/crypto/hashDJB2.js\");\n\nconst TASK_GRANULARITY = 250;\nconst DEFAULT_DIFFICULTY = 50000;\nconst CONSTANT_A = 'w1iV++8Paiz1W/JPPasdRTiHiPaZkF3L5fQBpl/EsMsAAAA=';\nconst CONSTANT_B = 'braNzUosoR/WGHdjuE3vgOzS3vAm0yeHdryKUKfqMzOZrnnxM2j0ZBtosjbG+BpuoONa0SSg0g1a';\nconst CONSTANT_C = 'H4sIALBvLloCA02OMQ4CMQwEe16xD0B8gIqKhk9YspOzyMUo8d2J35OYAgoX691Z+1YZtjkswRdB';\nconst CONSTANT_D = 'rFGlQjLECtkQ7Lt2mCc+NCV4wbqX9VJehLZIsQGVN91vP+SUxmyOAAAA';\nconst CONSTANT_E = 'y37v4RNP7wiH+kEdyYTTp/alYktUHe0gsATc9IuVhmeS4eX2/5zs4XTQ';\nconst CONSTANT_F = 'H4sIAHBsLloCAy2M0Q3CQAxD/5nCA1SMAQMwwVUXLpHSBF3SVmxPKvFn';\nconst CONSTANT_G = 'PowerToThePeople_';\n\nfunction createHash (prfx, pow) {\n  return prfx + DJB2.hash(String(CONSTANT_D + String(pow) + prfx + CONSTANT_E + String(pow).split('').reverse().join('') + CONSTANT_F));\n}\n\nfunction create (difficulty) {\n  difficulty = (typeof difficulty === 'undefined' || isNaN(difficulty) ? DEFAULT_DIFFICULTY : difficulty);\n\n  let pow = (1 + Math.random()) * difficulty; // create a number between difficulty and 2 times difficulty\n\n  pow = Math.floor(pow + (Math.floor(Math.random() * 5) * (difficulty / 5))); // pow is now a number between difficulty and 3 times difficulty\n\n  let prfx = ''; // the prefix serves as a hint for the proof\n  for (let i = 0; i < 5; i++) {\n    prfx += DJB2.hash(CONSTANT_A + i + CONSTANT_B + String(Math.random() * (Math.random() * 1000000)) + CONSTANT_C);\n  }\n  return {hash: createHash(prfx, pow), proof: DJB2.hash(CONSTANT_G + String(pow))};\n}\n\nconst executeTaskStep = (tasks, taskId, hint, difficulty, dataCallback, errorCallback, progressCallback) => () => {\n  // this process has been tasked to scan a 1/TASK_GRANULARITY part of all possible solutions\n  const task = tasks[taskId];\n  const step = task.step;\n  const maxSteps = Math.ceil(2 * difficulty / TASK_GRANULARITY); // the maximum nr of steps any process will handle\n\n  if (taskId === 0 && typeof progressCallback === 'function') {\n    progressCallback(step / (maxSteps + 1));\n  }\n\n  if (step < maxSteps) {\n    const prfx = hint.substr(0, 8 * 5);\n    const firstStep = difficulty + taskId * maxSteps;\n    const pow = firstStep + step; // create a number between difficulty and 3 times difficulty\n    const hash = createHash(prfx, pow);\n    if (hint === hash) { // the hash is found, work is done\n      for (let k = 0; k < TASK_GRANULARITY; k++) { // clear all running processes\n        if (tasks[k].interval !== null) {\n          clearInterval(tasks[k].interval); // clear this process interval\n        }\n      }\n      if (typeof dataCallback === 'function') { dataCallback(DJB2.hash(CONSTANT_G + String(pow))); }\n    } else { // the hash is not yet found, next step\n      ++task.step;\n    }\n  } else { // nr of steps exceeded. This process failed, check if all steps have failed\n    let countFailed = 0;\n    for (let k = 0; k < TASK_GRANULARITY; k++) {\n      if (tasks[k].step >= maxSteps) {\n        countFailed += 1;\n      }\n    }\n    clearInterval(task.interval); // clear this process interval\n    task.interval = null;\n    if (countFailed === TASK_GRANULARITY) { // all processes have fails\n      if (typeof errorCallback === 'function') { errorCallback('Local Proof of Work failed!'); }\n    }\n  }\n};\n\nfunction solve (hint, difficulty, dataCallback, errorCallback, progressCallback) {\n  difficulty = (typeof difficulty === 'undefined' || isNaN(difficulty) ? DEFAULT_DIFFICULTY : difficulty);\n\n  const tasks = [];\n\n  for (let taskId = 0; taskId < TASK_GRANULARITY; taskId++) { // subdivide the work into tasks\n    tasks[taskId] = {\n      step: 0,\n      interval: setInterval(executeTaskStep(tasks, taskId, hint, difficulty, dataCallback, errorCallback, progressCallback), 100)\n    };\n  }\n}\n\nexports.create = create;\nexports.solve = solve;\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/proof.js?\n}");

/***/ }),

/***/ "../common/crypto/sha256.js":
/*!**********************************!*\
  !*** ../common/crypto/sha256.js ***!
  \**********************************/
/***/ (function(module, exports, __webpack_require__) {

eval("{var __WEBPACK_AMD_DEFINE_RESULT__;!function(t,e){var i={};!function(t){\"use strict\";function e(t,e,i,r,n){for(var h,f,a,o,u,d,p,c,b,g,l,y,v;n>=64;){for(h=e[0],f=e[1],a=e[2],o=e[3],u=e[4],d=e[5],p=e[6],c=e[7],g=0;g<16;g++)l=r+4*g,t[g]=(255&i[l])<<24|(255&i[l+1])<<16|(255&i[l+2])<<8|255&i[l+3];for(g=16;g<64;g++)b=t[g-2],y=(b>>>17|b<<15)^(b>>>19|b<<13)^b>>>10,b=t[g-15],v=(b>>>7|b<<25)^(b>>>18|b<<14)^b>>>3,t[g]=(y+t[g-7]|0)+(v+t[g-16]|0);for(g=0;g<64;g++)y=(((u>>>6|u<<26)^(u>>>11|u<<21)^(u>>>25|u<<7))+(u&d^~u&p)|0)+(c+(s[g]+t[g]|0)|0)|0,v=((h>>>2|h<<30)^(h>>>13|h<<19)^(h>>>22|h<<10))+(h&f^h&a^f&a)|0,c=p,p=d,d=u,u=o+y|0,o=a,a=f,f=h,h=y+v|0;e[0]+=h,e[1]+=f,e[2]+=a,e[3]+=o,e[4]+=u,e[5]+=d,e[6]+=p,e[7]+=c,r+=64,n-=64}return r}function i(t){var e=(new r).update(t),i=e.digest();return e.clean(),i}t.__esModule=!0,t.digestLength=32,t.blockSize=64;var s=new Uint32Array([1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298]);var r=function(){function i(){this.digestLength=t.digestLength,this.blockSize=t.blockSize,this.state=new Int32Array(8),this.temp=new Int32Array(64),this.buffer=new Uint8Array(128),this.bufferLength=0,this.bytesHashed=0,this.finished=!1,this.reset()}return i.prototype.reset=function(){return this.state[0]=1779033703,this.state[1]=3144134277,this.state[2]=1013904242,this.state[3]=2773480762,this.state[4]=1359893119,this.state[5]=2600822924,this.state[6]=528734635,this.state[7]=1541459225,this.bufferLength=0,this.bytesHashed=0,this.finished=!1,this},i.prototype.clean=function(){for(t=0;t<this.buffer.length;t++)this.buffer[t]=0;for(var t=0;t<this.temp.length;t++)this.temp[t]=0;this.reset()},i.prototype.update=function(t,i){if(void 0===i&&(i=t.length),this.finished)throw new Error(\"SHA256: can't update because hash was finished.\");var s=0;if(this.bytesHashed+=i,this.bufferLength>0){for(;this.bufferLength<64&&i>0;)this.buffer[this.bufferLength++]=t[s++],i--;64===this.bufferLength&&(e(this.temp,this.state,this.buffer,0,64),this.bufferLength=0)}for(i>=64&&(s=e(this.temp,this.state,t,s,i),i%=64);i>0;)this.buffer[this.bufferLength++]=t[s++],i--;return this},i.prototype.finish=function(t){if(!this.finished){var i=this.bytesHashed,s=this.bufferLength,r=i/536870912|0,n=i<<3,h=i%64<56?64:128;this.buffer[s]=128;for(f=s+1;f<h-8;f++)this.buffer[f]=0;this.buffer[h-8]=r>>>24&255,this.buffer[h-7]=r>>>16&255,this.buffer[h-6]=r>>>8&255,this.buffer[h-5]=r>>>0&255,this.buffer[h-4]=n>>>24&255,this.buffer[h-3]=n>>>16&255,this.buffer[h-2]=n>>>8&255,this.buffer[h-1]=n>>>0&255,e(this.temp,this.state,this.buffer,0,h),this.finished=!0}for(var f=0;f<8;f++)t[4*f+0]=this.state[f]>>>24&255,t[4*f+1]=this.state[f]>>>16&255,t[4*f+2]=this.state[f]>>>8&255,t[4*f+3]=this.state[f]>>>0&255;return this},i.prototype.digest=function(){var t=new Uint8Array(this.digestLength);return this.finish(t),t},i.prototype._saveState=function(t){for(var e=0;e<this.state.length;e++)t[e]=this.state[e]},i.prototype._restoreState=function(t,e){for(var i=0;i<this.state.length;i++)this.state[i]=t[i];this.bytesHashed=e,this.finished=!1,this.bufferLength=0},i}();t.Hash=r;var n=function(){function t(t){this.inner=new r,this.outer=new r,this.blockSize=this.inner.blockSize,this.digestLength=this.inner.digestLength;var e=new Uint8Array(this.blockSize);if(t.length>this.blockSize)(new r).update(t).finish(e).clean();else for(i=0;i<t.length;i++)e[i]=t[i];for(i=0;i<e.length;i++)e[i]^=54;this.inner.update(e);for(i=0;i<e.length;i++)e[i]^=106;this.outer.update(e),this.istate=new Uint32Array(8),this.ostate=new Uint32Array(8),this.inner._saveState(this.istate),this.outer._saveState(this.ostate);for(var i=0;i<e.length;i++)e[i]=0}return t.prototype.reset=function(){return this.inner._restoreState(this.istate,this.inner.blockSize),this.outer._restoreState(this.ostate,this.outer.blockSize),this},t.prototype.clean=function(){for(var t=0;t<this.istate.length;t++)this.ostate[t]=this.istate[t]=0;this.inner.clean(),this.outer.clean()},t.prototype.update=function(t){return this.inner.update(t),this},t.prototype.finish=function(t){return this.outer.finished?this.outer.finish(t):(this.inner.finish(t),this.outer.update(t,this.digestLength).finish(t)),this},t.prototype.digest=function(){var t=new Uint8Array(this.digestLength);return this.finish(t),t},t}();t.HMAC=n;t.hash=i,t.default=i;t.hmac=function(t,e){var i=new n(t).update(e),s=i.digest();return i.clean(),s};t.pbkdf2=function(t,e,i,s){for(var r=new n(t),h=r.digestLength,f=new Uint8Array(4),a=new Uint8Array(h),o=new Uint8Array(h),u=new Uint8Array(s),d=0;d*h<s;d++){var p=d+1;f[0]=p>>>24&255,f[1]=p>>>16&255,f[2]=p>>>8&255,f[3]=p>>>0&255,r.reset(),r.update(e),r.update(f),r.finish(o);for(b=0;b<h;b++)a[b]=o[b];for(b=2;b<=i;b++){r.reset(),r.update(o).finish(o);for(var c=0;c<h;c++)a[c]^=o[c]}for(var b=0;b<h&&d*h+b<s;b++)u[d*h+b]=a[b]}for(d=0;d<h;d++)a[d]=o[d]=0;for(d=0;d<4;d++)f[d]=0;return r.clean(),u}}(i);var s=i.default;for(var r in i)s[r]=i[r]; true&&\"object\"==typeof module.exports?module.exports=s: true?!(__WEBPACK_AMD_DEFINE_RESULT__ = (function(){return s}).call(exports, __webpack_require__, exports, module),\n\t\t__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)):0}(this);\n\n\n//# sourceURL=webpack://hybrix-jslib/../common/crypto/sha256.js?\n}");

/***/ }),

/***/ "../common/crypto/sjcl.js":
/*!********************************!*\
  !*** ../common/crypto/sjcl.js ***!
  \********************************/
/***/ ((module) => {

eval("{var sjcl;\n\nfunction q (a) { throw a; } var t = void 0, u = !1; sjcl = {cipher: {}, hash: {}, keyexchange: {}, mode: {}, misc: {}, codec: {}, exception: {corrupt: function (a) { this.toString = function () { return 'CORRUPT: ' + this.message; }; this.message = a; }, invalid: function (a) { this.toString = function () { return 'INVALID: ' + this.message; }; this.message = a; }, bug: function (a) { this.toString = function () { return 'BUG: ' + this.message; }; this.message = a; }, notReady: function (a) { this.toString = function () { return 'NOT READY: ' + this.message; }; this.message = a; }}};\n true && module.exports && (module.exports = sjcl);\nsjcl.cipher.aes = function (a) {\n  this.j[0][0][0] || this.D(); var b, c, d, e, f = this.j[0][4], g = this.j[1]; b = a.length; var h = 1; b !== 4 && (b !== 6 && b !== 8) && q(new sjcl.exception.invalid('invalid aes key size')); this.a = [d = a.slice(0), e = []]; for (a = b; a < 4 * b + 28; a++) { c = d[a - 1]; if (a % b === 0 || b === 8 && a % b === 4)c = f[c >>> 24] << 24 ^ f[c >> 16 & 255] << 16 ^ f[c >> 8 & 255] << 8 ^ f[c & 255], a % b === 0 && (c = c << 8 ^ c >>> 24 ^ h << 24, h = h << 1 ^ 283 * (h >> 7)); d[a] = d[a - b] ^ c; } for (b = 0; a; b++, a--) {\n    c = d[b & 3 ? a : a - 4], e[b] = a <= 4 || b < 4 ? c : g[0][f[c >>> 24]] ^ g[1][f[c >> 16 & 255]] ^ g[2][f[c >> 8 & 255]] ^ g[3][f[c &\n255]];\n  }\n};\nsjcl.cipher.aes.prototype = {encrypt: function (a) { return y(this, a, 0); },\n  decrypt: function (a) { return y(this, a, 1); },\n  j: [[[], [], [], [], []], [[], [], [], [], []]],\n  D: function () {\n    var a = this.j[0], b = this.j[1], c = a[4], d = b[4], e, f, g, h = [], l = [], k, n, m, p; for (e = 0; e < 0x100; e++)l[(h[e] = e << 1 ^ 283 * (e >> 7)) ^ e] = e; for (f = g = 0; !c[f]; f ^= k || 1, g = l[g] || 1) { m = g ^ g << 1 ^ g << 2 ^ g << 3 ^ g << 4; m = m >> 8 ^ m & 255 ^ 99; c[f] = m; d[m] = f; n = h[e = h[k = h[f]]]; p = 0x1010101 * n ^ 0x10001 * e ^ 0x101 * k ^ 0x1010100 * f; n = 0x101 * h[m] ^ 0x1010100 * m; for (e = 0; e < 4; e++)a[e][f] = n = n << 24 ^ n >>> 8, b[e][m] = p = p << 24 ^ p >>> 8; } for (e =\n0; e < 5; e++)a[e] = a[e].slice(0), b[e] = b[e].slice(0);\n  }};\nfunction y (a, b, c) {\n  b.length !== 4 && q(new sjcl.exception.invalid('invalid aes block size')); var d = a.a[c], e = b[0] ^ d[0], f = b[c ? 3 : 1] ^ d[1], g = b[2] ^ d[2]; b = b[c ? 1 : 3] ^ d[3]; var h, l, k, n = d.length / 4 - 2, m, p = 4, s = [0, 0, 0, 0]; h = a.j[c]; a = h[0]; var r = h[1], v = h[2], w = h[3], x = h[4]; for (m = 0; m < n; m++)h = a[e >>> 24] ^ r[f >> 16 & 255] ^ v[g >> 8 & 255] ^ w[b & 255] ^ d[p], l = a[f >>> 24] ^ r[g >> 16 & 255] ^ v[b >> 8 & 255] ^ w[e & 255] ^ d[p + 1], k = a[g >>> 24] ^ r[b >> 16 & 255] ^ v[e >> 8 & 255] ^ w[f & 255] ^ d[p + 2], b = a[b >>> 24] ^ r[e >> 16 & 255] ^ v[f >> 8 & 255] ^ w[g & 255] ^ d[p + 3], p += 4, e = h, f = l, g = k; for (m = 0; m <\n4; m++)s[c ? 3 & -m : m] = x[e >>> 24] << 24 ^ x[f >> 16 & 255] << 16 ^ x[g >> 8 & 255] << 8 ^ x[b & 255] ^ d[p++], h = e, e = f, f = g, g = b, b = h; return s;\n}\nsjcl.bitArray = {bitSlice: function (a, b, c) { a = sjcl.bitArray.O(a.slice(b / 32), 32 - (b & 31)).slice(1); return c === t ? a : sjcl.bitArray.clamp(a, c - b); },\n  extract: function (a, b, c) { var d = Math.floor(-b - c & 31); return ((b + c - 1 ^ b) & -32 ? a[b / 32 | 0] << 32 - d ^ a[b / 32 + 1 | 0] >>> d : a[b / 32 | 0] >>> d) & (1 << c) - 1; },\n  concat: function (a, b) { if (a.length === 0 || b.length === 0) return a.concat(b); var c = a[a.length - 1], d = sjcl.bitArray.getPartial(c); return d === 32 ? a.concat(b) : sjcl.bitArray.O(b, d, c | 0, a.slice(0, a.l