exports.createLink = createLink;
exports.call = call;

const WSS_MAX_RETRIES = 3;

const ports = {
  ws: 80,
  wss: 443
}
exports.ports = ports;

const WebSocket = require('ws');

function getStackID(data, args) {
  const ID = args.identifier || 'id';
  return dataID = data[ID] ? 
                    data[ID] : 
                    args.hasOwnProperty('data') && args.data[ID] ?
                      args.data[ID] : 0; 
  /* Note: In some cases, there is no identifier in the object. 
   *       Then an argument 'identifier' may be given to set an identification key.
   * NB: NOT WORKING WITH FCC NODE! -> data.command ? data.command , BECAUSE command RETURNED OFTEN DIFFERS FROM command ISSUED
   */
}

function call (link, host, qpath, args, method, dataCallback, errorCallback, count) {
  if (link.readyState) {
    if (typeof args.data !== 'object' || args.data === null) errorCallback('Expected an object.');
    else {
      const stackID = getStackID(args.data, args);
      link.stack[stackID] = dataCallback;
    }
    try {
      link.send(JSON.stringify(args.data));
    } catch (e) {
      errorCallback('link not ready');
    }
  } else if ((count || 0) < WSS_MAX_RETRIES) { // retry if link not yet ready
    setTimeout(() => {
      call(link, host, qpath, args, method, dataCallback, errorCallback, (count || 0) + 1);
    }, 300);
  } else errorCallback('link not ready');
}

function createLink (APIrequest, host, APIhosts, dataCallback, errorCallback, passOptions) {
  const options = passOptions || {};
  const link = new WebSocket(host, options);
  link.stack = {};
  link
    .on('open', () => {
      global.hybrixd.logger(['info', 'apiQueue'], 'Websocket ' + host + ' opened');
      dataCallback(link);
    })
    .on('close', () => {
      global.hybrixd.logger(['info', 'apiQueue'], 'Websocket ' + host + ' closed');
      delete (APIhosts[host]);
    })
    .on('error', (error) => {
      global.hybrixd.logger(['error', 'apiQueue'], 'Websocket ' + host + ' : Error ' + error);
    })
    .on('message', message => {
      try {
        const data = JSON.parse(message);
        if (typeof data === 'object' && data !== null && data !== {}) {
          const stackID = getStackID(data, APIrequest.args);
          if (link.stack.hasOwnProperty(stackID)) {
            link.stack[stackID](data);
            delete link.stack[stackID];
          }
        }
      } catch (e) {
        global.hybrixd.logger(['warn', 'apiQueue'], 'Websocket ' + host + ' : Parsing Error ' + e);
      }
    });
}
