const cache = require('../cache');
const conf = require('../conf/conf');
const qrtzProcess = require('../scheduler/process');
const DJB2 = require('../../common/crypto/hashDJB2'); // fast DJB2 hashing
const DEFAULT_CACHE_VALUE = conf.get('cache.defaulttime');

function getFreshOrCachedData (recipe, request, xpath) {
  // TODO: a weird bug blocks unspent process to finish (stuck at 60%); it needs 'factor' added to noCaching to work
  const noCaching = ['deterministic','unspent','factor','push'].includes(xpath[2]);
  const cacheVal = typeof recipe.cache !== 'undefined' ? recipe.cache : DEFAULT_CACHE_VALUE;
  const cacheIdx = DJB2.hash(request.sessionID + xpath.join('/')); // perhaps double to avoid possible collisions? +DJB2.hash(xpath.join('_'));
  const cacheResult = cache.get(cacheIdx, cacheVal);
  const result = getFreshOrCachedData_(cacheResult, cacheIdx, recipe, request, xpath);
  if (!noCaching && result && !result.noCache && !result.error) { // if there's no error, use the new value
    cache.add(cacheIdx, result);
  }
  return result;
}

function getFreshDataWithoutCaching (recipe, request, xpath) {
  const result = moduleExecOrError(recipe, xpath, request.sessionID, request.data);
  return Object.assign(result, {noCache: true});
}

function getFreshOrCachedData_ (cacheResult, cacheIdx, recipe, request, xpath) {
  return cacheResult && cacheResult.fresh
    ? cacheResult.data
    : getExecDataorCached(cacheIdx, cacheResult, recipe, request, xpath);
}

function getExecDataorCached (cacheIdx, cacheResult, recipe, request, xpath) {
  let result = moduleExecOrError(recipe, xpath, request.sessionID, request.data); // we do a fresh call
  return !(result && result.error) || !cacheResult
    ? result
    : cacheResult.data;
}

function moduleExecOrError (recipe, xpath, sessionID, data) {
  const module = recipe.module || 'quartz';
  const moduleExists = module === 'quartz' || global.hybrixd.module.hasOwnProperty(module);
  return !moduleExists
    ? {error: 1, data: 'Module "' + module + '" not found or disfunctional!'}
    : activateModuleExec(data, recipe, xpath, sessionID);
}

function activateModuleExec (data, recipe, path, sessionID) {
  const command = path.slice(2);
  return qrtzProcess.create({data, recipe, path, command, sessionID}); // init new process
}

module.exports = {
  getFreshOrCachedData,
  getFreshDataWithoutCaching
};
