// asset.js -> handle asset calls
//
// (c) 2016 Internet of Coins project - Joachim de Koning
//

const {getFreshOrCachedData} = require('../cache');

function process (request, xpath) {
  const dataOrError = xpath.length === 1
    ? assetList(global.hybrixd.asset)
    : retrieveDataOrError(global.hybrixd.asset, request, xpath);

  return dataOrError;
}

function retrieveDataOrError (assets, request, xpath) {
  const symbol = xpath[1];
  const recipeDoesNotExist = !assets.hasOwnProperty(symbol);

  return recipeDoesNotExist
    ? mkErrorObj(symbol)
    : retrieveExecDataOrError(symbol, assets, request, xpath);
}

function retrieveExecDataOrError (symbol, assets, request, xpath) {
  const recipe = assets[symbol];
  return getFreshOrCachedData(recipe, request, xpath);
}

// asset specific functions start here
function assetList (assets) {
  const asset = Object
    .keys(assets)
    .sort();

  return {
    error: 0,
    data: asset
  };
}

function mkErrorObj (symbol) {
  return {
    error: 404,
    data: 'Asset "' + symbol + '" not found!'
  };
}

exports.process = process;
