/**
   * Count the amount of entries a list, string or object has.
   * @category Array/String
   * @param {String|Array|Object} [input] - String, array, object or variable.
   * @param {Boolean} [isVariable=false] - Specifies if the input is a variable.
   * @example
   * size                    // input: 'abcde', result: 5
   * size ['a','b',5]        // result: 3
   * size {'a':1,'b':2}      // result: 2
   * size someVariable true  // result: 2
   */
exports.size = data => async function (p, xdataOrIsVariable, isVariable) {
  let ydata = typeof xdataOrIsVariable !== 'undefined' && xdataOrIsVariable !== true ? xdataOrIsVariable : data;
  const testIsVariable = typeof isVariable !== 'undefined' && isVariable === true ? true : (typeof xdataOrIsVariable !== 'undefined' && xdataOrIsVariable === true ? true : false);
  if (testIsVariable) {
    const peekVariable = ydata;
    const peekResult = p.peek(peekVariable);
    if (peekResult.e > 0) p.fail(`size: Cannot peek variable '${peekVariable}'`);
    ydata = peekResult.v;
  }
  let result = 0;
  if (ydata === null) {
    result = 0;
  } else if (typeof ydata === 'object') {
    if (ydata.constructor === 'Array') {
      result = ydata.length;
    } else {
      result = Object.keys(ydata).length;
    }
  } else if (typeof ydata === 'string') {
    result = ydata.length;
  }
  p.next(result);
};

exports.tests = {
  size: [
    "data '1234'",
    'size',
    'flow 4 1 2',
    'done $OK',
    'fail'
  ],
  size1: [
    "size '1234'",
    'flow 4 1 2',
    'done $OK',
    'fail'
  ],
  size2: [
    "poke testVar '1234'",
    'size testVar true',
    'flow 4 1 2',
    'done $OK',
    'fail'
  ]  
};
