// (C) 2025 Internet of Coins / hybrix / Joachim de Koning
// hybrixd module - storage/module.js
// Module to provide storage

// IDEAS:
//  -->>> return ipfs.files.add(Buffer.from(content), { onlyHash: true })

// required libraries in this context
const storageLib = require('../../common/storage-fileBased');

async function cron (proc) {
  //storage.autoClean();
  //proc.warn(' >>> autoclean in progress');
  proc.done();
}

async function load (proc, data) {
  const key = getKey(proc, data);
  const readFile = typeof data === 'object' && data !== null ? data.readFile : false;
  if (key) {
    storageLib.load({key, type: 'path'}, (filePath) => {
      proc.mime('file:data');
      proc.done(filePath);
    }, proc.fail);
  } else proc.fail(`Key to load is void`);
}

async function save (proc, data) {
  const keyInput = proc.command[1] ? proc.command[1].split(':') : false;
  const value = typeof data === 'string' ? data : (proc.command[2] ? proc.command.slice(2).join('/') : false);
  if (keyInput) {
    if (typeof value === 'string') {
      if (value) {
        const [key, publicKey, signature] = [keyInput[0],keyInput[1],keyInput[2]];
        storageLib.save({key, value, publicKey, signature}, (saveResult) => {
          synchronize(proc, key);
          proc.done(saveResult);
        }, proc.fail);
      } else proc.fail(`Cannot save to ${keyInput} -> value data is empty`);
    } else proc.fail(`Cannot save to ${keyInput} -> value data must be of type string`);
  } else proc.fail(`Key to save is void`);
}

async function burn (proc, data) {
  const keyInput = getKey(proc, data);
  const [key, publicKey, signature] = [keyInput[0],keyInput[1],keyInput[2]];
  if (key) storageLib.burn({key, publicKey, signature}, proc.done, proc.fail);
  else proc.fail(`Key to burn is void`);
}

async function seek (proc, data) {
  const key = getKey(proc, data);
  if (key) storageLib.seek({key}, proc.done, proc.fail);
  else proc.fail(`Key to seek is void`);
}

async function meta (proc, data) {
  const key = getKey(proc, data);
  if (key) storageLib.meta({key}, proc.done, proc.fail);
  else proc.fail(`Key to meta is void`);
}

async function list (proc, data) {
  const key = getKey(proc, data);
  if (key) storageLib.list({key}, proc.done, proc.fail);
  else proc.fail(`Key to list is void`);
}

async function setHops (proc, data) {
  storageLib.setHops({key: data.key, value: data.value}, proc.done, proc.fail);
}

function getKey (proc, data) {
  return proc.command && proc.command[1]
              ? proc.command[1].split(':')[0]
              : typeof data === 'object' && data !== null && typeof data.key === 'string'
                ? data.key.split(':')[0]
                : false;
}

async function synchronize (proc, key) {
  const synchronize = proc.peek('enabled::synchronize');
  if (synchronize) {
    try {
      const syncResult = await proc.call(`synchronize::queue/${key}`);
      if (syncResult.error) proc.warn(`Sync failed for ${key} -> ${syncResult.data}`);
    } catch (e) {
      proc.warn(`Sync failed for ${key} -> ${JSON.stringify(e)}`);
    }
  }
}

/* DEPRECATED
async function hash (proc, data) {
  const key = proc.command && proc.command[1] ? proc.command[1] : data.key;
  storageLib.hash({key}, proc.done, proc.fail);
}

async function work (proc, data) {
  const key = proc.command && proc.command[1] ? proc.command[1] : data.key;
  const pow = proc.command && proc.command[2] ? proc.command[2] : data.pow;
  storageLib.provideProof({key, pow}, proc.done, proc.fail);
}
*/

// exports
exports.cron = cron;
exports.load = load;
exports.save = save;
exports.burn = burn;
exports.seek = seek;
exports.meta = meta;
exports.list = list;
exports.setHops = setHops;
