/**
 * @memberof module:compressed-json
 * @function bind
 * @param {Object} config
 * @param {string[]} [config.reservedKeys=[]] - reservedKeys to bind
 * @param {string[]} [config.reservedValues=[]] - reservedValues to bind
 */
'use strict';

import compress from './compress';
import decompress from './decompress';
/** @lends module:compressed-json.bind */


function bind() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _config$reservedKeys = config.reservedKeys,
      reservedKeys = _config$reservedKeys === void 0 ? [] : _config$reservedKeys,
      _config$reservedValue = config.reservedValues,
      reservedValues = _config$reservedValue === void 0 ? [] : _config$reservedValue;

  var boundCompress = function boundCompress(src) {
    return compress(src, {
      reservedKeys: reservedKeys,
      reservedValues: reservedValues
    });
  };

  boundCompress.toString = function (compressed) {
    return JSON.stringify(boundCompress(compressed));
  };

  var boundDecompress = function boundDecompress(src) {
    return decompress(src, {
      reservedKeys: reservedKeys,
      reservedValues: reservedValues
    });
  };

  boundDecompress.fromString = function (compressedString) {
    return boundDecompress(JSON.parse(compressedString));
  };

  return {
    compress: boundCompress,
    decompress: boundDecompress
  };
}

export default bind;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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