/**
 * @memberof module:compressed-json
 * @function compress
 * @param {Object} data
 * @param {Object} [options={}] - Optional settings
 */
'use strict';

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

import stringConverter from './converters/stringConverter';
/** @lends module:compressed-json.compress */


function compress(src) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _options$reservedKeys = options.reservedKeys,
      reservedKeys = _options$reservedKeys === void 0 ? [] : _options$reservedKeys,
      _options$reservedValu = options.reservedValues,
      reservedValues = _options$reservedValu === void 0 ? [] : _options$reservedValu;
  var MIN_SHARE_STRING_LENGTH = 4;
  var MAX_SHARE_STRING_LENGTH = 512;
  var keysDict = {};
  var knownValuesDict = {};
  var pointers = [];
  var keys = [];
  var wrappers = {};

  var shortKeyFor = function shortKeyFor(key) {
    if (key in keysDict) {
      return keysDict[key];
    }

    var keyIndex = keys.length;
    var shortKey = keyIndex.toString(36);
    keysDict[key] = shortKey;
    keys.push(key);
    return shortKey;
  };

  reservedKeys.forEach(function (reservedKey) {
    return shortKeyFor(reservedKey);
  });

  var stringValueFor = function stringValueFor(value, keyPath) {
    var canBeShared = MIN_SHARE_STRING_LENGTH <= value.length && value.length <= MAX_SHARE_STRING_LENGTH;

    if (canBeShared) {
      if (value in knownValuesDict) {
        if (knownValuesDict[value].shared) {
          return knownValuesDict[value].pointer;
        }

        var index = pointers.length;
        pointers.push(value);
        var pointer = stringConverter.toPointer(index);
        knownValuesDict[value].pointer = pointer;
        knownValuesDict[value].shared = true;
        return pointer;
      }
    }

    knownValuesDict[value] = {
      keyPath: keyPath,
      shared: false,
      pointer: null
    };
    return stringConverter.toEscaped(value);
  };

  reservedValues.forEach(function (reservedValue) {
    return stringValueFor(reservedValue);
  });

  var convert = function convert(values) {
    var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
        _ref$keyPath = _ref.keyPath,
        keyPath = _ref$keyPath === void 0 ? '' : _ref$keyPath;

    if (Array.isArray(values)) {
      var arr = values.map(function (v, i) {
        return convert(v, {
          keyPath: [keyPath, i].join('/')
        });
      });
      wrappers[keyPath] = arr;
      return arr;
    }

    if (values === null) {
      return null;
    }

    var type = _typeof(values);

    switch (type) {
      case 'function':
        return null;

      case 'object':
        {
          if (values instanceof Date) {
            return values.toJSON();
          }

          var compressed = {};

          var _keys = Object.keys(values);

          for (var _i = 0, _keys2 = _keys; _i < _keys2.length; _i++) {
            var key = _keys2[_i];
            var value = values[key];
            var shortKey = shortKeyFor(key);
            compressed[shortKey] = convert(value, {
              keyPath: [keyPath, shortKey].join('/')
            });
          }

          wrappers[keyPath] = compressed;
          return compressed;
        }

      case 'string':
        return stringValueFor(values, keyPath);

      default:
        return values;
    }
  };

  var converted = convert(src);

  for (var _i2 = 0, _Object$values = Object.values(knownValuesDict); _i2 < _Object$values.length; _i2++) {
    var _Object$values$_i = _Object$values[_i2],
        pointer = _Object$values$_i.pointer,
        shared = _Object$values$_i.shared,
        keyPath = _Object$values$_i.keyPath;

    if (shared && keyPath) {
      var _keys3 = keyPath.split('/');

      var lastKey = _keys3.pop();

      var wrapper = wrappers[_keys3.join('/')];

      wrapper[lastKey] = pointer;
    }
  }

  var K = keys.slice(reservedKeys.length);
  var P = pointers.slice(reservedValues.length);
  return _objectSpread({}, K.length > 0 ? {
    K: K
  } : {}, {}, P.length > 0 ? {
    P: P
  } : {}, {
    _: converted
  });
}

compress.toString = function compressToString(data) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var compressed = compress(data, options);
  return JSON.stringify(compressed);
};

export default compress;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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